<?php

return [
    'goodTitleTag' => 'Great! the page title tag is in recommended range.',
    'emptyPageTitle' => 'The title tag is missing or empty.',
    'resourcesCount' => ':count Resources',
    'secondCount' => ':count Seconds',
    'seoReportForDomain' => 'SEO Report for :domain',
    'secured' => 'Secured',
    'Not Secured' => 'Not Secured',
    'text' => 'Text',
    'length' => 'Length',
    'numberCharacters' => ':count characters',
    'title' => 'Title',
    'security' => 'Security',
    'speedOptimizations' => 'Speed optimizations',
    'titleExplainer' => 'Your webpage\'s meta title is an HTML tag that defines the title of your page. This tag displays your page title in search engine results, at the top of a user\'s browser, and also when your page is bookmarked in a list of favorites. A concise, descriptive title tag that accurately reflects your page\'s topic is important for ranking well in search engines.',
    'metaDescription' => 'Meta Description',
    'metaDescrptionExplainer' => 'The meta description of your webpage is an HTML tag that provides a concise and accurate summary of the page\'s content. Search engines use this information to understand the topic of the page and may also display the meta description in search results. Well-written and appealing meta descriptions can improve both your search rankings and the likelihood of users clicking on your page.',
    'perfectTitle' => 'The webpage is using a good title tag.',
    'titleErrorLength' => 'The webpage is using a title tag with a length of <strong>:length characters.</strong> While there\'s no target number of characters, titles should be descriptive and concise. We recommend using a title with a length between <strong>:min - :max characters</strong> in order to fit Google Search results that have a 600-pixel limit.',
    'titleErrorMissing' => 'The webpage is <strong>not using a title tag</strong>. Titles should be descriptive and concise. We recommend using a title with a length between <strong>:min - :max characters</strong>.',
    'titleErrorTags' => 'The webpage has <strong>:count title tags</strong>. Having multiple title tags on the page may cause search engines to display the "wrong" one, which may result in lower engagement or CTR from search results and may also have an impact on SEO.',
    'perfectDescription' => 'The webpage is using a good meta description tag.',
    'descriptionErrorLength' => 'This webpage has a meta description tag that is <strong>:length characters</strong> long. It is recommended to use well-written and engaging meta descriptions with a length between <strong>:min and :max characters (including spaces)</strong>.',
    'descriptionErrorMissing' => 'This webpage is <strong>missing a meta description tag</strong>! It is important to include this tag in order to provide a brief summary of the page for search engines. A well-written and enticing meta description can also increase the number of clicks on your site in search engine results.',
    'descriptionErrorTags' => 'The webpage has <strong>:count description tags</strong>. Having multiple description on the page may cause search engines to display the "wrong" one, which may result in lower engagement or CTR from search results and may also have an impact on SEO.',
    'googleSearchPreview' => 'Google Search Results Preview Test',
    'desktopVersion' => 'Desktop version',
    'mobileVersion' => 'Mobile version',
    'mostCommonKeywords' => 'Most Common Keywords',
    'mostCommonKeywordsHelp' => 'It is unlikely that there is a specific keyword density that is optimal for search engines (as their algorithms have evolved beyond using keyword density as a ranking factor). However, it can be helpful to see which keywords are most commonly used on your page and whether they accurately reflect the intended topic. More importantly, the keywords on your page should be used naturally and in grammatically correct copy.',
    'keywordsCount' => 'The page has :count relevant keywords',
    'mostCommonKeywordsExplainer' => 'Examine the most common keywords on your page and how often they are used. This can provide a quick overview of the keywords and topics that search engines may associate with your webpage.',
    '404error' => 'Custom 404 Error Pages',
    '404errorExplainer' => 'This SEO test will determine if your website has a custom 404 error page. By creating a custom 404 error page, you can improve the user experience for your website by letting users know that only a specific page is missing or broken (not the entire site). You can also provide helpful links, the opportunity to report bugs, and potentially track the source of broken links on your site.',
    'hasNotFound404' => 'This website <strong>does not have a custom 404 error page</strong>! Default 404 error pages result in a poor user experience - they can mislead users into thinking the entire site is down or broken, increase the likelihood that they will leave the website, and appear unprofessional. It is recommended to have a custom 404 error page to improve the user experience for your website by letting users know that only a specific page is missing or broken (not the entire site). You can also provide helpful links, the opportunity to report bugs, and potentially track the source of broken links.',
    'hasFound404' => 'This website <strong>has a custom 404 error page</strong>. It is recommended to have a custom 404 error page to improve the user experience for your website by letting users know that only a specific page is missing or broken (not the entire site). You can also provide helpful links, the opportunity to report bugs, and potentially track the source of broken links.',
    'imageAltText' => 'Image Alt Text',
    'imagesAltMissingCount' => 'This webpage is using :count "img" tags with :missing tags empty or missing "alt" attribute!',
    'imagesAltPassed' => 'All "img" tags from this webpage have the required "alt" attribute.',
    'imageAltTextExplainer' => 'Check if the images on your webpage have alt attributes. If an image cannot be displayed (for example, because of a broken image source or slow internet connection), the alt attribute provides alternative information. Including relevant keywords and text in the alt attribute can help both users and search engines better understand the subject of the image.',
    'inpageLinks' => 'In-page Links',
    'internalLinksCount' => 'This webpage has :count internal links',
    'externalLinks' => 'External Links',
    'internalLinks' => 'Internal Links',
    'internalLinksExplainer' => 'To ensure that search engines are able to crawl all links on the webpage, it is important to minimize the number of in-page links on the page.',
    'language' => 'Language',
    'languageDeclared' => 'This webpage has language declared',
    'languageNotDeclared' => 'This webpage has not language declared',
    'languageExplainer' => 'The lang attribute helps search engines understand the language of the content on the webpage, and enables browsers to suggest translations for it. By specifying the language of the webpage, the attribute helps improve its accessibility for users who may not speak the same language.',
    'performance' => 'Performance',
    'domSize' => 'Dom Size',
    'domPassed' => '    The Document Object Model (DOM) of this webpage has <strong>:size nodes</strong> which is less than the recommended value of :max nodes.',
    'domFailed' => 'The Document Object Model (DOM) of this webpage has <strong>:size nodes</strong> which is greater than the recommended value of :max nodes! A large DOM size negatively affects site performance and increases the page load time.',
    'domExplainer' => "This test will check the size of the DOM tree. When a web page is loaded, the browser creates a Document Object Model (DOM) of the page. All the tags in the HTML document are called nodes and the sum of them is translated as the DOM size. A large DOM tree will likely increase memory usage, cause longer style calculations, and may produce slower layout rendering.",
    'testPassedCount' => ':count tests passed',
    'overview' => 'Overview',
    'highIssue' => ':count High Issues',
    'lowIssues' => ':count Low Issues',
    'mediumIssues' => ':count Medium Issues',
    'commonSeoIssues' => 'Common SEO Issues',
    'loadTime' => 'Load time',
    'pageSize' => 'Page size',
    'HTTPSEncryption' => 'HTTPS encryption',
    'generateNewReport' => 'Generate New Report',
    'seo' => 'Seo',
    'reportGeneratedDate' => 'Report generated on :date.',
    'imageWithoutAlt' => "Images without ALT tag",
    'imageWithAlt' => "Images with ALT tag",
    'loadTime' => "Load Time",
    'loadtimePassedCount' => "The loading speed of this webpage, as measured is approximately <strong>:time seconds</strong>, which is faster than the average loading time of :recommended seconds.",
    'loadtimeFailedCount' => "The loading time of this webpage is around <strong>:time seconds</strong> and is greater than the average loading speed which is :recommended seconds!",
    'loadTimeExplainer' => "Check your website's loading speed. Page speed is an important factors in search engine rankings and overall site success. Pages that take longer than :recommended seconds to load can lose up to 50% of users. Faster webpages result in higher traffic, better conversions and increased sales over slower loading pages.",
    'pageSize' => "Page Size",
    'pagesizePassedCount' => "This webpage's HTML is smaller than the average, clocking in at <strong>:size</strong> as opposed to the <strong>typical :max.</strong> Websites that load quickly provide a superior user experience, and tend to have higher conversion rates and better search engine rankings.",
    'pagesizeFailedCount' => "This webpage's HTML is larger than the average, measuring at <strong>:size</strong> as compared to the <strong>standard :max.</strong> This can result in slower loading speeds, potentially causing visitors to leave and resulting in decreased revenue. To decrease the HTML size, techniques such as HTML compression, utilizing CSS layouts, using external style sheets, and moving javascript to separate files are effective methods.",
    'pagesizeExplainer' => "Examine the size of the HTML code on your webpage. The HTML size refers to the amount of code on the page and does not take into account the size of any images, external javascripts, or external CSS files.",
    'httpRequestExplainer' => "An HTTP request is a message sent by a web browser (or other client) to a web server, asking the server to retrieve or send a specific resource. When you visit a webpage, your browser sends an HTTP request to the server to retrieve the webpage's HTML, CSS, JavaScript, and other resources that make up the page. These resources can include things like images, videos, and other files.",
    'httpRequestFailedCount' => "This webpage has <strong>:requests http requests</strong>, which is more than the recommended :max http requests. A higher number of http requests can slow down page loading and negatively impact user experience!",
    'httpRequestPassedCount' => "This webpage has <strong>:requests http requests</strong>. A higher number of http requests results in a user's browser needing to request a large number of objects from the server, which will ultimately slow down the loading of your webpage.",
    'httpRequests' => "Http Requests",
    'imageFormats' => "Modern Image Format",
    'imageFormatsFailedCount' => "This webpage is serving <strong>:count images</strong> that aren't in modern format!",
    'imageFormatsPassedCount' => "This webpage is using images in a modern format.",
    'imageFormatExplainer' => 'This test will check if the webpage is serving images in modern formats. Image formats like <a href="https://jpeg.org/jpeg2000/" target="_blank" rel="noopener noreferrer">JPEG 2000</a>, <a href="https://jpeg.org/jpegxr/" target="_blank" rel="noopener noreferrer">JPEG XR</a>, and <a href="https://developers.google.com/speed/webp" target="_blank" rel="noopener noreferrer">WebP</a> often provide better compression than PNG or JPEG, which means faster downloads and less data consumption for users.',
    'imagesWithoutWebp' => "Images",
    'textCompression' => "HTML Compression/GZIP",
    'textCompressionPassed' => "This webpage is successfully compressed using <strong>:compression compression</strong> on your code. The HTML code is compressed from <strong>:from</strong> to <strong>:to</strong> (<strong>:percentage% size savings</strong>). This helps ensure a faster loading webpage and improved user experience.",
    'textCompressionFailed' => "This webpage is not compressed. The compressed HTML code could save up to 85% of download size. This helps ensure a faster loading webpage and improved user experience.",
    'textCompressionExplainer' => "Check if your website is using HTML compression. HTML compression plays an important role in improving website speed by finding similar strings within a text file and replacing them temporarily to reduce overall file size.",
    'deferJS' => "Defer Javascript",
    'deferJsExplainer' => '"Deferring" JavaScript means to hold off on loading or executing a JavaScript file until after the initial page load. By doing this, the browser can load and display the important content on the page first, and then load and execute the JavaScript afterwards. This can improve the initial load time of the page, and provide a better experience for the user, since they can start interacting with the page sooner. By deferring javascript the browser will also download it after the main content and so it will have less impact on load time.',
    'deferJSFailed' => "This webpage has <strong>:count JavaScript</strong> resources without the defer attribute.",
    'deferJSPassed' => "All JavaScript resources on this webpage have the defer attribute set.",
    'deferJsText' => "JavaScripts without defer",
    'plainEmail' => "Plaintext Email",
    'plainEmailFailed' => "This webpage include <strong>:count email</strong> addresses in plaintext.",
    'plainEmailPassed' => "This webpage does not include email addresses in plaintext.",
    'plainEmailExplainer' => "Check your website for any plaintext email addresses. When an email address is visible in a public setting, it is susceptible to being gathered by software used by mass emailers, a process commonly known as email address harvesting. This can lead to spam harvesters reading through your website's pages and collecting plaintext email addresses, which will then be added to bulk marketing databases and result in an increase of spam messages in your inbox. To combat this, there are various techniques for obscuring email addresses.",
    'httpsEncryption' => "SSL Checker and HTTPS Test",
    'sslTestPassed' => "This website is successfully using HTTPS, a secure communication protocol over the Internet. The SSL is issued by <strong>:issuer</strong> and will expire on <strong>:expire_at</strong>.",
    'sslTestFailed' => "This webpage does not have SSL and not using secure communication protocol over the Internet",
    'selfSigned' => "Self Signed",
    'httpsEncryptionExplainer' => 'Check if your website is using HTTPS, a secure protocol for sending/receiving data over the Internet. Using HTTPS indicates that an additional encryption/authentication layer was added between client and server. HTTPS should be used by any site that collects sensitive customer data such as credit card information. Even for sites that do not collect such data, <a href="https://webmasters.googleblog.com/2014/08/https-as-ranking-signal.html" target="_blank">switching to https helps users</a> by improving privacy and overall security. Google is increasingly using https as a positive ranking factor.',
    'mixedContent' => "Mixed Content (HTTP over HTTPS)",
    'mixedContentNo' => "This webpage does not use mixed content - both the initial HTML and all other resources are loaded over HTTPS.",
    'mixedContentYes' => "This webpage use mixed content",
    'mixedContentExplainer' => "This will verify that all elements are obtained through a secure HTTPS connection. When the main HTML is retrieved through a secure HTTPS connection but other resources such as images, videos, stylesheets and scripts are acquired via an insecure HTTP connection it is referred to as mixed content. This is so called mixed content because both HTTP and HTTPS elements are used to display the same page even though the original request was secure via HTTPS. Browsers may block mixed content, so resolving this problem ensures that your content displays correctly.",
    'serverAndSecurity' => "Server and Security",
    'favicon' => "Favicon",
    'faviconNo' => "This website does not appears to have a favicon.",
    'faviconYes' => "This website appears to have a favicon.",
    'faviconExplainer' => "The favicon is the icon that is being displayed in the browser's tab, when the webpage is being bookmarked, and sometimes even in search engine results.",
    'serverSignature' => "Server Signature",
    'serverNo' => "The server signature is off for this webpage.",
    'serverYes' => "The server signature is on for this webpage! Turning off the server signature is generally a good idea from a security standpoint.",
    'serverSigExplainer' => "Check if your server's signature is ON. A server signature is the public identity of your web server and contains sensitive information that could be used to exploit any known vulnerability. Turning your server signature OFF is considered a good security practice to avoid disclosure of what software versions you are running.",
    'coLinks' => "Unsafe Cross-Origin Links ",
    'coLinksPassed' => 'This webpage is not using <strong>target="_blank"</strong> links without <strong>rel="noopener"</strong> or <strong>rel="noreferrer"</strong> attribute.',
    'coLinksFailed' => 'This webpage is using target="_blank" <strong>:count links</strong> without rel="noopener" or rel="noreferrer" attribute, which can expose it to performance and security issues!',
    'coLinksExplainer' => 'This test will check if all links to external pages that have the target="_blank" attribute also have the rel="noopener" or rel="noreferrer" attribute. When you link to an external site using the target="_blank" attribute, security and performance issues arise:<ul><li>The external pages you link to may run on the same process as your page. If the other page is running a lot of JavaScript, your page\'s performance may suffer.</li><li>The other page can access your window object with the window.opener property. This may allow the other page to redirect your page to a malicious URL.</li></ul>Adding rel="noopener" or rel="noreferrer" to your target="_blank" links avoids these issues.',
    'advance' => "Advance",
    'socialMediaMetaTags' => 'Social Media Meta Tags',
    'socialMediaMetaTagsPassed' => 'This webpage is using social media meta tags.',
    'socialMediaMetaTagsFailed' => 'This webpage is not using social media meta tags.',
    'socialMediaMetaTagsExplainer' => 'This test will check if the analyzed webpage is using social media meta tags. While this type of meta tags don\'t affect what people see when they visit the webpage, they exist to provide information about it to search engines and social media platforms. Also, when a link is shared, both Facebook and Twitter will scrape the associated webpage and read its meta tags to display the appropriate information. Thus, social media meta tags will help to amplify your webpage\'s content, will improve brand visibility and will help to generate website traffic.',
    'structuredData' => "Structured Data",
    'structuredDataFailed' => "This webpage doesn't take the advantages of HTML Microdata or JSON-LD specifications in order to use structured data! View Google's guide for getting started with structured data.",
    'structuredDataPassed' => "This webpage doesn't take the advantages of HTML Microdata or JSON-LD specifications in order to use structured data! View Google's guide for getting started with structured data.",
    'structuredDataExplainer' => "Check if your webpage is using structured data markup. Search engines use structured data to better understand the content of your webpage and to create rich snippets in search results (which helps increase click-through rate to your site).",
    'openGraph' => "Open Graph",
    'twitter' => "Twitter",
    'schema' => "Schema.org",
    'viewPort' => "Meta Viewport",
    'hasViewPort' => "This webpage is using a viewport meta tag.",
    'hasNotviewPort' => "This webpage is not using a viewport meta tag.",
    'viewPortExplainer' => "The following checks if a viewport meta tag is being used on the webpage. This tag is crucial for responsive web design. In the absence of this tag, mobile devices will display the pages at the default desktop screen width and then scale them down, making them hard to read. By setting the viewport meta tag, it enables you to adjust the width and scaling of the viewport, allowing it to display correctly on all devices.",
    'charset' => "Charset Declaration",
    'hasCharset' => "This webpage has a character encoding declaration",
    'hasNotCharset' => "This webpage doesn't have a character encoding declaration",
    'charsetExplainer' => 'This test will check if the webpage has a character encoding declaration ("charset"). If the server doesn\'t specify a character encoding format when it sends an HTML file, the browser may display some characters incorrectly to users. Google recommends using the Unicode/UTF-8 character set when possible.',
    'sitemaps' => "Sitemaps",
    'hasSitemap' => "This website has a sitemap file.",
    'hasNotSitemap' => "No sitemap found.",
    'sitemapExplainer' => "Check if the website has a sitemap. A sitemap is important as it lists all the web pages of the site and let search engine crawlers to crawl the website more intelligently. A sitemap also provides valuable metadata for each webpage.",
    'socialLinks' => "Social Media Presence",
    'hasSocial' => "The webpage have social media links.",
    'hasNotSocial' => "No social media links found.",
    'socialExplainer' => "Social media presence is becoming increasingly important as a ranking factor for search engines to validate a website's trustworthiness and authority.",
    'contentlength' => "Content Length Test",
    'contentlengthCount' => "The webpage have <strong>:count words</strong> on page.",
    'contentlengthExplainer' => "The content length represents the number of words found on the webpage. The webpage should contain a decent amount of words.",
    'inlineCss' => "Inline CSS",
    'hasNotValidCss' => "This webpage does not contain inline CSS",
    'hasValidCss' => "This webpage is using inline CSS styles!",
    'inlineCssExplainer' => "Check your webpage HTML tags for inline CSS properties. Inline CSS property are added by using the style attribute within specific HTML tags. Inline CSS properties unnecessarily increase page size, and can be moved to an external CSS stylesheet. Removing inline CSS properties can improve page loading time and make site maintenance easier.",
    'http2' => "HTTP2 Test",
    'http2Passed' => "This webpage is using the HTTP/2 protocol.",
    'http2Failed' => "This webpage is not using the HTTP/2 protocol!",
    'http2Explainer' => "Checks if the webpage and all resources are served over HTTP/2. As the first major HTTP protocol update since 1997, HTTP/2 offers several key improvements such as increased speed and security.",
    'hsts' => "HSTS",
    'hstsPassed' => "This webpage is using the <strong>Strict-Transport-Security</strong> header.",
    'hstsFailed' => "This webpage is not using the <strong>Strict-Transport-Security</strong> header! This is a security header that was created as a way to force the browser to use secure connections when a site is running over HTTPS.",
    'hstsExplainer' => "This test will check if your webpage is using the Strict-Transport-Security header.",
    'depHtml' => "Deprecated HTML Tags",
    'depHtmlPassed' => "This webpage is not using deprecated html tags",
    'depHtmlFailed' => "This webpage is using :count deprecated html tags",
    'depHtmlExplainer' => 'Check if your webpage is using old, deprecated <a href="http://www.w3schools.com/tags/default.asp" target="_blank" rel="noopener noreferrer">HTML tags</a>. These tags will eventually lose browser support and your web pages may render incorrectly as browsers drop support for these tags.',
    'overview' => "Overview",
    'keywordUsageTest' => "Keywords Usage",
    'description' => "Description",
    'headings' => "Headings",
    'headingsExplainer' => "Check if your webpage is using any H1 and H2 HTML header tags. These tags are not visible to users but can help search engines understand and support the overall theme or purpose of the page. The H1 tag represents the most important heading, such as the title of the page or blog post. The H2 tag represents the second most important headings on the webpage, like subheadings.",
    'hasHeadingsTag' => "This webpage has heading tags.",
    'noHeadingsTag' => "The webpage does not have any H1 headings! These headings are useful for indicating the main topics of the page to search engines. Although they are not as crucial as good meta titles and descriptions, H1 headings can still help clarify the topic of the page for search engines.",
    'keyword' => "Keyword",
    'keywordUsageTestExplainer' => "This will analyze the webpage in question and determine if the keywords that are most commonly associated with the website or topic being discussed are present in the title, description, and headings of the webpage. This is important because search engines like Google use these elements to understand the content and relevance of a webpage, and a webpage that includes relevant keywords in these elements is more likely to rank well in search engine results. Additionally, having relevant keywords in these elements can also help attract more visitors to the website, as the keywords will be more likely to match what users are searching for.",
    'keywordUsageTestLong' => "Long Tail Keywords Usage",
    'keywordUsageTestLongExplainer' => "This analysis will evaluate the webpage by searching for the long tail keywords that are most frequently associated with the website or topic at hand in the webpage's title, description, and headings. This examination is crucial as search engines like Google take into account these elements to gauge the webpage's content and pertinence, thus a webpage that incorporates relevant keywords in these elements is more likely to have higher search engine rankings. Furthermore, incorporating relevant keywords in these elements can also help boost website traffic as it will make it more likely for the keywords to match what users are searching for when searching.",
    'inlineCSsHelp' => "The style attribute contains CSS style rules that are applied to the element. Inline CSS code unnecessarily increases the webpage's size, and can be moved in an external CSS file.",
    'doctype' => "Doctype",
    'doctypePassed' => "This webpage has a doctype declaration.",
    'doctypeFailed' => "This webpage has not doctype declaration.",
    'canonical' => "URL Canonicalization",
    'canonicalPassed' => "This webpage has valid canonical link",
    'canonicalFailed' => "This webpage has not canonical link",
    'nestedTables' => "Nested Tables",
    'nestedTablesPassed' => "This webpage is not using nested tables. This speeds up page loading time and optimizes the user experience.",
    'nestedTablesFailed' => "This webpage is using nested tables. This slows up page loading time and optimizes the user experience.",
    'framesets' => "Framesets",
    'framesetsPassed' => "This webpage does not use frames.",
    'framesetsFailed' => "This webpage uses frames.",
    'has_robots_txt' => "Robots.txt",
    'robotsTxtPassed' => 'This website has a "robots.txt" file.',
    'robotsTxtFailed' => 'This website lacks a "robots.txt" file. This file can protect private content from appearing online, save bandwidth, and lower load time on your server. A missing "robots.txt" file also generates additional errors in your apache log whenever robots request one.',
    'nofollow' => "Nofollow Tag",
    'nofollowPassed' => "This webpage is not using the nofollow meta tag!",
    'nofollowFailed' => "This webpage is using the nofollow meta tag!",
    'nofollowLinks' => "Nofollow Links",
    'noindex' => "NoIndex Tag",
    'noindexPassed' => "This webpage does not use the noindex meta tag. This means that it can be indexed by search engines.",
    'noindexFailed' => "This webpage use the noindex meta tag. This means that it cannot be indexed by search engines.",
    'spfRecord' => "SPF Records",
    'spfRecordPassed' => "This DNS server is using an SPF record.",
    'spfRecordFailed' => "This DNS server is not using an SPF record.",
    'redirects' => "URL Redirects",
    'redirectsPassed' => "This URL doesn't have any redirects (which could potentially cause site indexation issues and site loading delays).",
    'redirectsFailed' => "This URL performed redirects! While redirects are typically not advisable (as they can affect search engine indexing issues and adversely affect site loading time), one redirect may be acceptable, particularly if the URL is redirecting from a non-www version to its www version, or vice-versa",
    'analytics' => "Google Analytics",
    'analyticsPassed' => "This webpage is using Google Analytics.",
    'analyticsFailed' => "This webpage is not using Google Analytics.",
    'is_disallowed' => "Disallow Directive",
    'isdisallowedPassed' => "Your robots.txt file includes a disallow command which instructs search engines to avoid certain parts of your website! You are advised to confirm if access to these resources or pages are intended to be blocked (e.g., if they contain internal-only content or sensitive information)",
    'isdisallowedFailed' => "Your robots.txt file does not includes a disallow command which instructs search engines to avoid certain parts of your website!",
    'friendly' => "SEO Friendly URL",
    'friendlyPassed' => "All links from this webpage are SEO friendly.",
    'friendlyFailed' => "This webpage inclues some links that are not SEO friendly.",
    'unfriendlyUrl' => "SEO unfriendly URL",
    'outOf100'=> "Out of 100",
    'disallowedRules' => "Disallowed Rules",
    'disallowedNoRobot' => "This website lacks a \"robots.txt\" file. This file can protect private content from appearing online, save bandwidth, and lower load on your server. A missing \"robots.txt\" file also generates additional errors in your apache log whenever robots request one.",
    //to do rephrase
    'keywordUsageDoctypeExplainer' => "Check for doctype declaration. A document type declaration, or DOCTYPE, defines which version of (X)HTML your webpage is using. Proper doctype declaration assists with proper page rendering and functioning of web documents in compliant browsers.",
    'keywordUsageCanonicalExplainer' => "Test your site for potential URL canonicalization issues. Canonicalization describes how a site can use slightly different URLs for the same page (e.g., if http://www.example.com and http://example.com displays the same page but do not resolve to the same URL). If this happens, search engines may be unsure about which URL is the correct one to index",
    'keywordUsagenestedTablesExplainer' => "Check if this site contains nested tables. A nested table is an HTML table containing another table inside it. Use of nested tables can slow down page rendering in the user's browser.",
    'keywordUsageframesetsExplainer' => "Check if your page is using frames, which divide your browser window into multiple sections where each section can load separate HTML documents. Frames create problems for both users (e.g., by creating unexepected behavior with printing functions or use of the back-button) and search engine robots (by complicating the crawling process). Avoid use of frames when possible.",
    'keywordUsagerobotsTxtExplainer' => "Check if your website is using a robots.txt file. When search engine robots crawl a website, they typically first access a site's robots.txt file. Robots.txt tells Googlebot and other crawlers what is and is not allowed to be crawled on your site.",
    'keywordUsagenofollowExplainer' => "Check if your webpage is using the robots meta tag or the X-Robots-Tag HTTP header to instruct search engines not to follow the links on your page. Outgoing links marked with this tag will tell search engines not to follow or crawl that particular link. Google recommends that nofollow tags are used for paid advertisements on your site and links to pages that have not been vetted as trusted sites (e.g., links posted by users of your site)",
    'keywordUsagenoindexExplainer' => "Check if your webpage is using the robots meta tag or the X-Robots-Tag HTTP header to instruct search engines not to show your site in search results pages.",
    'multiCollapsespfRecordExplainer' => "Check if your DNS records contains an SPF record. SPF (Sender Policy Framework) records allow email systems to verify if a given mail server has been authorized to send mail on behalf of your domain. Creating an SPF record increases email delivery rates by reducing the likelihood of your email being marked as spam.",
    'multiCollapseanalyticsExplainer' => "Check if your website is connected with Google Analytics. Google Analytics is a popular, free website analysis tool that helps provide insights about your site's traffic and demographics.",
    'multiCollapseredirectsExplainer' => "Check how many redirects your URL will perform to resolve to the final destination URL. Redirects often cause search engine indexing issues and can also lead to some minor loading delays. Google recommends removing or keeping redirects to a minimum.",
    'multiCollapseisdisallowedExplainer' => "Check if your robots.txt file is instructing search engine crawlers to avoid parts of your website. The disallow directive is used in robots.txt to tell search engines not to crawl and index a file, page, or directory.",
    'multiCollapsefriendlyExplainer' => "Check if your webpage URLs are SEO friendly. In order for links to be SEO friendly, they should contain keywords relevant to the page's topic, and contain no spaces, underscores or other characters. You should avoid the use of parameters when possible, as they make URLs less inviting for users to click or share. Google's suggestions for URL structure specify using hyphens or dashes (-) rather than underscores (_). Unlike underscores, Google treats hyphens as separators between words in a URL.",


];
