import{g as yt}from"./_commonjsHelpers-725317a4.js";var ft={exports:{}};/*!
 * jsoneditor.js
 *
 * @brief
 * JSONEditor is a web-based tool to view, edit, format, and validate JSON.
 * It has various modes such as a tree editor, a code editor, and a plain text
 * editor.
 *
 * Supported browsers: Chrome, Firefox, Safari, Opera, Internet Explorer 8+
 *
 * @license
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 *
 * Copyright (c) 2011-2023 Jos de Jong, http://jsoneditoronline.org
 *
 * @author  Jos de Jong, <wjosdejong@gmail.com>
 * @version 9.10.5
 * @date    2023-12-21
 */(function(Ct,It){(function(Ye,at){Ct.exports=at()})(self,function(){return at={897:function(le,m,D){D.d(m,{x:function(){return Y}});var U=D(2602),k=D(9791),H=D(7907);function j(G){return(j=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(N){return typeof N}:function(N){return N&&typeof Symbol=="function"&&N.constructor===Symbol&&N!==Symbol.prototype?"symbol":typeof N})(G)}function z(G,N){for(var A=0;A<N.length;A++){var f=N[A];f.enumerable=f.enumerable||!1,f.configurable=!0,"value"in f&&(f.writable=!0),Object.defineProperty(G,function(R){return R=function(y,C){if(j(y)!=="object"||y===null)return y;var d=y[Symbol.toPrimitive];if(d===void 0)return(C==="string"?String:Number)(y);if(d=d.call(y,C||"default"),j(d)!=="object")return d;throw new TypeError("@@toPrimitive must return a primitive value.")}(R,"string"),j(R)==="symbol"?R:String(R)}(f.key),f)}}var Y=function(){function G(f,C){if(!(this instanceof G))throw new TypeError("Cannot call a class as a function");this.dom={};var y=this,h=this.dom,C=(this.anchor=void 0,this.items=f,this.eventListeners={},this.selection=void 0,this.onClose=C?C.close:void 0,this.limitHeight=!!C&&C.limitHeight,document.createElement("div")),d=(C.className="jsoneditor-contextmenu-root",h.root=C,document.createElement("div")),C=(d.className="jsoneditor-contextmenu",h.menu=d,C.appendChild(d),document.createElement("ul")),d=(C.className="jsoneditor-menu",d.appendChild(C),h.list=C,h.items=[],document.createElement("button")),h=(d.type="button",h.focusButton=d,document.createElement("li"));h.style.overflow="hidden",h.style.height="0",h.appendChild(d),C.appendChild(h),function l(n,o,i){i.forEach(function(a){var r,e,t,s,c,p;a.type==="separator"?((c=document.createElement("div")).className="jsoneditor-separator",(e=document.createElement("li")).appendChild(c),n.appendChild(e)):(r={},c=document.createElement("li"),n.appendChild(c),(e=document.createElement("button")).type="button",e.className=a.className,r.button=e,a.title&&(e.title=a.title),a.click&&(e.onclick=function(g){g.preventDefault(),y.hide(),a.click()}),c.appendChild(e),a.submenu?((s=document.createElement("div")).className="jsoneditor-icon",e.appendChild(s),(s=document.createElement("div")).className="jsoneditor-text"+(a.click?"":" jsoneditor-right-margin"),s.appendChild(document.createTextNode(a.text)),e.appendChild(s),(t=a.click?(e.className+=" jsoneditor-default",(s=document.createElement("button")).type="button",(r.buttonExpand=s).className="jsoneditor-expand",(p=document.createElement("div")).className="jsoneditor-expand",s.appendChild(p),c.appendChild(s),a.submenuTitle&&(s.title=a.submenuTitle),s):((p=document.createElement("div")).className="jsoneditor-expand",e.appendChild(p),e)).onclick=function(g){g.preventDefault(),y._onExpandItem(r),t.focus()},r.subItems=s=[],p=document.createElement("ul"),(r.ul=p).className="jsoneditor-menu",p.style.height="0",c.appendChild(p),l(p,s,a.submenu)):((c=document.createElement("div")).className="jsoneditor-icon",e.appendChild(c),(p=document.createElement("div")).className="jsoneditor-text",p.appendChild(document.createTextNode((0,H.Iu)(a.text))),e.appendChild(p)),o.push(r))})}(C,this.dom.items,f),this.maxHeight=0,f.forEach(function(l){l=24*(f.length+(l.submenu?l.submenu.length:0)),y.maxHeight=Math.max(y.maxHeight,l)})}var N,A;return N=G,(A=[{key:"_getVisibleButtons",value:function(){var f=[],R=this;return this.dom.items.forEach(function(y){f.push(y.button),y.buttonExpand&&f.push(y.buttonExpand),y.subItems&&y===R.expandedItem&&y.subItems.forEach(function(C){f.push(C.button),C.buttonExpand&&f.push(C.buttonExpand)})}),f}},{key:"show",value:function(f,o,y){this.hide();var C=!0,h=f.parentNode,d=f.getBoundingClientRect(),h=h.getBoundingClientRect(),l=o.getBoundingClientRect(),n=this,o=(this.dom.absoluteAnchor=(0,U.w)(f,o,function(){n.hide()}),d.bottom+this.maxHeight<l.bottom||d.top-this.maxHeight>l.top&&(C=!1),y?0:d.top-h.top);C?(y=f.offsetHeight,this.dom.menu.style.left="0",this.dom.menu.style.top=o+y+"px",this.dom.menu.style.bottom=""):(this.dom.menu.style.left="0",this.dom.menu.style.top="",this.dom.menu.style.bottom="0px"),this.limitHeight&&(h=C?l.bottom-d.bottom-10:d.top-l.top-10,this.dom.list.style.maxHeight=h+"px",this.dom.list.style.overflowY="auto"),this.dom.absoluteAnchor.appendChild(this.dom.root),this.selection=(0,k.getSelection)(),this.anchor=f,setTimeout(function(){n.dom.focusButton.focus()},0),G.visibleMenu&&G.visibleMenu.hide(),G.visibleMenu=this}},{key:"hide",value:function(){this.dom.absoluteAnchor&&(this.dom.absoluteAnchor.destroy(),delete this.dom.absoluteAnchor),this.dom.root.parentNode&&(this.dom.root.parentNode.removeChild(this.dom.root),this.onClose)&&this.onClose(),G.visibleMenu===this&&(G.visibleMenu=void 0)}},{key:"_onExpandItem",value:function(f){var R,y=this,C=f===this.expandedItem,d=this.expandedItem;d&&(d.ul.style.height="0",d.ul.style.padding="",setTimeout(function(){y.expandedItem!==d&&(d.ul.style.display="",k.removeClassName)(d.ul.parentNode,"jsoneditor-selected")},300),this.expandedItem=void 0),C||((R=f.ul).style.display="block",R.clientHeight,setTimeout(function(){if(y.expandedItem===f){for(var h=0,l=0;l<R.childNodes.length;l++)h+=R.childNodes[l].clientHeight;R.style.height=h+"px",R.style.padding="5px 10px"}},0),(0,k.addClassName)(R.parentNode,"jsoneditor-selected"),this.expandedItem=f)}},{key:"_onKeyDown",value:function(f){var R,y,C,d,h=f.target,l=f.which,n=!1;l===27?(this.selection&&(0,k.setSelection)(this.selection),this.anchor&&this.anchor.focus(),this.hide(),n=!0):l===9?f.shiftKey?(y=(R=this._getVisibleButtons()).indexOf(h))===0&&(R[R.length-1].focus(),n=!0):(y=(R=this._getVisibleButtons()).indexOf(h))===R.length-1&&(R[0].focus(),n=!0):l===37?(h.className==="jsoneditor-expand"&&(y=(R=this._getVisibleButtons()).indexOf(h),C=R[y-1])&&C.focus(),n=!0):l===38?(y=(R=this._getVisibleButtons()).indexOf(h),(C=(C=(C=R[y-1])&&C.className==="jsoneditor-expand"?R[y-2]:C)||R[R.length-1])&&C.focus(),n=!0):l===39?(y=(R=this._getVisibleButtons()).indexOf(h),(d=R[y+1])&&d.className==="jsoneditor-expand"&&d.focus(),n=!0):l===40&&(y=(R=this._getVisibleButtons()).indexOf(h),(d=(d=(d=R[y+1])&&d.className==="jsoneditor-expand"?R[y+2]:d)||R[0])&&(d.focus(),n=!0),n=!0),n&&(f.stopPropagation(),f.preventDefault())}}])&&z(N.prototype,A),Object.defineProperty(N,"prototype",{writable:!1}),G}();Y.visibleMenu=void 0},6436:function(le,m,D){function U(j){return(U=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(z){return typeof z}:function(z){return z&&typeof Symbol=="function"&&z.constructor===Symbol&&z!==Symbol.prototype?"symbol":typeof z})(j)}function k(j,z){for(var Y=0;Y<z.length;Y++){var G=z[Y];G.enumerable=G.enumerable||!1,G.configurable=!0,"value"in G&&(G.writable=!0),Object.defineProperty(j,function(N){return N=function(A,f){if(U(A)!=="object"||A===null)return A;var R=A[Symbol.toPrimitive];if(R===void 0)return(f==="string"?String:Number)(A);if(R=R.call(A,f||"default"),U(R)!=="object")return R;throw new TypeError("@@toPrimitive must return a primitive value.")}(N,"string"),U(N)==="symbol"?N:String(N)}(G.key),G)}}D.d(m,{Q:function(){return H}});var H=function(){function j(N){if(!(this instanceof j))throw new TypeError("Cannot call a class as a function");this.errorTableVisible=N.errorTableVisible,this.onToggleVisibility=N.onToggleVisibility,this.onFocusLine=N.onFocusLine||function(){},this.onChangeHeight=N.onChangeHeight,this.dom={};var N=document.createElement("div"),A=(N.className="jsoneditor-validation-errors-container",this.dom.validationErrorsContainer=N,document.createElement("div")),N=(A.style.display="none",A.className="jsoneditor-additional-errors fadein",A.textContent="Scroll for more ▿",this.dom.additionalErrorsIndication=A,N.appendChild(A),document.createElement("span")),A=(N.className="jsoneditor-validation-error-icon",N.style.display="none",this.dom.validationErrorIcon=N,document.createElement("span"));A.className="jsoneditor-validation-error-count",A.style.display="none",this.dom.validationErrorCount=A,this.dom.parseErrorIndication=document.createElement("span"),this.dom.parseErrorIndication.className="jsoneditor-parse-error-icon",this.dom.parseErrorIndication.style.display="none"}var z,Y;return z=j,(Y=[{key:"getErrorTable",value:function(){return this.dom.validationErrorsContainer}},{key:"getErrorCounter",value:function(){return this.dom.validationErrorCount}},{key:"getWarningIcon",value:function(){return this.dom.validationErrorIcon}},{key:"getErrorIcon",value:function(){return this.dom.parseErrorIndication}},{key:"toggleTableVisibility",value:function(){this.errorTableVisible=!this.errorTableVisible,this.onToggleVisibility(this.errorTableVisible)}},{key:"setErrors",value:function(G,N){var A,f,R=this,y=(this.dom.validationErrors&&(this.dom.validationErrors.parentNode.removeChild(this.dom.validationErrors),this.dom.validationErrors=null,this.dom.additionalErrorsIndication.style.display="none"),this.errorTableVisible&&0<G.length?((y=document.createElement("div")).className="jsoneditor-validation-errors",(f=document.createElement("table")).className="jsoneditor-text-errors",y.appendChild(f),A=document.createElement("tbody"),f.appendChild(A),G.forEach(function(C){isNaN(C.line)?C.dataPath&&(h=N.find(function(o){return o.path===C.dataPath}))&&(d=h.line+1):d=C.line;var d,h=document.createElement("tr"),l=(h.className=isNaN(d)?"":"jump-to-line",C.type==="error"?h.className+=" parse-error":h.className+=" validation-error",document.createElement("td")),n=document.createElement("button"),n=(n.className="jsoneditor-schema-error",l.appendChild(n),h.appendChild(l),document.createElement("td"));n.style="white-space: nowrap;",n.textContent=isNaN(d)?"":"Ln "+d,h.appendChild(n),typeof C=="string"?((l=document.createElement("td")).colSpan=2,(n=document.createElement("pre")).appendChild(document.createTextNode(C)),l.appendChild(n),h.appendChild(l)):((n=document.createElement("td")).appendChild(document.createTextNode(C.dataPath||"")),h.appendChild(n),l=document.createElement("td"),(n=document.createElement("pre")).appendChild(document.createTextNode(C.message.replace(/<br>/gi,`
`))),l.appendChild(n),h.appendChild(l)),h.onclick=function(){R.onFocusLine(d)},A.appendChild(h)}),this.dom.validationErrors=y,this.dom.validationErrorsContainer.appendChild(y),this.dom.additionalErrorsIndication.title=G.length+" errors total",this.dom.validationErrorsContainer.clientHeight<this.dom.validationErrorsContainer.scrollHeight?(this.dom.additionalErrorsIndication.style.display="block",this.dom.validationErrorsContainer.onscroll=function(){R.dom.additionalErrorsIndication.style.display=0<R.dom.validationErrorsContainer.clientHeight&&R.dom.validationErrorsContainer.scrollTop===0?"block":"none"}):this.dom.validationErrorsContainer.onscroll=void 0,f=this.dom.validationErrorsContainer.clientHeight+(this.dom.statusBar?this.dom.statusBar.clientHeight:0),this.onChangeHeight(f)):this.onChangeHeight(0),G.filter(function(C){return C.type!=="error"}).length);0<y?(this.dom.validationErrorCount.style.display="inline",this.dom.validationErrorCount.innerText=y,this.dom.validationErrorCount.onclick=this.toggleTableVisibility.bind(this),this.dom.validationErrorIcon.style.display="inline",this.dom.validationErrorIcon.title=y+" schema validation error(s) found",this.dom.validationErrorIcon.onclick=this.toggleTableVisibility.bind(this)):(this.dom.validationErrorCount.style.display="none",this.dom.validationErrorIcon.style.display="none"),G.some(function(C){return C.type==="error"})?(f=G[0].line,this.dom.parseErrorIndication.style.display="block",this.dom.parseErrorIndication.title=isNaN(f)?"parse error - check that the json is valid":"parse error on line "+f,this.dom.parseErrorIndication.onclick=this.toggleTableVisibility.bind(this)):this.dom.parseErrorIndication.style.display="none"}}])&&k(z.prototype,Y),Object.defineProperty(z,"prototype",{writable:!1}),j}()},2474:function(le,m,D){function U(j){return(U=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(z){return typeof z}:function(z){return z&&typeof Symbol=="function"&&z.constructor===Symbol&&z!==Symbol.prototype?"symbol":typeof z})(j)}function k(j,z){for(var Y=0;Y<z.length;Y++){var G=z[Y];G.enumerable=G.enumerable||!1,G.configurable=!0,"value"in G&&(G.writable=!0),Object.defineProperty(j,function(N){return N=function(A,f){if(U(A)!=="object"||A===null)return A;var R=A[Symbol.toPrimitive];if(R===void 0)return(f==="string"?String:Number)(A);if(R=R.call(A,f||"default"),U(R)!=="object")return R;throw new TypeError("@@toPrimitive must return a primitive value.")}(N,"string"),U(N)==="symbol"?N:String(N)}(G.key),G)}}D.d(m,{R:function(){return H}});var H=function(){function j(G){if(!(this instanceof j))throw new TypeError("Cannot call a class as a function");if(this.target=G.target||null,!this.target)throw new Error('FocusTracker constructor called without a "target" to track.');this.onFocus=typeof G.onFocus=="function"?G.onFocus:null,this.onBlur=typeof G.onBlur=="function"?G.onBlur:null,this._onClick=this._onEvent.bind(this),this._onKeyUp=(function(N){N.which!==9&&N.keyCode!==9||this._onEvent(N)}).bind(this),this._onBlur=this._onEvent.bind(this),this.focusFlag=!1,this.firstEventFlag=!0,(this.onFocus||this.onBlur)&&(document.addEventListener("click",this._onClick),document.addEventListener("keyup",this._onKeyUp),document.addEventListener("blur",this._onBlur))}var z,Y;return z=j,(Y=[{key:"destroy",value:function(){document.removeEventListener("click",this._onClick),document.removeEventListener("keyup",this._onKeyUp),document.removeEventListener("blur",this._onBlur),this._onEvent({target:document.body})}},{key:"_onEvent",value:function(G){G=G.target,G=G===this.target||!(!this.target.contains(G)&&!this.target.contains(document.activeElement)),G?this.focusFlag||(this.onFocus&&this.onFocus({type:"focus",target:this.target}),this.focusFlag=!0):(this.focusFlag||this.firstEventFlag)&&(this.onBlur&&this.onBlur({type:"blur",target:this.target}),this.focusFlag=!1,this.firstEventFlag)&&(this.firstEventFlag=!1)}}])&&k(z.prototype,Y),Object.defineProperty(z,"prototype",{writable:!1}),j}()},3161:function(le,m,D){var U=D(8170),k=D(8037),H=D(8038).treeModeMixins,j=D(8458).textModeMixins,z=D(341).previewModeMixins,R=D(9791),Y=R.clear,G=R.extend,N=R.getInnerText,A=R.getInternetExplorerVersion,f=R.parse,R=D(2744).tryRequireAjv,y=D(2558).showTransformModal,C=D(6210).showSortModal,d=R();function h(l,n,o){if(!(this instanceof h))throw new Error('JSONEditor constructor called without "new".');var i=A();if(i!==-1&&i<9)throw new Error("Unsupported browser, IE9 or newer required. Please install the newest version of your browser.");n&&(n.error&&(console.warn('Option "error" has been renamed to "onError"'),n.onError=n.error,delete n.error),n.change&&(console.warn('Option "change" has been renamed to "onChange"'),n.onChange=n.change,delete n.change),n.editable&&(console.warn('Option "editable" has been renamed to "onEditable"'),n.onEditable=n.editable,delete n.editable),n.onChangeJSON&&(n.mode==="text"||n.mode==="code"||n.modes&&(n.modes.indexOf("text")!==-1||n.modes.indexOf("code")!==-1))&&console.warn('Option "onChangeJSON" is not applicable to modes "text" and "code". Use "onChangeText" or "onChange" instead.'),n)&&Object.keys(n).forEach(function(a){h.VALID_OPTIONS.indexOf(a)===-1&&console.warn('Unknown option "'+a+'". This option will be ignored')}),arguments.length&&this._create(l,n,o)}typeof Promise>"u"&&console.error("Promise undefined. Please load a Promise polyfill in the browser in order to use JSONEditor"),h.modes={},h.prototype.DEBOUNCE_INTERVAL=150,h.VALID_OPTIONS=["ajv","schema","schemaRefs","templates","ace","theme","autocomplete","onChange","onChangeJSON","onChangeText","onExpand","onEditable","onError","onEvent","onModeChange","onNodeName","onValidate","onCreateMenu","onSelectionChange","onTextSelectionChange","onClassName","onFocus","onBlur","colorPicker","onColorPicker","timestampTag","timestampFormat","escapeUnicode","history","search","mode","modes","name","indentation","sortObjectKeys","navigationBar","statusBar","mainMenuBar","languages","language","enableSort","enableTransform","limitDragging","maxVisibleChilds","onValidationError","modalAnchor","popupAnchor","createQuery","executeQuery","queryDescription","allowSchemaSuggestions","showErrorTable"],h.prototype._create=function(l,n,o){this.container=l,this.options=n||{},this.json=o||{},l=this.options.mode||this.options.modes&&this.options.modes[0]||"tree",this.setMode(l)},h.prototype.destroy=function(){},h.prototype.set=function(l){this.json=l},h.prototype.get=function(){return this.json},h.prototype.setText=function(l){this.json=f(l)},h.prototype.getText=function(){return JSON.stringify(this.json)},h.prototype.setName=function(l){this.options||(this.options={}),this.options.name=l},h.prototype.getName=function(){return this.options&&this.options.name},h.prototype.setMode=function(l){if(l!==this.options.mode||!this.create){var n=this.container,o=G({},this.options),i=o.mode,a=(o.mode=l,h.modes[l]);if(!a)throw new Error('Unknown mode "'+o.mode+'"');var r=a.data==="text",e=this.getName(),t=this[r?"getText":"get"]();if(this.destroy(),Y(this),G(this,a.mixin),this.create(n,o),this.setName(e),this[r?"setText":"set"](t),typeof a.load=="function")try{a.load.call(this)}catch(s){console.error(s)}if(typeof o.onModeChange=="function"&&l!==i)try{o.onModeChange(l,i)}catch(s){console.error(s)}}},h.prototype.getMode=function(){return this.options.mode},h.prototype._onError=function(l){this.options&&typeof this.options.onError=="function"?this.options.onError(l):window.alert(l.toString())},h.prototype.setSchema=function(l,n){if(l){var o;try{this.options.ajv?o=this.options.ajv:((o=d({allErrors:!0,verbose:!0,schemaId:"auto",$data:!0})).addMetaSchema(D(7171)),o.addMetaSchema(D(6273)))}catch{console.warn("Failed to create an instance of Ajv, JSON Schema validation is not available. Please use a JSONEditor bundle including Ajv, or pass an instance of Ajv as via the configuration option `ajv`.")}if(o){if(n){for(var i in n)o.removeSchema(i),n[i]&&o.addSchema(n[i],i);this.options.schemaRefs=n}this.validateSchema=o.compile(l),this.options.schema=l,this.options.schemaRefs=n,this.validate()}}else this.validateSchema=null,this.options.schema=null,this.options.schemaRefs=null,this.validate();this.refresh(),typeof this._onSchemaChange=="function"&&this._onSchemaChange(l,n)},h.prototype.validate=function(){},h.prototype.refresh=function(){},(h.registerMode=function(l){var n;if(Array.isArray(l))for(a=0;a<l.length;a++)h.registerMode(l[a]);else{if(!("mode"in l))throw new Error('Property "mode" missing');if(!("mixin"in l))throw new Error('Property "mixin" missing');if(!("data"in l))throw new Error('Property "data" missing');var o=l.mode;if(o in h.modes)throw new Error('Mode "'+o+'" already registered');if(typeof l.mixin.create!="function")throw new Error('Required function "create" missing on mixin');for(var i=["setMode","registerMode","modes"],a=0;a<i.length;a++)if((n=i[a])in l.mixin)throw new Error('Reserved property "'+n+'" not allowed in mixin');h.modes[o]=l}})(H),h.registerMode(j),h.registerMode(z),h.ace=U,h.Ajv=d,h.VanillaPicker=k,h.showTransformModal=y,h.showSortModal=C,h.getInnerText=N,le.exports=h.default=h},6617:function(le,m,D){D.d(m,{x:function(){return z}});var U=D(897),k=D(7907);function H(Y){return(H=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(G){return typeof G}:function(G){return G&&typeof Symbol=="function"&&G.constructor===Symbol&&G!==Symbol.prototype?"symbol":typeof G})(Y)}function j(Y,G){for(var N=0;N<G.length;N++){var A=G[N];A.enumerable=A.enumerable||!1,A.configurable=!0,"value"in A&&(A.writable=!0),Object.defineProperty(Y,function(f){return f=function(R,y){if(H(R)!=="object"||R===null)return R;var C=R[Symbol.toPrimitive];if(C===void 0)return(y==="string"?String:Number)(R);if(C=C.call(R,y||"default"),H(C)!=="object")return C;throw new TypeError("@@toPrimitive must return a primitive value.")}(f,"string"),H(f)==="symbol"?f:String(f)}(A.key),A)}}var z=function(){function Y(A,f,R,y){if(!(this instanceof Y))throw new TypeError("Cannot call a class as a function");for(var C={code:{text:(0,k.Iu)("modeCodeText"),title:(0,k.Iu)("modeCodeTitle"),click:function(){y("code")}},form:{text:(0,k.Iu)("modeFormText"),title:(0,k.Iu)("modeFormTitle"),click:function(){y("form")}},text:{text:(0,k.Iu)("modeTextText"),title:(0,k.Iu)("modeTextTitle"),click:function(){y("text")}},tree:{text:(0,k.Iu)("modeTreeText"),title:(0,k.Iu)("modeTreeTitle"),click:function(){y("tree")}},view:{text:(0,k.Iu)("modeViewText"),title:(0,k.Iu)("modeViewTitle"),click:function(){y("view")}},preview:{text:(0,k.Iu)("modePreviewText"),title:(0,k.Iu)("modePreviewTitle"),click:function(){y("preview")}}},d=[],h=0;h<f.length;h++){var l=f[h],n=C[l];if(!n)throw new Error('Unknown mode "'+l+'"');n.className="jsoneditor-type-modes"+(R===l?" jsoneditor-selected":""),d.push(n)}var i=C[R];if(!i)throw new Error('Unknown mode "'+R+'"');var i=i.text,o=document.createElement("button"),i=(o.type="button",o.className="jsoneditor-modes jsoneditor-separator",o.textContent=i+" ▾",o.title=(0,k.Iu)("modeEditorTitle"),o.onclick=function(){new U.x(d).show(o,A)},document.createElement("div"));i.className="jsoneditor-modes",i.style.position="relative",i.appendChild(o),A.appendChild(i),this.dom={container:A,box:o,frame:i}}var G,N;return G=Y,(N=[{key:"focus",value:function(){this.dom.box.focus()}},{key:"destroy",value:function(){this.dom&&this.dom.frame&&this.dom.frame.parentNode&&this.dom.frame.parentNode.removeChild(this.dom.frame),this.dom=null}}])&&j(G.prototype,N),Object.defineProperty(G,"prototype",{writable:!1}),Y}()},8170:function(le,m,D){var U;if(window.ace)U=window.ace;else try{U=D(6225),D(4091),D(3330),D(4317);var k=D(7923);U.config.setModuleUrl("ace/mode/json_worker",k)}catch{}le.exports=U},4864:function(){window.ace.define("ace/theme/jsoneditor",["require","exports","module","ace/lib/dom"],function(le,m,D){m.isDark=!1,m.cssClass="ace-jsoneditor",m.cssText=`.ace-jsoneditor .ace_gutter {
background: #ebebeb;
color: #333
}

.ace-jsoneditor.ace_editor {
line-height: 1.3;
background-color: #fff;
}
.ace-jsoneditor .ace_print-margin {
width: 1px;
background: #e8e8e8
}
.ace-jsoneditor .ace_scroller {
background-color: #FFFFFF
}
.ace-jsoneditor .ace_text-layer {
color: gray
}
.ace-jsoneditor .ace_variable {
color: #1a1a1a
}
.ace-jsoneditor .ace_cursor {
border-left: 2px solid #000000
}
.ace-jsoneditor .ace_overwrite-cursors .ace_cursor {
border-left: 0px;
border-bottom: 1px solid #000000
}
.ace-jsoneditor .ace_marker-layer .ace_selection {
background: lightgray
}
.ace-jsoneditor.ace_multiselect .ace_selection.ace_start {
box-shadow: 0 0 3px 0px #FFFFFF;
border-radius: 2px
}
.ace-jsoneditor .ace_marker-layer .ace_step {
background: rgb(255, 255, 0)
}
.ace-jsoneditor .ace_marker-layer .ace_bracket {
margin: -1px 0 0 -1px;
border: 1px solid #BFBFBF
}
.ace-jsoneditor .ace_marker-layer .ace_active-line {
background: #FFFBD1
}
.ace-jsoneditor .ace_gutter-active-line {
background-color : #dcdcdc
}
.ace-jsoneditor .ace_marker-layer .ace_selected-word {
border: 1px solid lightgray
}
.ace-jsoneditor .ace_invisible {
color: #BFBFBF
}
.ace-jsoneditor .ace_keyword,
.ace-jsoneditor .ace_meta,
.ace-jsoneditor .ace_support.ace_constant.ace_property-value {
color: #AF956F
}
.ace-jsoneditor .ace_keyword.ace_operator {
color: #484848
}
.ace-jsoneditor .ace_keyword.ace_other.ace_unit {
color: #96DC5F
}
.ace-jsoneditor .ace_constant.ace_language {
color: darkorange
}
.ace-jsoneditor .ace_constant.ace_numeric {
color: red
}
.ace-jsoneditor .ace_constant.ace_character.ace_entity {
color: #BF78CC
}
.ace-jsoneditor .ace_invalid {
color: #FFFFFF;
background-color: #FF002A;
}
.ace-jsoneditor .ace_fold {
background-color: #AF956F;
border-color: #000000
}
.ace-jsoneditor .ace_storage,
.ace-jsoneditor .ace_support.ace_class,
.ace-jsoneditor .ace_support.ace_function,
.ace-jsoneditor .ace_support.ace_other,
.ace-jsoneditor .ace_support.ace_type {
color: #C52727
}
.ace-jsoneditor .ace_string {
color: green
}
.ace-jsoneditor .ace_comment {
color: #BCC8BA
}
.ace-jsoneditor .ace_entity.ace_name.ace_tag,
.ace-jsoneditor .ace_entity.ace_other.ace_attribute-name {
color: #606060
}
.ace-jsoneditor .ace_markup.ace_underline {
text-decoration: underline
}
.ace-jsoneditor .ace_indent-guide {
background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y
}`,le("../lib/dom").importCssString(m.cssText,m.cssClass)})},6589:function(le,m){(D={trace:function(){},yy:{},symbols_:{error:2,JSONString:3,STRING:4,JSONNumber:5,NUMBER:6,JSONNullLiteral:7,NULL:8,JSONBooleanLiteral:9,TRUE:10,FALSE:11,JSONText:12,JSONValue:13,EOF:14,JSONObject:15,JSONArray:16,"{":17,"}":18,JSONMemberList:19,JSONMember:20,":":21,",":22,"[":23,"]":24,JSONElementList:25,$accept:0,$end:1},terminals_:{2:"error",4:"STRING",6:"NUMBER",8:"NULL",10:"TRUE",11:"FALSE",14:"EOF",17:"{",18:"}",21:":",22:",",23:"[",24:"]"},productions_:[0,[3,1],[5,1],[7,1],[9,1],[9,1],[12,2],[13,1],[13,1],[13,1],[13,1],[13,1],[13,1],[15,2],[15,3],[20,3],[19,1],[19,3],[16,2],[16,3],[25,1],[25,3]],performAction:function(U,k,H,j,z,Y,G){var N=Y.length-1;switch(z){case 1:this.$=U.replace(/\\(\\|")/g,"$1").replace(/\\n/g,`
`).replace(/\\r/g,"\r").replace(/\\t/g,"	").replace(/\\v/g,"\v").replace(/\\f/g,"\f").replace(/\\b/g,"\b");break;case 2:this.$=Number(U);break;case 3:this.$=null;break;case 4:this.$=!0;break;case 5:this.$=!1;break;case 6:return this.$=Y[N-1];case 13:this.$={};break;case 14:this.$=Y[N-1];break;case 15:this.$=[Y[N-2],Y[N]];break;case 16:this.$={},this.$[Y[N][0]]=Y[N][1];break;case 17:this.$=Y[N-2],Y[N-2][Y[N][0]]=Y[N][1];break;case 18:this.$=[];break;case 19:this.$=Y[N-1];break;case 20:this.$=[Y[N]];break;case 21:this.$=Y[N-2],Y[N-2].push(Y[N])}},table:[{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],12:1,13:2,15:7,16:8,17:[1,14],23:[1,15]},{1:[3]},{14:[1,16]},{14:[2,7],18:[2,7],22:[2,7],24:[2,7]},{14:[2,8],18:[2,8],22:[2,8],24:[2,8]},{14:[2,9],18:[2,9],22:[2,9],24:[2,9]},{14:[2,10],18:[2,10],22:[2,10],24:[2,10]},{14:[2,11],18:[2,11],22:[2,11],24:[2,11]},{14:[2,12],18:[2,12],22:[2,12],24:[2,12]},{14:[2,3],18:[2,3],22:[2,3],24:[2,3]},{14:[2,4],18:[2,4],22:[2,4],24:[2,4]},{14:[2,5],18:[2,5],22:[2,5],24:[2,5]},{14:[2,1],18:[2,1],21:[2,1],22:[2,1],24:[2,1]},{14:[2,2],18:[2,2],22:[2,2],24:[2,2]},{3:20,4:[1,12],18:[1,17],19:18,20:19},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:23,15:7,16:8,17:[1,14],23:[1,15],24:[1,21],25:22},{1:[2,6]},{14:[2,13],18:[2,13],22:[2,13],24:[2,13]},{18:[1,24],22:[1,25]},{18:[2,16],22:[2,16]},{21:[1,26]},{14:[2,18],18:[2,18],22:[2,18],24:[2,18]},{22:[1,28],24:[1,27]},{22:[2,20],24:[2,20]},{14:[2,14],18:[2,14],22:[2,14],24:[2,14]},{3:20,4:[1,12],20:29},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:30,15:7,16:8,17:[1,14],23:[1,15]},{14:[2,19],18:[2,19],22:[2,19],24:[2,19]},{3:5,4:[1,12],5:6,6:[1,13],7:3,8:[1,9],9:4,10:[1,10],11:[1,11],13:31,15:7,16:8,17:[1,14],23:[1,15]},{18:[2,17],22:[2,17]},{18:[2,15],22:[2,15]},{22:[2,21],24:[2,21]}],defaultActions:{16:[2,6]},parseError:function(U,k){throw new Error(U)},parse:function(U){var k=this,H=[0],j=[null],z=[],Y=this.table,G="",N=0,A=0,f=0,R=(this.lexer.setInput(U),this.lexer.yy=this.yy,this.yy.lexer=this.lexer,this.lexer.yylloc===void 0&&(this.lexer.yylloc={}),this.lexer.yylloc);function y(){var s=k.lexer.lex()||1;return s=typeof s!="number"&&k.symbols_[s]||s}z.push(R),typeof this.yy.parseError=="function"&&(this.parseError=this.yy.parseError);for(var C,d,h,l,n,o,i,a,r,e={};;){if(h=H[H.length-1],(l=this.defaultActions[h]||(C==null&&(C=y()),Y[h]&&Y[h][C]))===void 0||!l.length||!l[0]){if(!f){for(n in a=[],Y[h])this.terminals_[n]&&2<n&&a.push("'"+this.terminals_[n]+"'");var t="",t=this.lexer.showPosition?"Parse error on line "+(N+1)+`:
`+this.lexer.showPosition()+`
Expecting `+a.join(", ")+", got '"+this.terminals_[C]+"'":"Parse error on line "+(N+1)+": Unexpected "+(C==1?"end of input":"'"+(this.terminals_[C]||C)+"'");this.parseError(t,{text:this.lexer.match,token:this.terminals_[C]||C,line:this.lexer.yylineno,loc:R,expected:a})}if(f==3){if(C==1)throw new Error(t||"Parsing halted.");A=this.lexer.yyleng,G=this.lexer.yytext,N=this.lexer.yylineno,R=this.lexer.yylloc,C=y()}for(;!(2 .toString()in Y[h]);){if(h==0)throw new Error(t||"Parsing halted.");r=1,H.length=H.length-2*r,j.length=j.length-r,z.length=z.length-r,h=H[H.length-1]}d=C,C=2,l=Y[h=H[H.length-1]]&&Y[h][2],f=3}if(l[0]instanceof Array&&1<l.length)throw new Error("Parse Error: multiple actions possible at state: "+h+", token: "+C);switch(l[0]){case 1:H.push(C),j.push(this.lexer.yytext),z.push(this.lexer.yylloc),H.push(l[1]),C=null,d?(C=d,d=null):(A=this.lexer.yyleng,G=this.lexer.yytext,N=this.lexer.yylineno,R=this.lexer.yylloc,0<f&&f--);break;case 2:if(o=this.productions_[l[1]][1],e.$=j[j.length-o],e._$={first_line:z[z.length-(o||1)].first_line,last_line:z[z.length-1].last_line,first_column:z[z.length-(o||1)].first_column,last_column:z[z.length-1].last_column},(i=this.performAction.call(e,G,A,N,this.yy,l[1],j,z))!==void 0)return i;o&&(H=H.slice(0,-1*o*2),j=j.slice(0,-1*o),z=z.slice(0,-1*o)),H.push(this.productions_[l[1]][0]),j.push(e.$),z.push(e._$),i=Y[H[H.length-2]][H[H.length-1]],H.push(i);break;case 3:return!0}}return!0}}).lexer={EOF:1,parseError:function(U,k){if(!this.yy.parseError)throw new Error(U);this.yy.parseError(U,k)},setInput:function(U){return this._input=U,this._more=this._less=this.done=!1,this.yylineno=this.yyleng=0,this.yytext=this.matched=this.match="",this.conditionStack=["INITIAL"],this.yylloc={first_line:1,first_column:0,last_line:1,last_column:0},this},input:function(){var U=this._input[0];return this.yytext+=U,this.yyleng++,this.match+=U,this.matched+=U,U.match(/\n/)&&this.yylineno++,this._input=this._input.slice(1),U},unput:function(U){return this._input=U+this._input,this},more:function(){return this._more=!0,this},less:function(U){this._input=this.match.slice(U)+this._input},pastInput:function(){var U=this.matched.substr(0,this.matched.length-this.match.length);return(20<U.length?"...":"")+U.substr(-20).replace(/\n/g,"")},upcomingInput:function(){var U=this.match;return U.length<20&&(U+=this._input.substr(0,20-U.length)),(U.substr(0,20)+(20<U.length?"...":"")).replace(/\n/g,"")},showPosition:function(){var U=this.pastInput(),k=new Array(U.length+1).join("-");return U+this.upcomingInput()+`
`+k+"^"},next:function(){if(this.done)return this.EOF;this._input||(this.done=!0),this._more||(this.yytext="",this.match="");for(var U,k,H,j,z=this._currentRules(),Y=0;Y<z.length&&(!(k=this._input.match(this.rules[z[Y]]))||U&&!(k[0].length>U[0].length)||(U=k,H=Y,this.options.flex));Y++);return U?((j=U[0].match(/\n.*/g))&&(this.yylineno+=j.length),this.yylloc={first_line:this.yylloc.last_line,last_line:this.yylineno+1,first_column:this.yylloc.last_column,last_column:j?j[j.length-1].length-1:this.yylloc.last_column+U[0].length},this.yytext+=U[0],this.match+=U[0],this.yyleng=this.yytext.length,this._more=!1,this._input=this._input.slice(U[0].length),this.matched+=U[0],j=this.performAction.call(this,this.yy,this,z[H],this.conditionStack[this.conditionStack.length-1]),this.done&&this._input&&(this.done=!1),j||void 0):this._input===""?this.EOF:void this.parseError("Lexical error on line "+(this.yylineno+1)+`. Unrecognized text.
`+this.showPosition(),{text:"",token:null,line:this.yylineno})},lex:function(){var U=this.next();return U!==void 0?U:this.lex()},begin:function(U){this.conditionStack.push(U)},popState:function(){return this.conditionStack.pop()},_currentRules:function(){return this.conditions[this.conditionStack[this.conditionStack.length-1]].rules},topState:function(){return this.conditionStack[this.conditionStack.length-2]},pushState:function(U){this.begin(U)},options:{},performAction:function(U,k,H,j){switch(H){case 0:break;case 1:return 6;case 2:return k.yytext=k.yytext.substr(1,k.yyleng-2),4;case 3:return 17;case 4:return 18;case 5:return 23;case 6:return 24;case 7:return 22;case 8:return 21;case 9:return 10;case 10:return 11;case 11:return 8;case 12:return 14;case 13:return"INVALID"}},rules:[/^(?:\s+)/,/^(?:(-?([0-9]|[1-9][0-9]+))(\.[0-9]+)?([eE][-+]?[0-9]+)?\b)/,/^(?:"(?:\\[\\"bfnrt/]|\\u[a-fA-F0-9]{4}|[^\\\0-\x09\x0a-\x1f"])*")/,/^(?:\{)/,/^(?:\})/,/^(?:\[)/,/^(?:\])/,/^(?:,)/,/^(?::)/,/^(?:true\b)/,/^(?:false\b)/,/^(?:null\b)/,/^(?:$)/,/^(?:.)/],conditions:{INITIAL:{rules:[0,1,2,3,4,5,6,7,8,9,10,11,12,13],inclusive:!0}}};var D;m.parser=D,m.parse=D.parse.bind(D)},3879:function(le){function m(){}m.prototype={on:function(N,A){this._events=this._events||{},this._events[N]=this._events[N]||[],this._events[N].push(A)},off:function(N,A){this._events=this._events||{},N in this._events&&this._events[N].splice(this._events[N].indexOf(A),1)},emit:function(N){if(this._events=this._events||{},N in this._events)for(var A=0;A<this._events[N].length;A++)this._events[N][A].apply(this,Array.prototype.slice.call(arguments,1))}},m.mixin=function(N){for(var A=["on","off","emit"],f=0;f<A.length;f++)typeof N=="function"?N.prototype[A[f]]=m.prototype[A[f]]:N[A[f]]=m.prototype[A[f]];return N};var D={escapeRegExp:function(N){var A=/[\\^$.*+?()[\]{}|]/g,f=new RegExp(A.source);return N&&f.test(N)?N.replace(A,"\\$&"):N},extend:function(N,A){for(var f in A){var R;A.hasOwnProperty(f)&&((R=A[f])&&Object.prototype.toString.call(R)==="[object Object]"?(N[f]=N[f]||{},D.extend(N[f],R)):N[f]=R)}return N},each:function(N,A,f){if(Object.prototype.toString.call(N)==="[object Object]")for(var R in N)Object.prototype.hasOwnProperty.call(N,R)&&A.call(f,R,N[R],N);else for(var y=0,C=N.length;y<C;y++)A.call(f,y,N[y],N)},createElement:function(N,A){var f,R=document.createElement(N);if(A&&Object.prototype.toString.call(A)==="[object Object]")for(f in A)f in R?R[f]=A[f]:f==="html"?R.innerHTML=A[f]:R.setAttribute(f,A[f]);return R},hasClass:function(N,A){if(N)return N.classList?N.classList.contains(A):!!N.className&&!!N.className.match(new RegExp("(\\s|^)"+A+"(\\s|$)"))},addClass:function(N,A){D.hasClass(N,A)||(N.classList?N.classList.add(A):N.className=N.className.trim()+" "+A)},removeClass:function(N,A){D.hasClass(N,A)&&(N.classList?N.classList.remove(A):N.className=N.className.replace(new RegExp("(^|\\s)"+A.split(" ").join("|")+"(\\s|$)","gi")," "))},closest:function(N,A){return N&&N!==document.body&&(A(N)?N:D.closest(N.parentNode,A))},isInt:function(N){return typeof N=="number"&&isFinite(N)&&Math.floor(N)===N},debounce:function(N,A,f){var R;return function(){var y=this,C=arguments,d=f&&!R;clearTimeout(R),R=setTimeout(function(){R=null,f||N.apply(y,C)},A),d&&N.apply(y,C)}},rect:function(R,C){var f=window,R=R.getBoundingClientRect(),y=C?f.pageXOffset:0,C=C?f.pageYOffset:0;return{bottom:R.bottom+C,height:R.height,left:R.left+y,right:R.right+y,top:R.top+C,width:R.width}},includes:function(N,A){return-1<N.indexOf(A)},startsWith:function(N,A){return N.substr(0,A.length)===A},truncate:function(N){for(;N.firstChild;)N.removeChild(N.firstChild)}};function U(N,A){return N.hasOwnProperty(A)&&(N[A]===!0||N[A].length)}function k(N,A,f){N.parentNode?N.parentNode.parentNode||A.appendChild(N.parentNode):A.appendChild(N),D.removeClass(N,"excluded"),f||(N.textContent=N.textContent)}function H(){var N,A;this.items.length&&(N=document.createDocumentFragment(),this.config.pagination?(A=this.pages.slice(0,this.pageIndex),D.each(A,function(f,R){D.each(R,function(y,C){k(C,N,this.customOption)},this)},this)):D.each(this.items,function(f,R){k(R,N,this.customOption)},this),N.childElementCount&&(D.removeClass(this.items[this.navIndex],"active"),this.navIndex=(N.querySelector(".selectr-option.selected")||N.querySelector(".selectr-option")).idx,D.addClass(this.items[this.navIndex],"active")),this.tree.appendChild(N))}function j(N,A){A=A||N;var f={class:"selectr-option",role:"treeitem","aria-selected":!1};return this.customOption?f.html=this.config.renderOption(A):f.textContent=N.textContent,(A=D.createElement("li",f)).idx=N.idx,this.items.push(A),N.defaultSelected&&this.defaultSelected.push(N.idx),N.disabled&&(A.disabled=!0,D.addClass(A,"disabled")),A}function z(){var N,A=this.tree,f=A.scrollTop;A.scrollHeight-A.offsetHeight<=f&&this.pageIndex<this.pages.length&&(N=document.createDocumentFragment(),D.each(this.pages[this.pageIndex],function(R,y){k(y,N,this.customOption)},this),A.appendChild(N),this.pageIndex++,this.emit("selectr.paginate",{items:this.items.length,total:this.data.length,page:this.pageIndex,pages:this.pages.length}))}function Y(){(this.config.searchable||this.config.taggable)&&(this.input.value=null,this.searching=!1,this.config.searchable&&D.removeClass(this.inputContainer,"active"),D.hasClass(this.container,"notice")&&(D.removeClass(this.container,"notice"),D.addClass(this.container,"open"),this.input.focus()),D.each(this.items,function(N,A){D.removeClass(A,"excluded"),this.customOption||(A.textContent=A.textContent)},this))}function G(N,A){if(!N)throw new Error("You must supply either a HTMLSelectElement or a CSS3 selector string.");if(typeof(this.el=N)=="string"&&(this.el=document.querySelector(N)),this.el===null)throw new Error("The element you passed to Selectr can not be found.");if(this.el.nodeName.toLowerCase()!=="select")throw new Error("The element you passed to Selectr is not a HTMLSelectElement.");this.render(A)}G.prototype.render=function(N){var A;this.rendered||((this.el.selectr=this).config=D.extend({defaultSelected:!0,width:"auto",disabled:!1,disabledMobile:!1,searchable:!0,clearable:!1,sortSelected:!1,allowDeselect:!1,closeOnScroll:!1,nativeDropdown:!1,nativeKeyboard:!1,placeholder:"Select an option...",taggable:!1,tagPlaceholder:"Enter a tag...",messages:{noResults:"No results.",noOptions:"No options available.",maxSelections:"A maximum of {max} items can be selected.",tagDuplicate:"That tag is already in use.",searchPlaceholder:"Search options..."}},N),this.originalType=this.el.type,this.originalIndex=this.el.tabIndex,this.defaultSelected=[],this.originalOptionCount=this.el.options.length,(this.config.multiple||this.config.taggable)&&(this.el.multiple=!0),this.disabled=U(this.config,"disabled"),this.opened=!1,this.config.taggable&&(this.config.searchable=!1),this.navigating=!1,this.mobileDevice=!1,!this.config.disabledMobile&&/Android|webOS|iPhone|iPad|BlackBerry|Windows Phone|Opera Mini|IEMobile|Mobile/i.test(navigator.userAgent)&&(this.mobileDevice=!0),this.customOption=this.config.hasOwnProperty("renderOption")&&typeof this.config.renderOption=="function",this.customSelected=this.config.hasOwnProperty("renderSelection")&&typeof this.config.renderSelection=="function",this.supportsEventPassiveOption=this.detectEventPassiveOption(),m.mixin(this),(function(){this.requiresPagination=this.config.pagination&&0<this.config.pagination,U(this.config,"width")&&(D.isInt(this.config.width)?this.width=this.config.width+"px":this.config.width==="auto"?this.width="100%":D.includes(this.config.width,"%")&&(this.width=this.config.width)),this.container=D.createElement("div",{class:"selectr-container"}),this.config.customClass&&D.addClass(this.container,this.config.customClass),this.mobileDevice?D.addClass(this.container,"selectr-mobile"):D.addClass(this.container,"selectr-desktop"),this.el.tabIndex=-1,this.config.nativeDropdown||this.mobileDevice?D.addClass(this.el,"selectr-visible"):D.addClass(this.el,"selectr-hidden"),this.selected=D.createElement("div",{class:"selectr-selected",disabled:this.disabled,tabIndex:0,"aria-expanded":!1}),this.label=D.createElement(this.el.multiple?"ul":"span",{class:"selectr-label"});var f=D.createElement("div",{class:"selectr-options-container"});if(this.tree=D.createElement("ul",{class:"selectr-options",role:"tree","aria-hidden":!0,"aria-expanded":!1}),this.notice=D.createElement("div",{class:"selectr-notice"}),this.el.setAttribute("aria-hidden",!0),this.disabled&&(this.el.disabled=!0),this.el.multiple?(D.addClass(this.label,"selectr-tags"),D.addClass(this.container,"multiple"),this.tags=[],this.selectedValues=this.config.defaultSelected?this.getSelectedProperties("value"):[],this.selectedIndexes=this.getSelectedProperties("idx")):(this.selectedValue=null,this.selectedIndex=-1),this.selected.appendChild(this.label),this.config.clearable&&(this.selectClear=D.createElement("button",{class:"selectr-clear",type:"button"}),this.container.appendChild(this.selectClear),D.addClass(this.container,"clearable")),this.config.taggable){var R=D.createElement("li",{class:"input-tag"});if(this.input=D.createElement("input",{class:"selectr-tag-input",placeholder:this.config.tagPlaceholder,tagIndex:0,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search"}),R.appendChild(this.input),this.label.appendChild(R),D.addClass(this.container,"taggable"),this.tagSeperators=[","],this.config.tagSeperators){this.tagSeperators=this.tagSeperators.concat(this.config.tagSeperators);for(var y=[],C=0;C<this.tagSeperators.length;C++)y.push(D.escapeRegExp(this.tagSeperators[C]));this.tagSeperatorsRegex=new RegExp(y.join("|"),"i")}else this.tagSeperatorsRegex=new RegExp(",","i")}this.config.searchable&&(this.input=D.createElement("input",{class:"selectr-input",tagIndex:-1,autocomplete:"off",autocorrect:"off",autocapitalize:"off",spellcheck:"false",role:"textbox",type:"search",placeholder:this.config.messages.searchPlaceholder}),this.inputClear=D.createElement("button",{class:"selectr-input-clear",type:"button"}),this.inputContainer=D.createElement("div",{class:"selectr-input-container"}),this.inputContainer.appendChild(this.input),this.inputContainer.appendChild(this.inputClear),f.appendChild(this.inputContainer)),f.appendChild(this.notice),f.appendChild(this.tree),this.items=[],this.options=[],this.el.options.length&&(this.options=[].slice.call(this.el.options));var d,h,l,n=!1,o=0;this.el.children.length&&D.each(this.el.children,function(a,r){r.nodeName==="OPTGROUP"?(n=D.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+r.label+"</li>"}),D.each(r.children,function(e,t){t.idx=o,n.appendChild(j.call(this,t,n)),o++},this)):(r.idx=o,j.call(this,r),o++)},this),this.config.data&&Array.isArray(this.config.data)&&(d=!(this.data=[]),n=!1,o=0,D.each(this.config.data,function(a,r){U(r,"children")?(d=D.createElement("optgroup",{label:r.text}),n=D.createElement("ul",{class:"selectr-optgroup",role:"group",html:"<li class='selectr-optgroup--label'>"+r.text+"</li>"}),D.each(r.children,function(e,t){(h=new Option(t.text,t.value,!1,t.hasOwnProperty("selected")&&t.selected===!0)).disabled=U(t,"disabled"),this.options.push(h),d.appendChild(h),h.idx=o,n.appendChild(j.call(this,h,t)),this.data[o]=t,o++},this),this.el.appendChild(d)):((h=new Option(r.text,r.value,!1,r.hasOwnProperty("selected")&&r.selected===!0)).disabled=U(r,"disabled"),this.options.push(h),h.idx=o,j.call(this,h,r),this.data[o]=r,o++)},this)),this.setSelected(!0);for(var i=this.navIndex=0;i<this.items.length;i++)if(l=this.items[i],!D.hasClass(l,"disabled")){D.addClass(l,"active"),this.navIndex=i;break}this.requiresPagination&&(this.pageIndex=1,this.paginate()),this.container.appendChild(this.selected),this.container.appendChild(f),this.placeEl=D.createElement("div",{class:"selectr-placeholder"}),this.setPlaceholder(),this.selected.appendChild(this.placeEl),this.disabled&&this.disable(),this.el.parentNode.insertBefore(this.container,this.el),this.container.appendChild(this.el)}).call(this),this.bindEvents(),this.update(),this.optsRect=D.rect(this.tree),this.rendered=!0,this.el.multiple||(this.el.selectedIndex=this.selectedIndex),A=this,setTimeout(function(){A.emit("selectr.init")},20))},G.prototype.getSelected=function(){return this.el.querySelectorAll("option:checked")},G.prototype.getSelectedProperties=function(N){var A=this.getSelected();return[].slice.call(A).map(function(f){return f[N]}).filter(function(f){return f!=null})},G.prototype.detectEventPassiveOption=function(){var N=!1;try{var A=Object.defineProperty({},"passive",{get:function(){N=!0}});window.addEventListener("test",null,A)}catch{}return N},G.prototype.bindEvents=function(){var N,A=this;this.events={},this.events.dismiss=(function(f){f=f.target,this.container.contains(f)||!this.opened&&!D.hasClass(this.container,"notice")||this.close()}).bind(this),this.events.navigate=(function(f){if(f=f||window.event,this.items.length&&this.opened&&D.includes([13,38,40],f.which)){if(f.preventDefault(),f.which===13)return!(this.noResults||this.config.taggable&&0<this.input.value.length)&&this.change(this.navIndex);var R,y=this.items[this.navIndex],C=this.navIndex;switch(f.which){case 38:(R=0)<this.navIndex&&this.navIndex--;break;case 40:this.navIndex<this.items.length-(R=1)&&this.navIndex++}for(this.navigating=!0;D.hasClass(this.items[this.navIndex],"disabled")||D.hasClass(this.items[this.navIndex],"excluded");){if(!(0<this.navIndex&&this.navIndex<this.items.length-1)){this.navIndex=C;break}if(R?this.navIndex++:this.navIndex--,this.searching){if(this.navIndex>this.tree.lastElementChild.idx){this.navIndex=this.tree.lastElementChild.idx;break}if(this.navIndex<this.tree.firstElementChild.idx){this.navIndex=this.tree.firstElementChild.idx;break}}}f=D.rect(this.items[this.navIndex]),R?(this.navIndex===0?this.tree.scrollTop=0:f.top+f.height>this.optsRect.top+this.optsRect.height&&(this.tree.scrollTop=this.tree.scrollTop+(f.top+f.height-(this.optsRect.top+this.optsRect.height))),this.navIndex===this.tree.childElementCount-1&&this.requiresPagination&&z.call(this)):this.navIndex===0?this.tree.scrollTop=0:f.top-this.optsRect.top<0&&(this.tree.scrollTop=this.tree.scrollTop+(f.top-this.optsRect.top)),y&&D.removeClass(y,"active"),D.addClass(this.items[this.navIndex],"active")}else this.navigating=!1}).bind(this),this.events.reset=this.reset.bind(this),(this.config.nativeDropdown||this.mobileDevice)&&(this.container.addEventListener("touchstart",function(f){f.changedTouches[0].target===A.el&&A.toggle()},!!this.supportsEventPassiveOption&&{passive:!0}),this.container.addEventListener("click",function(f){f.target===A.el&&A.toggle()}),this.el.addEventListener("change",function(f){f.__selfTriggered||(A.el.multiple?(f=A.getSelectedProperties("idx"),f=function(R,y){for(var C,d=[],h=R.slice(0),l=0;l<y.length;l++)-1<(C=h.indexOf(y[l]))?h.splice(C,1):d.push(y[l]);return[d,h]}(A.selectedIndexes,f),D.each(f[0],function(R,y){A.select(y)},A),D.each(f[1],function(R,y){A.deselect(y)},A)):-1<A.el.selectedIndex&&A.select(A.el.selectedIndex))})),this.config.nativeDropdown&&this.container.addEventListener("keydown",function(f){f.key==="Enter"&&A.selected===document.activeElement&&(A.toggle(),setTimeout(function(){A.el.focus()},200))}),this.selected.addEventListener("click",function(f){A.disabled||A.toggle(),f.preventDefault()}),this.config.nativeKeyboard&&(N="",this.selected.addEventListener("keydown",function(f){var R;A.disabled||A.selected!==document.activeElement||f.altKey||f.ctrlKey||f.metaKey||(f.key===" "||!A.opened&&-1<["Enter","ArrowUp","ArrowDown"].indexOf(f.key)?(A.toggle(),f.preventDefault(),f.stopPropagation()):f.key.length<=2&&String[String.fromCodePoint?"fromCodePoint":"fromCharCode"](f.key[String.codePointAt?"codePointAt":"charCodeAt"](0))===f.key&&(A.config.multiple?(A.open(),A.config.searchable&&(A.input.value=f.key,A.input.focus(),A.search(null,!0))):(N+=f.key,(R=A.search(N,!0))&&R.length&&(A.clear(),A.setValue(R[0].value)),setTimeout(function(){N=""},1e3)),f.preventDefault(),f.stopPropagation()))}),this.container.addEventListener("keyup",function(f){A.opened&&f.key==="Escape"&&(A.close(),f.stopPropagation(),A.selected.focus())})),this.label.addEventListener("click",function(f){D.hasClass(f.target,"selectr-tag-remove")&&A.deselect(f.target.parentNode.idx)}),this.selectClear&&this.selectClear.addEventListener("click",this.clear.bind(this)),this.tree.addEventListener("mousedown",function(f){f.preventDefault()}),this.tree.addEventListener("click",function(f){var R=D.closest(f.target,function(y){return y&&D.hasClass(y,"selectr-option")});R&&!D.hasClass(R,"disabled")&&(D.hasClass(R,"selected")?(A.el.multiple||!A.el.multiple&&A.config.allowDeselect)&&A.deselect(R.idx):A.select(R.idx),A.opened&&!A.el.multiple)&&A.close(),f.preventDefault(),f.stopPropagation()}),this.tree.addEventListener("mouseover",function(f){!D.hasClass(f.target,"selectr-option")||D.hasClass(f.target,"disabled")||(D.removeClass(A.items[A.navIndex],"active"),D.addClass(f.target,"active"),A.navIndex=[].slice.call(A.items).indexOf(f.target))}),this.config.searchable&&(this.input.addEventListener("focus",function(f){A.searching=!0}),this.input.addEventListener("blur",function(f){A.searching=!1}),this.input.addEventListener("keyup",function(f){A.search(),A.config.taggable||(this.value.length?D.addClass(this.parentNode,"active"):D.removeClass(this.parentNode,"active"))}),this.inputClear.addEventListener("click",function(f){A.input.value=null,Y.call(A),A.tree.childElementCount||H.call(A)})),this.config.taggable&&this.input.addEventListener("keyup",function(f){var R,y;A.search(),A.config.taggable&&this.value.length&&(R=this.value.trim()).length&&(f.which===13||A.tagSeperatorsRegex.test(R))&&(f=R.replace(A.tagSeperatorsRegex,""),(y=(f=(f=D.escapeRegExp(f)).trim()).length?A.add({value:f,textContent:f,selected:!0},!0):y)?(A.close(),Y.call(A)):(this.value="",A.setMessage(A.config.messages.tagDuplicate)))}),this.update=D.debounce(function(){A.opened&&A.config.closeOnScroll&&A.close(),A.width&&(A.container.style.width=A.width),A.invert()},50),this.requiresPagination&&(this.paginateItems=D.debounce(function(){z.call(this)},50),this.tree.addEventListener("scroll",this.paginateItems.bind(this))),document.addEventListener("click",this.events.dismiss),window.addEventListener("keydown",this.events.navigate),window.addEventListener("resize",this.update),window.addEventListener("scroll",this.update),this.on("selectr.destroy",function(){document.removeEventListener("click",this.events.dismiss),window.removeEventListener("keydown",this.events.navigate),window.removeEventListener("resize",this.update),window.removeEventListener("scroll",this.update)}),this.el.form&&(this.el.form.addEventListener("reset",this.events.reset),this.on("selectr.destroy",function(){this.el.form.removeEventListener("reset",this.events.reset)}))},G.prototype.setSelected=function(N){var A;this.config.data||this.el.multiple||!this.el.options.length||(this.el.selectedIndex!==0||this.el.options[0].defaultSelected||this.config.defaultSelected||(this.el.selectedIndex=-1),this.selectedIndex=this.el.selectedIndex,-1<this.selectedIndex&&this.select(this.selectedIndex)),this.config.multiple&&this.originalType==="select-one"&&!this.config.data&&this.el.options[0].selected&&!this.el.options[0].defaultSelected&&(this.el.options[0].selected=!1),D.each(this.options,function(f,R){R.selected&&R.defaultSelected&&this.select(R.idx)},this),this.config.selectedValue&&this.setValue(this.config.selectedValue),this.config.data&&(!this.el.multiple&&this.config.defaultSelected&&this.el.selectedIndex<0&&0<this.config.data.length&&this.select(0),A=0,D.each(this.config.data,function(f,R){U(R,"children")?D.each(R.children,function(y,C){C.hasOwnProperty("selected")&&C.selected===!0&&this.select(A),A++},this):(R.hasOwnProperty("selected")&&R.selected===!0&&this.select(A),A++)},this))},G.prototype.destroy=function(){this.rendered&&(this.emit("selectr.destroy"),this.originalType==="select-one"&&(this.el.multiple=!1),this.config.data&&(this.el.innerHTML=""),D.removeClass(this.el,"selectr-hidden"),this.container.parentNode.replaceChild(this.el,this.container),this.rendered=!1,delete this.el.selectr)},G.prototype.change=function(N){var A=this.items[N],f=this.options[N];f.disabled||(f.selected&&D.hasClass(A,"selected")?this.deselect(N):this.select(N),this.opened&&!this.el.multiple&&this.close())},G.prototype.select=function(N){var A=this.items[N],f=[].slice.call(this.el.options),R=this.options[N];if(this.el.multiple){if(D.includes(this.selectedIndexes,N))return!1;if(this.config.maxSelections&&this.tags.length===this.config.maxSelections)return this.setMessage(this.config.messages.maxSelections.replace("{max}",this.config.maxSelections),!0),!1;this.selectedValues.push(R.value),this.selectedIndexes.push(N),(function(C){var d,h=this,l=document.createDocumentFragment(),n=this.options[C.idx],o=this.data?this.data[C.idx]:n,i={class:"selectr-tag"},o=(this.customSelected?i.html=this.config.renderSelection(o):i.textContent=n.textContent,D.createElement("li",i)),i=D.createElement("button",{class:"selectr-tag-remove",type:"button"});o.appendChild(i),o.idx=C.idx,o.tag=n.value,this.tags.push(o),this.config.sortSelected?(i=this.tags.slice(),d=function(a,r){a.replace(/(\d+)|(\D+)/g,function(e,t,s){r.push([t||1/0,s||""])})},i.sort(function(a,r){var e,t,s=[],c=[];for(h.config.sortSelected===!0?(e=a.tag,t=r.tag):h.config.sortSelected==="text"&&(e=a.textContent,t=r.textContent),d(e,s),d(t,c);s.length&&c.length;){var g=s.shift(),p=c.shift(),g=g[0]-p[0]||g[1].localeCompare(p[1]);if(g)return g}return s.length-c.length}),D.each(i,function(a,r){l.appendChild(r)}),this.label.innerHTML=""):l.appendChild(o),this.config.taggable?this.label.insertBefore(l,this.input.parentNode):this.label.appendChild(l)}).call(this,A)}else{var y=this.data?this.data[N]:R;this.customSelected?this.label.innerHTML=this.config.renderSelection(y):this.label.textContent=R.textContent,this.selectedValue=R.value,this.selectedIndex=N,D.each(this.options,function(C,d){var h=this.items[C];C!==N&&(h&&D.removeClass(h,"selected"),d.selected=!1,d.removeAttribute("selected"))},this)}D.includes(f,R)||this.el.add(R),A.setAttribute("aria-selected",!0),D.addClass(A,"selected"),D.addClass(this.container,"has-selected"),R.selected=!0,R.setAttribute("selected",""),this.emit("selectr.change",R),this.emit("selectr.select",R),"createEvent"in document?((y=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),y.__selfTriggered=!0,this.el.dispatchEvent(y)):this.el.fireEvent("onchange")},G.prototype.deselect=function(N,A){var f=this.items[N],R=this.options[N];if(this.el.multiple){var y=this.selectedIndexes.indexOf(N),y=(this.selectedIndexes.splice(y,1),this.selectedValues.indexOf(R.value));this.selectedValues.splice(y,1),(function(C){var d=!1;D.each(this.tags,function(h,l){l.idx===C.idx&&(d=l)},this),d&&(this.label.removeChild(d),this.tags.splice(this.tags.indexOf(d),1))}).call(this,f),this.tags.length||D.removeClass(this.container,"has-selected")}else{if(!A&&!this.config.clearable&&!this.config.allowDeselect)return!1;this.label.innerHTML="",this.selectedValue=null,this.el.selectedIndex=this.selectedIndex=-1,D.removeClass(this.container,"has-selected")}this.items[N].setAttribute("aria-selected",!1),D.removeClass(this.items[N],"selected"),R.selected=!1,R.removeAttribute("selected"),this.emit("selectr.change",null),this.emit("selectr.deselect",R),"createEvent"in document?((y=document.createEvent("HTMLEvents")).initEvent("change",!0,!0),y.__selfTriggered=!0,this.el.dispatchEvent(y)):this.el.fireEvent("onchange")},G.prototype.setValue=function(N){var A=Array.isArray(N);if(A||(N=N.toString().trim()),!this.el.multiple&&A)return!1;D.each(this.options,function(f,R){(A&&-1<N.indexOf(R.value)||R.value===N)&&this.change(R.idx)},this)},G.prototype.getValue=function(N,A){var f,R;return this.el.multiple?N?this.selectedIndexes.length&&(R={values:[]},D.each(this.selectedIndexes,function(y,C){C=this.options[C],R.values[y]={value:C.value,text:C.textContent}},this)):R=this.selectedValues.slice():R=N?{value:(f=this.options[this.selectedIndex]).value,text:f.textContent}:this.selectedValue,R=N&&A?JSON.stringify(R):R},G.prototype.add=function(N,A){if(N){if(this.data=this.data||[],this.items=this.items||[],this.options=this.options||[],Array.isArray(N))D.each(N,function(y,C){this.add(C,A)},this);else if(Object.prototype.toString.call(N)==="[object Object]"){if(A){var f=!1;if(D.each(this.options,function(y,C){C.value.toLowerCase()===N.value.toLowerCase()&&(f=!0)}),f)return!1}var R=D.createElement("option",N);return this.data.push(N),this.mobileDevice&&this.el.add(R),this.options.push(R),R.idx=0<this.options.length?this.options.length-1:0,j.call(this,R),N.selected&&this.select(R.idx),this.setPlaceholder(),R}return this.config.pagination&&this.paginate(),!0}},G.prototype.remove=function(N){var A,f=[];Array.isArray(N)?D.each(N,function(R,y){D.isInt(y)?f.push(this.getOptionByIndex(y)):typeof y=="string"&&f.push(this.getOptionByValue(y))},this):D.isInt(N)?f.push(this.getOptionByIndex(N)):typeof N=="string"&&f.push(this.getOptionByValue(N)),f.length&&(D.each(f,function(R,y){A=y.idx,this.el.remove(y),this.options.splice(A,1),y=this.items[A].parentNode,y&&y.removeChild(this.items[A]),this.items.splice(A,1),D.each(this.options,function(C,d){d.idx=C,this.items[C].idx=C},this)},this),this.setPlaceholder(),this.config.pagination)&&this.paginate()},G.prototype.removeAll=function(){this.clear(!0),D.each(this.el.options,function(N,A){this.el.remove(A)},this),D.truncate(this.tree),this.items=[],this.options=[],this.data=[],this.navIndex=0,this.requiresPagination&&(this.requiresPagination=!1,this.pageIndex=1,this.pages=[]),this.setPlaceholder()},G.prototype.search=function(N,A){var f,R,y,C,d;if(!this.navigating)return f=!1,N||(N=this.input.value,f=!0,this.removeMessage(),D.truncate(this.tree)),R=[],y=document.createDocumentFragment(),0<(N=N.trim().toLowerCase()).length?(C=A?D.startsWith:D.includes,D.each(this.options,function(h,l){var n,o,i,a,r=this.items[l.idx];C(l.textContent.trim().toLowerCase(),N)&&!l.disabled?(R.push({text:l.textContent,value:l.value}),f&&(k(r,y,this.customOption),D.removeClass(r,"excluded"),!this.customOption)&&(n=N,i=(l=l).textContent,n=new RegExp(n,"ig"),a=n.exec(i))&&(l.innerHTML="",(o=document.createElement("span")).classList.add("selectr-match"),o.textContent=a[0],l.appendChild(document.createTextNode(i.substring(0,a.index))),l.appendChild(o),l.appendChild(document.createTextNode(i.substring(n.lastIndex))))):f&&D.addClass(r,"excluded")},this),f&&(y.childElementCount?(A=this.items[this.navIndex],d=y.querySelector(".selectr-option:not(.excluded)"),this.noResults=!1,D.removeClass(A,"active"),this.navIndex=d.idx,D.addClass(d,"active")):this.config.taggable||(this.noResults=!0,this.setMessage(this.config.messages.noResults)),this.tree.appendChild(y))):H.call(this),R},G.prototype.toggle=function(){this.disabled||(this.opened?this.close():this.open())},G.prototype.open=function(){var N=this;if(!this.options.length)return!1;this.opened||this.emit("selectr.open"),this.opened=!0,this.mobileDevice||this.config.nativeDropdown?(D.addClass(this.container,"native-open"),this.config.data&&D.each(this.options,function(A,f){this.el.add(f)},this)):(D.addClass(this.container,"open"),H.call(this),this.invert(),this.tree.scrollTop=0,D.removeClass(this.container,"notice"),this.selected.setAttribute("aria-expanded",!0),this.tree.setAttribute("aria-hidden",!1),this.tree.setAttribute("aria-expanded",!0),this.config.searchable&&!this.config.taggable&&setTimeout(function(){N.input.focus(),N.input.tabIndex=0},10))},G.prototype.close=function(){var N;this.opened&&this.emit("selectr.close"),this.opened=!1,this.navigating=!1,this.mobileDevice||this.config.nativeDropdown?D.removeClass(this.container,"native-open"):(N=D.hasClass(this.container,"notice"),this.config.searchable&&!N&&(this.input.blur(),this.input.tabIndex=-1,this.searching=!1),N&&(D.removeClass(this.container,"notice"),this.notice.textContent=""),D.removeClass(this.container,"open"),D.removeClass(this.container,"native-open"),this.selected.setAttribute("aria-expanded",!1),this.tree.setAttribute("aria-hidden",!0),this.tree.setAttribute("aria-expanded",!1),D.truncate(this.tree),Y.call(this))},G.prototype.enable=function(){this.disabled=!1,this.el.disabled=!1,this.selected.tabIndex=this.originalIndex,this.el.multiple&&D.each(this.tags,function(N,A){A.lastElementChild.tabIndex=0}),D.removeClass(this.container,"selectr-disabled")},G.prototype.disable=function(N){N||(this.el.disabled=!0),this.selected.tabIndex=-1,this.el.multiple&&D.each(this.tags,function(A,f){f.lastElementChild.tabIndex=-1}),this.disabled=!0,D.addClass(this.container,"selectr-disabled")},G.prototype.reset=function(){this.disabled||(this.clear(),this.setSelected(!0),D.each(this.defaultSelected,function(N,A){this.select(A)},this),this.emit("selectr.reset"))},G.prototype.clear=function(N,A){var f;this.el.multiple?this.selectedIndexes.length&&(f=this.selectedIndexes.slice(),A?this.deselect(f.slice(-1)[0]):D.each(f,function(R,y){this.deselect(y)},this)):-1<this.selectedIndex&&this.deselect(this.selectedIndex,N),this.emit("selectr.clear")},G.prototype.serialise=function(N){var A=[];return D.each(this.options,function(f,R){var y={value:R.value,text:R.textContent};R.selected&&(y.selected=!0),R.disabled&&(y.disabled=!0),A[f]=y}),N?JSON.stringify(A):A},G.prototype.serialize=function(N){return this.serialise(N)},G.prototype.setPlaceholder=function(N){N=N||this.config.placeholder||this.el.getAttribute("placeholder"),this.options.length||(N=this.config.messages.noOptions),this.placeEl.innerHTML=N},G.prototype.paginate=function(){var N;if(this.items.length)return(N=this).pages=this.items.map(function(A,f){return f%N.config.pagination==0?N.items.slice(f,f+N.config.pagination):null}).filter(function(A){return A}),this.pages},G.prototype.setMessage=function(N,A){A&&this.close(),D.addClass(this.container,"notice"),this.notice.textContent=N},G.prototype.removeMessage=function(){D.removeClass(this.container,"notice"),this.notice.innerHTML=""},G.prototype.invert=function(){var N=D.rect(this.selected),A=this.tree.parentNode.offsetHeight,f=window.innerHeight;N.top+N.height+A>f?(D.addClass(this.container,"inverted"),this.isInverted=!0):(D.removeClass(this.container,"inverted"),this.isInverted=!1),this.optsRect=D.rect(this.tree)},G.prototype.getOptionByIndex=function(N){return this.options[N]},G.prototype.getOptionByValue=function(N){for(var A=!1,f=0,R=this.options.length;f<R;f++)if(this.options[f].value.trim()===N.toString().trim()){A=this.options[f];break}return A},le.exports=G},4188:function(le,m,D){D.d(m,{EX:function(){return k},WF:function(){return H},oW:function(){return j},qD:function(){return U}});var U=document.body,k=10485760,H=2e4,j=2147483648},2602:function(le,m,D){D.d(m,{w:function(){return k}});var U=D(9791);function k(H,j,z){var Y,G=3<arguments.length&&arguments[3]!==void 0&&arguments[3],N=typeof(f=H).getRootNode=="function"?f.getRootNode():window,A={},f=H.getBoundingClientRect(),R=j.getBoundingClientRect(),y=document.createElement("div");function C(){if(y&&y.parentNode){for(var h in y.parentNode.removeChild(y),A)l=h,Object.prototype.hasOwnProperty.call(A,l)&&((l=A[h])&&(0,U.removeEventListener)(N,h,l),delete A[h]);typeof z=="function"&&z(H)}var l}function d(h){(h=h.target)===y||(0,U.isChildOf)(h,y)||C()}return y.className="jsoneditor-anchor",y.style.position="absolute",y.style.left=f.left-R.left+"px",y.style.top=f.top-R.top+"px",y.style.width=f.width-2+"px",y.style.height=f.height-2+"px",y.style.boxSizing="border-box",j.appendChild(y),A.mousedown=(0,U.addEventListener)(N,"mousedown",d),A.mousewheel=(0,U.addEventListener)(N,"mousewheel",d),G&&(Y=null,y.onmouseover=function(){clearTimeout(Y),Y=null},y.onmouseout=function(){Y=Y||setTimeout(C,200)}),y.destroy=C,y}},7923:function(le){le.exports="data:application/javascript;base64,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"},7907:function(le,m,D){D.d(m,{Iu:function(){return N},cC:function(){return G},m0:function(){return Y}}),D(4987);var U={en:{array:"Array",auto:"Auto",appendText:"Append",appendTitle:"Append a new field with type 'auto' after this field (Ctrl+Shift+Ins)",appendSubmenuTitle:"Select the type of the field to be appended",appendTitleAuto:"Append a new field with type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascending",ascendingTitle:"Sort the childs of this ${type} in ascending order",actionsMenu:"Click to open the actions menu (Ctrl+M)",cannotParseFieldError:"Cannot parse field into JSON",cannotParseValueError:"Cannot parse value into JSON",collapseAll:"Collapse all fields",compactTitle:"Compact JSON data, remove all whitespaces (Ctrl+Shift+I)",descending:"Descending",descendingTitle:"Sort the childs of this ${type} in descending order",drag:"Drag to move this field (Alt+Shift+Arrows)",duplicateKey:"duplicate key",duplicateText:"Duplicate",duplicateTitle:"Duplicate selected fields (Ctrl+D)",duplicateField:"Duplicate this field (Ctrl+D)",duplicateFieldError:"Duplicate field name",empty:"empty",expandAll:"Expand all fields",expandTitle:`Click to expand/collapse this field (Ctrl+E). 
Ctrl+Click to expand/collapse including all childs.`,formatTitle:"Format JSON data, with proper indentation and line feeds (Ctrl+I)",insert:"Insert",insertTitle:"Insert a new field with type 'auto' before this field (Ctrl+Ins)",insertSub:"Select the type of the field to be inserted",object:"Object",ok:"Ok",redo:"Redo (Ctrl+Shift+Z)",removeText:"Remove",removeTitle:"Remove selected fields (Ctrl+Del)",removeField:"Remove this field (Ctrl+Del)",repairTitle:"Repair JSON: fix quotes and escape characters, remove comments and JSONP notation, turn JavaScript objects into JSON.",searchTitle:"Search fields and values",searchNextResultTitle:"Next result (Enter)",searchPreviousResultTitle:"Previous result (Shift + Enter)",selectNode:"Select a node...",showAll:"show all",showMore:"show more",showMoreStatus:"displaying ${visibleChilds} of ${totalChilds} items.",sort:"Sort",sortTitle:"Sort the childs of this ${type}",sortTitleShort:"Sort contents",sortFieldLabel:"Field:",sortDirectionLabel:"Direction:",sortFieldTitle:"Select the nested field by which to sort the array or object",sortAscending:"Ascending",sortAscendingTitle:"Sort the selected field in ascending order",sortDescending:"Descending",sortDescendingTitle:"Sort the selected field in descending order",string:"String",transform:"Transform",transformTitle:"Filter, sort, or transform the childs of this ${type}",transformTitleShort:"Filter, sort, or transform contents",extract:"Extract",extractTitle:"Extract this ${type}",transformQueryTitle:"Enter a JMESPath query",transformWizardLabel:"Wizard",transformWizardFilter:"Filter",transformWizardSortBy:"Sort by",transformWizardSelectFields:"Select fields",transformQueryLabel:"Query",transformPreviewLabel:"Preview",type:"Type",typeTitle:"Change the type of this field",openUrl:"Ctrl+Click or Ctrl+Enter to open url in new window",undo:"Undo last action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Field type "object". An object contains an unordered set of key/value pairs.',arrayType:'Field type "array". An array contains an ordered collection of values.',stringType:'Field type "string". Field type is not determined from the value, but always returned as string.',modeEditorTitle:"Switch Editor Mode",modeCodeText:"Code",modeCodeTitle:"Switch to code highlighter",modeFormText:"Form",modeFormTitle:"Switch to form editor",modeTextText:"Text",modeTextTitle:"Switch to plain text editor",modeTreeText:"Tree",modeTreeTitle:"Switch to tree editor",modeViewText:"View",modeViewTitle:"Switch to tree view",modePreviewText:"Preview",modePreviewTitle:"Switch to preview mode",examples:"Examples",default:"Default",containsInvalidProperties:"Contains invalid properties",containsInvalidItems:"Contains invalid items"},es:{array:"Matriz",auto:"Auto",appendText:"Agregar",appendTitle:"Agregue un nuevo campo con el tipo 'auto' después de este campo (Ctrl + Shift + Ins)",appendSubmenuTitle:"Seleccione el tipo de campo que se agregará",appendTitleAuto:"Agregue un nuevo campo con el tipo 'auto' (Ctrl + Shift + Ins)",ascending:"Ascendente",ascendingTitle:"Ordene los elementos secundarios de este ${type} en orden ascendente",actionsMenu:"Haga clic para abrir el menú de acciones (Ctrl + M)",cannotParseFieldError:"No se puede parsear el campo en JSON",cannotParseValueError:"No se puede parsear el valor en JSON",collapseAll:"Contraer todos los campos",compactTitle:"Compactar datos JSON, eliminar todos los espacios en blanco (Ctrl + Shift + I)",descending:"Descendente",descendingTitle:"Ordene los hijos de este ${type} en orden descendente",drag:"Arrastre para mover este campo (Alt + Mayús + Flechas)",duplicateKey:"llave duplicada",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos seleccionados (Ctrl + D)",duplicateField:"Duplicar este campo (Ctrl + D)",duplicateFieldError:"Nombre de campo duplicado",empty:"vacio",expandAll:"Expandir todos los campos",expandTitle:`Haga clic para expandir/contraer este campo (Ctrl + E). 
  Ctrl+Clic para expandir/contraer incluyendo todos los niños.`,formatTitle:"Formatee los datos JSON, con la sangría y los avances de línea adecuados (Ctrl + I)",insert:"Insertar",insertTitle:"Inserte un nuevo campo con el tipo 'auto' antes de este campo (Ctrl + Ins)",insertSub:"Seleccione el tipo de campo a insertar",object:"Objeto",ok:"Ok",redo:"Rehacer (Ctrl+Mayús+Z)",removeText:"Eliminar",removeTitle:"Eliminar campos seleccionados (Ctrl+Supr)",removeField:"Eliminar este campo (Ctrl+Supr)",repairTitle:"Reparar JSON: corrija comillas y caracteres de escape, elimine comentarios y notación JSONP, convierta objetos JavaScript en JSON.",searchTitle:"Campos de búsqueda y valores",searchNextResultTitle:"Siguiente resultado (Entrar)",searchPreviousResultTitle:"Resultado anterior (Shift + Enter)",selectNode:"Seleccione un nodo...",showAll:"mostrar todo",showMore:"mostrar más",showMoreStatus:"mostrando ${visibleChilds} de ${totalChilds} elementos.",sort:"Ordenar",sortTitle:"Ordene los hijos de este ${type}",sortTitleShort:"Ordenar contenidos",sortFieldLabel:"Campo:",sortDirectionLabel:"Dirección:",sortFieldTitle:"Seleccione el campo anidado por el cual ordenar la matriz u objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar el campo seleccionado en orden ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar por el campo seleccionado, en orden descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar o transformar los hijos de este ${type}",transformTitleShort:"Filtrar, ordenar o transformar contenidos",extract:"Extraer",extractTitle:"Extrae este ${type}",transformQueryTitle:"Ingrese una consulta JMESPath",transformWizardLabel:"Wizard",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Seleccione un campo",transformQueryLabel:"Consulta",transformPreviewLabel:"Vista Previa",type:"Tipo",typeTitle:"Cambiar el tipo de campo",openUrl:"Ctrl+Click o Ctrl+Enter para abrir la URL en una nueva ventana",undo:"Deshacer la última acción (Ctrl+Z)",validationCannotMove:"No se puede mover un campo a un hijo de sí mismo.",autoType:'Field type "auto". The field type is automatically determined from the value and can be a string, number, boolean, or null.',objectType:'Tipo de campo "objeto".  Un objeto contiene un conjunto desordenado de pares clave/valor.',arrayType:'Tipo de campo "matriz".  Una matriz contiene una colección ordenada de valores.',stringType:'Tipo de campo "cadena".  El tipo de campo no se determina a partir del valor,  pero siempre se devuelve como una cadena.',modeEditorTitle:"Cambiar modo de editor",modeCodeText:"Codigo",modeCodeTitle:"Cambiar al resaltador de código",modeFormText:"Formulario",modeFormTitle:"Cambiar al editor de formularios",modeTextText:"Texto",modeTextTitle:"Cambiar al editor de texto sin formato",modeTreeText:"Arbol",modeTreeTitle:"Cambiar al editor de árbol",modeViewText:"Vista",modeViewTitle:"Cambiar a la vista de árbol",modePreviewText:"Vista Previa",modePreviewTitle:"Cambiar al modo de vista previa",examples:"Ejemplos",default:"Predeterminado",containsInvalidProperties:"Contiene propiedades no validas",containsInvalidItems:"Contiene items no validos"},"zh-CN":{array:"数组",auto:"自动",appendText:"追加",appendTitle:"在此字段后追加一个类型为“auto”的新字段 (Ctrl+Shift+Ins)",appendSubmenuTitle:"选择要追加的字段类型",appendTitleAuto:"追加类型为“auto”的新字段 (Ctrl+Shift+Ins)",ascending:"升序",ascendingTitle:"升序排列${type}的子节点",actionsMenu:"点击打开动作菜单(Ctrl+M)",cannotParseFieldError:"无法将字段解析为JSON",cannotParseValueError:"无法将值解析为JSON",collapseAll:"缩进所有字段",compactTitle:"压缩JSON数据，删除所有空格 (Ctrl+Shift+I)",descending:"降序",descendingTitle:"降序排列${type}的子节点",drag:"拖拽移动该节点(Alt+Shift+Arrows)",duplicateKey:"重复键",duplicateText:"复制",duplicateTitle:"复制选中字段(Ctrl+D)",duplicateField:"复制该字段(Ctrl+D)",duplicateFieldError:"重复的字段名称",empty:"清空",expandAll:"展开所有字段",expandTitle:`点击 展开/收缩 该字段(Ctrl+E). 
Ctrl+Click 展开/收缩 包含所有子节点.`,formatTitle:"使用适当的缩进和换行符格式化JSON数据 (Ctrl+I)",insert:"插入",insertTitle:"在此字段前插入类型为“auto”的新字段 (Ctrl+Ins)",insertSub:"选择要插入的字段类型",object:"对象",ok:"Ok",redo:"重做 (Ctrl+Shift+Z)",removeText:"移除",removeTitle:"移除选中字段 (Ctrl+Del)",removeField:"移除该字段 (Ctrl+Del)",repairTitle:"修复JSON：修复引号和转义符，删除注释和JSONP表示法，将JavaScript对象转换为JSON。",selectNode:"选择一个节点...",showAll:"展示全部",showMore:"展示更多",showMoreStatus:"显示${totalChilds}的${visibleChilds}项目.",sort:"排序",sortTitle:"排序${type}的子节点",sortTitleShort:"内容排序",sortFieldLabel:"字段：",sortDirectionLabel:"方向：",sortFieldTitle:"选择用于对数组或对象排序的嵌套字段",sortAscending:"升序排序",sortAscendingTitle:"按照该字段升序排序",sortDescending:"降序排序",sortDescendingTitle:"按照该字段降序排序",string:"字符串",transform:"变换",transformTitle:"筛选，排序，或者转换${type}的子节点",transformTitleShort:"筛选，排序，或者转换内容",extract:"提取",extractTitle:"提取这个 ${type}",transformQueryTitle:"输入JMESPath查询",transformWizardLabel:"向导",transformWizardFilter:"筛选",transformWizardSortBy:"排序",transformWizardSelectFields:"选择字段",transformQueryLabel:"查询",transformPreviewLabel:"预览",type:"类型",typeTitle:"更改字段类型",openUrl:"Ctrl+Click 或者 Ctrl+Enter 在新窗口打开链接",undo:"撤销上次动作 (Ctrl+Z)",validationCannotMove:"无法将字段移入其子节点",autoType:'字段类型 "auto". 字段类型由值自动确定 可以为 string，number，boolean，或者 null.',objectType:'字段类型 "object". 对象包含一组无序的键/值对.',arrayType:'字段类型 "array". 数组包含值的有序集合.',stringType:'字段类型 "string". 字段类型由值自动确定，但始终作为字符串返回.',modeCodeText:"代码",modeCodeTitle:"切换至代码高亮",modeFormText:"表单",modeFormTitle:"切换至表单编辑",modeTextText:"文本",modeTextTitle:"切换至文本编辑",modeTreeText:"树",modeTreeTitle:"切换至树编辑",modeViewText:"视图",modeViewTitle:"切换至树视图",modePreviewText:"预览",modePreviewTitle:"切换至预览模式",examples:"例子",default:"缺省",containsInvalidProperties:"包含无效的属性",containsInvalidItems:"包含无效项目"},"pt-BR":{array:"Lista",auto:"Automatico",appendText:"Adicionar",appendTitle:"Adicionar novo campo com tipo 'auto' depois deste campo (Ctrl+Shift+Ins)",appendSubmenuTitle:"Selecione o tipo do campo a ser adicionado",appendTitleAuto:"Adicionar novo campo com tipo 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendente",ascendingTitle:"Organizar filhor do tipo ${type} em crescente",actionsMenu:"Clique para abrir o menu de ações (Ctrl+M)",cannotParseFieldError:"Não é possível analisar o campo no JSON",cannotParseValueError:"Não é possível analisar o valor em JSON",collapseAll:"Fechar todos campos",compactTitle:"Dados JSON compactos, remova todos os espaços em branco (Ctrl+Shift+I)",descending:"Descendente",descendingTitle:"Organizar o filhos do tipo ${type} em decrescente",duplicateKey:"chave duplicada",drag:"Arraste para mover este campo (Alt+Shift+Arrows)",duplicateText:"Duplicar",duplicateTitle:"Duplicar campos selecionados (Ctrl+D)",duplicateField:"Duplicar este campo (Ctrl+D)",duplicateFieldError:"Nome do campo duplicado",empty:"vazio",expandAll:"Expandir todos campos",expandTitle:`Clique para expandir/encolher este campo (Ctrl+E). 
Ctrl+Click para expandir/encolher incluindo todos os filhos.`,formatTitle:"Formate dados JSON, com recuo e feeds de linha adequados (Ctrl+I)",insert:"Inserir",insertTitle:"Inserir um novo campo do tipo 'auto' antes deste campo (Ctrl+Ins)",insertSub:"Selecionar o tipo de campo a ser inserido",object:"Objeto",ok:"Ok",redo:"Refazer (Ctrl+Shift+Z)",removeText:"Remover",removeTitle:"Remover campos selecionados (Ctrl+Del)",removeField:"Remover este campo (Ctrl+Del)",repairTitle:"Repare JSON: corrija aspas e caracteres de escape, remova comentários e notação JSONP, transforme objetos JavaScript em JSON.",selectNode:"Selecione um nódulo...",showAll:"mostrar todos",showMore:"mostrar mais",showMoreStatus:"exibindo ${visibleChilds} de ${totalChilds} itens.",sort:"Organizar",sortTitle:"Organizar os filhos deste ${type}",sortTitleShort:"Organizar os filhos",sortFieldLabel:"Campo:",sortDirectionLabel:"Direção:",sortFieldTitle:"Selecione um campo filho pelo qual ordenar o array ou objeto",sortAscending:"Ascendente",sortAscendingTitle:"Ordenar o campo selecionado por ordem ascendente",sortDescending:"Descendente",sortDescendingTitle:"Ordenar o campo selecionado por ordem descendente",string:"Texto",transform:"Transformar",transformTitle:"Filtrar, ordenar ou transformar os filhos deste ${type}",transformTitleShort:"Filtrar, ordenar ou transformar conteúdos",transformQueryTitle:"Insira uma expressão JMESPath",transformWizardLabel:"Assistente",transformWizardFilter:"Filtro",transformWizardSortBy:"Ordenar por",transformWizardSelectFields:"Selecionar campos",transformQueryLabel:"Expressão",transformPreviewLabel:"Visualizar",type:"Tipo",typeTitle:"Mudar o tipo deste campo",openUrl:"Ctrl+Click ou Ctrl+Enter para abrir link em nova janela",undo:"Desfazer último ação (Ctrl+Z)",validationCannotMove:"Não pode mover um campo como filho dele mesmo",autoType:'Campo do tipo "auto". O tipo do campo é determinao automaticamente a partir do seu valor e pode ser texto, número, verdade/falso ou nulo.',objectType:'Campo do tipo "objeto". Um objeto contém uma lista de pares com chave e valor.',arrayType:'Campo do tipo "lista". Uma lista contem uma coleção de valores ordenados.',stringType:'Campo do tipo "string". Campo do tipo nao é determinado através do seu valor, mas sempre retornara um texto.',examples:"Exemplos",default:"Revelia",containsInvalidProperties:"Contém propriedades inválidas",containsInvalidItems:"Contém itens inválidos"},tr:{array:"Dizin",auto:"Otomatik",appendText:"Ekle",appendTitle:"Bu alanın altına 'otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",appendSubmenuTitle:"Eklenecek alanın tipini seç",appendTitleAuto:"'Otomatik' tipinde yeni bir alan ekle (Ctrl+Shift+Ins)",ascending:"Artan",ascendingTitle:"${type}'ın alt tiplerini artan düzende sırala",actionsMenu:"Aksiyon menüsünü açmak için tıklayın (Ctrl+M)",collapseAll:"Tüm alanları kapat",descending:"Azalan",descendingTitle:"${type}'ın alt tiplerini azalan düzende sırala",drag:"Bu alanı taşımak için sürükleyin (Alt+Shift+Arrows)",duplicateKey:"Var olan anahtar",duplicateText:"Aşağıya kopyala",duplicateTitle:"Seçili alanlardan bir daha oluştur (Ctrl+D)",duplicateField:"Bu alandan bir daha oluştur (Ctrl+D)",duplicateFieldError:"Duplicate field name",cannotParseFieldError:"Alan JSON'a ayrıştırılamıyor",cannotParseValueError:"JSON'a değer ayrıştırılamıyor",empty:"boş",expandAll:"Tüm alanları aç",expandTitle:`Bu alanı açmak/kapatmak için tıkla (Ctrl+E). 
Alt alanlarda dahil tüm alanları açmak için Ctrl+Click `,insert:"Ekle",insertTitle:"Bu alanın üstüne 'otomatik' tipinde yeni bir alan ekle (Ctrl+Ins)",insertSub:"Araya eklenecek alanın tipini seç",object:"Nesne",ok:"Tamam",redo:"Yeniden yap (Ctrl+Shift+Z)",removeText:"Kaldır",removeTitle:"Seçilen alanları kaldır (Ctrl+Del)",removeField:"Bu alanı kaldır (Ctrl+Del)",selectNode:"Bir nesne seç...",showAll:"tümünü göster",showMore:"daha fazla göster",showMoreStatus:"${totalChilds} alanın ${visibleChilds} alt alanları gösteriliyor",sort:"Sırala",sortTitle:"${type}'ın alt alanlarını sırala",sortTitleShort:"İçerikleri sırala",sortFieldLabel:"Alan:",sortDirectionLabel:"Yön:",sortFieldTitle:"Diziyi veya nesneyi sıralamak için iç içe geçmiş alanı seçin",sortAscending:"Artan",sortAscendingTitle:"Seçili alanı artan düzende sırala",sortDescending:"Azalan",sortDescendingTitle:"Seçili alanı azalan düzende sırala",string:"Karakter Dizisi",transform:"Dönüştür",transformTitle:"${type}'ın alt alanlarını filtrele, sırala veya dönüştür",transformTitleShort:"İçerikleri filterele, sırala veya dönüştür",transformQueryTitle:"JMESPath sorgusu gir",transformWizardLabel:"Sihirbaz",transformWizardFilter:"Filtre",transformWizardSortBy:"Sırala",transformWizardSelectFields:"Alanları seç",transformQueryLabel:"Sorgu",transformPreviewLabel:"Önizleme",type:"Tip",typeTitle:"Bu alanın tipini değiştir",openUrl:"URL'i yeni bir pencerede açmak için Ctrl+Click veya Ctrl+Enter",undo:"Son değişikliği geri al (Ctrl+Z)",validationCannotMove:"Alt alan olarak taşınamıyor",autoType:'Alan tipi "otomatik". Alan türü otomatik olarak değerden belirlenirve bir dize, sayı, boolean veya null olabilir.',objectType:'Alan tipi "nesne". Bir nesne, sıralanmamış bir anahtar / değer çifti kümesi içerir.',arrayType:'Alan tipi "dizi". Bir dizi, düzenli değerler koleksiyonu içerir.',stringType:'Alan tipi "karakter dizisi". Alan türü değerden belirlenmez,ancak her zaman karakter dizisi olarak döndürülür.',modeCodeText:"Kod",modeCodeTitle:"Kod vurgulayıcıya geç",modeFormText:"Form",modeFormTitle:"Form düzenleyiciye geç",modeTextText:"Metin",modeTextTitle:"Düz metin düzenleyiciye geç",modeTreeText:"Ağaç",modeTreeTitle:"Ağaç düzenleyiciye geç",modeViewText:"Görünüm",modeViewTitle:"Ağaç görünümüne geç",examples:"Örnekler",default:"Varsayılan",containsInvalidProperties:"Geçersiz özellikler içeriyor",containsInvalidItems:"Geçersiz öğeler içeriyor"},ja:{array:"配列",auto:"オート",appendText:"追加",appendTitle:'次のフィールドに"オート"のフィールドを追加 (Ctrl+Shift+Ins)',appendSubmenuTitle:"追加するフィールドの型を選択してください",appendTitleAuto:'"オート"のフィールドを追加 (Ctrl+Shift+Ins)',ascending:"昇順",ascendingTitle:"${type}の子要素を昇順に並べ替え",actionsMenu:"クリックしてアクションメニューを開く (Ctrl+M)",collapseAll:"すべてを折りたたむ",descending:"降順",descendingTitle:"${type}の子要素を降順に並べ替え",drag:"ドラッグして選択中のフィールドを移動 (Alt+Shift+Arrows)",duplicateKey:"複製キー",duplicateText:"複製",duplicateTitle:"選択中のフィールドを複製 (Ctrl+D)",duplicateField:"選択中のフィールドを複製 (Ctrl+D)",duplicateFieldError:"フィールド名が重複しています",cannotParseFieldError:"JSONのフィールドを解析できません",cannotParseValueError:"JSONの値を解析できません",empty:"空",expandAll:"すべてを展開",expandTitle:`クリックしてフィールドを展開/折りたたむ (Ctrl+E). 
Ctrl+Click ですべての子要素を展開/折りたたむ`,insert:"挿入",insertTitle:"選択中のフィールドの前に新しいフィールドを挿入 (Ctrl+Ins)",insertSub:"挿入するフィールドの型を選択",object:"オブジェクト",ok:"実行",redo:"やり直す (Ctrl+Shift+Z)",removeText:"削除",removeTitle:"選択中のフィールドを削除 (Ctrl+Del)",removeField:"選択中のフィールドを削除 (Ctrl+Del)",selectNode:"ノードを選択...",showAll:"すべてを表示",showMore:"もっと見る",showMoreStatus:"${totalChilds}個のアイテムのうち ${visibleChilds}個を表示しています。",sort:"並べ替え",sortTitle:"${type}の子要素を並べ替え",sortTitleShort:"並べ替え",sortFieldLabel:"フィールド:",sortDirectionLabel:"順序:",sortFieldTitle:"配列またはオブジェクトを並び替えるためのフィールドを選択",sortAscending:"昇順",sortAscendingTitle:"選択中のフィールドを昇順に並び替え",sortDescending:"降順",sortDescendingTitle:"選択中のフィールドを降順に並び替え",string:"文字列",transform:"変換",transformTitle:"${type}の子要素をフィルター・並び替え・変換する",transformTitleShort:"内容をフィルター・並び替え・変換する",extract:"抽出",extractTitle:"${type}を抽出",transformQueryTitle:"JMESPathクエリを入力",transformWizardLabel:"ウィザード",transformWizardFilter:"フィルター",transformWizardSortBy:"並び替え",transformWizardSelectFields:"フィールドを選択",transformQueryLabel:"クエリ",transformPreviewLabel:"プレビュー",type:"型",typeTitle:"選択中のフィールドの型を変更",openUrl:"Ctrl+Click または Ctrl+Enter で 新規ウィンドウでURLを開く",undo:"元に戻す (Ctrl+Z)",validationCannotMove:"子要素に移動できません ",autoType:"オート： フィールドの型は値から自動的に決定されます。 (文字列・数値・ブール・null)",objectType:"オブジェクト： オブジェクトは順序が決まっていないキーと値のペア組み合わせです。",arrayType:"配列： 配列は順序が決まっている値の集合体です。",stringType:"文字列： フィールド型は値から決定されませんが、常に文字列として返されます。",modeCodeText:"コードモード",modeCodeTitle:"ハイライトモードに切り替え",modeFormText:"フォームモード",modeFormTitle:"フォームモードに切り替え",modeTextText:"テキストモード",modeTextTitle:"テキストモードに切り替え",modeTreeText:"ツリーモード",modeTreeTitle:"ツリーモードに切り替え",modeViewText:"ビューモード",modeViewTitle:"ビューモードに切り替え",modePreviewText:"プレビュー",modePreviewTitle:"プレビューに切り替え",examples:"例",default:"デフォルト",containsInvalidProperties:"無効なプロパティが含まれています",containsInvalidItems:"無効なアイテムが含まれています"},"fr-FR":{array:"Liste",auto:"Auto",appendText:"Ajouter",appendTitle:"Ajouter un champ de type 'auto' après ce champ (Ctrl+Shift+Ins)",appendSubmenuTitle:"Sélectionner le type du champ à ajouter",appendTitleAuto:"Ajouter un champ de type 'auto' (Ctrl+Shift+Ins)",ascending:"Ascendant",ascendingTitle:"Trier les enfants de ce ${type} par ordre ascendant",actionsMenu:"Ouvrir le menu des actions (Ctrl+M)",collapseAll:"Regrouper",descending:"Descendant",descendingTitle:"Trier les enfants de ce ${type} par ordre descendant",drag:"Déplacer (Alt+Shift+Arrows)",duplicateKey:"Dupliquer la clé",duplicateText:"Dupliquer",duplicateTitle:"Dupliquer les champs sélectionnés (Ctrl+D)",duplicateField:"Dupliquer ce champ (Ctrl+D)",duplicateFieldError:"Dupliquer le nom de champ",cannotParseFieldError:"Champ impossible à parser en JSON",cannotParseValueError:"Valeur impossible à parser en JSON",empty:"vide",expandAll:"Étendre",expandTitle:`Étendre/regrouper ce champ (Ctrl+E). 
Ctrl+Click pour étendre/regrouper avec tous les champs.`,insert:"Insérer",insertTitle:"Insérer un champ de type 'auto' avant ce champ (Ctrl+Ins)",insertSub:"Sélectionner le type de champ à insérer",object:"Objet",ok:"Ok",redo:"Rejouer (Ctrl+Shift+Z)",removeText:"Supprimer",removeTitle:"Supprimer les champs sélectionnés (Ctrl+Del)",removeField:"Supprimer ce champ (Ctrl+Del)",searchTitle:"Rechercher champs et valeurs",searchNextResultTitle:"Résultat suivant (Enter)",searchPreviousResultTitle:"Résultat précédent (Shift + Enter)",selectNode:"Sélectionner un nœud...",showAll:"voir tout",showMore:"voir plus",showMoreStatus:"${visibleChilds} éléments affichés de ${totalChilds}.",sort:"Trier",sortTitle:"Trier les champs de ce ${type}",sortTitleShort:"Trier",sortFieldLabel:"Champ:",sortDirectionLabel:"Direction:",sortFieldTitle:"Sélectionner les champs permettant de trier les listes et objet",sortAscending:"Ascendant",sortAscendingTitle:"Trier les champs sélectionnés par ordre ascendant",sortDescending:"Descendant",sortDescendingTitle:"Trier les champs sélectionnés par ordre descendant",string:"Chaîne",transform:"Transformer",transformTitle:"Filtrer, trier, or transformer les enfants de ce ${type}",transformTitleShort:"Filtrer, trier ou transformer le contenu",extract:"Extraire",extractTitle:"Extraire ce ${type}",transformQueryTitle:"Saisir une requête JMESPath",transformWizardLabel:"Assistant",transformWizardFilter:"Filtrer",transformWizardSortBy:"Trier par",transformWizardSelectFields:"Sélectionner les champs",transformQueryLabel:"Requête",transformPreviewLabel:"Prévisualisation",type:"Type",typeTitle:"Changer le type de ce champ",openUrl:"Ctrl+Click ou Ctrl+Enter pour ouvrir l'url dans une autre fenêtre",undo:"Annuler la dernière action (Ctrl+Z)",validationCannotMove:"Cannot move a field into a child of itself",autoType:'Champe de type "auto". Ce type de champ est automatiquement déterminé en fonction de la valeur et peut être de type "chaîne", "nombre", "booléen" ou null.',objectType:'Champ de type "objet". Un objet contient un ensemble non ordonné de paires clé/valeur.',arrayType:'Champ de type "liste". Une liste contient une collection ordonnée de valeurs.',stringType:`Champ de type "chaîne". Ce type de champ n'est pas déterminé en fonction de la valeur, mais retourne systématiquement une chaîne de caractères.`,modeEditorTitle:"Changer mode d'édition",modeCodeText:"Code",modeCodeTitle:"Activer surlignage code",modeFormText:"Formulaire",modeFormTitle:"Activer formulaire",modeTextText:"Texte",modeTextTitle:"Activer éditeur texte",modeTreeText:"Arbre",modeTreeTitle:"Activer éditeur arbre",modeViewText:"Lecture seule",modeViewTitle:"Activer vue arbre",modePreviewText:"Prévisualisation",modePreviewTitle:"Activer mode prévisualiser",examples:"Exemples",default:"Défaut",containsInvalidProperties:"Contient des propriétés non valides",containsInvalidItems:"Contient des éléments invalides"},de:{array:"Auflistung",auto:"Auto",appendText:"anhängen",appendTitle:"Fügen Sie nach diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Umschalt+Ein)",appendSubmenuTitle:"Wählen Sie den Typ des neuen Feldes",appendTitleAuto:"Ein neues Feld vom Typ 'auto' hinzufügen (Strg+Umschalt+Ein)",ascending:"Aufsteigend",ascendingTitle:"Sortieren Sie die Elemente dieses ${type} in aufsteigender Reihenfolge",actionsMenu:"Klicken Sie zum Öffnen des Aktionsmenüs (Strg+M)",cannotParseFieldError:"Feld kann nicht in JSON geparst werden",cannotParseValueError:"Wert kann nicht in JSON geparst werden",collapseAll:"Alle Felder zuklappen",compactTitle:"JSON-Daten verdichten, alle Leerzeichen entfernen (Strg+Umschalt+\\)",descending:"Absteigend",descendingTitle:"Sortieren Sie die Elemente dieses ${type} in absteigender Reihenfolge",drag:"Ziehen, um dieses Feld zu verschieben (Alt+Umschalt+Pfeile)",duplicateKey:"Doppelter Schlüssel",duplicateText:"Duplikat",duplicateTitle:"Ausgewählte Felder duplizieren (Strg+D)",duplicateField:"Dieses Feld duplizieren (Strg+D)",duplicateFieldError:"Doppelter Feldname",empty:"leer",expandAll:"Alle Felder anzeigen",expandTitle:`Klicken Sie, um dieses Feld zu erweitern/zu kollabieren (Strg+E). 
Strg+Klicken Sie, um dieses Feld einschließlich aller Elemente zu erweitern/zu kollabieren.`,formatTitle:"JSON-Daten mit korrekter Einrückung und Zeilenvorschüben formatieren (Strg+\\)",insert:"einfügen",insertTitle:"Fügen Sie vor diesem Feld ein neues Feld mit dem Typ 'auto' ein (Strg+Einfg)",insertSub:"Wählen Sie den Typ des neuen Feldes",object:"Objekt",ok:"Ok",redo:"Wiederholen (Strg+Umschalt+Z)",removeText:"entfernen",removeTitle:"Ausgewählte Felder entfernen (Strg+Entf)",removeField:"Dieses Feld entfernen (Strg+Entf)",repairTitle:"JSON reparieren: Anführungszeichen und Escape-Zeichen korrigieren, Kommentare und JSONP-Notation entfernen, JavaScript-Objekte in JSON umwandeln.",searchTitle:"Suchfelder und Werte",searchNextResultTitle:"Nächstes Ergebnis (Enter)",searchPreviousResultTitle:"Vorheriges Ergebnis (Umschalt + Eingabe)",selectNode:"Wählen Sie einen Knoten aus...",showAll:"alle anzeigen",showMore:"mehr anzeigen",showMoreStatus:"Anzeige von ${visibleChilds} von ${totalChilds}-Elementen.",sort:"Sortieren",sortTitle:"Sortieren Sie die Elemente dieses ${type}",sortTitleShort:"Inhalt sortieren",sortFieldLabel:"Feld:",sortDirectionLabel:"Richtung:",sortFieldTitle:"Wählen Sie das verschachtelte Feld, nach dem das Array oder Objekt sortiert werden soll.",sortAscending:"Aufsteigend",sortAscendingTitle:"Sortieren Sie das ausgewählte Feld in aufsteigender Reihenfolge",sortDescending:"Absteigend",sortDescendingTitle:"Sortieren Sie das ausgewählte Feld in absteigender Reihenfolge",string:"Zeichenfolge",transform:"Verwandeln",transformTitle:"Die Elemente dieses ${type} filtern, sortieren oder transformieren",transformTitleShort:"Inhalte filtern, sortieren oder transformieren",extract:"Auszug",extractTitle:"Extrahieren Sie diesen ${type}",transformQueryTitle:"Eine JMESPath-Abfrage eingeben",transformWizardLabel:"Zauberer",transformWizardFilter:"Filter",transformWizardSortBy:"Sortieren nach",transformWizardSelectFields:"Felder auswählen",transformQueryLabel:"Anfrage",transformPreviewLabel:"Vorschau",type:"Geben Sie  ein.",typeTitle:"Ändern Sie den Typ dieses Feldes",openUrl:"Strg+Klicken oder Strg+Eingabe, um die URL in einem neuen Fenster zu öffnen",undo:"Letzte Aktion rückgängig machen (Strg+Z)",validationCannotMove:"Kann ein Feld nicht in ein Kind seiner selbst verschieben",autoType:'Feldtyp "auto". Der Feldtyp wird automatisch aus dem Wert bestimmt und kann ein String, eine Zahl, boolesch oder null sein.',objectType:'Feldtyp "Objekt". Ein Objekt enthält eine ungeordnete Menge von Schlüssel/Wert-Paaren.',arrayType:'Feldtyp "Array". Ein Array enthält eine geordnete Sammlung von Werten.',stringType:'Feldtyp "Zeichenfolge". Der Feldtyp wird nicht aus dem Wert bestimmt, sondern immer als Zeichenfolge zurückgegeben.',modeEditorTitle:"Editor-Modus umschalten",modeCodeText:"Code",modeCodeTitle:"Umschalten auf Code-Highlighter",modeFormText:"Formular",modeFormTitle:"Zum Formular-Editor wechseln",modeTextText:"Text",modeTextTitle:"Zum Editor für einfachen Text wechseln",modeTreeText:"Baum",modeTreeTitle:"Zum Baum-Editor wechseln",modeViewText:"Siehe",modeViewTitle:"Zur Baumansicht wechseln",modePreviewText:"Vorschau",modePreviewTitle:"In den Vorschau-Modus wechseln",examples:"Beispiele",default:"Standardmäßig",containsInvalidProperties:"Enthält ungültige Eigenschaften",containsInvalidItems:"Enthält ungültige Elemente"},ru:{array:"Массив",auto:"Авто",appendText:"Добавить",appendTitle:"Добавить новое поле с типом 'авто' после этого поля (Ctrl+Shift+Ins)",appendSubmenuTitle:"Выбрать тип поля для добавления",appendTitleAuto:"Добавить новое поле с типом 'авто' (Ctrl+Shift+Ins)",ascending:"По возрастанию",ascendingTitle:"Сортировать ${type} по возрастанию",actionsMenu:"Нажмите для открытия меню действий (Ctrl+M)",cannotParseFieldError:"Невозможно преобразовать поле в JSON",cannotParseValueError:"Невозможно преобразовать значение в JSON",collapseAll:"Свернуть все",compactTitle:"Минификация JSON (Ctrl+Shift+I)",descending:"По убыванию",descendingTitle:"Сортировать ${type} по убыванию",drag:"Потяните для перемещения этого поля (Alt+Shift+Arrows)",duplicateKey:"повторяющийся ключ",duplicateText:"Дублировать",duplicateTitle:"Дублирование полей (Ctrl+D)",duplicateField:"Дублировать поле (Ctrl+D)",duplicateFieldError:"Дублирование названия поля",empty:"пустой",expandAll:"Развернуть все",expandTitle:`Нажмите для раскрытия/скрытия поля (Ctrl+E)
или Ctrl+Click для раскрытия/скрытия всех потомков.`,formatTitle:"Форматирование JSON (Ctrl+I)",insert:"Вставить",insertTitle:"Вставить новое поле с типом 'авто' перед этим полем (Ctrl+Ins)",insertSub:"Выбрать тип поля для вставки",object:"Объект",ok:"ОК",redo:"Повторить (Ctrl+Shift+Z)",removeText:"Удалить",removeTitle:"Удалить выбранные поля (Ctrl+Del)",removeField:"Удалить поле (Ctrl+Del)",repairTitle:"Восстановите JSON: исправьте кавычки и escape-символы, удалите комментарии и нотацию JSONP, модифицируйте объекты JavaScript в JSON.",searchTitle:"Поиск",searchNextResultTitle:"Следующий результат (Enter)",searchPreviousResultTitle:"Предыдущий результат (Shift + Enter)",selectNode:"Выбор узла...",showAll:"показать все",showMore:"больше",showMoreStatus:"${visibleChilds} из ${totalChilds}",sort:"Сортировка",sortTitle:"Сортировка потомков типа ${type}",sortTitleShort:"Сортировка содержимого",sortFieldLabel:"Поле:",sortDirectionLabel:"Направление:",sortFieldTitle:"Выберите поле для сортировки массива или объекта",sortAscending:"По возрастанию",sortAscendingTitle:"Сортировка выбранного поря по возрастанию",sortDescending:"По убыванию",sortDescendingTitle:"Сортировка выбранного поря по убыванию",string:"Строка",transform:"Модификация",transformTitle:"Фильтрация, сортировка или модификация данных типа ${type}",transformTitleShort:"Фильтрация, сортировка или модификация данных",extract:"Извлечение",extractTitle:"Извлечь тип ${type}",transformQueryTitle:"Введите JMESpath запрос",transformWizardLabel:"Мастер",transformWizardFilter:"Фильтр",transformWizardSortBy:"Сортировка",transformWizardSelectFields:"Поля",transformQueryLabel:"Запрос",transformPreviewLabel:"Просмотр",type:"Тип",typeTitle:"Изменить тип этого поля",openUrl:"Ctrl+Click или Ctrl+Enter для открытия url в новом окне",undo:"Отменить (Ctrl+Z)",validationCannotMove:"Поле не может быть перемещено в потомка",autoType:"Тип поля автоматически определяется по значению и может быть строкой, числом, логическим значением или null.",objectType:"Объект содержит неупорядоченный набор пар ключ/значение.",arrayType:"Массив содержит упорядоченный набор значений.",stringType:"Тип поля не определяется из значения, но всегда возвращается как строка.",modeEditorTitle:"Переключение режима редактора",modeCodeText:"Код",modeCodeTitle:"Переключить в режим редактора кода",modeFormText:"Форма",modeFormTitle:"Переключить в режим формы",modeTextText:"Текст",modeTextTitle:"Переключить в режим редактора текста",modeTreeText:"Дерево",modeTreeTitle:"Переключить в режим редактора дерева",modeViewText:"Просмотр дерева",modeViewTitle:"Переключить в режим просмотра дерева",modePreviewText:"Просмотр",modePreviewTitle:"Переключить в режим просмотра",examples:"Примеры",default:"По умолчанию",containsInvalidProperties:"Содержит недопустимые свойства",containsInvalidItems:"Содержит недопустимые элементы"},ko:{array:"배열",auto:"자동",appendText:"추가",appendTitle:'선택한 요소 아래에 "자동" 요소를 추가합니다. (Ctrl + Shift + Ins)',appendSubmenuTitle:"추가할 요소의 유형을 선택해주세요.",appendTitleAuto:'"자동" 요소를 추가합니다. (Ctrl + Shift + Ins)',ascending:"오름차순",ascendingTitle:"선택한 ${type}의 하위 요소를 오름차순 정렬합니다.",actionsMenu:"메뉴 열기 (Ctrl + M)",cannotParseFieldError:"JSON의 요소를 해석할 수 없습니다.",cannotParseValueError:"JSON의 값을 해석할 수 없습니다.",collapseAll:"모두 접기",compactTitle:"모든 공백을 제거하여 JSON 데이터를 작게 만듭니다. (Ctrl + Shift + I)",descending:"내림차순",descendingTitle:"선택한 ${type}의 하위 요소를 내림차순으로 정렬",drag:"드래그하여 요소를 이동합니다. (Alt + Shift + Arrows)",duplicateKey:"복제키",duplicateText:"복제",duplicateTitle:"선택한 요소를 복제합니다. (Ctrl + D)",duplicateField:"선택한 요소를 복제합니다. (Ctrl + D)",duplicateFieldError:"요소 이름이 중복되었습니다.",empty:"비어있음",expandAll:"모두 열기",expandTitle:`클릭하여 요소를 열거나 닫습니다. (Ctrl + E) 
Ctrl + Click으로 모든 하위 요소를 열거나 닫습니다.`,formatTitle:"적절한 들여쓰기 및 줄바꿈으로 JSON 데이터를 정형화합니다. (Ctrl + I)",insert:"삽입",insertTitle:"선택한 요소 위에 새요소를 삽입합니다. (Ctrl + Ins)",insertSub:"삽입할 요소의 유형을 선택해주세요.",object:"객체",ok:"확인",redo:"다시 실행 (Ctrl + Shift + Z)",removeText:"삭제",removeTitle:"선택한 요소를 삭제합니다. (Ctrl + Del)",removeField:"선택한 요소를 삭제합니다. (Ctrl + Del)",repairTitle:"JSON 교정: JSON 내의 주석과 JSONP 표기법을 지우고 따옴표와 이스케이프 문자를 수정합니다.",searchTitle:"요소 또는 값 찾기",searchNextResultTitle:"다음으로 찾기 (Enter)",searchPreviousResultTitle:"이전으로 찾기 (Shift + Enter)",selectNode:"요소를 선택해주세요...",showAll:"모두보기",showMore:"더보기",showMoreStatus:"${totalChilds} 개의 항목 중 ${visibleChilds} 개를 표시합니다.",sort:"정렬",sortTitle:"선택한 ${type}의 하위 요소를 정렬합니다.",sortTitleShort:"정렬",sortFieldLabel:"요소:",sortDirectionLabel:"순서:",sortFieldTitle:"배열이나 객체를 정렬하는 요소를 선택해주세요.",sortAscending:"오름차순",sortAscendingTitle:"선택한 요소를 오름차순으로 정렬합니다.",sortDescending:"내림차순",sortDescendingTitle:"선택한 요소를 내림차순으로 정렬합니다.",string:"문자",transform:"변환",transformTitle:"선택한 ${type}의 하위 요소를 필터하거나 정렬 또는 변환합니다.",transformTitleShort:"내용을 필터하거나 정렬 또는 변환합니다.",extract:"추출",extractTitle:"선택한 ${type}의 값을 최상위에 위치시킵니다.",transformQueryTitle:"JMESPath 쿼리를 입력해주세요.",transformWizardLabel:"마법사",transformWizardFilter:"필터",transformWizardSortBy:"정렬",transformWizardSelectFields:"요소를 선택해주세요.",transformQueryLabel:"쿼리",transformPreviewLabel:"미리보기",type:"유형",typeTitle:"선택한 요소의 유형을 변경합니다.",openUrl:"Ctrl + Click 또는 Ctrl + Enter로 새 창에서 URL 열기",undo:"실행 취소 (Ctrl + Z)",validationCannotMove:"하위 요소로 이동할 수 없습니다.",autoType:"자동: 요소의 형식이 값의 유형으로 결정됩니다. 문자, 숫자, 부울, 또는 null만 허용됩니다.",objectType:"객체: 순서대로 나열되지 않은 이름/값 쌍으로 이루어진 집합입니다.",arrayType:"배열: 순서대로 나열된 값의 집합입니다.",stringType:"문자: 요소의 유형이 값에서 결정되지 않지만 항상 문자로 반환됩니다.",modeEditorTitle:"편집기 유형 변경",modeCodeText:"코드",modeCodeTitle:"형식 교정을 도와주는 기능이 포함된 문자 편집기",modeFormText:"입력 양식",modeFormTitle:"정해진 요소에 값을 입력하는 편집기",modeTextText:"문자",modeTextTitle:"단순 문자 편집기",modeTreeText:"트리",modeTreeTitle:"트리 구조로 표시되는 편집기",modeViewText:"보기",modeViewTitle:"읽기전용 트리 구조로 JSON을 표시",modePreviewText:"미리보기",modePreviewTitle:"읽기전용 문자로 JSON을 표시",examples:"예제",default:"기본값",containsInvalidProperties:"잘못된 속성이 포함되어 있습니다.",containsInvalidItems:"잘못된 항목이 포함되어 있습니다"}},k=Object.keys(U),H="en",j=typeof navigator<"u"?navigator.language||navigator.userLanguage:void 0,z=k.find(function(A){return A===j})||H;function Y(A){var f;A&&((f=k.find(function(R){return R===A}))?z=f:console.error("Language not found"))}function G(A){if(A)for(var f in A)(function(R){k.find(function(y){return y===R})||k.push(R),U[R]=Object.assign({},U[H],U[R],A[R])})(f)}function N(A,f,R){var y=U[R=R||z][A]||U[H][A]||A;if(f)for(var C in f)y=y.replace("${"+C+"}",f[C]);return y}},6056:function(le,U,D){D.d(U,{J:function(){return z},r:function(){return j}});var U=D(5156),k=D.n(U),H=D(9791);function j(Y,R){var N,A=R.sort,f=R.filter,R=R.projection,y="";return f?(N=f.field!=="@"?["0"].concat((0,H.parsePath)("."+f.field)):["0"],N=typeof(0,H.get)(Y,N)=="string"?f.value:(0,H.parseString)(f.value),y+="[? "+f.field+" "+f.relation+" `"+JSON.stringify(N)+"`]"):y+=Array.isArray(Y)?"[*]":"@",A&&(A.direction==="desc"?y+=" | reverse(sort_by(@, &"+A.field+"))":y+=" | sort_by(@, &"+A.field+")"),R&&(y[y.length-1]!=="]"&&(y+=" | [*]"),R.fields.length===1?y+="."+R.fields[0]:1<R.fields.length&&(y+=".{"+R.fields.map(function(C){var d=C.split(".");return d[d.length-1]+": "+C}).join(", ")+"}")),y}function z(Y,G){return k().search(Y,G)}},4987:function(){function le(m){m===void 0||"remove"in m||Object.defineProperty(m,"remove",{configurable:!0,enumerable:!0,writable:!0,value:function(){this.parentNode!==void 0&&this.parentNode.removeChild(this)}})}typeof Element<"u"&&(window.Element!==void 0&&le(window.Element.prototype),window.CharacterData!==void 0&&le(window.CharacterData.prototype),window.DocumentType!==void 0)&&le(window.DocumentType.prototype),Array.prototype.findIndex||Object.defineProperty(Array.prototype,"findIndex",{value:function(m){for(var D=0;D<this.length;D++){var U=this[D];if(m.call(this,U,D,this))return D}return-1},configurable:!0,writable:!0}),Array.prototype.find||Object.defineProperty(Array.prototype,"find",{value:function(m){return m=this.findIndex(m),this[m]},configurable:!0,writable:!0}),String.prototype.trim||(String.prototype.trim=function(){return this.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")})},341:function(le,h,d){d.r(h),d.d(h,{previewModeMixins:function(){return l}});var U=d(1262),k=d(4188),H=d(6436),j=d(2474);function z(n){return(z=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(o){return typeof o}:function(o){return o&&typeof Symbol=="function"&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o})(n)}function Y(n,o){for(var i=0;i<o.length;i++){var a=o[i];a.enumerable=a.enumerable||!1,a.configurable=!0,"value"in a&&(a.writable=!0),Object.defineProperty(n,function(r){return r=function(e,t){if(z(e)!=="object"||e===null)return e;var s=e[Symbol.toPrimitive];if(s===void 0)return(t==="string"?String:Number)(e);if(s=s.call(e,t||"default"),z(s)!=="object")return s;throw new TypeError("@@toPrimitive must return a primitive value.")}(r,"string"),z(r)==="symbol"?r:String(r)}(a.key),a)}}var G=function(){function n(a,r,e){if(!(this instanceof n))throw new TypeError("Cannot call a class as a function");this.onChange=a,this.calculateItemSize=r||function(){return 1},this.limit=e,this.items=[],this.index=-1}var o,i;return o=n,(i=[{key:"add",value:function(a){for(;this._calculateHistorySize()>this.limit&&1<this.items.length;)this.items.shift(),this.index--;this.items=this.items.slice(0,this.index+1),this.items.push(a),this.index++,this.onChange()}},{key:"_calculateHistorySize",value:function(){var a=this.calculateItemSize,r=0;return this.items.forEach(function(e){r+=a(e)}),r}},{key:"undo",value:function(){if(this.canUndo())return this.index--,this.onChange(),this.items[this.index]}},{key:"redo",value:function(){if(this.canRedo())return this.index++,this.onChange(),this.items[this.index]}},{key:"canUndo",value:function(){return 0<this.index}},{key:"canRedo",value:function(){return this.index<this.items.length-1}},{key:"clear",value:function(){this.items=[],this.index=-1,this.onChange()}}])&&Y(o.prototype,i),Object.defineProperty(o,"prototype",{writable:!1}),n}(),N=d(7907),A=d(6056),f=d(6617),R=d(6210),y=d(2558),h=d(8458),C=d(9791),d=h.textModeMixins[0].mixin,h={create:function(a){var o=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{},i=(o.statusBar===void 0&&(o.statusBar=!0),o.mainMenuBar=o.mainMenuBar!==!1,o.enableSort=o.enableSort!==!1,o.enableTransform=o.enableTransform!==!1,o.createQuery=o.createQuery||A.r,o.executeQuery=o.executeQuery||A.J,typeof(this.options=o).indentation=="number"?this.indentation=Number(o.indentation):this.indentation=2,(0,N.cC)(this.options.languages),(0,N.m0)(this.options.language),this.mode="preview",this),a=(this.container=a,this.dom={},this.json=void 0,this.text="",this._debouncedValidate=(0,C.debounce)(this.validate.bind(this),this.DEBOUNCE_INTERVAL),this.width=a.clientWidth,this.height=a.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-preview",this.frame.onclick=function(r){r.preventDefault()},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null}),a=(this.frameFocusTracker=new j.R(a),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.dom.busy=document.createElement("div"),this.dom.busy.className="jsoneditor-busy",this.dom.busyContent=document.createElement("span"),this.dom.busyContent.textContent="busy...",this.dom.busy.appendChild(this.dom.busyContent),this.content.appendChild(this.dom.busy),this.dom.previewContent=document.createElement("pre"),this.dom.previewContent.className="jsoneditor-preview",this.dom.previewText=document.createTextNode(""),this.dom.previewContent.appendChild(this.dom.previewText),this.content.appendChild(this.dom.previewContent),this.options.mainMenuBar&&((0,C.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(a=document.createElement("button")).type="button",a.className="jsoneditor-format",a.title=(0,N.Iu)("formatTitle"),this.menu.appendChild(a),a.onclick=function(){i.executeWithBusyMessage(function(){try{i.format()}catch(r){i._onError(r)}},"formatting...")},(a=document.createElement("button")).type="button",a.className="jsoneditor-compact",a.title=(0,N.Iu)("compactTitle"),this.menu.appendChild(a),a.onclick=function(){i.executeWithBusyMessage(function(){try{i.compact()}catch(r){i._onError(r)}},"compacting...")},this.options.enableSort&&((a=document.createElement("button")).type="button",a.className="jsoneditor-sort",a.title=(0,N.Iu)("sortTitleShort"),a.onclick=function(){i._showSortModal()},this.menu.appendChild(a)),this.options.enableTransform&&((a=document.createElement("button")).type="button",a.title=(0,N.Iu)("transformTitleShort"),a.className="jsoneditor-transform",a.onclick=function(){i._showTransformModal()},this.dom.transform=a,this.menu.appendChild(a)),(a=document.createElement("button")).type="button",a.className="jsoneditor-repair",a.title=(0,N.Iu)("repairTitle"),this.menu.appendChild(a),!(a.onclick=function(){i.json===void 0&&i.executeWithBusyMessage(function(){try{i.repair()}catch(r){i._onError(r)}},"repairing...")})!==this.options.history&&(this.history=new G(function(){i.dom.undo.disabled=!i.history.canUndo(),i.dom.redo.disabled=!i.history.canRedo()},function(r){return 2*r.text.length},k.oW),(a=document.createElement("button")).type="button",a.className="jsoneditor-undo jsoneditor-separator",a.title=(0,N.Iu)("undo"),a.onclick=function(){var r=i.history.undo();r&&i._applyHistory(r)},this.menu.appendChild(a),this.dom.undo=a,(a=document.createElement("button")).type="button",a.className="jsoneditor-redo",a.title=(0,N.Iu)("redo"),a.onclick=function(){var r=i.history.redo();r&&i._applyHistory(r)},this.menu.appendChild(a),this.dom.redo=a,this.history.onChange()),this.options)&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new f.x(this.menu,this.options.modes,this.options.mode,function(r){try{i.setMode(r),i.modeSwitcher.focus()}catch(e){i._onError(e)}})),Array.isArray(this.options.showErrorTable)?this.options.showErrorTable.includes(this.mode):this.options.showErrorTable===!0);this.errorTable=new H.Q({errorTableVisible:a,onToggleVisibility:function(){i.validate()},onFocusLine:null,onChangeHeight:function(r){r=r+(i.dom.statusBar?i.dom.statusBar.clientHeight:0)+1,i.content.style.marginBottom=-r+"px",i.content.style.paddingBottom=r+"px"}}),this.frame.appendChild(this.content),this.frame.appendChild(this.errorTable.getErrorTable()),this.container.appendChild(this.frame),o.statusBar&&((0,C.addClassName)(this.content,"has-status-bar"),a=document.createElement("div"),(this.dom.statusBar=a).className="jsoneditor-statusbar",this.frame.appendChild(a),this.dom.fileSizeInfo=document.createElement("span"),this.dom.fileSizeInfo.className="jsoneditor-size-info",this.dom.fileSizeInfo.innerText="",a.appendChild(this.dom.fileSizeInfo),this.dom.arrayInfo=document.createElement("span"),this.dom.arrayInfo.className="jsoneditor-size-info",this.dom.arrayInfo.innerText="",a.appendChild(this.dom.arrayInfo),a.appendChild(this.errorTable.getErrorCounter()),a.appendChild(this.errorTable.getWarningIcon()),a.appendChild(this.errorTable.getErrorIcon())),this._renderPreview(),this.setSchema(this.options.schema,this.options.schemaRefs)},_renderPreview:function(){var n=this.getText();this.dom.previewText.nodeValue=(0,C.limitCharacters)(n,k.WF),this.dom.fileSizeInfo&&(this.dom.fileSizeInfo.innerText="Size: "+(0,C.formatSize)(n.length)),this.dom.arrayInfo&&(Array.isArray(this.json)?this.dom.arrayInfo.innerText="Array: "+this.json.length+" items":this.dom.arrayInfo.innerText="")},_onChange:function(){if(this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(n){console.error("Error in onChange callback: ",n)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(n){console.error("Error in onChangeJSON callback: ",n)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(n){console.error("Error in onChangeText callback: ",n)}}},l=(h._showSortModal=function(){var n=this;this.executeWithBusyMessage(function(){var o=n.options.modalAnchor||k.qD,i=n.get();n._renderPreview(),(0,R.showSortModal)(o,i,function(a){n.executeWithBusyMessage(function(){var r,e,t;r=i,e=a,Array.isArray(r)&&(t=(0,C.sort)(r,e.path,e.direction),n.sortedBy=e,n._setAndFireOnChange(t)),(0,C.isObject)(r)&&(t=(0,C.sortObjectKeys)(r,e.direction),n.sortedBy=e,n._setAndFireOnChange(t))},"sorting...")},n.sortedBy)},"parsing...")},h._showTransformModal=function(){var n=this;this.executeWithBusyMessage(function(){var r=n.options,o=r.createQuery,i=r.executeQuery,a=r.modalAnchor,r=r.queryDescription,e=n.get();n._renderPreview(),(0,y.showTransformModal)({container:a||k.qD,json:e,queryDescription:r,createQuery:o,executeQuery:i,onTransform:function(t){n.executeWithBusyMessage(function(){var s=i(e,t);n._setAndFireOnChange(s)},"transforming...")}})},"parsing...")},h.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this._debouncedValidate=null,this.history&&(this.history.clear(),this.history=null),this.frameFocusTracker.destroy()},h.compact=function(){var n=this.get(),o=JSON.stringify(n);this._setTextAndFireOnChange(o,n)},h.format=function(){var n=this.get(),o=JSON.stringify(n,null,this.indentation);this._setTextAndFireOnChange(o,n)},h.repair=function(){var n=this.getText();try{var o=(0,U.K)(n);this._setTextAndFireOnChange(o)}catch{}},h.focus=function(){this.dom.transform.focus()},h.set=function(n){this.history&&this.history.clear(),this._set(n)},h.update=function(n){this._set(n)},h._set=function(n){this.text=void 0,this.json=n,this._renderPreview(),this._pushHistory(),this._debouncedValidate()},h._setAndFireOnChange=function(n){this._set(n),this._onChange()},h.get=function(){var n;return this.json===void 0&&(n=this.getText(),this.json=(0,C.parse)(n)),this.json},h.getText=function(){return this.text===void 0&&(this.text=JSON.stringify(this.json,null,this.indentation),this.options.escapeUnicode===!0)&&(this.text=(0,C.escapeUnicodeChars)(this.text)),this.text},h.setText=function(n){this.history&&this.history.clear(),this._setText(n)},h.updateText=function(n){this.getText()!==n&&this._setText(n)},h._setText=function(n,o){var i;this.options.escapeUnicode===!0?this.text=(0,C.escapeUnicodeChars)(n):this.text=n,this.json=o,this._renderPreview(),this.json===void 0?(i=this).executeWithBusyMessage(function(){try{i.json=i.get(),i._renderPreview(),i._pushHistory()}catch{}},"parsing..."):this._pushHistory(),this._debouncedValidate()},h._setTextAndFireOnChange=function(n,o){this._setText(n,o),this._onChange()},h._applyHistory=function(n){this.json=n.json,this.text=n.text,this._renderPreview(),this._debouncedValidate()},h._pushHistory=function(){var n;this.history&&(n={text:this.text,json:this.json},this.history.add(n))},h.executeWithBusyMessage=function(n,o){var i;this.getText().length>k.EX?((0,C.addClassName)((i=this).frame,"busy"),i.dom.busyContent.innerText=o,setTimeout(function(){n(),(0,C.removeClassName)(i.frame,"busy"),i.dom.busyContent.innerText=""},100)):n()},h.validate=d.validate,h._renderErrors=d._renderErrors,[{mode:"preview",mixin:h,data:"json"}])},6210:function(le,U,D){D.r(U),D.d(U,{showSortModal:function(){return z}});var U=D(483),k=D.n(U),H=D(7907),j=D(9791);function z(Y,C,N,A){var f=Array.isArray(C)?(0,j.getChildPaths)(C):[""],R=A&&A.path&&(0,j.contains)(f,A.path)?A.path:f[0],y=A&&A.direction||"asc",C='<div class="pico-modal-contents"><div class="pico-modal-header">'+(0,H.Iu)("sort")+"</div><form><table><tbody><tr>  <td>"+(0,H.Iu)("sortFieldLabel")+' </td>  <td class="jsoneditor-modal-input">  <div class="jsoneditor-select-wrapper">    <select id="field" title="'+(0,H.Iu)("sortFieldTitle")+'">    </select>  </div>  </td></tr><tr>  <td>'+(0,H.Iu)("sortDirectionLabel")+' </td>  <td class="jsoneditor-modal-input">  <div id="direction" class="jsoneditor-button-group"><input type="button" value="'+(0,H.Iu)("sortAscending")+'" title="'+(0,H.Iu)("sortAscendingTitle")+'" data-value="asc" class="jsoneditor-button-first jsoneditor-button-asc"/><input type="button" value="'+(0,H.Iu)("sortDescending")+'" title="'+(0,H.Iu)("sortDescendingTitle")+'" data-value="desc" class="jsoneditor-button-last jsoneditor-button-desc"/>  </div>  </td></tr><tr><td colspan="2" class="jsoneditor-modal-input jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,H.Iu)("ok")+'" /></td></tr></tbody></table></form></div>';k()({parent:Y,content:C,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-sort"}).afterCreate(function(d){var h=d.modalElem().querySelector("form"),l=d.modalElem().querySelector("#ok"),n=d.modalElem().querySelector("#field"),o=d.modalElem().querySelector("#direction");function i(a){o.value=a,o.className="jsoneditor-button-group jsoneditor-button-group-value-"+o.value}f.forEach(function(a){var r,e=document.createElement("option");e.text=(r=a)===""?"@":r[0]==="."?r.slice(1):r,e.value=a,n.appendChild(e)}),n.value=R||f[0],i(y||"asc"),o.onclick=function(a){i(a.target.getAttribute("data-value"))},l.onclick=function(a){a.preventDefault(),a.stopPropagation(),d.close(),N({path:n.value,direction:o.value})},h&&(h.onsubmit=l.onclick)}).afterClose(function(d){d.destroy()}).show()}},2558:function(le,k,D){D.r(k),D.d(k,{showTransformModal:function(){return R}});var k=D(483),U=D.n(k),k=D(3879),H=D.n(k),j=D(7907);function z(y){return(z=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(C){return typeof C}:function(C){return C&&typeof Symbol=="function"&&C.constructor===Symbol&&C!==Symbol.prototype?"symbol":typeof C})(y)}function Y(y,C,d,h){if(typeof y=="boolean"||y instanceof Boolean||y===null||typeof y=="number"||y instanceof Number||typeof y=="string"||y instanceof String||y instanceof Date)return JSON.stringify(y);if(Array.isArray(y)){for(var l=y,n=C,o=d,i=h,a=n?o+n:void 0,r=n?`[
`:"[",e=0;e<l.length;e++){var t=l[e];if(n&&(r+=a),r+=t!==void 0&&typeof t!="function"?Y(t,n,a,i):"null",e<l.length-1&&(r+=n?`,
`:","),r.length>i)return r+"..."}return r+=n?`
`+o+"]":"]"}if(y&&z(y)==="object"){var s,c=y,p=C,o=d,g=h,b=p?o+p:void 0,w=!0,E=p?`{
`:"{";if(typeof c.toJSON=="function")return Y(c.toJSON(),p,o,g);for(s in c)if(function(O,x){return Object.prototype.hasOwnProperty.call(O,x)}(c,s)){var W=c[s];if(w?w=!1:E+=p?`,
`:",",(E=(E+=p?b+'"'+s+'": ':'"'+s+'":')+Y(W,p,b,g)).length>g)return E+"..."}return E+=p?`
`+o+"}":"}"}}function G(y,C){for(var d="";0<C--;)d+=y;return d}var N=D(9791),A=D(4188),f='Enter a <a href="http://jmespath.org" target="_blank">JMESPath</a> query to filter, sort, or transform the JSON data.<br/>To learn JMESPath, go to <a href="http://jmespath.org/tutorial.html" target="_blank">the interactive tutorial</a>.';function R(a){var C=a.container,d=a.json,h=a.queryDescription,h=h===void 0?f:h,l=a.createQuery,n=a.executeQuery,o=a.onTransform,i=d,a='<label class="pico-modal-contents"><div class="pico-modal-header">'+(0,j.Iu)("transform")+"</div><p>"+h+'</p><div class="jsoneditor-jmespath-label">'+(0,j.Iu)("transformWizardLabel")+' </div><div id="wizard" class="jsoneditor-jmespath-block jsoneditor-jmespath-wizard">  <table class="jsoneditor-jmespath-wizard-table">    <tbody>      <tr>        <th>'+(0,j.Iu)("transformWizardFilter")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-filter-field" >            <select id="filterField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-relation" >            <select id="filterRelation">              <option value="==">==</option>              <option value="!=">!=</option>              <option value="<">&lt;</option>              <option value="<=">&lt;=</option>              <option value=">">&gt;</option>              <option value=">=">&gt;=</option>            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-filter-value" >            <input type="text" class="value" placeholder="value..." id="filterValue" />          </div>        </td>      </tr>      <tr>        <th>'+(0,j.Iu)("transformWizardSortBy")+'</th>        <td class="jsoneditor-jmespath-filter">          <div class="jsoneditor-inline jsoneditor-jmespath-sort-field">            <select id="sortField">            </select>          </div>          <div class="jsoneditor-inline jsoneditor-jmespath-sort-order" >            <select id="sortOrder">              <option value="asc">Ascending</option>              <option value="desc">Descending</option>            </select>          </div>        </td>      </tr>      <tr id="selectFieldsPart">        <th>'+(0,j.Iu)("transformWizardSelectFields")+'</th>        <td class="jsoneditor-jmespath-filter">          <select class="jsoneditor-jmespath-select-fields" id="selectFields" multiple></select>        </td>      </tr>    </tbody>  </table></div><div class="jsoneditor-jmespath-label">'+(0,j.Iu)("transformQueryLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="query"             rows="4"             autocomplete="off"             autocorrect="off"             autocapitalize="off"             spellcheck="false"            title="'+(0,j.Iu)("transformQueryTitle")+'">[*]</textarea></div><div class="jsoneditor-jmespath-label">'+(0,j.Iu)("transformPreviewLabel")+' </div><div class="jsoneditor-jmespath-block">  <textarea id="preview"       class="jsoneditor-transform-preview"      readonly> </textarea></div><div class="jsoneditor-jmespath-block jsoneditor-modal-actions">  <input type="submit" id="ok" value="'+(0,j.Iu)("ok")+'" autofocus /></div></div>';U()({parent:C,content:a,overlayClass:"jsoneditor-modal-overlay",overlayStyles:{backgroundColor:"rgb(1,1,1)",opacity:.3},modalClass:"jsoneditor-modal jsoneditor-modal-transform",focus:!1}).afterCreate(function(r){var e=r.modalElem(),B=e.querySelector("#wizard"),t=e.querySelector("#ok"),s=e.querySelector("#filterField"),c=e.querySelector("#filterRelation"),p=e.querySelector("#filterValue"),g=e.querySelector("#sortField"),b=e.querySelector("#sortOrder"),w=e.querySelector("#selectFields"),E=e.querySelector("#query"),W=e.querySelector("#preview");Array.isArray(i)||(B.style.fontStyle="italic",B.textContent="(wizard not available for objects, only for arrays)"),(0,N.getChildPaths)(d).forEach(function(Q){var Q=v(Q),K=document.createElement("option"),K=(K.text=Q,K.value=Q,s.appendChild(K),document.createElement("option"));K.text=Q,K.value=Q,g.appendChild(K)});var B=(0,N.getChildPaths)(d,!0).filter(function(X){return X!==""}),B=(0<B.length?B.forEach(function(Q){var Q=v(Q),K=document.createElement("option");K.text=Q,K.value=Q,w.appendChild(K)}):(B=e.querySelector("#selectFieldsPart"))&&(B.style.display="none"),new(H())(s,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."})),O=new(H())(c,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"compare..."}),x=new(H())(g,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"field..."}),u=new(H())(b,{defaultSelected:!1,clearable:!0,allowDeselect:!0,placeholder:"order..."}),_=new(H())(w,{multiple:!0,clearable:!0,defaultSelected:!1,placeholder:"select fields..."});function v(X){return X===""?"@":X[0]==="."?X.slice(1):X}B.on("selectr.change",M),O.on("selectr.change",M),p.oninput=M,x.on("selectr.change",M),u.on("selectr.change",M),_.on("selectr.change",M),e.querySelector(".pico-modal-contents").onclick=function(X){X.target.nodeName!=="A"&&X.preventDefault()};var $=(0,N.debounce)(function(){try{var X=n(i,E.value);W.className="jsoneditor-transform-preview",W.value=(Q=X,K=2,ne=A.WF,typeof K=="number"?10<K?T=G(" ",10):1<=K&&(T=G(" ",K)):typeof K=="string"&&K!==""&&(T=K),(K=Y(Q,T,"",ne)).length>ne?(Q=K,(typeof(T=ne)=="number"?Q.slice(0,T):Q)+"..."):K),t.disabled=!1}catch(F){W.className="jsoneditor-transform-preview jsoneditor-error",W.value=F.toString(),t.disabled=!0}var Q,K,ne,T},300);function P(X,Q){try{E.value=l(X,Q),t.disabled=!1,$()}catch(K){X='Error: an error happened when executing "createQuery": '+(K.message||K.toString()),E.value="",t.disabled=!0,W.className="jsoneditor-transform-preview jsoneditor-error",W.value=X}}function M(){var X={};if(s.value&&c.value&&p.value&&(X.filter={field:s.value,relation:c.value,value:p.value}),g.value&&b.value&&(X.sort={field:g.value,direction:b.value}),w.value){for(var Q,K=[],ne=0;ne<w.options.length;ne++)w.options[ne].selected&&(Q=w.options[ne].value,K.push(Q));X.projection={fields:K}}P(d,X)}E.oninput=$,t.onclick=function(X){X.preventDefault(),X.stopPropagation(),r.close(),o(E.value)},P(d,{}),setTimeout(function(){E.select(),E.focus(),E.selectionStart=3,E.selectionEnd=3})}).afterClose(function(r){r.destroy()}).show()}},8458:function(le,o,D){D.r(o),D.d(o,{textModeMixins:function(){return r}});var U=D(1262),o=D(8170),k=D.n(o),H=D(4188),j=D(6436),z=D(2474),Y=D(7907),G=D(6056),N=D(6617),A=D(6210),f=D(2558),R=D(9125),y=D(7026),C=D(9791);function d(e){return(d=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(t){return typeof t}:function(t){return t&&typeof Symbol=="function"&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(e)}function h(e,t){for(var s=0;s<t.length;s++){var c=t[s];c.enumerable=c.enumerable||!1,c.configurable=!0,"value"in c&&(c.writable=!0),Object.defineProperty(e,function(p){return p=function(g,b){if(d(g)!=="object"||g===null)return g;var w=g[Symbol.toPrimitive];if(w===void 0)return(b==="string"?String:Number)(g);if(w=w.call(g,b||"default"),d(w)!=="object")return w;throw new TypeError("@@toPrimitive must return a primitive value.")}(p,"string"),d(p)==="symbol"?p:String(p)}(c.key),c)}}var l=function(){function e(c,p){if(!(this instanceof e))throw new TypeError("Cannot call a class as a function");this.schema=c,this.schemaRefs=p||{},this.suggestions={},this.suggestionsRefs={},this._buildSuggestions()}var t,s;return t=e,(s=[{key:"_buildSuggestions",value:function(){for(var c in this._handleSchemaEntry("",this.schema,this.suggestions),this.schemaRefs)this.suggestionsRefs[c]={},this._handleSchemaEntry("",this.schemaRefs[c],this.suggestionsRefs[c])}},{key:"_handleRef",value:function(c,p,g){g[c]=g[c]||{},g[c].refs=g[c].refs||[],g[c].refs=(0,C.uniqueMergeArrays)(g[c].refs,[p])}},{key:"_handleSchemaEntry",value:function(c,p,g){if(p)if(p.$ref)this._handleRef(c,p.$ref,g);else{var b=this._checkOfConditon(p);if(b)this._handleOfCondition(c,p[b],g);else switch(p.type){case"object":this._handleObject(c,p,g);break;case"string":case"number":case"integer":this._handlePrimitive(c,p,g);break;case"boolean":this._handleBoolean(c,p,g);break;case"array":this._handleArray(c,p,g)}}else console.error("SchemaTextCompleter: schema node is missing for path",c)}},{key:"_handleObject",value:function(c,p,g){var b,w=this;(0,C.isObject)(p.properties)&&(b=Object.keys(p.properties),g[c]=g[c]||{},g[c].props=g[c].props||[],g[c].props=(0,C.uniqueMergeArrays)(g[c].props,b),b.forEach(function(E){(0,C.asyncExec)(function(){w._handleSchemaEntry("".concat(c,"/").concat(E),p.properties[E],g)})}))}},{key:"_handlePrimitive",value:function(c,p,g){g[c]=g[c]||{},(0,C.isArray)(p.examples)&&(g[c].examples=g[c].examples||[],g[c].examples=(0,C.uniqueMergeArrays)(g[c].examples,p.examples)),(0,C.isArray)(p.enum)&&(g[c].enum=g[c].enum||[],g[c].enum=(0,C.uniqueMergeArrays)(g[c].enum,p.enum))}},{key:"_handleBoolean",value:function(c,p,g){g[c]||(g[c]={bool:[!0,!1]})}},{key:"_handleArray",value:function(c,p,g){var b=this;p.items&&(0,C.asyncExec)(function(){b._handleSchemaEntry("".concat(c,"/\\d+"),p.items,g)})}},{key:"_handleOfCondition",value:function(c,p,g){var b=this;p&&p.length&&p.forEach(function(w){(0,C.asyncExec)(function(){b._handleSchemaEntry(c,w,g)})})}},{key:"_checkOfConditon",value:function(c){if(c)return c.oneOf?"oneOf":c.anyOf?"anyOf":c.allOf?"allOf":void 0}},{key:"getCompletions",value:function(c,p,g,b,w){var E=this;try{var W=y.parse(p.getValue()).pointers||{},B=function(O){function x(v){var $,P={props:"property",enum:"enum",bool:"boolean",examples:"examples"};O&&($=O[v])!=null&&$.length&&(u=u.concat(O[v].map(function(M){return{caption:M+"",meta:"schema [".concat(P[v],"]"),score:_++,value:M+""}})))}var u=[],_=0;x("props"),x("enum"),x("bool"),x("examples"),u.length&&w(null,u)};Object.keys(W).forEach(function(O){(0,C.asyncExec)(function(){function x(v,$,P){var M,X=Object.keys($).reduce(function(T,F){return new RegExp("^".concat(P).concat(F)).test(v)&&(!T||T.length<F.length)?F:T});if(typeof X=="string"){if((M=$[X])!=null&&(M=M.refs)!=null&&M.length){var Q,K={};for(Q in $[X].refs){var ne=$[X].refs[Q];E.suggestionsRefs[ne]&&((ne=x(v,E.suggestionsRefs[ne],"".concat(P).concat(X)))!=null&&ne.enum&&(K.enum=(0,C.uniqueMergeArrays)(K.enum,ne.enum)),ne!=null&&ne.examples&&(K.examples=(0,C.uniqueMergeArrays)(K.examples,ne.examples)),ne!=null&&ne.bool&&(K.bool=(0,C.uniqueMergeArrays)(K.bool,ne.bool)),ne!=null)&&ne.props&&(K.props=(0,C.uniqueMergeArrays)(K.props,ne.props))}return K}if(new RegExp("^".concat(P).concat(X,"$")).test(v))return $[X]}}var u,_;((_=W[O].key)==null?void 0:_.line)===g.row&&g.column>=W[O].key.column&&g.column<=W[O].keyEnd.column&&(u=O.slice(0,O.lastIndexOf("/"))),(u=((_=W[O].value)==null?void 0:_.line)===g.row&&((_=W[O].value)==null?void 0:_.line)===((_=W[O].valueEnd)==null?void 0:_.line)&&g.column>=W[O].value.column&&g.column<=W[O].valueEnd.column?O:u)&&(_=x(u,E.suggestions,""),B(_))})})}catch{}}}])&&h(t.prototype,s),Object.defineProperty(t,"prototype",{writable:!1}),e}();function n(e){return(n=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(t){return typeof t}:function(t){return t&&typeof Symbol=="function"&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(e)}var o={},i="ace/theme/jsoneditor";function a(){try{this.format()}catch{}}o.create=function(w){var t,s,c,p=this,g=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{},E=(g.statusBar===void 0&&(g.statusBar=!0),g.mainMenuBar=g.mainMenuBar!==!1,g.enableSort=g.enableSort!==!1,g.enableTransform=g.enableTransform!==!1,g.createQuery=g.createQuery||G.r,g.executeQuery=g.executeQuery||G.J,g.showErrorTable=g.showErrorTable!==void 0?g.showErrorTable:["text","preview"],typeof(this.options=g).indentation=="number"?this.indentation=Number(g.indentation):this.indentation=2,(0,Y.cC)(this.options.languages),(0,Y.m0)(this.options.language),g.ace||k()),b=(this.mode=g.mode==="code"?"code":"text",this.mode==="code"&&E===void 0&&(this.mode="text",console.warn("Failed to load Ace editor, falling back to plain text mode. Please use a JSONEditor bundle including Ace, or pass Ace as via the configuration option `ace`.")),this.theme=g.theme||i,this.theme===i&&E&&(0,R.O)(),g.onTextSelectionChange&&this.onTextSelectionChange(g.onTextSelectionChange),this),w=(this.container=w,this.dom={},this.aceEditor=void 0,this.textarea=void 0,this.validateSchema=null,this.annotations=[],this.lastSchemaErrors=void 0,this._debouncedValidate=(0,C.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),this.width=w.clientWidth,this.height=w.clientHeight,this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.frame.onclick=function(W){W.preventDefault()},this.frame.onkeydown=function(W){b._onKeyDown(W)},{target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null}),w=(this.frameFocusTracker=new z.R(w),this.content=document.createElement("div"),this.content.className="jsoneditor-outer",this.options.mainMenuBar&&((0,C.addClassName)(this.content,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(w=document.createElement("button")).type="button",w.className="jsoneditor-format",w.title=(0,Y.Iu)("formatTitle"),this.menu.appendChild(w),w.onclick=function(){try{b.format(),b._onChange()}catch(W){b._onError(W)}},(w=document.createElement("button")).type="button",w.className="jsoneditor-compact",w.title=(0,Y.Iu)("compactTitle"),this.menu.appendChild(w),w.onclick=function(){try{b.compact(),b._onChange()}catch(W){b._onError(W)}},this.options.enableSort&&((w=document.createElement("button")).type="button",w.className="jsoneditor-sort",w.title=(0,Y.Iu)("sortTitleShort"),w.onclick=function(){b._showSortModal()},this.menu.appendChild(w)),this.options.enableTransform&&((w=document.createElement("button")).type="button",w.title=(0,Y.Iu)("transformTitleShort"),w.className="jsoneditor-transform",w.onclick=function(){b._showTransformModal()},this.menu.appendChild(w)),(w=document.createElement("button")).type="button",w.className="jsoneditor-repair",w.title=(0,Y.Iu)("repairTitle"),this.menu.appendChild(w),w.onclick=function(){try{b.repair(),b._onChange()}catch(W){b._onError(W)}},this.mode==="code"&&((w=document.createElement("button")).type="button",w.className="jsoneditor-undo jsoneditor-separator",w.title=(0,Y.Iu)("undo"),w.onclick=function(){p.aceEditor.getSession().getUndoManager().undo()},this.menu.appendChild(w),this.dom.undo=w,(w=document.createElement("button")).type="button",w.className="jsoneditor-redo",w.title=(0,Y.Iu)("redo"),w.onclick=function(){p.aceEditor.getSession().getUndoManager().redo()},this.menu.appendChild(w),this.dom.redo=w),this.options&&this.options.modes&&this.options.modes.length&&(this.modeSwitcher=new N.x(this.menu,this.options.modes,this.options.mode,function(W){try{b.setMode(W),b.modeSwitcher.focus()}catch(B){b._onError(B)}})),this.mode==="code")&&((t=document.createElement("a")).appendChild(document.createTextNode("powered by ace")),t.href="https://ace.c9.io/",t.target="_blank",t.className="jsoneditor-poweredBy",t.onclick=function(){window.open(t.href,t.target,"noreferrer")},this.menu.appendChild(t)),this.options.onEditable&&n(this.options.onEditable==="function")&&!this.options.onEditable({})),E=(this.frame.appendChild(this.content),this.container.appendChild(this.frame),this.mode==="code"?(this.editorDom=document.createElement("div"),this.editorDom.style.height="100%",this.editorDom.style.width="100%",this.content.appendChild(this.editorDom),c=(E=E.edit(this.editorDom)).getSession(),E.$blockScrolling=1/0,E.setTheme(this.theme),E.setOptions({readOnly:w}),E.setShowPrintMargin(!1),E.setFontSize("14px"),c.setMode("ace/mode/json"),c.setTabSize(this.indentation),c.setUseSoftTabs(!0),c.setUseWrapMode(!0),s=c.setAnnotations,c.setAnnotations=function(W){s.call(this,W&&W.length?W:b.annotations)},E.commands.bindKey("Ctrl-L",null),E.commands.bindKey("Command-L",null),E.commands.bindKey("Ctrl-\\",null),E.commands.bindKey("Command-\\",null),E.commands.bindKey("Ctrl-Shift-\\",null),E.commands.bindKey("Command-Shift-\\",null),(this.aceEditor=E).on("change",this._onChange.bind(this)),E.on("changeSelection",this._onSelect.bind(this))):((c=document.createElement("textarea")).className="jsoneditor-text",c.spellcheck=!1,this.content.appendChild(c),this.textarea=c,this.textarea.readOnly=w,this.textarea.oninput===null?this.textarea.oninput=this._onChange.bind(this):this.textarea.onchange=this._onChange.bind(this),c.onselect=this._onSelect.bind(this),c.onmousedown=this._onMouseDown.bind(this),c.onblur=this._onBlur.bind(this)),this._updateHistoryButtons(),Array.isArray(this.options.showErrorTable)?this.options.showErrorTable.includes(this.mode):this.options.showErrorTable===!0);this.errorTable=new j.Q({errorTableVisible:E,onToggleVisibility:function(){b._validateAndCatch()},onFocusLine:function(W){b.isFocused=!0,isNaN(W)||b.setTextSelection({row:W,column:1},{row:W,column:1e3})},onChangeHeight:function(W){W=W+(b.dom.statusBar?b.dom.statusBar.clientHeight:0)+1,b.content.style.marginBottom=-W+"px",b.content.style.paddingBottom=W+"px"}}),this.frame.appendChild(this.errorTable.getErrorTable()),g.statusBar&&((0,C.addClassName)(this.content,"has-status-bar"),this.curserInfoElements={},w=document.createElement("div"),(this.dom.statusBar=w).className="jsoneditor-statusbar",this.frame.appendChild(w),(c=document.createElement("span")).className="jsoneditor-curserinfo-label",c.innerText="Ln:",(E=document.createElement("span")).className="jsoneditor-curserinfo-val",E.innerText="1",w.appendChild(c),w.appendChild(E),(g=document.createElement("span")).className="jsoneditor-curserinfo-label",g.innerText="Col:",(c=document.createElement("span")).className="jsoneditor-curserinfo-val",c.innerText="1",w.appendChild(g),w.appendChild(c),this.curserInfoElements.colVal=c,this.curserInfoElements.lnVal=E,(g=document.createElement("span")).className="jsoneditor-curserinfo-label",g.innerText="characters selected",g.style.display="none",(c=document.createElement("span")).className="jsoneditor-curserinfo-count",c.innerText="0",c.style.display="none",this.curserInfoElements.countLabel=g,this.curserInfoElements.countVal=c,w.appendChild(c),w.appendChild(g),w.appendChild(this.errorTable.getErrorCounter()),w.appendChild(this.errorTable.getWarningIcon()),w.appendChild(this.errorTable.getErrorIcon())),this.setSchema(this.options.schema,this.options.schemaRefs)},o._onSchemaChange=function(e,t){this.aceEditor&&(this.options.allowSchemaSuggestions&&e?(this.aceEditor.setOption("enableBasicAutocompletion",[new l(e,t)]),this.aceEditor.setOption("enableLiveAutocompletion",!0)):(this.aceEditor.setOption("enableBasicAutocompletion",void 0),this.aceEditor.setOption("enableLiveAutocompletion",!1)))},o._onChange=function(){var e=this;if(!this.onChangeDisabled){if(setTimeout(function(){e._updateHistoryButtons&&e._updateHistoryButtons()}),this._debouncedValidate(),this.options.onChange)try{this.options.onChange()}catch(t){console.error("Error in onChange callback: ",t)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(t){console.error("Error in onChangeText callback: ",t)}}},o._updateHistoryButtons=function(){var e;this.aceEditor&&this.dom.undo&&this.dom.redo&&(e=this.aceEditor.getSession().getUndoManager())&&e.hasUndo&&e.hasRedo&&(this.dom.undo.disabled=!e.hasUndo(),this.dom.redo.disabled=!e.hasRedo())},o._showSortModal=function(){try{var e=this,t=this.options.modalAnchor||H.qD,s=this.get();(0,A.showSortModal)(t,s,function(c){var p;Array.isArray(s)&&(p=(0,C.sort)(s,c.path,c.direction),e.sortedBy=c,e.update(p)),(0,C.isObject)(s)&&(p=(0,C.sortObjectKeys)(s,c.direction),e.sortedBy=c,e.update(p))},e.sortedBy)}catch(c){this._onError(c)}},o._showTransformModal=function(){var e=this;try{var t=this.options,s=t.modalAnchor,c=t.createQuery,p=t.executeQuery,g=t.queryDescription,b=this.get();(0,f.showTransformModal)({container:s||H.qD,json:b,queryDescription:g,createQuery:c,executeQuery:p,onTransform:function(w){w=p(b,w),e.update(w)}})}catch(w){this._onError(w)}},o._onSelect=function(){this._updateCursorInfo(),this._emitSelectionChange()},o._onKeyDown=function(e){var t=!1;(e.which||e.keyCode)===73&&e.ctrlKey&&(e.shiftKey?this.compact():this.format(),this._onChange(),t=!0),t&&(e.preventDefault(),e.stopPropagation()),this._updateCursorInfo(),this._emitSelectionChange()},o._onMouseDown=function(){this._updateCursorInfo(),this._emitSelectionChange()},o._onBlur=function(){var e=this;setTimeout(function(){e.isFocused||(e._updateCursorInfo(),e._emitSelectionChange()),e.isFocused=!1})},o._updateCursorInfo=function(){var e,t,s,c,p,g=this;function b(){g.curserInfoElements.countVal.innerText!==p&&(g.curserInfoElements.countVal.innerText=p,g.curserInfoElements.countVal.style.display=p?"inline":"none",g.curserInfoElements.countLabel.style.display=p?"inline":"none"),g.curserInfoElements.lnVal.innerText=s,g.curserInfoElements.colVal.innerText=c}this.textarea?setTimeout(function(){var w=(0,C.getInputSelection)(g.textarea);w.startIndex!==w.endIndex&&(p=w.endIndex-w.startIndex),c=(p&&g.cursorInfo&&g.cursorInfo.line===w.end.row&&g.cursorInfo.column===w.end.column?(s=w.start.row,w.start):(s=w.end.row,w.end)).column,g.cursorInfo={line:s,column:c,count:p},g.options.statusBar&&b()},0):this.aceEditor&&this.curserInfoElements&&(e=this.aceEditor.getCursorPosition(),t=this.aceEditor.getSelectedText(),s=e.row+1,c=e.column+1,p=t.length,g.cursorInfo={line:s,column:c,count:p},this.options.statusBar)&&b()},o._emitSelectionChange=function(){var e;this._selectionChangedHandler&&(e=this.getTextSelection(),this._selectionChangedHandler(e.start,e.end,e.text))},o._refreshAnnotations=function(){var e,t=this.aceEditor&&this.aceEditor.getSession();t&&(e=t.getAnnotations().filter(function(s){return s.type==="error"}),t.setAnnotations(e))},o.destroy=function(){this.aceEditor&&(this.aceEditor.destroy(),this.aceEditor=null),this.frame&&this.container&&this.frame.parentNode===this.container&&this.container.removeChild(this.frame),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.textarea=null,this._debouncedValidate=null,this.frameFocusTracker.destroy()},o.compact=function(){var e=this.get(),e=JSON.stringify(e);this.updateText(e)},o.format=function(){var e=this.get(),e=JSON.stringify(e,null,this.indentation);this.updateText(e)},o.repair=function(){var e=this.getText();try{var t=(0,U.K)(e);this.updateText(t)}catch{}},o.focus=function(){this.textarea&&this.textarea.focus(),this.aceEditor&&this.aceEditor.focus()},o.resize=function(){this.aceEditor&&this.aceEditor.resize(!1)},o.set=function(e){this.setText(JSON.stringify(e,null,this.indentation))},o.update=function(e){this.updateText(JSON.stringify(e,null,this.indentation))},o.get=function(){var e=this.getText();return(0,C.parse)(e)},o.getText=function(){return this.textarea?this.textarea.value:this.aceEditor?this.aceEditor.getValue():""},o._setText=function(p,t){var s,c=this,p=this.options.escapeUnicode===!0?(0,C.escapeUnicodeChars)(p):p;this.textarea&&(this.textarea.value=p),this.aceEditor&&(this.onChangeDisabled=!0,this.aceEditor.setValue(p,-1),this.onChangeDisabled=!1,t&&(s=this,setTimeout(function(){s.aceEditor&&s.aceEditor.session.getUndoManager().reset()})),setTimeout(function(){c._updateHistoryButtons&&c._updateHistoryButtons()})),this._debouncedValidate()},o.setText=function(e){this._setText(e,!0)},o.updateText=function(e){this.getText()!==e&&this._setText(e,!1)},o.validate=function(){var e,t=this,s=[],c=[];try{var p=this.get(),g=(this.validateSchema&&!this.validateSchema(p)&&(s=this.validateSchema.errors.map(function(w){return w.type="validation",(0,C.improveSchemaError)(w)})),this.validationSequence=(this.validationSequence||0)+1,this),b=this.validationSequence;return function(w,E){if(!E)return Promise.resolve([]);try{var W=E(w);return((0,C.isPromise)(W)?W:Promise.resolve(W)).then(function(B){return Array.isArray(B)?B.filter(function(O){var x=(0,C.isValidValidationError)(O);return x||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',O),x}).map(function(O){return{dataPath:(0,C.stringifyPath)(O.path),message:O.message,type:"customValidation"}}):[]})}catch(B){return Promise.reject(B)}}(p,this.options.onValidate).then(function(w){return b===g.validationSequence&&(w=s.concat(c).concat(w),g._renderErrors(w),typeof t.options.onValidationError=="function"&&(0,C.isValidationErrorChanged)(w,t.lastSchemaErrors)&&t.options.onValidationError.call(t,w),t.lastSchemaErrors=w),t.lastSchemaErrors})}catch(w){return this.getText()&&((p=/\w*line\s*(\d+)\w*/g.exec(w.message))&&(e=+p[1]),c=[{type:"error",message:w.message.replace(/\n/g,"<br>"),line:e}]),this._renderErrors(c),typeof this.options.onValidationError=="function"&&(0,C.isValidationErrorChanged)(c,this.lastSchemaErrors)&&this.options.onValidationError.call(this,c),this.lastSchemaErrors=c,Promise.resolve(this.lastSchemaErrors)}},o._validateAndCatch=function(){this.validate().catch(function(e){console.error("Error running validation:",e)})},o._renderErrors=function(e){var s=this.getText(),t=[],s=(e.reduce(function(c,p){return typeof p.dataPath=="string"&&c.indexOf(p.dataPath)===-1&&c.push(p.dataPath),c},t),(0,C.getPositionForPath)(s,t));this.aceEditor&&(this.annotations=s.map(function(c){var p=e.filter(function(b){return b.dataPath===c.path}),g=p.map(function(b){return b.message}).join(`
`);return g?{row:c.line,column:c.column,text:"Schema validation error"+(p.length!==1?"s":"")+`: 
`+g,type:"warning",source:"jsoneditor"}:{}}),this._refreshAnnotations()),this.errorTable.setErrors(e,s),this.aceEditor&&this.aceEditor.resize(!1)},o.getTextSelection=function(){var e,t,s,c={};return this.textarea?(s=(0,C.getInputSelection)(this.textarea),this.cursorInfo&&this.cursorInfo.line===s.end.row&&this.cursorInfo.column===s.end.column?(c.start=s.end,c.end=s.start):c=s,{start:c.start,end:c.end,text:this.textarea.value.substring(s.startIndex,s.endIndex)}):this.aceEditor?(s=this.aceEditor.getSelection(),e=this.aceEditor.getSelectedText(),t=s.getRange(),(s=s.getSelectionLead()).row===t.end.row&&s.column===t.end.column?c=t:(c.start=t.end,c.end=t.start),{start:{row:c.start.row+1,column:c.start.column+1},end:{row:c.end.row+1,column:c.end.column+1},text:e}):void 0},o.onTextSelectionChange=function(e){typeof e=="function"&&(this._selectionChangedHandler=(0,C.debounce)(e,this.DEBOUNCE_INTERVAL))},o.setTextSelection=function(e,t){var s,c,p;e&&t&&(this.textarea?(s=(0,C.getIndexForPosition)(this.textarea,e.row,e.column),p=(0,C.getIndexForPosition)(this.textarea,t.row,t.column),-1<s&&-1<p&&(this.textarea.setSelectionRange?(this.textarea.focus(),this.textarea.setSelectionRange(s,p)):this.textarea.createTextRange&&((c=this.textarea.createTextRange()).collapse(!0),c.moveEnd("character",p),c.moveStart("character",s),c.select()),p=(this.textarea.value.match(/\n/g)||[]).length+1,s=this.textarea.scrollHeight/p,c=e.row*s,this.textarea.scrollTop=c>this.textarea.clientHeight?c-this.textarea.clientHeight/2:0)):this.aceEditor&&(p={start:{row:e.row-1,column:e.column-1},end:{row:t.row-1,column:t.column-1}},this.aceEditor.selection.setRange(p),this.aceEditor.scrollToLine(e.row-1,!0)))};var r=[{mode:"text",mixin:o,data:"text",load:a},{mode:"code",mixin:o,data:"text",load:a}]},8038:function(le,X,K){K.r(X),K.d(X,{treeModeMixins:function(){return ne}});var U={start:function(T,F,V){return F.indexOf(T)===0},contain:function(T,F,V){return-1<F.indexOf(T)}},k=K(897),H=K(2474);function j(T){return(j=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(F){return typeof F}:function(F){return F&&typeof Symbol=="function"&&F.constructor===Symbol&&F!==Symbol.prototype?"symbol":typeof F})(T)}function z(T,F){for(var V=0;V<F.length;V++){var I=F[V];I.enumerable=I.enumerable||!1,I.configurable=!0,"value"in I&&(I.writable=!0),Object.defineProperty(T,function(S){return S=function(L,Z){if(j(L)!=="object"||L===null)return L;var J=L[Symbol.toPrimitive];if(J===void 0)return(Z==="string"?String:Number)(L);if(J=J.call(L,Z||"default"),j(J)!=="object")return J;throw new TypeError("@@toPrimitive must return a primitive value.")}(S,"string"),j(S)==="symbol"?S:String(S)}(I.key),I)}}var Y=function(){function T(){if(!(this instanceof T))throw new TypeError("Cannot call a class as a function");this.locked=!1}var F,V;return F=T,(V=[{key:"highlight",value:function(I){this.locked||(this.node!==I&&(this.node&&this.node.setHighlight(!1),this.node=I,this.node.setHighlight(!0)),this._cancelUnhighlight())}},{key:"unhighlight",value:function(){var I;this.locked||(I=this).node&&(this._cancelUnhighlight(),this.unhighlightTimer=setTimeout(function(){I.node.setHighlight(!1),I.node=void 0,I.unhighlightTimer=void 0},0))}},{key:"_cancelUnhighlight",value:function(){this.unhighlightTimer&&(clearTimeout(this.unhighlightTimer),this.unhighlightTimer=void 0)}},{key:"lock",value:function(){this.locked=!0}},{key:"unlock",value:function(){this.locked=!1}}])&&z(F.prototype,V),Object.defineProperty(F,"prototype",{writable:!1}),T}(),G=K(7907),N=K(6056),A=K(6617),X=K(233),f=K.n(X),R=K(2602),y=K(9791),C=K(6210),d=K(2558),h=K(4188);function l(T){return function(F){if(Array.isArray(F))return a(F)}(T)||function(F){if(typeof Symbol<"u"&&F[Symbol.iterator]!=null||F["@@iterator"]!=null)return Array.from(F)}(T)||i(T)||function(){throw new TypeError(`Invalid attempt to spread non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}()}function n(T,F){return function(V){if(Array.isArray(V))return V}(T)||function(V,I){var S=V==null?null:typeof Symbol<"u"&&V[Symbol.iterator]||V["@@iterator"];if(S!=null){var L,Z,J,re,pe=[],me=!0,ye=!1;try{if(J=(S=S.call(V)).next,I===0){if(Object(S)!==S)return;me=!1}else for(;!(me=(L=J.call(S)).done)&&(pe.push(L.value),pe.length!==I);me=!0);}catch(xe){ye=!0,Z=xe}finally{try{if(!me&&S.return!=null&&(re=S.return(),Object(re)!==re))return}finally{if(ye)throw Z}}return pe}}(T,F)||i(T,F)||function(){throw new TypeError(`Invalid attempt to destructure non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}()}function o(T,F){var V,I,S,L,Z=typeof Symbol<"u"&&T[Symbol.iterator]||T["@@iterator"];if(Z)return I=!(V=!0),{s:function(){Z=Z.call(T)},n:function(){var J=Z.next();return V=J.done,J},e:function(J){I=!0,S=J},f:function(){try{V||Z.return==null||Z.return()}finally{if(I)throw S}}};if(Array.isArray(T)||(Z=i(T))||F&&T&&typeof T.length=="number")return Z&&(T=Z),L=0,{s:F=function(){},n:function(){return L>=T.length?{done:!0}:{done:!1,value:T[L++]}},e:function(J){throw J},f:F};throw new TypeError(`Invalid attempt to iterate non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}function i(T,F){var V;if(T)return typeof T=="string"?a(T,F):(V=(V=Object.prototype.toString.call(T).slice(8,-1))==="Object"&&T.constructor?T.constructor.name:V)==="Map"||V==="Set"?Array.from(T):V==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(V)?a(T,F):void 0}function a(T,F){(F==null||F>T.length)&&(F=T.length);for(var V=0,I=new Array(F);V<F;V++)I[V]=T[V];return I}function r(T){return(r=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(F){return typeof F}:function(F){return F&&typeof Symbol=="function"&&F.constructor===Symbol&&F!==Symbol.prototype?"symbol":typeof F})(T)}function e(T,F){for(var V=0;V<F.length;V++){var I=F[V];I.enumerable=I.enumerable||!1,I.configurable=!0,"value"in I&&(I.writable=!0),Object.defineProperty(T,function(S){return S=function(L,Z){if(r(L)!=="object"||L===null)return L;var J=L[Symbol.toPrimitive];if(J===void 0)return(Z==="string"?String:Number)(L);if(J=J.call(L,Z||"default"),r(J)!=="object")return J;throw new TypeError("@@toPrimitive must return a primitive value.")}(S,"string"),r(S)==="symbol"?S:String(S)}(I.key),I)}}var t=function(){function T(I,S){if(!(this instanceof T))throw new TypeError("Cannot call a class as a function");this.editor=I,this.dom={},this.expanded=!1,S&&S instanceof Object?(this.setField(S.field,S.fieldEditable),"value"in S&&this.setValue(S.value,S.type),"internalValue"in S&&this.setInternalValue(S.internalValue)):(this.setField(""),this.setValue(null)),this._debouncedOnChangeValue=(0,y.debounce)(this._onChangeValue.bind(this),T.prototype.DEBOUNCE_INTERVAL),this._debouncedOnChangeField=(0,y.debounce)(this._onChangeField.bind(this),T.prototype.DEBOUNCE_INTERVAL),this.visibleChilds=this.getMaxVisibleChilds()}var F,V;return F=T,(V=[{key:"getMaxVisibleChilds",value:function(){return this.editor&&this.editor.options&&this.editor.options.maxVisibleChilds?this.editor.options.maxVisibleChilds:s}},{key:"_updateEditability",value:function(){var I,S;this.editable={field:!0,value:!0},this.editor&&(this.editable.field=this.editor.options.mode==="tree",this.editable.value=this.editor.options.mode!=="view",this.editor.options.mode!=="tree"&&this.editor.options.mode!=="form"||typeof this.editor.options.onEditable!="function"||(I=this.getValue.bind(this),typeof(S=this.editor.options.onEditable({field:this.field,get value(){return I()},path:this.getPath()}))=="boolean"?(this.editable.field=S,this.editable.value=S):r(S)==="object"&&S!==null?(typeof S.field=="boolean"&&(this.editable.field=S.field),typeof S.value=="boolean"&&(this.editable.value=S.value)):(console.error("Invalid return value for function onEditable.","Actual value:",S,".","Either a boolean or object { field: boolean, value: boolean } expected."),this.editable.field=!1,this.editable.value=!1)))}},{key:"getPath",value:function(){for(var I=this,S=[];I;){var L=I.getName();L!==void 0&&S.unshift(L),I=I.parent}return S}},{key:"getInternalPath",value:function(){for(var I=this,S=[];I;)I.parent&&S.unshift(I.getIndex()),I=I.parent;return S}},{key:"getName",value:function(){return this.parent?this.parent.type!=="array"?this.field:this.index:void 0}},{key:"findNodeByPath",value:function(I){if(I){if(I.length===0)return this;if(I.length&&this.childs&&this.childs.length){for(var S=0;S<this.childs.length;++S)if(""+I[0]==""+this.childs[S].getName())return this.childs[S].findNodeByPath(I.slice(1))}}}},{key:"findNodeByInternalPath",value:function(I){if(I){for(var Z=this,S=0;S<I.length&&Z;S++)var L=I[S],Z=Z.childs[L];return Z}}},{key:"serialize",value:function(){return{value:this.getValue(),path:this.getPath()}}},{key:"findNode",value:function(I){for(var S=(0,y.parsePath)(I),L=this;L&&0<S.length;)(function(){var Z=S.shift();if(typeof Z=="number"){if(L.type!=="array")throw new Error("Cannot get child node at index "+Z+": node is no array");L=L.childs[Z]}else{if(L.type!=="object")throw new Error("Cannot get child node "+Z+": node is no object");L=L.childs.filter(function(J){return J.field===Z})[0]}})();return L}},{key:"findParents",value:function(){for(var I=[],S=this.parent;S;)I.unshift(S),S=S.parent;return I}},{key:"setError",value:function(I,S){this.error=I,this.errorChild=S,this.dom&&this.dom.tr&&this.updateError()}},{key:"updateError",value:function(){var I=this,S=this.fieldError||this.valueError||this.error,L=this.dom.tdError;if(S&&this.dom&&this.dom.tr){(0,y.addClassName)(this.dom.tr,"jsoneditor-validation-error"),L||(L=document.createElement("td"),this.dom.tdError=L,this.dom.tdValue.parentNode.appendChild(L));var Z=document.createElement("button"),J=(Z.type="button",Z.className="jsoneditor-button jsoneditor-schema-error",function(){I.dom.popupAnchor&&I.dom.popupAnchor.destroy()}),re=function(){delete I.dom.popupAnchor},pe=function(be){var xe=I.editor.frame,be=(I.dom.popupAnchor=(0,R.w)(Z,I.editor.getPopupAnchor(),re,be),Z.getBoundingClientRect()),xe=120<xe.getBoundingClientRect().width-be.x?"jsoneditor-above":"jsoneditor-left",be=document.createElement("div");be.className="jsoneditor-popover "+xe,be.appendChild(document.createTextNode(S.message)),I.dom.popupAnchor.appendChild(be)},me=(Z.onmouseover=function(){I.dom.popupAnchor||pe(!0)},Z.onfocus=function(){J(),pe(!1)},Z.onblur=function(){J()},this.errorChild);for(me&&(Z.onclick=function(){me.findParents().forEach(function(ye){ye.expand(!1)}),me.scrollTo(function(){me.focus()})});L.firstChild;)L.removeChild(L.firstChild);L.appendChild(Z)}else this.dom.tr&&(0,y.removeClassName)(this.dom.tr,"jsoneditor-validation-error"),L&&(this.dom.tdError.parentNode.removeChild(this.dom.tdError),delete this.dom.tdError)}},{key:"getIndex",value:function(){var I;return this.parent?(I=this.parent.childs.indexOf(this))!==-1?I:null:-1}},{key:"setParent",value:function(I){this.parent=I}},{key:"setField",value:function(I,S){this.field=I,this.previousField=I,this.fieldEditable=S===!0}},{key:"getField",value:function(){return this.field===void 0&&this._getDomField(),this.field}},{key:"setValue",value:function(I,S){var L,Z,J,re,pe,me,ye=this.childs;if(this.type=this._getType(I),S&&S!==this.type){if(S!=="string"||this.type!=="auto")throw new Error('Type mismatch: cannot cast value of type "'+this.type+' to the specified type "'+S+'"');this.type=S}if(this.type==="array"){for(this.childs||(this.childs=[]),L=0;L<I.length;L++)(pe=I[L])===void 0||pe instanceof Function||(L<this.childs.length?((J=this.childs[L]).fieldEditable=!1,J.index=L,J.setValue(pe)):(J=new T(this.editor,{value:pe}),re=L<this.getMaxVisibleChilds(),this.appendChild(J,re,!1)));for(Z=this.childs.length;Z>=I.length;Z--)this.removeChild(this.childs[Z],!1)}else if(this.type==="object"){for(this.childs||(this.childs=[]),Z=this.childs.length-1;0<=Z;Z--)g(I,this.childs[Z].field)||this.removeChild(this.childs[Z],!1);for(var xe in L=0,I)g(I,xe)&&((pe=I[xe])===void 0||pe instanceof Function||((me=this.findChildByProperty(xe))?(me.setField(xe,!0),me.setValue(pe)):(me=new T(this.editor,{field:xe,value:pe}),xe=L<this.getMaxVisibleChilds(),this.appendChild(me,xe,!1))),L++);!(this.value="")===this.editor.options.sortObjectKeys&&this.sort([],"asc",!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=I;Array.isArray(ye)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"setInternalValue",value:function(I){var S,L,Z,J,re,pe=this.childs;if(this.type=I.type,I.type==="array"){for(this.childs||(this.childs=[]),J=0;J<I.childs.length;J++)(S=I.childs[J])===void 0||S instanceof Function||(J<this.childs.length?((L=this.childs[J]).fieldEditable=!1,L.index=J,L.setInternalValue(S)):(L=new T(this.editor,{internalValue:S}),Z=J<this.getMaxVisibleChilds(),this.appendChild(L,Z,!1)));for(re=this.childs.length;re>=I.childs.length;re--)this.removeChild(this.childs[re],!1)}else if(I.type==="object"){for(this.childs||(this.childs=[]),J=0;J<I.childs.length;J++)(S=I.childs[J])===void 0||S instanceof Function||(J<this.childs.length?(delete(L=this.childs[J]).index,L.setField(S.field,!0),L.setInternalValue(S.value)):(L=new T(this.editor,{field:S.field,internalValue:S.value}),Z=J<this.getMaxVisibleChilds(),this.appendChild(L,Z,!1)));for(re=this.childs.length;re>=I.childs.length;re--)this.removeChild(this.childs[re],!1)}else this.hideChilds(),delete this.append,delete this.showMore,delete this.expanded,delete this.childs,this.value=I.value;Array.isArray(pe)!==Array.isArray(this.childs)&&this.recreateDom(),this.updateDom({updateIndexes:!0}),this.previousValue=this.value}},{key:"recreateDom",value:function(){var I;this.dom&&this.dom.tr&&this.dom.tr.parentNode?(I=this._detachFromDom(),this.clearDom(),this._attachToDom(I)):this.clearDom()}},{key:"getValue",value:function(){var I,S;return this.type==="array"?(I=[],this.childs.forEach(function(L){I.push(L.getValue())}),I):this.type==="object"?(S={},this.childs.forEach(function(L){S[L.getField()]=L.getValue()}),S):(this.value===void 0&&this._getDomValue(),this.value)}},{key:"getInternalValue",value:function(){return this.type==="array"?{type:this.type,childs:this.childs.map(function(I){return I.getInternalValue()})}:this.type==="object"?{type:this.type,childs:this.childs.map(function(I){return{field:I.getField(),value:I.getInternalValue()}})}:(this.value===void 0&&this._getDomValue(),{type:this.type,value:this.value})}},{key:"getLevel",value:function(){return this.parent?this.parent.getLevel()+1:0}},{key:"getNodePath",value:function(){var I=this.parent?this.parent.getNodePath():[];return I.push(this),I}},{key:"clone",value:function(){var I,S;return(I=new T(this.editor)).type=this.type,I.field=this.field,I.fieldInnerText=this.fieldInnerText,I.fieldEditable=this.fieldEditable,I.previousField=this.previousField,I.value=this.value,I.valueInnerText=this.valueInnerText,I.previousValue=this.previousValue,I.expanded=this.expanded,I.visibleChilds=this.visibleChilds,this.childs?(S=[],this.childs.forEach(function(L){L=L.clone(),L.setParent(I),S.push(L)}),I.childs=S):I.childs=void 0,I}},{key:"expand",value:function(I){this.childs&&(this.expanded=!0,this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-expanded"),this.showChilds(),I!==!1&&this.childs.forEach(function(S){S.expand(I)}),this.updateDom({recurse:!1}))}},{key:"collapse",value:function(I){this.childs&&(this.hideChilds(),I!==!1&&this.childs.forEach(function(S){S.collapse(I)}),this.dom.expand&&(this.dom.expand.className="jsoneditor-button jsoneditor-collapsed"),this.expanded=!1,this.updateDom({recurse:!1}))}},{key:"showChilds",value:function(){var I=this.childs;if(I&&this.expanded){var I=this.dom.tr,S=I?I.parentNode:void 0;if(S){for(var L=this.getAppendDom(),Z=(L.parentNode||((J=I.nextSibling)?S.insertBefore(L,J):S.appendChild(L)),Math.min(this.childs.length,this.visibleChilds)),J=this._getNextTr(),re=0;re<Z;re++){var pe=this.childs[re];pe.getDom().parentNode||S.insertBefore(pe.getDom(),J),pe.showChilds()}I=this.getShowMoreDom(),J=this._getNextTr(),I.parentNode||S.insertBefore(I,J),this.showMore.updateDom()}}}},{key:"_getNextTr",value:function(){return this.showMore&&this.showMore.getDom().parentNode?this.showMore.getDom():this.append&&this.append.getDom().parentNode?this.append.getDom():void 0}},{key:"hide",value:function(I){var S=this.dom.tr,L=S?S.parentNode:void 0;L&&L.removeChild(S),this.dom.popupAnchor&&this.dom.popupAnchor.destroy(),this.hideChilds(I)}},{key:"hideChilds",value:function(I){var S;this.childs&&this.expanded&&((S=this.getAppendDom()).parentNode&&S.parentNode.removeChild(S),this.childs.forEach(function(L){L.hide()}),(S=this.getShowMoreDom()).parentNode&&S.parentNode.removeChild(S),I&&!I.resetVisibleChilds||(this.visibleChilds=this.getMaxVisibleChilds()))}},{key:"_updateCssClassName",value:function(){var I,S;this.dom.field&&this.editor&&this.editor.options&&typeof this.editor.options.onClassName=="function"&&this.dom.tree&&((0,y.removeAllClassNames)(this.dom.tree),I=this.getValue.bind(this),S=this.editor.options.onClassName({path:this.getPath(),field:this.field,get value(){return I()}})||"",(0,y.addClassName)(this.dom.tree,"jsoneditor-values "+S))}},{key:"recursivelyUpdateCssClassesOnNodes",value:function(){if(this._updateCssClassName(),Array.isArray(this.childs))for(var I=0;I<this.childs.length;I++)this.childs[I].recursivelyUpdateCssClassesOnNodes()}},{key:"expandTo",value:function(){for(var I=this.parent;I;)I.expanded||I.expand(),I=I.parent}},{key:"appendChild",value:function(I,S,L){var Z,J;this._hasChilds()&&(I.setParent(this),I.fieldEditable=this.type==="object",this.type==="array"&&(I.index=this.childs.length),this.type==="object"&&I.field===void 0&&I.setField(""),this.childs.push(I),this.expanded&&S!==!1&&(S=I.getDom(),J=(Z=this._getNextTr())?Z.parentNode:void 0,Z&&J&&J.insertBefore(S,Z),I.showChilds(),this.visibleChilds++),L!==!1)&&(this.updateDom({updateIndexes:!0}),I.updateDom({recurse:!0}))}},{key:"moveBefore",value:function(I,S,L){var Z,J,re;this._hasChilds()&&((Z=this.dom.tr?this.dom.tr.parentNode:void 0)&&((J=document.createElement("tr")).style.height=Z.clientHeight+"px",Z.appendChild(J)),I.parent&&I.parent.removeChild(I),S instanceof b||!S?this.childs.length+1>this.visibleChilds?(re=this.childs[this.visibleChilds-1],this.insertBefore(I,re,L)):this.appendChild(I,!0,L):this.insertBefore(I,S,L),Z)&&J&&Z.removeChild(J)}},{key:"insertBefore",value:function(I,S,L){if(this._hasChilds()){if(this.visibleChilds++,this.type==="object"&&I.field===void 0&&I.setField(""),S===this.append)I.setParent(this),I.fieldEditable=this.type==="object",this.childs.push(I);else{var Z=this.childs.indexOf(S);if(Z===-1)throw new Error("Node not found");I.setParent(this),I.fieldEditable=this.type==="object",this.childs.splice(Z,0,I)}var J;this.expanded&&(Z=I.getDom(),J=(S=S.getDom())?S.parentNode:void 0,S&&J&&J.insertBefore(Z,S),I.showChilds(),this.showChilds()),L!==!1&&(this.updateDom({updateIndexes:!0}),I.updateDom({recurse:!0}))}}},{key:"insertAfter",value:function(I,S){this._hasChilds()&&(S=this.childs.indexOf(S),(S=this.childs[S+1])?this.insertBefore(I,S):this.appendChild(I))}},{key:"search",value:function(I,S){Array.isArray(S)||(S=[]);var L=I?I.toLowerCase():void 0;return delete this.searchField,delete this.searchValue,this.field!==void 0&&S.length<=this.MAX_SEARCH_RESULTS&&(String(this.field).toLowerCase().indexOf(L)!==-1&&(this.searchField=!0,S.push({node:this,elem:"field"})),this._updateDomField()),this._hasChilds()?this.childs&&this.childs.forEach(function(Z){Z.search(I,S)}):this.value!==void 0&&S.length<=this.MAX_SEARCH_RESULTS&&(String(this.value).toLowerCase().indexOf(L)!==-1&&(this.searchValue=!0,S.push({node:this,elem:"value"})),this._updateDomValue()),S}},{key:"scrollTo",value:function(I){this.expandPathToNode(),this.dom.tr&&this.dom.tr.parentNode&&this.editor.scrollTo(this.dom.tr.offsetTop,I)}},{key:"expandPathToNode",value:function(){for(var I=this;I&&I.parent;){for(var S=I.parent.type==="array"?I.index:I.parent.childs.indexOf(I);I.parent.visibleChilds<S+1;)I.parent.visibleChilds+=this.getMaxVisibleChilds();I.parent.expand(!1),I=I.parent}}},{key:"focus",value:function(I){if(T.focusElement=I,this.dom.tr&&this.dom.tr.parentNode){var S=this.dom;switch(I){case"drag":(S.drag||S.menu).focus();break;case"menu":S.menu.focus();break;case"expand":this._hasChilds()?S.expand.focus():S.field&&this.fieldEditable?(S.field.focus(),(0,y.selectContentEditable)(S.field)):S.value&&!this._hasChilds()?(S.value.focus(),(0,y.selectContentEditable)(S.value)):S.menu.focus();break;case"field":S.field&&this.fieldEditable?(S.field.focus(),(0,y.selectContentEditable)(S.field)):S.value&&!this._hasChilds()?(S.value.focus(),(0,y.selectContentEditable)(S.value)):(this._hasChilds()?S.expand:S.menu).focus();break;default:S.select?S.select.focus():S.value&&!this._hasChilds()?(S.value.focus(),(0,y.selectContentEditable)(S.value)):S.field&&this.fieldEditable?(S.field.focus(),(0,y.selectContentEditable)(S.field)):(this._hasChilds()?S.expand:S.menu).focus()}}}},{key:"containsNode",value:function(I){if(this===I)return!0;var S=this.childs;if(S){for(var L=0,Z=S.length;L<Z;L++)if(S[L].containsNode(I))return!0}return!1}},{key:"removeChild",value:function(I,S){if(this.childs){var L=this.childs.indexOf(I);if(L!==-1)return L<this.visibleChilds&&this.expanded&&this.visibleChilds--,I.hide(),delete I.searchField,delete I.searchValue,(I=this.childs.splice(L,1)[0]).parent=null,S!==!1&&this.updateDom({updateIndexes:!0}),I}}},{key:"_remove",value:function(I){this.removeChild(I)}},{key:"changeType",value:function(I){var S,L=this.type;L!==I&&(I!=="string"&&I!=="auto"||L!=="string"&&L!=="auto"?(S=this._detachFromDom(),this.clearDom(),(this.type=I)==="object"?(this.childs||(this.childs=[]),this.childs.forEach(function(Z){Z.clearDom(),delete Z.index,Z.fieldEditable=!0,Z.field===void 0&&(Z.field="")}),L!=="string"&&L!=="auto"||(this.expanded=!0)):I==="array"?(this.childs||(this.childs=[]),this.childs.forEach(function(Z,J){Z.clearDom(),Z.fieldEditable=!1,Z.index=J}),L!=="string"&&L!=="auto"||(this.expanded=!0)):this.expanded=!1,this._attachToDom(S)):this.type=I,I!=="auto"&&I!=="string"||(this.value=I==="string"?String(this.value):(0,y.parseString)(String(this.value)),this.focus()),this.updateDom({updateIndexes:!0}))}},{key:"deepEqual",value:function(I){var S;if(this.type==="array"){if(!Array.isArray(I)||this.childs.length!==I.length)return!1;for(S=0;S<this.childs.length;S++)if(!this.childs[S].deepEqual(I[S]))return!1}else if(this.type==="object"){if(r(I)!=="object"||!I)return!1;var L=Object.keys(I);if(this.childs.length!==L.length)return!1;for(S=0;S<L.length;S++){var Z=this.childs[S];if(Z.field!==L[S]||!Z.deepEqual(I[Z.field]))return!1}}else if(this.value!==I)return!1;return!0}},{key:"_getDomValue",value:function(){if(this._clearValueError(),this.dom.value&&this.type!=="array"&&this.type!=="object"&&(this.valueInnerText=(0,y.getInnerText)(this.dom.value),this.valueInnerText==="")&&this.dom.value.innerHTML!==""&&(this.dom.value.textContent=""),this.valueInnerText!==void 0)try{var I,S;(S=this.type==="string"?this._unescapeHTML(this.valueInnerText):(I=this._unescapeHTML(this.valueInnerText),(0,y.parseString)(I)))!==this.value&&(this.value=S,this._debouncedOnChangeValue())}catch{this._setValueError((0,G.Iu)("cannotParseValueError"))}}},{key:"_setValueError",value:function(I){this.valueError={message:I},this.updateError()}},{key:"_clearValueError",value:function(){this.valueError&&(this.valueError=null,this.updateError())}},{key:"_setFieldError",value:function(I){this.fieldError={message:I},this.updateError()}},{key:"_clearFieldError",value:function(){this.fieldError&&(this.fieldError=null,this.updateError())}},{key:"_onChangeValue",value:function(){var I,S=this.editor.getDomSelection(),L=(S.range&&(L=(0,y.textDiff)(String(this.value),String(this.previousValue)),S.range.startOffset=L.start,S.range.endOffset=L.end),this.editor.getDomSelection());L.range&&(I=(0,y.textDiff)(String(this.previousValue),String(this.value)),L.range.startOffset=I.start,L.range.endOffset=I.end),this.editor._onAction("editValue",{path:this.getInternalPath(),oldValue:this.previousValue,newValue:this.value,oldSelection:S,newSelection:L}),this.previousValue=this.value}},{key:"_onChangeField",value:function(){var I=this.editor.getDomSelection(),S=this.previousField||"",L=(I.range&&(L=(0,y.textDiff)(this.field,S),I.range.startOffset=L.start,I.range.endOffset=L.end),this.editor.getDomSelection());L.range&&(S=(0,y.textDiff)(S,this.field),L.range.startOffset=S.start,L.range.endOffset=S.end),this.editor._onAction("editField",{parentPath:this.parent.getInternalPath(),index:this.getIndex(),oldValue:this.previousField,newValue:this.field,oldSelection:I,newSelection:L}),this.previousField=this.field}},{key:"_updateDomValue",value:function(){var I=this.dom.value;if(I){var S=["jsoneditor-value"],L=this.value,Z=this.type==="auto"?(0,y.getType)(L):this.type,J=Z==="string"&&(0,y.isUrl)(L);if(S.push("jsoneditor-"+Z),J&&S.push("jsoneditor-url"),String(this.value)===""&&this.type!=="array"&&this.type!=="object"&&S.push("jsoneditor-empty"),this.searchValueActive&&S.push("jsoneditor-highlight-active"),this.searchValue&&S.push("jsoneditor-highlight"),I.className=S.join(" "),Z==="array"||Z==="object"?(S=this.childs?this.childs.length:0,I.title=this.type+" containing "+S+" items"):J&&this.editable.value?I.title=(0,G.Iu)("openUrl"):I.title="",Z==="boolean"&&this.editable.value?(this.dom.checkbox||(this.dom.checkbox=document.createElement("input"),this.dom.checkbox.type="checkbox",this.dom.tdCheckbox=document.createElement("td"),this.dom.tdCheckbox.className="jsoneditor-tree",this.dom.tdCheckbox.appendChild(this.dom.checkbox),this.dom.tdValue.parentNode.insertBefore(this.dom.tdCheckbox,this.dom.tdValue)),this.dom.checkbox.checked=this.value):this.dom.tdCheckbox&&(this.dom.tdCheckbox.parentNode.removeChild(this.dom.tdCheckbox),delete this.dom.tdCheckbox,delete this.dom.checkbox),this.enum&&this.editable.value?(this.dom.select||(this.dom.select=document.createElement("select"),this.id=this.field+"_"+new Date().getUTCMilliseconds(),this.dom.select.id=this.id,this.dom.select.name=this.dom.select.id,(S=document.createElement("option")).value="",S.textContent="--",this.dom.select.appendChild(S),this._updateEnumOptions(),this.dom.tdSelect=document.createElement("td"),this.dom.tdSelect.className="jsoneditor-tree",this.dom.tdSelect.appendChild(this.dom.select),this.dom.tdValue.parentNode.insertBefore(this.dom.tdSelect,this.dom.tdValue)),this.dom.select.value=this.enum.indexOf(this.value)!==-1?this.value:"",!this.schema||g(this.schema,"oneOf")||g(this.schema,"anyOf")||g(this.schema,"allOf")?delete this.valueFieldHTML:(this.valueFieldHTML=this.dom.tdValue.innerHTML,this.dom.tdValue.style.visibility="hidden",this.dom.tdValue.textContent="")):this.dom.tdSelect&&(this.dom.tdSelect.parentNode.removeChild(this.dom.tdSelect),delete this.dom.tdSelect,delete this.dom.select,this.dom.tdValue.innerHTML=this.valueFieldHTML,this.dom.tdValue.style.visibility="",delete this.valueFieldHTML,this.dom.tdValue.appendChild(this.dom.value)),this.editor.options.colorPicker&&typeof L=="string"&&(0,y.isValidColor)(L)?(this.dom.color||(this.dom.color=document.createElement("div"),this.dom.color.className="jsoneditor-color",this.dom.tdColor=document.createElement("td"),this.dom.tdColor.className="jsoneditor-tree",this.dom.tdColor.appendChild(this.dom.color),this.dom.tdValue.parentNode.insertBefore(this.dom.tdColor,this.dom.tdValue)),(0,y.addClassName)(this.dom.value,"jsoneditor-color-value"),(this.editable.value?y.removeClassName:y.addClassName)(this.dom.color,"jsoneditor-color-readonly"),this.dom.color.style.backgroundColor=L):this._deleteDomColor(),this._showTimestampTag()){if(this.dom.date||(this.dom.date=document.createElement("div"),this.dom.date.className="jsoneditor-date",this.dom.value.parentNode.appendChild(this.dom.date)),J=null,J=typeof this.editor.options.timestampFormat=="function"?this.editor.options.timestampFormat({field:this.field,value:this.value,path:this.getPath()}):J){for(;this.dom.date.firstChild;)this.dom.date.removeChild(this.dom.date.firstChild);this.dom.date.appendChild(document.createTextNode(J))}else this.dom.date.textContent=new Date(L).toISOString();this.dom.date.title=new Date(L).toString()}else this.dom.date&&(this.dom.date.parentNode.removeChild(this.dom.date),delete this.dom.date);(0,y.stripFormatting)(I),this._updateDomDefault()}}},{key:"_updateEnumOptions",value:function(){if(this.enum&&this.dom.select){this.dom.select.innerHTML="";for(var I=0;I<this.enum.length;I++){var S=document.createElement("option");S.value=this.enum[I],S.textContent=this.enum[I],this.dom.select.appendChild(S)}}}},{key:"_deleteDomColor",value:function(){this.dom.color&&(this.dom.tdColor.parentNode.removeChild(this.dom.tdColor),delete this.dom.tdColor,delete this.dom.color,(0,y.removeClassName)(this.dom.value,"jsoneditor-color-value"))}},{key:"_updateDomField",value:function(){var I,S=this.dom.field;S&&((I=(0,y.makeFieldTooltip)(this.schema,this.editor.options.language))&&(S.title=I),(String(this.field)===""&&this.parent&&this.parent.type!=="array"?y.addClassName:y.removeClassName)(S,"jsoneditor-empty"),(this.searchFieldActive?y.addClassName:y.removeClassName)(S,"jsoneditor-highlight-active"),(this.searchField?y.addClassName:y.removeClassName)(S,"jsoneditor-highlight"),(0,y.stripFormatting)(S))}},{key:"_getDomField",value:function(I){if(this._clearFieldError(),this.dom.field&&this.fieldEditable&&(this.fieldInnerText=(0,y.getInnerText)(this.dom.field),this.fieldInnerText==="")&&this.dom.field.innerHTML!==""&&(this.dom.field.textContent=""),this.fieldInnerText!==void 0)try{var S=this._unescapeHTML(this.fieldInnerText),L=this.parent.getFieldNames(this);L.indexOf(S)!==-1?I?(S=(0,y.findUniqueName)(S,L))!==this.field&&(this.field=S,this._debouncedOnChangeField()):this._setFieldError((0,G.Iu)("duplicateFieldError")):S!==this.field&&(this.field=S,this._debouncedOnChangeField())}catch{this._setFieldError((0,G.Iu)("cannotParseFieldError"))}}},{key:"_updateDomDefault",value:function(){var I;this.schema&&this.schema.default!==void 0&&!this._hasChilds()&&(I=this.dom.select||this.dom.value)&&(this.value===this.schema.default?(I.title=(0,G.Iu)("default"),(0,y.addClassName)(I,"jsoneditor-is-default"),y.removeClassName):(I.removeAttribute("title"),(0,y.removeClassName)(I,"jsoneditor-is-default"),y.addClassName))(I,"jsoneditor-is-not-default")}},{key:"_showTimestampTag",value:function(){var I,S;return typeof this.value=="number"&&(typeof(I=this.editor.options.timestampTag)=="function"?typeof(S=I({field:this.field,value:this.value,path:this.getPath()}))=="boolean"?S:(0,y.isTimestamp)(this.field,this.value):I===!0&&(0,y.isTimestamp)(this.field,this.value))}},{key:"clearDom",value:function(){this.dom={}}},{key:"getDom",value:function(){var I,S,L=this.dom;return L.tr||(this._updateEditability(),L.tr=document.createElement("tr"),(L.tr.node=this).editor.options.mode==="tree"&&(S=document.createElement("td"),this.editable.field&&this.parent&&((I=document.createElement("button")).type="button",(L.drag=I).className="jsoneditor-button jsoneditor-dragarea",I.title=(0,G.Iu)("drag"),S.appendChild(I)),L.tr.appendChild(S),I=document.createElement("td"),(S=document.createElement("button")).type="button",(L.menu=S).className="jsoneditor-button jsoneditor-contextmenu-button",S.title=(0,G.Iu)("actionsMenu"),I.appendChild(L.menu),L.tr.appendChild(I)),S=document.createElement("td"),L.tr.appendChild(S),L.tree=this._createDomTree(),S.appendChild(L.tree),this.updateDom({updateIndexes:!0})),L.tr}},{key:"isVisible",value:function(){return this.dom&&this.dom.tr&&this.dom.tr.parentNode||!1}},{key:"isDescendantOf",value:function(I){for(var S=this.parent;S;){if(S===I)return!0;S=S.parent}return!1}},{key:"_createDomField",value:function(){return document.createElement("div")}},{key:"setHighlight",value:function(I){this.dom.tr&&((I?y.addClassName:y.removeClassName)(this.dom.tr,"jsoneditor-highlight"),this.append&&this.append.setHighlight(I),this.childs)&&this.childs.forEach(function(S){S.setHighlight(I)})}},{key:"setSelected",value:function(I,S){this.selected=I,this.dom.tr&&((I?y.addClassName:y.removeClassName)(this.dom.tr,"jsoneditor-selected"),(S?y.addClassName:y.removeClassName)(this.dom.tr,"jsoneditor-first"),this.append&&this.append.setSelected(I),this.showMore&&this.showMore.setSelected(I),this.childs)&&this.childs.forEach(function(L){L.setSelected(I)})}},{key:"updateValue",value:function(I){this.value=I,this.previousValue=I,this.valueError=void 0,this.updateDom()}},{key:"updateField",value:function(I){this.field=I,this.previousField=I,this.fieldError=void 0,this.updateDom()}},{key:"updateDom",value:function(I){var S,L=this.dom.tree,L=(L&&(L.style.marginLeft=24*this.getLevel()+"px"),this.dom.field),L=(L&&(this.fieldEditable?(L.contentEditable=this.editable.field,L.spellcheck=!1,L.className="jsoneditor-field"):(L.contentEditable=!1,L.className="jsoneditor-readonly"),S=this.index!==void 0?this.index:this.field!==void 0?this.field:(S=this.editor.options.schema?T._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):void 0)&&S.title?S.title:this._hasChilds()?this.type:"",S=this._escapeHTML(S),document.activeElement!==L&&S!==this._unescapeHTML((0,y.getInnerText)(L))&&(L.innerHTML=S),this._updateSchema(),this._updateEnumOptions()),this.dom.value),L=(L&&(this.type==="array"||this.type==="object"?this.updateNodeName():(S=this._escapeHTML(this.value),document.activeElement!==L&&S!==this._unescapeHTML((0,y.getInnerText)(L))&&(L.innerHTML=S))),this.dom.tr);L&&(this.type==="array"||this.type==="object"?((0,y.addClassName)(L,"jsoneditor-expandable"),this.expanded?((0,y.addClassName)(L,"jsoneditor-expanded"),(0,y.removeClassName)(L,"jsoneditor-collapsed")):((0,y.addClassName)(L,"jsoneditor-collapsed"),(0,y.removeClassName)(L,"jsoneditor-expanded"))):((0,y.removeClassName)(L,"jsoneditor-expandable"),(0,y.removeClassName)(L,"jsoneditor-expanded"),(0,y.removeClassName)(L,"jsoneditor-collapsed"))),this._updateDomField(),this._updateDomValue(),I&&I.updateIndexes===!0&&this._updateDomIndexes(),I&&I.recurse===!0&&this.childs&&this.childs.forEach(function(Z){Z.updateDom(I)}),this.error&&this.updateError(),this.append&&this.append.updateDom(),this.showMore&&this.showMore.updateDom(),this._updateCssClassName()}},{key:"_updateSchema",value:function(){this.editor&&this.editor.options&&(this.schema=this.editor.options.schema?T._findSchema(this.editor.options.schema,this.editor.options.schemaRefs||{},this.getPath()):null,this.schema?this.enum=T._findEnum(this.schema):delete this.enum)}},{key:"_updateDomIndexes",value:function(){var I=this.dom.value,S=this.childs;I&&S&&(this.type==="array"?S.forEach(function(L,Z){L.index=Z,L=L.dom.field,L&&(L.textContent=Z)}):this.type==="object"&&S.forEach(function(L){L.index!==void 0&&(delete L.index,L.field===void 0)&&(L.field="")}))}},{key:"_createDomValue",value:function(){var I;return this.type==="array"?(I=document.createElement("div")).textContent="[...]":this.type==="object"?(I=document.createElement("div")).textContent="{...}":(!this.editable.value&&(0,y.isUrl)(this.value)?(I=document.createElement("a")).href=this.value:((I=document.createElement("div")).contentEditable=this.editable.value,I.spellcheck=!1),I.innerHTML=this._escapeHTML(this.value)),I}},{key:"_createDomExpandButton",value:function(){var I=document.createElement("button");return I.type="button",this._hasChilds()?(I.className=this.expanded?"jsoneditor-button jsoneditor-expanded":"jsoneditor-button jsoneditor-collapsed",I.title=(0,G.Iu)("expandTitle")):(I.className="jsoneditor-button jsoneditor-invisible",I.title=""),I}},{key:"_createDomTree",value:function(){var I=this.dom,S=document.createElement("table"),Z=document.createElement("tbody"),L=(S.style.borderCollapse="collapse",S.className="jsoneditor-values",S.appendChild(Z),document.createElement("tr")),Z=(Z.appendChild(L),document.createElement("td")),Z=(Z.className="jsoneditor-tree",L.appendChild(Z),I.expand=this._createDomExpandButton(),Z.appendChild(I.expand),I.tdExpand=Z,document.createElement("td")),Z=(Z.className="jsoneditor-tree",L.appendChild(Z),I.field=this._createDomField(),Z.appendChild(I.field),I.tdField=Z,document.createElement("td")),Z=(Z.className="jsoneditor-tree",L.appendChild(Z),this.type!=="object"&&this.type!=="array"&&(Z.appendChild(document.createTextNode(":")),Z.className="jsoneditor-separator"),I.tdSeparator=Z,document.createElement("td"));return Z.className="jsoneditor-tree",L.appendChild(Z),I.value=this._createDomValue(),Z.appendChild(I.value),I.tdValue=Z,S}},{key:"onEvent",value:function(I){var S,L=I.type,Z=I.target||I.srcElement,J=this.dom,re=this,pe=this._hasChilds(),me=(Z!==J.drag&&Z!==J.menu||(L==="mouseover"?this.editor.highlighter.highlight(this):L==="mouseout"&&this.editor.highlighter.unhighlight()),L==="click"&&Z===J.menu&&((S=re.editor.highlighter).highlight(re),S.lock(),(0,y.addClassName)(J.menu,"jsoneditor-selected"),this.showContextMenu(J.menu,function(){(0,y.removeClassName)(J.menu,"jsoneditor-selected"),S.unlock(),S.unhighlight()})),L==="click"&&Z===J.expand&&pe&&(Ae=I.ctrlKey,this._onExpand(Ae)),L!=="click"||I.target!==re.dom.tdColor&&I.target!==re.dom.color||!this.editable.value||this._showColorPicker(),L==="change"&&Z===J.checkbox&&(this.dom.value.textContent=String(!this.value),this._getDomValue(),this._updateDomDefault()),L==="change"&&Z===J.select&&(this.dom.value.innerHTML=this._escapeHTML(J.select.value),this._getDomValue(),this._updateDomValue()),J.value);if(Z===me)switch(L){case"blur":case"change":this._getDomValue(),this._clearValueError(),this._updateDomValue();var ye=this._escapeHTML(this.value);ye!==this._unescapeHTML((0,y.getInnerText)(me))&&(me.innerHTML=ye);break;case"input":this._getDomValue(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"click":I.ctrlKey&&this.editable.value&&(0,y.isUrl)(this.value)&&(I.preventDefault(),window.open(this.value,"_blank","noreferrer"));break;case"keyup":this._getDomValue(),this._updateDomValue();break;case"cut":case"paste":setTimeout(function(){re._getDomValue(),re._updateDomValue()},1)}var xe=J.field;if(Z===xe)switch(L){case"blur":this._getDomField(!0),this._updateDomField();var be=this._escapeHTML(this.field);be!==this._unescapeHTML((0,y.getInnerText)(xe))&&(xe.innerHTML=be);break;case"input":this._getDomField(),this._updateSchema(),this._updateDomField(),this._updateDomValue();break;case"keydown":case"mousedown":this.editor.selection=this.editor.getDomSelection();break;case"keyup":this._getDomField(),this._updateDomField();break;case"cut":case"paste":setTimeout(function(){re._getDomField(),re._updateDomField()},1)}var Ae=J.tree;Ae&&Z===Ae.parentNode&&L==="click"&&!I.hasMoved&&((I.offsetX!==void 0?I.offsetX<24*(this.getLevel()+1):I.pageX<(0,y.getAbsoluteLeft)(J.tdSeparator))||pe?xe&&((0,y.setEndOfContentEditable)(xe),xe.focus()):me&&!this.enum&&((0,y.setEndOfContentEditable)(me),me.focus())),(Z!==J.tdExpand||pe)&&Z!==J.tdField&&Z!==J.tdSeparator||L!=="click"||I.hasMoved||xe&&((0,y.setEndOfContentEditable)(xe),xe.focus()),L==="keydown"&&this.onKeyDown(I),typeof this.editor.options.onEvent=="function"&&this._onEvent(I)}},{key:"_onEvent",value:function(I){var L=I.target,S=L===this.dom.field,L=L===this.dom.value||L===this.dom.checkbox||L===this.dom.select;(S||L)&&(S={field:this.getField(),path:this.getPath()},L&&!this._hasChilds()&&(S.value=this.getValue()),this.editor.options.onEvent(S,I))}},{key:"onKeyDown",value:function(I){var S,L,Z,J,re,pe,me,ye,xe,be,Ae,we,Re,We,Se=I.which||I.keyCode,ve=I.target||I.srcElement,Le=I.ctrlKey,Pe=I.shiftKey,ge=I.altKey,te=!1,ie=this.editor.options.mode==="tree",ce=0<this.editor.multiselection.nodes.length?this.editor.multiselection.nodes:[this],fe=ce[0],Ie=ce[ce.length-1];Se===13?ve===this.dom.value?this.editable.value&&!I.ctrlKey||(0,y.isUrl)(this.value)&&(window.open(this.value,"_blank","noreferrer"),te=!0):ve===this.dom.expand&&this._hasChilds()&&(Re=I.ctrlKey,this._onExpand(Re),ve.focus(),te=!0):Se===68?Le&&ie&&(T.onDuplicate(ce),te=!0):Se===69?Le&&(this._onExpand(Pe),ve.focus(),te=!0):Se===77&&ie?Le&&(this.showContextMenu(ve),te=!0):Se===46&&ie?Le&&(T.onRemove(ce),te=!0):Se===45&&ie?Le&&!Pe?(this._onInsertBefore(),te=!0):Le&&Pe&&(this._onInsertAfter(),te=!0):Se===35?ge&&((Re=this._lastNode())&&Re.focus(T.focusElement||this._getElementName(ve)),te=!0):Se===36?ge&&((Re=this._firstNode())&&Re.focus(T.focusElement||this._getElementName(ve)),te=!0):Se===37?ge&&!Pe?((Re=this._previousElement(ve))&&this.focus(this._getElementName(Re)),te=!0):ge&&Pe&&ie&&(Re=Ie.expanded?(Re=Ie.getAppendDom())?Re.nextSibling:void 0:Ie.getDom().nextSibling)&&(Ae=T.getNodeFromTarget(Re),Re=Re.nextSibling,we=T.getNodeFromTarget(Re),Ae)&&Ae instanceof b&&Ie.parent.childs.length!==1&&we&&we.parent&&(L=this.editor.getDomSelection(),Z=(J=fe.parent).childs[Ie.getIndex()+1]||J.append,re=fe.getIndex(),pe=we.getIndex(),me=J.getInternalPath(),ye=we.parent.getInternalPath(),ce.forEach(function($e){we.parent.moveBefore($e,we)}),this.focus(T.focusElement||this._getElementName(ve)),this.editor._onAction("moveNodes",{count:ce.length,fieldNames:ce.map(p),oldParentPath:J.getInternalPath(),newParentPath:fe.parent.getInternalPath(),oldIndex:Z.getIndex(),newIndex:fe.getIndex(),oldIndexRedo:re,newIndexRedo:pe,oldParentPathRedo:me,newParentPathRedo:ye,oldSelection:L,newSelection:this.editor.getDomSelection()})):Se===38?ge&&!Pe?((S=this._previousNode())&&(this.editor.deselect(!0),S.focus(T.focusElement||this._getElementName(ve))),te=!0):!ge&&Le&&Pe&&ie?((S=this._previousNode())&&((be=this.editor.multiselection).start=be.start||this,be.end=S,xe=this.editor._findTopLevelNodes(be.start,be.end),this.editor.select(xe),S.focus("field")),te=!0):ge&&Pe&&ie&&((S=fe._previousNode())&&S.parent&&(L=this.editor.getDomSelection(),Z=(J=fe.parent).childs[Ie.getIndex()+1]||J.append,re=fe.getIndex(),pe=S.getIndex(),me=J.getInternalPath(),ye=S.parent.getInternalPath(),ce.forEach(function($e){S.parent.moveBefore($e,S)}),this.focus(T.focusElement||this._getElementName(ve)),this.editor._onAction("moveNodes",{count:ce.length,fieldNames:ce.map(p),oldParentPath:J.getInternalPath(),newParentPath:fe.parent.getInternalPath(),oldIndex:Z.getIndex(),newIndex:fe.getIndex(),oldIndexRedo:re,newIndexRedo:pe,oldParentPathRedo:me,newParentPathRedo:ye,oldSelection:L,newSelection:this.editor.getDomSelection()})),te=!0):Se===39?ge&&!Pe?((Re=this._nextElement(ve))&&this.focus(this._getElementName(Re)),te=!0):ge&&Pe&&ie&&(Re=fe.getDom().previousSibling)&&(S=T.getNodeFromTarget(Re))&&S.parent&&!S.isVisible()&&(L=this.editor.getDomSelection(),Z=(J=fe.parent).childs[Ie.getIndex()+1]||J.append,re=fe.getIndex(),pe=S.getIndex(),me=J.getInternalPath(),ye=S.parent.getInternalPath(),ce.forEach(function($e){S.parent.moveBefore($e,S)}),this.focus(T.focusElement||this._getElementName(ve)),this.editor._onAction("moveNodes",{count:ce.length,fieldNames:ce.map(p),oldParentPath:J.getInternalPath(),newParentPath:fe.parent.getInternalPath(),oldIndex:Z.getIndex(),newIndex:fe.getIndex(),oldIndexRedo:re,newIndexRedo:pe,oldParentPathRedo:me,newParentPathRedo:ye,oldSelection:L,newSelection:this.editor.getDomSelection()})):Se===40&&(ge&&!Pe?((Ae=this._nextNode())&&(this.editor.deselect(!0),Ae.focus(T.focusElement||this._getElementName(ve))),te=!0):!ge&&Le&&Pe&&ie?((Ae=this._nextNode())&&((be=this.editor.multiselection).start=be.start||this,be.end=Ae,xe=this.editor._findTopLevelNodes(be.start,be.end),this.editor.select(xe),Ae.focus("field")),te=!0):ge&&Pe&&ie&&((We=(Ae=(Ae=(Ae=Ie.expanded?Ie.append?Ie.append._nextNode():void 0:Ie._nextNode())&&!Ae.isVisible()?Ae.parent.showMore:Ae)&&Ae instanceof b?Ie:Ae)&&(Ae._nextNode()||Ae.parent.append))&&We.parent&&(L=this.editor.getDomSelection(),Z=(J=fe.parent).childs[Ie.getIndex()+1]||J.append,re=fe.getIndex(),pe=We.getIndex(),me=J.getInternalPath(),ye=We.parent.getInternalPath(),ce.forEach(function($e){We.parent.moveBefore($e,We)}),this.focus(T.focusElement||this._getElementName(ve)),this.editor._onAction("moveNodes",{count:ce.length,fieldNames:ce.map(p),oldParentPath:J.getInternalPath(),newParentPath:fe.parent.getInternalPath(),oldParentPathRedo:me,newParentPathRedo:ye,oldIndexRedo:re,newIndexRedo:pe,oldIndex:Z.getIndex(),newIndex:fe.getIndex(),oldSelection:L,newSelection:this.editor.getDomSelection()})),te=!0)),te&&(I.preventDefault(),I.stopPropagation())}},{key:"_onExpand",value:function(I){var S,L,Z;I&&(Z=(L=(S=this.dom.tr.parentNode).parentNode).scrollTop,L.removeChild(S)),this.expanded?this.collapse(I):this.expand(I),I&&(L.appendChild(S),L.scrollTop=Z),typeof this.editor.options.onExpand=="function"&&this.editor.options.onExpand({path:this.getPath(),isExpand:this.expanded,recursive:I})}},{key:"_showColorPicker",value:function(){var I,S;typeof this.editor.options.onColorPicker=="function"&&this.dom.color&&((I=this)._deleteDomColor(),I.updateDom(),S=(0,R.w)(this.dom.color,this.editor.getPopupAnchor()),this.editor.options.onColorPicker(S,this.value,function(L){typeof L=="string"&&L!==I.value&&(I._deleteDomColor(),I.value=L,I.updateDom(),I._debouncedOnChangeValue())}))}},{key:"getFieldNames",value:function(I){return this.type==="object"?this.childs.filter(function(S){return S!==I}).map(function(S){return S.field}):[]}},{key:"_onInsertBefore",value:function(J,re,pe){var Z=this.editor.getDomSelection(),J=new T(this.editor,{field:J!==void 0?J:"",value:re!==void 0?re:"",type:pe}),re=(J.expand(!0),this.getInternalPath()),pe=(this.parent.insertBefore(J,this),this.editor.highlighter.unhighlight(),J.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertBeforeNodes",{nodes:[J],paths:[J.getInternalPath()],beforePath:re,parentPath:this.parent.getInternalPath(),oldSelection:Z,newSelection:pe})}},{key:"_onInsertAfter",value:function(J,re,L){var Z=this.editor.getDomSelection(),J=new T(this.editor,{field:J!==void 0?J:"",value:re!==void 0?re:"",type:L}),re=(J.expand(!0),this.parent.insertAfter(J,this),this.editor.highlighter.unhighlight(),J.focus("field"),this.editor.getDomSelection());this.editor._onAction("insertAfterNodes",{nodes:[J],paths:[J.getInternalPath()],afterPath:this.getInternalPath(),parentPath:this.parent.getInternalPath(),oldSelection:Z,newSelection:re})}},{key:"_onAppend",value:function(J,re,L){var Z=this.editor.getDomSelection(),J=new T(this.editor,{field:J!==void 0?J:"",value:re!==void 0?re:"",type:L}),re=(J.expand(!0),this.parent.appendChild(J),this.editor.highlighter.unhighlight(),J.focus("field"),this.editor.getDomSelection());this.editor._onAction("appendNodes",{nodes:[J],paths:[J.getInternalPath()],parentPath:this.parent.getInternalPath(),oldSelection:Z,newSelection:re})}},{key:"_onChangeType",value:function(I){var S,L,Z=this.type;I!==Z&&(S=this.editor.getDomSelection(),this.changeType(I),L=this.editor.getDomSelection(),this.editor._onAction("changeType",{path:this.getInternalPath(),oldType:Z,newType:I,oldSelection:S,newSelection:L}))}},{key:"sort",value:function(I,S){var L,Z,J=!(2<arguments.length&&arguments[2]!==void 0)||arguments[2];typeof I=="string"&&(I=(0,y.parsePath)(I)),this._hasChilds()&&(this.hideChilds(),L=this.childs,this.childs=this.childs.concat(),Z=S==="desc"?-1:1,this.type==="object"?this.childs.sort(function(re,pe){return Z*f()(re.field,pe.field)}):this.childs.sort(function(me,ye){var me=me.getNestedChild(I),ye=ye.getNestedChild(I);return me?ye?(me=me.value,ye=ye.value,typeof me!="string"&&typeof ye!="string"?ye<me?Z:me<ye?-Z:0:Z*f()(me,ye)):-Z:Z}),this._updateDomIndexes(),this.showChilds(),J===!0)&&this.editor._onAction("sort",{path:this.getInternalPath(),oldChilds:L,newChilds:this.childs})}},{key:"update",value:function(I){var S=this.getInternalValue();this.setValue(I),this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:S,newValue:this.getInternalValue()})}},{key:"_detachFromDom",value:function(){var I=this.dom.tr?this.dom.tr.parentNode:void 0,S=this.expanded?this.getAppendDom():this.getDom(),S=S&&S.parentNode?S.nextSibling:void 0;return this.hide({resetVisibleChilds:!1}),{table:I,nextTr:S}}},{key:"_attachToDom",value:function(I){I.table&&(I.nextTr?I.table.insertBefore(this.getDom(),I.nextTr):I.table.appendChild(this.getDom())),this.expanded&&this.showChilds()}},{key:"transform",value:function(I){if(this._hasChilds()){this.hideChilds();try{var S=this.getInternalValue(),L=this.getValue(),Z=this.editor.options.executeQuery(L,I),J=(this.setValue(Z),this.getInternalValue());this.editor._onAction("transform",{path:this.getInternalPath(),oldValue:S,newValue:J}),this.showChilds()}catch(re){this.showChilds(),this.editor._onError(re)}}}},{key:"extract",value:function(){this.editor.node.hideChilds(),this.hideChilds();try{var I=this.editor.node.getInternalValue(),S=(this.editor._setRoot(this),this.editor.node.getInternalValue());this.editor._onAction("transform",{path:this.editor.node.getInternalPath(),oldValue:I,newValue:S})}catch(L){this.editor._onError(L)}finally{this.updateDom({recurse:!0}),this.showChilds()}}},{key:"getNestedChild",value:function(I){for(var S=0,L=this;L&&S<I.length;)L=L.findChildByProperty(I[S]),S++;return L}},{key:"findChildByProperty",value:function(I){if(this.type==="object")return this.childs.find(function(S){return S.field===I})}},{key:"getAppendDom",value:function(){return this.append||(this.append=new b(this.editor),this.append.setParent(this)),this.append.getDom()}},{key:"getShowMoreDom",value:function(){return this.showMore||(this.showMore=new E(this.editor,this)),this.showMore.getDom()}},{key:"nextSibling",value:function(){var I=this.parent.childs.indexOf(this);return this.parent.childs[I+1]||this.parent.append}},{key:"_previousNode",value:function(){var I=null,S=this.getDom();if(S&&S.parentNode)for(var L=S;L=L.previousSibling,I=T.getNodeFromTarget(L),L&&I&&I instanceof b&&!I.isVisible(););return I}},{key:"_nextNode",value:function(){var I=null,S=this.getDom();if(S&&S.parentNode)for(var L=S;L=L.nextSibling,I=T.getNodeFromTarget(L),L&&I&&I instanceof b&&!I.isVisible(););return I}},{key:"_firstNode",value:function(){var I=null,S=this.getDom();return S&&S.parentNode&&(S=S.parentNode.firstChild,I=T.getNodeFromTarget(S)),I}},{key:"_lastNode",value:function(){var I=null,S=this.getDom();if(S&&S.parentNode)for(var L=S.parentNode.lastChild,I=T.getNodeFromTarget(L);L&&I&&!I.isVisible();)L=L.previousSibling,I=T.getNodeFromTarget(L);return I}},{key:"_previousElement",value:function(I){var S=this.dom;switch(I){case S.value:if(this.fieldEditable)return S.field;case S.field:if(this._hasChilds())return S.expand;case S.expand:return S.menu;case S.menu:if(S.drag)return S.drag;default:return null}}},{key:"_nextElement",value:function(I){var S=this.dom;switch(I){case S.drag:return S.menu;case S.menu:if(this._hasChilds())return S.expand;case S.expand:if(this.fieldEditable)return S.field;case S.field:if(!this._hasChilds())return S.value;default:return null}}},{key:"_getElementName",value:function(I){var S=this;return Object.keys(this.dom).find(function(L){return S.dom[L]===I})}},{key:"_hasChilds",value:function(){return this.type==="array"||this.type==="object"}},{key:"addTemplates",value:function(I,S){var L=this,Z=L.editor.options.templates;Z!=null&&(Z.length&&I.push({type:"separator"}),Z.forEach(function(J){I.push({text:J.text,className:J.className||"jsoneditor-type-object",title:J.title,click:(S?function(re,pe){L._onAppend(re,pe)}:function(re,pe){L._onInsertBefore(re,pe)}).bind(this,J.field,J.value)})}))}},{key:"showContextMenu",value:function(I,S){var L,Z=this,J=[];this.editable.value&&J.push({text:(0,G.Iu)("type"),title:(0,G.Iu)("typeTitle"),className:"jsoneditor-type-"+this.type,submenu:[{text:(0,G.Iu)("auto"),className:"jsoneditor-type-auto"+(this.type==="auto"?" jsoneditor-selected":""),title:(0,G.Iu)("autoType"),click:function(){Z._onChangeType("auto")}},{text:(0,G.Iu)("array"),className:"jsoneditor-type-array"+(this.type==="array"?" jsoneditor-selected":""),title:(0,G.Iu)("arrayType"),click:function(){Z._onChangeType("array")}},{text:(0,G.Iu)("object"),className:"jsoneditor-type-object"+(this.type==="object"?" jsoneditor-selected":""),title:(0,G.Iu)("objectType"),click:function(){Z._onChangeType("object")}},{text:(0,G.Iu)("string"),className:"jsoneditor-type-string"+(this.type==="string"?" jsoneditor-selected":""),title:(0,G.Iu)("stringType"),click:function(){Z._onChangeType("string")}}]}),this._hasChilds()&&(this.editor.options.enableSort&&J.push({text:(0,G.Iu)("sort"),title:(0,G.Iu)("sortTitle",{type:this.type}),className:"jsoneditor-sort-asc",click:function(){Z.showSortModal()}}),this.editor.options.enableTransform&&J.push({text:(0,G.Iu)("transform"),title:(0,G.Iu)("transformTitle",{type:this.type}),className:"jsoneditor-transform",click:function(){Z.showTransformModal()}}),this.parent)&&J.push({text:(0,G.Iu)("extract"),title:(0,G.Iu)("extractTitle",{type:this.type}),className:"jsoneditor-extract",click:function(){Z.extract()}}),this.parent&&this.parent._hasChilds()&&(J.length&&J.push({type:"separator"}),L=Z.parent.childs,Z===L[L.length-1]&&(L=[{text:(0,G.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,G.Iu)("autoType"),click:function(){Z._onAppend("","","auto")}},{text:(0,G.Iu)("array"),className:"jsoneditor-type-array",title:(0,G.Iu)("arrayType"),click:function(){Z._onAppend("",[])}},{text:(0,G.Iu)("object"),className:"jsoneditor-type-object",title:(0,G.Iu)("objectType"),click:function(){Z._onAppend("",{})}},{text:(0,G.Iu)("string"),className:"jsoneditor-type-string",title:(0,G.Iu)("stringType"),click:function(){Z._onAppend("","","string")}}],Z.addTemplates(L,!0),J.push({text:(0,G.Iu)("appendText"),title:(0,G.Iu)("appendTitle"),submenuTitle:(0,G.Iu)("appendSubmenuTitle"),className:"jsoneditor-append",click:function(){Z._onAppend("","","auto")},submenu:L})),L=[{text:(0,G.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,G.Iu)("autoType"),click:function(){Z._onInsertBefore("","","auto")}},{text:(0,G.Iu)("array"),className:"jsoneditor-type-array",title:(0,G.Iu)("arrayType"),click:function(){Z._onInsertBefore("",[])}},{text:(0,G.Iu)("object"),className:"jsoneditor-type-object",title:(0,G.Iu)("objectType"),click:function(){Z._onInsertBefore("",{})}},{text:(0,G.Iu)("string"),className:"jsoneditor-type-string",title:(0,G.Iu)("stringType"),click:function(){Z._onInsertBefore("","","string")}}],Z.addTemplates(L,!1),J.push({text:(0,G.Iu)("insert"),title:(0,G.Iu)("insertTitle"),submenuTitle:(0,G.Iu)("insertSub"),className:"jsoneditor-insert",click:function(){Z._onInsertBefore("","","auto")},submenu:L}),this.editable.field)&&(J.push({text:(0,G.Iu)("duplicateText"),title:(0,G.Iu)("duplicateField"),className:"jsoneditor-duplicate",click:function(){T.onDuplicate(Z)}}),J.push({text:(0,G.Iu)("removeText"),title:(0,G.Iu)("removeField"),className:"jsoneditor-remove",click:function(){T.onRemove(Z)}})),this.editor.options.onCreateMenu&&(L=Z.getPath(),J=this.editor.options.onCreateMenu(J,{type:"single",path:L,paths:[L]})),new k.x(J,{close:S}).show(I,this.editor.getPopupAnchor())}},{key:"showSortModal",value:function(){var I=this,S=this.editor.options.modalAnchor||h.qD,L=this.getValue();(0,C.showSortModal)(S,L,function(Z){var J=Z.path,J=(0,y.parsePath)(J);I.sortedBy=Z,I.sort(J,Z.direction)},I.sortedBy)}},{key:"showTransformModal",value:function(){var I=this,J=this.editor.options,S=J.modalAnchor,L=J.createQuery,Z=J.executeQuery,J=J.queryDescription,re=this.getValue();(0,d.showTransformModal)({container:S||h.qD,json:re,queryDescription:J,createQuery:L,executeQuery:Z,onTransform:function(pe){I.transform(pe)}})}},{key:"_getType",value:function(I){return I instanceof Array?"array":I instanceof Object?"object":typeof I=="string"&&typeof(0,y.parseString)(I)!="string"?"string":"auto"}},{key:"_escapeHTML",value:function(I){return typeof I!="string"?String(I):(I=String(I).replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/ {2}/g," &nbsp;").replace(/^ /,"&nbsp;").replace(/ $/,"&nbsp;"),I=(I=JSON.stringify(I)).substring(1,I.length-1),this.editor.options.escapeUnicode===!0?(0,y.escapeUnicodeChars)(I):I)}},{key:"_unescapeHTML",value:function(I){return I='"'+this._escapeJSON(I)+'"',(0,y.parse)(I).replace(/&lt;/g,"<").replace(/&gt;/g,">").replace(/&nbsp;|\u00A0/g," ").replace(/&amp;/g,"&")}},{key:"_escapeJSON",value:function(I){for(var S="",L=0;L<I.length;){var Z=I.charAt(L);Z===`
`?S+="\\n":Z==="\\"?(S+=Z,L++,(Z=I.charAt(L))!==""&&'"\\/bfnrtu'.indexOf(Z)!==-1||(S+="\\"),S+=Z):S+=Z==='"'?'\\"':Z,L++}return S}},{key:"updateNodeName",value:function(){var I=this.childs?this.childs.length:0;if(this.type==="object"||this.type==="array"){if(this.editor.options.onNodeName)try{var S=this.getValue.bind(this),L=this.editor.options.onNodeName({path:this.getPath(),size:I,type:this.type,get value(){return S()}})}catch(Z){console.error("Error in onNodeName callback: ",Z)}this.dom.value.textContent=this.type==="object"?"{"+(L||I)+"}":"["+(L||I)+"]"}}},{key:"recursivelyUpdateNodeName",value:function(){if(this.expanded&&(this.updateNodeName(),this.childs!=="undefined"))for(var I in this.childs)this.childs[I].recursivelyUpdateNodeName()}}])&&e(F.prototype,V),Object.defineProperty(F,"prototype",{writable:!1}),T}(),s=(t.prototype.DEBOUNCE_INTERVAL=150,t.prototype.MAX_SEARCH_RESULTS=999,100);function c(T){return T.getInternalPath()}function p(T){return T.getField()}function g(T,F){return Object.prototype.hasOwnProperty.call(T,F)}t.focusElement=void 0,t.select=function(T){setTimeout(function(){(0,y.selectContentEditable)(T)},0)},t.onDragStart=function(T,F){if(!Array.isArray(T))return t.onDragStart([T],F);var V,I,S,L,Z;T.length!==0&&(V=T[0],I=T[T.length-1],S=V.parent,Z=t.getNodeFromTarget(F.target),L=V.editor,Z=(0,y.getAbsoluteTop)(Z.dom.tr)-(0,y.getAbsoluteTop)(V.dom.tr),L.mousemove||(L.mousemove=(0,y.addEventListener)(F.view,"mousemove",function(J){t.onDrag(T,J)})),L.mouseup||(L.mouseup=(0,y.addEventListener)(F.view,"mouseup",function(J){t.onDragEnd(T,J)})),L.highlighter.lock(),L.drag={oldCursor:document.body.style.cursor,oldSelection:L.getDomSelection(),oldPaths:T.map(c),oldParent:S,oldNextNode:S.childs[I.getIndex()+1]||S.append,oldParentPathRedo:S.getInternalPath(),oldIndexRedo:V.getIndex(),mouseX:F.pageX,offsetY:Z,level:V.getLevel()},document.body.style.cursor="move",F.preventDefault())},t.onDrag=function(T,F){if(!Array.isArray(T))return t.onDrag([T],F);if(T.length!==0){var V,I,S,L,Z,J=T[0].editor,re=F.pageY-J.drag.offsetY,pe=F.pageX,me=!1,ye=T[0],xe=ye.dom.tr,be=(0,y.getAbsoluteTop)(xe),Ae=xe.offsetHeight;if(re<be){for(Se=xe;Se=Se.previousSibling,ve=t.getNodeFromTarget(Se),S=Se?(0,y.getAbsoluteTop)(Se):0,Se&&re<S;);(ve=ve&&!ve.parent?void 0:ve)||(Se=(xe=xe.parentNode.firstChild)?xe.nextSibling:void 0,(ve=t.getNodeFromTarget(Se))===ye&&(ve=void 0)),!(ve=ve&&ve.isVisible()&&(S=(Se=ve.dom.tr)?(0,y.getAbsoluteTop)(Se):0)+Ae<re?void 0:ve)||J.options.limitDragging!==!1&&ve.parent!==T[0].parent||(T.forEach(function(Pe){ve.parent.moveBefore(Pe,ve)}),me=!0)}else{var we=T[T.length-1];if(Ae=(xe=we.expanded&&we.append?we.append.getDom():we.dom.tr)?xe.nextSibling:void 0){for(L=(0,y.getAbsoluteTop)(Ae),V=Ae;I=t.getNodeFromTarget(V),V&&(Z=V.nextSibling?(0,y.getAbsoluteTop)(V.nextSibling):0,Z=V?Z-L:0,I&&I.parent.childs.length===T.length&&I.parent.childs[T.length-1]===we&&(be+=27),V=V.nextSibling),V&&be+Z<re;);if(I&&I.parent){for(var Ae=pe-J.drag.mouseX,Ae=Math.round(Ae/24/2),Re=J.drag.level+Ae,We=I.getLevel(),Se=I.dom.tr&&I.dom.tr.previousSibling;We<Re&&Se;){var ve=t.getNodeFromTarget(Se),Le=T.some(function(ge){return ge===ve||ve.isDescendantOf(ge)});if(!Le){if(!(ve instanceof b)||(Le=ve.parent.childs,Le.length===T.length&&Le[T.length-1]===we))break;We=(I=t.getNodeFromTarget(Se)).getLevel()}Se=Se.previousSibling}(I=I instanceof b&&!I.isVisible()&&I.parent.showMore.isVisible()?I._nextNode():I)&&(J.options.limitDragging===!1||I.parent===T[0].parent)&&I.dom.tr&&I.dom.tr!==xe.nextSibling&&(T.forEach(function(Pe){I.parent.moveBefore(Pe,I)}),me=!0)}}}me&&(J.drag.mouseX=pe,J.drag.level=ye.getLevel()),J.startAutoScroll(re),F.preventDefault()}},t.onDragEnd=function(T,F){if(!Array.isArray(T))return t.onDrag([T],F);var V,I,S,L,Z,J,re,pe,me;T.length!==0&&(J=T[0],V=J.editor,J&&J.dom.menu&&J.dom.menu.focus(),I=V.drag.oldParent.getInternalPath(),S=J.parent.getInternalPath(),L=V.drag.oldParent===J.parent,Z=V.drag.oldNextNode.getIndex(),J=J.getIndex(),re=V.drag.oldParentPathRedo,pe=V.drag.oldIndexRedo,me=L&&pe<J?J+T.length:J,L&&pe===J||V._onAction("moveNodes",{count:T.length,fieldNames:T.map(p),oldParentPath:I,newParentPath:S,oldIndex:Z,newIndex:J,oldIndexRedo:pe,newIndexRedo:me,oldParentPathRedo:re,newParentPathRedo:null,oldSelection:V.drag.oldSelection,newSelection:V.getDomSelection()}),document.body.style.cursor=V.drag.oldCursor,V.highlighter.unlock(),T.forEach(function(ye){ye.updateDom(),F.target!==ye.dom.drag&&F.target!==ye.dom.menu&&V.highlighter.unhighlight()}),delete V.drag,V.mousemove&&((0,y.removeEventListener)(F.view,"mousemove",V.mousemove),delete V.mousemove),V.mouseup&&((0,y.removeEventListener)(F.view,"mouseup",V.mouseup),delete V.mouseup),V.stopAutoScroll(),F.preventDefault())},t._findEnum=function(T){return T.enum?T.enum:(T=T.oneOf||T.anyOf||T.allOf,T&&(T=T.filter(function(F){return F.enum}),0<T.length)?T[0].enum:null)},t._findSchema=function(T,F,V){for(var I=3<arguments.length&&arguments[3]!==void 0?arguments[3]:T,S=V.slice(1,V.length),L=V[0],Z=[I],J=0,re=[I.oneOf,I.anyOf,I.allOf];J<re.length;J++){var pe=re[J];Array.isArray(pe)&&(Z=Z.concat(pe))}var me,ye=o(Z);try{for(ye.s();!(me=ye.n()).done;){if("$ref"in(I=me.value)&&typeof I.$ref=="string"){var xe,be=I.$ref;if(be in F)I=F[be];else{if(!be.startsWith("#/")){if(((xe=be.match(/#\//g))==null?void 0:xe.length)===1){var Ae,we,Re,We=n(be.split("#/"),2),Se=We[0],ve=We[1];if(Se in F)return Ae=F[Se],we={$ref:"#/".concat(ve)},(Re=[]).push(L),0<S.length&&Re.push.apply(Re,l(S)),t._findSchema(Ae,F,Re,we)}throw Error("Unable to resolve reference ".concat(be))}var Le,Pe=be.substring(2).split("/"),I=T,ge=o(Pe);try{for(ge.s();!(Le=ge.n()).done;){var te=Le.value;if(!(te in I))throw Error("Unable to resolve reference ".concat(be));I=I[te]}}catch(fe){ge.e(fe)}finally{ge.f()}}}if(L===void 0)return I;if(typeof L=="string"){if(r(I.properties)==="object"&&I.properties!==null&&L in I.properties)return I=I.properties[L],t._findSchema(T,F,S,I);if(r(I.patternProperties)==="object"&&I.patternProperties!==null){for(var ie in I.patternProperties)if(L.match(ie))return I=I.patternProperties[ie],t._findSchema(T,F,S,I)}if(r(I.additionalProperties)==="object")return I=I.additionalProperties,t._findSchema(T,F,S,I)}else if(typeof L=="number"&&r(I.items)==="object"&&I.items!==null)return I=I.items,t._findSchema(T,F,S,I)}}catch(ce){ye.e(ce)}finally{ye.f()}return null},t.onRemove=function(T){if(!Array.isArray(T))return t.onRemove([T]);var F,V,I,S,L,Z;T&&0<T.length&&(F=(I=T[0]).parent,V=I.editor,I=I.getIndex(),V.highlighter.unhighlight(),S=V.getDomSelection(),t.blurNodes(T),L=V.getDomSelection(),Z=T.map(c),T.forEach(function(J){J.parent._remove(J)}),V._onAction("removeNodes",{nodes:T,paths:Z,parentPath:F.getInternalPath(),index:I,oldSelection:S,newSelection:L}))},t.onDuplicate=function(T){if(!Array.isArray(T))return t.onDuplicate([T]);var F,V,I,S,L,Z,J;T&&0<T.length&&(F=T[T.length-1],V=F.parent,(I=F.editor).deselect(I.multiselection.nodes),S=I.getDomSelection(),L=F,Z=T.map(function(re){var pe,me=re.clone();return re.parent.type==="object"&&(pe=re.parent.getFieldNames(),me.field=(0,y.findUniqueName)(re.field,pe)),V.insertAfter(me,L),L=me}),T.length===1?Z[0].parent.type==="object"?(Z[0].dom.field.innerHTML=T[0]._escapeHTML(T[0].field),Z[0].focus("field")):Z[0].focus():I.select(Z),J=I.getDomSelection(),I._onAction("duplicateNodes",{paths:T.map(c),clonePaths:Z.map(c),afterPath:F.getInternalPath(),parentPath:V.getInternalPath(),oldSelection:S,newSelection:J}))},t.getNodeFromTarget=function(T){for(;T;){if(T.node)return T.node;T=T.parentNode}},t.targetIsColorPicker=function(T){var F=t.getNodeFromTarget(T);if(F)for(var V=T&&T.parentNode;V;){if(V===F.dom.color)return!0;V=V.parentNode}return!1},t.blurNodes=function(T){var F,V;Array.isArray(T)?(F=(V=T[0]).parent,V=V.getIndex(),(F.childs[V+T.length]?F.childs[V+T.length]:F.childs[V-1]||F).focus()):t.blurNodes([T])},(w.prototype=new t).getDom=function(){var T=this.dom;if(T.tr)return T.tr;this._updateEditability();var F=document.createElement("tr"),V=(F.className="jsoneditor-append",F.node=this,T.tr=F,this.editor.options.mode==="tree"&&(T.tdDrag=document.createElement("td"),I=document.createElement("td"),T.tdMenu=I,(V=document.createElement("button")).type="button",V.className="jsoneditor-button jsoneditor-contextmenu-button",V.title="Click to open the actions menu (Ctrl+M)",T.menu=V,I.appendChild(T.menu)),document.createElement("td")),I=document.createElement("div");return I.appendChild(document.createTextNode("("+(0,G.Iu)("empty")+")")),I.className="jsoneditor-readonly",V.appendChild(I),T.td=V,T.text=I,this.updateDom(),F},w.prototype.getPath=function(){return null},w.prototype.getIndex=function(){return null},w.prototype.updateDom=function(T){var F=this.dom,V=F.td,I=(V&&(V.style.paddingLeft=24*this.getLevel()+26+"px"),F.text),I=(I&&(I.firstChild.nodeValue="("+(0,G.Iu)("empty")+" "+this.parent.type+")"),F.tr);this.isVisible()?F.tr.firstChild||(F.tdDrag&&I.appendChild(F.tdDrag),F.tdMenu&&I.appendChild(F.tdMenu),I.appendChild(V)):F.tr.firstChild&&(F.tdDrag&&I.removeChild(F.tdDrag),F.tdMenu&&I.removeChild(F.tdMenu),I.removeChild(V))},w.prototype.isVisible=function(){return this.parent.childs.length===0},w.prototype.showContextMenu=function(T,F){var V,I=this,S=[{text:(0,G.Iu)("auto"),className:"jsoneditor-type-auto",title:(0,G.Iu)("autoType"),click:function(){I._onAppend("","","auto")}},{text:(0,G.Iu)("array"),className:"jsoneditor-type-array",title:(0,G.Iu)("arrayType"),click:function(){I._onAppend("",[])}},{text:(0,G.Iu)("object"),className:"jsoneditor-type-object",title:(0,G.Iu)("objectType"),click:function(){I._onAppend("",{})}},{text:(0,G.Iu)("string"),className:"jsoneditor-type-string",title:(0,G.Iu)("stringType"),click:function(){I._onAppend("","","string")}}],S=(I.addTemplates(S,!0),[{text:(0,G.Iu)("appendText"),title:(0,G.Iu)("appendTitleAuto"),submenuTitle:(0,G.Iu)("appendSubmenuTitle"),className:"jsoneditor-insert",click:function(){I._onAppend("","","auto")},submenu:S}]);this.editor.options.onCreateMenu&&(V=I.parent.getPath(),S=this.editor.options.onCreateMenu(S,{type:"append",path:V,paths:[V]})),new k.x(S,{close:F}).show(T,this.editor.getPopupAnchor())},w.prototype.onEvent=function(T){var F,V=T.type,I=T.target||T.srcElement,S=this.dom;I===S.menu&&(V==="mouseover"?this.editor.highlighter.highlight(this.parent):V==="mouseout"&&this.editor.highlighter.unhighlight()),V==="click"&&I===S.menu&&((F=this.editor.highlighter).highlight(this.parent),F.lock(),(0,y.addClassName)(S.menu,"jsoneditor-selected"),this.showContextMenu(S.menu,function(){(0,y.removeClassName)(S.menu,"jsoneditor-selected"),F.unlock(),F.unhighlight()})),V==="keydown"&&this.onKeyDown(T)};var b=w;function w(T){this.editor=T,this.dom={}}(W.prototype=new t).getDom=function(){var T,F,V,I,S,L;return this.dom.tr||(this._updateEditability(),this.dom.tr||(F=(T=this).parent,(S=document.createElement("a")).appendChild(document.createTextNode((0,G.Iu)("showMore"))),S.href="#",S.onclick=function(Z){return F.visibleChilds=Math.floor(F.visibleChilds/F.getMaxVisibleChilds()+1)*F.getMaxVisibleChilds(),T.updateDom(),F.showChilds(),Z.preventDefault(),!1},(L=document.createElement("a")).appendChild(document.createTextNode((0,G.Iu)("showAll"))),L.href="#",L.onclick=function(Z){return F.visibleChilds=1/0,T.updateDom(),F.showChilds(),Z.preventDefault(),!1},V=document.createElement("div"),I=document.createTextNode(this._getShowMoreText()),V.className="jsoneditor-show-more",V.appendChild(I),V.appendChild(S),V.appendChild(document.createTextNode(". ")),V.appendChild(L),V.appendChild(document.createTextNode(". ")),(S=document.createElement("td")).appendChild(V),L=document.createElement("tr"),this.editor.options.mode==="tree"&&(L.appendChild(document.createElement("td")),L.appendChild(document.createElement("td"))),L.appendChild(S),L.className="jsoneditor-show-more",this.dom.tr=L,this.dom.moreContents=V,this.dom.moreText=I),this.updateDom()),this.dom.tr},W.prototype.updateDom=function(T){var F;this.isVisible()?(this.dom.tr.node=this.parent.childs[this.parent.visibleChilds],this.dom.tr.parentNode||(F=this.parent._getNextTr())&&F.parentNode.insertBefore(this.dom.tr,F),this.dom.moreText.nodeValue=this._getShowMoreText(),this.dom.moreContents.style.marginLeft=24*(this.getLevel()+1)+"px"):this.dom.tr&&this.dom.tr.parentNode&&this.dom.tr.parentNode.removeChild(this.dom.tr)},W.prototype._getShowMoreText=function(){return(0,G.Iu)("showMoreStatus",{visibleChilds:this.parent.visibleChilds,totalChilds:this.parent.childs.length})+" "},W.prototype.isVisible=function(){return this.parent.expanded&&this.parent.childs.length>this.parent.visibleChilds},W.prototype.onEvent=function(T){T.type==="keydown"&&this.onKeyDown(T)};var E=W;function W(T,F){this.editor=T,this.parent=F,this.dom={}}function B(T){return(B=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(F){return typeof F}:function(F){return F&&typeof Symbol=="function"&&F.constructor===Symbol&&F!==Symbol.prototype?"symbol":typeof F})(T)}function O(T,F){for(var V=0;V<F.length;V++){var I=F[V];I.enumerable=I.enumerable||!1,I.configurable=!0,"value"in I&&(I.writable=!0),Object.defineProperty(T,function(S){return S=function(L,Z){if(B(L)!=="object"||L===null)return L;var J=L[Symbol.toPrimitive];if(J===void 0)return(Z==="string"?String:Number)(L);if(J=J.call(L,Z||"default"),B(J)!=="object")return J;throw new TypeError("@@toPrimitive must return a primitive value.")}(S,"string"),B(S)==="symbol"?S:String(S)}(I.key),I)}}var x=function(){function T(I){if(!(this instanceof T))throw new TypeError("Cannot call a class as a function");function S(L){return I.node.findNodeByInternalPath(L)}this.editor=I,this.history=[],this.index=-1,this.clear(),this.actions={editField:{undo:function(L){S(L.parentPath).childs[L.index].updateField(L.oldValue)},redo:function(L){S(L.parentPath).childs[L.index].updateField(L.newValue)}},editValue:{undo:function(L){S(L.path).updateValue(L.oldValue)},redo:function(L){S(L.path).updateValue(L.newValue)}},changeType:{undo:function(L){S(L.path).changeType(L.oldType)},redo:function(L){S(L.path).changeType(L.newType)}},appendNodes:{undo:function(L){var Z=S(L.parentPath);L.paths.map(S).forEach(function(J){Z.removeChild(J)})},redo:function(L){var Z=S(L.parentPath);L.nodes.forEach(function(J){Z.appendChild(J)})}},insertBeforeNodes:{undo:function(L){var Z=S(L.parentPath);L.paths.map(S).forEach(function(J){Z.removeChild(J)})},redo:function(L){var Z=S(L.parentPath),J=S(L.beforePath);L.nodes.forEach(function(re){Z.insertBefore(re,J)})}},insertAfterNodes:{undo:function(L){var Z=S(L.parentPath);L.paths.map(S).forEach(function(J){Z.removeChild(J)})},redo:function(L){var Z=S(L.parentPath),J=S(L.afterPath);L.nodes.forEach(function(re){Z.insertAfter(re,J),J=re})}},removeNodes:{undo:function(L){var Z=S(L.parentPath),J=Z.childs[L.index]||Z.append;L.nodes.forEach(function(re){Z.insertBefore(re,J)})},redo:function(L){var Z=S(L.parentPath);L.paths.map(S).forEach(function(J){Z.removeChild(J)})}},duplicateNodes:{undo:function(L){var Z=S(L.parentPath);L.clonePaths.map(S).forEach(function(J){Z.removeChild(J)})},redo:function(L){var Z=S(L.parentPath),J=S(L.afterPath);L.paths.map(S).forEach(function(re){var pe,me=re.clone();Z.type==="object"&&(pe=Z.getFieldNames(),me.field=(0,y.findUniqueName)(re.field,pe)),Z.insertAfter(me,J),J=me})}},moveNodes:{undo:function(L){var Z=S(L.oldParentPath),J=S(L.newParentPath),re=Z.childs[L.oldIndex]||Z.append;J.childs.slice(L.newIndex,L.newIndex+L.count).forEach(function(pe,me){pe.field=L.fieldNames[me],Z.moveBefore(pe,re)}),L.newParentPathRedo===null&&(L.newParentPathRedo=J.getInternalPath())},redo:function(L){var Z=S(L.oldParentPathRedo),J=S(L.newParentPathRedo),re=J.childs[L.newIndexRedo]||J.append;Z.childs.slice(L.oldIndexRedo,L.oldIndexRedo+L.count).forEach(function(pe,me){pe.field=L.fieldNames[me],J.moveBefore(pe,re)})}},sort:{undo:function(L){var Z=S(L.path);Z.hideChilds(),Z.childs=L.oldChilds,Z.updateDom({updateIndexes:!0}),Z.showChilds()},redo:function(L){var Z=S(L.path);Z.hideChilds(),Z.childs=L.newChilds,Z.updateDom({updateIndexes:!0}),Z.showChilds()}},transform:{undo:function(L){S(L.path).setInternalValue(L.oldValue)},redo:function(L){S(L.path).setInternalValue(L.newValue)}}}}var F,V;return F=T,(V=[{key:"onChange",value:function(){}},{key:"add",value:function(I,S){this.index++,this.history[this.index]={action:I,params:S,timestamp:new Date},this.index<this.history.length-1&&this.history.splice(this.index+1,this.history.length-this.index-1),this.onChange()}},{key:"clear",value:function(){this.history=[],this.index=-1,this.onChange()}},{key:"canUndo",value:function(){return 0<=this.index}},{key:"canRedo",value:function(){return this.index<this.history.length-1}},{key:"undo",value:function(){if(this.canUndo()){var I=this.history[this.index];if(I){var S=this.actions[I.action];if(S&&S.undo){if(S.undo(I.params),I.params.oldSelection)try{this.editor.setDomSelection(I.params.oldSelection)}catch(L){console.error(L)}}else console.error(new Error('unknown action "'+I.action+'"'))}this.index--,this.onChange()}}},{key:"redo",value:function(){if(this.canRedo()){this.index++;var I=this.history[this.index];if(I){var S=this.actions[I.action];if(S&&S.redo){if(S.redo(I.params),I.params.newSelection)try{this.editor.setDomSelection(I.params.newSelection)}catch(L){console.error(L)}}else console.error(new Error('unknown action "'+I.action+'"'))}this.onChange()}}},{key:"destroy",value:function(){this.editor=null,this.history=[],this.index=-1}}])&&O(F.prototype,V),Object.defineProperty(F,"prototype",{writable:!1}),T}();function u(T){return(u=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(F){return typeof F}:function(F){return F&&typeof Symbol=="function"&&F.constructor===Symbol&&F!==Symbol.prototype?"symbol":typeof F})(T)}function _(T,F){for(var V=0;V<F.length;V++){var I=F[V];I.enumerable=I.enumerable||!1,I.configurable=!0,"value"in I&&(I.writable=!0),Object.defineProperty(T,function(S){return S=function(L,Z){if(u(L)!=="object"||L===null)return L;var J=L[Symbol.toPrimitive];if(J===void 0)return(Z==="string"?String:Number)(L);if(J=J.call(L,Z||"default"),u(J)!=="object")return J;throw new TypeError("@@toPrimitive must return a primitive value.")}(S,"string"),u(S)==="symbol"?S:String(S)}(I.key),I)}}var v=function(){function T(re,Z){if(!(this instanceof T))throw new TypeError("Cannot call a class as a function");var L=this,re=(this.editor=re,this.timeout=void 0,this.delay=200,this.lastText=void 0,this.results=null,this.dom={},this.dom.container=Z,document.createElement("div")),Z=((this.dom.wrapper=re).className="jsoneditor-search",Z.appendChild(re),document.createElement("div")),Z=((this.dom.results=Z).className="jsoneditor-results",re.appendChild(Z),document.createElement("div")),re=((this.dom.input=Z).className="jsoneditor-frame",Z.title=(0,G.Iu)("searchTitle"),re.appendChild(Z),document.createElement("button")),J=(re.type="button",re.className="jsoneditor-refresh",Z.appendChild(re),document.createElement("input")),re=(J.type="text",(this.dom.search=J).oninput=function(pe){L._onDelayedSearch(pe)},J.onchange=function(pe){L._onSearch()},J.onkeydown=function(pe){L._onKeyDown(pe)},J.onkeyup=function(pe){L._onKeyUp(pe)},re.onclick=function(pe){J.select()},Z.appendChild(J),document.createElement("button")),re=(re.type="button",re.title=(0,G.Iu)("searchNextResultTitle"),re.className="jsoneditor-next",re.onclick=function(){L.next()},Z.appendChild(re),document.createElement("button"));re.type="button",re.title=(0,G.Iu)("searchPreviousResultTitle"),re.className="jsoneditor-previous",re.onclick=function(){L.previous()},Z.appendChild(re)}var F,V;return F=T,(V=[{key:"next",value:function(I){var S;this.results&&((S=this.resultIndex!==null?this.resultIndex+1:0)>this.results.length-1&&(S=0),this._setActiveResult(S,I))}},{key:"previous",value:function(I){var S,L;this.results&&(S=this.results.length-1,L=this.resultIndex!==null?this.resultIndex-1:S,this._setActiveResult(L=L<0?S:L,I))}},{key:"_setActiveResult",value:function(I,S){var L,Z,J;this.activeResult&&(L=this.activeResult.node,this.activeResult.elem==="field"?delete L.searchFieldActive:delete L.searchValueActive,L.updateDom()),this.results&&this.results[I]?(this.resultIndex=I,Z=this.results[this.resultIndex].node,(J=this.results[this.resultIndex].elem)==="field"?Z.searchFieldActive=!0:Z.searchValueActive=!0,this.activeResult=this.results[this.resultIndex],Z.updateDom(),Z.scrollTo(function(){S&&Z.focus(J)})):(this.resultIndex=void 0,this.activeResult=void 0)}},{key:"_clearDelay",value:function(){this.timeout!==void 0&&(clearTimeout(this.timeout),delete this.timeout)}},{key:"_onDelayedSearch",value:function(I){this._clearDelay();var S=this;this.timeout=setTimeout(function(L){S._onSearch()},this.delay)}},{key:"_onSearch",value:function(I){this._clearDelay();var S=this.dom.search.value,S=0<S.length?S:void 0;if(S!==this.lastText||I){this.lastText=S,this.results=this.editor.search(S);var I=this.results[0]?this.results[0].node.MAX_SEARCH_RESULTS:1/0,L=0;if(this.activeResult){for(var Z=0;Z<this.results.length;Z++)if(this.results[Z].node===this.activeResult.node){L=Z;break}}this._setActiveResult(L,!1),S!==void 0?(S=this.results.length,this.dom.results.textContent=S===0?"no results":S===1?"1 result":I<S?I+"+ results":S+" results"):this.dom.results.textContent=""}}},{key:"_onKeyDown",value:function(I){var S=I.which;S===27?(this.dom.search.value="",this._onSearch(),I.preventDefault(),I.stopPropagation()):S===13&&(I.ctrlKey?this._onSearch(!0):I.shiftKey?this.previous():this.next(),I.preventDefault(),I.stopPropagation())}},{key:"_onKeyUp",value:function(I){var S=I.keyCode;S!==27&&S!==13&&this._onDelayedSearch(I)}},{key:"clear",value:function(){this.dom.search.value="",this._onSearch()}},{key:"forceSearch",value:function(){this._onSearch(!0)}},{key:"isEmpty",value:function(){return this.dom.search.value===""}},{key:"destroy",value:function(){this.editor=null,this.dom.container.removeChild(this.dom.wrapper),this.dom=null,this.results=null,this.activeResult=null,this._clearDelay()}}])&&_(F.prototype,V),Object.defineProperty(F,"prototype",{writable:!1}),T}();function $(T){return($=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(F){return typeof F}:function(F){return F&&typeof Symbol=="function"&&F.constructor===Symbol&&F!==Symbol.prototype?"symbol":typeof F})(T)}function P(T,F){for(var V=0;V<F.length;V++){var I=F[V];I.enumerable=I.enumerable||!1,I.configurable=!0,"value"in I&&(I.writable=!0),Object.defineProperty(T,function(S){return S=function(L,Z){if($(L)!=="object"||L===null)return L;var J=L[Symbol.toPrimitive];if(J===void 0)return(Z==="string"?String:Number)(L);if(J=J.call(L,Z||"default"),$(J)!=="object")return J;throw new TypeError("@@toPrimitive must return a primitive value.")}(S,"string"),$(S)==="symbol"?S:String(S)}(I.key),I)}}var M=function(){function T(I,S){if(!(this instanceof T))throw new TypeError("Cannot call a class as a function");I&&(this.root=S,this.path=document.createElement("div"),this.path.className="jsoneditor-treepath",this.path.setAttribute("tabindex",0),this.contentMenuClicked=!1,I.appendChild(this.path),this.reset())}var F,V;return F=T,(V=[{key:"reset",value:function(){this.path.textContent=(0,G.Iu)("selectNode")}},{key:"setPath",value:function(I){var S=this;this.path.textContent="",I&&I.length&&I.forEach(function(L,Z){var J,re=document.createElement("span");re.className="jsoneditor-treepath-element",re.innerText=L.name,re.onclick=(function(pe){this.selectionCallback&&this.selectionCallback(pe)}).bind(S,L),S.path.appendChild(re),L.children.length&&((J=document.createElement("span")).className="jsoneditor-treepath-seperator",J.textContent="►",J.onclick=function(){S.contentMenuClicked=!0;var pe=[];L.children.forEach(function(me){pe.push({text:me.name,className:"jsoneditor-type-modes"+(I[Z+1]+1&&I[Z+1].name===me.name?" jsoneditor-selected":""),click:(function(ye,xe){this.contextMenuCallback&&this.contextMenuCallback(ye,xe)}).bind(S,L,me.name)})}),new k.x(pe,{limitHeight:!0}).show(J,S.root,!0)},S.path.appendChild(J)),Z===I.length-1&&(re=(J||re).getBoundingClientRect().right,S.path.offsetWidth<re&&(S.path.scrollLeft=re),S.path.scrollLeft)&&((re=document.createElement("span")).className="jsoneditor-treepath-show-all-btn",re.title="show all path",re.textContent="...",re.onclick=(function(pe){(S.contentMenuClicked=!1,y.addClassName)(S.path,"show-all"),S.path.style.width=S.path.parentNode.getBoundingClientRect().width-10+"px",S.path.onblur=function(){S.contentMenuClicked?(S.contentMenuClicked=!1,S.path.focus()):((0,y.removeClassName)(S.path,"show-all"),S.path.onblur=void 0,S.path.style.width="",S.setPath(pe))}}).bind(S,I),S.path.insertBefore(re,S.path.firstChild))})}},{key:"onSectionSelected",value:function(I){typeof I=="function"&&(this.selectionCallback=I)}},{key:"onContextMenuItemSelected",value:function(I){typeof I=="function"&&(this.contextMenuCallback=I)}}])&&P(F.prototype,V),Object.defineProperty(F,"prototype",{writable:!1}),T}(),X=K(8037),Q=K.n(X),K={},ne=(K.create=function(T,F){if(!T)throw new Error("No container element provided.");function V(te){var ie,ce;document.createRange?((ie=document.createRange()).selectNodeContents(te),ie.collapse(!1),(ce=window.getSelection()).removeAllRanges(),ce.addRange(ie)):document.selection&&((ie=document.body.createTextRange()).moveToElementText(te),ie.collapse(!1),ie.select())}function I(te){return re===void 0&&((re=document.createElement("span")).style.visibility="hidden",re.style.position="fixed",re.style.outline="0",re.style.margin="0",re.style.padding="0",re.style.border="0",re.style.left="0",re.style.whiteSpace="pre",re.style.fontSize=me,re.style.fontFamily=ye,re.style.fontWeight="normal",document.body.appendChild(re)),re.textContent=te,re.getBoundingClientRect().right}function S(){this.style.backgroundColor="#ddd"}function L(){this.style.backgroundColor=""}function Z(){Se.hide(),Se.onmouseselection(this.__hint,Se.rs)}var J,re,pe,me,ye,xe,be,Ae,we,Re,We,Se,ve,Le,Pe,ge;this.container=T,this.dom={},this.highlighter=new Y,this.selection=void 0,this.multiselection={nodes:[]},this.validateSchema=null,this.validationSequence=0,this.errorNodes=[],this.lastSchemaErrors=void 0,this.node=null,this.focusTarget=null,this._setOptions(F),F.autocomplete&&(this.autocomplete=((J=(J=F.autocomplete)||{}).filter=J.filter||"start",J.trigger=J.trigger||"keydown",J.confirmKeys=J.confirmKeys||[39,35,9],J.caseSensitive=J.caseSensitive||!1,ye=me="",(xe=document.createElement("div")).style.position="relative",xe.style.outline="0",xe.style.border="0",xe.style.margin="0",xe.style.padding="0",(be=document.createElement("div")).className="autocomplete dropdown",be.style.position="absolute",be.style.visibility="hidden",Ae=be,we=[],We=-1,Le=Se={rs:ve={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},startFrom:Re=0,options:[],element:null,elementHint:null,elementStyle:null,wrapper:xe,show:function(te,ie,ce){var fe=this;this.startFrom=ie,this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null),me===""&&(me=window.getComputedStyle(te).getPropertyValue("font-size")),ye===""&&(ye=window.getComputedStyle(te).getPropertyValue("font-family")),be.style.marginLeft="0",be.style.marginTop=te.getBoundingClientRect().height+"px",this.options=ce.map(String),this.element!==te&&(this.element=te,this.elementStyle={zIndex:this.element.style.zIndex,position:this.element.style.position,backgroundColor:this.element.style.backgroundColor,borderColor:this.element.style.borderColor}),this.element.style.zIndex=3,this.element.style.position="relative",this.element.style.backgroundColor="transparent",this.element.style.borderColor="transparent",this.elementHint=te.cloneNode(),this.elementHint.className="autocomplete hint",this.elementHint.style.zIndex=2,this.elementHint.style.position="absolute",this.elementHint.onfocus=function(){fe.element.focus()},this.element.addEventListener&&(this.element.removeEventListener("keydown",Pe),this.element.addEventListener("keydown",Pe,!1),this.element.removeEventListener("blur",ge),this.element.addEventListener("blur",ge,!1)),xe.appendChild(this.elementHint),xe.appendChild(be),te.parentElement.appendChild(xe),this.repaint(te)},setText:function(te){this.element.innerText=te},getText:function(){return this.element.innerText},hideDropDown:function(){this.wrapper.remove(),this.elementHint&&(this.elementHint.remove(),this.elementHint=null,Le.hide(),this.element.style.zIndex=this.elementStyle.zIndex,this.element.style.position=this.elementStyle.position,this.element.style.backgroundColor=this.elementStyle.backgroundColor,this.element.style.borderColor=this.elementStyle.borderColor)},repaint:function(ie){var ie=(ie=ie.innerText).replace(`
`,""),ce=this.options.length,fe=ie.substring(this.startFrom);pe=ie.substring(0,this.startFrom);for(var Ie=0;Ie<ce;Ie++){var $e=this.options[Ie];if(!J.caseSensitive&&$e.toLowerCase().indexOf(fe.toLowerCase())===0||J.caseSensitive&&$e.indexOf(fe)===0){this.elementHint.innerText=pe+fe+$e.substring(fe.length),this.elementHint.realInnerText=pe+$e;break}}be.style.left=I(pe)+"px",Le.refresh(fe,this.options),this.elementHint.style.width=I(this.elementHint.innerText)+10+"px",be.style.visibility!=="hidden"&&(this.elementHint.style.width=I(this.elementHint.innerText)+be.clientWidth+"px")}},hide:function(){Ae.style.visibility="hidden"},refresh:function(te,ie){Ae.style.visibility="hidden",Re=0,Ae.textContent="";var fe=window.innerHeight||document.documentElement.clientHeight,$e=Ae.parentNode.getBoundingClientRect(),ce=$e.top-6,fe=fe-$e.bottom-6,Ie=(we=[],typeof J.filter=="function"?J.filter:U[J.filter]),$e=Ie?ie.filter(function(ee){return Ie(J.caseSensitive?te:te.toLowerCase(),J.caseSensitive?ee:ee.toLowerCase(),J)}):[];(we=$e.map(function(ee){var ae=document.createElement("div"),he=(ae.className="item",ae.onmouseover=S,ae.onmouseout=L,ae.onmousedown=Z,ae.__hint=ee,ae.textContent="",ae.appendChild(document.createTextNode(ee.substring(0,te.length))),document.createElement("b"));return he.appendChild(document.createTextNode(ee.substring(te.length))),ae.appendChild(he),Ae.appendChild(ae),ae})).length===0||we.length===1&&(te.toLowerCase()===we[0].__hint.toLowerCase()&&!J.caseSensitive||te===we[0].__hint&&J.caseSensitive)||we.length<2||(Se.highlight(0),3*fe<ce?(Ae.style.maxHeight=ce+"px",Ae.style.top="",Ae.style.bottom="100%"):(Ae.style.top="100%",Ae.style.bottom="",Ae.style.maxHeight=fe+"px"),Ae.style.visibility="visible")},highlight:function(te){We!==-1&&we[We]&&(we[We].className="item"),we[te].className="item hover",We=te},move:function(te){return Ae.style.visibility==="hidden"?"":(Re+te!==-1&&Re+te!==we.length&&(Re+=te,Se.highlight(Re)),we[Re].__hint)},onmouseselection:function(){}},Pe=(function(te){var ie=(te=te||window.event).keyCode;if(this.elementHint!=null&&ie!==33&&ie!==34)if(ie===27)ve.hideDropDown(),ve.element.focus(),te.preventDefault(),te.stopPropagation();else{var ce,fe=(fe=this.element.innerText).replace(`
`,"");if(0<=J.confirmKeys.indexOf(ie))ie===9&&this.elementHint.innerText.length===0&&ve.onTab(),0<this.elementHint.innerText.length&&this.element.innerText!==this.elementHint.realInnerText&&(this.element.innerText=this.elementHint.realInnerText,ve.hideDropDown(),V(this.element),ie===9)&&(ve.element.focus(),te.preventDefault(),te.stopPropagation());else if(ie===13)if(this.elementHint.innerText.length===0)ve.onEnter();else{var Ie=be.style.visibility==="hidden";if(Le.hide(),Ie)return ve.hideDropDown(),ve.element.focus(),void ve.onEnter();this.element.innerText=this.elementHint.realInnerText,ve.hideDropDown(),V(this.element),te.preventDefault(),te.stopPropagation()}else ie===40?(Ie=fe.substring(this.startFrom),(ce=Le.move(1))===""&&ve.onArrowDown(),this.elementHint.innerText=pe+Ie+ce.substring(Ie.length),this.elementHint.realInnerText=pe+ce,te.preventDefault(),te.stopPropagation()):ie===38&&(Ie=fe.substring(this.startFrom),(ce=Le.move(-1))===""&&ve.onArrowUp(),this.elementHint.innerText=pe+Ie+ce.substring(Ie.length),this.elementHint.realInnerText=pe+ce,te.preventDefault(),te.stopPropagation())}}).bind(ve),ge=function(te){ve.hideDropDown()},Le.onmouseselection=function(te,ie){ie.element.innerText=ie.elementHint.innerText=pe+te,ie.hideDropDown(),window.setTimeout(function(){ie.element.focus(),V(ie.element)},1)},ve)),this.options.history&&this.options.mode!=="view"&&(this.history=new x(this)),this._createFrame(),this._createTable()},K.destroy=function(){this.frame&&this.container&&this.frame.parentNode===this.container&&(this.container.removeChild(this.frame),this.frame=null),this.container=null,this.dom=null,this.clear(),this.node=null,this.focusTarget=null,this.selection=null,this.multiselection=null,this.errorNodes=null,this.validateSchema=null,this._debouncedValidate=null,this.history&&(this.history.destroy(),this.history=null),this.searchBox&&(this.searchBox.destroy(),this.searchBox=null),this.modeSwitcher&&(this.modeSwitcher.destroy(),this.modeSwitcher=null),this.frameFocusTracker.destroy()},K._setOptions=function(T){var F=this;this.options={search:!0,history:!0,mode:"tree",name:void 0,schema:null,schemaRefs:null,autocomplete:null,navigationBar:!0,mainMenuBar:!0,limitDragging:!1,onSelectionChange:null,colorPicker:!0,onColorPicker:function(V,I,S){var L;Q()?(L=V.getBoundingClientRect().top,L=(0,y.getWindow)(V).innerHeight-L<300&&300<L,new(Q())({parent:V,color:I,popup:L?"top":"bottom",onDone:function(Z){Z=Z.rgba[3]===1?Z.hex.substr(0,7):Z.hex,S(Z)}}).show()):console.warn("Cannot open color picker: the `vanilla-picker` library is not included in the bundle. Either use the full bundle or implement your own color picker using `onColorPicker`.")},timestampTag:!0,timestampFormat:null,createQuery:N.r,executeQuery:N.J,onEvent:null,enableSort:!0,enableTransform:!0},T&&(Object.keys(T).forEach(function(V){F.options[V]=T[V]}),T.limitDragging==null)&&T.schema!=null&&(this.options.limitDragging=!0),this.setSchema(this.options.schema,this.options.schemaRefs),this._debouncedValidate=(0,y.debounce)(this._validateAndCatch.bind(this),this.DEBOUNCE_INTERVAL),T.onSelectionChange&&this.onSelectionChange(T.onSelectionChange),(0,G.cC)(this.options.languages),(0,G.m0)(this.options.language)},K.set=function(T){T instanceof Function||T===void 0?this.clear():(this.content.removeChild(this.table),T={field:this.options.name,value:T},T=new t(this,T),this._setRoot(T),this._validateAndCatch(),this.node.expand(!1),this.content.appendChild(this.table)),this.history&&this.history.clear(),this.searchBox&&this.searchBox.clear()},K.update=function(T){var F,V;this.node.deepEqual(T)||(F=this.getSelection(),this.onChangeDisabled=!0,this.node.update(T),this.onChangeDisabled=!1,this._validateAndCatch(),this.searchBox&&!this.searchBox.isEmpty()&&this.searchBox.forceSearch(),F&&F.start&&F.end&&(T=this.node.findNodeByPath(F.start.path),V=this.node.findNodeByPath(F.end.path),T)&&V?this.setSelection(F.start,F.end):this.setSelection({},{}))},K.get=function(){if(this.node)return this.node.getValue()},K.getText=function(){return JSON.stringify(this.get())},K.setText=function(T){try{this.set((0,y.parse)(T))}catch{T=(0,y.tryJsonRepair)(T),this.set((0,y.parse)(T))}},K.updateText=function(T){try{this.update((0,y.parse)(T))}catch{T=(0,y.tryJsonRepair)(T),this.update((0,y.parse)(T))}},K.setName=function(T){this.options.name=T,this.node&&this.node.updateField(this.options.name)},K.getName=function(){return this.options.name},K.focus=function(){var T=this.scrollableContent.querySelector("[contenteditable=true]");T?T.focus():this.node.dom.expand?this.node.dom.expand.focus():this.node.dom.menu?this.node.dom.menu.focus():(T=this.frame.querySelector("button"))&&T.focus()},K.clear=function(){this.node&&(this.node.hide(),delete this.node),this.treePath&&this.treePath.reset()},K._setRoot=function(T){this.clear(),(this.node=T).setParent(null),T.setField(this.getName(),!1),delete T.index,this.tbody.appendChild(T.getDom())},K.search=function(T){var F;return this.node?(this.content.removeChild(this.table),F=this.node.search(T),this.content.appendChild(this.table)):F=[],F},K.expandAll=function(){this.node&&(this.content.removeChild(this.table),this.node.expand(),this.content.appendChild(this.table))},K.collapseAll=function(){this.node&&(this.content.removeChild(this.table),this.node.collapse(),this.content.appendChild(this.table))},K.expand=function(T){var F;T&&(F=this.node?this.node.findNodeByPath(T.path):null)&&(T.isExpand?F.expand(T.recursive):F.collapse(T.recursive))},K._onAction=function(T,F){this.history&&this.history.add(T,F),this._onChange()},K._onChange=function(){if(!this.onChangeDisabled){var T;if(this.selection=this.getDomSelection(),this._debouncedValidate(),this.treePath&&((T=this.node&&this.selection?this.node.findNodeByInternalPath(this.selection.path):this.multiselection?this.multiselection.nodes[0]:void 0)?this._updateTreePath(T.getNodePath()):this.treePath.reset()),this.options.onChange)try{this.options.onChange()}catch(F){console.error("Error in onChange callback: ",F)}if(this.options.onChangeJSON)try{this.options.onChangeJSON(this.get())}catch(F){console.error("Error in onChangeJSON callback: ",F)}if(this.options.onChangeText)try{this.options.onChangeText(this.getText())}catch(F){console.error("Error in onChangeText callback: ",F)}if(this.options.onClassName&&this.node.recursivelyUpdateCssClassesOnNodes(),this.options.onNodeName&&this.node.childs)try{this.node.recursivelyUpdateNodeName()}catch(F){console.error("Error in onNodeName callback: ",F)}}},K.validate=function(){var T=this,F=this.node;if(F){var V=F.getValue(),I=[];this.validateSchema&&!this.validateSchema(V)&&(I=this.validateSchema.errors.map(function(Z){return(0,y.improveSchemaError)(Z)}).map(function(Z){return{node:F.findNode(Z.dataPath),error:Z,type:"validation"}}).filter(function(Z){return Z.node!=null}));try{this.validationSequence++;var S=this,L=this.validationSequence;return this._validateCustom(V).then(function(Z){return L===S.validationSequence&&(Z=[].concat(I,Z||[]),S._renderValidationErrors(Z),typeof T.options.onValidationError=="function"&&(0,y.isValidationErrorChanged)(Z,T.lastSchemaErrors)&&T.options.onValidationError.call(T,Z),T.lastSchemaErrors=Z),T.lastSchemaErrors})}catch(Z){return Promise.reject(Z)}}},K._validateAndCatch=function(){this.validate().catch(function(T){console.error("Error running validation:",T)})},K._renderValidationErrors=function(T){this.errorNodes&&this.errorNodes.forEach(function(V){V.setError(null)});var F=T.reduce(function(V,I){return I.node.findParents().filter(function(S){return!V.some(function(L){return L[0]===S})}).map(function(S){return[S,I.node]}).concat(V)},[]);this.errorNodes=F.map(function(V){return{node:V[0],child:V[1],error:{message:V[0].type==="object"?(0,G.Iu)("containsInvalidProperties"):(0,G.Iu)("containsInvalidItems")}}}).concat(T).map(function(V){return V.node.setError(V.error,V.child),V.node})},K._validateCustom=function(T){try{var F,V;if(this.options.onValidate)return F=this.node,V=this.options.onValidate(T),((0,y.isPromise)(V)?V:Promise.resolve(V)).then(function(I){return Array.isArray(I)?I.filter(function(S){var L=(0,y.isValidValidationError)(S);return L||console.warn('Ignoring a custom validation error with invalid structure. Expected structure: {path: [...], message: "..."}. Actual error:',S),L}).map(function(S){var L;try{L=S&&S.path?F.findNodeByPath(S.path):null}catch{}return L||console.warn("Ignoring validation error: node not found. Path:",S.path,"Error:",S),{node:L,error:S,type:"customValidation"}}).filter(function(S){return S&&S.node&&S.error&&S.error.message}):null})}catch(I){return Promise.reject(I)}return Promise.resolve(null)},K.refresh=function(){this.node&&this.node.updateDom({recurse:!0})},K.startAutoScroll=function(T){var F=this,V=this.scrollableContent,I=(0,y.getAbsoluteTop)(V),S=V.clientHeight,L=I+S;T<I+24&&0<V.scrollTop?this.autoScrollStep=(I+24-T)/3:L-24<T&&S+V.scrollTop<V.scrollHeight?this.autoScrollStep=(L-24-T)/3:this.autoScrollStep=void 0,this.autoScrollStep?this.autoScrollTimer||(this.autoScrollTimer=setInterval(function(){F.autoScrollStep?V.scrollTop-=F.autoScrollStep:F.stopAutoScroll()},50)):this.stopAutoScroll()},K.stopAutoScroll=function(){this.autoScrollTimer&&(clearTimeout(this.autoScrollTimer),delete this.autoScrollTimer),this.autoScrollStep&&delete this.autoScrollStep},K.setDomSelection=function(T){var F,V,I;T&&("scrollTop"in T&&this.scrollableContent&&(this.scrollableContent.scrollTop=T.scrollTop),T.paths?(F=this,V=T.paths.map(function(S){return F.node.findNodeByInternalPath(S)}),this.select(V)):(I=(V=T.path?this.node.findNodeByInternalPath(T.path):null)&&T.domName?V.dom[T.domName]:null,T.range&&I?(T=Object.assign({},T.range,{container:I}),(0,y.setSelectionOffset)(T)):V&&V.focus()))},K.getDomSelection=function(){var T=t.getNodeFromTarget(this.focusTarget),F=this.focusTarget,V=T?Object.keys(T.dom).find(function(S){return T.dom[S]===F}):null,I=(0,y.getSelectionOffset)();return(I=(I=I&&I.container.nodeName!=="DIV"?null:I)&&I.container!==F?null:I)&&delete I.container,{path:T?T.getInternalPath():null,domName:V,range:I,paths:0<this.multiselection.length?this.multiselection.nodes.map(function(S){return S.getInternalPath()}):null,scrollTop:this.scrollableContent?this.scrollableContent.scrollTop:0}},K.scrollTo=function(T,F){var V,I,S,L,Z=this.scrollableContent;Z?((V=this).animateTimeout&&(clearTimeout(V.animateTimeout),delete V.animateTimeout),V.animateCallback&&(V.animateCallback(!1),delete V.animateCallback),I=Z.clientHeight,S=Z.scrollHeight-I,L=Math.min(Math.max(T-I/4,0),S),function J(){var re=Z.scrollTop,re=L-re;3<Math.abs(re)?(Z.scrollTop+=re/3,V.animateCallback=F,V.animateTimeout=setTimeout(J,50)):(F&&F(!0),Z.scrollTop=L,delete V.animateTimeout,delete V.animateCallback)}()):F&&F(!1)},K._createFrame=function(){var T=this,F=(this.frame=document.createElement("div"),this.frame.className="jsoneditor jsoneditor-mode-"+this.options.mode,this.container.appendChild(this.frame),this.contentOuter=document.createElement("div"),this.contentOuter.className="jsoneditor-outer",this);function V(J){F._onEvent&&F._onEvent(J)}var I,S,L,Z={target:this.frame,onFocus:this.options.onFocus||null,onBlur:this.options.onBlur||null};this.frameFocusTracker=new H.R(Z),this.frame.onclick=function(J){var re=J.target;V(J),re.nodeName==="BUTTON"&&J.preventDefault()},this.frame.oninput=V,this.frame.onchange=V,this.frame.onkeydown=V,this.frame.onkeyup=V,this.frame.oncut=V,this.frame.onpaste=V,this.frame.onmousedown=V,this.frame.onmouseup=V,this.frame.onmouseover=V,this.frame.onmouseout=V,(0,y.addEventListener)(this.frame,"focus",V,!0),(0,y.addEventListener)(this.frame,"blur",V,!0),this.frame.onfocusin=V,this.frame.onfocusout=V,this.options.mainMenuBar&&((0,y.addClassName)(this.contentOuter,"has-main-menu-bar"),this.menu=document.createElement("div"),this.menu.className="jsoneditor-menu",this.frame.appendChild(this.menu),(Z=document.createElement("button")).type="button",Z.className="jsoneditor-expand-all",Z.title=(0,G.Iu)("expandAll"),Z.onclick=function(){F.expandAll(),typeof T.options.onExpand=="function"&&T.options.onExpand({path:[],isExpand:!0,recursive:!0})},this.menu.appendChild(Z),(Z=document.createElement("button")).type="button",Z.title=(0,G.Iu)("collapseAll"),Z.className="jsoneditor-collapse-all",Z.onclick=function(){F.collapseAll(),typeof T.options.onExpand=="function"&&T.options.onExpand({path:[],isExpand:!1,recursive:!0})},this.menu.appendChild(Z),this.options.enableSort&&((Z=document.createElement("button")).type="button",Z.className="jsoneditor-sort",Z.title=(0,G.Iu)("sortTitleShort"),Z.onclick=function(){F.node.showSortModal()},this.menu.appendChild(Z)),this.options.enableTransform&&((Z=document.createElement("button")).type="button",Z.title=(0,G.Iu)("transformTitleShort"),Z.className="jsoneditor-transform",Z.onclick=function(){F.node.showTransformModal()},this.menu.appendChild(Z)),this.history&&((I=document.createElement("button")).type="button",I.className="jsoneditor-undo jsoneditor-separator",I.title=(0,G.Iu)("undo"),I.onclick=function(){F._onUndo()},this.menu.appendChild(I),this.dom.undo=I,(S=document.createElement("button")).type="button",S.className="jsoneditor-redo",S.title=(0,G.Iu)("redo"),S.onclick=function(){F._onRedo()},this.menu.appendChild(S),this.dom.redo=S,this.history.onChange=function(){I.disabled=!F.history.canUndo(),S.disabled=!F.history.canRedo()},this.history.onChange()),this.options&&this.options.modes&&this.options.modes.length&&((L=this).modeSwitcher=new A.x(this.menu,this.options.modes,this.options.mode,function(J){try{L.setMode(J),L.modeSwitcher.focus()}catch(re){L._onError(re)}})),this.options.search)&&(this.searchBox=new v(this,this.menu)),this.options.navigationBar&&(this.navBar=document.createElement("div"),this.navBar.className="jsoneditor-navigation-bar nav-bar-empty",this.frame.appendChild(this.navBar),this.treePath=new M(this.navBar,this.getPopupAnchor()),this.treePath.onSectionSelected(this._onTreePathSectionSelected.bind(this)),this.treePath.onContextMenuItemSelected(this._onTreePathMenuItemSelected.bind(this)))},K._onUndo=function(){this.history&&(this.history.undo(),this._onChange())},K._onRedo=function(){this.history&&(this.history.redo(),this._onChange())},K._onEvent=function(T){if(!t.targetIsColorPicker(T.target)){var F,V=t.getNodeFromTarget(T.target);if(T.type==="keydown"&&this._onKeyDown(T),V&&T.type==="focus"&&(this.focusTarget=T.target,this.options.autocomplete)&&this.options.autocomplete.trigger==="focus"&&this._showAutoComplete(T.target),T.type==="mousedown"&&this._startDragDistance(T),T.type!=="mousemove"&&T.type!=="mouseup"&&T.type!=="click"||this._updateDragDistance(T),V&&this.options&&this.options.navigationBar&&V&&(T.type==="keydown"||T.type==="mousedown")&&(F=this,setTimeout(function(){F._updateTreePath(V.getNodePath())})),V&&V.selected){if(T.type==="click"){if(T.target===V.dom.menu)return void this.showContextMenu(T.target);T.hasMoved||this.deselect()}T.type==="mousedown"&&t.onDragStart(this.multiselection.nodes,T)}else T.type==="mousedown"&&(0,y.hasParentNode)(T.target,this.content)&&(this.deselect(),V&&T.target===V.dom.drag?t.onDragStart(V,T):V&&(T.target===V.dom.field||T.target===V.dom.value||T.target===V.dom.select)||this._onMultiSelectStart(T));V&&V.onEvent(T)}},K._updateTreePath=function(T){var F;function V(I){return I.parent?I.parent.type==="array"?I.index:I.field:I.field||I.type}T&&T.length?((0,y.removeClassName)(this.navBar,"nav-bar-empty"),F=[],T.forEach(function(I){var S={name:V(I),node:I,children:[]};I.childs&&I.childs.length&&I.childs.forEach(function(L){S.children.push({name:V(L),node:L})}),F.push(S)}),this.treePath.setPath(F)):(0,y.addClassName)(this.navBar,"nav-bar-empty")},K._onTreePathSectionSelected=function(T){T&&T.node&&(T.node.expandTo(),T.node.focus())},K._onTreePathMenuItemSelected=function(T,F){T&&T.children.length&&(T=T.children.find(function(V){return V.name===F}))&&T.node&&(this._updateTreePath(T.node.getNodePath()),T.node.expandTo(),T.node.focus())},K._startDragDistance=function(T){this.dragDistanceEvent={initialTarget:T.target,initialPageX:T.pageX,initialPageY:T.pageY,dragDistance:0,hasMoved:!1}},K._updateDragDistance=function(T){this.dragDistanceEvent||this._startDragDistance(T);var F=T.pageX-this.dragDistanceEvent.initialPageX,V=T.pageY-this.dragDistanceEvent.initialPageY;return this.dragDistanceEvent.dragDistance=Math.sqrt(F*F+V*V),this.dragDistanceEvent.hasMoved=this.dragDistanceEvent.hasMoved||10<this.dragDistanceEvent.dragDistance,T.dragDistance=this.dragDistanceEvent.dragDistance,T.hasMoved=this.dragDistanceEvent.hasMoved,T.dragDistance},K._onMultiSelectStart=function(T){var F,V=t.getNodeFromTarget(T.target);this.options.mode==="tree"&&this.options.onEditable===void 0&&(this.multiselection={start:V||null,end:null,nodes:[]},this._startDragDistance(T),(F=this).mousemove||(this.mousemove=(0,y.addEventListener)(T.view,"mousemove",function(I){F._onMultiSelect(I)})),this.mouseup||(this.mouseup=(0,y.addEventListener)(T.view,"mouseup",function(I){F._onMultiSelectEnd(I)})),T.preventDefault())},K._onMultiSelect=function(T){var F;T.preventDefault(),this._updateDragDistance(T),T.hasMoved&&((T=t.getNodeFromTarget(T.target))&&(this.multiselection.start==null&&(this.multiselection.start=T),this.multiselection.end=T),this.deselect(),T=this.multiselection.start,F=this.multiselection.end||this.multiselection.start,T)&&F&&(this.multiselection.nodes=this._findTopLevelNodes(T,F),this.multiselection.nodes&&this.multiselection.nodes.length&&(T=this.multiselection.nodes[0],this.multiselection.start===T||this.multiselection.start.isDescendantOf(T)?this.multiselection.direction="down":this.multiselection.direction="up"),this.select(this.multiselection.nodes))},K._onMultiSelectEnd=function(T){var F=this.multiselection.nodes[0];F&&F.dom.menu&&F.dom.menu.focus(),this.multiselection.start=null,this.multiselection.end=null,this.mousemove&&((0,y.removeEventListener)(T.view,"mousemove",this.mousemove),delete this.mousemove),this.mouseup&&((0,y.removeEventListener)(T.view,"mouseup",this.mouseup),delete this.mouseup)},K.deselect=function(T){var F=!!this.multiselection.nodes.length;this.multiselection.nodes.forEach(function(V){V.setSelected(!1)}),this.multiselection.nodes=[],T&&(this.multiselection.start=null,this.multiselection.end=null),F&&this._selectionChangedHandler&&this._selectionChangedHandler()},K.select=function(T){if(!Array.isArray(T))return this.select([T]);var F;T&&(this.deselect(),this.multiselection.nodes=T.slice(0),F=T[0],T.forEach(function(V){V.expandPathToNode(),V.setSelected(!0,V===F)}),this._selectionChangedHandler)&&(T=this.getSelection(),this._selectionChangedHandler(T.start,T.end))},K._findTopLevelNodes=function(Z,J){for(var V=Z.getNodePath(),I=J.getNodePath(),S=0;S<V.length&&V[S]===I[S];)S++;var L,Z=V[S-1],J=V[S],re=I[S];return J&&re||(Z.parent?Z=(re=J=Z).parent:(J=Z.childs[0],re=Z.childs[Z.childs.length-1])),Z&&J&&re?(J=Z.childs.indexOf(J),re=Z.childs.indexOf(re),L=Math.min(J,re),J=Math.max(J,re),Z.childs.slice(L,J+1)):[]},K._showAutoComplete=function(T){var F,V=t.getNodeFromTarget(T),I="";0<=T.className.indexOf("jsoneditor-value")&&(I="value"),(I=0<=T.className.indexOf("jsoneditor-field")?"field":I)!==""&&(F=this,setTimeout(function(){var S;!V||!(F.options.autocomplete.trigger==="focus"||0<T.innerText.length)||(S=F.options.autocomplete.getOptions(T.innerText,V.getPath(),I,V.editor))===null?F.autocomplete.hideDropDown():typeof S.then=="function"?S.then(function(L){L===null?F.autocomplete.hideDropDown():L.options?F.autocomplete.show(T,L.startFrom,L.options):F.autocomplete.show(T,0,L)}).catch(function(L){console.error(L)}):S.options?F.autocomplete.show(T,S.startFrom,S.options):F.autocomplete.show(T,0,S)},50))},K._onKeyDown=function(T){var F,V=T.which||T.keyCode,I=T.altKey,S=T.ctrlKey,L=T.metaKey,Z=T.shiftKey,J=!1,re=this.focusTarget;V===9&&(F=this,setTimeout(function(){F.focusTarget!==re&&(0,y.selectContentEditable)(F.focusTarget)},0)),this.searchBox&&(S&&V===70?(this.searchBox.dom.search.focus(),this.searchBox.dom.search.select(),J=!0):(V===114||S&&V===71)&&(Z?this.searchBox.previous(!0):this.searchBox.next(!0),J=!0)),this.history&&(S&&!Z&&V===90?(this._onUndo(),J=!0):S&&Z&&V===90&&(this._onRedo(),J=!0)),!this.options.autocomplete||J||S||I||L||T.key.length!==1&&V!==8&&V!==46||(J=!1,this._showAutoComplete(T.target)),J&&(T.preventDefault(),T.stopPropagation())},K._createTable=function(){var T;this.options.navigationBar&&(0,y.addClassName)(this.contentOuter,"has-nav-bar"),this.scrollableContent=document.createElement("div"),this.scrollableContent.className="jsoneditor-tree",this.contentOuter.appendChild(this.scrollableContent),this.content=document.createElement("div"),this.content.className="jsoneditor-tree-inner",this.scrollableContent.appendChild(this.content),this.table=document.createElement("table"),this.table.className="jsoneditor-tree",this.content.appendChild(this.table),this.colgroupContent=document.createElement("colgroup"),this.options.mode==="tree"&&((T=document.createElement("col")).width="24px",this.colgroupContent.appendChild(T)),(T=document.createElement("col")).width="24px",this.colgroupContent.appendChild(T),T=document.createElement("col"),this.colgroupContent.appendChild(T),this.table.appendChild(this.colgroupContent),this.tbody=document.createElement("tbody"),this.table.appendChild(this.tbody),this.frame.appendChild(this.contentOuter)},K.showContextMenu=function(T,F){var V,I=[],S=this.multiselection.nodes.slice();I.push({text:(0,G.Iu)("duplicateText"),title:(0,G.Iu)("duplicateTitle"),className:"jsoneditor-duplicate",click:function(){t.onDuplicate(S)}}),I.push({text:(0,G.Iu)("remove"),title:(0,G.Iu)("removeTitle"),className:"jsoneditor-remove",click:function(){t.onRemove(S)}}),this.options.onCreateMenu&&(V=S.map(function(L){return L.getPath()}),I=this.options.onCreateMenu(I,{type:"multiple",path:V[0],paths:V})),new k.x(I,{close:F}).show(T,this.getPopupAnchor())},K.getPopupAnchor=function(){return this.options.popupAnchor||this.frame},K.getSelection=function(){var T,F,V={start:null,end:null};return this.multiselection.nodes&&this.multiselection.nodes.length&&this.multiselection.nodes.length&&(T=this.multiselection.nodes[0],F=this.multiselection.nodes[this.multiselection.nodes.length-1],this.multiselection.direction==="down"?(V.start=T.serialize(),V.end=F.serialize()):(V.start=F.serialize(),V.end=T.serialize())),V},K.onSelectionChange=function(T){typeof T=="function"&&(this._selectionChangedHandler=(0,y.debounce)(T,this.DEBOUNCE_INTERVAL))},K.setSelection=function(T,F){T&&T.dom&&T.range&&(console.warn("setSelection/getSelection usage for text selection is deprecated and should not be used, see documentation for supported selection options"),this.setDomSelection(T)),T=this._getNodeInstancesByRange(T,F),T.forEach(function(V){V.expandTo()}),this.select(T)},K._getNodeInstancesByRange=function(T,F){T&&T.path&&(V=this.node.findNodeByPath(T.path),F)&&F.path&&(I=this.node.findNodeByPath(F.path));var V,I,S=[];if(V instanceof t)if(I instanceof t&&I!==V)if(V.parent===I.parent){F=V.getIndex()<I.getIndex()?(T=V,I):(T=I,V);var L=T;for(S.push(L);L=L.nextSibling(),S.push(L),L&&L!==F;);}else S=this._findTopLevelNodes(V,I);else S.push(V);return S},K.getNodesByRange=function(V,F){var V=this._getNodeInstancesByRange(V,F),I=[];return V.forEach(function(S){I.push(S.serialize())}),I},[{mode:"tree",mixin:K,data:"json"},{mode:"view",mixin:K,data:"json"},{mode:"form",mixin:K,data:"json"}])},2744:function(le,m,D){m.tryRequireAjv=function(){try{return D(8903)}catch{}}},9125:function(le,m,D){m.O=function(){try{D(4864)}catch(U){console.error(U)}}},9791:function(le,U,D){D.r(U),D.d(U,{addClassName:function(){return c},addEventListener:function(){return X},asyncExec:function(){return Ie},clear:function(){return n},compileJSONPointer:function(){return me},contains:function(){return ie},debounce:function(){return L},escapeUnicodeChars:function(){return d},extend:function(){return l},findUniqueName:function(){return we},formatSize:function(){return Pe},get:function(){return Ae},getAbsoluteLeft:function(){return t},getAbsoluteTop:function(){return s},getChildPaths:function(){return Re},getColorCSS:function(){return ye},getIndexForPosition:function(){return re},getInnerText:function(){return u},getInputSelection:function(){return J},getInternetExplorerVersion:function(){return $},getPositionForPath:function(){return pe},getSelection:function(){return W},getSelectionOffset:function(){return O},getType:function(){return o},getWindow:function(){return e},hasParentNode:function(){return v},improveSchemaError:function(){return F},insideRect:function(){return S},isArray:function(){return r},isChildOf:function(){return K},isFirefox:function(){return M},isObject:function(){return te},isPromise:function(){return V},isTimestamp:function(){return Le},isUrl:function(){return a},isValidColor:function(){return xe},isValidValidationError:function(){return I},isValidationErrorChanged:function(){return ce},limitCharacters:function(){return ge},makeFieldTooltip:function(){return be},parse:function(){return y},parsePath:function(){return ne},parseString:function(){return ve},removeAllClassNames:function(){return p},removeClassName:function(){return g},removeEventListener:function(){return Q},removeReturnsAndSurroundingWhitespace:function(){return _},selectContentEditable:function(){return E},setEndOfContentEditable:function(){return w},setSelection:function(){return B},setSelectionOffset:function(){return x},sort:function(){return We},sortObjectKeys:function(){return Se},stringifyPath:function(){return T},stripFormatting:function(){return b},textDiff:function(){return Z},tryJsonRepair:function(){return C},uniqueMergeArrays:function(){return fe},validate:function(){return h}}),D(4987);var U=D(233),k=D.n(U),H=D(1262),j=D(6589),z=D(7026),Y=D(7907);function G(ee){return function(ae){if(Array.isArray(ae))return N(ae)}(ee)||function(ae){if(typeof Symbol<"u"&&ae[Symbol.iterator]!=null||ae["@@iterator"]!=null)return Array.from(ae)}(ee)||function(ae,he){var Ce;if(ae)return typeof ae=="string"?N(ae,he):(Ce=(Ce=Object.prototype.toString.call(ae).slice(8,-1))==="Object"&&ae.constructor?ae.constructor.name:Ce)==="Map"||Ce==="Set"?Array.from(ae):Ce==="Arguments"||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(Ce)?N(ae,he):void 0}(ee)||function(){throw new TypeError(`Invalid attempt to spread non-iterable instance.
In order to be iterable, non-array objects must have a [Symbol.iterator]() method.`)}()}function N(ee,ae){(ae==null||ae>ee.length)&&(ae=ee.length);for(var he=0,Ce=new Array(ae);he<ae;he++)Ce[he]=ee[he];return Ce}function A(ee){return(A=typeof Symbol=="function"&&typeof Symbol.iterator=="symbol"?function(ae){return typeof ae}:function(ae){return ae&&typeof Symbol=="function"&&ae.constructor===Symbol&&ae!==Symbol.prototype?"symbol":typeof ae})(ee)}var f=1e4,R=9466848e5;function y(ee){try{return JSON.parse(ee)}catch(ae){throw h(ee),ae}}function C(ee){try{return(0,H.K)(ee)}catch{return ee}}function d(ee){return ee.replace(/[\u007F-\uFFFF]/g,function(ae){return"\\u"+("0000"+ae.charCodeAt(0).toString(16)).slice(-4)})}function h(ee){(j!==void 0?j:JSON).parse(ee)}function l(ee,ae){for(var he in ae)$e(ae,he)&&(ee[he]=ae[he]);return ee}function n(ee){for(var ae in ee)$e(ee,ae)&&delete ee[ae];return ee}function o(ee){return ee===null?"null":ee===void 0?"undefined":ee instanceof Number||typeof ee=="number"?"number":ee instanceof String||typeof ee=="string"?"string":ee instanceof Boolean||typeof ee=="boolean"?"boolean":ee instanceof RegExp?"regexp":r(ee)?"array":"object"}var i=/^https?:\/\/\S+$/;function a(ee){return(typeof ee=="string"||ee instanceof String)&&i.test(ee)}function r(ee){return Object.prototype.toString.call(ee)==="[object Array]"}function e(ee){return ee.ownerDocument.defaultView}function t(ee){return ee.getBoundingClientRect().left+window.pageXOffset||document.scrollLeft||0}function s(ee){return ee.getBoundingClientRect().top+window.pageYOffset||document.scrollTop||0}function c(ee,ae){var he=ee.className.split(" ");he.indexOf(ae)===-1&&(he.push(ae),ee.className=he.join(" "))}function p(ee){ee.className=""}function g(ee,Ce){var he=ee.className.split(" "),Ce=he.indexOf(Ce);Ce!==-1&&(he.splice(Ce,1),ee.className=he.join(" "))}function b(ee){for(var ae=ee.childNodes,he=0,Ce=ae.length;he<Ce;he++){var Te=ae[he],ke=(Te.style&&Te.removeAttribute("style"),Te.attributes);if(ke)for(var Ne=ke.length-1;0<=Ne;Ne--){var Fe=ke[Ne];Fe.specified===!0&&Te.removeAttribute(Fe.name)}b(Te)}}function w(ee){var ae;document.createRange&&((ae=document.createRange()).selectNodeContents(ee),ae.collapse(!1),(ee=window.getSelection()).removeAllRanges(),ee.addRange(ae))}function E(ee){var ae;ee&&ee.nodeName==="DIV"&&window.getSelection&&document.createRange&&((ae=document.createRange()).selectNodeContents(ee),(ee=window.getSelection()).removeAllRanges(),ee.addRange(ae))}function W(){if(window.getSelection){var ee=window.getSelection();if(ee.getRangeAt&&ee.rangeCount)return ee.getRangeAt(0)}return null}function B(ee){var ae;ee&&window.getSelection&&((ae=window.getSelection()).removeAllRanges(),ae.addRange(ee))}function O(){var ee=W();return ee&&"startOffset"in ee&&"endOffset"in ee&&ee.startContainer&&ee.startContainer===ee.endContainer?{startOffset:ee.startOffset,endOffset:ee.endOffset,container:ee.startContainer.parentNode}:null}function x(ee){var ae;document.createRange&&window.getSelection&&window.getSelection()&&(ae=document.createRange(),ee.container.firstChild||ee.container.appendChild(document.createTextNode("")),ae.setStart(ee.container.firstChild,ee.startOffset),ae.setEnd(ee.container.firstChild,ee.endOffset),B(ae))}function u(ee,ae){var he;if(ae===void 0&&(ae={_text:"",flush:function(){var Xe=this._text;return this._text="",Xe},set:function(Xe){this._text=Xe}}),ee.nodeValue)return(he=_(ee.nodeValue))!==""?ae.flush()+he:"";if(ee.hasChildNodes()){for(var Ce=ee.childNodes,Te="",ke=0,Ne=Ce.length;ke<Ne;ke++){var Fe,ze=Ce[ke];ze.nodeName==="DIV"||ze.nodeName==="P"?((Fe=(Fe=Ce[ke-1])?Fe.nodeName:void 0)&&Fe!=="DIV"&&Fe!=="P"&&Fe!=="BR"&&(Te!==""&&(Te+=`
`),ae.flush()),Te+=u(ze,ae),ae.set(`
`)):ze.nodeName==="BR"?(Te+=ae.flush(),ae.set(`
`)):Te+=u(ze,ae)}return Te}return""}function _(ee){return ee.replace(/(\b|^)\s*(\b|$)/g,function(ae){return/\n/.exec(ae)?"":ae})}function v(ee,ae){for(var he=ee?ee.parentNode:void 0;he;){if(he===ae)return!0;he=he.parentNode}return!1}function $(){var ee;return P===-1&&(ee=-1,typeof navigator<"u"&&navigator.appName==="Microsoft Internet Explorer"&&/MSIE ([0-9]+[.0-9]+)/.exec(navigator.userAgent)!=null&&(ee=parseFloat(RegExp.$1)),P=ee),P}var P=-1;function M(){return typeof navigator<"u"&&navigator.userAgent.indexOf("Firefox")!==-1}function X(ee,ae,he,Ce){return ee.addEventListener?(Ce===void 0&&(Ce=!1),ae==="mousewheel"&&M()&&(ae="DOMMouseScroll"),ee.addEventListener(ae,he,Ce),he):ee.attachEvent?(ee.attachEvent("on"+ae,Ce=function(){return he.call(ee,window.event)}),Ce):void 0}function Q(ee,ae,he,Ce){ee.removeEventListener?(Ce===void 0&&(Ce=!1),ae==="mousewheel"&&M()&&(ae="DOMMouseScroll"),ee.removeEventListener(ae,he,Ce)):ee.detachEvent&&ee.detachEvent("on"+ae,he)}function K(ee,ae){for(var he=ee.parentNode;he;){if(he===ae)return!0;he=he.parentNode}return!1}function ne(ee){var ae=[],he=0;function Ce(ke){for(var Ne="";ee[he]!==void 0&&ee[he]!==ke;)Ne+=ee[he],he++;if(ee[he]!==ke)throw new Error("Invalid JSON path: unexpected end, character "+ke+" expected");return Ne}for(;ee[he]!==void 0;)if(ee[he]===".")he++,ae.push(function(){for(var ke="";ee[he]!==void 0&&/[\w$]/.test(ee[he]);)ke+=ee[he],he++;if(ke==="")throw new Error("Invalid JSON path: property name expected at index "+he);return ke}());else{if(ee[he]!=="[")throw new Error('Invalid JSON path: unexpected character "'+ee[he]+'" at index '+he);if(ee[++he]==="'"||ee[he]==='"'){var Te=ee[he];if(he++,ae.push(Ce(Te)),ee[he]!==Te)throw new Error("Invalid JSON path: closing quote ' expected at index "+he);he++}else{if(Te=Ce("]").trim(),Te.length===0)throw new Error("Invalid JSON path: array value expected at index "+he);Te=Te==="*"?Te:JSON.parse(Te),ae.push(Te)}if(ee[he]!=="]")throw new Error("Invalid JSON path: closing bracket ] expected at index "+he);he++}return ae}function T(ee){return ee.map(function(ae){return typeof ae=="number"?"["+ae+"]":typeof ae=="string"&&ae.match(/^[A-Za-z0-9_$]+$/)?"."+ae:'["'+ae+'"]'}).join("")}function F(ee){var ae,he;return ee.keyword==="enum"&&Array.isArray(ee.schema)&&(he=ee.schema)&&(5<(he=he.map(function(Ce){return JSON.stringify(Ce)})).length&&(ae=["("+(he.length-5)+" more...)"],(he=he.slice(0,5)).push(ae)),ee.message="should be equal to one of: "+he.join(", ")),ee.keyword==="additionalProperties"&&(ee.message="should NOT have additional property: "+ee.params.additionalProperty),ee}function V(ee){return ee&&typeof ee.then=="function"&&typeof ee.catch=="function"}function I(ee){return A(ee)==="object"&&Array.isArray(ee.path)&&typeof ee.message=="string"}function S(ee,ae,he){return he=he!==void 0?he:0,ae.left-he>=ee.left&&ae.right+he<=ee.right&&ae.top-he>=ee.top&&ae.bottom+he<=ee.bottom}function L(ee,ae,he){var Ce;return function(){var Te=this,ke=arguments,Ne=he&&!Ce;clearTimeout(Ce),Ce=setTimeout(function(){Ce=null,he||ee.apply(Te,ke)},ae),Ne&&ee.apply(Te,ke)}}function Z(ee,ae){for(var he=ae.length,Ce=0,Te=ee.length,ke=ae.length;ae.charAt(Ce)===ee.charAt(Ce)&&Ce<he;)Ce++;for(;ae.charAt(ke-1)===ee.charAt(Te-1)&&Ce<ke&&0<Te;)ke--,Te--;return{start:Ce,end:ke}}function J(ee){var ae,he,Ce,Te,ke=0,Ne=0;return typeof ee.selectionStart=="number"&&typeof ee.selectionEnd=="number"?(ke=ee.selectionStart,Ne=ee.selectionEnd):(Te=document.selection.createRange())&&Te.parentElement()===ee&&(Ce=ee.value.length,ae=ee.value.replace(/\r\n/g,`
`),(he=ee.createTextRange()).moveToBookmark(Te.getBookmark()),(Te=ee.createTextRange()).collapse(!1),-1<he.compareEndPoints("StartToEnd",Te)?ke=Ne=Ce:(ke=-he.moveStart("character",-Ce),ke+=ae.slice(0,ke).split(`
`).length-1,-1<he.compareEndPoints("EndToEnd",Te)?Ne=Ce:(Ne=-he.moveEnd("character",-Ce),Ne+=ae.slice(0,Ne).split(`
`).length-1))),{startIndex:ke,endIndex:Ne,start:Fe(ke),end:Fe(Ne)};function Fe(ze){return ze=ee.value.substring(0,ze),{row:(ze.match(/\n/g)||[]).length+1,column:ze.length-ze.lastIndexOf(`
`)}}}function re(Ce,ae,he){var Ce=Ce.value||"";return 0<ae&&0<he?(Ce=Ce.split(`
`,ae),ae=Math.min(Ce.length,ae),he=Math.min(Ce[ae-1].length,he-1),he=ae===1?he:he+1,Ce.slice(0,ae-1).join(`
`).length+he):-1}function pe(ee,ae){var he,Ce=[];if(ae&&ae.length){try{he=z.parse(ee)}catch{return Ce}ae.forEach(function(Te){var ke=me(ne(Te)),ke=he.pointers[ke];ke&&Ce.push({path:Te,line:ke.key?ke.key.line:ke.value?ke.value.line:0,column:ke.key?ke.key.column:ke.value?ke.value.column:0})})}return Ce}function me(ee){return ee.map(function(ae){return"/"+String(ae).replace(/~/g,"~0").replace(/\//g,"~1")}).join("")}function ye(ee){var ae=document.createElement("div");return ae.style.color=ee,ae.style.color.split(/\s+/).join("").toLowerCase()||null}function xe(ee){return!!ye(ee)}function be(ee,ae){var he;return ee?(he="",ee.title&&(he+=ee.title),ee.description&&(0<he.length&&(he+=`
`),he+=ee.description),ee.default&&(0<he.length&&(he+=`

`),he=(he+=(0,Y.Iu)("default",void 0,ae)+`
`)+JSON.stringify(ee.default,null,2)),Array.isArray(ee.examples)&&0<ee.examples.length&&(0<he.length&&(he+=`

`),he+=(0,Y.Iu)("examples",void 0,ae)+`
`,ee.examples.forEach(function(Ce,Te){he+=JSON.stringify(Ce,null,2),Te!==ee.examples.length-1&&(he+=`
`)})),he):""}function Ae(ee,ae){for(var he=ee,Ce=0;Ce<ae.length&&he!=null;Ce++)he=he[ae[Ce]];return he}function we(ee,ae){for(var he=ee.replace(/ \(copy( \d+)?\)$/,""),Ce=he,Te=1;ae.indexOf(Ce)!==-1;)Ce=he+" ("+("copy"+(1<Te?" "+Te:""))+")",Te++;return Ce}function Re(ee,ae){var he={};if(Array.isArray(ee))for(var Ce=Math.min(ee.length,f),Te=0;Te<Ce;Te++)(function ke(Ne,Fe,ze,Xe){(Array.isArray(Ne)||te(Ne))&&!Xe||(Fe[ze||""]=!0),te(Ne)&&Object.keys(Ne).forEach(function(se){ke(Ne[se],Fe,ze+"."+se,Xe)})})(ee[Te],he,"",ae);else he[""]=!0;return Object.keys(he).sort()}function We(ee,ke,he){var Ce=ke&&ke!=="."?ne(ke):[],Te=he==="desc"?-1:1,ke=ee.slice();return ke.sort(function(Ne,Fe){return Ne=Ae(Ne,Ce),Fe=Ae(Fe,Ce),Te*(Fe<Ne?1:Ne<Fe?-1:0)}),ke}function Se(ee,Ce){var he=Ce==="desc"?-1:1,Ce=Object.keys(ee).sort(function(ke,Ne){return he*k()(ke,Ne)}),Te={};return Ce.forEach(function(ke){Te[ke]=ee[ke]}),Te}function ve(ee){var ae,he;return ee===""?"":(ae=ee.toLowerCase())==="null"?null:ae==="true"||ae!=="false"&&(/^0\d+$/.test(ee)||(ae=Number(ee),he=parseFloat(ee),isNaN(ae))||isNaN(he)?ee:ae)}function Le(ee,ae){return typeof ae=="number"&&R<ae&&isFinite(ae)&&Math.floor(ae)===ae&&!isNaN(new Date(ae).valueOf())}function Pe(ee){return ee<900?ee.toFixed()+" B":(ee=ee/1e3)<900?ee.toFixed(1)+" KB":(ee=ee/1e3)<900?ee.toFixed(1)+" MB":(ee=ee/1e3)<900?ee.toFixed(1)+" GB":(ee/1e3).toFixed(1)+" TB"}function ge(ee,ae){return ee.length<=ae?ee:ee.slice(0,ae)+"..."}function te(ee){return A(ee)==="object"&&ee!==null&&!Array.isArray(ee)}function ie(ee,ae){return ee.indexOf(ae)!==-1}function ce(ee,ae){if(ae||ee){if(ae&&!ee||!ae&&ee||ae.length!==ee.length)return!0;for(var he,Ce=0;Ce<ee.length;++Ce)if(he=function(Te){var ke=ee[Te].type==="error"?ae.find(function(Ne){return Ne.line===ee[Te].line}):ae.find(function(Ne){return Ne.dataPath===ee[Te].dataPath&&Ne.schemaPath===ee[Te].schemaPath});if(!ke)return{v:!0}}(Ce))return he.v}return!1}function fe(ee,ae){return ee=ee!=null&&ee.length?ee:[],ae=ae!=null&&ae.length?ae:[],G(new Set(ee.concat(ae)))}function Ie(ee){setTimeout(ee)}function $e(ee,ae){return Object.prototype.hasOwnProperty.call(ee,ae)}},8037:function(le,m,D){var U;if(window.Picker)U=window.Picker;else try{U=D(4049)}catch{}le.exports=U},6225:function(le,m,D){function U(A,f){var R,y;return f=N(A,f),(A=z.modules[f])||(typeof(A=z.payloads[f])=="function"&&(R={id:f,uri:"",exports:y={},packaged:!0},y=A(function(C,d){return Y(f,C,d)},y,R)||R.exports,z.modules[f]=y,delete z.payloads[f]),A=z.modules[f]=y||A),A}var k,H,j,z,Y,G,N;le=D.nmd(le),(j=function(){return this}())||typeof window>"u"||(j=window),(z=function(A,f,R){typeof A!="string"?z.original?z.original.apply(this,arguments):(console.error("dropping module because define wasn't a string."),console.trace()):(arguments.length==2&&(R=f),z.modules[A]||(z.payloads[A]=R,z.modules[A]=null))}).modules={},z.payloads={},Y=function(A,f,R){if(typeof f=="string"){var y=U(A,f);if(y!=null)return R&&R(),y}else if(Object.prototype.toString.call(f)==="[object Array]"){for(var C=[],d=0,h=f.length;d<h;++d){var l=U(A,f[d]);if(l==null&&G.original)return;C.push(l)}return R&&R.apply(null,C)||!0}},G=function(A,f){var R=Y("",A,f);return R==null&&G.original?G.original.apply(this,arguments):R},N=function(A,f){var R;if(f.indexOf("!")!==-1)return R=f.split("!"),N(A,R[0])+"!"+N(A,R[1]);if(f.charAt(0)==".")for(f=A.split("/").slice(0,-1).join("/")+"/"+f;f.indexOf(".")!==-1&&y!=f;){var y=f;f=f.replace(/\/\.\//,"/").replace(/[^\/]+\/\.\.\//,"")}return f},H=j,(k="ace")&&(j[k]||(j[k]={}),H=j[k]),H.define&&H.define.packaged||(z.original=H.define,H.define=z,H.define.packaged=!0),H.require&&H.require.packaged||(G.original=H.require,H.require=G,H.require.packaged=!0),ace.define("ace/lib/es6-shim",["require","exports","module"],function(A,f,R){function y(C,d,h){Object.defineProperty(C,d,{value:h,enumerable:!1,writable:!0,configurable:!0})}String.prototype.startsWith||y(String.prototype,"startsWith",function(C,d){return this.lastIndexOf(C,d=d||0)===d}),String.prototype.endsWith||y(String.prototype,"endsWith",function(C,d){return(d===void 0||d>this.length)&&(d=this.length),d-=C.length,C=this.indexOf(C,d),C!==-1&&C===d}),String.prototype.repeat||y(String.prototype,"repeat",function(C){for(var d="",h=this;0<C;)1&C&&(d+=h),(C>>=1)&&(h+=h);return d}),String.prototype.includes||y(String.prototype,"includes",function(C,d){return this.indexOf(C,d)!=-1}),Object.assign||(Object.assign=function(C){if(C==null)throw new TypeError("Cannot convert undefined or null to object");for(var d=Object(C),h=1;h<arguments.length;h++){var l=arguments[h];l!=null&&Object.keys(l).forEach(function(n){d[n]=l[n]})}return d}),Object.values||(Object.values=function(C){return Object.keys(C).map(function(d){return C[d]})}),Array.prototype.find||y(Array.prototype,"find",function(C){for(var d=this.length,h=arguments[1],l=0;l<d;l++){var n=this[l];if(C.call(h,n,l,this))return n}}),Array.prototype.findIndex||y(Array.prototype,"findIndex",function(C){for(var d=this.length,h=arguments[1],l=0;l<d;l++){var n=this[l];if(C.call(h,n,l,this))return l}}),Array.prototype.includes||y(Array.prototype,"includes",function(C,d){return this.indexOf(C,d)!=-1}),Array.prototype.fill||y(Array.prototype,"fill",function(C){for(var d=this.length>>>0,l=arguments[1]>>0,h=l<0?Math.max(d+l,0):Math.min(l,d),l=arguments[2],l=l===void 0?d:l>>0,n=l<0?Math.max(d+l,0):Math.min(l,d);h<n;)this[h]=C,h++;return this}),Array.of||y(Array,"of",function(){return Array.prototype.slice.call(arguments)})}),ace.define("ace/lib/fixoldbrowsers",["require","exports","module","ace/lib/es6-shim"],function(A,f,R){A("./es6-shim")}),ace.define("ace/lib/deep_copy",["require","exports","module"],function(A,f,R){f.deepCopy=function y(C){if(typeof C!="object"||!C)return C;if(Array.isArray(C))for(var d=[],h=0;h<C.length;h++)d[h]=y(C[h]);else{if(Object.prototype.toString.call(C)!=="[object Object]")return C;for(var h in d={},C)d[h]=y(C[h])}return d}}),ace.define("ace/lib/lang",["require","exports","module","ace/lib/deep_copy"],function(A,f,R){f.last=function(d){return d[d.length-1]},f.stringReverse=function(d){return d.split("").reverse().join("")},f.stringRepeat=function(d,h){for(var l="";0<h;)1&h&&(l+=d),(h>>=1)&&(d+=d);return l};var y=/^\s\s*/,C=/\s\s*$/;f.stringTrimLeft=function(d){return d.replace(y,"")},f.stringTrimRight=function(d){return d.replace(C,"")},f.copyObject=function(d){var h,l={};for(h in d)l[h]=d[h];return l},f.copyArray=function(d){for(var h=[],l=0,n=d.length;l<n;l++)d[l]&&typeof d[l]=="object"?h[l]=this.copyObject(d[l]):h[l]=d[l];return h},f.deepCopy=A("./deep_copy").deepCopy,f.arrayToMap=function(d){for(var h={},l=0;l<d.length;l++)h[d[l]]=1;return h},f.createMap=function(d){var h,l=Object.create(null);for(h in d)l[h]=d[h];return l},f.arrayRemove=function(d,h){for(var l=0;l<=d.length;l++)h===d[l]&&d.splice(l,1)},f.escapeRegExp=function(d){return d.replace(/([.*+?^${}()|[\]\/\\])/g,"\\$1")},f.escapeHTML=function(d){return(""+d).replace(/&/g,"&#38;").replace(/"/g,"&#34;").replace(/'/g,"&#39;").replace(/</g,"&#60;")},f.getMatchOffsets=function(d,h){var l=[];return d.replace(h,function(n){l.push({offset:arguments[arguments.length-2],length:n.length})}),l},f.deferredCall=function(d){function h(){n=null,d()}function l(o){return l.cancel(),n=setTimeout(h,o||0),l}var n=null;return(l.schedule=l).call=function(){return this.cancel(),d(),l},l.cancel=function(){return clearTimeout(n),n=null,l},l.isPending=function(){return n},l},f.delayedCall=function(d,h){function l(){o=null,d()}function n(i){o==null&&(o=setTimeout(l,i||h))}var o=null;return n.delay=function(i){o&&clearTimeout(o),o=setTimeout(l,i||h)},(n.schedule=n).call=function(){this.cancel(),d()},n.cancel=function(){o&&clearTimeout(o),o=null},n.isPending=function(){return o},n},f.supportsLookbehind=function(){try{new RegExp("(?<=.)")}catch{return!1}return!0},f.supportsUnicodeFlag=function(){try{new RegExp("^.$","u")}catch{return!1}return!0}}),ace.define("ace/lib/useragent",["require","exports","module"],function(A,f,R){f.OS={LINUX:"LINUX",MAC:"MAC",WINDOWS:"WINDOWS"},f.getOS=function(){return f.isMac?f.OS.MAC:f.isLinux?f.OS.LINUX:f.OS.WINDOWS};var d=typeof navigator=="object"?navigator:{},y=(/mac|win|linux/i.exec(d.platform)||["other"])[0].toLowerCase(),C=d.userAgent||"",d=d.appName||"";f.isWin=y=="win",f.isMac=y=="mac",f.isLinux=y=="linux",f.isIE=d=="Microsoft Internet Explorer"||0<=d.indexOf("MSAppHost")?parseFloat((C.match(/(?:MSIE |Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]):parseFloat((C.match(/(?:Trident\/[0-9]+[\.0-9]+;.*rv:)([0-9]+[\.0-9]+)/)||[])[1]),f.isOldIE=f.isIE&&f.isIE<9,f.isGecko=f.isMozilla=C.match(/ Gecko\/\d+/),f.isOpera=typeof opera=="object"&&Object.prototype.toString.call(window.opera)=="[object Opera]",f.isWebKit=parseFloat(C.split("WebKit/")[1])||void 0,f.isChrome=parseFloat(C.split(" Chrome/")[1])||void 0,f.isEdge=parseFloat(C.split(" Edge/")[1])||void 0,f.isAIR=0<=C.indexOf("AdobeAIR"),f.isAndroid=0<=C.indexOf("Android"),f.isChromeOS=0<=C.indexOf(" CrOS "),f.isIOS=/iPad|iPhone|iPod/.test(C)&&!window.MSStream,f.isIOS&&(f.isMac=!0),f.isMobile=f.isIOS||f.isAndroid}),ace.define("ace/lib/dom",["require","exports","module","ace/lib/useragent"],function(d,f,R){var y,C,d=d("./useragent"),h=(f.buildDom=function o(i,a,r){if(typeof i=="string"&&i)return g=document.createTextNode(i),a&&a.appendChild(g),g;if(!Array.isArray(i))return i&&i.appendChild&&a&&a.appendChild(i),i;if(typeof i[0]!="string"||!i[0]){for(var e=[],t=0;t<i.length;t++){var s=o(i[t],a,r);s&&e.push(s)}return e}for(var c=document.createElement(i[0]),p=i[1],g=1,t=g=p&&typeof p=="object"&&!Array.isArray(p)?2:g;t<i.length;t++)o(i[t],c,r);return g==2&&Object.keys(p).forEach(function(b){var w=p[b];b==="class"?c.className=Array.isArray(w)?w.join(" "):w:typeof w=="function"||b=="value"||b[0]=="$"?c[b]=w:b==="ref"?r&&(r[w]=c):b==="style"?typeof w=="string"&&(c.style.cssText=w):w!=null&&c.setAttribute(b,w)}),a&&a.appendChild(c),c},f.getDocumentHead=function(o){return(o=o||document).head||o.getElementsByTagName("head")[0]||o.documentElement},f.createElement=function(o,i){return document.createElementNS?document.createElementNS(i||"http://www.w3.org/1999/xhtml",o):document.createElement(o)},f.removeChildren=function(o){o.innerHTML=""},f.createTextNode=function(o,i){return(i?i.ownerDocument:document).createTextNode(o)},f.createFragment=function(o){return(o?o.ownerDocument:document).createDocumentFragment()},f.hasCssClass=function(o,i){return(o.className+"").split(/\s+/g).indexOf(i)!==-1},f.addCssClass=function(o,i){f.hasCssClass(o,i)||(o.className+=" "+i)},f.removeCssClass=function(o,i){for(var a=o.className.split(/\s+/g);;){var r=a.indexOf(i);if(r==-1)break;a.splice(r,1)}o.className=a.join(" ")},f.toggleCssClass=function(o,i){for(var a=o.className.split(/\s+/g),r=!0;;){var e=a.indexOf(i);if(e==-1)break;r=!1,a.splice(e,1)}return r&&a.push(i),o.className=a.join(" "),r},f.setCssClass=function(o,i,a){a?f.addCssClass(o,i):f.removeCssClass(o,i)},f.hasCssString=function(o,i){var a,r=0;if(a=(i=i||document).querySelectorAll("style")){for(;r<a.length;)if(a[r++].id===o)return!0}},f.removeElementById=function(o,i){(i=i||document).getElementById(o)&&i.getElementById(o).remove()},[]);function l(){var o=h;h=null,o&&o.forEach(function(i){n(i[0],i[1])})}function n(o,i,a){if(typeof document<"u"){if(h){if(a)l();else if(a===!1)return h.push([o,i])}if(!y){var r=a,a=(r=a&&a.getRootNode&&(r=a.getRootNode())&&r!=a?r:document).ownerDocument||r;if(i&&f.hasCssString(i,r))return null;i&&(o+=`
/*# sourceURL=ace/css/`+i+" */");var e=f.createElement("style");e.appendChild(a.createTextNode(o)),i&&(e.id=i),(r=r==a?f.getDocumentHead(a):r).insertBefore(e,r.firstChild)}}}f.useStrictCSP=function(o){(y=o)==0?l():h=h||[]},f.importCssString=n,f.importCssStylsheet=function(o,i){f.buildDom(["link",{rel:"stylesheet",href:o}],f.getDocumentHead(i))},f.scrollbarWidth=function(r){var i=f.createElement("ace_inner"),a=(i.style.width="100%",i.style.minWidth="0px",i.style.height="200px",i.style.display="block",f.createElement("ace_outer")),t=a.style,r=(t.position="absolute",t.left="-10000px",t.overflow="hidden",t.width="200px",t.minWidth="0px",t.height="150px",t.display="block",a.appendChild(i),r&&r.documentElement||document&&document.documentElement);if(!r)return 0;r.appendChild(a);var e=i.offsetWidth,t=(t.overflow="scroll",i.offsetWidth);return e===t&&(t=a.clientWidth),r.removeChild(a),e-t},f.computedStyle=function(o,i){return window.getComputedStyle(o,"")||{}},f.setStyle=function(o,i,a){o[i]!==a&&(o[i]=a)},f.HAS_CSS_ANIMATION=!1,f.HAS_CSS_TRANSFORMS=!1,f.HI_DPI=!d.isWin||typeof window<"u"&&1.5<=window.devicePixelRatio,d.isChromeOS&&(f.HI_DPI=!1),typeof document<"u"&&(C=document.createElement("div"),f.HI_DPI&&C.style.transform!==void 0&&(f.HAS_CSS_TRANSFORMS=!0),d.isEdge||C.style.animationName===void 0||(f.HAS_CSS_ANIMATION=!0),C=null),f.HAS_CSS_TRANSFORMS?f.translate=function(o,i,a){o.style.transform="translate("+Math.round(i)+"px, "+Math.round(a)+"px)"}:f.translate=function(o,i,a){o.style.top=Math.round(a)+"px",o.style.left=Math.round(i)+"px"}}),ace.define("ace/lib/net",["require","exports","module","ace/lib/dom"],function(A,f,R){var y=A("./dom");f.get=function(C,d){var h=new XMLHttpRequest;h.open("GET",C,!0),h.onreadystatechange=function(){h.readyState===4&&d(h.responseText)},h.send(null)},f.loadScript=function(C,d){var h=y.getDocumentHead(),l=document.createElement("script");l.src=C,h.appendChild(l),l.onload=l.onreadystatechange=function(n,o){!o&&l.readyState&&l.readyState!="loaded"&&l.readyState!="complete"||(l=l.onload=l.onreadystatechange=null,o)||d()}},f.qualifyURL=function(C){var d=document.createElement("a");return d.href=C,d.href}}),ace.define("ace/lib/oop",["require","exports","module"],function(A,f,R){f.inherits=function(y,C){y.super_=C,y.prototype=Object.create(C.prototype,{constructor:{value:y,enumerable:!1,writable:!0,configurable:!0}})},f.mixin=function(y,C){for(var d in C)y[d]=C[d];return y},f.implement=function(y,C){f.mixin(y,C)}}),ace.define("ace/lib/event_emitter",["require","exports","module"],function(A,f,R){function y(){this.propagationStopped=!0}function C(){this.defaultPrevented=!0}var d={};d._emit=d._dispatchEvent=function(h,l){this._eventRegistry||(this._eventRegistry={}),this._defaultHandlers||(this._defaultHandlers={});var n=this._eventRegistry[h]||[],o=this._defaultHandlers[h];if(n.length||o){(l=typeof l=="object"&&l?l:{}).type||(l.type=h),l.stopPropagation||(l.stopPropagation=y),l.preventDefault||(l.preventDefault=C);for(var n=n.slice(),i=0;i<n.length&&(n[i](l,this),!l.propagationStopped);i++);return o&&!l.defaultPrevented?o(l,this):void 0}},d._signal=function(h,l){if(n=(this._eventRegistry||{})[h])for(var n=n.slice(),o=0;o<n.length;o++)n[o](l,this)},d.once=function(h,l){var n=this;if(this.on(h,function o(){n.off(h,o),l.apply(null,arguments)}),!l)return new Promise(function(o){l=o})},d.setDefaultHandler=function(h,l){var n,o,i=this._defaultHandlers;(i=i||(this._defaultHandlers={_disabled_:{}}))[h]&&(o=i[h],(n=i._disabled_[h])||(i._disabled_[h]=n=[]),n.push(o),(o=n.indexOf(l))!=-1)&&n.splice(o,1),i[h]=l},d.removeDefaultHandler=function(h,l){var n,o=this._defaultHandlers;o&&(n=o._disabled_[h],o[h]==l?n&&this.setDefaultHandler(h,n.pop()):n&&(o=n.indexOf(l))!=-1&&n.splice(o,1))},d.on=d.addEventListener=function(h,l,n){this._eventRegistry=this._eventRegistry||{};var o=this._eventRegistry[h];return(o=o||(this._eventRegistry[h]=[])).indexOf(l)==-1&&o[n?"unshift":"push"](l),l},d.off=d.removeListener=d.removeEventListener=function(h,l){this._eventRegistry=this._eventRegistry||{},h=this._eventRegistry[h],h&&(l=h.indexOf(l))!==-1&&h.splice(l,1)},d.removeAllListeners=function(h){h||(this._eventRegistry=this._defaultHandlers=void 0),this._eventRegistry&&(this._eventRegistry[h]=void 0),this._defaultHandlers&&(this._defaultHandlers[h]=void 0)},f.EventEmitter=d}),ace.define("ace/lib/report_error",["require","exports","module"],function(A,f,R){f.reportError=function(y,C){var d=new Error(y);d.data=C,typeof console=="object"&&console.error&&console.error(d),setTimeout(function(){throw d})}}),ace.define("ace/lib/app_config",["require","exports","module","ace/lib/oop","ace/lib/event_emitter","ace/lib/report_error"],function(h,f,R){var y,C=h("./oop"),d=h("./event_emitter").EventEmitter,h=h("./report_error").reportError,l={setOptions:function(a){Object.keys(a).forEach(function(r){this.setOption(r,a[r])},this)},getOptions:function(a){var r,e={};return a?Array.isArray(a)||(e=a,a=Object.keys(e)):(r=this.$options,a=Object.keys(r).filter(function(t){return!r[t].hidden})),a.forEach(function(t){e[t]=this.getOption(t)},this),e},setOption:function(a,r){var e;if(this["$"+a]!==r)return(e=this.$options[a])?e.forwardTo?this[e.forwardTo]&&this[e.forwardTo].setOption(a,r):(e.handlesSet||(this["$"+a]=r),void(e&&e.set&&e.set.call(this,r))):n('misspelled option "'+a+'"')},getOption:function(a){var r=this.$options[a];return r?r.forwardTo?this[r.forwardTo]&&this[r.forwardTo].getOption(a):r&&r.get?r.get.call(this):this["$"+a]:n('misspelled option "'+a+'"')}};function n(a){typeof console<"u"&&console.warn&&console.warn.apply(console,arguments)}i.prototype.defineOptions=function(a,r,e){return a.$options||(this.$defaultOptions[r]=a.$options={}),Object.keys(e).forEach(function(t){var s=e[t];(s=typeof s=="string"?{forwardTo:s}:s).name||(s.name=t),"initialValue"in(a.$options[s.name]=s)&&(a["$"+s.name]=s.initialValue)}),C.implement(a,l),this},i.prototype.resetOptions=function(a){Object.keys(a.$options).forEach(function(r){var e=a.$options[r];"value"in e&&a.setOption(r,e.value)})},i.prototype.setDefaultValue=function(a,r,e){if(!a){for(a in this.$defaultOptions)if(this.$defaultOptions[a][r])break;if(!this.$defaultOptions[a][r])return!1}var t=this.$defaultOptions[a]||(this.$defaultOptions[a]={});t[r]&&(t.forwardTo?this.setDefaultValue(t.forwardTo,r,e):t[r].value=e)},i.prototype.setDefaultValues=function(a,r){Object.keys(r).forEach(function(e){this.setDefaultValue(a,e,r[e])},this)},i.prototype.setMessages=function(a){y=a},i.prototype.nls=function(a,r){return y&&!y[a]&&n("No message found for '"+a+"' in the provided messages, falling back to default English message."),a=y&&y[a]||a,a=r?a.replace(/\$(\$|[\d]+)/g,function(e,t){return t=="$"?"$":r[t]}):a};var o=i;function i(){this.$defaultOptions={}}o.prototype.warn=n,o.prototype.reportError=h,C.implement(o.prototype,d),f.AppConfig=o}),ace.define("ace/theme/textmate-css",["require","exports","module"],function(A,f,R){R.exports=`.ace-tm .ace_gutter {
  background: #f0f0f0;
  color: #333;
}

.ace-tm .ace_print-margin {
  width: 1px;
  background: #e8e8e8;
}

.ace-tm .ace_fold {
    background-color: #6B72E6;
}

.ace-tm {
  background-color: #FFFFFF;
  color: black;
}

.ace-tm .ace_cursor {
  color: black;
}
        
.ace-tm .ace_invisible {
  color: rgb(191, 191, 191);
}

.ace-tm .ace_storage,
.ace-tm .ace_keyword {
  color: blue;
}

.ace-tm .ace_constant {
  color: rgb(197, 6, 11);
}

.ace-tm .ace_constant.ace_buildin {
  color: rgb(88, 72, 246);
}

.ace-tm .ace_constant.ace_language {
  color: rgb(88, 92, 246);
}

.ace-tm .ace_constant.ace_library {
  color: rgb(6, 150, 14);
}

.ace-tm .ace_invalid {
  background-color: rgba(255, 0, 0, 0.1);
  color: red;
}

.ace-tm .ace_support.ace_function {
  color: rgb(60, 76, 114);
}

.ace-tm .ace_support.ace_constant {
  color: rgb(6, 150, 14);
}

.ace-tm .ace_support.ace_type,
.ace-tm .ace_support.ace_class {
  color: rgb(109, 121, 222);
}

.ace-tm .ace_keyword.ace_operator {
  color: rgb(104, 118, 135);
}

.ace-tm .ace_string {
  color: rgb(3, 106, 7);
}

.ace-tm .ace_comment {
  color: rgb(76, 136, 107);
}

.ace-tm .ace_comment.ace_doc {
  color: rgb(0, 102, 255);
}

.ace-tm .ace_comment.ace_doc.ace_tag {
  color: rgb(128, 159, 191);
}

.ace-tm .ace_constant.ace_numeric {
  color: rgb(0, 0, 205);
}

.ace-tm .ace_variable {
  color: rgb(49, 132, 149);
}

.ace-tm .ace_xml-pe {
  color: rgb(104, 104, 91);
}

.ace-tm .ace_entity.ace_name.ace_function {
  color: #0000A2;
}


.ace-tm .ace_heading {
  color: rgb(12, 7, 255);
}

.ace-tm .ace_list {
  color:rgb(185, 6, 144);
}

.ace-tm .ace_meta.ace_tag {
  color:rgb(0, 22, 142);
}

.ace-tm .ace_string.ace_regex {
  color: rgb(255, 0, 0)
}

.ace-tm .ace_marker-layer .ace_selection {
  background: rgb(181, 213, 255);
}
.ace-tm.ace_multiselect .ace_selection.ace_start {
  box-shadow: 0 0 3px 0px white;
}
.ace-tm .ace_marker-layer .ace_step {
  background: rgb(252, 255, 0);
}

.ace-tm .ace_marker-layer .ace_stack {
  background: rgb(164, 229, 101);
}

.ace-tm .ace_marker-layer .ace_bracket {
  margin: -1px 0 0 -1px;
  border: 1px solid rgb(192, 192, 192);
}

.ace-tm .ace_marker-layer .ace_active-line {
  background: rgba(0, 0, 0, 0.07);
}

.ace-tm .ace_gutter-active-line {
    background-color : #dcdcdc;
}

.ace-tm .ace_marker-layer .ace_selected-word {
  background: rgb(250, 250, 255);
  border: 1px solid rgb(200, 200, 250);
}

.ace-tm .ace_indent-guide {
  background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAAE0lEQVQImWP4////f4bLly//BwAmVgd1/w11/gAAAABJRU5ErkJggg==") right repeat-y;
}

.ace-tm .ace_indent-guide-active {
  background: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAACCAYAAACZgbYnAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAAZSURBVHjaYvj///9/hivKyv8BAAAA//8DACLqBhbvk+/eAAAAAElFTkSuQmCC") right repeat-y;
}
`}),ace.define("ace/theme/textmate",["require","exports","module","ace/theme/textmate-css","ace/lib/dom"],function(A,f,R){f.isDark=!1,f.cssClass="ace-tm",f.cssText=A("./textmate-css"),f.$id="ace/theme/textmate",A("../lib/dom").importCssString(f.cssText,f.cssClass,!1)}),ace.define("ace/config",["require","exports","module","ace/lib/lang","ace/lib/net","ace/lib/dom","ace/lib/app_config","ace/theme/textmate"],function(A,f,R){var y,C=A("./lib/lang"),d=A("./lib/net"),h=A("./lib/dom"),l=A("./lib/app_config").AppConfig,n=(R.exports=f=new l,{packaged:!1,workerPath:null,modePath:null,themePath:null,basePath:"",suffix:".js",$moduleUrls:{},loadWorkerFromBlob:!0,sharedPopups:!1,useStrictCSP:null}),o=(f.get=function(i){if(n.hasOwnProperty(i))return n[i];throw new Error("Unknown config key: "+i)},f.set=function(i,a){if(n.hasOwnProperty(i))n[i]=a;else if(this.setDefaultValue("",i,a)==0)throw new Error("Unknown config key: "+i);i=="useStrictCSP"&&h.useStrictCSP(a)},f.all=function(){return C.copyObject(n)},f.$modes={},f.moduleUrl=function(i,a){var r,e,t;return n.$moduleUrls[i]||(i=i.split("/"),r=(a=a||i[i.length-2]||"")=="snippets"?"/":"-",e=i[i.length-1],a=="worker"&&r=="-"&&(t=new RegExp("^"+a+"[\\-_]|[\\-_]"+a+"$","g"),e=e.replace(t,"")),(!e||e==a)&&1<i.length&&(e=i[i.length-2]),(t=n[a+"Path"])==null?t=n.basePath:r=="/"&&(a=r=""),t&&t.slice(-1)!="/"&&(t+="/"),t+a+r+e+this.get("suffix"))},f.setModuleUrl=function(i,a){return n.$moduleUrls[i]=a},f.setLoader=function(i){y=i},f.dynamicModules=Object.create(null),f.$loading={},f.$loaded={},f.loadModule=function(i,a){function r(s){if(s&&!f.$loading[i])return a&&a(s);if(f.$loading[i]||(f.$loading[i]=[]),f.$loading[i].push(a),!(1<f.$loading[i].length)){let c=function(){var p,g;g=function(b,w){w&&(f.$loaded[i]=w),f._emit("load.module",{name:i,module:w});var E=f.$loading[i];f.$loading[i]=null,E.forEach(function(W){W&&W(w)})},(p=i)==="ace/theme/textmate"||p==="./theme/textmate"?g(null,A("./theme/textmate")):y?y(p,g):console.error("loader is not configured")};if(!f.get("packaged"))return c();d.loadScript(f.moduleUrl(i,t),c),o()}}var e,t;if(Array.isArray(i)&&(t=i[0],i=i[1]),f.dynamicModules[i])f.dynamicModules[i]().then(function(s){s.default?r(s.default):r(s)});else{try{e=this.$require(i)}catch{}r(e||f.$loaded[i])}},f.$require=function(i){if(typeof R.require=="function")return R.require(i)},f.setModuleLoader=function(i,a){f.dynamicModules[i]=a},function(){n.basePath||n.workerPath||n.modePath||n.themePath||Object.keys(n.$moduleUrls).length||(console.error("Unable to infer path to ace from script src,","use ace.config.set('basePath', 'path') to enable dynamic loading of modes and themes","or with webpack use ace/webpack-resolver"),o=function(){})});f.version="1.31.1"}),ace.define("ace/loader_build",["require","exports","module","ace/lib/fixoldbrowsers","ace/config"],function(A,f,R){A("./lib/fixoldbrowsers");var y=A("./config"),C=(y.setLoader(function(h,l){A([h],function(n){l(null,n)})}),function(){return this||typeof window<"u"&&window}());function d(h){if(C&&C.document){y.set("packaged",h||A.packaged||R.packaged||C.define&&D.amdD.packaged);for(var l,n={},o="",h=document.currentScript||document._currentScript,i=h&&h.ownerDocument||document,a=(h&&h.src&&(o=h.src.split(/[?#]/)[0].split("/").slice(0,-1).join("/")||""),i.getElementsByTagName("script")),r=0;r<a.length;r++){var e=a[r],t=e.src||e.getAttribute("src");if(t){for(var s=e.attributes,c=0,p=s.length;c<p;c++){var g=s[c];g.name.indexOf("data-ace-")===0&&(n[g.name.replace(/^data-ace-/,"").replace(/-(.)/g,function(w,E){return E.toUpperCase()})]=g.value)}e=t.match(/^(.*)\/ace([\-.]\w+)?\.js(\?|$)/),e&&(o=e[1])}}for(l in o&&(n.base=n.base||o,n.packaged=!0),n.basePath=n.base,n.workerPath=n.workerPath||n.base,n.modePath=n.modePath||n.base,n.themePath=n.themePath||n.base,delete n.base,n)n[l]!==void 0&&y.set(l,n[l])}}R.exports=function(h){y.init=d,y.$require=A,h.require=A,h.define=D.amdD},d(!0)}),ace.define("ace/range",["require","exports","module"],function(A,f,R){C.prototype.isEqual=function(d){return this.start.row===d.start.row&&this.end.row===d.end.row&&this.start.column===d.start.column&&this.end.column===d.end.column},C.prototype.toString=function(){return"Range: ["+this.start.row+"/"+this.start.column+"] -> ["+this.end.row+"/"+this.end.column+"]"},C.prototype.contains=function(d,h){return this.compare(d,h)==0},C.prototype.compareRange=function(h){var l=h.end,h=h.start,l=this.compare(l.row,l.column);return l==1?(l=this.compare(h.row,h.column))==1?2:l==0?1:0:l==-1?-2:(l=this.compare(h.row,h.column))==-1?-1:l==1?42:0},C.prototype.comparePoint=function(d){return this.compare(d.row,d.column)},C.prototype.containsRange=function(d){return this.comparePoint(d.start)==0&&this.comparePoint(d.end)==0},C.prototype.intersects=function(d){return d=this.compareRange(d),d==-1||d==0||d==1},C.prototype.isEnd=function(d,h){return this.end.row==d&&this.end.column==h},C.prototype.isStart=function(d,h){return this.start.row==d&&this.start.column==h},C.prototype.setStart=function(d,h){typeof d=="object"?(this.start.column=d.column,this.start.row=d.row):(this.start.row=d,this.start.column=h)},C.prototype.setEnd=function(d,h){typeof d=="object"?(this.end.column=d.column,this.end.row=d.row):(this.end.row=d,this.end.column=h)},C.prototype.inside=function(d,h){return this.compare(d,h)==0&&!this.isEnd(d,h)&&!this.isStart(d,h)},C.prototype.insideStart=function(d,h){return this.compare(d,h)==0&&!this.isEnd(d,h)},C.prototype.insideEnd=function(d,h){return this.compare(d,h)==0&&!this.isStart(d,h)},C.prototype.compare=function(d,h){return this.isMultiLine()||d!==this.start.row?d<this.start.row?-1:d>this.end.row?1:this.start.row===d?h>=this.start.column?0:-1:this.end.row!==d||h<=this.end.column?0:1:h<this.start.column?-1:h>this.end.column?1:0},C.prototype.compareStart=function(d,h){return this.start.row==d&&this.start.column==h?-1:this.compare(d,h)},C.prototype.compareEnd=function(d,h){return this.end.row==d&&this.end.column==h?1:this.compare(d,h)},C.prototype.compareInside=function(d,h){return this.end.row==d&&this.end.column==h?1:this.start.row==d&&this.start.column==h?-1:this.compare(d,h)},C.prototype.clipRows=function(d,h){var l,n;return this.end.row>h?l={row:h+1,column:0}:this.end.row<d&&(l={row:d,column:0}),this.start.row>h?n={row:h+1,column:0}:this.start.row<d&&(n={row:d,column:0}),C.fromPoints(n||this.start,l||this.end)},C.prototype.extend=function(d,h){var l,n,o=this.compare(d,h);return o==0?this:(o==-1?l={row:d,column:h}:n={row:d,column:h},C.fromPoints(l||this.start,n||this.end))},C.prototype.isEmpty=function(){return this.start.row===this.end.row&&this.start.column===this.end.column},C.prototype.isMultiLine=function(){return this.start.row!==this.end.row},C.prototype.clone=function(){return C.fromPoints(this.start,this.end)},C.prototype.collapseRows=function(){return this.end.column==0?new C(this.start.row,0,Math.max(this.start.row,this.end.row-1),0):new C(this.start.row,0,this.end.row,0)},C.prototype.toScreenRange=function(l){var h=l.documentToScreenPosition(this.start),l=l.documentToScreenPosition(this.end);return new C(h.row,h.column,l.row,l.column)},C.prototype.moveBy=function(d,h){this.start.row+=d,this.start.column+=h,this.end.row+=d,this.end.column+=h};var y=C;function C(d,h,l,n){this.start={row:d,column:h},this.end={row:l,column:n}}y.fromPoints=function(d,h){return new y(d.row,d.column,h.row,h.column)},y.comparePoints=function(d,h){return d.row-h.row||d.column-h.column},y.comparePoints=function(d,h){return d.row-h.row||d.column-h.column},f.Range=y}),ace.define("ace/lib/keys",["require","exports","module","ace/lib/oop"],function(A,f,R){var y=A("./oop"),C=function(){var d,h,l={MODIFIER_KEYS:{16:"Shift",17:"Ctrl",18:"Alt",224:"Meta",91:"MetaLeft",92:"MetaRight",93:"ContextMenu"},KEY_MODS:{ctrl:1,alt:2,option:2,shift:4,super:8,meta:8,command:8,cmd:8,control:1},FUNCTION_KEYS:{8:"Backspace",9:"Tab",13:"Return",19:"Pause",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"Print",45:"Insert",46:"Delete",96:"Numpad0",97:"Numpad1",98:"Numpad2",99:"Numpad3",100:"Numpad4",101:"Numpad5",102:"Numpad6",103:"Numpad7",104:"Numpad8",105:"Numpad9","-13":"NumpadEnter",112:"F1",113:"F2",114:"F3",115:"F4",116:"F5",117:"F6",118:"F7",119:"F8",120:"F9",121:"F10",122:"F11",123:"F12",144:"Numlock",145:"Scrolllock"},PRINTABLE_KEYS:{32:" ",48:"0",49:"1",50:"2",51:"3",52:"4",53:"5",54:"6",55:"7",56:"8",57:"9",59:";",61:"=",65:"a",66:"b",67:"c",68:"d",69:"e",70:"f",71:"g",72:"h",73:"i",74:"j",75:"k",76:"l",77:"m",78:"n",79:"o",80:"p",81:"q",82:"r",83:"s",84:"t",85:"u",86:"v",87:"w",88:"x",89:"y",90:"z",107:"+",109:"-",110:".",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",111:"/",106:"*"}};for(h in l.PRINTABLE_KEYS[173]="-",l.FUNCTION_KEYS)d=l.FUNCTION_KEYS[h].toLowerCase(),l[d]=parseInt(h,10);for(h in l.PRINTABLE_KEYS)d=l.PRINTABLE_KEYS[h].toLowerCase(),l[d]=parseInt(h,10);y.mixin(l,l.MODIFIER_KEYS),y.mixin(l,l.PRINTABLE_KEYS),y.mixin(l,l.FUNCTION_KEYS),l.enter=l.return,l.escape=l.esc,l.del=l.delete;for(var n=["cmd","ctrl","alt","shift"],o=Math.pow(2,n.length);o--;)l.KEY_MODS[o]=n.filter(function(i){return o&l.KEY_MODS[i]}).join("-")+"-";return l.KEY_MODS[0]="",l.KEY_MODS[-1]="input-",l}();y.mixin(f,C),(f.default=f).keyCodeToString=function(d){var h=C[d];return(h=typeof h!="string"?String.fromCharCode(d):h).toLowerCase()}}),ace.define("ace/lib/event",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(A,f,R){var y,C=A("./keys"),d=A("./useragent"),h=null,l=0;function n(){if(y==null){y=!1;try{document.createComment("").addEventListener("test",function(){},{get passive(){y={passive:!1}}})}catch{}}return y}function o(c,p,g){this.elem=c,this.type=p,this.callback=g}o.prototype.destroy=function(){e(this.elem,this.type,this.callback),this.elem=this.type=this.callback=void 0};function i(c){return 0|(c.ctrlKey?1:0)|(c.altKey?2:0)|(c.shiftKey?4:0)|(c.metaKey?8:0)}var a,r=f.addListener=function(c,p,g,b){c.addEventListener(p,g,n()),b&&b.$toDestroy.push(new o(c,p,g))},e=f.removeListener=function(c,p,g){c.removeEventListener(p,g,n())};f.stopEvent=function(c){return f.stopPropagation(c),f.preventDefault(c),!1},f.stopPropagation=function(c){c.stopPropagation&&c.stopPropagation()},f.preventDefault=function(c){c.preventDefault&&c.preventDefault()},f.getButton=function(c){return c.type=="dblclick"?0:c.type=="contextmenu"||d.isMac&&c.ctrlKey&&!c.altKey&&!c.shiftKey?2:c.button},f.capture=function(c,p,g){var b=c&&c.ownerDocument||document;function w(E){p&&p(E),g&&g(E),e(b,"mousemove",p),e(b,"mouseup",w),e(b,"dragstart",w)}return r(b,"mousemove",p),r(b,"mouseup",w),r(b,"dragstart",w),w},f.addMouseWheelListener=function(c,p,g){r(c,"wheel",function(b){var w=b.deltaX||0,E=b.deltaY||0;switch(b.deltaMode){case b.DOM_DELTA_PIXEL:b.wheelX=.15*w,b.wheelY=.15*E;break;case b.DOM_DELTA_LINE:b.wheelX=15*w,b.wheelY=15*E;break;case b.DOM_DELTA_PAGE:b.wheelX=150*w,b.wheelY=150*E}p(b)},g)},f.addMultiMouseDownListener=function(c,p,g,b,w){var E,W,B,O=0,x={2:"dblclick",3:"tripleclick",4:"quadclick"};function u(_){var v;if(f.getButton(_)!==0?O=0:1<_.detail&&!(4<++O)||(O=1),d.isIE&&(v=5<Math.abs(_.clientX-E)||5<Math.abs(_.clientY-W),B&&!v||(O=1),B&&clearTimeout(B),B=setTimeout(function(){B=null},p[O-1]||600),O==1)&&(E=_.clientX,W=_.clientY),_._clicks=O,g[b]("mousedown",_),4<O)O=0;else if(1<O)return g[b](x[O],_)}(c=Array.isArray(c)?c:[c]).forEach(function(_){r(_,"mousedown",u,w)})};function t(c,p,g){var b=i(p);if(!d.isMac&&h){if(p.getModifierState&&(p.getModifierState("OS")||p.getModifierState("Win"))&&(b|=8),h.altGr){if((3&b)==3)return;h.altGr=0}g!==18&&g!==17||(w="location"in p?p.location:p.keyLocation,g===17&&w===1?h[g]==1&&(l=p.timeStamp):g===18&&b===3&&w===2&&p.timeStamp-l<50&&(h.altGr=!0))}if(g in C.MODIFIER_KEYS&&(g=-1),!b&&g===13){var w="location"in p?p.location:p.keyLocation;if(w===3&&(c(p,b,-g),p.defaultPrevented))return}if(d.isChromeOS&&8&b){if(c(p,b,g),p.defaultPrevented)return;b&=-9}return!!(b||g in C.FUNCTION_KEYS||g in C.PRINTABLE_KEYS)&&c(p,b,g)}function s(){h=Object.create(null)}f.getModifierString=function(c){return C.KEY_MODS[i(c)]},f.addCommandKeyListener=function(c,p,g){var b,w;d.isOldGecko||d.isOpera&&!("KeyboardEvent"in window)?(b=null,r(c,"keydown",function(E){b=E.keyCode},g),r(c,"keypress",function(E){return t(p,E,b)},g)):(w=null,r(c,"keydown",function(E){h[E.keyCode]=(h[E.keyCode]||0)+1;var W=t(p,E,E.keyCode);return w=E.defaultPrevented,W},g),r(c,"keypress",function(E){w&&(E.ctrlKey||E.altKey||E.shiftKey||E.metaKey)&&(f.stopEvent(E),w=null)},g),r(c,"keyup",function(E){h[E.keyCode]=null},g),h||(s(),r(window,"focus",s)))},typeof window=="object"&&window.postMessage&&!d.isOldIE&&(a=1,f.nextTick=function(c,p){p=p||window;function g(w){w.data==b&&(f.stopPropagation(w),e(p,"message",g),c())}var b="zero-timeout-message-"+a++;r(p,"message",g),p.postMessage(b,"*")}),f.$idleBlocked=!1,f.onIdle=function(c,p){return setTimeout(function g(){f.$idleBlocked?setTimeout(g,100):c()},p)},f.$idleBlockId=null,f.blockIdle=function(c){f.$idleBlockId&&clearTimeout(f.$idleBlockId),f.$idleBlocked=!0,f.$idleBlockId=setTimeout(function(){f.$idleBlocked=!1},c||100)},f.nextFrame=typeof window=="object"&&(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame),f.nextFrame?f.nextFrame=f.nextFrame.bind(window):f.nextFrame=function(c){setTimeout(c,17)}}),ace.define("ace/clipboard",["require","exports","module"],function(A,f,R){var y;R.exports={lineMode:!1,pasteCancelled:function(){return!!(y&&y>Date.now()-50)||(y=!1)},cancel:function(){y=Date.now()}}}),ace.define("ace/keyboard/textinput",["require","exports","module","ace/lib/event","ace/config","ace/lib/useragent","ace/lib/dom","ace/lib/lang","ace/clipboard","ace/lib/keys"],function(A,f,R){var y=A("../lib/event"),C=A("../config").nls,d=A("../lib/useragent"),h=A("../lib/dom"),l=A("../lib/lang"),n=A("../clipboard"),o=d.isChrome<18,i=d.isIE,a=63<d.isChrome,r=A("../lib/keys"),e=r.KEY_MODS,t=d.isIOS,s=t?/\s/:/\n/,c=d.isMobile;f.TextInput=function(p,g){var b=h.createElement("textarea"),w=(b.className="ace_text-input",b.setAttribute("wrap","off"),b.setAttribute("autocorrect","off"),b.setAttribute("autocapitalize","off"),b.setAttribute("spellcheck",!1),b.style.opacity="0",p.insertBefore(b,p.firstChild),!1),E=!1,W=!1,B=!1,O="",x=(c||(b.style.fontSize="1px"),!1),u=!1,_="",v=0,$=0,P=0,M=Number.MAX_SAFE_INTEGER,X=Number.MIN_SAFE_INTEGER,Q=0;try{var K=document.activeElement===b}catch{}this.setNumberOfExtraLines=function(ge){M=Number.MAX_SAFE_INTEGER,X=Number.MIN_SAFE_INTEGER,Q=ge<0?0:ge},this.setAriaOptions=function(ge){ge.activeDescendant?(b.setAttribute("aria-haspopup","true"),b.setAttribute("aria-autocomplete",ge.inline?"both":"list"),b.setAttribute("aria-activedescendant",ge.activeDescendant)):(b.setAttribute("aria-haspopup","false"),b.setAttribute("aria-autocomplete","both"),b.removeAttribute("aria-activedescendant")),ge.role&&b.setAttribute("role",ge.role),ge.setLabel&&(b.setAttribute("aria-roledescription",C("editor")),g.session)&&(ge=g.session.selection.cursor.row,b.setAttribute("aria-label",C("Cursor at row $0",[ge+1])))},this.setAriaOptions({role:"textbox"}),y.addListener(b,"blur",function(ge){u||(g.onBlur(ge),K=!1)},g),y.addListener(b,"focus",function(ge){if(!u){if(K=!0,d.isEdge)try{if(!document.hasFocus())return}catch{}g.onFocus(ge),d.isEdge?setTimeout(I):I()}},g),this.$focusScroll=!1,this.focus=function(){if(this.setAriaOptions({setLabel:g.renderer.enableKeyboardAccessibility}),O||a||this.$focusScroll=="browser")return b.focus({preventScroll:!0});var ge=b.style.top;b.style.position="fixed",b.style.top="0px";try{var te=b.getBoundingClientRect().top!=0}catch{return}var ie=[];if(te)for(var ce=b.parentElement;ce&&ce.nodeType==1;)ie.push(ce),ce.setAttribute("ace_nocontext",!0),ce=!ce.parentElement&&ce.getRootNode?ce.getRootNode().host:ce.parentElement;b.focus({preventScroll:!0}),te&&ie.forEach(function(fe){fe.removeAttribute("ace_nocontext")}),setTimeout(function(){b.style.position="",b.style.top=="0px"&&(b.style.top=ge)},0)},this.blur=function(){b.blur()},this.isFocused=function(){return K},g.on("beforeEndOperation",function(){var ge=g.curOp,te=ge&&ge.command&&ge.command.name;te!="insertstring"&&(te=te&&(ge.docChanged||ge.selectionChanged),W&&te&&(_=b.value="",xe()),I())});function ne(ge,te){for(var ie=te,ce=1;ce<=ge-M&&ce<2*Q+1;ce++)ie+=g.session.getLine(ge-ce).length+1;return ie}function T(ge){me(ge,!0)}function F(ge){me(ge,!1)}function V(ge){var te=pe(ge);n.pasteCancelled()||(typeof te=="string"?(te&&g.onPaste(te,ge),d.isIE&&setTimeout(I),y.preventDefault(ge)):(b.value="",E=!0))}var I=t?function(ge){var te;!K||w&&!ge||B||((te=`
 ab`+(ge=ge||"")+`cde fg
`)!=b.value&&(b.value=_=te),te=4+(ge.length||(g.selection.isEmpty()?0:1)),v==4&&$==te||b.setSelectionRange(4,te),v=4,$=te)}:function(){if(!W&&!B&&(K||Z)){W=!0;var ge=0,te=0,ie="";if(g.session){for(var ce,Ie=g.selection,fe=Ie.getRange(),Ie=Ie.cursor.row,$e=(Ie===X+1?X=(M=X+1)+2*Q:Ie===M-1?M=(X=M-1)-2*Q:(Ie<M-1||X+1<Ie)&&(M=Q<Ie?Ie-Q:0,X=Q<Ie?Ie+Q:2*Q),[]),ee=M;ee<=X;ee++)$e.push(g.session.getLine(ee));ie=$e.join(`
`),ge=ne(fe.start.row,fe.start.column),te=ne(fe.end.row,fe.end.column),fe.start.row<M?(ce=g.session.getLine(M-1),ge=fe.start.row<M-1?0:ge,te+=ce.length+1,ie=ce+`
`+ie):fe.end.row>X?(ce=g.session.getLine(X+1),te=fe.end.row>X+1?ce.length:fe.end.column,te+=ie.length+1,ie=ie+`
`+ce):c&&0<Ie&&(ie=`
`+ie,te+=1,ge+=1),400<ie.length&&(ge<400&&te<400?ie=ie.slice(0,400):(ie=`
`,ge==te?ge=te=0:(ge=0,te=1))),fe=ie+`

`,fe!=_&&(b.value=_=fe,v=$=fe.length)}if(Z&&(v=b.selectionStart,$=b.selectionEnd),$!=te||v!=ge||b.selectionEnd!=$)try{b.setSelectionRange(ge,te),v=ge,$=te}catch{}W=!1}},S=(this.resetSelection=I,K&&g.onFocus(),function(ge){return ge.selectionStart===0&&ge.selectionEnd>=_.length&&ge.value===_&&_&&ge.selectionEnd!==$}),L=null,Z=(this.setInputHandler=function(ge){L=ge},!(this.getInputHandler=function(){return L})),J=function(ge,te){if(Z=Z&&!1,E)return I(),ge&&g.onPaste(ge),E=!1,"";for(var ie=b.selectionStart,ce=b.selectionEnd,fe=v,Ie=_.length-$,$e=ge,ee=ge.length-ie,ae=ge.length-ce,he=0;0<fe&&_[he]==ge[he];)he++,fe--;for($e=$e.slice(he),he=1;0<Ie&&_.length-he>v-1&&_[_.length-he]==ge[ge.length-he];)he++,Ie--;ee-=he-1,ae-=he-1;var Ce=$e.length-he+1;return Ce<0&&(fe=-Ce,Ce=0),$e=$e.slice(0,Ce),te||$e||ee||fe||Ie||ae?(Ce=!(B=!0),d.isAndroid&&$e==". "&&($e="  ",Ce=!0),$e&&!fe&&!Ie&&!ee&&!ae||x?g.onTextInput($e):g.onTextInput($e,{extendLeft:fe,extendRight:Ie,restoreStart:ee,restoreEnd:ae}),B=!1,_=ge,v=ie,$=ce,P=ae,Ce?`
`:$e):""},re=function(te){if(W)return ye();if(te&&te.inputType){if(te.inputType=="historyUndo")return g.execCommand("undo");if(te.inputType=="historyRedo")return g.execCommand("redo")}var te=b.value,ie=J(te,!0);(500<te.length||s.test(ie)||c&&v<1&&v==$)&&I()},pe=function(ge,te,ie){var ce=ge.clipboardData||window.clipboardData;if(ce&&!o){var fe=i||ie?"Text":"text/plain";try{return te?ce.setData(fe,te)!==!1:ce.getData(fe)}catch(Ie){if(!ie)return pe(Ie,te,!0)}}},me=function(ge,te){var ie=g.getCopyText();if(!ie)return y.preventDefault(ge);pe(ge,ie)?(t&&(I(ie),w=ie,setTimeout(function(){w=!1},10)),te?g.onCut():g.onCopy(),y.preventDefault(ge)):(w=!0,b.value=ie,b.select(),setTimeout(function(){w=!1,I(),te?g.onCut():g.onCopy()}))},ye=(y.addCommandKeyListener(b,g.onCommandKey.bind(g),g),y.addListener(b,"select",function(ge){W||(w?w=!1:S(b)?(g.selectAll(),I()):c&&b.selectionStart!=v&&I())},g),y.addListener(b,"input",re,g),y.addListener(b,"cut",T,g),y.addListener(b,"copy",F,g),y.addListener(b,"paste",V,g),"oncut"in b&&"oncopy"in b&&"onpaste"in b||y.addListener(p,"keydown",function(ge){if((!d.isMac||ge.metaKey)&&ge.ctrlKey)switch(ge.keyCode){case 67:F(ge);break;case 86:V(ge);break;case 88:T(ge)}},g),function(){var ge;if(W&&g.onCompositionUpdate&&!g.$readOnly)return x?be():void(W.useTextareaForIME?g.onCompositionUpdate(b.value):(ge=b.value,J(ge),W.markerRange&&(W.context&&(W.markerRange.start.column=W.selectionStart=W.context.compositionStartOffset),W.markerRange.end.column=W.markerRange.start.column+$-W.selectionStart+P)))}),xe=function(ge){g.onCompositionEnd&&!g.$readOnly&&(W=!1,g.onCompositionEnd(),g.off("mousedown",be),ge)&&re()};function be(){u=!0,b.blur(),b.focus(),u=!1}var Ae,we=l.delayedCall(ye,50).schedule.bind(null,null);function Re(){clearTimeout(Ae),Ae=setTimeout(function(){O&&(b.style.cssText=O,O=""),g.renderer.$isMousePressed=!1,g.renderer.$keepTextAreaAtCursor&&g.renderer.$moveTextAreaToCursor()},0)}y.addListener(b,"compositionstart",function(ge){W||!g.onCompositionStart||g.$readOnly||(W={},x)||(ge.data&&(W.useTextareaForIME=!1),setTimeout(ye,0),g._signal("compositionStart"),g.on("mousedown",be),(ge=g.getSelectionRange()).end.row=ge.start.row,ge.end.column=ge.start.column,W.markerRange=ge,W.selectionStart=v,g.onCompositionStart(W),W.useTextareaForIME?(_=b.value="",$=v=0):(b.msGetInputContext&&(W.context=b.msGetInputContext()),b.getInputContext&&(W.context=b.getInputContext())))},g),y.addListener(b,"compositionupdate",ye,g),y.addListener(b,"keyup",function(ge){ge.keyCode==27&&b.value.length<b.selectionStart&&(W||(_=b.value),v=$=-1,I()),we()},g),y.addListener(b,"keydown",we,g),y.addListener(b,"compositionend",xe,g),this.getElement=function(){return b},this.setCommandMode=function(ge){x=ge,b.readOnly=!1},this.setReadOnly=function(ge){x||(b.readOnly=ge)},this.setCopyWithEmptySelection=function(ge){},this.onContextMenu=function(ge){Z=!0,I(),g._emit("nativecontextmenu",{target:g,domEvent:ge}),this.moveToMouse(ge,!0)},this.moveToMouse=function(ge,ce){O=O||b.style.cssText,b.style.cssText=(ce?"z-index:100000;":"")+(d.isIE?"opacity:0.1;":"")+"text-indent: -"+(v+$)*g.renderer.characterWidth*.5+"px;";function ie(ae){h.translate(b,ae.clientX-$e-2,Math.min(ae.clientY-Ie-2,ee))}var ce=g.container.getBoundingClientRect(),fe=h.computedStyle(g.container),Ie=ce.top+(parseInt(fe.borderTopWidth)||0),$e=ce.left+(parseInt(ce.borderLeftWidth)||0),ee=ce.bottom-Ie-b.clientHeight-2;ie(ge),ge.type=="mousedown"&&(g.renderer.$isMousePressed=!0,clearTimeout(Ae),d.isWin)&&y.capture(g.container,ie,Re)},this.onContextMenuClose=Re;function We(ge){g.textInput.onContextMenu(ge),Re()}if(y.addListener(b,"mouseup",We,g),y.addListener(b,"mousedown",function(ge){ge.preventDefault(),Re()},g),y.addListener(g.renderer.scroller,"contextmenu",We,g),y.addListener(b,"contextmenu",We,g),t){let ge=function(te){var ie,ce,fe,Ie;document.activeElement!==ve||Pe||W||Se.$mouseHandler.isMousePressed||w||(ie=ve.selectionStart,ce=ve.selectionEnd,fe=null,(Ie=0)==ie?fe=r.up:ie==1?fe=r.home:$<ce&&_[ce]==`
`?fe=r.end:ie<v&&_[ie-1]==" "?(fe=r.left,Ie=e.option):ie<v||ie==v&&$!=v&&ie==ce?fe=r.left:$<ce&&2<_.slice(0,ce).split(`
`).length?fe=r.down:$<ce&&_[ce-1]==" "?(fe=r.right,Ie=e.option):($<ce||ce==$&&$!=v&&ie==ce)&&(fe=r.right),ie!==ce&&(Ie|=e.shift),fe&&(!Se.onCommandKey({},Ie,fe)&&Se.commands&&(fe=r.keyCodeToString(fe),Ie=Se.commands.findKeyCommand(Ie,fe))&&Se.execCommand(Ie),v=ie,$=ce,I("")))};var Se=g,ve=b,Le=null,Pe=!1;ve.addEventListener("keydown",function(te){Le&&clearTimeout(Le),Pe=!0},!0),ve.addEventListener("keyup",function(te){Le=setTimeout(function(){Pe=!1},100)},!0),document.addEventListener("selectionchange",ge),Se.on("destroy",function(){document.removeEventListener("selectionchange",ge)})}this.destroy=function(){b.parentElement&&b.parentElement.removeChild(b)}},f.$setUserAgentForTests=function(p,g){c=p,t=g}}),ace.define("ace/mouse/default_handlers",["require","exports","module","ace/lib/useragent"],function(C,f,R){var y=C("../lib/useragent"),C=(d.prototype.onMouseDown=function(l){var n=l.inSelection(),o=l.getDocumentPosition(),i=(this.mousedownEvent=l,this.editor),a=l.getButton();if(a!==0)!i.getSelectionRange().isEmpty()&&a!=1||i.selection.moveToPosition(o),a==2&&(i.textInput.onContextMenu(l.domEvent),y.isMozilla||l.preventDefault());else{if(this.mousedownEvent.time=Date.now(),!n||i.isFocused()||(i.focus(),!this.$focusTimeout)||this.$clickSelection||i.inMultiSelectMode)return this.captureMouse(l),this.startSelect(o,1<l.domEvent._clicks),l.preventDefault();this.setState("focusWait"),this.captureMouse(l)}},d.prototype.startSelect=function(l,n){l=l||this.editor.renderer.screenToTextCoordinates(this.x,this.y);var o=this.editor;this.mousedownEvent&&(this.mousedownEvent.getShiftKey()?o.selection.selectToPosition(l):n||o.selection.moveToPosition(l),n||this.select(),o.setStyle("ace_selecting"),this.setState("select"))},d.prototype.select=function(){var l,n=this.editor,o=n.renderer.screenToTextCoordinates(this.x,this.y);this.$clickSelection&&(l=(l=this.$clickSelection.comparePoint(o))==-1?this.$clickSelection.end:l==1?this.$clickSelection.start:(o=(l=h(this.$clickSelection,o)).cursor,l.anchor),n.selection.setSelectionAnchor(l.row,l.column)),n.selection.selectToPosition(o),n.renderer.scrollCursorIntoView()},d.prototype.extendSelectionBy=function(e){var n,o,i,a=this.editor,r=a.renderer.screenToTextCoordinates(this.x,this.y),e=a.selection[e](r.row,r.column);this.$clickSelection&&(o=this.$clickSelection.comparePoint(e.start),n=this.$clickSelection.comparePoint(e.end),o==-1&&n<=0?(i=this.$clickSelection.end,e.end.row==r.row&&e.end.column==r.column||(r=e.start)):n==1&&0<=o?(i=this.$clickSelection.start,e.start.row==r.row&&e.start.column==r.column||(r=e.end)):i=o==-1&&n==1?(r=e.end,e.start):(r=(o=h(this.$clickSelection,r)).cursor,o.anchor),a.selection.setSelectionAnchor(i.row,i.column)),a.selection.selectToPosition(r),a.renderer.scrollCursorIntoView()},d.prototype.selectByLinesEnd=function(){this.$clickSelection=null,this.editor.unsetStyle("ace_selecting")},d.prototype.focusWait=function(){i=this.mousedownEvent.x,l=this.mousedownEvent.y,o=this.x,n=this.y;var l,n,o=Math.sqrt(Math.pow(o-i,2)+Math.pow(n-l,2)),i=Date.now();(0<o||i-this.mousedownEvent.time>this.$focusTimeout)&&this.startSelect(this.mousedownEvent.getDocumentPosition())},d.prototype.onDoubleClick=function(n){var n=n.getDocumentPosition(),o=this.editor,i=o.session.getBracketRange(n);i?(i.isEmpty()&&(i.start.column--,i.end.column++),this.setState("select")):(i=o.selection.getWordRange(n.row,n.column),this.setState("selectByWords")),this.$clickSelection=i,this.select()},d.prototype.onTripleClick=function(n){var n=n.getDocumentPosition(),o=this.editor,i=(this.setState("selectByLines"),o.getSelectionRange());i.isMultiLine()&&i.contains(n.row,n.column)?(this.$clickSelection=o.selection.getLineRange(i.start.row),this.$clickSelection.end=o.selection.getLineRange(i.end.row).end):this.$clickSelection=o.selection.getLineRange(n.row),this.select()},d.prototype.onQuadClick=function(l){var n=this.editor;n.selectAll(),this.$clickSelection=n.getSelectionRange(),this.setState("selectAll")},d.prototype.onMouseWheel=function(l){var n,o,i,a,r,e,t;if(!l.getAccelKey())return l.getShiftKey()&&l.wheelY&&!l.wheelX&&(l.wheelX=l.wheelY,l.wheelY=0),n=this.editor,this.$lastScroll||(this.$lastScroll={t:0,vx:0,vy:0,allowed:0}),o=this.$lastScroll,a=(t=(i=l.domEvent.timeStamp)-o.t)?l.wheelX/t:o.vx,r=t?l.wheelY/t:o.vy,t<550&&(a=(a+o.vx)/2,r=(r+o.vy)/2),t=!1,1<=(e=Math.abs(a/r))&&n.renderer.isScrollableBy(l.wheelX*l.speed,0)&&(t=!0),(t=e<=1&&n.renderer.isScrollableBy(0,l.wheelY*l.speed)?!0:t)?o.allowed=i:i-o.allowed<550&&(Math.abs(a)<=1.5*Math.abs(o.vx)&&Math.abs(r)<=1.5*Math.abs(o.vy)?(t=!0,o.allowed=i):o.allowed=0),o.t=i,o.vx=a,o.vy=r,t?(n.renderer.scrollBy(l.wheelX*l.speed,l.wheelY*l.speed),l.stop()):void 0},d);function d(l){l.$clickSelection=null;var n=l.editor;n.setDefaultHandler("mousedown",this.onMouseDown.bind(l)),n.setDefaultHandler("dblclick",this.onDoubleClick.bind(l)),n.setDefaultHandler("tripleclick",this.onTripleClick.bind(l)),n.setDefaultHandler("quadclick",this.onQuadClick.bind(l)),n.setDefaultHandler("mousewheel",this.onMouseWheel.bind(l)),["select","startSelect","selectEnd","selectAllEnd","selectByWordsEnd","selectByLinesEnd","dragWait","dragWaitEnd","focusWait"].forEach(function(o){l[o]=this[o]},this),l.selectByLines=this.extendSelectionBy.bind(l,"getLineRange"),l.selectByWords=this.extendSelectionBy.bind(l,"getWordRange")}function h(l,n){return(l.start.row==l.end.row?2*n.column-l.start.column-l.end.column:l.start.row!=l.end.row-1||l.start.column||l.end.column?2*n.row-l.start.row-l.end.row:n.column-4)<0?{cursor:l.start,anchor:l.end}:{cursor:l.end,anchor:l.start}}C.prototype.selectEnd=C.prototype.selectByLinesEnd,C.prototype.selectAllEnd=C.prototype.selectByLinesEnd,C.prototype.selectByWordsEnd=C.prototype.selectByLinesEnd,f.DefaultHandlers=C}),ace.define("ace/tooltip",["require","exports","module","ace/lib/dom","ace/range"],function(n,f,R){var y,e=this&&this.__extends||(y=function(s,c){return(y=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(p,g){p.__proto__=g}:function(p,g){for(var b in g)Object.prototype.hasOwnProperty.call(g,b)&&(p[b]=g[b])}))(s,c)},function(s,c){if(typeof c!="function"&&c!==null)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");function p(){this.constructor=s}y(s,c),s.prototype=c===null?Object.create(c):(p.prototype=c.prototype,new p)}),C=this&&this.__values||function(s){var c=typeof Symbol=="function"&&Symbol.iterator,p=c&&s[c],g=0;if(p)return p.call(s);if(s&&typeof s.length=="number")return{next:function(){return{value:(s=s&&g>=s.length?void 0:s)&&s[g++],done:!s}}};throw new TypeError(c?"Object is not iterable.":"Symbol.iterator is not defined.")},d=n("./lib/dom"),h=n("./range").Range,l="ace_tooltip",n=(o.prototype.$init=function(){return this.$element=d.createElement("div"),this.$element.className=l,this.$element.style.display="none",this.$parentNode.appendChild(this.$element),this.$element},o.prototype.getElement=function(){return this.$element||this.$init()},o.prototype.setText=function(s){this.getElement().textContent=s},o.prototype.setHtml=function(s){this.getElement().innerHTML=s},o.prototype.setPosition=function(s,c){this.getElement().style.left=s+"px",this.getElement().style.top=c+"px"},o.prototype.setClassName=function(s){d.addCssClass(this.getElement(),s)},o.prototype.setTheme=function(s){this.$element.className=l+" "+(s.isDark?"ace_dark ":"")+(s.cssClass||"")},o.prototype.show=function(s,c,p){s!=null&&this.setText(s),c!=null&&p!=null&&this.setPosition(c,p),this.isOpen||(this.getElement().style.display="block",this.isOpen=!0)},o.prototype.hide=function(){this.isOpen&&(this.getElement().style.display="none",this.getElement().className=l,this.isOpen=!1)},o.prototype.getHeight=function(){return this.getElement().offsetHeight},o.prototype.getWidth=function(){return this.getElement().offsetWidth},o.prototype.destroy=function(){this.isOpen=!1,this.$element&&this.$element.parentNode&&this.$element.parentNode.removeChild(this.$element)},o);function o(s){this.isOpen=!1,this.$element=null,this.$parentNode=s}function i(){this.popups=[]}i.prototype.addPopup=function(s){this.popups.push(s),this.updatePopups()},i.prototype.removePopup=function(s){s=this.popups.indexOf(s),s!==-1&&(this.popups.splice(s,1),this.updatePopups())},i.prototype.updatePopups=function(){this.popups.sort(function(_,v){return v.priority-_.priority});var s,c,p,g,b=[];try{for(var w=C(this.popups),E=w.next();!E.done;E=w.next()){var W=E.value,B=!0;try{p=void 0;for(var O=C(b),x=O.next();!x.done;x=O.next()){var u=x.value;if(this.doPopupsOverlap(u,W)){B=!1;break}}}catch(_){p={error:_}}finally{try{x&&!x.done&&(g=O.return)&&g.call(O)}finally{if(p)throw p.error}}B?b.push(W):W.hide()}}catch(_){s={error:_}}finally{try{E&&!E.done&&(c=w.return)&&c.call(w)}finally{if(s)throw s.error}}},i.prototype.doPopupsOverlap=function(s,c){return s=s.getElement().getBoundingClientRect(),c=c.getElement().getBoundingClientRect(),s.left<c.right&&s.right>c.left&&s.top<c.bottom&&s.bottom>c.top};var a,r=new i,e=(f.popupManager=r,f.Tooltip=n,e(t,a=n),t.prototype.addToEditor=function(s){s.on("mousemove",this.onMouseMove),s.on("mousedown",this.hide),s.renderer.getMouseEventTarget().addEventListener("mouseout",this.onMouseOut,!0)},t.prototype.removeFromEditor=function(s){s.off("mousemove",this.onMouseMove),s.off("mousedown",this.hide),s.renderer.getMouseEventTarget().removeEventListener("mouseout",this.onMouseOut,!0),this.timeout&&(clearTimeout(this.timeout),this.timeout=null)},t.prototype.onMouseMove=function(s,g){this.lastEvent=s,this.lastT=Date.now();var p,g=g.$mouseHandler.isMousePressed;this.isOpen&&(p=this.lastEvent&&this.lastEvent.getDocumentPosition(),this.range&&this.range.contains(p.row,p.column)&&!g&&!this.isOutsideOfText(this.lastEvent)||this.hide()),this.timeout||g||(this.lastEvent=s,this.timeout=setTimeout(this.waitForHover,this.idleTime))},t.prototype.waitForHover=function(){this.timeout&&clearTimeout(this.timeout);var s=Date.now()-this.lastT;10<this.idleTime-s?this.timeout=setTimeout(this.waitForHover,this.idleTime-s):(this.timeout=null,this.lastEvent&&!this.isOutsideOfText(this.lastEvent)&&this.$gatherData(this.lastEvent,this.lastEvent.editor))},t.prototype.isOutsideOfText=function(s){var c=s.editor,p=s.getDocumentPosition(),g=c.session.getLine(p.row);return p.column==g.length&&(g=c.renderer.pixelToScreenCoordinates(s.clientX,s.clientY),s=c.session.documentToScreenPosition(p.row,p.column),s.column!=g.column||s.row!=g.row)},t.prototype.setDataProvider=function(s){this.$gatherData=s},t.prototype.showForRange=function(s,c,p,g){var b,w;g&&g!=this.lastEvent||this.isOpen&&document.activeElement==this.getElement()||(g=s.renderer,this.isOpen||(r.addPopup(this),this.$registerCloseEvents(),this.setTheme(g.theme)),this.isOpen=!0,this.addMarker(c,s.session),this.range=h.fromPoints(c.start,c.end),(s=this.getElement()).innerHTML="",s.appendChild(p),s.style.display="block",p=g.textToScreenCoordinates(c.start.row,c.start.column),c=s.clientHeight,b=g.scroller.getBoundingClientRect(),w=!0,(w=p.pageY-c<0?!1:w)?p.pageY-=c:p.pageY+=g.lineHeight,s.style.maxWidth=b.width-(p.pageX-b.left)+"px",this.setPosition(p.pageX,p.pageY))},t.prototype.addMarker=function(s,c){this.marker&&this.$markerSession.removeMarker(this.marker),this.$markerSession=c,this.marker=c&&c.addMarker(s,"ace_highlight-marker","text")},t.prototype.hide=function(s){!s&&document.activeElement==this.getElement()||s&&s.target&&(s.type!="keydown"||s.ctrlKey||s.metaKey)&&this.$element.contains(s.target)||(this.lastEvent=null,this.timeout&&clearTimeout(this.timeout),this.timeout=null,this.addMarker(null),this.isOpen&&(this.$removeCloseEvents(),this.getElement().style.display="none",this.isOpen=!1,r.removePopup(this)))},t.prototype.$registerCloseEvents=function(){window.addEventListener("keydown",this.hide,!0),window.addEventListener("mousewheel",this.hide,!0),window.addEventListener("mousedown",this.hide,!0)},t.prototype.$removeCloseEvents=function(){window.removeEventListener("keydown",this.hide,!0),window.removeEventListener("mousewheel",this.hide,!0),window.removeEventListener("mousedown",this.hide,!0)},t.prototype.onMouseOut=function(s){this.timeout&&(clearTimeout(this.timeout),this.timeout=null),this.lastEvent=null,!this.isOpen||!s.relatedTarget||s.relatedTarget==this.getElement()||s&&s.currentTarget.contains(s.relatedTarget)||s.relatedTarget.classList.contains("ace_content")||this.hide()},t);function t(c){c===void 0&&(c=document.body);var c=a.call(this,c)||this,p=(c.timeout=void 0,c.lastT=0,c.idleTime=350,c.lastEvent=void 0,c.onMouseOut=c.onMouseOut.bind(c),c.onMouseMove=c.onMouseMove.bind(c),c.waitForHover=c.waitForHover.bind(c),c.hide=c.hide.bind(c),c.getElement());return p.style.whiteSpace="pre-wrap",p.style.pointerEvents="auto",p.addEventListener("mouseout",c.onMouseOut),p.tabIndex=-1,p.addEventListener("blur",(function(){p.contains(document.activeElement)||this.hide()}).bind(c)),c}f.HoverTooltip=e}),ace.define("ace/mouse/default_gutter_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/tooltip","ace/config"],function(A,f,R){var y,C=this&&this.__extends||(y=function(e,t){return(y=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(s,c){s.__proto__=c}:function(s,c){for(var p in c)Object.prototype.hasOwnProperty.call(c,p)&&(s[p]=c[p])}))(e,t)},function(e,t){if(typeof t!="function"&&t!==null)throw new TypeError("Class extends value "+String(t)+" is not a constructor or null");function s(){this.constructor=e}y(e,t),e.prototype=t===null?Object.create(t):(s.prototype=t.prototype,new s)}),d=this&&this.__values||function(e){var t=typeof Symbol=="function"&&Symbol.iterator,s=t&&e[t],c=0;if(s)return s.call(e);if(e&&typeof e.length=="number")return{next:function(){return{value:(e=e&&c>=e.length?void 0:e)&&e[c++],done:!e}}};throw new TypeError(t?"Object is not iterable.":"Symbol.iterator is not defined.")},h=A("../lib/dom"),l=A("../lib/event"),n=A("../tooltip").Tooltip,o=A("../config").nls;f.GutterHandler=function(e){var t,s,c=e.editor,p=c.renderer.$gutterLayer,g=new a(c);function b(){t=t&&clearTimeout(t),g.isOpen&&(g.hideTooltip(),c.off("mousewheel",b))}function w(E){g.setPosition(E.x,E.y)}e.editor.setDefaultHandler("guttermousedown",function(E){if(c.isFocused()&&E.getButton()==0){var W=p.getRegion(E);if(W!="foldWidgets"){var W=E.getDocumentPosition().row,B=c.session.selection;if(E.getShiftKey())B.selectTo(W,0);else{if(E.domEvent.detail==2)return c.selectAll(),E.preventDefault();e.$clickSelection=c.selection.getLineRange(W)}return e.setState("selectByLines"),e.captureMouse(E),E.preventDefault()}}}),e.editor.setDefaultHandler("guttermousemove",function(E){var W=E.domEvent.target||E.domEvent.srcElement;if(h.hasCssClass(W,"ace_fold-widget"))return b();g.isOpen&&e.$tooltipFollowsMouse&&w(E),s=E,t=t||setTimeout(function(){if(t=null,s&&!e.isMousePressed){var B=s.getDocumentPosition().row;if(B==c.session.getLength()){var O=c.renderer.pixelToScreenCoordinates(0,s.y).row,x=s.$pos;if(O>c.session.documentToScreenRow(x.row,x.column))return void b()}g.showTooltip(B),g.isOpen&&(c.on("mousewheel",b),!e.$tooltipFollowsMouse&&(O=s.getGutterRow(),x=p.$lines.get(O))?(B=x.element.querySelector(".ace_gutter_annotation").getBoundingClientRect(),(O=g.getElement().style).left=B.right+"px",O.top=B.bottom+"px"):w(s))}else b()},50)}),l.addListener(c.renderer.$gutter,"mouseout",function(E){s=null,g.isOpen&&(t=t||setTimeout(function(){t=null,b()},50))},c),c.on("changeSession",b),c.on("input",b)},C(r,i=n),r.prototype.setPosition=function(e,t){var s=window.innerWidth||document.documentElement.clientWidth,c=window.innerHeight||document.documentElement.clientHeight,p=this.getWidth(),g=this.getHeight();s<(e+=15)+p&&(e-=e+p-s),c<(t+=15)+g&&(t-=20+g),n.prototype.setPosition.call(this,e,t)},Object.defineProperty(r,"annotationLabels",{get:function(){return{error:{singular:o("error"),plural:o("errors")},warning:{singular:o("warning"),plural:o("warnings")},info:{singular:o("information message"),plural:o("information messages")}}},enumerable:!1,configurable:!0}),r.prototype.showTooltip=function(e){var t=this.editor.renderer.$gutterLayer,s=t.$annotations[e],c=s?{text:Array.from(s.text),type:Array.from(s.type)}:{text:[],type:[]},p=t.session.getFoldLine(e);if(p&&t.$showFoldedAnnotations){for(var g,b={error:[],warning:[],info:[]},w=e+1;w<=p.end.row;w++)if(t.$annotations[w])for(var E=0;E<t.$annotations[w].text.length;E++){var W=t.$annotations[w].type[E];b[W].push(t.$annotations[w].text[E]),W==="error"?g="error_fold":W==="warning"&&(g="warning_fold")}g!=="error_fold"&&g!=="warning_fold"||(s="".concat(r.annotationsToSummaryString(b)," in folded code."),c.text.push(s),c.type.push(g))}if(c.text.length===0)return this.hide();for(var B={error:[],warning:[],info:[]},O=t.$useSvgGutterIcons?"ace_icon_svg":"ace_icon",w=0;w<c.text.length;w++){var x="<span class='ace_".concat(c.type[w]," ").concat(O,"' aria-label='").concat(r.annotationLabels[c.type[w].replace("_fold","")].singular,"' role=img> </span> ").concat(c.text[w]);B[c.type[w].replace("_fold","")].push(x)}e=[].concat(B.error,B.warning,B.info).join("<br>"),this.setHtml(e),this.$element.setAttribute("aria-live","polite"),this.isOpen||(this.setTheme(this.editor.renderer.theme),this.setClassName("ace_gutter-tooltip")),this.show(),this.editor._signal("showGutterTooltip",this)},r.prototype.hideTooltip=function(){this.$element.removeAttribute("aria-live"),this.hide(),this.editor._signal("hideGutterTooltip",this)},r.annotationsToSummaryString=function(e){var t,s,c=[];try{for(var p=d(["error","warning","info"]),g=p.next();!g.done;g=p.next()){var b,w=g.value;e[w].length&&(b=e[w].length===1?r.annotationLabels[w].singular:r.annotationLabels[w].plural,c.push("".concat(e[w].length," ").concat(b)))}}catch(E){t={error:E}}finally{try{g&&!g.done&&(s=p.return)&&s.call(p)}finally{if(t)throw t.error}}return c.join(", ")};var i,a=r;function r(e){var t=i.call(this,e.container)||this;return t.editor=e,t}f.GutterTooltip=a}),ace.define("ace/mouse/mouse_event",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(A,f,R){var y=A("../lib/event"),C=A("../lib/useragent");function d(h,l){this.domEvent=h,this.editor=l,this.x=this.clientX=h.clientX,this.y=this.clientY=h.clientY,this.$pos=null,this.$inSelection=null,this.propagationStopped=!1,this.defaultPrevented=!1}d.prototype.stopPropagation=function(){y.stopPropagation(this.domEvent),this.propagationStopped=!0},d.prototype.preventDefault=function(){y.preventDefault(this.domEvent),this.defaultPrevented=!0},d.prototype.stop=function(){this.stopPropagation(),this.preventDefault()},d.prototype.getDocumentPosition=function(){return this.$pos||(this.$pos=this.editor.renderer.screenToTextCoordinates(this.clientX,this.clientY)),this.$pos},d.prototype.getGutterRow=function(){var h=this.getDocumentPosition().row;return this.editor.session.documentToScreenRow(h,0)-this.editor.session.documentToScreenRow(this.editor.renderer.$gutterLayer.$lines.get(0).row,0)},d.prototype.inSelection=function(){var h,l;return this.$inSelection===null&&((h=this.editor.getSelectionRange()).isEmpty()?this.$inSelection=!1:(l=this.getDocumentPosition(),this.$inSelection=h.contains(l.row,l.column))),this.$inSelection},d.prototype.getButton=function(){return y.getButton(this.domEvent)},d.prototype.getShiftKey=function(){return this.domEvent.shiftKey},d.prototype.getAccelKey=function(){return C.isMac?this.domEvent.metaKey:this.domEvent.ctrlKey},f.MouseEvent=d}),ace.define("ace/mouse/dragdrop_handler",["require","exports","module","ace/lib/dom","ace/lib/event","ace/lib/useragent"],function(A,f,R){var y=A("../lib/dom"),C=A("../lib/event"),d=A("../lib/useragent");function h(n){var o,i,a,r,e,t,s,c,p,g,b,w=n.editor,E=y.createElement("div"),W=(E.style.cssText="top:-100px;position:absolute;z-index:2147483647;opacity:0.5",E.textContent=" ",["dragWait","dragWaitEnd","startDrag","dragReadyEnd","onMouseDrag"].forEach(function(M){n[M]=this[M]},this),w.on("mousedown",this.onMouseDown.bind(n)),w.container),B=0;function O(){var M,X,Q,K,ne,T,F,V,I=t;t=w.renderer.screenToTextCoordinates(i,a),Q=t,X=I,K=Date.now(),M=!X||Q.row!=X.row,X=!X||Q.column!=X.column,!g||M||X?(w.moveCursorToPosition(Q),g=K,b={x:i,y:a}):5<l(b.x,b.y,i,a)?g=null:200<=K-g&&(w.renderer.scrollCursorIntoView(),g=null),M=t,X=I,Q=Date.now(),K=w.renderer.layerConfig.lineHeight,I=w.renderer.layerConfig.characterWidth,ne=w.renderer.scroller.getBoundingClientRect(),ne={x:{left:i-ne.left,right:ne.right-i},y:{top:a-ne.top,bottom:ne.bottom-a}},T=Math.min(ne.x.left,ne.x.right),F=Math.min(ne.y.top,ne.y.bottom),V={row:M.row,column:M.column},T/I<=2&&(V.column+=ne.x.left<ne.x.right?-3:2),F/K<=1&&(V.row+=ne.y.top<ne.y.bottom?-1:1),T=M.row!=V.row,I=M.column!=V.column,F=!X||M.row!=X.row,T||I&&!F?p?200<=Q-p&&w.renderer.scrollCursorIntoView(V):p=Q:p=null}function x(){e=w.selection.toOrientedRange(),o=w.session.addMarker(e,"ace_selection",w.getSelectionStyle()),w.clearSelection(),w.isFocused()&&w.renderer.$cursorLayer.setBlinking(!1),clearInterval(r),O(),r=setInterval(O,20),B=0,C.addListener(document,"mousemove",v)}function u(){clearInterval(r),w.session.removeMarker(o),o=null,w.selection.fromOrientedRange(e),w.isFocused()&&!c&&w.$resetCursorStyle(),B=0,g=p=t=e=null,C.removeListener(document,"mousemove",v)}this.onDragStart=function(M){var X;if(this.cancelDrag||!W.draggable)return X=this,setTimeout(function(){X.startSelect(),X.captureMouse(M)},0),M.preventDefault();e=w.getSelectionRange();var Q=M.dataTransfer;Q.effectAllowed=w.getReadOnly()?"copy":"copyMove",w.container.appendChild(E),Q.setDragImage&&Q.setDragImage(E,0,0),setTimeout(function(){w.container.removeChild(E)}),Q.clearData(),Q.setData("Text",w.session.getTextRange()),c=!0,this.setState("drag")},this.onDragEnd=function(M){W.draggable=!1,c=!1,this.setState(null),w.getReadOnly()||(M=M.dataTransfer.dropEffect,s||M!="move"||w.session.remove(w.getSelectionRange()),w.$resetCursorStyle()),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle("")},this.onDragEnter=function(M){if(!w.getReadOnly()&&$(M.dataTransfer))return i=M.clientX,a=M.clientY,o||x(),B++,M.dataTransfer.dropEffect=s=P(M),C.preventDefault(M)},this.onDragOver=function(M){if(!w.getReadOnly()&&$(M.dataTransfer))return i=M.clientX,a=M.clientY,o||(x(),B++),_!==null&&(_=null),M.dataTransfer.dropEffect=s=P(M),C.preventDefault(M)},this.onDragLeave=function(M){if(--B<=0&&o)return u(),s=null,C.preventDefault(M)},this.onDrop=function(M){if(t){var X=M.dataTransfer;if(c)switch(s){case"move":e=e.contains(t.row,t.column)?{start:t,end:t}:w.moveText(e,t);break;case"copy":e=w.moveText(e,t,!0)}else X=X.getData("Text"),e={start:t,end:w.session.insert(t,X)},w.focus(),s=null;return u(),C.preventDefault(M)}},C.addListener(W,"dragstart",this.onDragStart.bind(n),w),C.addListener(W,"dragend",this.onDragEnd.bind(n),w),C.addListener(W,"dragenter",this.onDragEnter.bind(n),w),C.addListener(W,"dragover",this.onDragOver.bind(n),w),C.addListener(W,"dragleave",this.onDragLeave.bind(n),w),C.addListener(W,"drop",this.onDrop.bind(n),w);var _=null;function v(){_==null&&(_=setTimeout(function(){_!=null&&o&&u()},20))}function $(M){return M=M.types,!M||Array.prototype.some.call(M,function(X){return X=="text/plain"||X=="Text"})}function P(M){var X=["copy","copymove","all","uninitialized"],Q=d.isMac?M.altKey:M.ctrlKey,K="uninitialized";try{K=M.dataTransfer.effectAllowed.toLowerCase()}catch{}var ne="none";return Q&&0<=X.indexOf(K)?ne="copy":0<=["move","copymove","linkmove","all","uninitialized"].indexOf(K)?ne="move":0<=X.indexOf(K)&&(ne="copy"),ne}}function l(n,o,i,a){return Math.sqrt(Math.pow(i-n,2)+Math.pow(a-o,2))}(function(){this.dragWait=function(){Date.now()-this.mousedownEvent.time>this.editor.getDragDelay()&&this.startDrag()},this.dragWaitEnd=function(){this.editor.container.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()),this.selectEnd()},this.dragReadyEnd=function(n){this.editor.$resetCursorStyle(),this.editor.unsetStyle("ace_dragging"),this.editor.renderer.setCursorStyle(""),this.dragWaitEnd()},this.startDrag=function(){this.cancelDrag=!1;var n=this.editor,o=(n.container.draggable=!0,n.renderer.$cursorLayer.setBlinking(!1),n.setStyle("ace_dragging"),d.isWin?"default":"move");n.renderer.setCursorStyle(o),this.setState("dragReady")},this.onMouseDrag=function(n){var o=this.editor.container;d.isIE&&this.state=="dragReady"&&3<l(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&o.dragDrop(),this.state==="dragWait"&&0<l(this.mousedownEvent.x,this.mousedownEvent.y,this.x,this.y)&&(o.draggable=!1,this.startSelect(this.mousedownEvent.getDocumentPosition()))},this.onMouseDown=function(n){var o,i,a;this.$dragEnabled&&(this.mousedownEvent=n,o=this.editor,i=n.inSelection(),a=n.getButton(),(n.domEvent.detail||1)!==1||a!==0||!i||n.editor.inMultiSelectMode&&(n.getAccelKey()||n.getShiftKey())||(this.mousedownEvent.time=Date.now(),"unselectable"in(a=n.domEvent.target||n.domEvent.srcElement)&&(a.unselectable="on"),o.getDragDelay()?(d.isWebKit&&(this.cancelDrag=!0,o.container.draggable=!0),this.setState("dragWait")):this.startDrag(),this.captureMouse(n,this.onMouseDrag.bind(this)),n.defaultPrevented=!0))}}).call(h.prototype),f.DragdropHandler=h}),ace.define("ace/mouse/touch_handler",["require","exports","module","ace/mouse/mouse_event","ace/lib/event","ace/lib/dom"],function(A,f,R){var y=A("./mouse_event").MouseEvent,C=A("../lib/event"),d=A("../lib/dom");f.addTouchListeners=function(h,l){var n,o,i,a,r,e,t,s,c,p="scroll",g=0,b=0,w=0,E=0;function W(){function u($){var P,M=$.target.getAttribute("action");M!="more"&&v?(M=="paste"?_.readText().then(function(X){l.execCommand(M,X)}):M&&(M!="cut"&&M!="copy"||(_?_.writeText(l.getCopyText()):document.execCommand("copy")),l.execCommand(M)),c.firstChild.style.display="none",v=!1,M!="openCommandPalette"&&l.focus()):(v=!v,$=l.getCopyText(),P=l.session.getUndoManager().hasUndo(),c.replaceChild(d.buildDom(v?["span",!$&&["span",{class:"ace_mobile-button",action:"selectall"},"Select All"],$&&["span",{class:"ace_mobile-button",action:"copy"},"Copy"],$&&["span",{class:"ace_mobile-button",action:"cut"},"Cut"],_&&["span",{class:"ace_mobile-button",action:"paste"},"Paste"],P&&["span",{class:"ace_mobile-button",action:"undo"},"Undo"],["span",{class:"ace_mobile-button",action:"find"},"Find"],["span",{class:"ace_mobile-button",action:"openCommandPalette"},"Palette"]]:["span"]),c.firstChild))}var _=window.navigator&&window.navigator.clipboard,v=!1;c=d.buildDom(["div",{class:"ace_mobile-menu",ontouchstart:function($){p="menu",$.stopPropagation(),$.preventDefault(),l.textInput.focus()},ontouchend:function($){$.stopPropagation(),$.preventDefault(),u($)},onclick:u},["span"],["span",{class:"ace_mobile-button",action:"more"},"..."]],l.container)}function B(){c||W();var u=l.selection.cursor,u=l.renderer.textToScreenCoordinates(u.row,u.column),_=l.renderer.textToScreenCoordinates(0,0).pageX,v=l.renderer.scrollLeft,$=l.container.getBoundingClientRect();c.style.top=u.pageY-$.top-3+"px",u.pageX-$.left<$.width-70?(c.style.left="",c.style.right="10px"):(c.style.right="",c.style.left=_+v-$.left+"px"),c.style.display="",c.firstChild.style.display="none",l.on("input",O)}function O(u){c&&(c.style.display="none"),l.off("input",O)}function x(){r=null,clearTimeout(r);var u=l.selection.getRange(),_=u.contains(t.row,t.column);!u.isEmpty()&&_||(l.selection.moveToPosition(t),l.selection.selectWord()),p="wait",B()}C.addListener(h,"contextmenu",function(u){s&&l.textInput.getElement().focus()},l),C.addListener(h,"touchstart",function(u){var _=u.touches;if(r||1<_.length)clearTimeout(r),r=null,i=-1,p="zoom";else{s=l.$mouseHandler.isMousePressed=!0;var v=l.renderer.layerConfig.lineHeight,$=l.renderer.layerConfig.lineHeight,P=u.timeStamp,M=(a=P,_[0]),X=M.clientX,M=M.clientY,X=(Math.abs(n-X)+Math.abs(o-M)>v&&(i=-1),n=u.clientX=X,o=u.clientY=M,w=E=0,new y(u,l));if(t=X.getDocumentPosition(),P-i<500&&_.length==1&&!g)b++,u.preventDefault(),u.button=0,r=null,clearTimeout(r),l.selection.moveToPosition(t),(M=2<=b?l.selection.getLineRange(t.row):l.session.getBracketRange(t))&&!M.isEmpty()?l.selection.setRange(M):l.selection.selectWord(),p="wait";else{b=0;var X=l.selection.cursor,_=l.selection.isEmpty()?X:l.selection.anchor,M=l.renderer.$cursorLayer.getPixelPosition(X,!0),X=l.renderer.$cursorLayer.getPixelPosition(_,!0),_=l.renderer.scroller.getBoundingClientRect(),Q=l.renderer.layerConfig.offset,K=l.renderer.scrollLeft,ne=function(I,S){return(I/=$)*I+(S=S/v-.75)*S};if(u.clientX<_.left)return void(p="zoom");M=ne(u.clientX-_.left-M.left+K,u.clientY-_.top-M.top+Q),ne=ne(u.clientX-_.left-X.left+K,u.clientY-_.top-X.top+Q),M<3.5&&ne<3.5&&(p=ne<M?"cursor":"anchor"),p=ne<3.5?"anchor":M<3.5?"cursor":"scroll",r=setTimeout(x,450)}i=P}},l),C.addListener(h,"touchend",function(u){s=l.$mouseHandler.isMousePressed=!1,e&&clearInterval(e),p=="zoom"?(p="",g=0):(r?(l.selection.moveToPosition(t),g=0,B):p=="scroll"?(g+=60,e=setInterval(function(){g--<=0&&(clearInterval(e),e=null),Math.abs(w)<.01&&(w=0),Math.abs(E)<.01&&(E=0),g<20&&(w*=.9),g<20&&(E*=.9);var _=l.session.getScrollTop();l.renderer.scrollBy(10*w,10*E),_==l.session.getScrollTop()&&(g=0)},10),O):B)(),clearTimeout(r),r=null},l),C.addListener(h,"touchmove",function(u){r&&(clearTimeout(r),r=null);var _=u.touches;if(!(1<_.length||p=="zoom")){var _=_[0],v=n-_.clientX,$=o-_.clientY;if(p=="wait"){if(!(4<v*v+$*$))return u.preventDefault();p="cursor"}n=_.clientX,o=_.clientY,u.clientX=_.clientX,u.clientY=_.clientY;var _=u.timeStamp,P=_-a;a=_,p=="scroll"?((_=new y(u,l)).speed=1,_.wheelX=v,_.wheelY=$,10*Math.abs(v)<Math.abs($)&&(v=0),10*Math.abs($)<Math.abs(v)&&($=0),P!=0&&(w=v/P,E=$/P),l._emit("mousewheel",_),_.propagationStopped||(w=E=0)):(v=new y(u,l).getDocumentPosition(),p=="cursor"?l.selection.moveCursorToPosition(v):p=="anchor"&&l.selection.setSelectionAnchor(v.row,v.column),l.renderer.scrollCursorIntoView(v),u.preventDefault())}},l)}}),ace.define("ace/mouse/mouse_handler",["require","exports","module","ace/lib/event","ace/lib/useragent","ace/mouse/default_handlers","ace/mouse/default_gutter_handler","ace/mouse/mouse_event","ace/mouse/dragdrop_handler","ace/mouse/touch_handler","ace/config"],function(i,f,R){var y=i("../lib/event"),C=i("../lib/useragent"),d=i("./default_handlers").DefaultHandlers,h=i("./default_gutter_handler").GutterHandler,l=i("./mouse_event").MouseEvent,n=i("./dragdrop_handler").DragdropHandler,o=i("./touch_handler").addTouchListeners,i=i("../config"),a=(r.prototype.onMouseEvent=function(e,t){this.editor.session&&this.editor._emit(e,new l(t,this.editor))},r.prototype.onMouseMove=function(e,t){var s=this.editor._eventRegistry&&this.editor._eventRegistry.mousemove;s&&s.length&&this.editor._emit(e,new l(t,this.editor))},r.prototype.onMouseWheel=function(e,t){var s=new l(t,this.editor);s.speed=2*this.$scrollSpeed,s.wheelX=t.wheelX,s.wheelY=t.wheelY,this.editor._emit(e,s)},r.prototype.setState=function(e){this.state=e},r.prototype.captureMouse=function(e,t){this.x=e.x,this.y=e.y,this.isMousePressed=!0;function s(B){if(B){if(C.isWebKit&&!B.which&&w.releaseMouse)return w.releaseMouse();w.x=B.clientX,w.y=B.clientY,t&&t(B),w.mouseEvent=new l(B,w.editor),w.$mouseMoved=!0}}function c(B){g.off("beforeEndOperation",E),clearInterval(W),g.session&&p(),w[w.state+"End"]&&w[w.state+"End"](B),w.state="",w.isMousePressed=b.$isMousePressed=!1,b.$keepTextAreaAtCursor&&b.$moveTextAreaToCursor(),w.$onCaptureMouseMove=w.releaseMouse=null,B&&w.onMouseEvent("mouseup",B),g.endOperation()}function p(){w[w.state]&&w[w.state](),w.$mouseMoved=!1}var g=this.editor,b=this.editor.renderer,w=(b.$isMousePressed=!0,this);if(C.isOldIE&&e.domEvent.type=="dblclick")return setTimeout(function(){c(e)});var E=function(B){w.releaseMouse&&g.curOp.command.name&&g.curOp.selectionChanged&&(w[w.state+"End"]&&w[w.state+"End"](),w.state="",w.releaseMouse())},W=(g.on("beforeEndOperation",E),g.startOperation({command:{name:"mouse"}}),w.$onCaptureMouseMove=s,w.releaseMouse=y.capture(this.editor.container,s,c),setInterval(p,20))},r.prototype.cancelContextMenu=function(){var e=(function(t){t&&t.domEvent&&t.domEvent.type!="contextmenu"||(this.editor.off("nativecontextmenu",e),t&&t.domEvent&&y.stopEvent(t.domEvent))}).bind(this);setTimeout(e,10),this.editor.on("nativecontextmenu",e)},r.prototype.destroy=function(){this.releaseMouse&&this.releaseMouse()},r);function r(e){function t(g){document.hasFocus&&document.hasFocus()&&(e.isFocused()||document.activeElement!=(e.textInput&&e.textInput.getElement()))||window.focus(),e.focus(),setTimeout(function(){e.isFocused()||e.focus()})}var s=this,c=(this.editor=e,new d(this),new h(this),new n(this),e.renderer.getMouseEventTarget()),p=(y.addListener(c,"click",this.onMouseEvent.bind(this,"click"),e),y.addListener(c,"mousemove",this.onMouseMove.bind(this,"mousemove"),e),y.addMultiMouseDownListener([c,e.renderer.scrollBarV&&e.renderer.scrollBarV.inner,e.renderer.scrollBarH&&e.renderer.scrollBarH.inner,e.textInput&&e.textInput.getElement()].filter(Boolean),[400,300,250],this,"onMouseEvent",e),y.addMouseWheelListener(e.container,this.onMouseWheel.bind(this,"mousewheel"),e),o(e.container,e),e.renderer.$gutter);y.addListener(p,"mousedown",this.onMouseEvent.bind(this,"guttermousedown"),e),y.addListener(p,"click",this.onMouseEvent.bind(this,"gutterclick"),e),y.addListener(p,"dblclick",this.onMouseEvent.bind(this,"gutterdblclick"),e),y.addListener(p,"mousemove",this.onMouseEvent.bind(this,"guttermousemove"),e),y.addListener(c,"mousedown",t,e),y.addListener(p,"mousedown",t,e),C.isIE&&e.renderer.scrollBarV&&(y.addListener(e.renderer.scrollBarV.element,"mousedown",t,e),y.addListener(e.renderer.scrollBarH.element,"mousedown",t,e)),e.on("mousemove",function(g){var b,w;s.state||s.$dragDelay||!s.$dragEnabled||(g=e.renderer.screenToTextCoordinates(g.x,g.y),b=e.session.selection.getRange(),w=e.renderer,!b.isEmpty()&&b.insideStart(g.row,g.column)?w.setCursorStyle("default"):w.setCursorStyle(""))},e)}a.prototype.releaseMouse=null,i.defineOptions(a.prototype,"mouseHandler",{scrollSpeed:{initialValue:2},dragDelay:{initialValue:C.isMac?150:0},dragEnabled:{initialValue:!0},focusTimeout:{initialValue:0},tooltipFollowsMouse:{initialValue:!0}}),f.MouseHandler=a}),ace.define("ace/mouse/fold_handler",["require","exports","module","ace/lib/dom"],function(A,f,R){var y=A("../lib/dom");f.FoldHandler=function(C){C.on("click",function(d){var l=d.getDocumentPosition(),h=C.session,l=h.getFoldAt(l.row,l.column,1),l=(l&&(d.getAccelKey()?h.removeFold(l):h.expandFold(l),d.stop()),d.domEvent&&d.domEvent.target);l&&y.hasCssClass(l,"ace_inline_button")&&y.hasCssClass(l,"ace_toggle_wrap")&&(h.setOption("wrap",!h.getUseWrapMode()),C.renderer.scrollCursorIntoView())}),C.on("gutterclick",function(d){var h,l;C.renderer.$gutterLayer.getRegion(d)=="foldWidgets"&&(h=d.getDocumentPosition().row,(l=C.session).foldWidgets&&l.foldWidgets[h]&&C.session.onFoldWidgetClick(h,d),C.isFocused()||C.focus(),d.stop())}),C.on("gutterdblclick",function(d){var h,l,n;C.renderer.$gutterLayer.getRegion(d)=="foldWidgets"&&(n=d.getDocumentPosition().row,(l=(l=(h=C.session).getParentFoldRangeData(n,!0)).range||l.firstRange)&&(n=l.start.row,(n=h.getFoldAt(n,h.getLine(n).length,1))?h.removeFold(n):(h.addFold("...",l),C.renderer.scrollCursorIntoView({row:l.start.row,column:0}))),d.stop())})}}),ace.define("ace/keyboard/keybinding",["require","exports","module","ace/lib/keys","ace/lib/event"],function(A,f,R){var y=A("../lib/keys"),C=A("../lib/event");function d(h){this.$editor=h,this.$data={editor:h},this.$handlers=[],this.setDefaultHandler(h.commands)}d.prototype.setDefaultHandler=function(h){this.removeKeyboardHandler(this.$defaultHandler),this.$defaultHandler=h,this.addKeyboardHandler(h,0)},d.prototype.setKeyboardHandler=function(h){var l=this.$handlers;if(l[l.length-1]!=h){for(;l[l.length-1]&&l[l.length-1]!=this.$defaultHandler;)this.removeKeyboardHandler(l[l.length-1]);this.addKeyboardHandler(h,1)}},d.prototype.addKeyboardHandler=function(h,l){var n;h&&(typeof h!="function"||h.handleKeyboard||(h.handleKeyboard=h),(n=this.$handlers.indexOf(h))!=-1&&this.$handlers.splice(n,1),l==null?this.$handlers.push(h):this.$handlers.splice(l,0,h),n==-1)&&h.attach&&h.attach(this.$editor)},d.prototype.removeKeyboardHandler=function(h){var l=this.$handlers.indexOf(h);return l!=-1&&(this.$handlers.splice(l,1),h.detach&&h.detach(this.$editor),!0)},d.prototype.getKeyboardHandler=function(){return this.$handlers[this.$handlers.length-1]},d.prototype.getStatusText=function(){var h=this.$data,l=h.editor;return this.$handlers.map(function(n){return n.getStatusText&&n.getStatusText(l,h)||""}).filter(Boolean).join(" ")},d.prototype.$callKeyboardHandlers=function(h,l,n,o){for(var i,a=!1,r=this.$editor.commands,e=this.$handlers.length;e--&&!((i=this.$handlers[e].handleKeyboard(this.$data,h,l,n,o))&&i.command&&((a=i.command=="null"||r.exec(i.command,this.$editor,i.args,o))&&o&&h!=-1&&i.passEvent!=1&&i.command.passEvent!=1&&C.stopEvent(o),a)););return a||h!=-1||(i={command:"insertstring"},a=r.exec("insertstring",this.$editor,l)),a&&this.$editor._signal&&this.$editor._signal("keyboardActivity",i),a},d.prototype.onCommandKey=function(h,l,n){var o=y.keyCodeToString(n);return this.$callKeyboardHandlers(l,o,n,h)},d.prototype.onTextInput=function(h){return this.$callKeyboardHandlers(-1,h)},f.KeyBinding=d}),ace.define("ace/lib/bidiutil",["require","exports","module"],function(A,f,R){var y=0,C=0,d=!1,h=!1,l=!1,n=[[0,3,0,1,0,0,0],[0,3,0,1,2,2,0],[0,3,0,17,2,0,1],[0,3,5,5,4,1,0],[0,3,21,21,4,0,1],[0,3,5,5,4,2,0]],o=[[2,0,1,1,0,1,0],[2,0,1,1,0,2,0],[2,0,2,1,3,2,0],[2,0,2,33,3,1,1]],i=0,a=1,r=2,e=3,t=4,s=5,c=6,p=7,g=8,b=9,w=10,E=11,W=12,B=13,O=14,x=15,u=16,_=17,v=18,$=[v,v,v,v,v,v,v,v,v,c,s,c,g,s,v,v,v,v,v,v,v,v,v,v,v,v,v,v,s,s,s,c,g,t,t,E,E,E,t,t,t,t,t,w,b,w,b,b,r,r,r,r,r,r,r,r,r,r,b,t,t,t,t,t,t,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,t,t,t,t,t,t,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,i,t,t,t,t,v,v,v,v,v,v,s,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,v,b,t,E,E,E,E,t,t,t,t,i,t,t,v,t,t,E,E,r,r,t,i,t,t,t,r,i,t,t,t,t,t],P=[g,g,g,g,g,g,g,g,g,g,g,v,v,v,i,a,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,g,s,B,O,x,u,_,b,E,E,E,E,E,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,b,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,t,g];function M(K,ne,T,F){var V,I,S,L=y?o:n,Z=0,J=-1,re=null,pe=null,me=[];if(!F)for(re=0,F=[];re<T;re++)F[re]=Q(K[re]);for(C=y,l=h=d=!1,pe=0;pe<T;pe++){if(S=Z,me[pe]=V=function(xe,be,Ae,we){var Re,We,Se,ve=be[we];switch(ve){case i:case a:d=!1;case t:case e:return ve;case r:return d?e:r;case p:return d=!0,a;case g:return t;case b:return we<1||we+1>=be.length||(Re=Ae[we-1])!=r&&Re!=e||(Le=be[we+1])!=r&&Le!=e?t:(Le=d?e:Le)==Re?Le:t;case w:return(Re=0<we?Ae[we-1]:s)==r&&we+1<be.length&&be[we+1]==r?r:t;case E:if(0<we&&Ae[we-1]==r)return r;if(d)return t;for(Se=we+1,We=be.length;Se<We&&be[Se]==E;)Se++;return Se<We&&be[Se]==r?r:t;case W:for(We=be.length,Se=we+1;Se<We&&be[Se]==W;)Se++;if(Se<We){var Le=xe[we],Le=1425<=Le&&Le<=2303||Le==64286;if(Re=be[Se],Le&&(Re==a||Re==p))return a}return we<1||(Re=be[we-1])==s?t:Ae[we-1];case s:return h=!(d=!1),y;case c:return l=!0,t;case B:case O:case u:case _:case x:d=!1;case v:return t}}(K,F,me,pe),S=240&(Z=L[S][V]),Z&=15,ne[pe]=I=L[Z][5],0<S){if(S==16)for(re=J;re<pe;re++)ne[re]=1;J=-1}if(L[Z][6])J==-1&&(J=pe);else if(-1<J){for(re=J;re<pe;re++)ne[re]=I;J=-1}F[pe]==s&&(ne[pe]=0),C|=I}if(l){for(re=0;re<T;re++)if(F[re]==c){ne[re]=y;for(var ye=re-1;0<=ye&&F[ye]==g;ye--)ne[ye]=y}}}function X(K,ne,T){if(!(C<K))if(K!=1||y!=1||h)for(var F,V,I,S,L=T.length,Z=0;Z<L;){if(ne[Z]>=K){for(F=Z+1;F<L&&ne[F]>=K;)F++;for(V=Z,I=F-1;V<I;V++,I--)S=T[V],T[V]=T[I],T[I]=S;Z=F}Z++}else T.reverse()}function Q(K){var ne=K.charCodeAt(0),T=ne>>8;return T==0?191<ne?i:$[ne]:T==5?/[\u0591-\u05f4]/.test(K)?a:i:T==6?/[\u0610-\u061a\u064b-\u065f\u06d6-\u06e4\u06e7-\u06ed]/.test(K)?W:/[\u0660-\u0669\u066b-\u066c]/.test(K)?e:ne==1642?E:/[\u06f0-\u06f9]/.test(K)?r:p:T==32&&ne<=8287?P[255&ne]:T==254&&65136<=ne?p:t}f.L=i,f.R=a,f.EN=r,f.ON_R=3,f.AN=4,f.R_H=5,f.B=6,f.RLE=7,f.DOT="·",f.doBidiReorder=function(K,ne,T){if(K.length<2)return{};var F=K.split(""),V=new Array(F.length),I=new Array(F.length),S=[];y=T?1:0,M(F,S,F.length,ne);for(var L=0;L<V.length;V[L]=L,L++);for(X(2,S,V),X(1,S,V),L=0;L<V.length-1;L++)ne[L]===e?S[L]=f.AN:S[L]===a&&(ne[L]>p&&ne[L]<B||ne[L]===t||ne[L]===v)?S[L]=f.ON_R:0<L&&F[L-1]==="ل"&&/\u0622|\u0623|\u0625|\u0627/.test(F[L])&&(S[L-1]=S[L]=f.R_H,L++);for(F[F.length-1]===f.DOT&&(S[F.length-1]=f.B),F[0]==="‫"&&(S[0]=f.RLE),L=0;L<V.length;L++)I[L]=S[V[L]];return{logicalFromVisual:V,bidiLevels:I}},f.hasBidiCharacters=function(K,ne){for(var T=!1,F=0;F<K.length;F++)ne[F]=Q(K.charAt(F)),T||ne[F]!=a&&ne[F]!=p&&ne[F]!=e||(T=!0);return T},f.getVisualFromLogicalIdx=function(K,ne){for(var T=0;T<ne.logicalFromVisual.length;T++)if(ne.logicalFromVisual[T]==K)return T;return 0}}),ace.define("ace/bidihandler",["require","exports","module","ace/lib/bidiutil","ace/lib/lang"],function(A,f,R){var y=A("./lib/bidiutil"),C=A("./lib/lang"),d=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac\u202B]/;function h(l){this.session=l,this.bidiMap={},this.currentRow=null,this.bidiUtil=y,this.charWidths=[],this.EOL="¬",this.showInvisibles=!0,this.isRtlDir=!1,this.$isRtl=!1,this.line="",this.wrapIndent=0,this.EOF="¶",this.RLE="‫",this.contentWidth=0,this.fontMetrics=null,this.rtlLineOffset=0,this.wrapOffset=0,this.isMoveLeftOperation=!1,this.seenBidi=d.test(l.getValue())}h.prototype.isBidiRow=function(l,n,o){return!!this.seenBidi&&(l!==this.currentRow&&(this.currentRow=l,this.updateRowLine(n,o),this.updateBidiMap()),this.bidiMap.bidiLevels)},h.prototype.onChange=function(l){this.seenBidi?this.currentRow=null:l.action=="insert"&&d.test(l.lines.join(`
`))&&(this.seenBidi=!0,this.currentRow=null)},h.prototype.getDocumentRow=function(){var l=0,n=this.session.$screenRowCache;return l=n.length&&0<=(n=this.session.$getRowCacheIndex(n,this.currentRow))?this.session.$docRowCache[n]:l},h.prototype.getSplitIndex=function(){var l=0,n=this.session.$screenRowCache;if(n.length)for(var o,i=this.session.$getRowCacheIndex(n,this.currentRow);0<this.currentRow-l&&(o=this.session.$getRowCacheIndex(n,this.currentRow-l-1))===i;)i=o,l++;else l=this.currentRow;return l},h.prototype.updateRowLine=function(l,n){var o,i=(l=l===void 0?this.getDocumentRow():l)===this.session.getLength()-1?this.EOF:this.EOL,a=(this.wrapIndent=0,this.line=this.session.getLine(l),this.isRtlDir=this.$isRtl||this.line.charAt(0)===this.RLE,(!this.session.$useWrapMode||(l=this.session.$wrapData[l])&&(0<(n=n===void 0?this.getSplitIndex():n)&&l.length?(this.wrapIndent=l.indent,this.wrapOffset=this.wrapIndent*this.charWidths[y.L],this.line=n<l.length?this.line.substring(l[n-1],l[n]):this.line.substring(l[l.length-1])):this.line=this.line.substring(0,l[n]),n==l.length))&&(this.line+=this.showInvisibles?i:y.DOT),this.session),r=0;this.line=this.line.replace(/\t|[\u1100-\u2029, \u202F-\uFFE6]/g,function(e,t){return e==="	"||a.isFullWidth(e.charCodeAt(0))?(o=e==="	"?a.getScreenTabSize(t+r):2,r+=o-1,C.stringRepeat(y.DOT,o)):e}),this.isRtlDir&&(this.fontMetrics.$main.textContent=this.line.charAt(this.line.length-1)==y.DOT?this.line.substr(0,this.line.length-1):this.line,this.rtlLineOffset=this.contentWidth-this.fontMetrics.$main.getBoundingClientRect().width)},h.prototype.updateBidiMap=function(){var l=[];y.hasBidiCharacters(this.line,l)||this.isRtlDir?this.bidiMap=y.doBidiReorder(this.line,l,this.isRtlDir):this.bidiMap={}},h.prototype.markAsDirty=function(){this.currentRow=null},h.prototype.updateCharacterWidths=function(l){var n;this.characterWidth!==l.$characterSize.width&&(this.fontMetrics=l,n=this.characterWidth=l.$characterSize.width,l=l.$measureCharWidth("ה"),this.charWidths[y.L]=this.charWidths[y.EN]=this.charWidths[y.ON_R]=n,this.charWidths[y.R]=this.charWidths[y.AN]=l,this.charWidths[y.R_H]=.45*l,this.charWidths[y.B]=this.charWidths[y.RLE]=0,this.currentRow=null)},h.prototype.setShowInvisibles=function(l){this.showInvisibles=l,this.currentRow=null},h.prototype.setEolChar=function(l){this.EOL=l},h.prototype.setContentWidth=function(l){this.contentWidth=l},h.prototype.isRtlLine=function(l){return!!this.$isRtl||(l!=null?this.session.getLine(l).charAt(0)==this.RLE:this.isRtlDir)},h.prototype.setRtlDirection=function(l,n){for(var o=l.getCursorPosition(),i=l.selection.getSelectionAnchor().row;i<=o.row;i++)n||l.session.getLine(i).charAt(0)!==l.session.$bidiHandler.RLE?n&&l.session.getLine(i).charAt(0)!==l.session.$bidiHandler.RLE&&l.session.doc.insert({column:0,row:i},l.session.$bidiHandler.RLE):l.session.doc.removeInLine(i,0,1)},h.prototype.getPosLeft=function(l){l-=this.wrapIndent;var n=this.line.charAt(0)===this.RLE?1:0,o=n<l?this.session.getOverwrite()?l:l-1:n,i=y.getVisualFromLogicalIdx(o,this.bidiMap),a=this.bidiMap.bidiLevels,r=0;!this.session.getOverwrite()&&l<=n&&a[i]%2!=0&&i++;for(var e=0;e<i;e++)r+=this.charWidths[a[e]];return!this.session.getOverwrite()&&n<l&&a[i]%2==0&&(r+=this.charWidths[a[i]]),this.wrapIndent&&(r+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset),this.isRtlDir&&(r+=this.rtlLineOffset),r},h.prototype.getSelections=function(l,n){var o,i=this.bidiMap,a=i.bidiLevels,r=[],e=0,t=Math.min(l,n)-this.wrapIndent,s=Math.max(l,n)-this.wrapIndent,c=!1,p=!1,g=0;this.wrapIndent&&(e+=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);for(var b,w=0;w<a.length;w++)b=i.logicalFromVisual[w],o=a[w],(c=t<=b&&b<s)&&!p?g=e:!c&&p&&r.push({left:g,width:e-g}),e+=this.charWidths[o],p=c;if(c&&w===a.length&&r.push({left:g,width:e-g}),this.isRtlDir)for(var E=0;E<r.length;E++)r[E].left+=this.rtlLineOffset;return r},h.prototype.offsetToCol=function(o){this.isRtlDir&&(o-=this.rtlLineOffset);var n=0,o=Math.max(o,0),i=0,a=0,r=this.bidiMap.bidiLevels,e=this.charWidths[r[a]];for(this.wrapIndent&&(o-=this.isRtlDir?-1*this.wrapOffset:this.wrapOffset);i+e/2<o;){if(i+=e,a===r.length-1){e=0;break}e=this.charWidths[r[++a]]}return(n=0<a&&r[a-1]%2!=0&&r[a]%2==0?(o<i&&a--,this.bidiMap.logicalFromVisual[a]):0<a&&r[a-1]%2==0&&r[a]%2!=0?1+(i<o?this.bidiMap.logicalFromVisual[a]:this.bidiMap.logicalFromVisual[a-1]):this.isRtlDir&&a===r.length-1&&e===0&&r[a-1]%2==0||!this.isRtlDir&&a===0&&r[a]%2!=0?1+this.bidiMap.logicalFromVisual[a]:(0<a&&r[a-1]%2!=0&&e!==0&&a--,this.bidiMap.logicalFromVisual[a]))===0&&this.isRtlDir&&n++,n+this.wrapIndent},f.BidiHandler=h}),ace.define("ace/selection",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/range"],function(l,f,R){var y=l("./lib/oop"),C=l("./lib/lang"),d=l("./lib/event_emitter").EventEmitter,h=l("./range").Range,l=(n.prototype.isEmpty=function(){return this.$isEmpty||this.anchor.row==this.lead.row&&this.anchor.column==this.lead.column},n.prototype.isMultiLine=function(){return!this.$isEmpty&&this.anchor.row!=this.cursor.row},n.prototype.getCursor=function(){return this.lead.getPosition()},n.prototype.setAnchor=function(o,i){this.$isEmpty=!1,this.anchor.setPosition(o,i)},n.prototype.getAnchor=function(){return this.$isEmpty?this.getSelectionLead():this.anchor.getPosition()},n.prototype.getSelectionLead=function(){return this.lead.getPosition()},n.prototype.isBackwards=function(){var o=this.anchor,i=this.lead;return o.row>i.row||o.row==i.row&&o.column>i.column},n.prototype.getRange=function(){var o=this.anchor,i=this.lead;return this.$isEmpty?h.fromPoints(i,i):this.isBackwards()?h.fromPoints(i,o):h.fromPoints(o,i)},n.prototype.clearSelection=function(){this.$isEmpty||(this.$isEmpty=!0,this._emit("changeSelection"))},n.prototype.selectAll=function(){this.$setSelection(0,0,Number.MAX_VALUE,Number.MAX_VALUE)},n.prototype.setRange=function(o,r){var a=r?o.end:o.start,r=r?o.start:o.end;this.$setSelection(a.row,a.column,r.row,r.column)},n.prototype.$setSelection=function(o,i,a,r){var e,t;!this.$silent&&(e=this.$isEmpty,t=this.inMultiSelectMode,this.$silent=!0,this.$cursorChanged=this.$anchorChanged=!1,this.anchor.setPosition(o,i),this.cursor.setPosition(a,r),this.$isEmpty=!h.comparePoints(this.anchor,this.cursor),this.$silent=!1,this.$cursorChanged&&this._emit("changeCursor"),this.$cursorChanged||this.$anchorChanged||e!=this.$isEmpty||t)&&this._emit("changeSelection")},n.prototype.$moveSelection=function(o){var i=this.lead;this.$isEmpty&&this.setSelectionAnchor(i.row,i.column),o.call(this)},n.prototype.selectTo=function(o,i){this.$moveSelection(function(){this.moveCursorTo(o,i)})},n.prototype.selectToPosition=function(o){this.$moveSelection(function(){this.moveCursorToPosition(o)})},n.prototype.moveTo=function(o,i){this.clearSelection(),this.moveCursorTo(o,i)},n.prototype.moveToPosition=function(o){this.clearSelection(),this.moveCursorToPosition(o)},n.prototype.selectUp=function(){this.$moveSelection(this.moveCursorUp)},n.prototype.selectDown=function(){this.$moveSelection(this.moveCursorDown)},n.prototype.selectRight=function(){this.$moveSelection(this.moveCursorRight)},n.prototype.selectLeft=function(){this.$moveSelection(this.moveCursorLeft)},n.prototype.selectLineStart=function(){this.$moveSelection(this.moveCursorLineStart)},n.prototype.selectLineEnd=function(){this.$moveSelection(this.moveCursorLineEnd)},n.prototype.selectFileEnd=function(){this.$moveSelection(this.moveCursorFileEnd)},n.prototype.selectFileStart=function(){this.$moveSelection(this.moveCursorFileStart)},n.prototype.selectWordRight=function(){this.$moveSelection(this.moveCursorWordRight)},n.prototype.selectWordLeft=function(){this.$moveSelection(this.moveCursorWordLeft)},n.prototype.getWordRange=function(o,i){var a;return i===void 0&&(o=(a=o||this.lead).row,i=a.column),this.session.getWordRange(o,i)},n.prototype.selectWord=function(){this.setSelectionRange(this.getWordRange())},n.prototype.selectAWord=function(){var o=this.getCursor(),o=this.session.getAWordRange(o.row,o.column);this.setSelectionRange(o)},n.prototype.getLineRange=function(a,i){var a=typeof a=="number"?a:this.lead.row,r=this.session.getFoldLine(a),r=r?(a=r.start.row,r.end.row):a;return i===!0?new h(a,0,r,this.session.getLine(r).length):new h(a,0,r+1,0)},n.prototype.selectLine=function(){this.setSelectionRange(this.getLineRange())},n.prototype.moveCursorUp=function(){this.moveCursorBy(-1,0)},n.prototype.moveCursorDown=function(){this.moveCursorBy(1,0)},n.prototype.wouldMoveIntoSoftTab=function(o,i,a){var r=o.column,e=o.column+i;return a<0&&(r=o.column-i,e=o.column),this.session.isTabStop(o)&&this.doc.getLine(o.row).slice(r,e).split(" ").length-1==i},n.prototype.moveCursorLeft=function(){var o,i=this.lead.getPosition();(o=this.session.getFoldAt(i.row,i.column,-1))?this.moveCursorTo(o.start.row,o.start.column):i.column===0?0<i.row&&this.moveCursorTo(i.row-1,this.doc.getLine(i.row-1).length):(o=this.session.getTabSize(),this.wouldMoveIntoSoftTab(i,o,-1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,-o):this.moveCursorBy(0,-1))},n.prototype.moveCursorRight=function(){var o,i=this.lead.getPosition();(o=this.session.getFoldAt(i.row,i.column,1))?this.moveCursorTo(o.end.row,o.end.column):this.lead.column==this.doc.getLine(this.lead.row).length?this.lead.row<this.doc.getLength()-1&&this.moveCursorTo(this.lead.row+1,0):(o=this.session.getTabSize(),i=this.lead,this.wouldMoveIntoSoftTab(i,o,1)&&!this.session.getNavigateWithinSoftTabs()?this.moveCursorBy(0,o):this.moveCursorBy(0,1))},n.prototype.moveCursorLineStart=function(){var a=this.lead.row,o=this.lead.column,i=this.session.documentToScreenRow(a,o),i=this.session.screenToDocumentPosition(i,0),a=this.session.getDisplayLine(a,null,i.row,i.column).match(/^\s*/);a[0].length==o||this.session.$useEmacsStyleLineStart||(i.column+=a[0].length),this.moveCursorToPosition(i)},n.prototype.moveCursorLineEnd=function(){var o,i=this.lead,i=this.session.getDocumentLastRowColumnPosition(i.row,i.column);this.lead.column==i.column&&(o=this.session.getLine(i.row),i.column==o.length)&&0<(o=o.search(/\s+$/))&&(i.column=o),this.moveCursorTo(i.row,i.column)},n.prototype.moveCursorFileEnd=function(){var o=this.doc.getLength()-1,i=this.doc.getLine(o).length;this.moveCursorTo(o,i)},n.prototype.moveCursorFileStart=function(){this.moveCursorTo(0,0)},n.prototype.moveCursorLongWordRight=function(){var o=this.lead.row,i=this.lead.column,a=this.doc.getLine(o),r=a.substring(i),e=(this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.getFoldAt(o,i,1));e?this.moveCursorTo(e.end.row,e.end.column):(this.session.nonTokenRe.exec(r)&&(i+=this.session.nonTokenRe.lastIndex,this.session.nonTokenRe.lastIndex=0,r=a.substring(i)),i>=a.length?(this.moveCursorTo(o,a.length),this.moveCursorRight(),o<this.doc.getLength()-1&&this.moveCursorWordRight()):(this.session.tokenRe.exec(r)&&(i+=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(o,i)))},n.prototype.moveCursorLongWordLeft=function(){var o,i=this.lead.row,a=this.lead.column;(o=this.session.getFoldAt(i,a,-1))?this.moveCursorTo(o.start.row,o.start.column):((o=this.session.getFoldStringAt(i,a,-1))==null&&(o=this.doc.getLine(i).substring(0,a)),o=C.stringReverse(o),this.session.nonTokenRe.lastIndex=0,this.session.tokenRe.lastIndex=0,this.session.nonTokenRe.exec(o)&&(a-=this.session.nonTokenRe.lastIndex,o=o.slice(this.session.nonTokenRe.lastIndex),this.session.nonTokenRe.lastIndex=0),a<=0?(this.moveCursorTo(i,0),this.moveCursorLeft(),0<i&&this.moveCursorWordLeft()):(this.session.tokenRe.exec(o)&&(a-=this.session.tokenRe.lastIndex,this.session.tokenRe.lastIndex=0),this.moveCursorTo(i,a)))},n.prototype.$shortWordEndIndex=function(o){var i,a=0,r=/\s/,e=this.session.tokenRe;if(e.lastIndex=0,this.session.tokenRe.exec(o))a=this.session.tokenRe.lastIndex;else{for(;(i=o[a])&&r.test(i);)a++;if(a<1){for(e.lastIndex=0;(i=o[a])&&!e.test(i);)if(e.lastIndex=0,a++,r.test(i)){if(2<a){a--;break}for(;(i=o[a])&&r.test(i);)a++;if(2<a)break}}}return e.lastIndex=0,a},n.prototype.moveCursorShortWordRight=function(){var o=this.lead.row,i=this.lead.column,a=this.doc.getLine(o),r=a.substring(i),e=this.session.getFoldAt(o,i,1);if(e)return this.moveCursorTo(e.end.row,e.end.column);if(i==a.length){for(var t=this.doc.getLength();r=this.doc.getLine(++o),o<t&&/^\s*$/.test(r););/^\s+/.test(r)||(r=""),i=0}e=this.$shortWordEndIndex(r),this.moveCursorTo(o,i+e)},n.prototype.moveCursorShortWordLeft=function(){var o=this.lead.row,i=this.lead.column;if(r=this.session.getFoldAt(o,i,-1))return this.moveCursorTo(r.start.row,r.start.column);var a=this.session.getLine(o).substring(0,i);if(i===0){for(;a=this.doc.getLine(--o),0<o&&/^\s*$/.test(a););i=a.length,/\s+$/.test(a)||(a="")}var r=C.stringReverse(a),r=this.$shortWordEndIndex(r);return this.moveCursorTo(o,i-r)},n.prototype.moveCursorWordRight=function(){this.session.$selectLongWords?this.moveCursorLongWordRight():this.moveCursorShortWordRight()},n.prototype.moveCursorWordLeft=function(){this.session.$selectLongWords?this.moveCursorLongWordLeft():this.moveCursorShortWordLeft()},n.prototype.moveCursorBy=function(o,i){var a,r=this.session.documentToScreenPosition(this.lead.row,this.lead.column),e=(i===0&&(o!==0&&(this.session.$bidiHandler.isBidiRow(r.row,this.lead.row)?(a=this.session.$bidiHandler.getPosLeft(r.column),r.column=Math.round(a/this.session.$bidiHandler.charWidths[0])):a=r.column*this.session.$bidiHandler.charWidths[0]),this.$desiredColumn?r.column=this.$desiredColumn:this.$desiredColumn=r.column),o!=0&&this.session.lineWidgets&&this.session.lineWidgets[this.lead.row]&&(e=this.session.lineWidgets[this.lead.row],o<0?o-=e.rowsAbove||0:0<o&&(o+=e.rowCount-(e.rowsAbove||0))),this.session.screenToDocumentPosition(r.row+o,r.column,a));o!==0&&i===0&&e.row===this.lead.row&&(e.column,this.lead.column),this.moveCursorTo(e.row,e.column+i,i===0)},n.prototype.moveCursorToPosition=function(o){this.moveCursorTo(o.row,o.column)},n.prototype.moveCursorTo=function(o,i,a){var r=this.session.getFoldAt(o,i,1),r=(r&&(o=r.start.row,i=r.start.column),this.$keepDesiredColumnOnChange=!0,this.session.getLine(o));/[\uDC00-\uDFFF]/.test(r.charAt(i))&&r.charAt(i-1)&&(this.lead.row==o&&this.lead.column==i+1?i-=1:i+=1),this.lead.setPosition(o,i),this.$keepDesiredColumnOnChange=!1,a||(this.$desiredColumn=null)},n.prototype.moveCursorToScreen=function(o,i,a){o=this.session.screenToDocumentPosition(o,i),this.moveCursorTo(o.row,o.column,a)},n.prototype.detach=function(){this.lead.detach(),this.anchor.detach()},n.prototype.fromOrientedRange=function(o){this.setSelectionRange(o,o.cursor==o.start),this.$desiredColumn=o.desiredColumn||this.$desiredColumn},n.prototype.toOrientedRange=function(o){var i=this.getRange();return o?(o.start.column=i.start.column,o.start.row=i.start.row,o.end.column=i.end.column,o.end.row=i.end.row):o=i,o.cursor=this.isBackwards()?o.start:o.end,o.desiredColumn=this.$desiredColumn,o},n.prototype.getRangeOfMovements=function(o){var i=this.getCursor();try{o(this);var a=this.getCursor();return h.fromPoints(i,a)}catch{return h.fromPoints(i,i)}finally{this.moveCursorToPosition(i)}},n.prototype.toJSON=function(){var o;return this.rangeCount?o=this.ranges.map(function(i){var a=i.clone();return a.isBackwards=i.cursor==i.start,a}):(o=this.getRange()).isBackwards=this.isBackwards(),o},n.prototype.fromJSON=function(o){if(o.start==null){if(this.rangeList&&1<o.length){this.toSingleRange(o[0]);for(var i=o.length;i--;){var a=h.fromPoints(o[i].start,o[i].end);o[i].isBackwards&&(a.cursor=a.start),this.addRange(a,!0)}return}o=o[0]}this.rangeList&&this.toSingleRange(o),this.setSelectionRange(o,o.isBackwards)},n.prototype.isEqual=function(o){if((o.length||this.rangeCount)&&o.length!=this.rangeCount)return!1;if(!o.length||!this.ranges)return this.getRange().isEqual(o);for(var i=this.ranges.length;i--;)if(!this.ranges[i].isEqual(o[i]))return!1;return!0},n);function n(o){this.session=o,this.doc=o.getDocument(),this.clearSelection(),this.cursor=this.lead=this.doc.createAnchor(0,0),this.anchor=this.doc.createAnchor(0,0),this.$silent=!1;var i=this;this.cursor.on("change",function(a){i.$cursorChanged=!0,i.$silent||i._emit("changeCursor"),i.$isEmpty||i.$silent||i._emit("changeSelection"),i.$keepDesiredColumnOnChange||a.old.column==a.value.column||(i.$desiredColumn=null)}),this.anchor.on("change",function(){i.$anchorChanged=!0,i.$isEmpty||i.$silent||i._emit("changeSelection")})}l.prototype.setSelectionAnchor=l.prototype.setAnchor,l.prototype.getSelectionAnchor=l.prototype.getAnchor,l.prototype.setSelectionRange=l.prototype.setRange,y.implement(l.prototype,d),f.Selection=l}),ace.define("ace/tokenizer",["require","exports","module","ace/lib/report_error"],function(y,f,R){var y=y("./lib/report_error").reportError,C=2e3,d=(h.prototype.$setMaxTokenCount=function(l){C=0|l},h.prototype.$applyToken=function(l){var n=this.splitRegex.exec(l).slice(1),o=this.token.apply(this,n);if(typeof o=="string")return[{type:o,value:l}];for(var i=[],a=0,r=o.length;a<r;a++)n[a]&&(i[i.length]={type:o[a],value:n[a]});return i},h.prototype.$arrayTokens=function(l){if(!l)return[];var n=this.splitRegex.exec(l);if(!n)return"text";for(var o=[],i=this.tokenArray,a=0,r=i.length;a<r;a++)n[a+1]&&(o[o.length]={type:i[a],value:n[a+1]});return o},h.prototype.removeCapturingGroups=function(l){return l.replace(/\\.|\[(?:\\.|[^\\\]])*|\(\?[:=!<]|(\()/g,function(n,o){return o?"(?:":n})},h.prototype.createSplitterRegexp=function(l,n){var o,i,a;return(l=(l=l.indexOf("(?=")!=-1&&(o=0,i=!1,a={},l.replace(/(\\.)|(\((?:\?[=!])?)|(\))|([\[\]])/g,function(r,e,t,s,c,p){return i?i=c!="]":c?i=!0:s?(o==a.stack&&(a.end=p+1,a.stack=-1),o--):t&&(o++,t.length!=1)&&(a.stack=o,a.start=p),r}),a.end!=null)&&/^\)*$/.test(l.substr(a.end))?l.substring(0,a.start)+l.substr(a.end):l).charAt(0)!="^"?"^"+l:l).charAt(l.length-1)!="$"&&(l+="$"),new RegExp(l,(n||"").replace("g",""))},h.prototype.getLineTokens=function(l,n){n&&typeof n!="string"?(n=(o=n.slice(0))[0])==="#tmp"&&(o.shift(),n=o.shift()):o=[];for(var o,i,a=n||"start",r=(r=this.states[a])||this.states[a="start"],e=this.matchMappings[a],t=this.regExps[a],s=[],c=t.lastIndex=0,p=0,g={type:null,value:""};i=t.exec(l);){var b,w=e.defaultToken,E=null,W=i[0],B=t.lastIndex;B-W.length>c&&(b=l.substring(c,B-W.length),g.type==w?g.value+=b:(g.type&&s.push(g),g={type:w,value:b}));for(var O=0;O<i.length-2;O++)if(i[O+1]!==void 0){w=(E=r[e[O]]).onMatch?E.onMatch(W,a,o,l):E.token,E.next&&(a=typeof E.next=="string"?E.next:E.next(a,o),(r=this.states[a])||(this.reportError("state doesn't exist",a),r=this.states[a="start"]),e=this.matchMappings[a],(t=this.regExps[a]).lastIndex=c=B),E.consumeLineEnd&&(c=B);break}if(W){if(typeof w=="string")E&&E.merge===!1||g.type!==w?(g.type&&s.push(g),g={type:w,value:W}):g.value+=W;else if(w)for(g.type&&s.push(g),g={type:null,value:""},O=0;O<w.length;O++)s.push(w[O])}if(c==l.length)break;if(c=B,p++>C){for(p>2*l.length&&this.reportError("infinite loop with in ace tokenizer",{startState:n,line:l});c<l.length;)g.type&&s.push(g),g={value:l.substring(c,c+=500),type:"overflow"};a="start",o=[];break}}return g.type&&s.push(g),1<o.length&&o[0]!==a&&o.unshift("#tmp",a),{tokens:s,state:o.length?o:a}},h);function h(l){for(var n in this.states=l,this.regExps={},this.matchMappings={},this.states){for(var o=this.states[n],i=[],a=0,r=this.matchMappings[n]={defaultToken:"text"},e="g",t=[],s=0;s<o.length;s++){var c,p,g=o[s];g.defaultToken&&(r.defaultToken=g.defaultToken),g.caseInsensitive&&e.indexOf("i")===-1&&(e+="i"),g.unicode&&e.indexOf("u")===-1&&(e+="u"),g.regex==null||(g.regex instanceof RegExp&&(g.regex=g.regex.toString().slice(1,-1)),c=g.regex,p=new RegExp("(?:("+c+")|(.))").exec("a").length-2,Array.isArray(g.token)?g.token.length==1||p==1?g.token=g.token[0]:p-1!=g.token.length?(this.reportError("number of classes and regexp groups doesn't match",{rule:g,groupCount:p-1}),g.token=g.token[0]):(g.tokenArray=g.token,g.token=null,g.onMatch=this.$arrayTokens):typeof g.token!="function"||g.onMatch||(g.onMatch=1<p?this.$applyToken:g.token),1<p&&(c=/\\\d/.test(g.regex)?g.regex.replace(/\\([0-9]+)/g,function(b,w){return"\\"+(parseInt(w,10)+a+1)}):(p=1,this.removeCapturingGroups(g.regex)),g.splitRegex||typeof g.token=="string"||t.push(g)),r[a]=s,a+=p,i.push(c),g.onMatch)||(g.onMatch=null)}i.length||(r[0]=0,i.push("$")),t.forEach(function(b){b.splitRegex=this.createSplitterRegexp(b.regex,e)},this),this.regExps[n]=new RegExp("("+i.join(")|(")+")|($)",e)}}d.prototype.reportError=y,f.Tokenizer=d}),ace.define("ace/mode/text_highlight_rules",["require","exports","module","ace/lib/deep_copy"],function(A,f,R){function y(){this.$rules={start:[{token:"empty_line",regex:"^$"},{defaultToken:"text"}]}}var C=A("../lib/deep_copy").deepCopy;(function(){this.addRules=function(l,n){if(n)for(var o in l){for(var i=l[o],a=0;a<i.length;a++){var r=i[a];(r.next||r.onMatch)&&(typeof r.next=="string"&&r.next.indexOf(n)!==0&&(r.next=n+r.next),r.nextState)&&r.nextState.indexOf(n)!==0&&(r.nextState=n+r.nextState)}this.$rules[n+o]=i}else for(var o in l)this.$rules[o]=l[o]},this.getRules=function(){return this.$rules},this.embedRules=function(l,n,o,i,a){if(l=typeof l=="function"?new l().getRules():l,i)for(var r=0;r<i.length;r++)i[r]=n+i[r];else for(var e in i=[],l)i.push(n+e);if(this.addRules(l,n),o)for(var t=Array.prototype[a?"push":"unshift"],r=0;r<i.length;r++)t.apply(this.$rules[i[r]],C(o));this.$embeds||(this.$embeds=[]),this.$embeds.push(n)},this.getEmbeds=function(){return this.$embeds};function d(l,n){return l=="start"&&!n.length||n.unshift(this.nextState,l),this.nextState}function h(l,n){return n.shift(),n.shift()||"start"}this.normalizeRules=function(){var l=0,n=this.$rules;Object.keys(n).forEach(function o(i){var a=n[i];a.processed=!0;for(var r=0;r<a.length;r++){var e=a[r],t=null,s=(Array.isArray(e)&&(t=e,e={}),!e.regex&&e.start&&(e.regex=e.start,e.next||(e.next=[]),e.next.push({defaultToken:e.token},{token:e.token+".end",regex:e.end||e.start,next:"pop"}),e.token=e.token+".start",e.push=!0),e.next||e.push);if(s&&Array.isArray(s)?((p=e.stateName)||(typeof(p=e.token)!="string"&&(p=p[0]||""),n[p]&&(p+=l++)),n[p]=s,o(e.next=p)):s=="pop"&&(e.next=h),e.push&&(e.nextState=e.next||e.push,e.next=d,delete e.push),e.rules)for(var c in e.rules)n[c]?n[c].push&&n[c].push.apply(n[c],e.rules[c]):n[c]=e.rules[c];var p=typeof e=="string"?e:e.include;p&&(p==="$self"&&(p="start"),t=Array.isArray(p)?p.map(function(g){return n[g]}):n[p]),t&&(s=[r,1].concat(t),e.noEscape&&(s=s.filter(function(g){return!g.next})),a.splice.apply(a,s),r--),e.keywordMap&&(e.token=this.createKeywordMapper(e.keywordMap,e.defaultToken||"text",e.caseInsensitive),delete e.defaultToken)}},this)},this.createKeywordMapper=function(l,n,o,i){var a=Object.create(null);return this.$keywordList=[],Object.keys(l).forEach(function(r){for(var e=l[r].split(i||"|"),t=e.length;t--;){var s=e[t];this.$keywordList.push(s),o&&(s=s.toLowerCase()),a[s]=r}},this),l=null,o?function(r){return a[r.toLowerCase()]||n}:function(r){return a[r]||n}},this.getKeywords=function(){return this.$keywords}}).call(y.prototype),f.TextHighlightRules=y}),ace.define("ace/mode/behaviour",["require","exports","module"],function(A,f,R){function y(){this.$behaviours={}}(function(){this.add=function(C,d,h){switch(void 0){case this.$behaviours:this.$behaviours={};case this.$behaviours[C]:this.$behaviours[C]={}}this.$behaviours[C][d]=h},this.addBehaviours=function(C){for(var d in C)for(var h in C[d])this.add(d,h,C[d][h])},this.remove=function(C){this.$behaviours&&this.$behaviours[C]&&delete this.$behaviours[C]},this.inherit=function(C,d){C=(typeof C=="function"?new C:C).getBehaviours(d),this.addBehaviours(C)},this.getBehaviours=function(C){if(C){for(var d={},h=0;h<C.length;h++)this.$behaviours[C[h]]&&(d[C[h]]=this.$behaviours[C[h]]);return d}return this.$behaviours}}).call(y.prototype),f.Behaviour=y}),ace.define("ace/token_iterator",["require","exports","module","ace/range"],function(A,f,R){var y=A("./range").Range;function C(d,h,l){this.$session=d,this.$row=h,this.$rowTokens=d.getTokens(h),d=d.getTokenAt(h,l),this.$tokenIndex=d?d.index:-1}C.prototype.stepBackward=function(){for(--this.$tokenIndex;this.$tokenIndex<0;){if(--this.$row,this.$row<0)return this.$row=0,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=this.$rowTokens.length-1}return this.$rowTokens[this.$tokenIndex]},C.prototype.stepForward=function(){var d;for(this.$tokenIndex+=1;this.$tokenIndex>=this.$rowTokens.length;){if(this.$row+=1,d=d||this.$session.getLength(),this.$row>=d)return this.$row=d-1,null;this.$rowTokens=this.$session.getTokens(this.$row),this.$tokenIndex=0}return this.$rowTokens[this.$tokenIndex]},C.prototype.getCurrentToken=function(){return this.$rowTokens[this.$tokenIndex]},C.prototype.getCurrentTokenRow=function(){return this.$row},C.prototype.getCurrentTokenColumn=function(){var d=this.$rowTokens,h=this.$tokenIndex,l=d[h].start;if(l===void 0)for(l=0;0<h;)l+=d[--h].value.length;return l},C.prototype.getCurrentTokenPosition=function(){return{row:this.$row,column:this.getCurrentTokenColumn()}},C.prototype.getCurrentTokenRange=function(){var d=this.$rowTokens[this.$tokenIndex],h=this.getCurrentTokenColumn();return new y(this.$row,h,this.$row,h+d.value.length)},f.TokenIterator=C}),ace.define("ace/mode/behaviour/cstyle",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(A,f,R){function y(s){var c=-1;if((e=s.multiSelect&&(c=s.selection.index,e.rangeCount!=s.multiSelect.rangeCount)?{rangeCount:s.multiSelect.rangeCount}:e)[c])return h=e[c];h=e[c]={autoInsertedBrackets:0,autoInsertedRow:-1,autoInsertedLineEnd:"",maybeInsertedBrackets:0,maybeInsertedRow:-1,maybeInsertedLineStart:"",maybeInsertedLineEnd:""}}function C(s,c,p,g){var b=s.end.row-s.start.row;return{text:p+c+g,selection:[0,s.start.column+1,b,s.end.column+(b?0:1)]}}function d(s){s=s||{},this.add("braces","insertion",function(c,p,g,b,w){var E=g.getCursorPosition(),W=b.doc.getLine(E.row);if(w=="{")return y(g),O=g.getSelectionRange(),(x=b.doc.getTextRange(O))!==""&&x!=="{"&&g.getWrapBehavioursEnabled()?C(O,x,"{","}"):d.isSaneInsertion(g,b)?/[\]\}\)]/.test(W[E.column])||g.inMultiSelectMode||s.braces?(d.recordAutoInsert(g,b,"}"),{text:"{}",selection:[1,1]}):(d.recordMaybeInsert(g,b,"{"),{text:"{",selection:[1,1]}):void 0;if(w=="}"){y(g);var B=W.substring(E.column,E.column+1);if(B=="}"&&b.$findOpeningBracket("}",{column:E.column+1,row:E.row})!==null&&d.isAutoInsertedClosing(E,W,w))return d.popAutoInsertedClosing(),{text:"",selection:[1,1]}}else{if(w==`
`||w==`\r
`){y(g);var O="";if(d.isMaybeInsertedClosing(E,W)&&(O=i.stringRepeat("}",h.maybeInsertedBrackets),d.clearMaybeInsertedClosing()),(B=W.substring(E.column,E.column+1))==="}"){var x=b.findMatchingBracket({row:E.row,column:E.column+1},"}");if(!x)return null;var u=this.$getIndent(b.getLine(x.row))}else{if(!O)return void d.clearMaybeInsertedClosing();u=this.$getIndent(W)}return w=u+b.getTabString(),{text:`
`+w+`
`+u+O,selection:[1,w.length,1,w.length]}}d.clearMaybeInsertedClosing()}}),this.add("braces","deletion",function(c,p,g,b,w){var E=b.doc.getTextRange(w);if(!w.isMultiLine()&&E=="{"){if(y(g),b.doc.getLine(w.start.row).substring(w.end.column,w.end.column+1)=="}")return w.end.column++,w;h.maybeInsertedBrackets--}}),this.add("parens","insertion",function(c,p,g,b,w){if(w=="(")return y(g),E=g.getSelectionRange(),(W=b.doc.getTextRange(E))!==""&&g.getWrapBehavioursEnabled()?C(E,W,"(",")"):d.isSaneInsertion(g,b)?(d.recordAutoInsert(g,b,")"),{text:"()",selection:[1,1]}):void 0;if(w==")"){y(g);var E=g.getCursorPosition(),W=b.doc.getLine(E.row),g=W.substring(E.column,E.column+1);if(g==")"&&b.$findOpeningBracket(")",{column:E.column+1,row:E.row})!==null&&d.isAutoInsertedClosing(E,W,w))return d.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("parens","deletion",function(c,p,g,b,w){var E=b.doc.getTextRange(w);if(!w.isMultiLine()&&E=="("&&(y(g),b.doc.getLine(w.start.row).substring(w.start.column+1,w.start.column+2)==")"))return w.end.column++,w}),this.add("brackets","insertion",function(c,p,g,b,w){if(w=="[")return y(g),E=g.getSelectionRange(),(W=b.doc.getTextRange(E))!==""&&g.getWrapBehavioursEnabled()?C(E,W,"[","]"):d.isSaneInsertion(g,b)?(d.recordAutoInsert(g,b,"]"),{text:"[]",selection:[1,1]}):void 0;if(w=="]"){y(g);var E=g.getCursorPosition(),W=b.doc.getLine(E.row),g=W.substring(E.column,E.column+1);if(g=="]"&&b.$findOpeningBracket("]",{column:E.column+1,row:E.row})!==null&&d.isAutoInsertedClosing(E,W,w))return d.popAutoInsertedClosing(),{text:"",selection:[1,1]}}}),this.add("brackets","deletion",function(c,p,g,b,w){var E=b.doc.getTextRange(w);if(!w.isMultiLine()&&E=="["&&(y(g),b.doc.getLine(w.start.row).substring(w.start.column+1,w.start.column+2)=="]"))return w.end.column++,w}),this.add("string_dquotes","insertion",function(c,p,g,b,w){var E=b.$mode.$quotes||t;if(w.length==1&&E[w]&&(!this.lineCommentStart||this.lineCommentStart.indexOf(w)==-1)){y(g);var W=g.getSelectionRange(),B=b.doc.getTextRange(W);if(!(B===""||B.length==1&&E[B])&&g.getWrapBehavioursEnabled())return C(W,B,w,w);if(!B){var E=g.getCursorPosition(),W=b.doc.getLine(E.row),B=W.substring(E.column-1,E.column),g=W.substring(E.column,E.column+1),u=b.getTokenAt(E.row,E.column),O=b.getTokenAt(E.row,E.column+1);if(B=="\\"&&u&&/escape/.test(u.type))return null;var x,u=u&&/string|escape/.test(u.type),_=!O||/string|escape/.test(O.type);if(g==w)(x=u!==_)&&/string\.end/.test(O.type)&&(x=!1);else{if(u&&!_||u&&_||(O=b.$mode.tokenRe,u=(O.lastIndex=0,O.test(B)),_=(O.lastIndex=0,O.test(g)),b=b.$mode.$pairQuotesAfter,!(b&&b[w]&&b[w].test(B))&&u||_)||g&&!/[\s;,.})\]\\]/.test(g)||(b=W[E.column-2],B==w&&(b==w||O.test(b))))return null;x=!0}return{text:x?w+w:"",selection:[1,1]}}}}),this.add("string_dquotes","deletion",function(c,p,g,b,w){var E=b.$mode.$quotes||t,W=b.doc.getTextRange(w);if(!w.isMultiLine()&&E.hasOwnProperty(W)&&(y(g),b.doc.getLine(w.start.row).substring(w.start.column+1,w.start.column+2)==W))return w.end.column++,w}),s.closeDocComment!==!1&&this.add("doc comment end","insertion",function(c,p,g,b,w){var E;if(c==="doc-start"&&(w===`
`||w===`\r
`)&&g.selection.isEmpty())return c=g.getCursorPosition(),g=b.doc.getLine(c.row),b=b.doc.getLine(c.row+1),E=this.$getIndent(g),/\s*\*/.test(b)?/^\s*\*/.test(g)?{text:w+E+"* ",selection:[1,3+E.length,1,3+E.length]}:{text:w+E+" * ",selection:[1,3+E.length,1,3+E.length]}:/\/\*\*/.test(g.substring(0,c.column))?{text:w+E+" * "+w+" "+E+"*/",selection:[1,4+E.length,1,4+E.length]}:void 0})}var h,l=A("../../lib/oop"),n=A("../behaviour").Behaviour,o=A("../../token_iterator").TokenIterator,i=A("../../lib/lang"),a=["text","paren.rparen","rparen","paren","punctuation.operator"],r=["text","paren.rparen","rparen","paren","punctuation.operator","comment"],e={},t={'"':'"',"'":"'"};d.isSaneInsertion=function(s,c){var p=s.getCursorPosition(),g=new o(c,p.row,p.column);if(!this.$matchTokenType(g.getCurrentToken()||"text",a)){if(/[)}\]]/.test(s.session.getLine(p.row)[p.column]))return!0;if(s=new o(c,p.row,p.column+1),!this.$matchTokenType(s.getCurrentToken()||"text",a))return!1}return g.stepForward(),g.getCurrentTokenRow()!==p.row||this.$matchTokenType(g.getCurrentToken()||"text",r)},d.$matchTokenType=function(s,c){return-1<c.indexOf(s.type||s)},d.recordAutoInsert=function(s,c,p){s=s.getCursorPosition(),c=c.doc.getLine(s.row),this.isAutoInsertedClosing(s,c,h.autoInsertedLineEnd[0])||(h.autoInsertedBrackets=0),h.autoInsertedRow=s.row,h.autoInsertedLineEnd=p+c.substr(s.column),h.autoInsertedBrackets++},d.recordMaybeInsert=function(s,c,p){s=s.getCursorPosition(),c=c.doc.getLine(s.row),this.isMaybeInsertedClosing(s,c)||(h.maybeInsertedBrackets=0),h.maybeInsertedRow=s.row,h.maybeInsertedLineStart=c.substr(0,s.column)+p,h.maybeInsertedLineEnd=c.substr(s.column),h.maybeInsertedBrackets++},d.isAutoInsertedClosing=function(s,c,p){return 0<h.autoInsertedBrackets&&s.row===h.autoInsertedRow&&p===h.autoInsertedLineEnd[0]&&c.substr(s.column)===h.autoInsertedLineEnd},d.isMaybeInsertedClosing=function(s,c){return 0<h.maybeInsertedBrackets&&s.row===h.maybeInsertedRow&&c.substr(s.column)===h.maybeInsertedLineEnd&&c.substr(0,s.column)==h.maybeInsertedLineStart},d.popAutoInsertedClosing=function(){h.autoInsertedLineEnd=h.autoInsertedLineEnd.substr(1),h.autoInsertedBrackets--},d.clearMaybeInsertedClosing=function(){h&&(h.maybeInsertedBrackets=0,h.maybeInsertedRow=-1)},l.inherits(d,n),f.CstyleBehaviour=d}),ace.define("ace/unicode",["require","exports","module"],function(A,f,R){for(var y=[48,9,8,25,5,0,2,25,48,0,11,0,5,0,6,22,2,30,2,457,5,11,15,4,8,0,2,0,18,116,2,1,3,3,9,0,2,2,2,0,2,19,2,82,2,138,2,4,3,155,12,37,3,0,8,38,10,44,2,0,2,1,2,1,2,0,9,26,6,2,30,10,7,61,2,9,5,101,2,7,3,9,2,18,3,0,17,58,3,100,15,53,5,0,6,45,211,57,3,18,2,5,3,11,3,9,2,1,7,6,2,2,2,7,3,1,3,21,2,6,2,0,4,3,3,8,3,1,3,3,9,0,5,1,2,4,3,11,16,2,2,5,5,1,3,21,2,6,2,1,2,1,2,1,3,0,2,4,5,1,3,2,4,0,8,3,2,0,8,15,12,2,2,8,2,2,2,21,2,6,2,1,2,4,3,9,2,2,2,2,3,0,16,3,3,9,18,2,2,7,3,1,3,21,2,6,2,1,2,4,3,8,3,1,3,2,9,1,5,1,2,4,3,9,2,0,17,1,2,5,4,2,2,3,4,1,2,0,2,1,4,1,4,2,4,11,5,4,4,2,2,3,3,0,7,0,15,9,18,2,2,7,2,2,2,22,2,9,2,4,4,7,2,2,2,3,8,1,2,1,7,3,3,9,19,1,2,7,2,2,2,22,2,9,2,4,3,8,2,2,2,3,8,1,8,0,2,3,3,9,19,1,2,7,2,2,2,22,2,15,4,7,2,2,2,3,10,0,9,3,3,9,11,5,3,1,2,17,4,23,2,8,2,0,3,6,4,0,5,5,2,0,2,7,19,1,14,57,6,14,2,9,40,1,2,0,3,1,2,0,3,0,7,3,2,6,2,2,2,0,2,0,3,1,2,12,2,2,3,4,2,0,2,5,3,9,3,1,35,0,24,1,7,9,12,0,2,0,2,0,5,9,2,35,5,19,2,5,5,7,2,35,10,0,58,73,7,77,3,37,11,42,2,0,4,328,2,3,3,6,2,0,2,3,3,40,2,3,3,32,2,3,3,6,2,0,2,3,3,14,2,56,2,3,3,66,5,0,33,15,17,84,13,619,3,16,2,25,6,74,22,12,2,6,12,20,12,19,13,12,2,2,2,1,13,51,3,29,4,0,5,1,3,9,34,2,3,9,7,87,9,42,6,69,11,28,4,11,5,11,11,39,3,4,12,43,5,25,7,10,38,27,5,62,2,28,3,10,7,9,14,0,89,75,5,9,18,8,13,42,4,11,71,55,9,9,4,48,83,2,2,30,14,230,23,280,3,5,3,37,3,5,3,7,2,0,2,0,2,0,2,30,3,52,2,6,2,0,4,2,2,6,4,3,3,5,5,12,6,2,2,6,67,1,20,0,29,0,14,0,17,4,60,12,5,0,4,11,18,0,5,0,3,9,2,0,4,4,7,0,2,0,2,0,2,3,2,10,3,3,6,4,5,0,53,1,2684,46,2,46,2,132,7,6,15,37,11,53,10,0,17,22,10,6,2,6,2,6,2,6,2,6,2,6,2,6,2,6,2,31,48,0,470,1,36,5,2,4,6,1,5,85,3,1,3,2,2,89,2,3,6,40,4,93,18,23,57,15,513,6581,75,20939,53,1164,68,45,3,268,4,27,21,31,3,13,13,1,2,24,9,69,11,1,38,8,3,102,3,1,111,44,25,51,13,68,12,9,7,23,4,0,5,45,3,35,13,28,4,64,15,10,39,54,10,13,3,9,7,22,4,1,5,66,25,2,227,42,2,1,3,9,7,11171,13,22,5,48,8453,301,3,61,3,105,39,6,13,4,6,11,2,12,2,4,2,0,2,1,2,1,2,107,34,362,19,63,3,53,41,11,5,15,17,6,13,1,25,2,33,4,2,134,20,9,8,25,5,0,2,25,12,88,4,5,3,5,3,5,3,2],C=0,d=[],h=0;h<y.length;h+=2)d.push(C+=y[h]),y[h+1]&&d.push(45,C+=y[h+1]);f.wordChars=String.fromCharCode.apply(null,d)}),ace.define("ace/mode/text",["require","exports","module","ace/config","ace/tokenizer","ace/mode/text_highlight_rules","ace/mode/behaviour/cstyle","ace/unicode","ace/lib/lang","ace/token_iterator","ace/range"],function(A,f,R){function y(){this.HighlightRules=h}var C=A("../config"),d=A("../tokenizer").Tokenizer,h=A("./text_highlight_rules").TextHighlightRules,l=A("./behaviour/cstyle").CstyleBehaviour,n=A("../unicode"),o=A("../lib/lang"),i=A("../token_iterator").TokenIterator,a=A("../range").Range;(function(){this.$defaultBehaviour=new l,this.tokenRe=new RegExp("^["+n.wordChars+"\\$_]+","g"),this.nonTokenRe=new RegExp("^(?:[^"+n.wordChars+"\\$_]|\\s])+","g"),this.getTokenizer=function(){return this.$tokenizer||(this.$highlightRules=this.$highlightRules||new this.HighlightRules(this.$highlightRuleConfig),this.$tokenizer=new d(this.$highlightRules.getRules())),this.$tokenizer},this.lineCommentStart="",this.blockComment="",this.toggleCommentLines=function(r,e,t,s){var c=e.doc,p=!0,g=!0,b=1/0,w=e.getTabSize(),E=!1;if(this.lineCommentStart){_=Array.isArray(this.lineCommentStart)?($=this.lineCommentStart.map(o.escapeRegExp).join("|"),this.lineCommentStart[0]):($=o.escapeRegExp(this.lineCommentStart),this.lineCommentStart),$=new RegExp("^(\\s*)(?:"+$+") ?"),E=e.getUseSoftTabs();var W=function(Q,K){var ne,T,F=Q.match($);F&&(ne=F[1].length,T=F[0].length,u(Q,ne,T)||F[0][T-1]!=" "||T--,c.removeInLine(K,ne,T))},B=_+" ",O=function(Q,K){p&&!/\S/.test(Q)||(u(Q,b,b)?c.insertInLine({row:K,column:b},B):c.insertInLine({row:K,column:b},_))},x=function(Q,K){return $.test(Q)},u=function(Q,K,ne){for(var T=0;K--&&Q.charAt(K)==" ";)T++;if(T%w!=0)return!1;for(T=0;Q.charAt(ne++)==" ";)T++;return 2<w?T%w!=w-1:T%w==0}}else{if(!this.blockComment)return!1;var _=this.blockComment.start,v=this.blockComment.end,$=new RegExp("^(\\s*)(?:"+o.escapeRegExp(_)+")"),P=new RegExp("(?:"+o.escapeRegExp(v)+")\\s*$"),O=function(T,F){x(T,F)||p&&!/\S/.test(T)||(c.insertInLine({row:F,column:T.length},v),c.insertInLine({row:F,column:b},_))},W=function(T,F){var V;(V=T.match(P))&&c.removeInLine(F,T.length-V[0].length,T.length),(V=T.match($))&&c.removeInLine(F,V[1].length,V[0].length)},x=function(T,F){if($.test(T))return!0;for(var V=e.getTokens(F),I=0;I<V.length;I++)if(V[I].type==="comment")return!0}}function M(Q){for(var K=t;K<=s;K++)Q(c.getLine(K),K)}var X=1/0;M(function(Q,K){var ne=Q.search(/\S/);ne!==-1?(ne<b&&(b=ne),g&&!x(Q,K)&&(g=!1)):X>Q.length&&(X=Q.length)}),b==1/0&&(b=X,g=p=!1),E&&b%w!=0&&(b=Math.floor(b/w)*w),M(g?W:O)},this.toggleBlockComment=function(r,e,t,s){var c=this.blockComment;if(c){!c.start&&c[0]&&(c=c[0]);var p,g,b=(O=new i(e,s.row,s.column)).getCurrentToken(),w=(e.selection,e.selection.toOrientedRange());if(b&&/comment/.test(b.type)){for(;b&&/comment/.test(b.type);){if((x=b.value.indexOf(c.start))!=-1){var E=O.getCurrentTokenRow(),W=O.getCurrentTokenColumn()+x,B=new a(E,W,E,W+c.start.length);break}b=O.stepBackward()}for(var O,x,b=(O=new i(e,s.row,s.column)).getCurrentToken();b&&/comment/.test(b.type);){if((x=b.value.indexOf(c.end))!=-1){var E=O.getCurrentTokenRow(),W=O.getCurrentTokenColumn()+x,u=new a(E,W,E,W+c.end.length);break}b=O.stepForward()}u&&e.remove(u),B&&(e.remove(B),p=B.start.row,g=-c.start.length)}else g=c.start.length,p=t.start.row,e.insert(t.end,c.end),e.insert(t.start,c.start);w.start.row==p&&(w.start.column+=g),w.end.row==p&&(w.end.column+=g),e.selection.fromOrientedRange(w)}},this.getNextLineIndent=function(r,e,t){return this.$getIndent(e)},this.checkOutdent=function(r,e,t){return!1},this.autoOutdent=function(r,e,t){},this.$getIndent=function(r){return r.match(/^\s*/)[0]},this.createWorker=function(r){return null},this.createModeDelegates=function(r){for(var e in this.$embeds=[],this.$modes={},r){var t,s,c;r[e]&&(s=(t=r[e]).prototype.$id,(c=C.$modes[s])||(C.$modes[s]=c=new t),C.$modes[e]||(C.$modes[e]=c),this.$embeds.push(e),this.$modes[e]=c)}for(var p=["toggleBlockComment","toggleCommentLines","getNextLineIndent","checkOutdent","autoOutdent","transformAction","getCompletions"],e=0;e<p.length;e++)(function(b){var w=p[e],E=b[w];b[p[e]]=function(){return this.$delegator(w,arguments,E)}})(this)},this.$delegator=function(r,e,t){var s=e[0]||"start";if(typeof s!="string"){if(Array.isArray(s[2])){var c=s[2][s[2].length-1];if(g=this.$modes[c])return g[r].apply(g,[s[1]].concat([].slice.call(e,1)))}s=s[0]||"start"}for(var p=0;p<this.$embeds.length;p++)if(this.$modes[this.$embeds[p]]){var g,b=s.split(this.$embeds[p]);if(!b[0]&&b[1])return e[0]=b[1],(g=this.$modes[this.$embeds[p]])[r].apply(g,e)}return c=t.apply(this,e),t?c:void 0},this.transformAction=function(r,e,t,s,c){if(this.$behaviour){var p,g=this.$behaviour.getBehaviours();for(p in g)if(g[p][e]){var b=g[p][e].apply(this,arguments);if(b)return b}}},this.getKeywords=function(r){if(!this.completionKeywords){var e=this.$tokenizer.rules,t=[];for(g in e)for(var s=e[g],c=0,p=s.length;c<p;c++)if(typeof s[c].token=="string")/keyword|support|storage/.test(s[c].token)&&t.push(s[c].regex);else if(typeof s[c].token=="object")for(var g,b=0,w=s[c].token.length;b<w;b++)/keyword|support|storage/.test(s[c].token[b])&&(g=s[c].regex.match(/\(.+?\)/g)[b],t.push(g.substr(1,g.length-2)));this.completionKeywords=t}return r?t.concat(this.$keywordList||[]):this.$keywordList},this.$createKeywordList=function(){return this.$highlightRules||this.getTokenizer(),this.$keywordList=this.$highlightRules.$keywordList||[]},this.getCompletions=function(r,e,t,s){return(this.$keywordList||this.$createKeywordList()).map(function(c){return{name:c,value:c,score:0,meta:"keyword"}})},this.$id="ace/mode/text"}).call(y.prototype),f.Mode=y}),ace.define("ace/apply_delta",["require","exports","module"],function(A,f,R){f.applyDelta=function(y,C,d){var h=C.start.row,l=C.start.column,n=y[h]||"";switch(C.action){case"insert":C.lines.length===1?y[h]=n.substring(0,l)+C.lines[0]+n.substring(l):(o=[h,1].concat(C.lines),y.splice.apply(y,o),y[h]=n.substring(0,l)+y[h],y[h+C.lines.length-1]+=n.substring(l));break;case"remove":var o=C.end.column,i=C.end.row;h===i?y[h]=n.substring(0,l)+n.substring(o):y.splice(h,i-h+1,n.substring(0,l)+y[i].substring(o))}}}),ace.define("ace/anchor",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(C,f,R){var y=C("./lib/oop"),C=C("./lib/event_emitter").EventEmitter,d=(h.prototype.getPosition=function(){return this.$clipPositionToDocument(this.row,this.column)},h.prototype.getDocument=function(){return this.document},h.prototype.onChange=function(n){n.start.row==n.end.row&&n.start.row!=this.row||n.start.row>this.row||(n=function(o,i,a){var s=o.action=="insert",r=(s?1:-1)*(o.end.row-o.start.row),e=(s?1:-1)*(o.end.column-o.start.column),t=o.start,s=s?t:o.end;return l(i,t,a)?{row:i.row,column:i.column}:l(s,i,!a)?{row:i.row+r,column:i.column+(i.row==s.row?e:0)}:{row:t.row,column:t.column}}(n,{row:this.row,column:this.column},this.$insertRight),this.setPosition(n.row,n.column,!0))},h.prototype.setPosition=function(n,o,i){i=i?{row:n,column:o}:this.$clipPositionToDocument(n,o),this.row==i.row&&this.column==i.column||(n={row:this.row,column:this.column},this.row=i.row,this.column=i.column,this._signal("change",{old:n,value:i}))},h.prototype.detach=function(){this.document.off("change",this.$onChange)},h.prototype.attach=function(n){this.document=n||this.document,this.document.on("change",this.$onChange)},h.prototype.$clipPositionToDocument=function(n,o){var i={};return n>=this.document.getLength()?(i.row=Math.max(0,this.document.getLength()-1),i.column=this.document.getLine(i.row).length):n<0?(i.row=0,i.column=0):(i.row=n,i.column=Math.min(this.document.getLine(i.row).length,Math.max(0,o))),o<0&&(i.column=0),i},h);function h(n,o,i){this.$onChange=this.onChange.bind(this),this.attach(n),i===void 0?this.setPosition(o.row,o.column):this.setPosition(o,i)}function l(n,o,i){return i=i?n.column<=o.column:n.column<o.column,n.row<o.row||n.row==o.row&&i}d.prototype.$insertRight=!1,y.implement(d.prototype,C),f.Anchor=d}),ace.define("ace/document",["require","exports","module","ace/lib/oop","ace/apply_delta","ace/lib/event_emitter","ace/range","ace/anchor"],function(n,f,R){var y=n("./lib/oop"),C=n("./apply_delta").applyDelta,d=n("./lib/event_emitter").EventEmitter,h=n("./range").Range,l=n("./anchor").Anchor,n=(o.prototype.setValue=function(i){var a=this.getLength()-1;this.remove(new h(0,0,a,this.getLine(a).length)),this.insert({row:0,column:0},i||"")},o.prototype.getValue=function(){return this.getAllLines().join(this.getNewLineCharacter())},o.prototype.createAnchor=function(i,a){return new l(this,i,a)},o.prototype.$detectNewLine=function(i){i=i.match(/^.*?(\r\n|\r|\n)/m),this.$autoNewLine=i?i[1]:`
`,this._signal("changeNewLineMode")},o.prototype.getNewLineCharacter=function(){switch(this.$newLineMode){case"windows":return`\r
`;case"unix":return`
`;default:return this.$autoNewLine||`
`}},o.prototype.setNewLineMode=function(i){this.$newLineMode!==i&&(this.$newLineMode=i,this._signal("changeNewLineMode"))},o.prototype.getNewLineMode=function(){return this.$newLineMode},o.prototype.isNewLine=function(i){return i==`\r
`||i=="\r"||i==`
`},o.prototype.getLine=function(i){return this.$lines[i]||""},o.prototype.getLines=function(i,a){return this.$lines.slice(i,a+1)},o.prototype.getAllLines=function(){return this.getLines(0,this.getLength())},o.prototype.getLength=function(){return this.$lines.length},o.prototype.getTextRange=function(i){return this.getLinesForRange(i).join(this.getNewLineCharacter())},o.prototype.getLinesForRange=function(i){var a,r;return i.start.row===i.end.row?a=[this.getLine(i.start.row).substring(i.start.column,i.end.column)]:((a=this.getLines(i.start.row,i.end.row))[0]=(a[0]||"").substring(i.start.column),r=a.length-1,i.end.row-i.start.row==r&&(a[r]=a[r].substring(0,i.end.column))),a},o.prototype.insertLines=function(i,a){return console.warn("Use of document.insertLines is deprecated. Use the insertFullLines method instead."),this.insertFullLines(i,a)},o.prototype.removeLines=function(i,a){return console.warn("Use of document.removeLines is deprecated. Use the removeFullLines method instead."),this.removeFullLines(i,a)},o.prototype.insertNewLine=function(i){return console.warn("Use of document.insertNewLine is deprecated. Use insertMergedLines(position, ['', '']) instead."),this.insertMergedLines(i,["",""])},o.prototype.insert=function(i,a){return this.getLength()<=1&&this.$detectNewLine(a),this.insertMergedLines(i,this.$split(a))},o.prototype.insertInLine=function(e,a){var r=this.clippedPos(e.row,e.column),e=this.pos(e.row,e.column+a.length);return this.applyDelta({start:r,end:e,action:"insert",lines:[a]},!0),this.clonePos(e)},o.prototype.clippedPos=function(i,a){var r=this.getLength(),r=(i===void 0?i=r:i<0?i=0:r<=i&&(i=r-1,a=void 0),this.getLine(i));return a==null&&(a=r.length),{row:i,column:a=Math.min(Math.max(a,0),r.length)}},o.prototype.clonePos=function(i){return{row:i.row,column:i.column}},o.prototype.pos=function(i,a){return{row:i,column:a}},o.prototype.$clipPosition=function(i){var a=this.getLength();return i.row>=a?(i.row=Math.max(0,a-1),i.column=this.getLine(a-1).length):(i.row=Math.max(0,i.row),i.column=Math.min(Math.max(i.column,0),this.getLine(i.row).length)),i},o.prototype.insertFullLines=function(i,a){var r=0,r=(i=Math.min(Math.max(i,0),this.getLength()))<this.getLength()?(a=a.concat([""]),0):(a=[""].concat(a),this.$lines[--i].length);this.insertMergedLines({row:i,column:r},a)},o.prototype.insertMergedLines=function(r,a){var r=this.clippedPos(r.row,r.column),e={row:r.row+a.length-1,column:(a.length==1?r.column:0)+a[a.length-1].length};return this.applyDelta({start:r,end:e,action:"insert",lines:a}),this.clonePos(e)},o.prototype.remove=function(r){var a=this.clippedPos(r.start.row,r.start.column),r=this.clippedPos(r.end.row,r.end.column);return this.applyDelta({start:a,end:r,action:"remove",lines:this.getLinesForRange({start:a,end:r})}),this.clonePos(a)},o.prototype.removeInLine=function(i,a,r){return a=this.clippedPos(i,a),i=this.clippedPos(i,r),this.applyDelta({start:a,end:i,action:"remove",lines:this.getLinesForRange({start:a,end:i})},!0),this.clonePos(a)},o.prototype.removeFullLines=function(i,a){i=Math.min(Math.max(0,i),this.getLength()-1);var s=(a=Math.min(Math.max(0,a),this.getLength()-1))==this.getLength()-1&&0<i,e=a<this.getLength()-1,t=s?i-1:i,s=s?this.getLine(t).length:0,r=e?a+1:a,e=e?0:this.getLine(r).length,t=new h(t,s,r,e),s=this.$lines.slice(i,a+1);return this.applyDelta({start:t.start,end:t.end,action:"remove",lines:this.getLinesForRange(t)}),s},o.prototype.removeNewLine=function(i){i<this.getLength()-1&&0<=i&&this.applyDelta({start:this.pos(i,this.getLine(i).length),end:this.pos(i+1,0),action:"remove",lines:["",""]})},o.prototype.replace=function(i,a){return i instanceof h||(i=h.fromPoints(i.start,i.end)),a.length===0&&i.isEmpty()?i.start:a==this.getTextRange(i)?i.end:(this.remove(i),a?this.insert(i.start,a):i.start)},o.prototype.applyDeltas=function(i){for(var a=0;a<i.length;a++)this.applyDelta(i[a])},o.prototype.revertDeltas=function(i){for(var a=i.length-1;0<=a;a--)this.revertDelta(i[a])},o.prototype.applyDelta=function(i,a){var r=i.action=="insert";(r?i.lines.length<=1&&!i.lines[0]:!h.comparePoints(i.start,i.end))||(r&&2e4<i.lines.length?this.$splitAndapplyLargeDelta(i,2e4):(C(this.$lines,i,a),this._signal("change",i)))},o.prototype.$safeApplyDelta=function(i){var a=this.$lines.length;(i.action=="remove"&&i.start.row<a&&i.end.row<a||i.action=="insert"&&i.start.row<=a)&&this.applyDelta(i)},o.prototype.$splitAndapplyLargeDelta=function(i,a){for(var r=i.lines,e=r.length-a+1,t=i.start.row,s=i.start.column,c=0,p=0;c<e;c=p){p+=a-1;var g=r.slice(c,p);g.push(""),this.applyDelta({start:this.pos(t+c,s),end:this.pos(t+p,s=0),action:i.action,lines:g},!0)}i.lines=r.slice(c),i.start.row=t+c,i.start.column=s,this.applyDelta(i,!0)},o.prototype.revertDelta=function(i){this.$safeApplyDelta({start:this.clonePos(i.start),end:this.clonePos(i.end),action:i.action=="insert"?"remove":"insert",lines:i.lines.slice()})},o.prototype.indexToPosition=function(i,a){for(var r=this.$lines||this.getAllLines(),e=this.getNewLineCharacter().length,t=a||0,s=r.length;t<s;t++)if((i-=r[t].length+e)<0)return{row:t,column:i+r[t].length+e};return{row:s-1,column:i+r[s-1].length+e}},o.prototype.positionToIndex=function(i,a){for(var r=this.$lines||this.getAllLines(),e=this.getNewLineCharacter().length,t=0,s=Math.min(i.row,r.length),c=a||0;c<s;++c)t+=r[c].length+e;return t+i.column},o.prototype.$split=function(i){return i.split(/\r\n|\r|\n/)},o);function o(i){this.$lines=[""],i.length===0?this.$lines=[""]:Array.isArray(i)?this.insertMergedLines({row:0,column:0},i):this.insert({row:0,column:0},i)}n.prototype.$autoNewLine="",n.prototype.$newLineMode="auto",y.implement(n.prototype,d),f.Document=n}),ace.define("ace/background_tokenizer",["require","exports","module","ace/lib/oop","ace/lib/event_emitter"],function(C,f,R){var y=C("./lib/oop"),C=C("./lib/event_emitter").EventEmitter,d=(h.prototype.setTokenizer=function(l){this.tokenizer=l,this.lines=[],this.states=[],this.start(0)},h.prototype.setDocument=function(l){this.doc=l,this.lines=[],this.states=[],this.stop()},h.prototype.fireUpdateEvent=function(l,n){this._signal("update",{data:{first:l,last:n}})},h.prototype.start=function(l){this.currentLine=Math.min(l||0,this.currentLine,this.doc.getLength()),this.lines.splice(this.currentLine,this.lines.length),this.states.splice(this.currentLine,this.states.length),this.stop(),this.running=setTimeout(this.$worker,700)},h.prototype.scheduleStart=function(){this.running||(this.running=setTimeout(this.$worker,700))},h.prototype.$updateOnChange=function(l){var n=l.start.row,o=l.end.row-n;o==0?this.lines[n]=null:l.action=="remove"?(this.lines.splice(n,1+o,null),this.states.splice(n,1+o,null)):((l=Array(1+o)).unshift(n,1),this.lines.splice.apply(this.lines,l),this.states.splice.apply(this.states,l)),this.currentLine=Math.min(n,this.currentLine,this.doc.getLength()),this.stop()},h.prototype.stop=function(){this.running&&clearTimeout(this.running),this.running=!1},h.prototype.getTokens=function(l){return this.lines[l]||this.$tokenizeRow(l)},h.prototype.getState=function(l){return this.currentLine==l&&this.$tokenizeRow(l),this.states[l]||"start"},h.prototype.$tokenizeRow=function(l){var o=this.doc.getLine(l),n=this.states[l-1],o=this.tokenizer.getLineTokens(o,n,l);return this.states[l]+""!=o.state+""?(this.states[l]=o.state,this.lines[l+1]=null,this.currentLine>l+1&&(this.currentLine=l+1)):this.currentLine==l&&(this.currentLine=l+1),this.lines[l]=o.tokens},h.prototype.cleanup=function(){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.removeAllListeners()},h);function h(l,n){this.running=!1,this.lines=[],this.states=[],this.currentLine=0,this.tokenizer=l;var o=this;this.$worker=function(){if(o.running){for(var i=new Date,a=o.currentLine,r=-1,e=o.doc,t=a;o.lines[a];)a++;var s=e.getLength(),c=0;for(o.running=!1;a<s;){for(o.$tokenizeRow(a),r=a;a++,o.lines[a];);if(++c%5==0&&20<new Date-i){o.running=setTimeout(o.$worker,20);break}}o.currentLine=a,t<=(r=r==-1?a:r)&&o.fireUpdateEvent(t,r)}}}y.implement(d.prototype,C),f.BackgroundTokenizer=d}),ace.define("ace/search_highlight",["require","exports","module","ace/lib/lang","ace/range"],function(d,f,R){var y=d("./lib/lang"),C=d("./range").Range,d=(h.prototype.setRegexp=function(l){this.regExp+""!=l+""&&(this.regExp=l,this.cache=[])},h.prototype.update=function(l,n,o,i){if(this.regExp)for(var a=i.firstRow,r=i.lastRow,e={},t=a;t<=r;t++){var s=this.cache[t];s==null&&(s=(s=(s=y.getMatchOffsets(o.getLine(t),this.regExp)).length>this.MAX_RANGES?s.slice(0,this.MAX_RANGES):s).map(function(b){return new C(t,b.offset,t,b.offset+b.length)}),this.cache[t]=s.length?s:"");for(var c=s.length;c--;){var p=s[c].toScreenRange(o),g=p.toString();e[g]||(e[g]=!0,n.drawSingleLineMarker(l,p,this.clazz,i))}}},h);function h(l,n,o){o===void 0&&(o="text"),this.setRegexp(l),this.clazz=n,this.type=o}d.prototype.MAX_RANGES=500,f.SearchHighlight=d}),ace.define("ace/undomanager",["require","exports","module","ace/range"],function(A,f,R){C.prototype.addSession=function(t){this.$session=t},C.prototype.add=function(t,s,c){this.$fromUndo||t!=this.$lastDelta&&(this.$keepRedoStack||(this.$redoStack.length=0),s!==!1&&this.lastDeltas||(this.lastDeltas=[],(s=this.$undoStack.length)>this.$undoDepth-1&&this.$undoStack.splice(0,s-this.$undoDepth+1),this.$undoStack.push(this.lastDeltas),t.id=this.$rev=++this.$maxRev),t.action!="remove"&&t.action!="insert"||(this.$lastDelta=t),this.lastDeltas.push(t))},C.prototype.addSelection=function(t,s){this.selections.push({value:t,rev:s||this.$rev})},C.prototype.startNewGroup=function(){return this.lastDeltas=null,this.$rev},C.prototype.markIgnored=function(t,s){s==null&&(s=this.$rev+1);for(var c=this.$undoStack,p=c.length;p--;){var g=c[p][0];if(g.id<=t)break;g.id<s&&(g.ignore=!0)}this.lastDeltas=null},C.prototype.getSelection=function(t,s){for(var c=this.selections,p=c.length;p--;){var g=c[p];if(g.rev<t)return g=s?c[p+1]:g}},C.prototype.getRevision=function(){return this.$rev},C.prototype.getDeltas=function(t,s){s==null&&(s=this.$rev+1);for(var c=this.$undoStack,p=null,g=0,b=c.length;b--;){var w=c[b][0];if(w.id<s&&!p&&(p=b+1),w.id<=t){g=b+1;break}}return c.slice(g,p)},C.prototype.getChangedRanges=function(t,s){s==null&&this.$rev},C.prototype.getChangedLines=function(t,s){s==null&&this.$rev},C.prototype.undo=function(t,s){this.lastDeltas=null;var c,p=this.$undoStack;if(function(g,b){for(var w=b;w--;){var E=g[w];if(E&&!E[0].ignore){for(;w<b-1;){var W=function(B,O){for(var x=B.length;x--;)for(var u=0;u<O.length;u++)if(!i(B[x],O[u])){for(;x<B.length;){for(;u--;)i(O[u],B[x]);u=O.length,x++}return[B,O]}return B.selectionBefore=O.selectionBefore=B.selectionAfter=O.selectionAfter=null,[O,B]}(g[w],g[w+1]);g[w]=W[0],g[w+1]=W[1],w++}return 1}}}(p,p.length))return t=t||this.$session,this.$redoStackBaseRev!==this.$rev&&this.$redoStack.length&&(this.$redoStack=[]),this.$fromUndo=!0,c=null,(p=p.pop())&&(c=t.undoChanges(p,s),this.$redoStack.push(p),this.$syncRev()),this.$fromUndo=!1,c},C.prototype.redo=function(t,s){if(this.lastDeltas=null,t=t||this.$session,this.$fromUndo=!0,this.$redoStackBaseRev!=this.$rev){for(var _=this.getDeltas(this.$redoStackBaseRev,this.$rev+1),c=this.$redoStack,p=_,g=0;g<p.length;g++)for(var b=p[g],w=0;w<b.length;w++){E=void 0,W=void 0,B=void 0,O=void 0,x=void 0,u=void 0;var E=c,W=b[w];W=function(P){return{start:l(P.start),end:l(P.end),action:P.action,lines:P.lines.slice()}}(W);for(var B=E.length;B--;){for(var O=E[B],x=0;x<O.length;x++){var u=function(P,M){var X,Q,K=P.action=="insert",ne=M.action=="insert";if(K&&ne)h(P.start,M.start)<0?a(M,P,1):a(P,M,1);else if(K&&!ne)0<=h(P.start,M.end)?a(P,M,-1):(h(P.start,M.start)<=0||a(P,d.fromPoints(M.start,P.start),-1),a(M,P,1));else if(!K&&ne)0<=h(M.start,P.end)?a(M,P,-1):(h(M.start,P.start)<=0||a(M,d.fromPoints(P.start,M.start),-1),a(P,M,1));else if(!K&&!ne)if(0<=h(M.start,P.end))a(M,P,-1);else{if(!(h(M.end,P.start)<=0))return h(P.start,M.start)<0&&(P=e(X=P,M.start)),0<h(P.end,M.end)&&(Q=e(P,M.end)),r(M.end,P.start,P.end,-1),Q&&!X&&(P.lines=Q.lines,P.start=Q.start,P.end=Q.end,Q=P),[M,X,Q].filter(Boolean);a(P,M,-1)}return[M,P]}(O[x],W);W=u[0],u.length!=2&&(u[2]?(O.splice(x+1,1,u[1],u[2]),x++):u[1]||(O.splice(x,1),x--))}O.length||E.splice(B,1)}}this.$redoStackBaseRev=this.$rev,this.$redoStack.forEach(function($){$[0].id=++this.$maxRev},this)}var _=this.$redoStack.pop(),v=null;return _&&(v=t.redoChanges(_,s),this.$undoStack.push(_),this.$syncRev()),this.$fromUndo=!1,v},C.prototype.$syncRev=function(){var t=this.$undoStack,t=t[t.length-1],t=t&&t[0].id||0;this.$redoStackBaseRev=t,this.$rev=t},C.prototype.reset=function(){this.lastDeltas=null,this.$lastDelta=null,this.$undoStack=[],this.$redoStack=[],this.$rev=0,this.mark=0,this.$redoStackBaseRev=this.$rev,this.selections=[]},C.prototype.canUndo=function(){return 0<this.$undoStack.length},C.prototype.canRedo=function(){return 0<this.$redoStack.length},C.prototype.bookmark=function(t){t==null&&(t=this.$rev),this.mark=t},C.prototype.isAtBookmark=function(){return this.$rev===this.mark},C.prototype.toJSON=function(){return{$redoStack:this.$redoStack,$undoStack:this.$undoStack}},C.prototype.fromJSON=function(t){this.reset(),this.$undoStack=t.$undoStack,this.$redoStack=t.$redoStack},C.prototype.$prettyPrint=function(t){return t?n(t):n(this.$undoStack)+`
---
`+n(this.$redoStack)};var y=C;function C(){this.$maxRev=0,this.$fromUndo=!1,this.$undoDepth=1/0,this.reset()}y.prototype.hasUndo=y.prototype.canUndo,y.prototype.hasRedo=y.prototype.canRedo,y.prototype.isClean=y.prototype.isAtBookmark,y.prototype.markClean=y.prototype.bookmark;var d=A("./range").Range,h=d.comparePoints;d.comparePoints;function l(t){return{row:t.row,column:t.column}}function n(t){var s;return t=t||this,Array.isArray(t)?t.map(n).join(`
`):(s="",t.action?(s=t.action=="insert"?"+":"-",s+="["+t.lines+"]"):t.value&&(s=Array.isArray(t.value)?t.value.map(o).join(`
`):o(t.value)),t.start&&(s+=o(t)),(t.id||t.rev)&&(s+="	("+(t.id||t.rev)+")"),s)}function o(t){return t.start.row+":"+t.start.column+"=>"+t.end.row+":"+t.end.column}function i(t,s){var c=t.action=="insert",p=s.action=="insert";if(c&&p)if(0<=h(s.start,t.end))a(s,t,-1);else{if(!(h(s.start,t.start)<=0))return;a(t,s,1)}else if(c&&!p)if(0<=h(s.start,t.end))a(s,t,-1);else{if(!(h(s.end,t.start)<=0))return;a(t,s,-1)}else if(!c&&p)if(0<=h(s.start,t.start))a(s,t,1);else{if(!(h(s.start,t.start)<=0))return;a(t,s,1)}else if(!c&&!p)if(0<=h(s.start,t.start))a(s,t,1);else{if(!(h(s.end,t.start)<=0))return;a(t,s,-1)}return 1}function a(t,s,c){r(t.start,s.start,s.end,c),r(t.end,s.start,s.end,c)}function r(t,s,c,p){t.row==(p==1?s:c).row&&(t.column+=p*(c.column-s.column)),t.row+=p*(c.row-s.row)}function e(t,s){var c=t.lines,p=t.end,b=(t.end=l(s),t.end.row-t.start.row),g=c.splice(b,c.length),b=b?s.column:s.column-t.start.column;return c.push(g[0].substring(0,b)),g[0]=g[0].substr(b),{start:l(s),end:p,lines:g,action:t.action}}f.UndoManager=y}),ace.define("ace/edit_session/fold_line",["require","exports","module","ace/range"],function(A,f,R){var y=A("../range").Range;function C(d,h){this.foldData=d,Array.isArray(h)?this.folds=h:h=this.folds=[h],d=h[h.length-1],this.range=new y(h[0].start.row,h[0].start.column,d.end.row,d.end.column),this.start=this.range.start,this.end=this.range.end,this.folds.forEach(function(l){l.setFoldLine(this)},this)}C.prototype.shiftRow=function(d){this.start.row+=d,this.end.row+=d,this.folds.forEach(function(h){h.start.row+=d,h.end.row+=d})},C.prototype.addFold=function(d){if(d.sameRow){if(d.start.row<this.startRow||d.endRow>this.endRow)throw new Error("Can't add a fold to this FoldLine as it has no connection");this.folds.push(d),this.folds.sort(function(h,l){return-h.range.compareEnd(l.start.row,l.start.column)}),0<this.range.compareEnd(d.start.row,d.start.column)?(this.end.row=d.end.row,this.end.column=d.end.column):this.range.compareStart(d.end.row,d.end.column)<0&&(this.start.row=d.start.row,this.start.column=d.start.column)}else if(d.start.row==this.end.row)this.folds.push(d),this.end.row=d.end.row,this.end.column=d.end.column;else{if(d.end.row!=this.start.row)throw new Error("Trying to add fold to FoldRow that doesn't have a matching row");this.folds.unshift(d),this.start.row=d.start.row,this.start.column=d.start.column}d.foldLine=this},C.prototype.containsRow=function(d){return d>=this.start.row&&d<=this.end.row},C.prototype.walk=function(d,h,l){var n,o,i=0,a=this.folds,r=!0;h==null&&(h=this.end.row,l=this.end.column);for(var e=0;e<a.length;e++){if((o=(n=a[e]).range.compareStart(h,l))==-1)return void d(null,h,l,i,r);if(!d(null,n.start.row,n.start.column,i,r)&&d(n.placeholder,n.start.row,n.start.column,i)||o===0)return;r=!n.sameRow,i=n.end.column}d(null,h,l,i,r)},C.prototype.getNextFoldTo=function(d,h){for(var l,n,o=0;o<this.folds.length;o++){if((n=(l=this.folds[o]).range.compareEnd(d,h))==-1)return{fold:l,kind:"after"};if(n===0)return{fold:l,kind:"inside"}}return null},C.prototype.addRemoveChars=function(d,h,l){var n,o=this.getNextFoldTo(d,h);if(o){if(n=o.fold,o.kind=="inside"&&n.start.column!=h&&n.start.row!=d)window.console&&window.console.log(d,h,n);else if(n.start.row==d){var i,a=(i=this.folds).indexOf(n);for(a===0&&(this.start.column+=l);a<i.length;a++){if((n=i[a]).start.column+=l,!n.sameRow)return;n.end.column+=l}this.end.column+=l}}},C.prototype.split=function(o,h){var l,n,o=this.getNextFoldTo(o,h);return o&&o.kind!="inside"?(h=o.fold,o=this.folds,l=this.foldData,h=o.indexOf(h),n=o[h-1],this.end.row=n.end.row,this.end.column=n.end.column,n=new C(l,o=o.splice(h,o.length-h)),l.splice(l.indexOf(this)+1,0,n),n):null},C.prototype.merge=function(d){for(var h=d.folds,l=0;l<h.length;l++)this.addFold(h[l]);var n=this.foldData;n.splice(n.indexOf(d),1)},C.prototype.toString=function(){var d=[this.range.toString()+": ["];return this.folds.forEach(function(h){d.push("  "+h.toString())}),d.push("]"),d.join(`
`)},C.prototype.idxToPosition=function(d){for(var h=0,l=0;l<this.folds.length;l++){var n=this.folds[l];if((d-=n.start.column-h)<0)return{row:n.start.row,column:n.start.column+d};if((d-=n.placeholder.length)<0)return n.start;h=n.end.column}return{row:this.end.row,column:this.end.column+d}},f.FoldLine=C}),ace.define("ace/range_list",["require","exports","module","ace/range"],function(C,f,R){var y=C("./range").Range.comparePoints,C=(d.prototype.pointIndex=function(h,l,n){for(var o=this.ranges,i=n||0;i<o.length;i++){var a=o[i],r=y(h,a.end);if(!(0<r))return a=y(h,a.start),r===0?l&&a!==0?-i-2:i:0<a||a===0&&!l?i:-i-1}return-i-1},d.prototype.add=function(h){var n=!h.isEmpty(),l=this.pointIndex(h.start,n),n=this.pointIndex(h.end,n,l=l<0?-l-1:l);return n<0?n=-n-1:n++,this.ranges.splice(l,n-l,h)},d.prototype.addList=function(h){for(var l=[],n=h.length;n--;)l.push.apply(l,this.add(h[n]));return l},d.prototype.substractPoint=function(h){if(h=this.pointIndex(h),0<=h)return this.ranges.splice(h,1)},d.prototype.merge=function(){for(var h=[],l=this.ranges,n=(l=l.sort(function(r,e){return y(r.start,e.start)}))[0],o=1;o<l.length;o++){var i=n,n=l[o],a=y(i.end,n.start);a<0||(a!=0||i.isEmpty()||n.isEmpty())&&(y(i.end,n.end)<0&&(i.end.row=n.end.row,i.end.column=n.end.column),l.splice(o,1),h.push(n),n=i,o--)}return this.ranges=l,h},d.prototype.contains=function(h,l){return 0<=this.pointIndex({row:h,column:l})},d.prototype.containsPoint=function(h){return 0<=this.pointIndex(h)},d.prototype.rangeAtPoint=function(h){if(h=this.pointIndex(h),0<=h)return this.ranges[h]},d.prototype.clipRows=function(h,l){var n=this.ranges;if(n[0].start.row>l||n[n.length-1].start.row<h)return[];for(var h=this.pointIndex({row:h,column:0}),o=this.pointIndex({row:l,column:0},h=h<0?-h-1:h),i=(o<0&&(o=-o-1),[]),a=h;a<o;a++)i.push(n[a]);return i},d.prototype.removeAll=function(){return this.ranges.splice(0,this.ranges.length)},d.prototype.attach=function(h){this.session&&this.detach(),this.session=h,this.onChange=this.$onChange.bind(this),this.session.on("change",this.onChange)},d.prototype.detach=function(){this.session&&(this.session.removeListener("change",this.onChange),this.session=null)},d.prototype.$onChange=function(h){for(var l=h.start,n=h.end,o=l.row,i=n.row,a=this.ranges,r=0,e=a.length;r<e&&!((c=a[r]).end.row>=o);r++);if(h.action=="insert")for(var t=i-o,s=-l.column+n.column;r<e&&!((c=a[r]).start.row>o);r++)c.start.row==o&&c.start.column>=l.column&&(c.start.column==l.column&&this.$bias<=0||(c.start.column+=s,c.start.row+=t)),c.end.row==o&&c.end.column>=l.column&&(c.end.column==l.column&&this.$bias<0||(c.end.column==l.column&&0<s&&r<e-1&&c.end.column>c.start.column&&c.end.column==a[r+1].start.column&&(c.end.column-=s),c.end.column+=s,c.end.row+=t));else for(var c,t=o-i,s=l.column-n.column;r<e&&!((c=a[r]).start.row>i);r++)c.end.row<i&&(o<c.end.row||o==c.end.row&&l.column<c.end.column)?(c.end.row=o,c.end.column=l.column):c.end.row==i?c.end.column<=n.column?(t||c.end.column>l.column)&&(c.end.column=l.column,c.end.row=l.row):(c.end.column+=s,c.end.row+=t):c.end.row>i&&(c.end.row+=t),c.start.row<i&&(o<c.start.row||o==c.start.row&&l.column<c.start.column)?(c.start.row=o,c.start.column=l.column):c.start.row==i?c.start.column<=n.column?(t||c.start.column>l.column)&&(c.start.column=l.column,c.start.row=l.row):(c.start.column+=s,c.start.row+=t):c.start.row>i&&(c.start.row+=t);if(t!=0&&r<e)for(;r<e;r++)(c=a[r]).start.row+=t,c.end.row+=t},d);function d(){this.ranges=[],this.$bias=1}C.prototype.comparePoints=y,f.RangeList=C}),ace.define("ace/edit_session/fold",["require","exports","module","ace/range_list"],function(d,f,R){var y,C,h=this&&this.__extends||(y=function(i,a){return(y=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(r,e){r.__proto__=e}:function(r,e){for(var t in e)Object.prototype.hasOwnProperty.call(e,t)&&(r[t]=e[t])}))(i,a)},function(i,a){if(typeof a!="function"&&a!==null)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");function r(){this.constructor=i}y(i,a),i.prototype=a===null?Object.create(a):(r.prototype=a.prototype,new r)}),d=d("../range_list").RangeList,h=(h(l,C=d),l.prototype.toString=function(){return'"'+this.placeholder+'" '+this.range.toString()},l.prototype.setFoldLine=function(i){this.foldLine=i,this.subFolds.forEach(function(a){a.setFoldLine(i)})},l.prototype.clone=function(){var i=new l(this.range.clone(),this.placeholder);return this.subFolds.forEach(function(a){i.subFolds.push(a.clone())}),i.collapseChildren=this.collapseChildren,i},l.prototype.addSubFold=function(i){if(!this.range.isEqual(i)){s=i,c=this.start,n(s.start,c),n(s.end,c);for(var a=i.start.row,r=i.start.column,e=0,t=-1;e<this.subFolds.length&&(t=this.subFolds[e].range.compare(a,r))==1;e++);var s=this.subFolds[e],c=0;if(t==0){if(s.range.containsRange(i))return s.addSubFold(i);c=1}for(var a=i.range.end.row,r=i.range.end.column,p=e,t=-1;p<this.subFolds.length&&(t=this.subFolds[p].range.compare(a,r))==1;p++);t==0&&p++;for(var g=this.subFolds.splice(e,p-e,i),b=t==0?g.length-1:g.length,w=c;w<b;w++)i.addSubFold(g[w]);return i.setFoldLine(this.foldLine),i}},l.prototype.restoreRange=function(i){return i=i,a=this.start,o(i.start,a),void o(i.end,a);var a},l);function l(i,a){var r=C.call(this)||this;return r.foldLine=null,r.placeholder=a,r.range=i,r.start=i.start,r.end=i.end,r.sameRow=i.start.row==i.end.row,r.subFolds=r.ranges=[],r}function n(i,a){i.row-=a.row,i.row==0&&(i.column-=a.column)}function o(i,a){i.row==0&&(i.column+=a.column),i.row+=a.row}f.Fold=h}),ace.define("ace/edit_session/folding",["require","exports","module","ace/range","ace/edit_session/fold_line","ace/edit_session/fold","ace/token_iterator","ace/mouse/mouse_event"],function(A,f,R){var y=A("../range").Range,C=A("./fold_line").FoldLine,d=A("./fold").Fold,h=A("../token_iterator").TokenIterator,l=A("../mouse/mouse_event").MouseEvent;f.Folding=function(){this.getFoldAt=function(n,o,i){var a=this.getFoldLine(n);if(!a)return null;for(var r=a.folds,e=0;e<r.length;e++){var t=r[e].range;if(t.contains(n,o)&&(i!=1||!t.isEnd(n,o)||t.isEmpty())&&(i!=-1||!t.isStart(n,o)||t.isEmpty()))return r[e]}},this.getFoldsInRange=function(n){var o=n.start,i=n.end,a=this.$foldData,r=[];o.column+=1,--i.column;for(var e=0;e<a.length;e++){var t=a[e].range.compareRange(n);if(t!=2){if(t==-2)break;for(var s=a[e].folds,c=0;c<s.length;c++){var p=s[c];if((t=p.range.compareRange(n))==-2)break;if(t!=2){if(t==42)break;r.push(p)}}}}return--o.column,i.column+=1,r},this.getFoldsInRangeList=function(n){var o;return Array.isArray(n)?(o=[],n.forEach(function(i){o=o.concat(this.getFoldsInRange(i))},this)):o=this.getFoldsInRange(n),o},this.getAllFolds=function(){for(var n=[],o=this.$foldData,i=0;i<o.length;i++)for(var a=0;a<o[i].folds.length;a++)n.push(o[i].folds[a]);return n},this.getFoldStringAt=function(n,o,i,a){if(!(a=a||this.getFoldLine(n)))return null;for(var r,e={end:{column:0}},t=0;t<a.folds.length;t++){var s,c=(s=a.folds[t]).range.compareEnd(n,o);if(c==-1){r=this.getLine(s.start.row).substring(e.end.column,s.start.column);break}if(c===0)return null;e=s}return r=r||this.getLine(s.start.row).substring(e.end.column),i==-1?r.substring(0,o-e.end.column):i==1?r.substring(o-e.end.column):r},this.getFoldLine=function(n,o){var i=this.$foldData,a=0;for((a=o?i.indexOf(o):a)==-1&&(a=0);a<i.length;a++){var r=i[a];if(r.start.row<=n&&r.end.row>=n)return r;if(r.end.row>n)return null}return null},this.getNextFoldLine=function(n,o){var i=this.$foldData,a=0;for((a=o?i.indexOf(o):a)==-1&&(a=0);a<i.length;a++){var r=i[a];if(r.end.row>=n)return r}return null},this.getFoldedRowCount=function(n,o){for(var i=this.$foldData,a=o-n+1,r=0;r<i.length;r++){var t=i[r],e=t.end.row,t=t.start.row;if(o<=e){t<o&&(n<=t?a-=o-t:a=0);break}n<=e&&(a-=n<=t?e-t:e-n+1)}return a},this.$addFoldLine=function(n){return this.$foldData.push(n),this.$foldData.sort(function(o,i){return o.start.row-i.start.row}),n},this.addFold=function(t,c){var i,a=this.$foldData,r=!1,e=(t instanceof d?i=t:(i=new d(c,t)).collapseChildren=c.collapseChildren,this.$clipRangeToDocument(i.range),i.start.row),t=i.start.column,s=i.end.row,c=i.end.column,p=this.getFoldAt(e,t,1),g=this.getFoldAt(s,c,-1);if(p&&g==p)return p.addSubFold(i);p&&!p.range.isStart(e,t)&&this.removeFold(p),g&&!g.range.isEnd(s,c)&&this.removeFold(g),t=this.getFoldsInRange(i.range),0<t.length&&(this.removeFolds(t),i.collapseChildren||t.forEach(function(W){i.addSubFold(W)}));for(var b=0;b<a.length;b++){var w=a[b];if(s==w.start.row){w.addFold(i),r=!0;break}if(e==w.end.row){if(w.addFold(i),r=!0,!i.sameRow){var E=a[b+1];if(E&&E.start.row==s){w.merge(E);break}}break}if(s<=w.start.row)break}return r||(w=this.$addFoldLine(new C(this.$foldData,i))),this.$useWrapMode?this.$updateWrapData(w.start.row,w.start.row):this.$updateRowLengthCache(w.start.row,w.start.row),this.$modified=!0,this._signal("changeFold",{data:i,action:"add"}),i},this.addFolds=function(n){n.forEach(function(o){this.addFold(o)},this)},this.removeFold=function(n){var o=n.foldLine,i=o.start.row,a=o.end.row,r=this.$foldData,e=o.folds;e.length==1?r.splice(r.indexOf(o),1):o.range.isEnd(n.end.row,n.end.column)?(e.pop(),o.end.row=e[e.length-1].end.row,o.end.column=e[e.length-1].end.column):o.range.isStart(n.start.row,n.start.column)?(e.shift(),o.start.row=e[0].start.row,o.start.column=e[0].start.column):n.sameRow?e.splice(e.indexOf(n),1):((e=(r=o.split(n.start.row,n.start.column)).folds).shift(),r.start.row=e[0].start.row,r.start.column=e[0].start.column),this.$updating||(this.$useWrapMode?this.$updateWrapData(i,a):this.$updateRowLengthCache(i,a)),this.$modified=!0,this._signal("changeFold",{data:n,action:"remove"})},this.removeFolds=function(n){for(var o=[],i=0;i<n.length;i++)o.push(n[i]);o.forEach(function(a){this.removeFold(a)},this),this.$modified=!0},this.expandFold=function(n){this.removeFold(n),n.subFolds.forEach(function(o){n.restoreRange(o),this.addFold(o)},this),0<n.collapseChildren&&this.foldAll(n.start.row+1,n.end.row,n.collapseChildren-1),n.subFolds=[]},this.expandFolds=function(n){n.forEach(function(o){this.expandFold(o)},this)},this.unfold=function(n,o){var i;if(n==null)i=new y(0,0,this.getLength(),0),o==null&&(o=!0);else if(typeof n=="number")i=new y(n,0,n,this.getLine(n).length);else if("row"in n)i=y.fromPoints(n,n);else{if(Array.isArray(n))return a=[],n.forEach(function(r){a=a.concat(this.unfold(r))},this),a;i=n}for(var a,n=a=this.getFoldsInRangeList(i);a.length==1&&y.comparePoints(a[0].start,i.start)<0&&0<y.comparePoints(a[0].end,i.end);)this.expandFolds(a),a=this.getFoldsInRangeList(i);if(o!=0?this.removeFolds(a):this.expandFolds(a),n.length)return n},this.isRowFolded=function(n,o){return!!this.getFoldLine(n,o)},this.getRowFoldEnd=function(n,o){return o=this.getFoldLine(n,o),o?o.end.row:n},this.getRowFoldStart=function(n,o){return o=this.getFoldLine(n,o),o?o.start.row:n},this.getFoldDisplayLine=function(n,o,i,a,r){a==null&&(a=n.start.row),r==null&&(r=0),o==null&&(o=n.end.row),i==null&&(i=this.getLine(o).length);var e=this.doc,t="";return n.walk(function(s,c,p,g){if(!(c<a)){if(c==a){if(p<r)return;g=Math.max(r,g)}t+=s??e.getLine(c).substring(g,p)}},o,i),t},this.getDisplayLine=function(n,o,i,a){var r=this.getFoldLine(n);return r?this.getFoldDisplayLine(r,n,o,i,a):(r=this.doc.getLine(n)).substring(a||0,o||r.length)},this.$cloneFoldData=function(){var n=[];return n=this.$foldData.map(function(o){return o=o.folds.map(function(i){return i.clone()}),new C(n,o)})},this.toggleFold=function(n){var o=this.selection.getRange();if(o.isEmpty()){var i,a=o.start;if(i=this.getFoldAt(a.row,a.column))return void this.expandFold(i);(r=this.findMatchingBracket(a))?o.comparePoint(r)==1?o.end=r:(o.start=r,o.start.column++,o.end.column--):(r=this.findMatchingBracket({row:a.row,column:a.column+1}))?(o.comparePoint(r)==1?o.end=r:o.start=r,o.start.column++):o=this.getCommentFoldRange(a.row,a.column)||o}else{var r=this.getFoldsInRange(o);if(n&&r.length)return void this.expandFolds(r);r.length==1&&(i=r[0])}if((i=i||this.getFoldAt(o.start.row,o.start.column))&&i.range.toString()==o.toString())this.expandFold(i);else{if(a="...",!o.isMultiLine()){if((a=this.getTextRange(o)).length<4)return;a=a.trim().substring(0,2)+".."}this.addFold(a,o)}},this.getCommentFoldRange=function(n,o,i){var a=new h(this,n,o),r=a.getCurrentToken(),e=r&&r.type;if(r&&/^comment|string/.test(e)){(e=e.match(/comment|string/)[0])=="comment"&&(e+="|doc-start|\\.doc");var t=new RegExp(e),e=new y;if(i!=1){for(;(r=a.stepBackward())&&t.test(r.type)&&!/^comment.end/.test(r.type););r=a.stepForward()}if(e.start.row=a.getCurrentTokenRow(),e.start.column=a.getCurrentTokenColumn()+(/^comment.start/.test(r.type)?r.value.length:2),a=new h(this,n,o),i!=-1){var s=-1;do if(r=a.stepForward(),s==-1){var c=this.getState(a.$row);t.test(c)||(s=a.$row)}else if(a.$row>s)break;while(r&&t.test(r.type)&&!/^comment.start/.test(r.type));r=a.stepBackward()}else r=a.getCurrentToken();return e.end.row=a.getCurrentTokenRow(),e.end.column=a.getCurrentTokenColumn(),/^comment.end/.test(r.type)||(e.end.column+=r.value.length-2),e}},this.foldAll=function(n,o,i,a){i==null&&(i=1e5);var r=this.foldWidgets;if(r){o=o||this.getLength();for(var e,t=n=n||0;t<o;t++)r[t]==null&&(r[t]=this.getFoldWidget(t)),r[t]!="start"||a&&!a(t)||(e=this.getFoldWidgetRange(t))&&e.isMultiLine()&&e.end.row<=o&&e.start.row>=n&&(t=e.end.row,e.collapseChildren=i,this.addFold("...",e))}},this.foldToLevel=function(n){for(this.foldAll();0<n--;)this.unfold(null,!1)},this.foldAllComments=function(){var n=this;this.foldAll(null,null,null,function(o){for(var i=n.getTokens(o),a=0;a<i.length;a++){var r=i[a];if(r.type!="text"||!/^\s+$/.test(r.value))return!!/comment/.test(r.type)}})},this.$foldStyles={manual:1,markbegin:1,markbeginend:1},this.$foldStyle="markbegin",this.setFoldStyle=function(n){if(!this.$foldStyles[n])throw new Error("invalid fold style: "+n+"["+Object.keys(this.$foldStyles).join(", ")+"]");this.$foldStyle!=n&&((this.$foldStyle=n)=="manual"&&this.unfold(),n=this.$foldMode,this.$setFolding(null),this.$setFolding(n))},this.$setFolding=function(n){this.$foldMode!=n&&(this.$foldMode=n,this.off("change",this.$updateFoldWidgets),this.off("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets),this._signal("changeAnnotation"),n&&this.$foldStyle!="manual"?(this.foldWidgets=[],this.getFoldWidget=n.getFoldWidget.bind(n,this,this.$foldStyle),this.getFoldWidgetRange=n.getFoldWidgetRange.bind(n,this,this.$foldStyle),this.$updateFoldWidgets=this.updateFoldWidgets.bind(this),this.$tokenizerUpdateFoldWidgets=this.tokenizerUpdateFoldWidgets.bind(this),this.on("change",this.$updateFoldWidgets),this.on("tokenizerUpdate",this.$tokenizerUpdateFoldWidgets)):this.foldWidgets=null)},this.getParentFoldRangeData=function(n,o){var i=this.foldWidgets;if(!i||o&&i[n])return{};for(var a=n-1;0<=a;){var r=i[a];if((r=r??(i[a]=this.getFoldWidget(a)))=="start"){var e=this.getFoldWidgetRange(a),t=t||e;if(e&&e.end.row>=n)break}a--}return{range:a!==-1&&e,firstRange:t}},this.onFoldWidgetClick=function(n,o){var i={children:(o=o instanceof l?o.domEvent:o).shiftKey,all:o.ctrlKey||o.metaKey,siblings:o.altKey};this.$toggleFoldWidget(n,i)||(n=o.target||o.srcElement)&&/ace_fold-widget/.test(n.className)&&(n.className+=" ace_invalid")},this.$toggleFoldWidget=function(n,o){var i,a,r,e;if(this.getFoldWidget)return i=this.getFoldWidget(n),a=this.getLine(n),(a=this.getFoldAt(n,(i=i==="end"?-1:1)==-1?0:a.length,i))?(o.children||o.all?this.removeFold(a):this.expandFold(a),a):(i=this.getFoldWidgetRange(n,!0))&&!i.isMultiLine()&&(a=this.getFoldAt(i.start.row,i.start.column,1))&&i.isEqual(a.range)?(this.removeFold(a),a):(o.siblings?((a=this.getParentFoldRangeData(n)).range&&(r=a.range.start.row+1,e=a.range.end.row),this.foldAll(r,e,o.all?1e4:0)):o.children?(e=i?i.end.row:this.getLength(),this.foldAll(n+1,e,o.all?1e4:0)):i&&(o.all&&(i.collapseChildren=1e4),this.addFold("...",i)),i)},this.toggleFoldWidget=function(n){var o,i=this.selection.getCursor().row;i=this.getRowFoldStart(i),!this.$toggleFoldWidget(i,{})&&(o=(o=this.getParentFoldRangeData(i,!0)).range||o.firstRange)&&(i=o.start.row,(i=this.getFoldAt(i,this.getLine(i).length,1))?this.removeFold(i):this.addFold("...",o))},this.updateFoldWidgets=function(n){var o=n.start.row,i=n.end.row-o;i==0?this.foldWidgets[o]=null:n.action=="remove"?this.foldWidgets.splice(o,1+i,null):((n=Array(1+i)).unshift(o,1),this.foldWidgets.splice.apply(this.foldWidgets,n))},this.tokenizerUpdateFoldWidgets=function(n){n=n.data,n.first!=n.last&&this.foldWidgets.length>n.first&&this.foldWidgets.splice(n.first,this.foldWidgets.length)}}}),ace.define("ace/edit_session/bracket_match",["require","exports","module","ace/token_iterator","ace/range"],function(A,f,R){var y=A("../token_iterator").TokenIterator,C=A("../range").Range;f.BracketMatch=function(){this.findMatchingBracket=function(d,h){return d.column!=0&&(h=h||this.getLine(d.row).charAt(d.column-1))!=""&&(h=h.match(/([\(\[\{])|([\)\]\}])/))?h[1]?this.$findClosingBracket(h[1],d):this.$findOpeningBracket(h[2],d):null},this.getBracketRange=function(d){var h,l,n=this.getLine(d.row),o=!0,i=n.charAt(d.column-1),a=i&&i.match(/([\(\[\{])|([\)\]\}])/);if(a||(i=n.charAt(d.column),d={row:d.row,column:d.column+1},a=i&&i.match(/([\(\[\{])|([\)\]\}])/),o=!1),!a)return null;if(a[1]){if(!(l=this.$findClosingBracket(a[1],d)))return null;h=C.fromPoints(d,l),o||(h.end.column++,h.start.column--),h.cursor=h.end}else{if(!(l=this.$findOpeningBracket(a[2],d)))return null;h=C.fromPoints(l,d),o||(h.start.column++,h.end.column--),h.cursor=h.start}return h},this.getMatchingBracketRanges=function(d,h){var l=this.getLine(d.row),n=/([\(\[\{])|([\)\]\}])/,o=!h&&l.charAt(d.column-1),i=o&&o.match(n);return i||(o=(h===void 0||h)&&l.charAt(d.column),d={row:d.row,column:d.column+1},i=o&&o.match(n)),i?(h=new C(d.row,d.column-1,d.row,d.column),(l=i[1]?this.$findClosingBracket(i[1],d):this.$findOpeningBracket(i[2],d))?[h,new C(l.row,l.column,l.row,l.column+1)]:[h]):null},this.$brackets={")":"(","(":")","]":"[","[":"]","{":"}","}":"{","<":">",">":"<"},this.$findOpeningBracket=function(d,h,l){var n=this.$brackets[d],o=1,i=new y(this,h.row,h.column),a=i.getCurrentToken();if(a=a||i.stepForward()){l=l||new RegExp("(\\.?"+a.type.replace(".","\\.").replace("rparen",".paren").replace(/\b(?:end)\b/,"(?:start|begin|end)").replace(/-close\b/,"-(close|open)")+")+");for(var r=h.column-i.getCurrentTokenColumn()-2,e=a.value;;){for(;0<=r;){var t=e.charAt(r);if(t==n){if(--o==0)return{row:i.getCurrentTokenRow(),column:r+i.getCurrentTokenColumn()}}else t==d&&(o+=1);--r}for(;(a=i.stepBackward())&&!l.test(a.type););if(a==null)break;r=(e=a.value).length-1}return null}},this.$findClosingBracket=function(d,h,l){var n=this.$brackets[d],o=1,i=new y(this,h.row,h.column),a=i.getCurrentToken();if(a=a||i.stepForward()){l=l||new RegExp("(\\.?"+a.type.replace(".","\\.").replace("lparen",".paren").replace(/\b(?:start|begin)\b/,"(?:start|begin|end)").replace(/-open\b/,"-(close|open)")+")+");for(var r=h.column-i.getCurrentTokenColumn();;){for(var e=a.value,t=e.length;r<t;){var s=e.charAt(r);if(s==n){if(--o==0)return{row:i.getCurrentTokenRow(),column:r+i.getCurrentTokenColumn()}}else s==d&&(o+=1);r+=1}for(;(a=i.stepForward())&&!l.test(a.type););if(a==null)break;r=0}return null}},this.getMatchingTags=function(h){var h=new y(this,h.row,h.column),l=this.$findTagName(h);if(l)return h.stepBackward().value==="<"?this.$findClosingTag(h,l):this.$findOpeningTag(h,l)},this.$findTagName=function(d){var h=d.getCurrentToken(),l=!1,n=!1;if(h&&h.type.indexOf("tag-name")===-1)for(;(h=n?d.stepBackward():d.stepForward())&&(h.value==="/>"?n=!0:h.type.indexOf("tag-name")!==-1&&(l=!0)),h&&!l;);return h},this.$findClosingTag=function(d,h){var l=h.value,n=h.value,o=0,i=new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+1),a=(h=d.stepForward(),new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+h.value.length)),r=!1;do{var e,t=h;if(h=d.stepForward())if(h.value!==">"||r||(e=new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+1),r=!0),h.type.indexOf("tag-name")!==-1){if(n===(l=h.value)){if(t.value==="<")o++;else if(t.value==="</"&&--o<0){d.stepBackward();var s=new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+2),c=(h=d.stepForward(),new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+h.value.length));if(!(h=d.stepForward())||h.value!==">")return;var p=new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+1)}}}else n===l&&h.value==="/>"&&--o<0&&(p=c=s=new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+2),e=new C(a.end.row,a.end.column,a.end.row,a.end.column+1))}while(h&&0<=o);if(i&&e&&s&&p&&a&&c)return{openTag:new C(i.start.row,i.start.column,e.end.row,e.end.column),closeTag:new C(s.start.row,s.start.column,p.end.row,p.end.column),openTagName:a,closeTagName:c}},this.$findOpeningTag=function(d,h){var l,n=d.getCurrentToken(),o=h.value,i=0,a=d.getCurrentTokenRow(),r=d.getCurrentTokenColumn(),e=new C(a,r,a,r+2),t=(d.stepForward(),new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+h.value.length));if((h=d.stepForward())&&h.value===">"){var s=new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+1);d.stepBackward(),d.stepBackward();do if(h=n,a=d.getCurrentTokenRow(),l=(r=d.getCurrentTokenColumn())+h.value.length,n=d.stepBackward(),h){if(h.type.indexOf("tag-name")!==-1){if(o===h.value)if(n.value==="<"){if(0<++i){for(var c=new C(a,r,a,l),p=new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+1);(h=d.stepForward())&&h.value!==">";);var g=new C(d.getCurrentTokenRow(),d.getCurrentTokenColumn(),d.getCurrentTokenRow(),d.getCurrentTokenColumn()+1)}}else n.value==="</"&&i--}else if(h.value==="/>"){for(var b=0,w=n;w;){if(w.type.indexOf("tag-name")!==-1&&w.value===o){i--;break}if(w.value==="<")break;w=d.stepBackward(),b++}for(var E=0;E<b;E++)d.stepForward()}}while(n&&i<=0);return p&&g&&e&&s&&c&&t?{openTag:new C(p.start.row,p.start.column,g.end.row,g.end.column),closeTag:new C(e.start.row,e.start.column,s.end.row,s.end.column),openTagName:c,closeTagName:t}:void 0}}}}),ace.define("ace/edit_session",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/bidihandler","ace/config","ace/lib/event_emitter","ace/selection","ace/mode/text","ace/range","ace/document","ace/background_tokenizer","ace/search_highlight","ace/undomanager","ace/edit_session/folding","ace/edit_session/bracket_match"],function(A,f,R){var y=A("./lib/oop"),C=A("./lib/lang"),d=A("./bidihandler").BidiHandler,h=A("./config"),l=A("./lib/event_emitter").EventEmitter,n=A("./selection").Selection,o=A("./mode/text").Mode,i=A("./range").Range,a=A("./document").Document,r=A("./background_tokenizer").BackgroundTokenizer,e=A("./search_highlight").SearchHighlight,t=A("./undomanager").UndoManager,s=(c.prototype.setDocument=function(u){this.doc&&this.doc.off("change",this.$onChange),(this.doc=u).on("change",this.$onChange,!0),this.bgTokenizer.setDocument(this.getDocument()),this.resetCaches()},c.prototype.getDocument=function(){return this.doc},c.prototype.$resetRowCache=function(u){var _;u?(_=this.$docRowCache.length,(u=this.$getRowCacheIndex(this.$docRowCache,u)+1)<_&&(this.$docRowCache.splice(u,_),this.$screenRowCache.splice(u,_))):(this.$docRowCache=[],this.$screenRowCache=[])},c.prototype.$getRowCacheIndex=function(u,_){for(var v=0,$=u.length-1;v<=$;){var P=v+$>>1,M=u[P];if(M<_)v=1+P;else{if(!(_<M))return P;$=P-1}}return v-1},c.prototype.resetCaches=function(){this.$modified=!0,this.$wrapData=[],this.$rowLengthCache=[],this.$resetRowCache(0),this.destroyed||this.bgTokenizer.start(0)},c.prototype.onChangeFold=function(u){u=u.data,this.$resetRowCache(u.start.row)},c.prototype.onChange=function(u){this.$modified=!0,this.$bidiHandler.onChange(u),this.$resetRowCache(u.start.row);var _=this.$updateInternalDataOnChange(u);!this.$fromUndo&&this.$undoManager&&(_&&_.length&&(this.$undoManager.add({action:"removeFolds",folds:_},this.mergeUndoDeltas),this.mergeUndoDeltas=!0),this.$undoManager.add(u,this.mergeUndoDeltas),this.mergeUndoDeltas=!0,this.$informUndoManager.schedule()),this.bgTokenizer.$updateOnChange(u),this._signal("change",u)},c.prototype.setValue=function(u){this.doc.setValue(u),this.selection.moveTo(0,0),this.$resetRowCache(0),this.setUndoManager(this.$undoManager),this.getUndoManager().reset()},c.fromJSON=function(u){u=JSON.parse(u);var _=new t,v=(_.$undoStack=u.history.undo,_.$redoStack=u.history.redo,_.mark=u.history.mark,_.$rev=u.history.rev,new c(u.value));return u.folds.forEach(function($){v.addFold("...",i.fromPoints($.start,$.end))}),v.setAnnotations(u.annotations),v.setBreakpoints(u.breakpoints),v.setMode(u.mode),v.setScrollLeft(u.scrollLeft),v.setScrollTop(u.scrollTop),v.setUndoManager(_),v.selection.fromJSON(u.selection),v},c.prototype.toJSON=function(){return{annotations:this.$annotations,breakpoints:this.$breakpoints,folds:this.getAllFolds().map(function(u){return u.range}),history:this.getUndoManager(),mode:this.$mode.$id,scrollLeft:this.$scrollLeft,scrollTop:this.$scrollTop,selection:this.selection.toJSON(),value:this.doc.getValue()}},c.prototype.toString=function(){return this.doc.getValue()},c.prototype.getSelection=function(){return this.selection},c.prototype.getState=function(u){return this.bgTokenizer.getState(u)},c.prototype.getTokens=function(u){return this.bgTokenizer.getTokens(u)},c.prototype.getTokenAt=function(u,_){var v=this.bgTokenizer.getTokens(u),P=0;if(_==null)var $=v.length-1,P=this.getLine(u).length;else for($=0;$<v.length&&!(_<=(P+=v[$].value.length));$++);return(u=v[$])?(u.index=$,u.start=P-u.value.length,u):null},c.prototype.setUndoManager=function(u){var _;this.$undoManager=u,this.$informUndoManager&&this.$informUndoManager.cancel(),u?(u.addSession(_=this),this.$syncInformUndoManager=function(){_.$informUndoManager.cancel(),_.mergeUndoDeltas=!1},this.$informUndoManager=C.delayedCall(this.$syncInformUndoManager)):this.$syncInformUndoManager=function(){}},c.prototype.markUndoGroup=function(){this.$syncInformUndoManager&&this.$syncInformUndoManager()},c.prototype.getUndoManager=function(){return this.$undoManager||this.$defaultUndoManager},c.prototype.getTabString=function(){return this.getUseSoftTabs()?C.stringRepeat(" ",this.getTabSize()):"	"},c.prototype.setUseSoftTabs=function(u){this.setOption("useSoftTabs",u)},c.prototype.getUseSoftTabs=function(){return this.$useSoftTabs&&!this.$mode.$indentWithTabs},c.prototype.setTabSize=function(u){this.setOption("tabSize",u)},c.prototype.getTabSize=function(){return this.$tabSize},c.prototype.isTabStop=function(u){return this.$useSoftTabs&&u.column%this.$tabSize==0},c.prototype.setNavigateWithinSoftTabs=function(u){this.setOption("navigateWithinSoftTabs",u)},c.prototype.getNavigateWithinSoftTabs=function(){return this.$navigateWithinSoftTabs},c.prototype.setOverwrite=function(u){this.setOption("overwrite",u)},c.prototype.getOverwrite=function(){return this.$overwrite},c.prototype.toggleOverwrite=function(){this.setOverwrite(!this.$overwrite)},c.prototype.addGutterDecoration=function(u,_){this.$decorations[u]||(this.$decorations[u]=""),this.$decorations[u]+=" "+_,this._signal("changeBreakpoint",{})},c.prototype.removeGutterDecoration=function(u,_){this.$decorations[u]=(this.$decorations[u]||"").replace(" "+_,""),this._signal("changeBreakpoint",{})},c.prototype.getBreakpoints=function(){return this.$breakpoints},c.prototype.setBreakpoints=function(u){this.$breakpoints=[];for(var _=0;_<u.length;_++)this.$breakpoints[u[_]]="ace_breakpoint";this._signal("changeBreakpoint",{})},c.prototype.clearBreakpoints=function(){this.$breakpoints=[],this._signal("changeBreakpoint",{})},c.prototype.setBreakpoint=function(u,_){(_=_===void 0?"ace_breakpoint":_)?this.$breakpoints[u]=_:delete this.$breakpoints[u],this._signal("changeBreakpoint",{})},c.prototype.clearBreakpoint=function(u){delete this.$breakpoints[u],this._signal("changeBreakpoint",{})},c.prototype.addMarker=function(M,_,v,$){var P=this.$markerId++,M={range:M,type:v||"line",renderer:typeof v=="function"?v:null,clazz:_,inFront:!!$,id:P};return $?(this.$frontMarkers[P]=M,this._signal("changeFrontMarker")):(this.$backMarkers[P]=M,this._signal("changeBackMarker")),P},c.prototype.addDynamicMarker=function(u,_){var v;if(u.update)return v=this.$markerId++,u.id=v,u.inFront=!!_,_?(this.$frontMarkers[v]=u,this._signal("changeFrontMarker")):(this.$backMarkers[v]=u,this._signal("changeBackMarker")),u},c.prototype.removeMarker=function(u){var _=this.$frontMarkers[u]||this.$backMarkers[u];_&&(delete(_.inFront?this.$frontMarkers:this.$backMarkers)[u],this._signal(_.inFront?"changeFrontMarker":"changeBackMarker"))},c.prototype.getMarkers=function(u){return u?this.$frontMarkers:this.$backMarkers},c.prototype.highlight=function(u){var _;this.$searchHighlight||(_=new e(null,"ace_selected-word","text"),this.$searchHighlight=this.addDynamicMarker(_)),this.$searchHighlight.setRegexp(u)},c.prototype.highlightLines=function(u,_,v,$){return typeof _!="number"&&(v=_,_=u),v=v||"ace_step",u=new i(u,0,_,1/0),u.id=this.addMarker(u,v,"fullLine",$),u},c.prototype.setAnnotations=function(u){this.$annotations=u,this._signal("changeAnnotation",{})},c.prototype.getAnnotations=function(){return this.$annotations||[]},c.prototype.clearAnnotations=function(){this.setAnnotations([])},c.prototype.$detectNewLine=function(u){u=u.match(/^.*?(\r?\n)/m),this.$autoNewLine=u?u[1]:`
`},c.prototype.getWordRange=function(u,_){var v,$=this.getLine(u),P=!1,M=(v=(P=(P=0<_?!!$.charAt(_-1).match(this.tokenRe):P)||!!$.charAt(_).match(this.tokenRe))?this.tokenRe:/^\s+$/.test($.slice(_-1,_+1))?/\s/:this.nonTokenRe,_);if(0<M){for(;0<=--M&&$.charAt(M).match(v););M++}for(var X=_;X<$.length&&$.charAt(X).match(v);)X++;return new i(u,M,u,X)},c.prototype.getAWordRange=function(u,_){for(var v=this.getWordRange(u,_),$=this.getLine(v.end.row);$.charAt(v.end.column).match(/[ \t]/);)v.end.column+=1;return v},c.prototype.setNewLineMode=function(u){this.doc.setNewLineMode(u)},c.prototype.getNewLineMode=function(){return this.doc.getNewLineMode()},c.prototype.setUseWorker=function(u){this.setOption("useWorker",u)},c.prototype.getUseWorker=function(){return this.$useWorker},c.prototype.onReloadTokenizer=function(u){var _=u.data;this.bgTokenizer.start(_.first),this._signal("tokenizerUpdate",u)},c.prototype.setMode=function(u,_){if(u&&typeof u=="object"){if(u.getTokenizer)return this.$onChangeMode(u);var v=u,$=v.path}else $=u||"ace/mode/text";this.$modes["ace/mode/text"]||(this.$modes["ace/mode/text"]=new o),this.$modes[$]&&!v?(this.$onChangeMode(this.$modes[$]),_&&_()):(this.$modeId=$,h.loadModule(["mode",$],(function(P){if(this.$modeId!==$)return _&&_();this.$modes[$]&&!v?this.$onChangeMode(this.$modes[$]):P&&P.Mode&&(P=new P.Mode(v),v||((this.$modes[$]=P).$id=$),this.$onChangeMode(P)),_&&_()}).bind(this)),this.$mode||this.$onChangeMode(this.$modes["ace/mode/text"],!0))},c.prototype.$onChangeMode=function(u,_){var v,$,P;_||(this.$modeId=u.$id),this.$mode===u||(v=this.$mode,this.$mode=u,this.$stopWorker(),this.$useWorker&&this.$startWorker(),($=u.getTokenizer()).on!==void 0&&(P=this.onReloadTokenizer.bind(this),$.on("update",P)),this.bgTokenizer.setTokenizer($),this.bgTokenizer.setDocument(this.getDocument()),this.tokenRe=u.tokenRe,this.nonTokenRe=u.nonTokenRe,_)||(u.attachToSession&&u.attachToSession(this),this.$options.wrapMethod.set.call(this,this.$wrapMethod),this.$setFolding(u.foldingRules),this.bgTokenizer.start(0),this._emit("changeMode",{oldMode:v,mode:u}))},c.prototype.$stopWorker=function(){this.$worker&&(this.$worker.terminate(),this.$worker=null)},c.prototype.$startWorker=function(){try{this.$worker=this.$mode.createWorker(this)}catch(u){h.warn("Could not load worker",u),this.$worker=null}},c.prototype.getMode=function(){return this.$mode},c.prototype.setScrollTop=function(u){this.$scrollTop===u||isNaN(u)||(this.$scrollTop=u,this._signal("changeScrollTop",u))},c.prototype.getScrollTop=function(){return this.$scrollTop},c.prototype.setScrollLeft=function(u){this.$scrollLeft===u||isNaN(u)||(this.$scrollLeft=u,this._signal("changeScrollLeft",u))},c.prototype.getScrollLeft=function(){return this.$scrollLeft},c.prototype.getScreenWidth=function(){return this.$computeWidth(),this.lineWidgets?Math.max(this.getLineWidgetMaxWidth(),this.screenWidth):this.screenWidth},c.prototype.getLineWidgetMaxWidth=function(){var u;return this.lineWidgetsWidth!=null?this.lineWidgetsWidth:(u=0,this.lineWidgets.forEach(function(_){_&&_.screenWidth>u&&(u=_.screenWidth)}),this.lineWidgetWidth=u)},c.prototype.$computeWidth=function(u){if(this.$modified||u){if(this.$modified=!1,this.$useWrapMode)return this.screenWidth=this.$wrapLimit;for(var _=this.doc.getAllLines(),v=this.$rowLengthCache,$=0,P=0,M=this.$foldData[P],X=M?M.start.row:1/0,Q=_.length,K=0;K<Q;K++){if(X<K){if(Q<=(K=M.end.row+1))break;X=(M=this.$foldData[P++])?M.start.row:1/0}v[K]==null&&(v[K]=this.$getStringScreenWidth(_[K])[0]),v[K]>$&&($=v[K])}this.screenWidth=$}},c.prototype.getLine=function(u){return this.doc.getLine(u)},c.prototype.getLines=function(u,_){return this.doc.getLines(u,_)},c.prototype.getLength=function(){return this.doc.getLength()},c.prototype.getTextRange=function(u){return this.doc.getTextRange(u||this.selection.getRange())},c.prototype.insert=function(u,_){return this.doc.insert(u,_)},c.prototype.remove=function(u){return this.doc.remove(u)},c.prototype.removeFullLines=function(u,_){return this.doc.removeFullLines(u,_)},c.prototype.undoChanges=function(u,_){if(u.length){this.$fromUndo=!0;for(var v=u.length-1;v!=-1;v--){var $=u[v];$.action=="insert"||$.action=="remove"?this.doc.revertDelta($):$.folds&&this.addFolds($.folds)}!_&&this.$undoSelect&&(u.selectionBefore?this.selection.fromJSON(u.selectionBefore):this.selection.setRange(this.$getUndoSelection(u,!0))),this.$fromUndo=!1}},c.prototype.redoChanges=function(u,_){if(u.length){this.$fromUndo=!0;for(var v=0;v<u.length;v++){var $=u[v];$.action!="insert"&&$.action!="remove"||this.doc.$safeApplyDelta($)}!_&&this.$undoSelect&&(u.selectionAfter?this.selection.fromJSON(u.selectionAfter):this.selection.setRange(this.$getUndoSelection(u,!1))),this.$fromUndo=!1}},c.prototype.setUndoSelect=function(u){this.$undoSelect=u},c.prototype.$getUndoSelection=function(u,_){function v(Q){return _?Q.action!=="insert":Q.action==="insert"}for(var $,P,M=0;M<u.length;M++){var X=u[M];X.start&&($?v(X)?(P=X.start,$.compare(P.row,P.column)==-1&&$.setStart(P),P=X.end,$.compare(P.row,P.column)==1&&$.setEnd(P)):(P=X.start,$.compare(P.row,P.column)==-1&&($=i.fromPoints(X.start,X.start))):$=v(X)?i.fromPoints(X.start,X.end):i.fromPoints(X.start,X.start))}return $},c.prototype.replace=function(u,_){return this.doc.replace(u,_)},c.prototype.moveText=function(u,K,v){var $,P,M,X=this.getTextRange(u),Q=this.getFoldsInRange(u),K=i.fromPoints(K,K);return v||(this.remove(u),P=u.start.row-u.end.row,(M=P?-u.end.column:u.start.column-u.end.column)&&(K.start.row==u.end.row&&K.start.column>u.end.column&&(K.start.column+=M),K.end.row==u.end.row)&&K.end.column>u.end.column&&(K.end.column+=M),P&&K.start.row>=u.end.row&&(K.start.row+=P,K.end.row+=P)),K.end=this.insert(K.start,X),Q.length&&($=u.start,v=K.start,P=v.row-$.row,M=v.column-$.column,this.addFolds(Q.map(function(ne){return(ne=ne.clone()).start.row==$.row&&(ne.start.column+=M),ne.end.row==$.row&&(ne.end.column+=M),ne.start.row+=P,ne.end.row+=P,ne}))),K},c.prototype.indentRows=function(u,_,v){v=v.replace(/\t/g,this.getTabString());for(var $=u;$<=_;$++)this.doc.insertInLine({row:$,column:0},v)},c.prototype.outdentRows=function(u){for(var _=u.collapseRows(),v=new i(0,0,0,0),$=this.getTabSize(),P=_.start.row;P<=_.end.row;++P){var M=this.getLine(P);v.start.row=P,v.end.row=P;for(var X=0;X<$&&M.charAt(X)==" ";++X);X<$&&M.charAt(X)=="	"?(v.start.column=X,v.end.column=X+1):(v.start.column=0,v.end.column=X),this.remove(v)}},c.prototype.$moveLines=function(u,_,M){if(u=this.getRowFoldStart(u),_=this.getRowFoldEnd(_),M<0){if((P=this.getRowFoldStart(u+M))<0)return 0;var $=P-u}else if(0<M){if((P=this.getRowFoldEnd(_+M))>this.doc.getLength()-1)return 0;$=P-_}else u=this.$clipRowToDocument(u),$=(_=this.$clipRowToDocument(_))-u+1;var P=new i(u,0,_,Number.MAX_VALUE),P=this.getFoldsInRange(P).map(function(X){return(X=X.clone()).start.row+=$,X.end.row+=$,X}),M=M==0?this.doc.getLines(u,_):this.doc.removeFullLines(u,_);return this.doc.insertFullLines(u+$,M),P.length&&this.addFolds(P),$},c.prototype.moveLinesUp=function(u,_){return this.$moveLines(u,_,-1)},c.prototype.moveLinesDown=function(u,_){return this.$moveLines(u,_,1)},c.prototype.duplicateLines=function(u,_){return this.$moveLines(u,_,0)},c.prototype.$clipRowToDocument=function(u){return Math.max(0,Math.min(u,this.doc.getLength()-1))},c.prototype.$clipColumnToRow=function(u,_){return _<0?0:Math.min(this.doc.getLine(u).length,_)},c.prototype.$clipPositionToDocument=function(u,_){var v;return _=Math.max(0,_),_=u<0?u=0:(v=this.doc.getLength())<=u?this.doc.getLine(u=v-1).length:Math.min(this.doc.getLine(u).length,_),{row:u,column:_}},c.prototype.$clipRangeToDocument=function(u){u.start.row<0?(u.start.row=0,u.start.column=0):u.start.column=this.$clipColumnToRow(u.start.row,u.start.column);var _=this.doc.getLength()-1;return u.end.row>_?(u.end.row=_,u.end.column=this.doc.getLine(_).length):u.end.column=this.$clipColumnToRow(u.end.row,u.end.column),u},c.prototype.setUseWrapMode=function(u){u!=this.$useWrapMode&&(this.$useWrapMode=u,this.$modified=!0,this.$resetRowCache(0),u&&(u=this.getLength(),this.$wrapData=Array(u),this.$updateWrapData(0,u-1)),this._signal("changeWrapMode"))},c.prototype.getUseWrapMode=function(){return this.$useWrapMode},c.prototype.setWrapLimitRange=function(u,_){this.$wrapLimitRange.min===u&&this.$wrapLimitRange.max===_||(this.$wrapLimitRange={min:u,max:_},this.$modified=!0,this.$bidiHandler.markAsDirty(),this.$useWrapMode&&this._signal("changeWrapMode"))},c.prototype.adjustWrapLimit=function(u,$){var v=this.$wrapLimitRange,$=(v.max<0&&(v={min:$,max:$}),this.$constrainWrapLimit(u,v.min,v.max));return $!=this.$wrapLimit&&1<$&&(this.$wrapLimit=$,this.$modified=!0,this.$useWrapMode&&(this.$updateWrapData(0,this.getLength()-1),this.$resetRowCache(0),this._signal("changeWrapLimit")),!0)},c.prototype.$constrainWrapLimit=function(u,_,v){return _&&(u=Math.max(_,u)),u=v?Math.min(v,u):u},c.prototype.getWrapLimit=function(){return this.$wrapLimit},c.prototype.setWrapLimit=function(u){this.setWrapLimitRange(u,u)},c.prototype.getWrapLimitRange=function(){return{min:this.$wrapLimitRange.min,max:this.$wrapLimitRange.max}},c.prototype.$updateInternalDataOnChange=function(u){var _=this.$useWrapMode,v=u.action,$=u.start,P=u.end,M=$.row,X=P.row,Q=X-M,K=null;if(this.$updating=!0,Q!=0)if(v==="remove"){this[_?"$wrapData":"$rowLengthCache"].splice(M,Q);var ne=this.$foldData,K=this.getFoldsInRange(u);this.removeFolds(K);var T=0;for((I=this.getFoldLine(P.row))&&(I.addRemoveChars(P.row,P.column,$.column-P.column),I.shiftRow(-Q),(F=this.getFoldLine(M))&&F!==I&&(F.merge(I),I=F),T=ne.indexOf(I)+1);T<ne.length;T++)(I=ne[T]).start.row>=P.row&&I.shiftRow(-Q);X=M}else{var F=Array(Q),V=(F.unshift(M,0),_?this.$wrapData:this.$rowLengthCache),ne=(V.splice.apply(V,F),this.$foldData),T=0;for((I=this.getFoldLine(M))&&((V=I.range.compareInside($.row,$.column))==0?(I=I.split($.row,$.column))&&(I.shiftRow(Q),I.addRemoveChars(X,0,P.column-$.column)):V==-1&&(I.addRemoveChars(M,0,P.column-$.column),I.shiftRow(Q)),T=ne.indexOf(I)+1);T<ne.length;T++)(I=ne[T]).start.row>=M&&I.shiftRow(Q)}else{var I,Q=Math.abs(u.start.column-u.end.column);v==="remove"&&(K=this.getFoldsInRange(u),this.removeFolds(K),Q=-Q),(I=this.getFoldLine(M))&&I.addRemoveChars(M,$.column,Q)}return _&&this.$wrapData.length!=this.doc.getLength()&&console.error("doc.getLength() and $wrapData.length have to be the same!"),this.$updating=!1,_?this.$updateWrapData(M,X):this.$updateRowLengthCache(M,X),K},c.prototype.$updateRowLengthCache=function(u,_,v){this.$rowLengthCache[u]=null,this.$rowLengthCache[_]=null},c.prototype.$updateWrapData=function(u,_){var v,$,P=this.doc.getAllLines(),M=this.getTabSize(),X=this.$wrapData,Q=this.$wrapLimit,K=u;for(_=Math.min(_,P.length-1);K<=_;)($=this.getFoldLine(K,$))?(v=[],$.walk((function(ne,T,F,V){var I;if(ne!=null){(I=this.$getDisplayTokens(ne,v.length))[0]=b;for(var S=1;S<I.length;S++)I[S]=w}else I=this.$getDisplayTokens(P[T].substring(V,F),v.length);v=v.concat(I)}).bind(this),$.end.row,P[$.end.row].length+1),X[$.start.row]=this.$computeWrapSplits(v,Q,M),K=$.end.row+1):(v=this.$getDisplayTokens(P[K]),X[K]=this.$computeWrapSplits(v,Q,M),K++)},c.prototype.$computeWrapSplits=function(u,_,v){if(u.length==0)return[];var $=[],P=u.length,M=0,X=0,Q=this.$wrapAsCode,K=this.$indentedSoftWrap,ne=_<=Math.max(2*v,8)||K===!1?0:Math.floor(_/2);function T(S){for(var L=S-M,Z=M;Z<S;Z++){var J=u[Z];J!==12&&J!==2||--L}$.length||(F=function(){var re=0;if(ne===0)return re;if(K)for(var pe=0;pe<u.length;pe++){var me=u[pe];if(me==W)re+=1;else if(me==B)re+=v;else if(me!=O)break}return Q&&K!==!1&&(re+=v),Math.min(re,ne)}(),$.indent=F),X+=L,$.push(X),M=S}for(var F=0;_-F<P-M;){var V=M+_-F;if(u[V-1]>=W&&u[V]>=W)T(V);else if(u[V]==b||u[V]==w){for(;V!=M-1&&u[V]!=b;V--);if(!(M<V)){for(V=M+_;V<u.length&&u[V]==w;V++);if(V==u.length)break}T(V)}else{for(var I=Math.max(V-(_-(_>>2)),M-1);I<V&&u[V]<b;)V--;if(Q){for(;I<V&&u[V]<b;)V--;for(;I<V&&u[V]==E;)V--}else for(;I<V&&u[V]<W;)V--;I<V?T(++V):(u[V=M+_]==g&&V--,T(V-F))}}return $},c.prototype.$getDisplayTokens=function(u,_){var v,$=[];_=_||0;for(var P=0;P<u.length;P++){var M=u.charCodeAt(P);if(M==9){v=this.getScreenTabSize($.length+_),$.push(B);for(var X=1;X<v;X++)$.push(O)}else M==32?$.push(W):39<M&&M<48||57<M&&M<64?$.push(E):4352<=M&&x(M)?$.push(p,g):$.push(p)}return $},c.prototype.$getStringScreenWidth=function(u,_,v){if(_==0)return[0,0];var $,P;for(_==null&&(_=1/0),v=v||0,P=0;P<u.length&&(($=u.charCodeAt(P))==9?v+=this.getScreenTabSize(v):4352<=$&&x($)?v+=2:v+=1,!(_<v));P++);return[v,P]},c.prototype.getRowLength=function(u){var _=1;return this.lineWidgets&&(_+=this.lineWidgets[u]&&this.lineWidgets[u].rowCount||0),this.$useWrapMode&&this.$wrapData[u]?this.$wrapData[u].length+_:_},c.prototype.getRowLineCount=function(u){return this.$useWrapMode&&this.$wrapData[u]?this.$wrapData[u].length+1:1},c.prototype.getRowWrapIndent=function(u){var _;return this.$useWrapMode&&(u=this.screenToDocumentPosition(u,Number.MAX_VALUE),(_=this.$wrapData[u.row]).length)&&_[0]<u.column?_.indent:0},c.prototype.getScreenLastRowColumn=function(u){return u=this.screenToDocumentPosition(u,Number.MAX_VALUE),this.documentToScreenColumn(u.row,u.column)},c.prototype.getDocumentLastRowColumn=function(u,_){return u=this.documentToScreenRow(u,_),this.getScreenLastRowColumn(u)},c.prototype.getDocumentLastRowColumnPosition=function(u,_){return u=this.documentToScreenRow(u,_),this.screenToDocumentPosition(u,Number.MAX_VALUE/10)},c.prototype.getRowSplitData=function(u){if(this.$useWrapMode)return this.$wrapData[u]},c.prototype.getScreenTabSize=function(u){return this.$tabSize-(u%this.$tabSize|0)},c.prototype.screenToDocumentRow=function(u,_){return this.screenToDocumentPosition(u,_).row},c.prototype.screenToDocumentColumn=function(u,_){return this.screenToDocumentPosition(u,_).column},c.prototype.screenToDocumentPosition=function(u,_,v){if(u<0)return{row:0,column:0};for(var $,P,M,X=0,Q=0,K=0,ne=0,T=this.$screenRowCache,F=this.$getRowCacheIndex(T,u),V=T.length,I=(M=V&&0<=F?(K=T[F],X=this.$docRowCache[F],u>T[V-1]):!V,this.getLength()-1),S=this.getNextFoldLine(X),L=S?S.start.row:1/0;K<=u&&!(u<K+(ne=this.getRowLength(X))||I<=X);)K+=ne,L<++X&&(X=S.end.row+1,L=(S=this.getNextFoldLine(X,S))?S.start.row:1/0),M&&(this.$docRowCache.push(X),this.$screenRowCache.push(K));if(S&&S.start.row<=X)$=this.getFoldDisplayLine(S),X=S.start.row;else{if(K+ne<=u||I<X)return{row:I,column:this.getLine(I).length};$=this.getLine(X),S=null}return F=0,T=Math.floor(u-K),this.$useWrapMode&&(V=this.$wrapData[X])&&(P=V[T],0<T)&&V.length&&(F=V.indent,Q=V[T-1]||V[V.length-1],$=$.substring(Q)),v!==void 0&&this.$bidiHandler.isBidiRow(K+T,X,T)&&(_=this.$bidiHandler.offsetToCol(v)),Q+=this.$getStringScreenWidth($,_-F)[1],this.$useWrapMode&&P<=Q&&(Q=P-1),S?S.idxToPosition(Q):{row:X,column:Q}},c.prototype.documentToScreenPosition=function(u,_){var F=_===void 0?this.$clipPositionToDocument(u.row,u.column):this.$clipPositionToDocument(u,_),v=(u=F.row,_=F.column,0),F=null;(X=this.getFoldAt(u,_,1))&&(u=X.start.row,_=X.start.column);for(var $,P,M=0,X=this.$docRowCache,V=this.$getRowCacheIndex(X,u),Q=X.length,K=(P=Q&&0<=V?(M=X[V],v=this.$screenRowCache[V],u>X[Q-1]):!Q,this.getNextFoldLine(M)),ne=K?K.start.row:1/0;M<u;){if(ne<=M){if(u<($=K.end.row+1))break;ne=(K=this.getNextFoldLine($,K))?K.start.row:1/0}else $=M+1;v+=this.getRowLength(M),M=$,P&&(this.$docRowCache.push(M),this.$screenRowCache.push(v))}var T="",F=K&&ne<=M?(T=this.getFoldDisplayLine(K,u,_),K.start.row):(T=this.getLine(u).substring(0,_),u),V=0;if(this.$useWrapMode){var I=this.$wrapData[F];if(I){for(var S=0;T.length>=I[S];)v++,S++;T=T.substring(I[S-1]||0,T.length),V=0<S?I.indent:0}}return this.lineWidgets&&this.lineWidgets[M]&&this.lineWidgets[M].rowsAbove&&(v+=this.lineWidgets[M].rowsAbove),{row:v,column:V+this.$getStringScreenWidth(T)[0]}},c.prototype.documentToScreenColumn=function(u,_){return this.documentToScreenPosition(u,_).column},c.prototype.documentToScreenRow=function(u,_){return this.documentToScreenPosition(u,_).row},c.prototype.getScreenLength=function(){var u=0,_=null;if(this.$useWrapMode)for(var v=this.$wrapData.length,$=0,P=0,M=(_=this.$foldData[P++])?_.start.row:1/0;$<v;){var X=this.$wrapData[$];u+=X?X.length+1:1,M<++$&&($=_.end.row+1,M=(_=this.$foldData[P++])?_.start.row:1/0)}else for(var u=this.getLength(),Q=this.$foldData,P=0;P<Q.length;P++)u-=(_=Q[P]).end.row-_.start.row;return this.lineWidgets&&(u+=this.$getWidgetScreenLength()),u},c.prototype.$setFontMetrics=function(u){this.$enableVarChar&&(this.$getStringScreenWidth=function(_,v,$){if(v===0)return[0,0];var P,M;for(v=v||1/0,$=$||0,M=0;M<_.length&&!(v<($+=(P=_.charAt(M))==="	"?this.getScreenTabSize($):u.getCharacterWidth(P)));M++);return[$,M]})},c.prototype.destroy=function(){this.destroyed||(this.bgTokenizer.setDocument(null),this.bgTokenizer.cleanup(),this.destroyed=!0),this.$stopWorker(),this.removeAllListeners(),this.doc&&this.doc.off("change",this.$onChange),this.selection.detach()},c);function c(u,_){this.$breakpoints=[],this.$decorations=[],this.$frontMarkers={},this.$backMarkers={},this.$markerId=1,this.$undoSelect=!0,this.$foldData=[],this.id="session"+ ++c.$uid,this.$foldData.toString=function(){return this.join(`
`)},this.bgTokenizer=new r(new o().getTokenizer(),this);var v=this;this.bgTokenizer.on("update",function($){v._signal("tokenizerUpdate",$)}),this.on("changeFold",this.onChangeFold.bind(this)),this.$onChange=this.onChange.bind(this),typeof u=="object"&&u.getLine||(u=new a(u)),this.setDocument(u),this.selection=new n(this),this.$bidiHandler=new d(this),h.resetOptions(this),this.setMode(_),h._signal("session",this),this.destroyed=!1}s.$uid=0,s.prototype.$modes=h.$modes,s.prototype.getValue=s.prototype.toString,s.prototype.$defaultUndoManager={undo:function(){},redo:function(){},hasUndo:function(){},hasRedo:function(){},reset:function(){},add:function(){},addSelection:function(){},startNewGroup:function(){},addSession:function(){}},s.prototype.$overwrite=!1,s.prototype.$mode=null,s.prototype.$modeId=null,s.prototype.$scrollTop=0,s.prototype.$scrollLeft=0,s.prototype.$wrapLimit=80,s.prototype.$useWrapMode=!1,s.prototype.$wrapLimitRange={min:null,max:null},s.prototype.lineWidgets=null,s.prototype.isFullWidth=x,y.implement(s.prototype,l);var p=1,g=2,b=3,w=4,E=9,W=10,B=11,O=12;function x(u){return!(u<4352)&&(4352<=u&&u<=4447||4515<=u&&u<=4519||4602<=u&&u<=4607||9001<=u&&u<=9002||11904<=u&&u<=11929||11931<=u&&u<=12019||12032<=u&&u<=12245||12272<=u&&u<=12283||12288<=u&&u<=12350||12353<=u&&u<=12438||12441<=u&&u<=12543||12549<=u&&u<=12589||12593<=u&&u<=12686||12688<=u&&u<=12730||12736<=u&&u<=12771||12784<=u&&u<=12830||12832<=u&&u<=12871||12880<=u&&u<=13054||13056<=u&&u<=19903||19968<=u&&u<=42124||42128<=u&&u<=42182||43360<=u&&u<=43388||44032<=u&&u<=55203||55216<=u&&u<=55238||55243<=u&&u<=55291||63744<=u&&u<=64255||65040<=u&&u<=65049||65072<=u&&u<=65106||65108<=u&&u<=65126||65128<=u&&u<=65131||65281<=u&&u<=65376||65504<=u&&u<=65510)}A("./edit_session/folding").Folding.call(s.prototype),A("./edit_session/bracket_match").BracketMatch.call(s.prototype),h.defineOptions(s.prototype,"session",{wrap:{set:function(u){u&&u!="off"?u=="free"?u=!0:u=="printMargin"?u=-1:typeof u=="string"&&(u=parseInt(u,10)||!1):u=!1,this.$wrap!=u&&((this.$wrap=u)?(this.setWrapLimitRange(u=typeof u=="number"?u:null,u),this.setUseWrapMode(!0)):this.setUseWrapMode(!1))},get:function(){return this.getUseWrapMode()?this.$wrap==-1?"printMargin":this.getWrapLimitRange().min?this.$wrap:"free":"off"},handlesSet:!0},wrapMethod:{set:function(u){(u=u=="auto"?this.$mode.type!="text":u!="text")!=this.$wrapAsCode&&(this.$wrapAsCode=u,this.$useWrapMode)&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:"auto"},indentedSoftWrap:{set:function(){this.$useWrapMode&&(this.$useWrapMode=!1,this.setUseWrapMode(!0))},initialValue:!0},firstLineNumber:{set:function(){this._signal("changeBreakpoint")},initialValue:1},useWorker:{set:function(u){this.$useWorker=u,this.$stopWorker(),u&&this.$startWorker()},initialValue:!0},useSoftTabs:{initialValue:!0},tabSize:{set:function(u){0<(u=parseInt(u))&&this.$tabSize!==u&&(this.$modified=!0,this.$rowLengthCache=[],this.$tabSize=u,this._signal("changeTabSize"))},initialValue:4,handlesSet:!0},navigateWithinSoftTabs:{initialValue:!1},foldStyle:{set:function(u){this.setFoldStyle(u)},handlesSet:!0},overwrite:{set:function(u){this._signal("changeOverwrite")},initialValue:!1},newLineMode:{set:function(u){this.doc.setNewLineMode(u)},get:function(){return this.doc.getNewLineMode()},handlesSet:!0},mode:{set:function(u){this.setMode(u)},get:function(){return this.$modeId},handlesSet:!0}}),f.EditSession=s}),ace.define("ace/search",["require","exports","module","ace/lib/lang","ace/lib/oop","ace/range"],function(A,f,R){var y=A("./lib/lang"),C=A("./lib/oop"),d=A("./range").Range;function h(){this.$options={}}h.prototype.set=function(l){return C.mixin(this.$options,l),this},h.prototype.getOptions=function(){return y.copyObject(this.$options)},h.prototype.setOptions=function(l){this.$options=l},h.prototype.find=function(i){var n,o=this.$options,i=this.$matchIterator(i,o);return!!i&&(n=null,i.forEach(function(a,r,e,t){return n=new d(a,r,e,t),!(r==t&&o.start&&o.start.start&&o.skipCurrent!=0&&n.isEqual(o.start)&&(n=null,1))}),n)},h.prototype.findAll=function(l){var n=this.$options;if(!n.needle)return[];this.$assembleRegExp(n);var o=n.range,i=o?l.getLines(o.start.row,o.end.row):l.doc.getAllLines(),a=[],r=n.re;if(n.$isMultiLine){var e,t=r.length,s=i.length-t;e:for(var c=r.offset||0;c<=s;c++){for(var p=0;p<t;p++)if(i[c+p].search(r[p])==-1)continue e;var g=i[c],b=i[c+t-1],g=g.length-g.match(r[0])[0].length,b=b.match(r[t-1])[0].length;e&&e.end.row===c&&e.end.column>g||(a.push(e=new d(c,g,c+t-1,b)),2<t&&(c=c+t-2))}}else for(var w=0;w<i.length;w++)for(var E=y.getMatchOffsets(i[w],r),p=0;p<E.length;p++){var W=E[p];a.push(new d(w,W.offset,w,W.offset+W.length))}if(o){for(var B=o.start.column,O=o.end.column,w=0,p=a.length-1;w<p&&a[w].start.column<B&&a[w].start.row==0;)w++;for(var x=o.end.row-o.start.row;w<p&&a[p].end.column>O&&a[p].end.row==x;)p--;for(a=a.slice(w,p+1),w=0,p=a.length;w<p;w++)a[w].start.row+=o.start.row,a[w].end.row+=o.start.row}return a},h.prototype.replace=function(l,n){var o=this.$options,i=this.$assembleRegExp(o);if(o.$isMultiLine)return n;if(i){var a=i.exec(l);if(!a||a[0].length!=l.length)return null;if(n=l.replace(i,n),o.preserveCase){n=n.split("");for(var r=Math.min(l.length,l.length);r--;){var e=l[r];e&&e.toLowerCase()!=e?n[r]=n[r].toUpperCase():n[r]=n[r].toLowerCase()}n=n.join("")}return n}},h.prototype.$assembleRegExp=function(l,n){if(l.needle instanceof RegExp)return l.re=l.needle;var o,i,a,r,e=l.needle;if(!l.needle)return l.re=!1;l.$supportsUnicodeFlag===void 0&&(l.$supportsUnicodeFlag=y.supportsUnicodeFlag());try{new RegExp(e,"u")}catch{l.$supportsUnicodeFlag=!1}function t(p,g){return g===void 0&&(g=!0),(a&&i.$supportsUnicodeFlag?new RegExp("[\\p{L}\\p{N}_]","u"):new RegExp("\\w")).test(p)||i.regExp?a&&i.$supportsUnicodeFlag?g?"(?<=^|[^\\p{L}\\p{N}_])":"(?=[^\\p{L}\\p{N}_]|$)":"\\b":""}l.regExp||(e=y.escapeRegExp(e)),l.wholeWord&&(o=e,i=l,a=y.supportsLookbehind(),r=Array.from(o),s=r[0],r=r[r.length-1],e=t(s)+o+t(r,!1));var s=l.caseSensitive?"gm":"gmi";if(l.$supportsUnicodeFlag&&(s+="u"),l.$isMultiLine=!n&&/[\n\r]/.test(e),l.$isMultiLine)return l.re=this.$assembleMultilineRegExp(e,s);try{var c=new RegExp(e,s)}catch{c=!1}return l.re=c},h.prototype.$assembleMultilineRegExp=function(l,n){for(var o=l.replace(/\r\n|\r|\n/g,`$
^`).split(`
`),i=[],a=0;a<o.length;a++)try{i.push(new RegExp(o[a],n))}catch{return!1}return i},h.prototype.$matchIterator=function(l,n){var o,i,a,r,e,t,s,c,p=this.$assembleRegExp(n);return!!p&&(o=n.backwards==1,i=n.skipCurrent!=0,a=n.range,(r=(r=n.start)||(a?a[o?"end":"start"]:l.selection.getRange())).start&&(r=r[i!=o?"end":"start"]),e=a?a.start.row:0,t=a?a.end.row:l.getLength()-1,c=n.$isMultiLine?(s=p.length,function(g,b,w){var E=o?g-s+1:g;if(!(E<0||E+s>l.getLength())){var W=l.getLine(E),g=W.search(p[0]);if(!(!o&&g<b||g===-1)){for(var B=1;B<s;B++)if((W=l.getLine(E+B)).search(p[B])==-1)return;var O=W.match(p[s-1])[0].length;if(!(o&&b<O))return!!w(E,g,E+s-1,O)||void 0}}}):o?function(g,b,w){var E,W=l.getLine(g),B=[];for(p.lastIndex=0;E=p.exec(W);){var O=E[0].length,x=E.index;if(!O){if(x>=W.length)break;p.lastIndex=x+=1}if(E.index+O>b)break;B.push(E.index,O)}for(var u=B.length-1;0<=u;u-=2){var _=B[u-1];if(w(g,_,g,_+(O=B[u])))return!0}}:function(g,b,w){var E=l.getLine(g);for(p.lastIndex=b;W=p.exec(E);){var W,B=W[0].length;if(w(g,W=W.index,g,W+B))return!0;if(!B&&(p.lastIndex=W+=1,W>=E.length))return!1}},{forEach:o?function(g){var b=r.row;if(!c(b,r.column,g)){for(b--;e<=b;b--)if(c(b,Number.MAX_VALUE,g))return;if(n.wrap!=0){for(b=t,e=r.row;e<=b;b--)if(c(b,Number.MAX_VALUE,g))return}}}:function(g){var b=r.row;if(!c(b,r.column,g)){for(b+=1;b<=t;b++)if(c(b,0,g))return;if(n.wrap!=0){for(b=e,t=r.row;b<=t;b++)if(c(b,0,g))return}}}})},f.Search=h}),ace.define("ace/keyboard/hash_handler",["require","exports","module","ace/lib/keys","ace/lib/useragent"],function(r,f,R){var y,C=this&&this.__extends||(y=function(t,s){return(y=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(c,p){c.__proto__=p}:function(c,p){for(var g in p)Object.prototype.hasOwnProperty.call(p,g)&&(c[g]=p[g])}))(t,s)},function(t,s){if(typeof s!="function"&&s!==null)throw new TypeError("Class extends value "+String(s)+" is not a constructor or null");function c(){this.constructor=t}y(t,s),t.prototype=s===null?Object.create(s):(c.prototype=s.prototype,new c)}),d=r("../lib/keys"),h=r("../lib/useragent"),l=d.KEY_MODS,n=(o.prototype.$init=function(t,s,c){this.platform=s||(h.isMac?"mac":"win"),this.commands={},this.commandKeyBinding={},this.addCommands(t),this.$singleCommand=c},o.prototype.addCommand=function(t){this.commands[t.name]&&this.removeCommand(t),(this.commands[t.name]=t).bindKey&&this._buildKeyHash(t)},o.prototype.removeCommand=function(t,s){var c,p=t&&(typeof t=="string"?t:t.name),g=(t=this.commands[p],s||delete this.commands[p],this.commandKeyBinding);for(c in g){var b,w=g[c];w==t?delete g[c]:Array.isArray(w)&&(b=w.indexOf(t))!=-1&&(w.splice(b,1),w.length==1)&&(g[c]=w[0])}},o.prototype.bindKey=function(t,s,c){if(typeof t=="object"&&t&&(c==null&&(c=t.position),t=t[this.platform]),t)return typeof s=="function"?this.addCommand({exec:s,bindKey:t,name:s.name||t}):void t.split("|").forEach(function(w){var g="",b=(w.indexOf(" ")!=-1&&(w=(b=w.split(/\s+/)).pop(),b.forEach(function(E){E=this.parseKeys(E),E=l[E.hashId]+E.key,g+=(g?" ":"")+E,this._addCommandToBinding(g,"chainKeys")},this),g+=" "),this.parseKeys(w)),w=l[b.hashId]+b.key;this._addCommandToBinding(g+w,s,c)},this)},o.prototype._addCommandToBinding=function(t,s,c){var p=this.commandKeyBinding;if(s)if(!p[t]||this.$singleCommand)p[t]=s;else{Array.isArray(p[t])?(b=p[t].indexOf(s))!=-1&&p[t].splice(b,1):p[t]=[p[t]],typeof c!="number"&&(c=i(s));for(var g=p[t],b=0;b<g.length&&!(c<i(g[b]));b++);g.splice(b,0,s)}else delete p[t]},o.prototype.addCommands=function(t){t&&Object.keys(t).forEach(function(s){var c=t[s];if(c){if(typeof c=="string")return this.bindKey(c,s);typeof(c=typeof c=="function"?{exec:c}:c)=="object"&&(c.name||(c.name=s),this.addCommand(c))}},this)},o.prototype.removeCommands=function(t){Object.keys(t).forEach(function(s){this.removeCommand(t[s])},this)},o.prototype.bindKeys=function(t){Object.keys(t).forEach(function(s){this.bindKey(s,t[s])},this)},o.prototype._buildKeyHash=function(t){this.bindKey(t.bindKey,t)},o.prototype.parseKeys=function(t){var s=t.toLowerCase().split(/[\-\+]([\-\+])?/).filter(function(E){return E}),c=s.pop(),p=d[c];if(d.FUNCTION_KEYS[p])c=d.FUNCTION_KEYS[p].toLowerCase();else{if(!s.length)return{key:c,hashId:-1};if(s.length==1&&s[0]=="shift")return{key:c.toUpperCase(),hashId:-1}}for(var g=0,b=s.length;b--;){var w=d.KEY_MODS[s[b]];if(w==null)return typeof console<"u"&&console.error("invalid modifier "+s[b]+" in "+t),!1;g|=w}return{key:c,hashId:g}},o.prototype.findKeyCommand=function(t,s){return t=l[t]+s,this.commandKeyBinding[t]},o.prototype.handleKeyboard=function(t,s,c,p){var g,b;if(!(p<0))return g=l[s]+c,b=this.commandKeyBinding[g],t.$keyChain&&(t.$keyChain+=" "+g,b=this.commandKeyBinding[t.$keyChain]||b),!b||b!="chainKeys"&&b[b.length-1]!="chainKeys"?(t.$keyChain&&(s&&s!=4||c.length!=1?(s==-1||0<p)&&(t.$keyChain=""):t.$keyChain=t.$keyChain.slice(0,-g.length-1)),{command:b}):(t.$keyChain=t.$keyChain||g,{command:"null"})},o.prototype.getStatusText=function(t,s){return s.$keyChain||""},o);function o(t,s){this.$init(t,s,!1)}function i(t){return typeof t=="object"&&t.bindKey&&t.bindKey.position||(t.isDefault?-100:0)}C(e,a=n);var a,r=e;function e(t,s){return t=a.call(this,t,s)||this,t.$singleCommand=!0,t}r.call=function(t,s,c){n.prototype.$init.call(t,s,c,!0)},n.call=function(t,s,c){n.prototype.$init.call(t,s,c,!1)},f.HashHandler=r,f.MultiHashHandler=n}),ace.define("ace/commands/command_manager",["require","exports","module","ace/lib/oop","ace/keyboard/hash_handler","ace/lib/event_emitter"],function(l,f,R){var y,C,n=this&&this.__extends||(y=function(i,a){return(y=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(r,e){r.__proto__=e}:function(r,e){for(var t in e)Object.prototype.hasOwnProperty.call(e,t)&&(r[t]=e[t])}))(i,a)},function(i,a){if(typeof a!="function"&&a!==null)throw new TypeError("Class extends value "+String(a)+" is not a constructor or null");function r(){this.constructor=i}y(i,a),i.prototype=a===null?Object.create(a):(r.prototype=a.prototype,new r)}),d=l("../lib/oop"),h=l("../keyboard/hash_handler").MultiHashHandler,l=l("../lib/event_emitter").EventEmitter,n=(n(o,C=h),o.prototype.exec=function(i,a,r){if(Array.isArray(i)){for(var e=i.length;e--;)if(this.exec(i[e],a,r))return!0;return!1}var t;return!!(i=typeof i=="string"?this.commands[i]:i)&&!(a&&a.$readOnly&&!i.readOnly||this.$checkCommandState!=0&&i.isAvailable&&!i.isAvailable(a)||((t={editor:a,command:i,args:r}).returnValue=this._emit("exec",t),this._signal("afterExec",t),t.returnValue===!1))},o.prototype.toggleRecording=function(i){if(!this.$inReplay)return i&&i._emit("changeStatus"),this.recording?(this.macro.pop(),this.off("exec",this.$addCommandToMacro),this.macro.length||(this.macro=this.oldMacro),this.recording=!1):(this.$addCommandToMacro||(this.$addCommandToMacro=(function(a){this.macro.push([a.command,a.args])}).bind(this)),this.oldMacro=this.macro,this.macro=[],this.on("exec",this.$addCommandToMacro),this.recording=!0)},o.prototype.replay=function(i){if(!this.$inReplay&&this.macro){if(this.recording)return this.toggleRecording(i);try{this.$inReplay=!0,this.macro.forEach(function(a){typeof a=="string"?this.exec(a,i):this.exec(a[0],i,a[1])},this)}finally{this.$inReplay=!1}}},o.prototype.trimMacro=function(i){return i.map(function(a){return typeof a[0]!="string"&&(a[0]=a[0].name),a=a[1]?a:a[0]})},o);function o(i,a){return a=C.call(this,a,i)||this,a.byName=a.commands,a.setDefaultHandler("exec",function(r){return r.args?r.command.exec(r.editor,r.args,r.event,!1):r.command.exec(r.editor,{},r.event,!0)}),a}d.implement(n.prototype,l),f.CommandManager=n}),ace.define("ace/commands/default_commands",["require","exports","module","ace/lib/lang","ace/config","ace/range"],function(A,f,R){var y=A("../lib/lang"),C=A("../config"),d=A("../range").Range;function h(n,o){return{win:n,mac:o}}f.commands=[{name:"showSettingsMenu",description:"Show settings menu",bindKey:h("Ctrl-,","Command-,"),exec:function(n){C.loadModule("ace/ext/settings_menu",function(o){o.init(n),n.showSettingsMenu()})},readOnly:!0},{name:"goToNextError",description:"Go to next error",bindKey:h("Alt-E","F4"),exec:function(n){C.loadModule("ace/ext/error_marker",function(o){o.showErrorMarker(n,1)})},scrollIntoView:"animate",readOnly:!0},{name:"goToPreviousError",description:"Go to previous error",bindKey:h("Alt-Shift-E","Shift-F4"),exec:function(n){C.loadModule("ace/ext/error_marker",function(o){o.showErrorMarker(n,-1)})},scrollIntoView:"animate",readOnly:!0},{name:"selectall",description:"Select all",bindKey:h("Ctrl-A","Command-A"),exec:function(n){n.selectAll()},readOnly:!0},{name:"centerselection",description:"Center selection",bindKey:h(null,"Ctrl-L"),exec:function(n){n.centerSelection()},readOnly:!0},{name:"gotoline",description:"Go to line...",bindKey:h("Ctrl-L","Command-L"),exec:function(n,o){typeof o!="number"||isNaN(o)||n.gotoLine(o),n.prompt({$type:"gotoLine"})},readOnly:!0},{name:"fold",bindKey:h("Alt-L|Ctrl-F1","Command-Alt-L|Command-F1"),exec:function(n){n.session.toggleFold(!1)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"unfold",bindKey:h("Alt-Shift-L|Ctrl-Shift-F1","Command-Alt-Shift-L|Command-Shift-F1"),exec:function(n){n.session.toggleFold(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleFoldWidget",description:"Toggle fold widget",bindKey:h("F2","F2"),exec:function(n){n.session.toggleFoldWidget()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"toggleParentFoldWidget",description:"Toggle parent fold widget",bindKey:h("Alt-F2","Alt-F2"),exec:function(n){n.session.toggleFoldWidget(!0)},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"foldall",description:"Fold all",bindKey:h(null,"Ctrl-Command-Option-0"),exec:function(n){n.session.foldAll()},scrollIntoView:"center",readOnly:!0},{name:"foldAllComments",description:"Fold all comments",bindKey:h(null,"Ctrl-Command-Option-0"),exec:function(n){n.session.foldAllComments()},scrollIntoView:"center",readOnly:!0},{name:"foldOther",description:"Fold other",bindKey:h("Alt-0","Command-Option-0"),exec:function(n){n.session.foldAll(),n.session.unfold(n.selection.getAllRanges())},scrollIntoView:"center",readOnly:!0},{name:"unfoldall",description:"Unfold all",bindKey:h("Alt-Shift-0","Command-Option-Shift-0"),exec:function(n){n.session.unfold()},scrollIntoView:"center",readOnly:!0},{name:"findnext",description:"Find next",bindKey:h("Ctrl-K","Command-G"),exec:function(n){n.findNext()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"findprevious",description:"Find previous",bindKey:h("Ctrl-Shift-K","Command-Shift-G"),exec:function(n){n.findPrevious()},multiSelectAction:"forEach",scrollIntoView:"center",readOnly:!0},{name:"selectOrFindNext",description:"Select or find next",bindKey:h("Alt-K","Ctrl-G"),exec:function(n){n.selection.isEmpty()?n.selection.selectWord():n.findNext()},readOnly:!0},{name:"selectOrFindPrevious",description:"Select or find previous",bindKey:h("Alt-Shift-K","Ctrl-Shift-G"),exec:function(n){n.selection.isEmpty()?n.selection.selectWord():n.findPrevious()},readOnly:!0},{name:"find",description:"Find",bindKey:h("Ctrl-F","Command-F"),exec:function(n){C.loadModule("ace/ext/searchbox",function(o){o.Search(n)})},readOnly:!0},{name:"overwrite",description:"Overwrite",bindKey:"Insert",exec:function(n){n.toggleOverwrite()},readOnly:!0},{name:"selecttostart",description:"Select to start",bindKey:h("Ctrl-Shift-Home","Command-Shift-Home|Command-Shift-Up"),exec:function(n){n.getSelection().selectFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotostart",description:"Go to start",bindKey:h("Ctrl-Home","Command-Home|Command-Up"),exec:function(n){n.navigateFileStart()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectup",description:"Select up",bindKey:h("Shift-Up","Shift-Up|Ctrl-Shift-P"),exec:function(n){n.getSelection().selectUp()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golineup",description:"Go line up",bindKey:h("Up","Up|Ctrl-P"),exec:function(n,o){n.navigateUp(o.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttoend",description:"Select to end",bindKey:h("Ctrl-Shift-End","Command-Shift-End|Command-Shift-Down"),exec:function(n){n.getSelection().selectFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"gotoend",description:"Go to end",bindKey:h("Ctrl-End","Command-End|Command-Down"),exec:function(n){n.navigateFileEnd()},multiSelectAction:"forEach",readOnly:!0,scrollIntoView:"animate",aceCommandGroup:"fileJump"},{name:"selectdown",description:"Select down",bindKey:h("Shift-Down","Shift-Down|Ctrl-Shift-N"),exec:function(n){n.getSelection().selectDown()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"golinedown",description:"Go line down",bindKey:h("Down","Down|Ctrl-N"),exec:function(n,o){n.navigateDown(o.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordleft",description:"Select word left",bindKey:h("Ctrl-Shift-Left","Option-Shift-Left"),exec:function(n){n.getSelection().selectWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordleft",description:"Go to word left",bindKey:h("Ctrl-Left","Option-Left"),exec:function(n){n.navigateWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolinestart",description:"Select to line start",bindKey:h("Alt-Shift-Left","Command-Shift-Left|Ctrl-Shift-A"),exec:function(n){n.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolinestart",description:"Go to line start",bindKey:h("Alt-Left|Home","Command-Left|Home|Ctrl-A"),exec:function(n){n.navigateLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectleft",description:"Select left",bindKey:h("Shift-Left","Shift-Left|Ctrl-Shift-B"),exec:function(n){n.getSelection().selectLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoleft",description:"Go to left",bindKey:h("Left","Left|Ctrl-B"),exec:function(n,o){n.navigateLeft(o.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectwordright",description:"Select word right",bindKey:h("Ctrl-Shift-Right","Option-Shift-Right"),exec:function(n){n.getSelection().selectWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotowordright",description:"Go to word right",bindKey:h("Ctrl-Right","Option-Right"),exec:function(n){n.navigateWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selecttolineend",description:"Select to line end",bindKey:h("Alt-Shift-Right","Command-Shift-Right|Shift-End|Ctrl-Shift-E"),exec:function(n){n.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotolineend",description:"Go to line end",bindKey:h("Alt-Right|End","Command-Right|End|Ctrl-E"),exec:function(n){n.navigateLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectright",description:"Select right",bindKey:h("Shift-Right","Shift-Right"),exec:function(n){n.getSelection().selectRight()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"gotoright",description:"Go to right",bindKey:h("Right","Right|Ctrl-F"),exec:function(n,o){n.navigateRight(o.times)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectpagedown",description:"Select page down",bindKey:"Shift-PageDown",exec:function(n){n.selectPageDown()},readOnly:!0},{name:"pagedown",description:"Page down",bindKey:h(null,"Option-PageDown"),exec:function(n){n.scrollPageDown()},readOnly:!0},{name:"gotopagedown",description:"Go to page down",bindKey:h("PageDown","PageDown|Ctrl-V"),exec:function(n){n.gotoPageDown()},readOnly:!0},{name:"selectpageup",description:"Select page up",bindKey:"Shift-PageUp",exec:function(n){n.selectPageUp()},readOnly:!0},{name:"pageup",description:"Page up",bindKey:h(null,"Option-PageUp"),exec:function(n){n.scrollPageUp()},readOnly:!0},{name:"gotopageup",description:"Go to page up",bindKey:"PageUp",exec:function(n){n.gotoPageUp()},readOnly:!0},{name:"scrollup",description:"Scroll up",bindKey:h("Ctrl-Up",null),exec:function(n){n.renderer.scrollBy(0,-2*n.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"scrolldown",description:"Scroll down",bindKey:h("Ctrl-Down",null),exec:function(n){n.renderer.scrollBy(0,2*n.renderer.layerConfig.lineHeight)},readOnly:!0},{name:"selectlinestart",description:"Select line start",bindKey:"Shift-Home",exec:function(n){n.getSelection().selectLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"selectlineend",description:"Select line end",bindKey:"Shift-End",exec:function(n){n.getSelection().selectLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"togglerecording",description:"Toggle recording",bindKey:h("Ctrl-Alt-E","Command-Option-E"),exec:function(n){n.commands.toggleRecording(n)},readOnly:!0},{name:"replaymacro",description:"Replay macro",bindKey:h("Ctrl-Shift-E","Command-Shift-E"),exec:function(n){n.commands.replay(n)},readOnly:!0},{name:"jumptomatching",description:"Jump to matching",bindKey:h("Ctrl-\\|Ctrl-P","Command-\\"),exec:function(n){n.jumpToMatching()},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"selecttomatching",description:"Select to matching",bindKey:h("Ctrl-Shift-\\|Ctrl-Shift-P","Command-Shift-\\"),exec:function(n){n.jumpToMatching(!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"expandToMatching",description:"Expand to matching",bindKey:h("Ctrl-Shift-M","Ctrl-Shift-M"),exec:function(n){n.jumpToMatching(!0,!0)},multiSelectAction:"forEach",scrollIntoView:"animate",readOnly:!0},{name:"passKeysToBrowser",description:"Pass keys to browser",bindKey:h(null,null),exec:function(){},passEvent:!0,readOnly:!0},{name:"copy",description:"Copy",exec:function(n){},readOnly:!0},{name:"cut",description:"Cut",exec:function(n){var o=n.$copyWithEmptySelection&&n.selection.isEmpty()?n.selection.getLineRange():n.selection.getRange();n._emit("cut",o),o.isEmpty()||n.session.remove(o),n.clearSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"paste",description:"Paste",exec:function(n,o){n.$handlePaste(o)},scrollIntoView:"cursor"},{name:"removeline",description:"Remove line",bindKey:h("Ctrl-D","Command-D"),exec:function(n){n.removeLines()},scrollIntoView:"cursor",multiSelectAction:"forEachLine"},{name:"duplicateSelection",description:"Duplicate selection",bindKey:h("Ctrl-Shift-D","Command-Shift-D"),exec:function(n){n.duplicateSelection()},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"sortlines",description:"Sort lines",bindKey:h("Ctrl-Alt-S","Command-Alt-S"),exec:function(n){n.sortLines()},scrollIntoView:"selection",multiSelectAction:"forEachLine"},{name:"togglecomment",description:"Toggle comment",bindKey:h("Ctrl-/","Command-/"),exec:function(n){n.toggleCommentLines()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"toggleBlockComment",description:"Toggle block comment",bindKey:h("Ctrl-Shift-/","Command-Shift-/"),exec:function(n){n.toggleBlockComment()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"modifyNumberUp",description:"Modify number up",bindKey:h("Ctrl-Shift-Up","Alt-Shift-Up"),exec:function(n){n.modifyNumber(1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"modifyNumberDown",description:"Modify number down",bindKey:h("Ctrl-Shift-Down","Alt-Shift-Down"),exec:function(n){n.modifyNumber(-1)},scrollIntoView:"cursor",multiSelectAction:"forEach"},{name:"replace",description:"Replace",bindKey:h("Ctrl-H","Command-Option-F"),exec:function(n){C.loadModule("ace/ext/searchbox",function(o){o.Search(n,!0)})}},{name:"undo",description:"Undo",bindKey:h("Ctrl-Z","Command-Z"),exec:function(n){n.undo()}},{name:"redo",description:"Redo",bindKey:h("Ctrl-Shift-Z|Ctrl-Y","Command-Shift-Z|Command-Y"),exec:function(n){n.redo()}},{name:"copylinesup",description:"Copy lines up",bindKey:h("Alt-Shift-Up","Command-Option-Up"),exec:function(n){n.copyLinesUp()},scrollIntoView:"cursor"},{name:"movelinesup",description:"Move lines up",bindKey:h("Alt-Up","Option-Up"),exec:function(n){n.moveLinesUp()},scrollIntoView:"cursor"},{name:"copylinesdown",description:"Copy lines down",bindKey:h("Alt-Shift-Down","Command-Option-Down"),exec:function(n){n.copyLinesDown()},scrollIntoView:"cursor"},{name:"movelinesdown",description:"Move lines down",bindKey:h("Alt-Down","Option-Down"),exec:function(n){n.moveLinesDown()},scrollIntoView:"cursor"},{name:"del",description:"Delete",bindKey:h("Delete","Delete|Ctrl-D|Shift-Delete"),exec:function(n){n.remove("right")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"backspace",description:"Backspace",bindKey:h("Shift-Backspace|Backspace","Ctrl-Backspace|Shift-Backspace|Backspace|Ctrl-H"),exec:function(n){n.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"cut_or_delete",description:"Cut or delete",bindKey:h("Shift-Delete",null),exec:function(n){if(!n.selection.isEmpty())return!1;n.remove("left")},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestart",description:"Remove to line start",bindKey:h("Alt-Backspace","Command-Backspace"),exec:function(n){n.removeToLineStart()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineend",description:"Remove to line end",bindKey:h("Alt-Delete","Ctrl-K|Command-Delete"),exec:function(n){n.removeToLineEnd()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolinestarthard",description:"Remove to line start hard",bindKey:h("Ctrl-Shift-Backspace",null),exec:function(n){var o=n.selection.getRange();o.start.column=0,n.session.remove(o)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removetolineendhard",description:"Remove to line end hard",bindKey:h("Ctrl-Shift-Delete",null),exec:function(n){var o=n.selection.getRange();o.end.column=Number.MAX_VALUE,n.session.remove(o)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordleft",description:"Remove word left",bindKey:h("Ctrl-Backspace","Alt-Backspace|Ctrl-Alt-Backspace"),exec:function(n){n.removeWordLeft()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"removewordright",description:"Remove word right",bindKey:h("Ctrl-Delete","Alt-Delete"),exec:function(n){n.removeWordRight()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"outdent",description:"Outdent",bindKey:h("Shift-Tab","Shift-Tab"),exec:function(n){n.blockOutdent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"indent",description:"Indent",bindKey:h("Tab","Tab"),exec:function(n){n.indent()},multiSelectAction:"forEach",scrollIntoView:"selectionPart"},{name:"blockoutdent",description:"Block outdent",bindKey:h("Ctrl-[","Ctrl-["),exec:function(n){n.blockOutdent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"blockindent",description:"Block indent",bindKey:h("Ctrl-]","Ctrl-]"),exec:function(n){n.blockIndent()},multiSelectAction:"forEachLine",scrollIntoView:"selectionPart"},{name:"insertstring",description:"Insert string",exec:function(n,o){n.insert(o)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"inserttext",description:"Insert text",exec:function(n,o){n.insert(y.stringRepeat(o.text||"",o.times||1))},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"splitline",description:"Split line",bindKey:h(null,"Ctrl-O"),exec:function(n){n.splitLine()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"transposeletters",description:"Transpose letters",bindKey:h("Alt-Shift-X","Ctrl-T"),exec:function(n){n.transposeLetters()},multiSelectAction:function(n){n.transposeSelections(1)},scrollIntoView:"cursor"},{name:"touppercase",description:"To uppercase",bindKey:h("Ctrl-U","Ctrl-U"),exec:function(n){n.toUpperCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"tolowercase",description:"To lowercase",bindKey:h("Ctrl-Shift-U","Ctrl-Shift-U"),exec:function(n){n.toLowerCase()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"autoindent",description:"Auto Indent",bindKey:h(null,null),exec:function(n){n.autoIndent()},multiSelectAction:"forEachLine",scrollIntoView:"animate"},{name:"expandtoline",description:"Expand to line",bindKey:h("Ctrl-Shift-L","Command-Shift-L"),exec:function(n){var o=n.selection.getRange();o.start.column=o.end.column=0,o.end.row++,n.selection.setRange(o,!1)},multiSelectAction:"forEach",scrollIntoView:"cursor",readOnly:!0},{name:"openlink",bindKey:h("Ctrl+F3","F3"),exec:function(n){n.openLink()}},{name:"joinlines",description:"Join lines",bindKey:h(null,null),exec:function(n){for(var a=n.selection.isBackwards(),o=a?n.selection.getSelectionLead():n.selection.getSelectionAnchor(),i=a?n.selection.getSelectionAnchor():n.selection.getSelectionLead(),a=n.session.doc.getLine(o.row).length,r=n.session.doc.getTextRange(n.selection.getRange()).replace(/\n\s*/," ").length,e=n.session.doc.getLine(o.row),t=o.row+1;t<=i.row+1;t++){var s=y.stringTrimLeft(y.stringTrimRight(n.session.doc.getLine(t)));e+=s=s.length!==0?" "+s:s}i.row+1<n.session.doc.getLength()-1&&(e+=n.session.doc.getNewLineCharacter()),n.clearSelection(),n.session.doc.replace(new d(o.row,0,i.row+2,0),e),0<r?(n.selection.moveCursorTo(o.row,o.column),n.selection.selectTo(o.row,o.column+r)):(a=n.session.doc.getLine(o.row).length>a?a+1:a,n.selection.moveCursorTo(o.row,a))},multiSelectAction:"forEach",readOnly:!0},{name:"invertSelection",description:"Invert selection",bindKey:h(null,null),exec:function(n){var o=n.session.doc.getLength()-1,i=n.session.doc.getLine(o).length,a=n.selection.rangeList.ranges,r=[];a.length<1&&(a=[n.selection.getRange()]);for(var e=0;e<a.length;e++)e!=a.length-1||a[e].end.row===o&&a[e].end.column===i||r.push(new d(a[e].end.row,a[e].end.column,o,i)),e===0?a[e].start.row===0&&a[e].start.column===0||r.push(new d(0,0,a[e].start.row,a[e].start.column)):r.push(new d(a[e-1].end.row,a[e-1].end.column,a[e].start.row,a[e].start.column));for(n.exitMultiSelectMode(),n.clearSelection(),e=0;e<r.length;e++)n.selection.addRange(r[e],!1)},readOnly:!0,scrollIntoView:"none"},{name:"addLineAfter",description:"Add new line after the current line",exec:function(n){n.selection.clearSelection(),n.navigateLineEnd(),n.insert(`
`)},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"addLineBefore",description:"Add new line before the current line",exec:function(n){n.selection.clearSelection();var o=n.getCursorPosition();n.selection.moveTo(o.row-1,Number.MAX_VALUE),n.insert(`
`),o.row===0&&n.navigateUp()},multiSelectAction:"forEach",scrollIntoView:"cursor"},{name:"openCommandPallete",exec:function(n){console.warn("This is an obsolete command. Please use `openCommandPalette` instead."),n.prompt({$type:"commands"})},readOnly:!0},{name:"openCommandPalette",description:"Open command palette",bindKey:h("F1","F1"),exec:function(n){n.prompt({$type:"commands"})},readOnly:!0},{name:"modeSelect",description:"Change language mode...",bindKey:h(null,null),exec:function(n){n.prompt({$type:"modes"})},readOnly:!0}];for(var l=1;l<9;l++)f.commands.push({name:"foldToLevel"+l,description:"Fold To Level "+l,level:l,exec:function(n){n.session.foldToLevel(this.level)},scrollIntoView:"center",readOnly:!0})}),ace.define("ace/line_widgets",["require","exports","module","ace/lib/dom"],function(A,f,R){var y=A("./lib/dom");function C(d){this.session=d,(this.session.widgetManager=this).session.getRowLength=this.getRowLength,this.session.$getWidgetScreenLength=this.$getWidgetScreenLength,this.updateOnChange=this.updateOnChange.bind(this),this.renderWidgets=this.renderWidgets.bind(this),this.measureWidgets=this.measureWidgets.bind(this),this.session._changedWidgets=[],this.$onChangeEditor=this.$onChangeEditor.bind(this),this.session.on("change",this.updateOnChange),this.session.on("changeFold",this.updateOnFold),this.session.on("changeEditor",this.$onChangeEditor)}C.prototype.getRowLength=function(d){var h=this.lineWidgets&&this.lineWidgets[d]&&this.lineWidgets[d].rowCount||0;return this.$useWrapMode&&this.$wrapData[d]?this.$wrapData[d].length+1+h:1+h},C.prototype.$getWidgetScreenLength=function(){var d=0;return this.lineWidgets.forEach(function(h){h&&h.rowCount&&!h.hidden&&(d+=h.rowCount)}),d},C.prototype.$onChangeEditor=function(d){this.attach(d.editor)},C.prototype.attach=function(d){d&&d.widgetManager&&d.widgetManager!=this&&d.widgetManager.detach(),this.editor!=d&&(this.detach(),this.editor=d)&&(d.widgetManager=this,d.renderer.on("beforeRender",this.measureWidgets),d.renderer.on("afterRender",this.renderWidgets))},C.prototype.detach=function(d){var h=this.editor;h&&(this.editor=null,h.widgetManager=null,h.renderer.off("beforeRender",this.measureWidgets),h.renderer.off("afterRender",this.renderWidgets),h=this.session.lineWidgets)&&h.forEach(function(l){l&&l.el&&l.el.parentNode&&(l._inDocument=!1,l.el.parentNode.removeChild(l.el))})},C.prototype.updateOnFold=function(d,h){var l=h.lineWidgets;if(l&&d.action){for(var h=d.data,n=h.start.row,o=h.end.row,i=d.action=="add",a=n+1;a<o;a++)l[a]&&(l[a].hidden=i);l[o]&&(i?l[n]?l[o].hidden=i:l[n]=l[o]:(l[n]==l[o]&&(l[n]=void 0),l[o].hidden=i))}},C.prototype.updateOnChange=function(d){var h,l,n,o=this.session.lineWidgets;o&&(h=d.start.row,(l=d.end.row-h)!=0)&&(d.action=="remove"?(n=o.splice(h+1,l),!o[h]&&n[n.length-1]&&(o[h]=n.pop()),n.forEach(function(i){i&&this.removeLineWidget(i)},this)):(n=new Array(l),o[h]&&o[h].column!=null&&d.start.column>o[h].column&&h++,n.unshift(h,0),o.splice.apply(o,n)),this.$updateRows())},C.prototype.$updateRows=function(){var d,h=this.session.lineWidgets;h&&(d=!0,h.forEach(function(l,n){if(l)for(d=!1,l.row=n;l.$oldWidget;)l.$oldWidget.row=n,l=l.$oldWidget}),d)&&(this.session.lineWidgets=null)},C.prototype.$registerLineWidget=function(d){this.session.lineWidgets||(this.session.lineWidgets=new Array(this.session.getLength()));var h=this.session.lineWidgets[d.row];return h&&(d.$oldWidget=h).el&&h.el.parentNode&&(h.el.parentNode.removeChild(h.el),h._inDocument=!1),this.session.lineWidgets[d.row]=d},C.prototype.addLineWidget=function(d){var h,l,n;return this.$registerLineWidget(d),d.session=this.session,this.editor&&(h=this.editor.renderer,d.html&&!d.el&&(d.el=y.createElement("div"),d.el.innerHTML=d.html),d.text&&!d.el&&(d.el=y.createElement("div"),d.el.textContent=d.text),d.el&&(y.addCssClass(d.el,"ace_lineWidgetContainer"),d.className&&y.addCssClass(d.el,d.className),d.el.style.position="absolute",d.el.style.zIndex=5,h.container.appendChild(d.el),d._inDocument=!0,d.coverGutter||(d.el.style.zIndex=3),d.pixelHeight==null)&&(d.pixelHeight=d.el.offsetHeight),d.rowCount==null&&(d.rowCount=d.pixelHeight/h.layerConfig.lineHeight),l=this.session.getFoldAt(d.row,0),(d.$fold=l)&&(n=this.session.lineWidgets,d.row!=l.end.row||n[l.start.row]?d.hidden=!0:n[l.start.row]=d),this.session._emit("changeFold",{data:{start:{row:d.row}}}),this.$updateRows(),this.renderWidgets(null,h),this.onWidgetChanged(d)),d},C.prototype.removeLineWidget=function(d){if(d._inDocument=!1,d.session=null,d.el&&d.el.parentNode&&d.el.parentNode.removeChild(d.el),d.editor&&d.editor.destroy)try{d.editor.destroy()}catch{}if(this.session.lineWidgets){var h=this.session.lineWidgets[d.row];if(h==d)this.session.lineWidgets[d.row]=d.$oldWidget,d.$oldWidget&&this.onWidgetChanged(d.$oldWidget);else for(;h;){if(h.$oldWidget==d){h.$oldWidget=d.$oldWidget;break}h=h.$oldWidget}}this.session._emit("changeFold",{data:{start:{row:d.row}}}),this.$updateRows()},C.prototype.getWidgetsAtRow=function(d){for(var h=this.session.lineWidgets,l=h&&h[d],n=[];l;)n.push(l),l=l.$oldWidget;return n},C.prototype.onWidgetChanged=function(d){this.session._changedWidgets.push(d),this.editor&&this.editor.renderer.updateFull()},C.prototype.measureWidgets=function(d,h){var l=this.session._changedWidgets,n=h.layerConfig;if(l&&l.length){for(var o=1/0,i=0;i<l.length;i++){var a=l[i];if(a&&a.el&&a.session==this.session){if(!a._inDocument){if(this.session.lineWidgets[a.row]!=a)continue;a._inDocument=!0,h.container.appendChild(a.el)}a.h=a.el.offsetHeight,a.fixedWidth||(a.w=a.el.offsetWidth,a.screenWidth=Math.ceil(a.w/n.characterWidth));var r=a.h/n.lineHeight;a.coverLine&&(r-=this.session.getRowLineCount(a.row))<0&&(r=0),a.rowCount!=r&&(a.rowCount=r,a.row<o)&&(o=a.row)}}o!=1/0&&(this.session._emit("changeFold",{data:{start:{row:o}}}),this.session.lineWidgetWidth=null),this.session._changedWidgets=[]}},C.prototype.renderWidgets=function(d,h){var l=h.layerConfig,n=this.session.lineWidgets;if(n){for(var o=Math.min(this.firstRow,l.firstRow),i=Math.max(this.lastRow,l.lastRow,n.length);0<o&&!n[o];)o--;this.firstRow=l.firstRow,this.lastRow=l.lastRow,h.$cursorLayer.config=l;for(var a=o;a<=i;a++){var r,e=n[a];e&&e.el&&(e.hidden?e.el.style.top=-100-(e.pixelHeight||0)+"px":(e._inDocument||(e._inDocument=!0,h.container.appendChild(e.el)),r=h.$cursorLayer.getPixelPosition({row:a,column:0},!0).top,e.coverLine||(r+=l.lineHeight*this.session.getRowLineCount(e.row)),e.el.style.top=r-l.offset+"px",r=e.coverGutter?0:h.gutterWidth,e.fixedWidth||(r-=h.scrollLeft),e.el.style.left=r+"px",e.fullWidth&&e.screenWidth&&(e.el.style.minWidth=l.width+2*l.padding+"px"),e.fixedWidth?e.el.style.right=h.scrollBar.getWidth()+"px":e.el.style.right=""))}}},f.LineWidgets=C}),ace.define("ace/keyboard/gutter_handler",["require","exports","module","ace/lib/keys","ace/mouse/default_gutter_handler"],function(A,f,R){var y=A("../lib/keys"),C=A("../mouse/default_gutter_handler").GutterTooltip;function d(n){this.editor=n,this.gutterLayer=n.renderer.$gutterLayer,this.element=n.renderer.$gutter,this.lines=n.renderer.$gutterLayer.$lines,this.activeRowIndex=null,this.activeLane=null,this.annotationTooltip=new C(this.editor)}d.prototype.addListener=function(){this.element.addEventListener("keydown",this.$onGutterKeyDown.bind(this)),this.element.addEventListener("focusout",this.$blurGutter.bind(this)),this.editor.on("mousewheel",this.$blurGutter.bind(this))},d.prototype.removeListener=function(){this.element.removeEventListener("keydown",this.$onGutterKeyDown.bind(this)),this.element.removeEventListener("focusout",this.$blurGutter.bind(this)),this.editor.off("mousewheel",this.$blurGutter.bind(this))},d.prototype.$onGutterKeyDown=function(n){var o;this.annotationTooltip.isOpen?(n.preventDefault(),n.keyCode===y.escape&&this.annotationTooltip.hideTooltip()):n.target===this.element?n.keyCode==y.enter&&(n.preventDefault(),o=this.editor.getCursorPosition().row,this.editor.isRowVisible(o)||this.editor.scrollToLine(o,!0,!0),setTimeout((function(){var i=this.$rowToRowIndex(this.gutterLayer.$cursorCell.row),a=this.$findNearestFoldWidget(i),r=this.$findNearestAnnotation(i);a===null&&r===null||(a===null&&r!==null||(a===null||r!==null)&&Math.abs(r-i)<Math.abs(a-i)?(this.activeRowIndex=r,this.activeLane="annotation",this.$focusAnnotation(this.activeRowIndex)):(this.activeRowIndex=a,this.activeLane="fold",this.$focusFoldWidget(this.activeRowIndex)))}).bind(this),10)):(this.$handleGutterKeyboardInteraction(n),setTimeout((function(){this.editor._signal("gutterkeydown",new h(n,this))}).bind(this),10))},d.prototype.$handleGutterKeyboardInteraction=function(n){if(n.keyCode===y.tab)n.preventDefault();else if(n.keyCode===y.escape)n.preventDefault(),this.$blurGutter(),this.element.focus(),this.lane=null;else if(n.keyCode===y.up)switch(n.preventDefault(),this.activeLane){case"fold":this.$moveFoldWidgetUp();break;case"annotation":this.$moveAnnotationUp()}else if(n.keyCode===y.down)switch(n.preventDefault(),this.activeLane){case"fold":this.$moveFoldWidgetDown();break;case"annotation":this.$moveAnnotationDown()}else if(n.keyCode===y.left)n.preventDefault(),this.$switchLane("annotation");else if(n.keyCode===y.right)n.preventDefault(),this.$switchLane("fold");else if(n.keyCode===y.enter||n.keyCode===y.space)switch(n.preventDefault(),this.activeLane){case"fold":if(this.gutterLayer.session.foldWidgets[this.$rowIndexToRow(this.activeRowIndex)]==="start"){var o=this.$rowIndexToRow(this.activeRowIndex);this.editor.session.onFoldWidgetClick(this.$rowIndexToRow(this.activeRowIndex),n),setTimeout((function(){this.$rowIndexToRow(this.activeRowIndex)!==o&&(this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=this.$rowToRowIndex(o),this.$focusFoldWidget(this.activeRowIndex))}).bind(this),10);break}if(this.gutterLayer.session.foldWidgets[this.$rowIndexToRow(this.activeRowIndex)]==="end")break;return;case"annotation":var i=this.lines.cells[this.activeRowIndex].element.childNodes[2].getBoundingClientRect(),a=this.annotationTooltip.getElement().style;a.left=i.right+"px",a.top=i.bottom+"px",this.annotationTooltip.showTooltip(this.$rowIndexToRow(this.activeRowIndex))}},d.prototype.$blurGutter=function(){if(this.activeRowIndex!==null)switch(this.activeLane){case"fold":this.$blurFoldWidget(this.activeRowIndex);break;case"annotation":this.$blurAnnotation(this.activeRowIndex)}this.annotationTooltip.isOpen&&this.annotationTooltip.hideTooltip()},d.prototype.$isFoldWidgetVisible=function(i){var o=this.editor.isRowFullyVisible(this.$rowIndexToRow(i)),i=this.$getFoldWidget(i).style.display!=="none";return o&&i},d.prototype.$isAnnotationVisible=function(i){var o=this.editor.isRowFullyVisible(this.$rowIndexToRow(i)),i=this.$getAnnotation(i).style.display!=="none";return o&&i},d.prototype.$getFoldWidget=function(n){return this.lines.get(n).element.childNodes[1]},d.prototype.$getAnnotation=function(n){return this.lines.get(n).element.childNodes[2]},d.prototype.$findNearestFoldWidget=function(n){if(this.$isFoldWidgetVisible(n))return n;for(var o=0;0<n-o||n+o<this.lines.getLength()-1;){if(0<=n-++o&&this.$isFoldWidgetVisible(n-o))return n-o;if(n+o<=this.lines.getLength()-1&&this.$isFoldWidgetVisible(n+o))return n+o}return null},d.prototype.$findNearestAnnotation=function(n){if(this.$isAnnotationVisible(n))return n;for(var o=0;0<n-o||n+o<this.lines.getLength()-1;){if(0<=n-++o&&this.$isAnnotationVisible(n-o))return n-o;if(n+o<=this.lines.getLength()-1&&this.$isAnnotationVisible(n+o))return n+o}return null},d.prototype.$focusFoldWidget=function(n){n!=null&&((n=this.$getFoldWidget(n)).classList.add(this.editor.renderer.keyboardFocusClassName),n.focus())},d.prototype.$focusAnnotation=function(n){n!=null&&((n=this.$getAnnotation(n)).classList.add(this.editor.renderer.keyboardFocusClassName),n.focus())},d.prototype.$blurFoldWidget=function(n){n=this.$getFoldWidget(n),n.classList.remove(this.editor.renderer.keyboardFocusClassName),n.blur()},d.prototype.$blurAnnotation=function(n){n=this.$getAnnotation(n),n.classList.remove(this.editor.renderer.keyboardFocusClassName),n.blur()},d.prototype.$moveFoldWidgetUp=function(){for(var n=this.activeRowIndex;0<n;)if(this.$isFoldWidgetVisible(--n))return this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=n,void this.$focusFoldWidget(this.activeRowIndex)},d.prototype.$moveFoldWidgetDown=function(){for(var n=this.activeRowIndex;n<this.lines.getLength()-1;)if(this.$isFoldWidgetVisible(++n))return this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=n,void this.$focusFoldWidget(this.activeRowIndex)},d.prototype.$moveAnnotationUp=function(){for(var n=this.activeRowIndex;0<n;)if(this.$isAnnotationVisible(--n))return this.$blurAnnotation(this.activeRowIndex),this.activeRowIndex=n,void this.$focusAnnotation(this.activeRowIndex)},d.prototype.$moveAnnotationDown=function(){for(var n=this.activeRowIndex;n<this.lines.getLength()-1;)if(this.$isAnnotationVisible(++n))return this.$blurAnnotation(this.activeRowIndex),this.activeRowIndex=n,void this.$focusAnnotation(this.activeRowIndex)},d.prototype.$switchLane=function(n){switch(n){case"annotation":this.activeLane!=="annotation"&&(o=this.$findNearestAnnotation(this.activeRowIndex))!=null&&(this.activeLane="annotation",this.$blurFoldWidget(this.activeRowIndex),this.activeRowIndex=o,this.$focusAnnotation(this.activeRowIndex));break;case"fold":var o;this.activeLane!=="fold"&&(o=this.$findNearestFoldWidget(this.activeRowIndex))!=null&&(this.activeLane="fold",this.$blurAnnotation(this.activeRowIndex),this.activeRowIndex=o,this.$focusFoldWidget(this.activeRowIndex))}},d.prototype.$rowIndexToRow=function(n){return n=this.lines.get(n),n?n.row:null},d.prototype.$rowToRowIndex=function(n){for(var o=0;o<this.lines.getLength();o++)if(this.lines.get(o).row==n)return o;return null},f.GutterKeyboardHandler=d,l.prototype.getKey=function(){return y.keyCodeToString(this.domEvent.keyCode)},l.prototype.getRow=function(){return this.gutterKeyboardHandler.$rowIndexToRow(this.gutterKeyboardHandler.activeRowIndex)},l.prototype.isInAnnotationLane=function(){return this.gutterKeyboardHandler.activeLane==="annotation"},l.prototype.isInFoldLane=function(){return this.gutterKeyboardHandler.activeLane==="fold"};var h=l;function l(n,o){this.gutterKeyboardHandler=o,this.domEvent=n}f.GutterKeyboardEvent=h}),ace.define("ace/editor",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/useragent","ace/keyboard/textinput","ace/mouse/mouse_handler","ace/mouse/fold_handler","ace/keyboard/keybinding","ace/edit_session","ace/search","ace/range","ace/lib/event_emitter","ace/commands/command_manager","ace/commands/default_commands","ace/config","ace/token_iterator","ace/line_widgets","ace/keyboard/gutter_handler","ace/config","ace/clipboard","ace/lib/keys"],function(x,f,R){var y=this&&this.__values||function(v){var $=typeof Symbol=="function"&&Symbol.iterator,P=$&&v[$],M=0;if(P)return P.call(v);if(v&&typeof v.length=="number")return{next:function(){return{value:(v=v&&M>=v.length?void 0:v)&&v[M++],done:!v}}};throw new TypeError($?"Object is not iterable.":"Symbol.iterator is not defined.")},C=x("./lib/oop"),d=x("./lib/dom"),h=x("./lib/lang"),l=x("./lib/useragent"),n=x("./keyboard/textinput").TextInput,o=x("./mouse/mouse_handler").MouseHandler,i=x("./mouse/fold_handler").FoldHandler,a=x("./keyboard/keybinding").KeyBinding,r=x("./edit_session").EditSession,e=x("./search").Search,t=x("./range").Range,s=x("./lib/event_emitter").EventEmitter,c=x("./commands/command_manager").CommandManager,p=x("./commands/default_commands").commands,g=x("./config"),b=x("./token_iterator").TokenIterator,w=x("./line_widgets").LineWidgets,E=x("./keyboard/gutter_handler").GutterKeyboardHandler,W=x("./config").nls,B=x("./clipboard"),O=x("./lib/keys"),x=(u.prototype.$initOperationListeners=function(){this.commands.on("exec",this.startOperation.bind(this),!0),this.commands.on("afterExec",this.endOperation.bind(this),!0),this.$opResetTimer=h.delayedCall(this.endOperation.bind(this,!0)),this.on("change",(function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.docChanged=!0}).bind(this),!0),this.on("changeSelection",(function(){this.curOp||(this.startOperation(),this.curOp.selectionBefore=this.$lastSel),this.curOp.selectionChanged=!0}).bind(this),!0)},u.prototype.startOperation=function(v){if(this.curOp){if(!v||this.curOp.command)return;this.prevOp=this.curOp}v||(this.previousCommand=null,v={}),this.$opResetTimer.schedule(),this.curOp=this.session.curOp={command:v.command||{},args:v.args,scrollTop:this.renderer.scrollTop},this.curOp.selectionBefore=this.selection.toJSON()},u.prototype.endOperation=function(v){if(this.curOp&&this.session){if(v&&v.returnValue===!1||!this.session)return this.curOp=null;if((v!=1||!this.curOp.command||this.curOp.command.name!="mouse")&&(this._signal("beforeEndOperation"),this.curOp)){var v=this.curOp.command,$=v&&v.scrollIntoView;if($){switch($){case"center-animate":$="animate";case"center":this.renderer.scrollCursorIntoView(null,.5);break;case"animate":case"cursor":this.renderer.scrollCursorIntoView();break;case"selectionPart":var P=this.selection.getRange(),M=this.renderer.layerConfig;(P.start.row>=M.lastRow||P.end.row<=M.firstRow)&&this.renderer.scrollSelectionIntoView(this.selection.anchor,this.selection.lead)}$=="animate"&&this.renderer.animateScrolling(this.curOp.scrollTop)}v=this.selection.toJSON(),this.curOp.selectionAfter=v,this.$lastSel=this.selection.toJSON(),this.session.getUndoManager().addSelection(v),this.prevOp=this.curOp,this.curOp=null}}},u.prototype.$historyTracker=function(v){var $,P,M,X;this.$mergeUndoDeltas&&($=this.prevOp,P=this.$mergeableCommands,M=$.command&&v.command.name==$.command.name,v.command.name=="insertstring"?(X=v.args,this.mergeNextCommand===void 0&&(this.mergeNextCommand=!0),M=M&&this.mergeNextCommand&&(!/\s/.test(X)||/\s/.test($.args)),this.mergeNextCommand=!0):M=M&&P.indexOf(v.command.name)!==-1,(M=this.$mergeUndoDeltas!="always"&&2e3<Date.now()-this.sequenceStartTime?!1:M)?this.session.mergeUndoDeltas=!0:P.indexOf(v.command.name)!==-1&&(this.sequenceStartTime=Date.now()))},u.prototype.setKeyboardHandler=function(v,$){var P;v&&typeof v=="string"&&v!="ace"?(this.$keybindingId=v,P=this,g.loadModule(["keybinding",v],function(M){P.$keybindingId==v&&P.keyBinding.setKeyboardHandler(M&&M.handler),$&&$()})):(this.$keybindingId=null,this.keyBinding.setKeyboardHandler(v),$&&$())},u.prototype.getKeyboardHandler=function(){return this.keyBinding.getKeyboardHandler()},u.prototype.setSession=function(v){var $,P;this.session!=v&&(this.curOp&&this.endOperation(),this.curOp={},($=this.session)&&(this.session.off("change",this.$onDocumentChange),this.session.off("changeMode",this.$onChangeMode),this.session.off("tokenizerUpdate",this.$onTokenizerUpdate),this.session.off("changeTabSize",this.$onChangeTabSize),this.session.off("changeWrapLimit",this.$onChangeWrapLimit),this.session.off("changeWrapMode",this.$onChangeWrapMode),this.session.off("changeFold",this.$onChangeFold),this.session.off("changeFrontMarker",this.$onChangeFrontMarker),this.session.off("changeBackMarker",this.$onChangeBackMarker),this.session.off("changeBreakpoint",this.$onChangeBreakpoint),this.session.off("changeAnnotation",this.$onChangeAnnotation),this.session.off("changeOverwrite",this.$onCursorChange),this.session.off("changeScrollTop",this.$onScrollTopChange),this.session.off("changeScrollLeft",this.$onScrollLeftChange),(P=this.session.getSelection()).off("changeCursor",this.$onCursorChange),P.off("changeSelection",this.$onSelectionChange)),(this.session=v)?(this.$onDocumentChange=this.onDocumentChange.bind(this),v.on("change",this.$onDocumentChange),this.renderer.setSession(v),this.$onChangeMode=this.onChangeMode.bind(this),v.on("changeMode",this.$onChangeMode),this.$onTokenizerUpdate=this.onTokenizerUpdate.bind(this),v.on("tokenizerUpdate",this.$onTokenizerUpdate),this.$onChangeTabSize=this.renderer.onChangeTabSize.bind(this.renderer),v.on("changeTabSize",this.$onChangeTabSize),this.$onChangeWrapLimit=this.onChangeWrapLimit.bind(this),v.on("changeWrapLimit",this.$onChangeWrapLimit),this.$onChangeWrapMode=this.onChangeWrapMode.bind(this),v.on("changeWrapMode",this.$onChangeWrapMode),this.$onChangeFold=this.onChangeFold.bind(this),v.on("changeFold",this.$onChangeFold),this.$onChangeFrontMarker=this.onChangeFrontMarker.bind(this),this.session.on("changeFrontMarker",this.$onChangeFrontMarker),this.$onChangeBackMarker=this.onChangeBackMarker.bind(this),this.session.on("changeBackMarker",this.$onChangeBackMarker),this.$onChangeBreakpoint=this.onChangeBreakpoint.bind(this),this.session.on("changeBreakpoint",this.$onChangeBreakpoint),this.$onChangeAnnotation=this.onChangeAnnotation.bind(this),this.session.on("changeAnnotation",this.$onChangeAnnotation),this.$onCursorChange=this.onCursorChange.bind(this),this.session.on("changeOverwrite",this.$onCursorChange),this.$onScrollTopChange=this.onScrollTopChange.bind(this),this.session.on("changeScrollTop",this.$onScrollTopChange),this.$onScrollLeftChange=this.onScrollLeftChange.bind(this),this.session.on("changeScrollLeft",this.$onScrollLeftChange),this.selection=v.getSelection(),this.selection.on("changeCursor",this.$onCursorChange),this.$onSelectionChange=this.onSelectionChange.bind(this),this.selection.on("changeSelection",this.$onSelectionChange),this.onChangeMode(),this.onCursorChange(),this.onScrollTopChange(),this.onScrollLeftChange(),this.onSelectionChange(),this.onChangeFrontMarker(),this.onChangeBackMarker(),this.onChangeBreakpoint(),this.onChangeAnnotation(),this.session.getUseWrapMode()&&this.renderer.adjustWrapLimit(),this.renderer.updateFull()):(this.selection=null,this.renderer.setSession(v)),this._signal("changeSession",{session:v,oldSession:$}),this.curOp=null,$&&$._signal("changeEditor",{oldEditor:this}),v&&v._signal("changeEditor",{editor:this}),v)&&!v.destroyed&&v.bgTokenizer.scheduleStart()},u.prototype.getSession=function(){return this.session},u.prototype.setValue=function(v,$){return this.session.doc.setValue(v),$?$==1?this.navigateFileEnd():$==-1&&this.navigateFileStart():this.selectAll(),v},u.prototype.getValue=function(){return this.session.getValue()},u.prototype.getSelection=function(){return this.selection},u.prototype.resize=function(v){this.renderer.onResize(v)},u.prototype.setTheme=function(v,$){this.renderer.setTheme(v,$)},u.prototype.getTheme=function(){return this.renderer.getTheme()},u.prototype.setStyle=function(v){this.renderer.setStyle(v)},u.prototype.unsetStyle=function(v){this.renderer.unsetStyle(v)},u.prototype.getFontSize=function(){return this.getOption("fontSize")||d.computedStyle(this.container).fontSize},u.prototype.setFontSize=function(v){this.setOption("fontSize",v)},u.prototype.$highlightBrackets=function(){var v;this.$highlightPending||((v=this).$highlightPending=!0,setTimeout(function(){v.$highlightPending=!1;var $,P,M,X,Q=v.session;Q&&!Q.destroyed&&(Q.$bracketHighlight&&(Q.$bracketHighlight.markerIds.forEach(function(K){Q.removeMarker(K)}),Q.$bracketHighlight=null),$=v.getCursorPosition(),P=(P=v.getKeyboardHandler())&&P.$getDirectionForHighlight&&P.$getDirectionForHighlight(v),(P=Q.getMatchingBracketRanges($,P))||(M=new b(Q,$.row,$.column).getCurrentToken())&&/\b(?:tag-open|tag-name)/.test(M.type)&&(M=Q.getMatchingTags($))&&(P=[M.openTagName,M.closeTagName]),(P=!P&&Q.$mode.getMatching?Q.$mode.getMatching(v.session):P)&&(X="ace_bracket",Array.isArray(P)?P.length==1&&(X="ace_error_bracket"):P=[P],P.length==2&&(t.comparePoints(P[0].end,P[1].start)==0?P=[t.fromPoints(P[0].start,P[1].end)]:t.comparePoints(P[0].start,P[1].end)==0&&(P=[t.fromPoints(P[1].start,P[0].end)])),Q.$bracketHighlight={ranges:P,markerIds:P.map(function(K){return Q.addMarker(K,X,"text")})}),v.getHighlightIndentGuides())&&v.renderer.$textLayer.$highlightIndentGuide()},50))},u.prototype.focus=function(){this.textInput.focus()},u.prototype.isFocused=function(){return this.textInput.isFocused()},u.prototype.blur=function(){this.textInput.blur()},u.prototype.onFocus=function(v){this.$isFocused||(this.$isFocused=!0,this.renderer.showCursor(),this.renderer.visualizeFocus(),this._emit("focus",v))},u.prototype.onBlur=function(v){this.$isFocused&&(this.$isFocused=!1,this.renderer.hideCursor(),this.renderer.visualizeBlur(),this._emit("blur",v))},u.prototype.$cursorChange=function(){this.renderer.updateCursor(),this.$highlightBrackets(),this.$updateHighlightActiveLine()},u.prototype.onDocumentChange=function(v){var $=this.session.$useWrapMode,P=v.start.row==v.end.row?v.end.row:1/0;this.renderer.updateLines(v.start.row,P,$),this._signal("change",v),this.$cursorChange()},u.prototype.onTokenizerUpdate=function(v){v=v.data,this.renderer.updateLines(v.first,v.last)},u.prototype.onScrollTopChange=function(){this.renderer.scrollToY(this.session.getScrollTop())},u.prototype.onScrollLeftChange=function(){this.renderer.scrollToX(this.session.getScrollLeft())},u.prototype.onCursorChange=function(){this.$cursorChange(),this._signal("changeSelection")},u.prototype.$updateHighlightActiveLine=function(){var v,$,P=this.getSession();this.$highlightActiveLine&&(this.$selectionStyle=="line"&&this.selection.isMultiLine()||(v=this.getCursorPosition()),this.renderer.theme&&this.renderer.theme.$selectionColorConflict&&!this.selection.isEmpty()&&(v=!1),!this.renderer.$maxLines||this.session.getLength()!==1||1<this.renderer.$minLines||(v=!1)),P.$highlightLineMarker&&!v?(P.removeMarker(P.$highlightLineMarker.id),P.$highlightLineMarker=null):!P.$highlightLineMarker&&v?(($=new t(v.row,v.column,v.row,1/0)).id=P.addMarker($,"ace_active-line","screenLine"),P.$highlightLineMarker=$):v&&(P.$highlightLineMarker.start.row=v.row,P.$highlightLineMarker.end.row=v.row,P.$highlightLineMarker.start.column=v.column,P._signal("changeBackMarker"))},u.prototype.onSelectionChange=function(v){var $,P,M=this.session,M=(M.$selectionMarker&&M.removeMarker(M.$selectionMarker),M.$selectionMarker=null,this.selection.isEmpty()?this.$updateHighlightActiveLine():($=this.selection.getRange(),P=this.getSelectionStyle(),M.$selectionMarker=M.addMarker($,"ace_selection",P)),this.$highlightSelectedWord&&this.$getSelectionHighLightRegexp());this.session.highlight(M),this._signal("changeSelection")},u.prototype.$getSelectionHighLightRegexp=function(){var v=this.session,$=this.getSelectionRange();if(!$.isEmpty()&&!$.isMultiLine()){var P=$.start.column,M=$.end.column,v=v.getLine($.start.row),$=v.substring(P,M);if(!(5e3<$.length)&&/[\w\d]/.test($)&&($=this.$search.$assembleRegExp({wholeWord:!0,caseSensitive:!0,needle:$}),v=v.substring(P-1,M+1),$.test(v)))return $}},u.prototype.onChangeFrontMarker=function(){this.renderer.updateFrontMarkers()},u.prototype.onChangeBackMarker=function(){this.renderer.updateBackMarkers()},u.prototype.onChangeBreakpoint=function(){this.renderer.updateBreakpoints()},u.prototype.onChangeAnnotation=function(){this.renderer.setAnnotations(this.session.getAnnotations())},u.prototype.onChangeMode=function(v){this.renderer.updateText(),this._emit("changeMode",v)},u.prototype.onChangeWrapLimit=function(){this.renderer.updateFull()},u.prototype.onChangeWrapMode=function(){this.renderer.onResize(!0)},u.prototype.onChangeFold=function(){this.$updateHighlightActiveLine(),this.renderer.updateFull()},u.prototype.getSelectedText=function(){return this.session.getTextRange(this.getSelectionRange())},u.prototype.getCopyText=function(){var v=this.getSelectedText(),$=this.session.doc.getNewLineCharacter(),P=!1;if(!v&&this.$copyWithEmptySelection)for(var P=!0,M=this.selection.getAllRanges(),X=0;X<M.length;X++){var Q=M[X];X&&M[X-1].start.row==Q.start.row||(v+=this.session.getLine(Q.start.row)+$)}var K={text:v};return this._signal("copy",K),B.lineMode=!!P&&K.text,K.text},u.prototype.onCopy=function(){this.commands.exec("copy",this)},u.prototype.onCut=function(){this.commands.exec("cut",this)},u.prototype.onPaste=function(v,$){this.commands.exec("paste",this,{text:v,event:$})},u.prototype.$handlePaste=function(P){this._signal("paste",P=typeof P=="string"?{text:P}:P);var $=P.text,P=$===B.lineMode,M=this.session;if(!this.inMultiSelectMode||this.inVirtualSelectionMode)P?M.insert({row:this.selection.lead.row,column:0},$):this.insert($);else if(P)this.selection.rangeList.ranges.forEach(function(T){M.insert({row:T.start.row,column:0},$)});else{var X=$.split(/\r\n|\r|\n/),Q=this.selection.rangeList.ranges,P=!(X.length!=2||X[0]&&X[1]);if(X.length!=Q.length||P)return this.commands.exec("insertstring",this,$);for(var K=Q.length;K--;){var ne=Q[K];ne.isEmpty()||M.remove(ne),M.insert(ne.start,X[K])}}},u.prototype.execCommand=function(v,$){return this.commands.exec(v,this,$)},u.prototype.insert=function(v,ne){var P,M=this.session,X=M.getMode(),Q=this.getCursorPosition(),K=(this.getBehavioursEnabled()&&!ne&&(P=X.transformAction(M.getState(Q.row),"insertion",this,M,v))&&(v===P.text||this.inVirtualSelectionMode||(this.session.mergeUndoDeltas=!1,this.mergeNextCommand=!1),v=P.text),v=="	"&&(v=this.session.getTabString()),this.selection.isEmpty()?this.session.getOverwrite()&&v.indexOf(`
`)==-1&&((K=new t.fromPoints(Q,Q)).end.column+=v.length,this.session.remove(K)):(K=this.getSelectionRange(),Q=this.session.remove(K),this.clearSelection()),v!=`
`&&v!=`\r
`||(T=M.getLine(Q.row),Q.column>T.search(/\S|$/)&&(ne=T.substr(Q.column).search(/\S|$/),M.doc.removeInLine(Q.row,Q.column,Q.column+ne))),this.clearSelection(),Q.column),ne=M.getState(Q.row),T=M.getLine(Q.row),F=X.checkOutdent(ne,T,v);M.insert(Q,v),P&&P.selection&&(P.selection.length==2?this.selection.setSelectionRange(new t(Q.row,K+P.selection[0],Q.row,K+P.selection[1])):this.selection.setSelectionRange(new t(Q.row+P.selection[0],P.selection[1],Q.row+P.selection[2],P.selection[3]))),this.$enableAutoIndent&&(M.getDocument().isNewLine(v)&&(K=X.getNextLineIndent(ne,T.slice(0,Q.column),M.getTabString()),M.insert({row:Q.row+1,column:0},K)),F)&&X.autoOutdent(ne,M,Q.row)},u.prototype.autoIndent=function(){for(var v,$,P,M,X,Q=this.session,K=Q.getMode(),ne=(P=this.selection.isEmpty()?($=0,Q.doc.getLength()-1):($=(v=this.getSelectionRange()).start.row,v.end.row),""),T="",F=Q.getTabString(),V=$;V<=P;V++)0<V&&(ne=Q.getState(V-1),M=Q.getLine(V-1),T=K.getNextLineIndent(ne,M,F)),M=Q.getLine(V),T!==(X=K.$getIndent(M))&&(0<X.length&&(X=new t(V,0,V,X.length),Q.remove(X)),0<T.length)&&Q.insert({row:V,column:0},T),K.autoOutdent(ne,Q,V)},u.prototype.onTextInput=function(v,$){if(!$)return this.keyBinding.onTextInput(v);this.startOperation({command:{name:"insertstring"}}),v=this.applyComposition.bind(this,v,$),this.selection.rangeCount?this.forEachSelection(v):v(),this.endOperation()},u.prototype.applyComposition=function(v,$){var P;($.extendLeft||$.extendRight)&&((P=this.selection.getRange()).start.column-=$.extendLeft,P.end.column+=$.extendRight,P.start.column<0&&(P.start.row--,P.start.column+=this.session.getLine(P.start.row).length+1),this.selection.setRange(P),v||P.isEmpty()||this.remove()),!v&&this.selection.isEmpty()||this.insert(v,!0),($.restoreStart||$.restoreEnd)&&((P=this.selection.getRange()).start.column-=$.restoreStart,P.end.column-=$.restoreEnd,this.selection.setRange(P))},u.prototype.onCommandKey=function(v,$,P){return this.keyBinding.onCommandKey(v,$,P)},u.prototype.setOverwrite=function(v){this.session.setOverwrite(v)},u.prototype.getOverwrite=function(){return this.session.getOverwrite()},u.prototype.toggleOverwrite=function(){this.session.toggleOverwrite()},u.prototype.setScrollSpeed=function(v){this.setOption("scrollSpeed",v)},u.prototype.getScrollSpeed=function(){return this.getOption("scrollSpeed")},u.prototype.setDragDelay=function(v){this.setOption("dragDelay",v)},u.prototype.getDragDelay=function(){return this.getOption("dragDelay")},u.prototype.setSelectionStyle=function(v){this.setOption("selectionStyle",v)},u.prototype.getSelectionStyle=function(){return this.getOption("selectionStyle")},u.prototype.setHighlightActiveLine=function(v){this.setOption("highlightActiveLine",v)},u.prototype.getHighlightActiveLine=function(){return this.getOption("highlightActiveLine")},u.prototype.setHighlightGutterLine=function(v){this.setOption("highlightGutterLine",v)},u.prototype.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},u.prototype.setHighlightSelectedWord=function(v){this.setOption("highlightSelectedWord",v)},u.prototype.getHighlightSelectedWord=function(){return this.$highlightSelectedWord},u.prototype.setAnimatedScroll=function(v){this.renderer.setAnimatedScroll(v)},u.prototype.getAnimatedScroll=function(){return this.renderer.getAnimatedScroll()},u.prototype.setShowInvisibles=function(v){this.renderer.setShowInvisibles(v)},u.prototype.getShowInvisibles=function(){return this.renderer.getShowInvisibles()},u.prototype.setDisplayIndentGuides=function(v){this.renderer.setDisplayIndentGuides(v)},u.prototype.getDisplayIndentGuides=function(){return this.renderer.getDisplayIndentGuides()},u.prototype.setHighlightIndentGuides=function(v){this.renderer.setHighlightIndentGuides(v)},u.prototype.getHighlightIndentGuides=function(){return this.renderer.getHighlightIndentGuides()},u.prototype.setShowPrintMargin=function(v){this.renderer.setShowPrintMargin(v)},u.prototype.getShowPrintMargin=function(){return this.renderer.getShowPrintMargin()},u.prototype.setPrintMarginColumn=function(v){this.renderer.setPrintMarginColumn(v)},u.prototype.getPrintMarginColumn=function(){return this.renderer.getPrintMarginColumn()},u.prototype.setReadOnly=function(v){this.setOption("readOnly",v)},u.prototype.getReadOnly=function(){return this.getOption("readOnly")},u.prototype.setBehavioursEnabled=function(v){this.setOption("behavioursEnabled",v)},u.prototype.getBehavioursEnabled=function(){return this.getOption("behavioursEnabled")},u.prototype.setWrapBehavioursEnabled=function(v){this.setOption("wrapBehavioursEnabled",v)},u.prototype.getWrapBehavioursEnabled=function(){return this.getOption("wrapBehavioursEnabled")},u.prototype.setShowFoldWidgets=function(v){this.setOption("showFoldWidgets",v)},u.prototype.getShowFoldWidgets=function(){return this.getOption("showFoldWidgets")},u.prototype.setFadeFoldWidgets=function(v){this.setOption("fadeFoldWidgets",v)},u.prototype.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},u.prototype.remove=function(X){this.selection.isEmpty()&&(X=="left"?this.selection.selectLeft():this.selection.selectRight());var $,P,M,X=this.getSelectionRange();this.getBehavioursEnabled()&&(P=($=this.session).getState(X.start.row),P=$.getMode().transformAction(P,"deletion",this,$,X),X.end.column===0&&(M=$.getTextRange(X))[M.length-1]==`
`&&(M=$.getLine(X.end.row),/^\s+$/.test(M))&&(X.end.column=M.length),P)&&(X=P),this.session.remove(X),this.clearSelection()},u.prototype.removeWordRight=function(){this.selection.isEmpty()&&this.selection.selectWordRight(),this.session.remove(this.getSelectionRange()),this.clearSelection()},u.prototype.removeWordLeft=function(){this.selection.isEmpty()&&this.selection.selectWordLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},u.prototype.removeToLineStart=function(){this.selection.isEmpty()&&this.selection.selectLineStart(),this.selection.isEmpty()&&this.selection.selectLeft(),this.session.remove(this.getSelectionRange()),this.clearSelection()},u.prototype.removeToLineEnd=function(){this.selection.isEmpty()&&this.selection.selectLineEnd();var v=this.getSelectionRange();v.start.column==v.end.column&&v.start.row==v.end.row&&(v.end.column=0,v.end.row++),this.session.remove(v),this.clearSelection()},u.prototype.splitLine=function(){this.selection.isEmpty()||(this.session.remove(this.getSelectionRange()),this.clearSelection());var v=this.getCursorPosition();this.insert(`
`),this.moveCursorToPosition(v)},u.prototype.setGhostText=function(v,$){this.session.widgetManager||(this.session.widgetManager=new w(this.session),this.session.widgetManager.attach(this)),this.renderer.setGhostText(v,$)},u.prototype.removeGhostText=function(){this.session.widgetManager&&this.renderer.removeGhostText()},u.prototype.transposeLetters=function(){var v,$,P,M;this.selection.isEmpty()&&($=(v=this.getCursorPosition()).column)!==0&&(M=$<(M=this.session.getLine(v.row)).length?(P=M.charAt($)+M.charAt($-1),new t(v.row,$-1,v.row,$+1)):(P=M.charAt($-1)+M.charAt($-2),new t(v.row,$-2,v.row,$)),this.session.replace(M,P),this.session.selection.moveToPosition(M.end))},u.prototype.toLowerCase=function(){var v=this.getSelectionRange(),$=(this.selection.isEmpty()&&this.selection.selectWord(),this.getSelectionRange()),P=this.session.getTextRange($);this.session.replace($,P.toLowerCase()),this.selection.setSelectionRange(v)},u.prototype.toUpperCase=function(){var v=this.getSelectionRange(),$=(this.selection.isEmpty()&&this.selection.selectWord(),this.getSelectionRange()),P=this.session.getTextRange($);this.session.replace($,P.toUpperCase()),this.selection.setSelectionRange(v)},u.prototype.indent=function(){var v=this.session,$=this.getSelectionRange();if(!($.start.row<$.end.row)){if($.start.column<$.end.column){var P,Q=v.getTextRange($);if(!/^\s+$/.test(Q))return P=this.$getSelectedRows(),void v.indentRows(P.first,P.last,"	")}var M=v.getLine($.start.row),Q=$.start,X=v.getTabSize(),Q=v.documentToScreenColumn(Q.row,Q.column);if(this.session.getUseSoftTabs())var K=X-Q%X,ne=h.stringRepeat(" ",K);else{for(K=Q%X;M[$.start.column-1]==" "&&K;)$.start.column--,K--;this.selection.setSelectionRange($),ne="	"}return this.insert(ne)}P=this.$getSelectedRows(),v.indentRows(P.first,P.last,"	")},u.prototype.blockIndent=function(){var v=this.$getSelectedRows();this.session.indentRows(v.first,v.last,"	")},u.prototype.blockOutdent=function(){var v=this.session.getSelection();this.session.outdentRows(v.getRange())},u.prototype.sortLines=function(){for(var v=this.$getSelectedRows(),$=this.session,P=[],M=v.first;M<=v.last;M++)P.push($.getLine(M));P.sort(function(K,ne){return K.toLowerCase()<ne.toLowerCase()?-1:K.toLowerCase()>ne.toLowerCase()?1:0});for(var X=new t(0,0,0,0),M=v.first;M<=v.last;M++){var Q=$.getLine(M);X.start.row=M,X.end.row=M,X.end.column=Q.length,$.replace(X,P[M-v.first])}},u.prototype.toggleCommentLines=function(){var v=this.session.getState(this.getCursorPosition().row),$=this.$getSelectedRows();this.session.getMode().toggleCommentLines(v,this.session,$.first,$.last)},u.prototype.toggleBlockComment=function(){var v=this.getCursorPosition(),$=this.session.getState(v.row),P=this.getSelectionRange();this.session.getMode().toggleBlockComment($,this.session,P,v)},u.prototype.getNumberAt=function(v,$){for(var P=/[\-]?[0-9]+(?:\.[0-9]+)?/g,M=(P.lastIndex=0,this.session.getLine(v));P.lastIndex<$;){var X=P.exec(M);if(X.index<=$&&X.index+X[0].length>=$)return{value:X[0],start:X.index,end:X.index+X[0].length}}return null},u.prototype.modifyNumber=function(v){var $,P,M,X=this.selection.getCursor().row,Q=this.selection.getCursor().column,K=new t(X,Q-1,X,Q),K=this.session.getTextRange(K);!isNaN(parseFloat(K))&&isFinite(K)?(K=this.getNumberAt(X,Q))&&(M=0<=K.value.indexOf(".")?K.start+K.value.indexOf(".")+1:K.end,$=K.start+K.value.length-M,P=parseFloat(K.value),P*=Math.pow(10,$),M!==K.end&&Q<M?v*=Math.pow(10,K.end-Q-1):v*=Math.pow(10,K.end-Q),M=(P=(P+=v)/Math.pow(10,$)).toFixed($),v=new t(X,K.start,X,K.end),this.session.replace(v,M),this.moveCursorTo(X,Math.max(K.start+1,Q+M.length-K.value.length))):this.toggleWord()},u.prototype.toggleWord=function(){for(var v,$=this.selection.getCursor().row,P=this.selection.getCursor().column,M=(this.selection.selectWord(),this.getSelectedText()),X=this.selection.getWordRange().start.column,Q=M.replace(/([a-z]+|[A-Z]+)(?=[A-Z_]|$)/g,"$1 ").split(/\s/),K=P-X-1,ne=(K<0&&(K=0),0),T=this,F=(M.match(/[A-Za-z0-9_]+/)&&Q.forEach(function(J,re){v=ne+J.length,ne<=K&&K<=v&&(M=J,T.selection.clearSelection(),T.moveCursorTo($,ne+X),T.selection.selectTo($,v+X)),ne=v}),this.$toggleWordPairs),V=0;V<F.length;V++)for(var I=F[V],S=0;S<=1;S++){var L=+!S,Z=M.match(new RegExp("^\\s?_?("+h.escapeRegExp(I[S])+")\\s?$","i"));Z&&M.match(new RegExp("([_]|^|\\s)("+h.escapeRegExp(Z[1])+")($|\\s)","g"))&&(Z=M.replace(new RegExp(h.escapeRegExp(I[S]),"i"),function(J){var re=I[L];return J.toUpperCase()==J?re=re.toUpperCase():J.charAt(0).toUpperCase()==J.charAt(0)&&(re=re.substr(0,0)+I[L].charAt(0).toUpperCase()+re.substr(1)),re}),this.insert(Z))}},u.prototype.findLinkAt=function(Q,$){var P,M,X,Q=this.session.getLine(Q).split(/((?:https?|ftp):\/\/[\S]+)/),K=$,ne=(K<0&&(K=0),0);try{for(var T=y(Q),F=T.next();!F.done;F=T.next()){var V=F.value,I=ne+V.length;if(ne<=K&&K<=I&&V.match(/((?:https?|ftp):\/\/[\S]+)/)){X=V.replace(/[\s:.,'";}\]]+$/,"");break}ne=I}}catch(S){P={error:S}}finally{try{F&&!F.done&&(M=T.return)&&M.call(T)}finally{if(P)throw P.error}}return X},u.prototype.openLink=function(){var v=this.selection.getCursor(),v=this.findLinkAt(v.row,v.column);return v&&window.open(v,"_blank"),v!=null},u.prototype.removeLines=function(){var v=this.$getSelectedRows();this.session.removeFullLines(v.first,v.last),this.clearSelection()},u.prototype.duplicateSelection=function(){var v,$=this.selection,P=this.session,M=$.getRange(),X=$.isBackwards();M.isEmpty()?(v=M.start.row,P.duplicateLines(v,v)):(v=X?M.start:M.end,P=P.insert(v,P.getTextRange(M),!1),M.start=v,M.end=P,$.setSelectionRange(M,X))},u.prototype.moveLinesDown=function(){this.$moveLines(1,!1)},u.prototype.moveLinesUp=function(){this.$moveLines(-1,!1)},u.prototype.moveText=function(v,$,P){return this.session.moveText(v,$,P)},u.prototype.copyLinesUp=function(){this.$moveLines(-1,!0)},u.prototype.copyLinesDown=function(){this.$moveLines(1,!0)},u.prototype.$moveLines=function(v,$){var P=this.selection;if(!P.inMultiSelectMode||this.inVirtualSelectionMode){var M=P.toOrientedRange(),X=this.$getSelectedRows(M),Q=this.session.$moveLines(X.first,X.last,$?0:v);M.moveBy(Q=$&&v==-1?0:Q,0),P.fromOrientedRange(M)}else{for(var K=P.rangeList.ranges,ne=(P.rangeList.detach(this.session),this.inVirtualSelectionMode=!0,0),T=0,F=K.length,V=0;V<F;V++){for(var I=V,S=(K[V].moveBy(ne,0),(X=this.$getSelectedRows(K[V])).first),L=X.last;++V<F;){T&&K[V].moveBy(T,0);var Z=this.$getSelectedRows(K[V]);if($&&Z.first!=L||!$&&Z.first>L+1)break;L=Z.last}for(V--,ne=this.session.$moveLines(S,L,$?0:v),$&&v==-1&&(I=V+1);I<=V;)K[I].moveBy(ne,0),I++;T+=ne=$?ne:0}P.fromOrientedRange(P.ranges[0]),P.rangeList.attach(this.session),this.inVirtualSelectionMode=!1}},u.prototype.$getSelectedRows=function(v){return v=(v||this.getSelectionRange()).collapseRows(),{first:this.session.getRowFoldStart(v.start.row),last:this.session.getRowFoldEnd(v.end.row)}},u.prototype.onCompositionStart=function(v){this.renderer.showComposition(v)},u.prototype.onCompositionUpdate=function(v){this.renderer.setCompositionText(v)},u.prototype.onCompositionEnd=function(){this.renderer.hideComposition()},u.prototype.getFirstVisibleRow=function(){return this.renderer.getFirstVisibleRow()},u.prototype.getLastVisibleRow=function(){return this.renderer.getLastVisibleRow()},u.prototype.isRowVisible=function(v){return v>=this.getFirstVisibleRow()&&v<=this.getLastVisibleRow()},u.prototype.isRowFullyVisible=function(v){return v>=this.renderer.getFirstFullyVisibleRow()&&v<=this.renderer.getLastFullyVisibleRow()},u.prototype.$getVisibleRowCount=function(){return this.renderer.getScrollBottomRow()-this.renderer.getScrollTopRow()+1},u.prototype.$moveByPage=function(Q,$){var P=this.renderer,M=this.renderer.layerConfig,X=Q*Math.floor(M.height/M.lineHeight),Q=($===!0?this.selection.$moveSelection(function(){this.moveCursorBy(X,0)}):$===!1&&(this.selection.moveCursorBy(X,0),this.selection.clearSelection()),P.scrollTop);P.scrollBy(0,X*M.lineHeight),$!=null&&P.scrollCursorIntoView(null,.5),P.animateScrolling(Q)},u.prototype.selectPageDown=function(){this.$moveByPage(1,!0)},u.prototype.selectPageUp=function(){this.$moveByPage(-1,!0)},u.prototype.gotoPageDown=function(){this.$moveByPage(1,!1)},u.prototype.gotoPageUp=function(){this.$moveByPage(-1,!1)},u.prototype.scrollPageDown=function(){this.$moveByPage(1)},u.prototype.scrollPageUp=function(){this.$moveByPage(-1)},u.prototype.scrollToRow=function(v){this.renderer.scrollToRow(v)},u.prototype.scrollToLine=function(v,$,P,M){this.renderer.scrollToLine(v,$,P,M)},u.prototype.centerSelection=function(){var v=this.getSelectionRange(),v={row:Math.floor(v.start.row+(v.end.row-v.start.row)/2),column:Math.floor(v.start.column+(v.end.column-v.start.column)/2)};this.renderer.alignCursor(v,.5)},u.prototype.getCursorPosition=function(){return this.selection.getCursor()},u.prototype.getCursorPositionScreen=function(){return this.session.documentToScreenPosition(this.getCursorPosition())},u.prototype.getSelectionRange=function(){return this.selection.getRange()},u.prototype.selectAll=function(){this.selection.selectAll()},u.prototype.clearSelection=function(){this.selection.clearSelection()},u.prototype.moveCursorTo=function(v,$){this.selection.moveCursorTo(v,$)},u.prototype.moveCursorToPosition=function(v){this.selection.moveCursorToPosition(v)},u.prototype.jumpToMatching=function(v,$){var P=this.getCursorPosition(),M=new b(this.session,P.row,P.column),X=M.getCurrentToken(),Q=0,K=(X=X&&X.type.indexOf("tag-name")!==-1?M.stepBackward():X)||M.stepForward();if(K){var ne,T,F=!1,V={},I=P.column-K.start,S={")":"(","(":"(","]":"[","[":"[","{":"{","}":"{"};do if(K.value.match(/[{}()\[\]]/g)){for(;I<K.value.length&&!F;I++)if(S[K.value[I]])switch(T=S[K.value[I]]+"."+K.type.replace("rparen","lparen"),isNaN(V[T])&&(V[T]=0),K.value[I]){case"(":case"[":case"{":V[T]++;break;case")":case"]":case"}":V[T]--,V[T]===-1&&(ne="bracket",F=!0)}}else K.type.indexOf("tag-name")!==-1&&(isNaN(V[K.value])&&(V[K.value]=0),X.value==="<"&&1<Q?V[K.value]++:X.value==="</"&&V[K.value]--,V[K.value]===-1)&&(ne="tag",F=!0);while(F||(X=K,Q++,K=M.stepForward(),I=0),K&&!F);if(ne){if(ne==="bracket")!(Z=this.session.getBracketRange(P))&&(J=(Z=new t(M.getCurrentTokenRow(),M.getCurrentTokenColumn()+I-1,M.getCurrentTokenRow(),M.getCurrentTokenColumn()+I-1)).start,$||J.row===P.row&&Math.abs(J.column-P.column)<2)&&(Z=this.session.getBracketRange(J));else if(ne==="tag"){if(!K||K.type.indexOf("tag-name")===-1)return;var L,Z,J=(J=(Z=new t(M.getCurrentTokenRow(),M.getCurrentTokenColumn()-2,M.getCurrentTokenRow(),M.getCurrentTokenColumn()-2)).compare(P.row,P.column)===0&&(L=this.session.getMatchingTags(P))?L.openTag.contains(P.row,P.column)?(Z=L.closeTag).start:(Z=L.openTag,L.closeTag.start.row===P.row&&L.closeTag.start.column===P.column?Z.end:Z.start):J)||Z.start}(J=Z&&Z.cursor||J)&&(v?Z&&$?this.selection.setRange(Z):Z&&Z.isEqual(this.getSelectionRange())?this.clearSelection():this.selection.selectTo(J.row,J.column):this.selection.moveTo(J.row,J.column))}}},u.prototype.gotoLine=function(v,$,P){this.selection.clearSelection(),this.session.unfold({row:v-1,column:$||0}),this.exitMultiSelectMode&&this.exitMultiSelectMode(),this.moveCursorTo(v-1,$||0),this.isRowFullyVisible(v-1)||this.scrollToLine(v-1,!0,P)},u.prototype.navigateTo=function(v,$){this.selection.moveTo(v,$)},u.prototype.navigateUp=function(v){var $;if(this.selection.isMultiLine()&&!this.selection.isBackwards())return $=this.selection.anchor.getPosition(),this.moveCursorToPosition($);this.selection.clearSelection(),this.selection.moveCursorBy(-v||-1,0)},u.prototype.navigateDown=function(v){var $;if(this.selection.isMultiLine()&&this.selection.isBackwards())return $=this.selection.anchor.getPosition(),this.moveCursorToPosition($);this.selection.clearSelection(),this.selection.moveCursorBy(v||1,0)},u.prototype.navigateLeft=function(v){if(this.selection.isEmpty())for(v=v||1;v--;)this.selection.moveCursorLeft();else{var $=this.getSelectionRange().start;this.moveCursorToPosition($)}this.clearSelection()},u.prototype.navigateRight=function(v){if(this.selection.isEmpty())for(v=v||1;v--;)this.selection.moveCursorRight();else{var $=this.getSelectionRange().end;this.moveCursorToPosition($)}this.clearSelection()},u.prototype.navigateLineStart=function(){this.selection.moveCursorLineStart(),this.clearSelection()},u.prototype.navigateLineEnd=function(){this.selection.moveCursorLineEnd(),this.clearSelection()},u.prototype.navigateFileEnd=function(){this.selection.moveCursorFileEnd(),this.clearSelection()},u.prototype.navigateFileStart=function(){this.selection.moveCursorFileStart(),this.clearSelection()},u.prototype.navigateWordRight=function(){this.selection.moveCursorWordRight(),this.clearSelection()},u.prototype.navigateWordLeft=function(){this.selection.moveCursorWordLeft(),this.clearSelection()},u.prototype.replace=function(v,P){P&&this.$search.set(P);var P=this.$search.find(this.session),M=0;return P&&(this.$tryReplace(P,v)&&(M=1),this.selection.setSelectionRange(P),this.renderer.scrollSelectionIntoView(P.start,P.end)),M},u.prototype.replaceAll=function(v,$){$&&this.$search.set($);var P=this.$search.findAll(this.session),M=0;if(P.length){$=this.getSelectionRange(),this.selection.moveTo(0,0);for(var X=P.length-1;0<=X;--X)this.$tryReplace(P[X],v)&&M++;this.selection.setSelectionRange($)}return M},u.prototype.$tryReplace=function(v,$){var P=this.session.getTextRange(v);return($=this.$search.replace(P,$))!==null?(v.end=this.session.replace(v,$),v):null},u.prototype.getLastSearchOptions=function(){return this.$search.getOptions()},u.prototype.find=function(X,$,P){$=$||{},typeof X=="string"||X instanceof RegExp?$.needle=X:typeof X=="object"&&C.mixin($,X);var M=this.selection.getRange(),X=($.needle==null&&((X=this.session.getTextRange(M)||this.$search.$options.needle)||(M=this.session.getWordRange(M.start.row,M.start.column),X=this.session.getTextRange(M)),this.$search.set({needle:X})),this.$search.set($),$.start||this.$search.set({start:M}),this.$search.find(this.session));return $.preventScroll?X:X?(this.revealRange(X,P),X):($.backwards?M.start=M.end:M.end=M.start,void this.selection.setRange(M))},u.prototype.findNext=function(v,$){this.find({skipCurrent:!0,backwards:!1},v,$)},u.prototype.findPrevious=function(v,$){this.find(v,{skipCurrent:!0,backwards:!0},$)},u.prototype.revealRange=function(v,$){this.session.unfold(v),this.selection.setSelectionRange(v);var P=this.renderer.scrollTop;this.renderer.scrollSelectionIntoView(v.start,v.end,.5),$!==!1&&this.renderer.animateScrolling(P)},u.prototype.undo=function(){this.session.getUndoManager().undo(this.session),this.renderer.scrollCursorIntoView(null,.5)},u.prototype.redo=function(){this.session.getUndoManager().redo(this.session),this.renderer.scrollCursorIntoView(null,.5)},u.prototype.destroy=function(){this.$toDestroy&&(this.$toDestroy.forEach(function(v){v.destroy()}),this.$toDestroy=null),this.$mouseHandler&&this.$mouseHandler.destroy(),this.renderer.destroy(),this._signal("destroy",this),this.session&&this.session.destroy(),this._$emitInputEvent&&this._$emitInputEvent.cancel(),this.removeAllListeners()},u.prototype.setAutoScrollEditorIntoView=function(v){var $,P,M,X,Q,K,ne;v&&(M=!1,(P=this).$scrollAnchor||(this.$scrollAnchor=document.createElement("div")),(X=this.$scrollAnchor).style.cssText="position:absolute",this.container.insertBefore(X,this.container.firstChild),Q=this.on("changeSelection",function(){M=!0}),K=this.renderer.on("beforeRender",function(){M&&($=P.renderer.container.getBoundingClientRect())}),ne=this.renderer.on("afterRender",function(){var T,F,V;M&&$&&(P.isFocused()||P.searchBox&&P.searchBox.isFocused())&&(T=(F=P.renderer).$cursorLayer.$pixelPos,F=F.layerConfig,V=T.top-F.offset,(M=0<=T.top&&V+$.top<0||!(T.top<F.height&&T.top+$.top+F.lineHeight>window.innerHeight)&&null)!=null&&(X.style.top=V+"px",X.style.left=T.left+"px",X.style.height=F.lineHeight+"px",X.scrollIntoView(M)),M=$=null)}),this.setAutoScrollEditorIntoView=function(T){T||(delete this.setAutoScrollEditorIntoView,this.off("changeSelection",Q),this.renderer.off("afterRender",ne),this.renderer.off("beforeRender",K))})},u.prototype.$resetCursorStyle=function(){var v=this.$cursorStyle||"ace",$=this.renderer.$cursorLayer;$&&($.setSmoothBlinking(/smooth/.test(v)),$.isBlinking=!this.$readOnly&&v!="wide",d.setCssClass($.element,"ace_slim-cursors",/slim/.test(v)))},u.prototype.prompt=function(v,$,P){var M=this;g.loadModule("ace/ext/prompt",function(X){X.prompt(M,v,$,P)})},u);function u(v,$,P){this.$toDestroy=[];var M=v.getContainerElement();this.container=M,this.renderer=v,this.id="editor"+ ++u.$uid,this.commands=new c(l.isMac?"mac":"win",p),typeof document=="object"&&(this.textInput=new n(v.getTextAreaContainer(),this),this.renderer.textarea=this.textInput.getElement(),this.$mouseHandler=new o(this),new i(this)),this.keyBinding=new a(this),this.$search=new e().set({wrap:!0}),this.$historyTracker=this.$historyTracker.bind(this),this.commands.on("exec",this.$historyTracker),this.$initOperationListeners(),this._$emitInputEvent=h.delayedCall((function(){this._signal("input",{}),this.session&&!this.session.destroyed&&this.session.bgTokenizer.scheduleStart()}).bind(this)),this.on("change",function(X,Q){Q._$emitInputEvent.schedule(31)}),this.setSession($||P&&P.session||new r("")),g.resetOptions(this),P&&this.setOptions(P),g._signal("editor",this)}x.$uid=0,x.prototype.curOp=null,x.prototype.prevOp={},x.prototype.$mergeableCommands=["backspace","del","insertstring"],x.prototype.$toggleWordPairs=[["first","last"],["true","false"],["yes","no"],["width","height"],["top","bottom"],["right","left"],["on","off"],["x","y"],["get","set"],["max","min"],["horizontal","vertical"],["show","hide"],["add","remove"],["up","down"],["before","after"],["even","odd"],["in","out"],["inside","outside"],["next","previous"],["increase","decrease"],["attach","detach"],["&&","||"],["==","!="]],C.implement(x.prototype,s),g.defineOptions(x.prototype,"editor",{selectionStyle:{set:function(v){this.onSelectionChange(),this._signal("changeSelectionStyle",{data:v})},initialValue:"line"},highlightActiveLine:{set:function(){this.$updateHighlightActiveLine()},initialValue:!0},highlightSelectedWord:{set:function(v){this.$onSelectionChange()},initialValue:!0},readOnly:{set:function(v){this.textInput.setReadOnly(v),this.$resetCursorStyle()},initialValue:!1},copyWithEmptySelection:{set:function(v){this.textInput.setCopyWithEmptySelection(v)},initialValue:!1},cursorStyle:{set:function(v){this.$resetCursorStyle()},values:["ace","slim","smooth","wide"],initialValue:"ace"},mergeUndoDeltas:{values:[!1,!0,"always"],initialValue:!0},behavioursEnabled:{initialValue:!0},wrapBehavioursEnabled:{initialValue:!0},enableAutoIndent:{initialValue:!0},autoScrollEditorIntoView:{set:function(v){this.setAutoScrollEditorIntoView(v)}},keyboardHandler:{set:function(v){this.setKeyboardHandler(v)},get:function(){return this.$keybindingId},handlesSet:!0},value:{set:function(v){this.session.setValue(v)},get:function(){return this.getValue()},handlesSet:!0,hidden:!0},session:{set:function(v){this.setSession(v)},get:function(){return this.session},handlesSet:!0,hidden:!0},showLineNumbers:{set:function(v){this.renderer.$gutterLayer.setShowLineNumbers(v),this.renderer.$loop.schedule(this.renderer.CHANGE_GUTTER),v&&this.$relativeLineNumbers?_.attach(this):_.detach(this)},initialValue:!0},relativeLineNumbers:{set:function(v){this.$showLineNumbers&&v?_.attach(this):_.detach(this)}},placeholder:{set:function(v){this.$updatePlaceholder||(this.$updatePlaceholder=(function(){var $=this.session&&(this.renderer.$composition||1<this.session.getLength()||0<this.session.getLine(0).length);$&&this.renderer.placeholderNode?(this.renderer.off("afterRender",this.$updatePlaceholder),d.removeCssClass(this.container,"ace_hasPlaceholder"),this.renderer.placeholderNode.remove(),this.renderer.placeholderNode=null):$||this.renderer.placeholderNode?!$&&this.renderer.placeholderNode&&(this.renderer.placeholderNode.textContent=this.$placeholder||""):(this.renderer.on("afterRender",this.$updatePlaceholder),d.addCssClass(this.container,"ace_hasPlaceholder"),($=d.createElement("div")).className="ace_placeholder",$.textContent=this.$placeholder||"",this.renderer.placeholderNode=$,this.renderer.content.appendChild(this.renderer.placeholderNode))}).bind(this),this.on("input",this.$updatePlaceholder)),this.$updatePlaceholder()}},enableKeyboardAccessibility:{set:function(v){function $(X){X.target==this.renderer.scroller&&X.keyCode===O.enter&&(X.preventDefault(),X=this.getCursorPosition().row,this.isRowVisible(X)||this.scrollToLine(X,!0,!0),this.focus())}var P,M={name:"blurTextInput",description:"Set focus to the editor content div to allow tabbing through the page",bindKey:"Esc",exec:function(X){X.blur(),X.renderer.scroller.focus()},readOnly:!0};v?(this.renderer.enableKeyboardAccessibility=!0,this.renderer.keyboardFocusClassName="ace_keyboard-focus",this.textInput.getElement().setAttribute("tabindex",-1),this.textInput.setNumberOfExtraLines(l.isWin?3:0),this.renderer.scroller.setAttribute("tabindex",0),this.renderer.scroller.setAttribute("role","group"),this.renderer.scroller.setAttribute("aria-roledescription",W("editor")),this.renderer.scroller.classList.add(this.renderer.keyboardFocusClassName),this.renderer.scroller.setAttribute("aria-label",W("Editor content, press Enter to start editing, press Escape to exit")),this.renderer.scroller.addEventListener("keyup",$.bind(this)),this.commands.addCommand(M),this.renderer.$gutter.setAttribute("tabindex",0),this.renderer.$gutter.setAttribute("aria-hidden",!1),this.renderer.$gutter.setAttribute("role","group"),this.renderer.$gutter.setAttribute("aria-roledescription",W("editor")),this.renderer.$gutter.setAttribute("aria-label",W("Editor gutter, press Enter to interact with controls using arrow keys, press Escape to exit")),this.renderer.$gutter.classList.add(this.renderer.keyboardFocusClassName),this.renderer.content.setAttribute("aria-hidden",!0),(P=P||new E(this)).addListener()):(this.renderer.enableKeyboardAccessibility=!1,this.textInput.getElement().setAttribute("tabindex",0),this.textInput.setNumberOfExtraLines(0),this.renderer.scroller.setAttribute("tabindex",-1),this.renderer.scroller.removeAttribute("role"),this.renderer.scroller.removeAttribute("aria-roledescription"),this.renderer.scroller.classList.remove(this.renderer.keyboardFocusClassName),this.renderer.scroller.removeAttribute("aria-label"),this.renderer.scroller.removeEventListener("keyup",$.bind(this)),this.commands.removeCommand(M),this.renderer.content.removeAttribute("aria-hidden"),this.renderer.$gutter.setAttribute("tabindex",-1),this.renderer.$gutter.setAttribute("aria-hidden",!0),this.renderer.$gutter.removeAttribute("role"),this.renderer.$gutter.removeAttribute("aria-roledescription"),this.renderer.$gutter.removeAttribute("aria-label"),this.renderer.$gutter.classList.remove(this.renderer.keyboardFocusClassName),P&&P.removeListener())},initialValue:!1},customScrollbar:"renderer",hScrollBarAlwaysVisible:"renderer",vScrollBarAlwaysVisible:"renderer",highlightGutterLine:"renderer",animatedScroll:"renderer",showInvisibles:"renderer",showPrintMargin:"renderer",printMarginColumn:"renderer",printMargin:"renderer",fadeFoldWidgets:"renderer",showFoldWidgets:"renderer",displayIndentGuides:"renderer",highlightIndentGuides:"renderer",showGutter:"renderer",fontSize:"renderer",fontFamily:"renderer",maxLines:"renderer",minLines:"renderer",scrollPastEnd:"renderer",fixedWidthGutter:"renderer",theme:"renderer",hasCssTransforms:"renderer",maxPixelHeight:"renderer",useTextareaForIME:"renderer",useResizeObserver:"renderer",useSvgGutterIcons:"renderer",showFoldedAnnotations:"renderer",scrollSpeed:"$mouseHandler",dragDelay:"$mouseHandler",dragEnabled:"$mouseHandler",focusTimeout:"$mouseHandler",tooltipFollowsMouse:"$mouseHandler",firstLineNumber:"session",overwrite:"session",newLineMode:"session",useWorker:"session",useSoftTabs:"session",navigateWithinSoftTabs:"session",tabSize:"session",wrap:"session",indentedSoftWrap:"session",foldStyle:"session",mode:"session"});var _={getText:function(v,$){return(Math.abs(v.selection.lead.row-$)||$+1+($<9?"·":""))+""},getWidth:function(v,$,P){return Math.max($.toString().length,(P.lastRow+1).toString().length,2)*P.characterWidth},update:function(v,$){$.renderer.$loop.schedule($.renderer.CHANGE_GUTTER)},attach:function(v){v.renderer.$gutterLayer.$renderer=this,v.on("changeSelection",this.update),this.update(null,v)},detach:function(v){v.renderer.$gutterLayer.$renderer==this&&(v.renderer.$gutterLayer.$renderer=null),v.off("changeSelection",this.update),this.update(null,v)}};f.Editor=x}),ace.define("ace/layer/lines",["require","exports","module","ace/lib/dom"],function(A,f,R){var y=A("../lib/dom");function C(d,h){this.element=d,this.canvasHeight=h||5e5,this.element.style.height=2*this.canvasHeight+"px",this.cells=[],this.cellCache=[],this.$offsetCoefficient=0}C.prototype.moveContainer=function(d){y.translate(this.element,0,-(d.firstRowScreen*d.lineHeight%this.canvasHeight)-d.offset*this.$offsetCoefficient)},C.prototype.pageChanged=function(d,h){return Math.floor(d.firstRowScreen*d.lineHeight/this.canvasHeight)!==Math.floor(h.firstRowScreen*h.lineHeight/this.canvasHeight)},C.prototype.computeLineTop=function(d,h,l){var n=h.firstRowScreen*h.lineHeight,n=Math.floor(n/this.canvasHeight);return l.documentToScreenRow(d,0)*h.lineHeight-n*this.canvasHeight},C.prototype.computeLineHeight=function(d,h,l){return h.lineHeight*l.getRowLineCount(d)},C.prototype.getLength=function(){return this.cells.length},C.prototype.get=function(d){return this.cells[d]},C.prototype.shift=function(){this.$cacheCell(this.cells.shift())},C.prototype.pop=function(){this.$cacheCell(this.cells.pop())},C.prototype.push=function(d){if(Array.isArray(d)){this.cells.push.apply(this.cells,d);for(var h=y.createFragment(this.element),l=0;l<d.length;l++)h.appendChild(d[l].element);this.element.appendChild(h)}else this.cells.push(d),this.element.appendChild(d.element)},C.prototype.unshift=function(d){if(Array.isArray(d)){this.cells.unshift.apply(this.cells,d);for(var h=y.createFragment(this.element),l=0;l<d.length;l++)h.appendChild(d[l].element);this.element.firstChild?this.element.insertBefore(h,this.element.firstChild):this.element.appendChild(h)}else this.cells.unshift(d),this.element.insertAdjacentElement("afterbegin",d.element)},C.prototype.last=function(){return this.cells.length?this.cells[this.cells.length-1]:null},C.prototype.$cacheCell=function(d){d&&(d.element.remove(),this.cellCache.push(d))},C.prototype.createCell=function(d,h,l,n){var o,i=this.cellCache.pop();return i||(o=y.createElement("div"),n&&n(o),this.element.appendChild(o),i={element:o,text:"",row:d}),i.row=d,i},f.Lines=C}),ace.define("ace/layer/gutter",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/lang","ace/lib/event_emitter","ace/layer/lines","ace/config"],function(o,f,R){var y=o("../lib/dom"),C=o("../lib/oop"),d=o("../lib/lang"),h=o("../lib/event_emitter").EventEmitter,l=o("./lines").Lines,n=o("../config").nls,o=(i.prototype.setSession=function(r){this.session&&this.session.off("change",this.$updateAnnotations),(this.session=r)&&r.on("change",this.$updateAnnotations)},i.prototype.addGutterDecoration=function(r,e){window.console&&console.warn&&console.warn("deprecated use session.addGutterDecoration"),this.session.addGutterDecoration(r,e)},i.prototype.removeGutterDecoration=function(r,e){window.console&&console.warn&&console.warn("deprecated use session.removeGutterDecoration"),this.session.removeGutterDecoration(r,e)},i.prototype.setAnnotations=function(r){this.$annotations=[];for(var e=0;e<r.length;e++){var t=r[e],p=t.row,s=(s=this.$annotations[p])||(this.$annotations[p]={text:[],type:[]}),p=t.text,c=t.type,p=p?d.escapeHTML(p):t.html||"",p=(s.text.indexOf(p)===-1&&(s.text.push(p),s.type.push(c)),t.className);p?s.className=p:c=="error"?s.className=" ace_error":c=="warning"&&s.className!=" ace_error"?s.className=" ace_warning":c!="info"||s.className||(s.className=" ace_info")}},i.prototype.$updateAnnotations=function(r){var e,t;this.$annotations.length&&(e=r.start.row,(t=r.end.row-e)!=0)&&(r.action=="remove"?this.$annotations.splice(e,1+t,null):((r=new Array(1+t)).unshift(e,1),this.$annotations.splice.apply(this.$annotations,r)))},i.prototype.update=function(r){this.config=r;for(var e=this.session,t=r.firstRow,s=Math.min(r.lastRow+r.gutterOffset,e.getLength()-1),c=(this.oldLastRow=s,this.config=r,this.$lines.moveContainer(r),this.$updateCursorRow(),e.getNextFoldLine(t)),p=c?c.start.row:1/0,g=null,b=-1,w=t;;){if(p<w&&(w=c.end.row+1,p=(c=e.getNextFoldLine(w,c))?c.start.row:1/0),s<w){for(;this.$lines.getLength()>b+1;)this.$lines.pop();break}(g=this.$lines.get(++b))?g.row=w:(g=this.$lines.createCell(w,r,this.session,a),this.$lines.push(g)),this.$renderCell(g,r,c,w),w++}this._signal("afterRender"),this.$updateGutterWidth(r)},i.prototype.$updateGutterWidth=function(r){var e=this.session,c=e.gutterRenderer||this.$renderer,s=e.$firstLineNumber,t=this.$lines.last()?this.$lines.last().text:"",s=((this.$fixedWidth||e.$useWrapMode)&&(t=e.getLength()+s-1),c?c.getWidth(e,t,r):t.toString().length*r.characterWidth),c=this.$padding||this.$computePadding();(s+=c.left+c.right)===this.gutterWidth||isNaN(s)||(this.gutterWidth=s,this.element.parentNode.style.width=this.element.style.width=Math.ceil(this.gutterWidth)+"px",this._signal("changeGutterWidth",s))},i.prototype.$updateCursorRow=function(){var r;this.$highlightGutterLine&&(r=this.session.selection.getCursor(),this.$cursorRow!==r.row)&&(this.$cursorRow=r.row)},i.prototype.updateLineHighlight=function(){if(this.$highlightGutterLine){var r=this.session.selection.cursor.row;if(this.$cursorRow=r,!this.$cursorCell||this.$cursorCell.row!=r){this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ",""));var e=this.$lines.cells;this.$cursorCell=null;for(var t=0;t<e.length;t++){var s=e[t];if(s.row>=this.$cursorRow){if(s.row>this.$cursorRow){var c=this.session.getFoldLine(this.$cursorRow);if(!(0<t&&c&&c.start.row==e[t-1].row))break;s=e[t-1]}s.element.className="ace_gutter-active-line "+s.element.className,this.$cursorCell=s;break}}}}},i.prototype.scrollLines=function(r){var e=this.config;if(this.config=r,this.$updateCursorRow(),this.$lines.pageChanged(e,r))return this.update(r);this.$lines.moveContainer(r);var t=Math.min(r.lastRow+r.gutterOffset,this.session.getLength()-1),s=this.oldLastRow;if(this.oldLastRow=t,!e||s<r.firstRow)return this.update(r);if(t<e.firstRow)return this.update(r);if(e.firstRow<r.firstRow)for(var c=this.session.getFoldedRowCount(e.firstRow,r.firstRow-1);0<c;c--)this.$lines.shift();if(t<s)for(c=this.session.getFoldedRowCount(t+1,s);0<c;c--)this.$lines.pop();r.firstRow<e.firstRow&&this.$lines.unshift(this.$renderLines(r,r.firstRow,e.firstRow-1)),s<t&&this.$lines.push(this.$renderLines(r,s+1,t)),this.updateLineHighlight(),this._signal("afterRender"),this.$updateGutterWidth(r)},i.prototype.$renderLines=function(r,e,t){for(var s=[],c=e,p=this.session.getNextFoldLine(c),g=p?p.start.row:1/0;g<c&&(c=p.end.row+1,g=(p=this.session.getNextFoldLine(c,p))?p.start.row:1/0),!(t<c);){var b=this.$lines.createCell(c,r,this.session,a);this.$renderCell(b,r,p,c),s.push(b),c++}return s},i.prototype.$renderCell=function(r,e,t,s){var c,p=r.element,g=this.session,b=p.childNodes[0],w=p.childNodes[1],E=p.childNodes[2],W=E.firstChild,B=g.$firstLineNumber,O=g.$breakpoints,x=g.$decorations,M=g.gutterRenderer||this.$renderer,u=this.$showFoldWidgets&&g.foldWidgets,_=t?t.start.row:Number.MAX_VALUE,v=e.lineHeight+"px",$=this.$useSvgGutterIcons?"ace_gutter-cell_svg-icons ":"ace_gutter-cell ",P=this.$useSvgGutterIcons?"ace_icon_svg":"ace_icon",M=(M?M.getText(g,s):s+B).toString();if(this.$highlightGutterLine&&(s==this.$cursorRow||t&&s<this.$cursorRow&&_<=s&&this.$cursorRow<=t.end.row)&&($+="ace_gutter-active-line ",this.$cursorCell!=r)&&(this.$cursorCell&&(this.$cursorCell.element.className=this.$cursorCell.element.className.replace("ace_gutter-active-line ","")),this.$cursorCell=r),O[s]&&($+=O[s]),x[s]&&($+=x[s]),this.$annotations[s]&&s!==_&&($+=this.$annotations[s].className),c=u&&(c=u[s])==null?u[s]=g.getFoldWidget(s):c){if(B="ace_fold-widget ace_"+c,O=c=="start"&&s==_&&s<t.end.row,O){B+=" ace_closed";for(var X="",Q=!1,K=s+1;K<=t.end.row;K++)if(this.$annotations[K]){if(this.$annotations[K].className===" ace_error"){Q=!0,X=" ace_error_fold";break}this.$annotations[K].className===" ace_warning"&&(Q=!0,X=" ace_warning_fold")}$+=X}else B+=" ace_open";w.className!=B&&(w.className=B),y.setStyle(w.style,"height",v),y.setStyle(w.style,"display","inline-block"),w.setAttribute("role","button"),w.setAttribute("tabindex","-1"),x=g.getFoldWidgetRange(s),x?w.setAttribute("aria-label",n("Toggle code folding, rows $0 through $1",[x.start.row+1,x.end.row+1])):t?w.setAttribute("aria-label",n("Toggle code folding, rows $0 through $1",[t.start.row+1,t.end.row+1])):w.setAttribute("aria-label",n("Toggle code folding, row $0",[s+1])),O?(w.setAttribute("aria-expanded","false"),w.setAttribute("title",n("Unfold code"))):(w.setAttribute("aria-expanded","true"),w.setAttribute("title",n("Fold code")))}else w&&(y.setStyle(w.style,"display","none"),w.setAttribute("tabindex","0"),w.removeAttribute("role"),w.removeAttribute("aria-label"));return Q&&this.$showFoldedAnnotations?(E.className="ace_gutter_annotation",W.className=P,W.className+=X,y.setStyle(W.style,"height",v),y.setStyle(E.style,"display","block"),y.setStyle(E.style,"height",v),E.setAttribute("aria-label",n("Read annotations row $0",[M])),E.setAttribute("tabindex","-1"),E.setAttribute("role","button")):this.$annotations[s]?(E.className="ace_gutter_annotation",W.className=P,this.$useSvgGutterIcons?W.className+=this.$annotations[s].className:p.classList.add(this.$annotations[s].className.replace(" ","")),y.setStyle(W.style,"height",v),y.setStyle(E.style,"display","block"),y.setStyle(E.style,"height",v),E.setAttribute("aria-label",n("Read annotations row $0",[M])),E.setAttribute("tabindex","-1"),E.setAttribute("role","button")):(y.setStyle(E.style,"display","none"),E.removeAttribute("aria-label"),E.removeAttribute("role"),E.setAttribute("tabindex","0")),M!==b.data&&(b.data=M),p.className!=$&&(p.className=$),y.setStyle(r.element.style,"height",this.$lines.computeLineHeight(s,e,g)+"px"),y.setStyle(r.element.style,"top",this.$lines.computeLineTop(s,e,g)+"px"),r.text=M,E.style.display==="none"&&w.style.display==="none"?r.element.setAttribute("aria-hidden",!0):r.element.setAttribute("aria-hidden",!1),r},i.prototype.setHighlightGutterLine=function(r){this.$highlightGutterLine=r},i.prototype.setShowLineNumbers=function(r){this.$renderer=!r&&{getWidth:function(){return 0},getText:function(){return""}}},i.prototype.getShowLineNumbers=function(){return this.$showLineNumbers},i.prototype.setShowFoldWidgets=function(r){r?y.addCssClass(this.element,"ace_folding-enabled"):y.removeCssClass(this.element,"ace_folding-enabled"),this.$showFoldWidgets=r,this.$padding=null},i.prototype.getShowFoldWidgets=function(){return this.$showFoldWidgets},i.prototype.$computePadding=function(){var r;return this.element.firstChild?(r=y.computedStyle(this.element.firstChild),this.$padding={},this.$padding.left=(parseInt(r.borderLeftWidth)||0)+(parseInt(r.paddingLeft)||0)+1,this.$padding.right=(parseInt(r.borderRightWidth)||0)+(parseInt(r.paddingRight)||0),this.$padding):{left:0,right:0}},i.prototype.getRegion=function(r){var e=this.$padding||this.$computePadding(),t=this.element.getBoundingClientRect();return r.x<e.left+t.left?"markers":this.$showFoldWidgets&&r.x>t.right-e.right?"foldWidgets":void 0},i);function i(r){this.element=y.createElement("div"),this.element.className="ace_layer ace_gutter-layer",r.appendChild(this.element),this.setShowFoldWidgets(this.$showFoldWidgets),this.gutterWidth=0,this.$annotations=[],this.$updateAnnotations=this.$updateAnnotations.bind(this),this.$lines=new l(this.element),this.$lines.$offsetCoefficient=1}function a(r){var e=document.createTextNode(""),e=(r.appendChild(e),y.createElement("span")),e=(r.appendChild(e),y.createElement("span")),t=(r.appendChild(e),y.createElement("span"));return e.appendChild(t),r}o.prototype.$fixedWidth=!1,o.prototype.$highlightGutterLine=!0,o.prototype.$renderer="",o.prototype.$showLineNumbers=!0,o.prototype.$showFoldWidgets=!0,C.implement(o.prototype,h),f.Gutter=o}),ace.define("ace/layer/marker",["require","exports","module","ace/range","ace/lib/dom"],function(d,f,R){var y=d("../range").Range,C=d("../lib/dom"),d=(h.prototype.setPadding=function(l){this.$padding=l},h.prototype.setSession=function(l){this.session=l},h.prototype.setMarkers=function(l){this.markers=l},h.prototype.elt=function(l,n){var o=this.i!=-1&&this.element.childNodes[this.i];o?this.i++:(o=document.createElement("div"),this.element.appendChild(o),this.i=-1),o.style.cssText=n,o.className=l},h.prototype.update=function(l){if(l){var n,o;for(o in this.config=l,this.i=0,this.markers){var i,a,r,e=this.markers[o];e.range?(r=e.range.clipRows(l.firstRow,l.lastRow)).isEmpty()||(r=r.toScreenRange(this.session),e.renderer?(i=this.$getTop(r.start.row,l),a=this.$padding+r.start.column*l.characterWidth,e.renderer(n,r,a,i,l)):e.type=="fullLine"?this.drawFullLineMarker(n,r,e.clazz,l):e.type=="screenLine"?this.drawScreenLineMarker(n,r,e.clazz,l):r.isMultiLine()?e.type=="text"?this.drawTextMarker(n,r,e.clazz,l):this.drawMultiLineMarker(n,r,e.clazz,l):this.drawSingleLineMarker(n,r,e.clazz+" ace_start ace_br15",l)):e.update(n,this,this.session,l)}if(this.i!=-1)for(;this.i<this.element.childElementCount;)this.element.removeChild(this.element.lastChild)}},h.prototype.$getTop=function(l,n){return(l-n.firstRowScreen)*n.lineHeight},h.prototype.drawTextMarker=function(l,n,o,i,a){for(var r,e=this.session,t=n.start.row,s=n.end.row,c=t,p=0,g=e.getScreenLastRowColumn(c),b=new y(c,n.start.column,c,p);c<=s;c++)b.start.row=b.end.row=c,b.start.column=c==t?n.start.column:e.getRowWrapIndent(c),b.end.column=g,r=p,p=g,g=c+1<s?e.getScreenLastRowColumn(c+1):c==s?0:n.end.column,this.drawSingleLineMarker(l,b,o+(c==t?" ace_start":"")+" ace_br"+((c==t||c==t+1&&n.start.column?1:0)|(r<p?2:0)|(g<p?4:0)|(c==s?8:0)),i,c==s?0:1,a)},h.prototype.drawMultiLineMarker=function(l,n,o,i,a){var r,e=this.$padding,t=i.lineHeight,s=this.$getTop(n.start.row,i),c=e+n.start.column*i.characterWidth;a=a||"",this.session.$bidiHandler.isBidiRow(n.start.row)?((r=n.clone()).end.row=r.start.row,r.end.column=this.session.getLine(r.start.row).length,this.drawBidiSingleLineMarker(l,r,o+" ace_br1 ace_start",i,null,a)):this.elt(o+" ace_br1 ace_start","height:"+t+"px;right:0;top:"+s+"px;left:"+c+"px;"+(a||"")),this.session.$bidiHandler.isBidiRow(n.end.row)?((r=n.clone()).start.row=r.end.row,r.start.column=0,this.drawBidiSingleLineMarker(l,r,o+" ace_br12",i,null,a)):(s=this.$getTop(n.end.row,i),c=n.end.column*i.characterWidth,this.elt(o+" ace_br12","height:"+t+"px;width:"+c+"px;top:"+s+"px;left:"+e+"px;"+(a||""))),(t=(n.end.row-n.start.row-1)*i.lineHeight)<=0||(s=this.$getTop(n.start.row+1,i),l=(n.start.column?1:0)|(n.end.column?0:8),this.elt(o+(l?" ace_br"+l:""),"height:"+t+"px;right:0;top:"+s+"px;left:"+e+"px;"+(a||"")))},h.prototype.drawSingleLineMarker=function(e,c,o,i,t,r){if(this.session.$bidiHandler.isBidiRow(c.start.row))return this.drawBidiSingleLineMarker(e,c,o,i,t,r);var e=i.lineHeight,t=(c.end.column+(t||0)-c.start.column)*i.characterWidth,s=this.$getTop(c.start.row,i),c=this.$padding+c.start.column*i.characterWidth;this.elt(o,"height:"+e+"px;width:"+t+"px;top:"+s+"px;left:"+c+"px;"+(r||""))},h.prototype.drawBidiSingleLineMarker=function(l,n,o,i,a,r){var e=i.lineHeight,t=this.$getTop(n.start.row,i),s=this.$padding;this.session.$bidiHandler.getSelections(n.start.column,n.end.column).forEach(function(c){this.elt(o,"height:"+e+"px;width:"+(c.width+(a||0))+"px;top:"+t+"px;left:"+(s+c.left)+"px;"+(r||""))},this)},h.prototype.drawFullLineMarker=function(l,n,o,i,a){var r=this.$getTop(n.start.row,i),e=i.lineHeight;n.start.row!=n.end.row&&(e+=this.$getTop(n.end.row,i)-r),this.elt(o,"height:"+e+"px;top:"+r+"px;left:0;right:0;"+(a||""))},h.prototype.drawScreenLineMarker=function(l,n,o,i,a){n=this.$getTop(n.start.row,i),i=i.lineHeight,this.elt(o,"height:"+i+"px;top:"+n+"px;left:0;right:0;"+(a||""))},h);function h(l){this.element=C.createElement("div"),this.element.className="ace_layer ace_marker-layer",l.appendChild(this.element)}d.prototype.$padding=0,f.Marker=d}),ace.define("ace/layer/text_util",["require","exports","module"],function(A,f,R){var y=new Set(["text","rparen","lparen"]);f.isTextToken=function(C){return y.has(C)}}),ace.define("ace/layer/text",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/layer/lines","ace/lib/event_emitter","ace/config","ace/layer/text_util"],function(i,f,R){var y=i("../lib/oop"),C=i("../lib/dom"),d=i("../lib/lang"),h=i("./lines").Lines,l=i("../lib/event_emitter").EventEmitter,n=i("../config").nls,o=i("./text_util").isTextToken,i=(a.prototype.$updateEolChar=function(){var r=this.session.doc,r=r.getNewLineCharacter()==`
`&&r.getNewLineMode()!="windows"?this.EOL_CHAR_LF:this.EOL_CHAR_CRLF;if(this.EOL_CHAR!=r)return this.EOL_CHAR=r,!0},a.prototype.setPadding=function(r){this.$padding=r,this.element.style.margin="0 "+r+"px"},a.prototype.getLineHeight=function(){return this.$fontMetrics.$characterSize.height||0},a.prototype.getCharacterWidth=function(){return this.$fontMetrics.$characterSize.width||0},a.prototype.$setFontMetrics=function(r){this.$fontMetrics=r,this.$fontMetrics.on("changeCharacterSize",(function(e){this._signal("changeCharacterSize",e)}).bind(this)),this.$pollSizeChanges()},a.prototype.checkForSizeChanges=function(){this.$fontMetrics.checkForSizeChanges()},a.prototype.$pollSizeChanges=function(){return this.$pollSizeChangesTimer=this.$fontMetrics.$pollSizeChanges()},a.prototype.setSession=function(r){(this.session=r)&&this.$computeTabString()},a.prototype.setShowInvisibles=function(r){return this.showInvisibles!=r&&(typeof(this.showInvisibles=r)=="string"?(this.showSpaces=/tab/i.test(r),this.showTabs=/space/i.test(r),this.showEOL=/eol/i.test(r)):this.showSpaces=this.showTabs=this.showEOL=r,this.$computeTabString(),!0)},a.prototype.setDisplayIndentGuides=function(r){return this.displayIndentGuides!=r&&(this.displayIndentGuides=r,this.$computeTabString(),!0)},a.prototype.setHighlightIndentGuides=function(r){return this.$highlightIndentGuides!==r&&(this.$highlightIndentGuides=r)},a.prototype.$computeTabString=function(){for(var r,e,t,s,c,p,g=this.session.getTabSize(),b=(this.tabSize=g,this.$tabStrings=[0]),w=1;w<g+1;w++)this.showTabs?((p=this.dom.createElement("span")).className="ace_invisible ace_invisible_tab",p.textContent=d.stringRepeat(this.TAB_CHAR,w),b.push(p)):b.push(this.dom.createTextNode(d.stringRepeat(" ",w),this.element));this.displayIndentGuides&&(this.$indentGuideRe=/\s\S| \t|\t |\s$/,r="ace_indent-guide",e=this.showSpaces?" ace_invisible ace_invisible_space":"",t=this.showSpaces?d.stringRepeat(this.SPACE_CHAR,this.tabSize):d.stringRepeat(" ",this.tabSize),s=this.showTabs?" ace_invisible ace_invisible_tab":"",c=this.showTabs?d.stringRepeat(this.TAB_CHAR,this.tabSize):t,(p=this.dom.createElement("span")).className=r+e,p.textContent=t,this.$tabStrings[" "]=p,(p=this.dom.createElement("span")).className=r+s,p.textContent=c,this.$tabStrings["	"]=p)},a.prototype.updateLines=function(r,e,t){if(this.config.lastRow!=r.lastRow||this.config.firstRow!=r.firstRow)return this.update(r);this.config=r;for(var s=Math.max(e,r.firstRow),c=Math.min(t,r.lastRow),p=this.element.childNodes,g=0,b=r.firstRow;b<s;b++){if(w=this.session.getFoldLine(b)){if(w.containsRow(s)){s=w.start.row;break}b=w.end.row}g++}for(var w,E=!1,b=s,W=(w=this.session.getNextFoldLine(b))?w.start.row:1/0;W<b&&(b=w.end.row+1,W=(w=this.session.getNextFoldLine(b,w))?w.start.row:1/0),!(c<b);){var B,O=p[g++];O&&(this.dom.removeChildren(O),this.$renderLine(O,b,b==W&&w),E&&(O.style.top=this.$lines.computeLineTop(b,r,this.session)+"px"),B=r.lineHeight*this.session.getRowLength(b)+"px",O.style.height!=B)&&(E=!0,O.style.height=B),b++}if(E)for(;g<this.$lines.cells.length;){var x=this.$lines.cells[g++];x.element.style.top=this.$lines.computeLineTop(x.row,r,this.session)+"px"}},a.prototype.scrollLines=function(r){var e=this.config;if(this.config=r,this.$lines.pageChanged(e,r))return this.update(r);this.$lines.moveContainer(r);var t=r.lastRow,s=e?e.lastRow:-1;if(!e||s<r.firstRow)return this.update(r);if(t<e.firstRow)return this.update(r);if(!e||e.lastRow<r.firstRow)return this.update(r);if(r.lastRow<e.firstRow)return this.update(r);if(e.firstRow<r.firstRow)for(var c=this.session.getFoldedRowCount(e.firstRow,r.firstRow-1);0<c;c--)this.$lines.shift();if(e.lastRow>r.lastRow)for(c=this.session.getFoldedRowCount(r.lastRow+1,e.lastRow);0<c;c--)this.$lines.pop();r.firstRow<e.firstRow&&this.$lines.unshift(this.$renderLinesFragment(r,r.firstRow,e.firstRow-1)),r.lastRow>e.lastRow&&this.$lines.push(this.$renderLinesFragment(r,e.lastRow+1,r.lastRow)),this.$highlightIndentGuide()},a.prototype.$renderLinesFragment=function(r,e,t){for(var s=[],c=e,p=this.session.getNextFoldLine(c),g=p?p.start.row:1/0;g<c&&(c=p.end.row+1,g=(p=this.session.getNextFoldLine(c,p))?p.start.row:1/0),!(t<c);){var b=this.$lines.createCell(c,r,this.session),w=b.element;this.dom.removeChildren(w),C.setStyle(w.style,"height",this.$lines.computeLineHeight(c,r,this.session)+"px"),C.setStyle(w.style,"top",this.$lines.computeLineTop(c,r,this.session)+"px"),this.$renderLine(w,c,c==g&&p),this.$useLineGroups()?w.className="ace_line_group":w.className="ace_line",s.push(b),c++}return s},a.prototype.update=function(r){this.$lines.moveContainer(r);for(var e=(this.config=r).firstRow,t=r.lastRow,s=this.$lines;s.getLength();)s.pop();s.push(this.$renderLinesFragment(r,e,t))},a.prototype.$renderToken=function(r,e,t,s){for(var c,p,g=this,b=/(\t)|( +)|([\x00-\x1f\x80-\xa0\xad\u1680\u180E\u2000-\u200f\u2028\u2029\u202F\u205F\uFEFF\uFFF9-\uFFFC\u2066\u2067\u2068\u202A\u202B\u202D\u202E\u202C\u2069]+)|(\u3000)|([\u1100-\u115F\u11A3-\u11A7\u11FA-\u11FF\u2329-\u232A\u2E80-\u2E99\u2E9B-\u2EF3\u2F00-\u2FD5\u2FF0-\u2FFB\u3001-\u303E\u3041-\u3096\u3099-\u30FF\u3105-\u312D\u3131-\u318E\u3190-\u31BA\u31C0-\u31E3\u31F0-\u321E\u3220-\u3247\u3250-\u32FE\u3300-\u4DBF\u4E00-\uA48C\uA490-\uA4C6\uA960-\uA97C\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFAFF\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFF01-\uFF60\uFFE0-\uFFE6]|[\uD800-\uDBFF][\uDC00-\uDFFF])/g,w=this.dom.createFragment(this.element),E=0;c=b.exec(s);){var W,B,O=c[1],x=c[2],u=c[3],_=c[4],v=c[5];!g.showSpaces&&x||(W=E!=c.index?s.slice(E,c.index):"",E=c.index+c[0].length,W&&w.appendChild(this.dom.createTextNode(W,this.element)),O?(W=g.session.getScreenTabSize(e+c.index),w.appendChild(g.$tabStrings[W].cloneNode(!0)),e+=W-1):x?g.showSpaces?((B=this.dom.createElement("span")).className="ace_invisible ace_invisible_space",B.textContent=d.stringRepeat(g.SPACE_CHAR,x.length),w.appendChild(B)):w.appendChild(this.dom.createTextNode(x,this.element)):u?((B=this.dom.createElement("span")).className="ace_invisible ace_invisible_space ace_invalid",B.textContent=d.stringRepeat(g.SPACE_CHAR,u.length),w.appendChild(B)):_?(e+=1,(B=this.dom.createElement("span")).style.width=2*g.config.characterWidth+"px",B.className=g.showSpaces?"ace_cjk ace_invisible ace_invisible_space":"ace_cjk",B.textContent=g.showSpaces?g.SPACE_CHAR:_,w.appendChild(B)):v&&(e+=1,(B=this.dom.createElement("span")).style.width=2*g.config.characterWidth+"px",B.className="ace_cjk",B.textContent=v,w.appendChild(B)))}return w.appendChild(this.dom.createTextNode(E?s.slice(E):s,this.element)),o(t.type)?r.appendChild(w):(p="ace_"+t.type.replace(/\./g," ace_"),B=this.dom.createElement("span"),t.type=="fold"&&(B.style.width=t.value.length*this.config.characterWidth+"px",B.setAttribute("title",n("Unfold code"))),B.className=p,B.appendChild(w),r.appendChild(B)),e+s.length},a.prototype.renderIndentGuide=function(r,e,t){var s=e.search(this.$indentGuideRe);if(!(s<=0||t<=s)){if(e[0]==" "){for(var c=(s-=s%this.tabSize)/this.tabSize,p=0;p<c;p++)r.appendChild(this.$tabStrings[" "].cloneNode(!0));return this.$highlightIndentGuide(),e.substr(s)}if(e[0]=="	"){for(p=0;p<s;p++)r.appendChild(this.$tabStrings["	"].cloneNode(!0));return this.$highlightIndentGuide(),e.substr(s)}this.$highlightIndentGuide()}return e},a.prototype.$highlightIndentGuide=function(){if(this.$highlightIndentGuides&&this.displayIndentGuides){this.$highlightIndentGuideMarker={indentLevel:void 0,start:void 0,end:void 0,dir:void 0};var r=this.session.doc.$lines;if(r){var e=this.session.selection.getCursor(),t=/^\s*/.exec(this.session.doc.getLine(e.row))[0].length,s=Math.floor(t/this.tabSize);if(this.$highlightIndentGuideMarker={indentLevel:s,start:e.row},this.session.$bracketHighlight){for(var c=this.session.$bracketHighlight.ranges,p=0;p<c.length;p++)if(e.row!==c[p].start.row){this.$highlightIndentGuideMarker.end=c[p].start.row,e.row>c[p].start.row?this.$highlightIndentGuideMarker.dir=-1:this.$highlightIndentGuideMarker.dir=1;break}}if(!this.$highlightIndentGuideMarker.end&&r[e.row]!==""&&e.column===r[e.row].length)for(this.$highlightIndentGuideMarker.dir=1,p=e.row+1;p<r.length;p++){var g=r[p],b=/^\s*/.exec(g)[0].length;if(g!==""&&(this.$highlightIndentGuideMarker.end=p,b<=t))break}this.$renderHighlightIndentGuide()}}},a.prototype.$clearActiveIndentGuide=function(){for(var r=this.$lines.cells,e=0;e<r.length;e++){var t=r[e].element.childNodes;if(0<t.length){for(var s=0;s<t.length;s++)if(t[s].classList&&t[s].classList.contains("ace_indent-guide-active")){t[s].classList.remove("ace_indent-guide-active");break}}}},a.prototype.$setIndentGuideActive=function(r,e){this.session.doc.getLine(r.row)!==""&&(r=r.element.childNodes)&&(r=r[e-1])&&r.classList&&r.classList.contains("ace_indent-guide")&&r.classList.add("ace_indent-guide-active")},a.prototype.$renderHighlightIndentGuide=function(){if(this.$lines){var r=this.$lines.cells,e=(this.$clearActiveIndentGuide(),this.$highlightIndentGuideMarker.indentLevel);if(e!==0){if(this.$highlightIndentGuideMarker.dir===1)for(var t=0;t<r.length;t++){var s=r[t];if(this.$highlightIndentGuideMarker.end&&s.row>=this.$highlightIndentGuideMarker.start+1){if(s.row>=this.$highlightIndentGuideMarker.end)break;this.$setIndentGuideActive(s,e)}}else for(t=r.length-1;0<=t;t--)if(s=r[t],this.$highlightIndentGuideMarker.end&&s.row<this.$highlightIndentGuideMarker.start){if(s.row<=this.$highlightIndentGuideMarker.end)break;this.$setIndentGuideActive(s,e)}}}},a.prototype.$createLineElement=function(r){var e=this.dom.createElement("div");return e.className="ace_line",e.style.height=this.config.lineHeight+"px",e},a.prototype.$renderWrappedLine=function(r,e,t){var s=0,c=0,p=t[0],g=0,b=this.$createLineElement();r.appendChild(b);for(var w=0;w<e.length;w++){var E=e[w],W=E.value;if(w==0&&this.displayIndentGuides){if(s=W.length,!(W=this.renderIndentGuide(b,W,p)))continue;s-=W.length}if(s+W.length<p)g=this.$renderToken(b,g,E,W),s+=W.length;else{for(;s+W.length>=p;)g=this.$renderToken(b,g,E,W.substring(0,p-s)),W=W.substring(p-s),s=p,b=this.$createLineElement(),r.appendChild(b),b.appendChild(this.dom.createTextNode(d.stringRepeat(" ",t.indent),this.element)),g=0,p=t[++c]||Number.MAX_VALUE;W.length!=0&&(s+=W.length,g=this.$renderToken(b,g,E,W))}}t[t.length-1]>this.MAX_LINE_LENGTH&&this.$renderOverflowMessage(b,g,null,"",!0)},a.prototype.$renderSimpleLine=function(r,e){for(var t=0,s=0;s<e.length;s++){var c=e[s],p=c.value;if(s!=0||!this.displayIndentGuides||(p=this.renderIndentGuide(r,p))){if(t+p.length>this.MAX_LINE_LENGTH)return this.$renderOverflowMessage(r,t,c,p);t=this.$renderToken(r,t,c,p)}}},a.prototype.$renderOverflowMessage=function(r,e,t,s,c){t&&this.$renderToken(r,e,t,s.slice(0,this.MAX_LINE_LENGTH-e)),t=this.dom.createElement("span"),t.className="ace_inline_button ace_keyword ace_toggle_wrap",t.textContent=c?"<hide>":"<click to see more...>",r.appendChild(t)},a.prototype.$renderLine=function(r,e,t){var s,c,p=r;(s=(t=t||t==0?t:this.session.getFoldLine(e))?this.$getFoldLineTokens(e,t):this.session.getTokens(e)).length?(c=this.session.getRowSplitData(e))&&c.length?(this.$renderWrappedLine(r,s,c),p=r.lastChild):(p=r,this.$useLineGroups()&&(p=this.$createLineElement(),r.appendChild(p)),this.$renderSimpleLine(p,s)):this.$useLineGroups()&&(p=this.$createLineElement(),r.appendChild(p)),this.showEOL&&p&&(t&&(e=t.end.row),(c=this.dom.createElement("span")).className="ace_invisible ace_invisible_eol",c.textContent=e==this.session.getLength()-1?this.EOF_CHAR:this.EOL_CHAR,p.appendChild(c))},a.prototype.$getFoldLineTokens=function(r,e){var t=this.session,s=[],c=t.getTokens(r);return e.walk(function(p,g,b,w,E){if(p!=null)s.push({type:"fold",value:p});else if((c=E?t.getTokens(g):c).length){for(var W,B=c,O=w,x=b,u=0,_=0;_+B[u].value.length<O;)if(_+=B[u].value.length,++u==B.length)return;for(_!=O&&((W=B[u].value.substring(O-_)).length>x-O&&(W=W.substring(0,x-O)),s.push({type:B[u].type,value:W}),_=O+W.length,u+=1);_<x&&u<B.length;)(W=B[u].value).length+_>x?s.push({type:B[u].type,value:W.substring(0,x-_)}):s.push(B[u]),_+=W.length,u+=1}},e.end.row,this.session.getLine(e.end.row).length),s},a.prototype.$useLineGroups=function(){return this.session.getUseWrapMode()},a);function a(r){this.dom=C,this.element=this.dom.createElement("div"),this.element.className="ace_layer ace_text-layer",r.appendChild(this.element),this.$updateEolChar=this.$updateEolChar.bind(this),this.$lines=new h(this.element)}i.prototype.EOF_CHAR="¶",i.prototype.EOL_CHAR_LF="¬",i.prototype.EOL_CHAR_CRLF="¤",i.prototype.EOL_CHAR=i.prototype.EOL_CHAR_LF,i.prototype.TAB_CHAR="—",i.prototype.SPACE_CHAR="·",i.prototype.$padding=0,i.prototype.MAX_LINE_LENGTH=1e4,i.prototype.showInvisibles=!1,i.prototype.showSpaces=!1,i.prototype.showTabs=!1,i.prototype.showEOL=!1,i.prototype.displayIndentGuides=!0,i.prototype.$highlightIndentGuides=!0,i.prototype.$tabStrings=[],i.prototype.destroy={},i.prototype.onChangeTabSize=i.prototype.$computeTabString,y.implement(i.prototype,l),f.Text=i}),ace.define("ace/layer/cursor",["require","exports","module","ace/lib/dom"],function(C,f,R){var y=C("../lib/dom"),C=(d.prototype.$updateOpacity=function(h){for(var l=this.cursors,n=l.length;n--;)y.setStyle(l[n].style,"opacity",h?"":"0")},d.prototype.$startCssAnimation=function(){for(var h=this.cursors,l=h.length;l--;)h[l].style.animationDuration=this.blinkInterval+"ms";this.$isAnimating=!0,setTimeout((function(){this.$isAnimating&&y.addCssClass(this.element,"ace_animate-blinking")}).bind(this))},d.prototype.$stopCssAnimation=function(){this.$isAnimating=!1,y.removeCssClass(this.element,"ace_animate-blinking")},d.prototype.setPadding=function(h){this.$padding=h},d.prototype.setSession=function(h){this.session=h},d.prototype.setBlinking=function(h){h!=this.isBlinking&&(this.isBlinking=h,this.restartTimer())},d.prototype.setBlinkInterval=function(h){h!=this.blinkInterval&&(this.blinkInterval=h,this.restartTimer())},d.prototype.setSmoothBlinking=function(h){h!=this.smoothBlinking&&(this.smoothBlinking=h,y.setCssClass(this.element,"ace_smooth-blinking",h),this.$updateCursors(!0),this.restartTimer())},d.prototype.addCursor=function(){var h=y.createElement("div");return h.className="ace_cursor",this.element.appendChild(h),this.cursors.push(h),h},d.prototype.removeCursor=function(){var h;if(1<this.cursors.length)return(h=this.cursors.pop()).parentNode.removeChild(h),h},d.prototype.hideCursor=function(){this.isVisible=!1,y.addCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},d.prototype.showCursor=function(){this.isVisible=!0,y.removeCssClass(this.element,"ace_hidden-cursors"),this.restartTimer()},d.prototype.restartTimer=function(){var h,l=this.$updateCursors;clearInterval(this.intervalId),clearTimeout(this.timeoutId),this.$stopCssAnimation(),this.smoothBlinking&&(this.$isSmoothBlinking=!1,y.removeCssClass(this.element,"ace_smooth-blinking")),l(!0),this.isBlinking&&this.blinkInterval&&this.isVisible?(this.smoothBlinking&&(this.$isSmoothBlinking=!0,setTimeout((function(){this.$isSmoothBlinking&&y.addCssClass(this.element,"ace_smooth-blinking")}).bind(this))),y.HAS_CSS_ANIMATION?this.$startCssAnimation():(h=(function(){this.timeoutId=setTimeout(function(){l(!1)},.6*this.blinkInterval)}).bind(this),this.intervalId=setInterval(function(){l(!0),h()},this.blinkInterval),h())):this.$stopCssAnimation()},d.prototype.getPixelPosition=function(h,l){if(!this.config||!this.session)return{left:0,top:0};h=h||this.session.selection.getCursor();var n=this.session.documentToScreenPosition(h);return{left:this.$padding+(this.session.$bidiHandler.isBidiRow(n.row,h.row)?this.session.$bidiHandler.getPosLeft(n.column):n.column*this.config.characterWidth),top:(n.row-(l?this.config.firstRowScreen:0))*this.config.lineHeight}},d.prototype.isCursorInView=function(h,l){return 0<=h.top&&h.top<l.maxHeight},d.prototype.update=function(h){this.config=h;for(var l=this.session.$selectionMarkers,o=0,n=0,o=0,i=(l=l!==void 0&&l.length!==0?l:[{cursor:null}]).length;o<i;o++){var a,r,e=this.getPixelPosition(l[o].cursor,!0);(e.top>h.height+h.offset||e.top<0)&&1<o||(r=(a=this.cursors[n++]||this.addCursor()).style,this.drawCursor?this.drawCursor(a,e,h,l[o],this.session):this.isCursorInView(e,h)?(y.setStyle(r,"display","block"),y.translate(a,e.left,e.top),y.setStyle(r,"width",Math.round(h.characterWidth)+"px"),y.setStyle(r,"height",h.lineHeight+"px")):y.setStyle(r,"display","none"))}for(;this.cursors.length>n;)this.removeCursor();var t=this.session.getOverwrite();this.$setOverwrite(t),this.$pixelPos=e,this.restartTimer()},d.prototype.$setOverwrite=function(h){h!=this.overwrite&&((this.overwrite=h)?y.addCssClass(this.element,"ace_overwrite-cursors"):y.removeCssClass(this.element,"ace_overwrite-cursors"))},d.prototype.destroy=function(){clearInterval(this.intervalId),clearTimeout(this.timeoutId)},d);function d(h){this.element=y.createElement("div"),this.element.className="ace_layer ace_cursor-layer",h.appendChild(this.element),this.isVisible=!1,this.isBlinking=!0,this.blinkInterval=1e3,this.smoothBlinking=!1,this.cursors=[],this.cursor=this.addCursor(),y.addCssClass(this.element,"ace_hidden-cursors"),this.$updateCursors=this.$updateOpacity.bind(this)}C.prototype.$padding=0,C.prototype.drawCursor=null,f.Cursor=C}),ace.define("ace/scrollbar",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(e,f,R){var y,C=this&&this.__extends||(y=function(s,c){return(y=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(p,g){p.__proto__=g}:function(p,g){for(var b in g)Object.prototype.hasOwnProperty.call(g,b)&&(p[b]=g[b])}))(s,c)},function(s,c){if(typeof c!="function"&&c!==null)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");function p(){this.constructor=s}y(s,c),s.prototype=c===null?Object.create(c):(p.prototype=c.prototype,new p)}),i=e("./lib/oop"),d=e("./lib/dom"),h=e("./lib/event"),e=e("./lib/event_emitter").EventEmitter,l=(n.prototype.setVisible=function(s){this.element.style.display=s?"":"none",this.isVisible=s,this.coeff=1},n);function n(s,c){this.element=d.createElement("div"),this.element.className="ace_scrollbar ace_scrollbar"+c,this.inner=d.createElement("div"),this.inner.className="ace_scrollbar-inner",this.inner.textContent=" ",this.element.appendChild(this.inner),s.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,h.addListener(this.element,"scroll",this.onScroll.bind(this)),h.addListener(this.element,"mousedown",h.preventDefault)}i.implement(l.prototype,e),C(a,o=l),a.prototype.onScroll=function(){var s;this.skipEvent||(this.scrollTop=this.element.scrollTop,this.coeff!=1&&(s=this.element.clientHeight/this.scrollHeight,this.scrollTop=this.scrollTop*(1-s)/(this.coeff-s)),this._emit("scroll",{data:this.scrollTop})),this.skipEvent=!1},a.prototype.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},a.prototype.setHeight=function(s){this.element.style.height=s+"px"},a.prototype.setScrollHeight=function(s){32768<(this.scrollHeight=s)?(this.coeff=32768/s,s=32768):this.coeff!=1&&(this.coeff=1),this.inner.style.height=s+"px"},a.prototype.setScrollTop=function(s){this.scrollTop!=s&&(this.skipEvent=!0,this.scrollTop=s,this.element.scrollTop=s*this.coeff)};var o,i=a;function a(s,c){var p=o.call(this,s,"-v")||this;return p.scrollTop=0,p.scrollHeight=0,c.$scrollbarWidth=p.width=d.scrollbarWidth(s.ownerDocument),p.inner.style.width=p.element.style.width=(p.width||15)+5+"px",p.$minWidth=0,p}i.prototype.setInnerHeight=i.prototype.setScrollHeight,C(t,r=l),t.prototype.onScroll=function(){this.skipEvent||(this.scrollLeft=this.element.scrollLeft,this._emit("scroll",{data:this.scrollLeft})),this.skipEvent=!1},t.prototype.getHeight=function(){return this.isVisible?this.height:0},t.prototype.setWidth=function(s){this.element.style.width=s+"px"},t.prototype.setInnerWidth=function(s){this.inner.style.width=s+"px"},t.prototype.setScrollWidth=function(s){this.inner.style.width=s+"px"},t.prototype.setScrollLeft=function(s){this.scrollLeft!=s&&(this.skipEvent=!0,this.scrollLeft=this.element.scrollLeft=s)};var r,e=t;function t(s,c){return s=r.call(this,s,"-h")||this,s.scrollLeft=0,s.height=c.$scrollbarWidth,s.inner.style.height=s.element.style.height=(s.height||15)+5+"px",s}f.ScrollBar=i,f.ScrollBarV=i,f.ScrollBarH=e,f.VScrollBar=i,f.HScrollBar=e}),ace.define("ace/scrollbar_custom",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/event","ace/lib/event_emitter"],function(e,f,R){var y,C=this&&this.__extends||(y=function(s,c){return(y=Object.setPrototypeOf||({__proto__:[]}instanceof Array?function(p,g){p.__proto__=g}:function(p,g){for(var b in g)Object.prototype.hasOwnProperty.call(g,b)&&(p[b]=g[b])}))(s,c)},function(s,c){if(typeof c!="function"&&c!==null)throw new TypeError("Class extends value "+String(c)+" is not a constructor or null");function p(){this.constructor=s}y(s,c),s.prototype=c===null?Object.create(c):(p.prototype=c.prototype,new p)}),i=e("./lib/oop"),d=e("./lib/dom"),h=e("./lib/event"),e=e("./lib/event_emitter").EventEmitter,l=(d.importCssString(`.ace_editor>.ace_sb-v div, .ace_editor>.ace_sb-h div{
  position: absolute;
  background: rgba(128, 128, 128, 0.6);
  -moz-box-sizing: border-box;
  box-sizing: border-box;
  border: 1px solid #bbb;
  border-radius: 2px;
  z-index: 8;
}
.ace_editor>.ace_sb-v, .ace_editor>.ace_sb-h {
  position: absolute;
  z-index: 6;
  background: none;
  overflow: hidden!important;
}
.ace_editor>.ace_sb-v {
  z-index: 6;
  right: 0;
  top: 0;
  width: 12px;
}
.ace_editor>.ace_sb-v div {
  z-index: 8;
  right: 0;
  width: 100%;
}
.ace_editor>.ace_sb-h {
  bottom: 0;
  left: 0;
  height: 12px;
}
.ace_editor>.ace_sb-h div {
  bottom: 0;
  height: 100%;
}
.ace_editor>.ace_sb_grabbed {
  z-index: 8;
  background: #000;
}`,"ace_scrollbar.css",!1),n.prototype.setVisible=function(s){this.element.style.display=s?"":"none",this.isVisible=s,this.coeff=1},n);function n(s,c){this.element=d.createElement("div"),this.element.className="ace_sb"+c,this.inner=d.createElement("div"),this.inner.className="",this.element.appendChild(this.inner),this.VScrollWidth=12,this.HScrollHeight=12,s.appendChild(this.element),this.setVisible(!1),this.skipEvent=!1,h.addMultiMouseDownListener(this.element,[500,300,300],this,"onMouseDown")}i.implement(l.prototype,e),C(a,o=l),a.prototype.onMouseDown=function(s,c){var p,g,b,w,E;if(s==="mousedown"&&h.getButton(c)===0&&c.detail!==2)return c.target===this.inner?(p=this,g=c.clientY,b=c.clientY,w=this.thumbTop,h.capture(this.inner,function(W){g=W.clientY},function(){clearInterval(E)}),E=setInterval(function(){var W;g!==void 0&&(W=p.scrollTopFromThumbTop(w+g-b))!==p.scrollTop&&p._emit("scroll",{data:W})},20)):(s=c.clientY-this.element.getBoundingClientRect().top-this.thumbHeight/2,this._emit("scroll",{data:this.scrollTopFromThumbTop(s)})),h.preventDefault(c)},a.prototype.getHeight=function(){return this.height},a.prototype.scrollTopFromThumbTop=function(s){return s=s*(this.pageHeight-this.viewHeight)/(this.slideHeight-this.thumbHeight),(s>>=0)<0?s=0:s>this.pageHeight-this.viewHeight&&(s=this.pageHeight-this.viewHeight),s},a.prototype.getWidth=function(){return Math.max(this.isVisible?this.width:0,this.$minWidth||0)},a.prototype.setHeight=function(s){this.height=Math.max(0,s),this.slideHeight=this.height,this.viewHeight=this.height,this.setScrollHeight(this.pageHeight,!0)},a.prototype.setScrollHeight=function(s,c){(this.pageHeight!==s||c)&&(this.pageHeight=s,this.thumbHeight=this.slideHeight*this.viewHeight/this.pageHeight,this.thumbHeight>this.slideHeight&&(this.thumbHeight=this.slideHeight),this.thumbHeight<15&&(this.thumbHeight=15),this.inner.style.height=this.thumbHeight+"px",this.scrollTop>this.pageHeight-this.viewHeight)&&(this.scrollTop=this.pageHeight-this.viewHeight,this.scrollTop<0&&(this.scrollTop=0),this._emit("scroll",{data:this.scrollTop}))},a.prototype.setScrollTop=function(s){this.scrollTop=s,this.thumbTop=(s=s<0?0:s)*(this.slideHeight-this.thumbHeight)/(this.pageHeight-this.viewHeight),this.inner.style.top=this.thumbTop+"px"};var o,i=a;function a(s,c){var p=o.call(this,s,"-v")||this;return p.scrollTop=0,p.scrollHeight=0,p.parent=s,p.width=p.VScrollWidth,p.renderer=c,p.inner.style.width=p.element.style.width=(p.width||15)+"px",p.$minWidth=0,p}i.prototype.setInnerHeight=i.prototype.setScrollHeight,C(t,r=l),t.prototype.onMouseDown=function(s,c){var p,g,b,w,E;if(s==="mousedown"&&h.getButton(c)===0&&c.detail!==2)return c.target===this.inner?(p=this,g=c.clientX,b=c.clientX,w=this.thumbLeft,h.capture(this.inner,function(W){g=W.clientX},function(){clearInterval(E)}),E=setInterval(function(){var W;g!==void 0&&(W=p.scrollLeftFromThumbLeft(w+g-b))!==p.scrollLeft&&p._emit("scroll",{data:W})},20)):(s=c.clientX-this.element.getBoundingClientRect().left-this.thumbWidth/2,this._emit("scroll",{data:this.scrollLeftFromThumbLeft(s)})),h.preventDefault(c)},t.prototype.getHeight=function(){return this.isVisible?this.height:0},t.prototype.scrollLeftFromThumbLeft=function(s){return s=s*(this.pageWidth-this.viewWidth)/(this.slideWidth-this.thumbWidth),(s>>=0)<0?s=0:s>this.pageWidth-this.viewWidth&&(s=this.pageWidth-this.viewWidth),s},t.prototype.setWidth=function(s){this.width=Math.max(0,s),this.element.style.width=this.width+"px",this.slideWidth=this.width,this.viewWidth=this.width,this.setScrollWidth(this.pageWidth,!0)},t.prototype.setScrollWidth=function(s,c){(this.pageWidth!==s||c)&&(this.pageWidth=s,this.thumbWidth=this.slideWidth*this.viewWidth/this.pageWidth,this.thumbWidth>this.slideWidth&&(this.thumbWidth=this.slideWidth),this.thumbWidth<15&&(this.thumbWidth=15),this.inner.style.width=this.thumbWidth+"px",this.scrollLeft>this.pageWidth-this.viewWidth)&&(this.scrollLeft=this.pageWidth-this.viewWidth,this.scrollLeft<0&&(this.scrollLeft=0),this._emit("scroll",{data:this.scrollLeft}))},t.prototype.setScrollLeft=function(s){this.scrollLeft=s,this.thumbLeft=(s=s<0?0:s)*(this.slideWidth-this.thumbWidth)/(this.pageWidth-this.viewWidth),this.inner.style.left=this.thumbLeft+"px"};var r,e=t;function t(s,c){return s=r.call(this,s,"-h")||this,s.scrollLeft=0,s.scrollWidth=0,s.height=s.HScrollHeight,s.inner.style.height=s.element.style.height=(s.height||12)+"px",s.renderer=c,s}e.prototype.setInnerWidth=e.prototype.setScrollWidth,f.ScrollBar=i,f.ScrollBarV=i,f.ScrollBarH=e,f.VScrollBar=i,f.HScrollBar=e}),ace.define("ace/renderloop",["require","exports","module","ace/lib/event"],function(A,f,R){var y=A("./lib/event");function C(d,h){this.onRender=d,this.pending=!1,this.changes=0,this.$recursionLimit=2,this.window=h||window;var l=this;this._flush=function(n){l.pending=!1;var o=l.changes;o&&(y.blockIdle(100),l.changes=0,l.onRender(o)),l.changes?l.$recursionLimit--<0||l.schedule():l.$recursionLimit=2}}C.prototype.schedule=function(d){this.changes=this.changes|d,this.changes&&!this.pending&&(y.nextFrame(this._flush),this.pending=!0)},C.prototype.clear=function(d){var h=this.changes;return this.changes=0,h},f.RenderLoop=C}),ace.define("ace/layer/font_metrics",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/lib/useragent","ace/lib/event_emitter"],function(n,f,R){var y=n("../lib/oop"),C=n("../lib/dom"),d=n("../lib/lang"),h=n("../lib/event"),l=n("../lib/useragent"),n=n("../lib/event_emitter").EventEmitter,o=typeof ResizeObserver=="function",i=(a.prototype.$setMeasureNodeStyles=function(r,e){r.width=r.height="auto",r.left=r.top="0px",r.visibility="hidden",r.position="absolute",r.whiteSpace="pre",l.isIE<8?r["font-family"]="inherit":r.font="inherit",r.overflow=e?"hidden":"visible"},a.prototype.checkForSizeChanges=function(r){var e;!(r=r===void 0?this.$measureSizes():r)||this.$characterSize.width===r.width&&this.$characterSize.height===r.height||(this.$measureNode.style.fontWeight="bold",e=this.$measureSizes(),this.$measureNode.style.fontWeight="",this.$characterSize=r,this.charSizes=Object.create(null),this.allowBoldFonts=e&&e.width===r.width&&e.height===r.height,this._emit("changeCharacterSize",{data:r}))},a.prototype.$addObserver=function(){var r=this;this.$observer=new window.ResizeObserver(function(e){r.checkForSizeChanges()}),this.$observer.observe(this.$measureNode)},a.prototype.$pollSizeChanges=function(){var r;return this.$pollSizeChangesTimer||this.$observer?this.$pollSizeChangesTimer:(r=this).$pollSizeChangesTimer=h.onIdle(function e(){r.checkForSizeChanges(),h.onIdle(e,500)},500)},a.prototype.setPolling=function(r){r?this.$pollSizeChanges():this.$pollSizeChangesTimer&&(clearInterval(this.$pollSizeChangesTimer),this.$pollSizeChangesTimer=0)},a.prototype.$measureSizes=function(r){return r={height:(r||this.$measureNode).clientHeight,width:(r||this.$measureNode).clientWidth/512},r.width===0||r.height===0?null:r},a.prototype.$measureCharWidth=function(r){return this.$main.textContent=d.stringRepeat(r,512),this.$main.getBoundingClientRect().width/512},a.prototype.getCharacterWidth=function(r){var e=this.charSizes[r];return e=e===void 0?this.charSizes[r]=this.$measureCharWidth(r)/this.$characterSize.width:e},a.prototype.destroy=function(){clearInterval(this.$pollSizeChangesTimer),this.$observer&&this.$observer.disconnect(),this.el&&this.el.parentNode&&this.el.parentNode.removeChild(this.el)},a.prototype.$getZoom=function(r){return r&&r.parentElement?(window.getComputedStyle(r).zoom||1)*this.$getZoom(r.parentElement):1},a.prototype.$initTransformMeasureNodes=function(){function r(e,t){return["div",{style:"position: absolute;top:"+e+"px;left:"+t+"px;"}]}this.els=C.buildDom([r(0,0),r(200,0),r(0,200),r(200,200)],this.el)},a.prototype.transformCoordinates=function(r,e){function t(O,x,u){var _=O[1]*x[0]-O[0]*x[1];return[(-x[1]*u[0]+x[0]*u[1])/_,(+O[1]*u[0]-O[0]*u[1])/_]}function s(O,x){return[O[0]-x[0],O[1]-x[1]]}function c(O,x){return[O[0]+x[0],O[1]+x[1]]}function p(O,x){return[O*x[0],O*x[1]]}function g(O){return O=O.getBoundingClientRect(),[O.left,O.top]}r=r&&p(1/this.$getZoom(this.el),r),this.els||this.$initTransformMeasureNodes();var b,w=g(this.els[0]),W=g(this.els[1]),B=g(this.els[2]),E=g(this.els[3]),E=t(s(E,W),s(E,B),s(c(W,B),c(E,w))),W=p(1+E[0],s(W,w)),B=p(1+E[1],s(B,w));return e?(b=E[0]*e[0]/200+E[1]*e[1]/200+1,e=c(p(e[0],W),p(e[1],B)),c(p(1/b/200,e),w)):(b=s(r,w),e=t(s(W,p(E[0],b)),s(B,p(E[1],b)),b),p(200,e))},a);function a(r){this.el=C.createElement("div"),this.$setMeasureNodeStyles(this.el.style,!0),this.$main=C.createElement("div"),this.$setMeasureNodeStyles(this.$main.style),this.$measureNode=C.createElement("div"),this.$setMeasureNodeStyles(this.$measureNode.style),this.el.appendChild(this.$main),this.el.appendChild(this.$measureNode),r.appendChild(this.el),this.$measureNode.textContent=d.stringRepeat("X",512),this.$characterSize={width:0,height:0},o?this.$addObserver():this.checkForSizeChanges()}i.prototype.$characterSize={width:0,height:0},y.implement(i.prototype,n),f.FontMetrics=i}),ace.define("ace/css/editor-css",["require","exports","module"],function(A,f,R){R.exports=`
.ace_br1 {border-top-left-radius    : 3px;}
.ace_br2 {border-top-right-radius   : 3px;}
.ace_br3 {border-top-left-radius    : 3px; border-top-right-radius:    3px;}
.ace_br4 {border-bottom-right-radius: 3px;}
.ace_br5 {border-top-left-radius    : 3px; border-bottom-right-radius: 3px;}
.ace_br6 {border-top-right-radius   : 3px; border-bottom-right-radius: 3px;}
.ace_br7 {border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px;}
.ace_br8 {border-bottom-left-radius : 3px;}
.ace_br9 {border-top-left-radius    : 3px; border-bottom-left-radius:  3px;}
.ace_br10{border-top-right-radius   : 3px; border-bottom-left-radius:  3px;}
.ace_br11{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-left-radius:  3px;}
.ace_br12{border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}
.ace_br13{border-top-left-radius    : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}
.ace_br14{border-top-right-radius   : 3px; border-bottom-right-radius: 3px; border-bottom-left-radius:  3px;}
.ace_br15{border-top-left-radius    : 3px; border-top-right-radius:    3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px;}


.ace_editor {
    position: relative;
    overflow: hidden;
    padding: 0;
    font: 12px/normal 'Monaco', 'Menlo', 'Ubuntu Mono', 'Consolas', 'Source Code Pro', 'source-code-pro', monospace;
    direction: ltr;
    text-align: left;
    -webkit-tap-highlight-color: rgba(0, 0, 0, 0);
}

.ace_scroller {
    position: absolute;
    overflow: hidden;
    top: 0;
    bottom: 0;
    background-color: inherit;
    -ms-user-select: none;
    -moz-user-select: none;
    -webkit-user-select: none;
    user-select: none;
    cursor: text;
}

.ace_content {
    position: absolute;
    box-sizing: border-box;
    min-width: 100%;
    contain: style size layout;
    font-variant-ligatures: no-common-ligatures;
}

.ace_keyboard-focus:focus {
    box-shadow: inset 0 0 0 2px #5E9ED6;
    outline: none;
}

.ace_dragging .ace_scroller:before{
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    content: '';
    background: rgba(250, 250, 250, 0.01);
    z-index: 1000;
}
.ace_dragging.ace_dark .ace_scroller:before{
    background: rgba(0, 0, 0, 0.01);
}

.ace_gutter {
    position: absolute;
    overflow : hidden;
    width: auto;
    top: 0;
    bottom: 0;
    left: 0;
    cursor: default;
    z-index: 4;
    -ms-user-select: none;
    -moz-user-select: none;
    -webkit-user-select: none;
    user-select: none;
    contain: style size layout;
}

.ace_gutter-active-line {
    position: absolute;
    left: 0;
    right: 0;
}

.ace_scroller.ace_scroll-left:after {
    content: "";
    position: absolute;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    box-shadow: 17px 0 16px -16px rgba(0, 0, 0, 0.4) inset;
    pointer-events: none;
}

.ace_gutter-cell, .ace_gutter-cell_svg-icons {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    padding-left: 19px;
    padding-right: 6px;
    background-repeat: no-repeat;
}

.ace_gutter-cell_svg-icons .ace_gutter_annotation {
    margin-left: -14px;
    float: left;
}

.ace_gutter-cell .ace_gutter_annotation {
    margin-left: -19px;
    float: left;
}

.ace_gutter-cell.ace_error, .ace_icon.ace_error, .ace_icon.ace_error_fold {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAABOFBMVEX/////////QRswFAb/Ui4wFAYwFAYwFAaWGAfDRymzOSH/PxswFAb/SiUwFAYwFAbUPRvjQiDllog5HhHdRybsTi3/Tyv9Tir+Syj/UC3////XurebMBIwFAb/RSHbPx/gUzfdwL3kzMivKBAwFAbbvbnhPx66NhowFAYwFAaZJg8wFAaxKBDZurf/RB6mMxb/SCMwFAYwFAbxQB3+RB4wFAb/Qhy4Oh+4QifbNRcwFAYwFAYwFAb/QRzdNhgwFAYwFAbav7v/Uy7oaE68MBK5LxLewr/r2NXewLswFAaxJw4wFAbkPRy2PyYwFAaxKhLm1tMwFAazPiQwFAaUGAb/QBrfOx3bvrv/VC/maE4wFAbRPBq6MRO8Qynew8Dp2tjfwb0wFAbx6eju5+by6uns4uH9/f36+vr/GkHjAAAAYnRSTlMAGt+64rnWu/bo8eAA4InH3+DwoN7j4eLi4xP99Nfg4+b+/u9B/eDs1MD1mO7+4PHg2MXa347g7vDizMLN4eG+Pv7i5evs/v79yu7S3/DV7/498Yv24eH+4ufQ3Ozu/v7+y13sRqwAAADLSURBVHjaZc/XDsFgGIBhtDrshlitmk2IrbHFqL2pvXf/+78DPokj7+Fz9qpU/9UXJIlhmPaTaQ6QPaz0mm+5gwkgovcV6GZzd5JtCQwgsxoHOvJO15kleRLAnMgHFIESUEPmawB9ngmelTtipwwfASilxOLyiV5UVUyVAfbG0cCPHig+GBkzAENHS0AstVF6bacZIOzgLmxsHbt2OecNgJC83JERmePUYq8ARGkJx6XtFsdddBQgZE2nPR6CICZhawjA4Fb/chv+399kfR+MMMDGOQAAAABJRU5ErkJggg==");
    background-repeat: no-repeat;
    background-position: 2px center;
}

.ace_gutter-cell.ace_warning, .ace_icon.ace_warning, .ace_icon.ace_warning_fold {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAMAAAAoLQ9TAAAAmVBMVEX///8AAAD///8AAAAAAABPSzb/5sAAAAB/blH/73z/ulkAAAAAAAD85pkAAAAAAAACAgP/vGz/rkDerGbGrV7/pkQICAf////e0IsAAAD/oED/qTvhrnUAAAD/yHD/njcAAADuv2r/nz//oTj/p064oGf/zHAAAAA9Nir/tFIAAAD/tlTiuWf/tkIAAACynXEAAAAAAAAtIRW7zBpBAAAAM3RSTlMAABR1m7RXO8Ln31Z36zT+neXe5OzooRDfn+TZ4p3h2hTf4t3k3ucyrN1K5+Xaks52Sfs9CXgrAAAAjklEQVR42o3PbQ+CIBQFYEwboPhSYgoYunIqqLn6/z8uYdH8Vmdnu9vz4WwXgN/xTPRD2+sgOcZjsge/whXZgUaYYvT8QnuJaUrjrHUQreGczuEafQCO/SJTufTbroWsPgsllVhq3wJEk2jUSzX3CUEDJC84707djRc5MTAQxoLgupWRwW6UB5fS++NV8AbOZgnsC7BpEAAAAABJRU5ErkJggg==");
    background-repeat: no-repeat;
    background-position: 2px center;
}

.ace_gutter-cell.ace_info, .ace_icon.ace_info {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAAAAAA6mKC9AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAAJ0Uk5TAAB2k804AAAAPklEQVQY02NgIB68QuO3tiLznjAwpKTgNyDbMegwisCHZUETUZV0ZqOquBpXj2rtnpSJT1AEnnRmL2OgGgAAIKkRQap2htgAAAAASUVORK5CYII=");
    background-repeat: no-repeat;
    background-position: 2px center;
}
.ace_dark .ace_gutter-cell.ace_info, .ace_dark .ace_icon.ace_info {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQBAMAAADt3eJSAAAAJFBMVEUAAAChoaGAgIAqKiq+vr6tra1ZWVmUlJSbm5s8PDxubm56enrdgzg3AAAAAXRSTlMAQObYZgAAAClJREFUeNpjYMAPdsMYHegyJZFQBlsUlMFVCWUYKkAZMxZAGdxlDMQBAG+TBP4B6RyJAAAAAElFTkSuQmCC");
}

.ace_icon_svg.ace_error {
    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiI+CjxnIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlPSJyZWQiIHNoYXBlLXJlbmRlcmluZz0iZ2VvbWV0cmljUHJlY2lzaW9uIj4KPGNpcmNsZSBmaWxsPSJub25lIiBjeD0iOCIgY3k9IjgiIHI9IjciIHN0cm9rZS1saW5lam9pbj0icm91bmQiLz4KPGxpbmUgeDE9IjExIiB5MT0iNSIgeDI9IjUiIHkyPSIxMSIvPgo8bGluZSB4MT0iMTEiIHkxPSIxMSIgeDI9IjUiIHkyPSI1Ii8+CjwvZz4KPC9zdmc+");
    background-color: crimson;
}
.ace_icon_svg.ace_warning {
    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiI+CjxnIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlPSJkYXJrb3JhbmdlIiBzaGFwZS1yZW5kZXJpbmc9Imdlb21ldHJpY1ByZWNpc2lvbiI+Cjxwb2x5Z29uIHN0cm9rZS1saW5lam9pbj0icm91bmQiIGZpbGw9Im5vbmUiIHBvaW50cz0iOCAxIDE1IDE1IDEgMTUgOCAxIi8+CjxyZWN0IHg9IjgiIHk9IjEyIiB3aWR0aD0iMC4wMSIgaGVpZ2h0PSIwLjAxIi8+CjxsaW5lIHgxPSI4IiB5MT0iNiIgeDI9IjgiIHkyPSIxMCIvPgo8L2c+Cjwvc3ZnPg==");
    background-color: darkorange;
}
.ace_icon_svg.ace_info {
    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiI+CjxnIHN0cm9rZS13aWR0aD0iMiIgc3Ryb2tlPSJibHVlIiBzaGFwZS1yZW5kZXJpbmc9Imdlb21ldHJpY1ByZWNpc2lvbiI+CjxjaXJjbGUgZmlsbD0ibm9uZSIgY3g9IjgiIGN5PSI4IiByPSI3IiBzdHJva2UtbGluZWpvaW49InJvdW5kIi8+Cjxwb2x5bGluZSBwb2ludHM9IjggMTEgOCA4Ii8+Cjxwb2x5bGluZSBwb2ludHM9IjkgOCA2IDgiLz4KPGxpbmUgeDE9IjEwIiB5MT0iMTEiIHgyPSI2IiB5Mj0iMTEiLz4KPHJlY3QgeD0iOCIgeT0iNSIgd2lkdGg9IjAuMDEiIGhlaWdodD0iMC4wMSIvPgo8L2c+Cjwvc3ZnPg==");
    background-color: royalblue;
}

.ace_icon_svg.ace_error_fold {
    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAxNiIgZmlsbD0ibm9uZSI+CiAgPHBhdGggZD0ibSAxOC45Mjk4NTEsNy44Mjk4MDc2IGMgMC4xNDYzNTMsNi4zMzc0NjA0IC02LjMyMzE0Nyw3Ljc3Nzg0NDQgLTcuNDc3OTEyLDcuNzc3ODQ0NCAtMi4xMDcyNzI2LC0wLjEyODc1IDUuMTE3Njc4LDAuMzU2MjQ5IDUuMDUxNjk4LC03Ljg3MDA2MTggLTAuNjA0NjcyLC04LjAwMzk3MzQ5IC03LjA3NzI3MDYsLTcuNTYzMTE4OSAtNC44NTczLC03LjQzMDM5NTU2IDEuNjA2LC0wLjExNTE0MjI1IDYuODk3NDg1LDEuMjYyNTQ1OTYgNy4yODM1MTQsNy41MjI2MTI5NiB6IiBmaWxsPSJjcmltc29uIiBzdHJva2Utd2lkdGg9IjIiLz4KICA8cGF0aCBmaWxsLXJ1bGU9ImV2ZW5vZGQiIGNsaXAtcnVsZT0iZXZlbm9kZCIgZD0ibSA4LjExNDc1NjIsMi4wNTI5ODI4IGMgMy4zNDkxNjk4LDAgNi4wNjQxMzI4LDIuNjc2ODYyNyA2LjA2NDEzMjgsNS45Nzg5NTMgMCwzLjMwMjExMjIgLTIuNzE0OTYzLDUuOTc4OTIwMiAtNi4wNjQxMzI4LDUuOTc4OTIwMiAtMy4zNDkxNDczLDAgLTYuMDY0MTc3MiwtMi42NzY4MDggLTYuMDY0MTc3MiwtNS45Nzg5MjAyIDAuMDA1MzksLTMuMjk5ODg2MSAyLjcxNzI2NTYsLTUuOTczNjQwOCA2LjA2NDE3NzIsLTUuOTc4OTUzIHogbSAwLC0xLjczNTgyNzE5IGMgLTQuMzIxNDgzNiwwIC03LjgyNDc0MDM4LDMuNDU0MDE4NDkgLTcuODI0NzQwMzgsNy43MTQ3ODAxOSAwLDQuMjYwNzI4MiAzLjUwMzI1Njc4LDcuNzE0NzQ1MiA3LjgyNDc0MDM4LDcuNzE0NzQ1MiA0LjMyMTQ0OTgsMCA3LjgyNDY5OTgsLTMuNDU0MDE3IDcuODI0Njk5OCwtNy43MTQ3NDUyIDAsLTIuMDQ2MDkxNCAtMC44MjQzOTIsLTQuMDA4MzY3MiAtMi4yOTE3NTYsLTUuNDU1MTc0NiBDIDEyLjE4MDIyNSwxLjEyOTk2NDggMTAuMTkwMDEzLDAuMzE3MTU1NjEgOC4xMTQ3NTYyLDAuMzE3MTU1NjEgWiBNIDYuOTM3NDU2Myw4LjI0MDU5ODUgNC42NzE4Njg1LDEwLjQ4NTg1MiA2LjAwODY4MTQsMTEuODc2NzI4IDguMzE3MDAzNSw5LjYwMDc5MTEgMTAuNjI1MzM3LDExLjg3NjcyOCAxMS45NjIxMzgsMTAuNDg1ODUyIDkuNjk2NTUwOCw4LjI0MDU5ODUgMTEuOTYyMTM4LDYuMDA2ODA2NiAxMC41NzMyNDYsNC42Mzc0MzM1IDguMzE3MDAzNSw2Ljg3MzQyOTcgNi4wNjA3NjA3LDQuNjM3NDMzNSA0LjY3MTg2ODUsNi4wMDY4MDY2IFoiIGZpbGw9ImNyaW1zb24iIHN0cm9rZS13aWR0aD0iMiIvPgo8L3N2Zz4=");
    background-color: crimson;
}
.ace_icon_svg.ace_warning_fold {
    -webkit-mask-image: url("data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMTYiIHZpZXdCb3g9IjAgMCAyMCAxNiIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xNC43NzY5IDE0LjczMzdMOC42NTE5MiAyLjQ4MzY5QzguMzI5NDYgMS44Mzg3NyA3LjQwOTEzIDEuODM4NzcgNy4wODY2NyAyLjQ4MzY5TDAuOTYxNjY5IDE0LjczMzdDMC42NzA3NzUgMTUuMzE1NSAxLjA5MzgzIDE2IDEuNzQ0MjkgMTZIMTMuOTk0M0MxNC42NDQ4IDE2IDE1LjA2NzggMTUuMzE1NSAxNC43NzY5IDE0LjczMzdaTTMuMTYwMDcgMTQuMjVMNy44NjkyOSA0LjgzMTU2TDEyLjU3ODUgMTQuMjVIMy4xNjAwN1pNOC43NDQyOSAxMS42MjVWMTMuMzc1SDYuOTk0MjlWMTEuNjI1SDguNzQ0MjlaTTYuOTk0MjkgMTAuNzVWNy4yNUg4Ljc0NDI5VjEwLjc1SDYuOTk0MjlaIiBmaWxsPSIjRUM3MjExIi8+CjxwYXRoIGQ9Ik0xMS4xOTkxIDIuOTUyMzhDMTAuODgwOSAyLjMxNDY3IDEwLjM1MzcgMS44MDUyNiA5LjcwNTUgMS41MDlMMTEuMDQxIDEuMDY5NzhDMTEuNjg4MyAwLjk0OTgxNCAxMi4zMzcgMS4yNzI2MyAxMi42MzE3IDEuODYxNDFMMTcuNjEzNiAxMS44MTYxQzE4LjM1MjcgMTMuMjkyOSAxNy41OTM4IDE1LjA4MDQgMTYuMDE4IDE1LjU3NDVDMTYuNDA0NCAxNC40NTA3IDE2LjMyMzEgMTMuMjE4OCAxNS43OTI0IDEyLjE1NTVMMTEuMTk5MSAyLjk1MjM4WiIgZmlsbD0iI0VDNzIxMSIvPgo8L3N2Zz4=");
    background-color: darkorange;
}

.ace_scrollbar {
    contain: strict;
    position: absolute;
    right: 0;
    bottom: 0;
    z-index: 6;
}

.ace_scrollbar-inner {
    position: absolute;
    cursor: text;
    left: 0;
    top: 0;
}

.ace_scrollbar-v{
    overflow-x: hidden;
    overflow-y: scroll;
    top: 0;
}

.ace_scrollbar-h {
    overflow-x: scroll;
    overflow-y: hidden;
    left: 0;
}

.ace_print-margin {
    position: absolute;
    height: 100%;
}

.ace_text-input {
    position: absolute;
    z-index: 0;
    width: 0.5em;
    height: 1em;
    opacity: 0;
    background: transparent;
    -moz-appearance: none;
    appearance: none;
    border: none;
    resize: none;
    outline: none;
    overflow: hidden;
    font: inherit;
    padding: 0 1px;
    margin: 0 -1px;
    contain: strict;
    -ms-user-select: text;
    -moz-user-select: text;
    -webkit-user-select: text;
    user-select: text;
    /*with \`pre-line\` chrome inserts &nbsp; instead of space*/
    white-space: pre!important;
}
.ace_text-input.ace_composition {
    background: transparent;
    color: inherit;
    z-index: 1000;
    opacity: 1;
}
.ace_composition_placeholder { color: transparent }
.ace_composition_marker { 
    border-bottom: 1px solid;
    position: absolute;
    border-radius: 0;
    margin-top: 1px;
}

[ace_nocontext=true] {
    transform: none!important;
    filter: none!important;
    clip-path: none!important;
    mask : none!important;
    contain: none!important;
    perspective: none!important;
    mix-blend-mode: initial!important;
    z-index: auto;
}

.ace_layer {
    z-index: 1;
    position: absolute;
    overflow: hidden;
    /* workaround for chrome bug https://github.com/ajaxorg/ace/issues/2312*/
    word-wrap: normal;
    white-space: pre;
    height: 100%;
    width: 100%;
    box-sizing: border-box;
    /* setting pointer-events: auto; on node under the mouse, which changes
        during scroll, will break mouse wheel scrolling in Safari */
    pointer-events: none;
}

.ace_gutter-layer {
    position: relative;
    width: auto;
    text-align: right;
    pointer-events: auto;
    height: 1000000px;
    contain: style size layout;
}

.ace_text-layer {
    font: inherit !important;
    position: absolute;
    height: 1000000px;
    width: 1000000px;
    contain: style size layout;
}

.ace_text-layer > .ace_line, .ace_text-layer > .ace_line_group {
    contain: style size layout;
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
}

.ace_hidpi .ace_text-layer,
.ace_hidpi .ace_gutter-layer,
.ace_hidpi .ace_content,
.ace_hidpi .ace_gutter {
    contain: strict;
}
.ace_hidpi .ace_text-layer > .ace_line, 
.ace_hidpi .ace_text-layer > .ace_line_group {
    contain: strict;
}

.ace_cjk {
    display: inline-block;
    text-align: center;
}

.ace_cursor-layer {
    z-index: 4;
}

.ace_cursor {
    z-index: 4;
    position: absolute;
    box-sizing: border-box;
    border-left: 2px solid;
    /* workaround for smooth cursor repaintng whole screen in chrome */
    transform: translatez(0);
}

.ace_multiselect .ace_cursor {
    border-left-width: 1px;
}

.ace_slim-cursors .ace_cursor {
    border-left-width: 1px;
}

.ace_overwrite-cursors .ace_cursor {
    border-left-width: 0;
    border-bottom: 1px solid;
}

.ace_hidden-cursors .ace_cursor {
    opacity: 0.2;
}

.ace_hasPlaceholder .ace_hidden-cursors .ace_cursor {
    opacity: 0;
}

.ace_smooth-blinking .ace_cursor {
    transition: opacity 0.18s;
}

.ace_animate-blinking .ace_cursor {
    animation-duration: 1000ms;
    animation-timing-function: step-end;
    animation-name: blink-ace-animate;
    animation-iteration-count: infinite;
}

.ace_animate-blinking.ace_smooth-blinking .ace_cursor {
    animation-duration: 1000ms;
    animation-timing-function: ease-in-out;
    animation-name: blink-ace-animate-smooth;
}
    
@keyframes blink-ace-animate {
    from, to { opacity: 1; }
    60% { opacity: 0; }
}

@keyframes blink-ace-animate-smooth {
    from, to { opacity: 1; }
    45% { opacity: 1; }
    60% { opacity: 0; }
    85% { opacity: 0; }
}

.ace_marker-layer .ace_step, .ace_marker-layer .ace_stack {
    position: absolute;
    z-index: 3;
}

.ace_marker-layer .ace_selection {
    position: absolute;
    z-index: 5;
}

.ace_marker-layer .ace_bracket {
    position: absolute;
    z-index: 6;
}

.ace_marker-layer .ace_error_bracket {
    position: absolute;
    border-bottom: 1px solid #DE5555;
    border-radius: 0;
}

.ace_marker-layer .ace_active-line {
    position: absolute;
    z-index: 2;
}

.ace_marker-layer .ace_selected-word {
    position: absolute;
    z-index: 4;
    box-sizing: border-box;
}

.ace_line .ace_fold {
    box-sizing: border-box;

    display: inline-block;
    height: 11px;
    margin-top: -2px;
    vertical-align: middle;

    background-image:
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACJJREFUeNpi+P//fxgTAwPDBxDxD078RSX+YeEyDFMCIMAAI3INmXiwf2YAAAAASUVORK5CYII=");
    background-repeat: no-repeat, repeat-x;
    background-position: center center, top left;
    color: transparent;

    border: 1px solid black;
    border-radius: 2px;

    cursor: pointer;
    pointer-events: auto;
}

.ace_dark .ace_fold {
}

.ace_fold:hover{
    background-image:
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABEAAAAJCAYAAADU6McMAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJpJREFUeNpi/P//PwOlgAXGYGRklAVSokD8GmjwY1wasKljQpYACtpCFeADcHVQfQyMQAwzwAZI3wJKvCLkfKBaMSClBlR7BOQikCFGQEErIH0VqkabiGCAqwUadAzZJRxQr/0gwiXIal8zQQPnNVTgJ1TdawL0T5gBIP1MUJNhBv2HKoQHHjqNrA4WO4zY0glyNKLT2KIfIMAAQsdgGiXvgnYAAAAASUVORK5CYII="),
        url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAA3CAYAAADNNiA5AAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAACBJREFUeNpi+P//fz4TAwPDZxDxD5X4i5fLMEwJgAADAEPVDbjNw87ZAAAAAElFTkSuQmCC");
}

.ace_tooltip {
    background-color: #f5f5f5;
    border: 1px solid gray;
    border-radius: 1px;
    box-shadow: 0 1px 2px rgba(0, 0, 0, 0.3);
    color: black;
    max-width: 100%;
    padding: 3px 4px;
    position: fixed;
    z-index: 999999;
    box-sizing: border-box;
    cursor: default;
    white-space: pre;
    word-wrap: break-word;
    line-height: normal;
    font-style: normal;
    font-weight: normal;
    letter-spacing: normal;
    pointer-events: none;
}

.ace_tooltip.ace_dark {
    background-color: #636363;
    color: #fff;
}

.ace_tooltip:focus {
    outline: 1px solid #5E9ED6;
}

.ace_icon {
    display: inline-block;
    width: 18px;
    vertical-align: top;
}

.ace_icon_svg {
    display: inline-block;
    width: 12px;
    vertical-align: top;
    -webkit-mask-repeat: no-repeat;
    -webkit-mask-size: 12px;
    -webkit-mask-position: center;
}

.ace_folding-enabled > .ace_gutter-cell, .ace_folding-enabled > .ace_gutter-cell_svg-icons {
    padding-right: 13px;
}

.ace_fold-widget {
    box-sizing: border-box;

    margin: 0 -12px 0 1px;
    display: none;
    width: 11px;
    vertical-align: top;

    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42mWKsQ0AMAzC8ixLlrzQjzmBiEjp0A6WwBCSPgKAXoLkqSot7nN3yMwR7pZ32NzpKkVoDBUxKAAAAABJRU5ErkJggg==");
    background-repeat: no-repeat;
    background-position: center;

    border-radius: 3px;
    
    border: 1px solid transparent;
    cursor: pointer;
}

.ace_folding-enabled .ace_fold-widget {
    display: inline-block;   
}

.ace_fold-widget.ace_end {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAANElEQVR42m3HwQkAMAhD0YzsRchFKI7sAikeWkrxwScEB0nh5e7KTPWimZki4tYfVbX+MNl4pyZXejUO1QAAAABJRU5ErkJggg==");
}

.ace_fold-widget.ace_closed {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAGCAYAAAAG5SQMAAAAOUlEQVR42jXKwQkAMAgDwKwqKD4EwQ26sSOkVWjgIIHAzPiCgaqiqnJHZnKICBERHN194O5b9vbLuAVRL+l0YWnZAAAAAElFTkSuQmCCXA==");
}

.ace_fold-widget:hover {
    border: 1px solid rgba(0, 0, 0, 0.3);
    background-color: rgba(255, 255, 255, 0.2);
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.7);
}

.ace_fold-widget:active {
    border: 1px solid rgba(0, 0, 0, 0.4);
    background-color: rgba(0, 0, 0, 0.05);
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.8);
}
/**
 * Dark version for fold widgets
 */
.ace_dark .ace_fold-widget {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAHklEQVQIW2P4//8/AzoGEQ7oGCaLLAhWiSwB146BAQCSTPYocqT0AAAAAElFTkSuQmCC");
}
.ace_dark .ace_fold-widget.ace_end {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAYAAACNbyblAAAAH0lEQVQIW2P4//8/AxQ7wNjIAjDMgC4AxjCVKBirIAAF0kz2rlhxpAAAAABJRU5ErkJggg==");
}
.ace_dark .ace_fold-widget.ace_closed {
    background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAMAAAAFCAYAAACAcVaiAAAAHElEQVQIW2P4//+/AxAzgDADlOOAznHAKgPWAwARji8UIDTfQQAAAABJRU5ErkJggg==");
}
.ace_dark .ace_fold-widget:hover {
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);
    background-color: rgba(255, 255, 255, 0.1);
}
.ace_dark .ace_fold-widget:active {
    box-shadow: 0 1px 1px rgba(255, 255, 255, 0.2);
}

.ace_inline_button {
    border: 1px solid lightgray;
    display: inline-block;
    margin: -1px 8px;
    padding: 0 5px;
    pointer-events: auto;
    cursor: pointer;
}
.ace_inline_button:hover {
    border-color: gray;
    background: rgba(200,200,200,0.2);
    display: inline-block;
    pointer-events: auto;
}

.ace_fold-widget.ace_invalid {
    background-color: #FFB4B4;
    border-color: #DE5555;
}

.ace_fade-fold-widgets .ace_fold-widget {
    transition: opacity 0.4s ease 0.05s;
    opacity: 0;
}

.ace_fade-fold-widgets:hover .ace_fold-widget {
    transition: opacity 0.05s ease 0.05s;
    opacity:1;
}

.ace_underline {
    text-decoration: underline;
}

.ace_bold {
    font-weight: bold;
}

.ace_nobold .ace_bold {
    font-weight: normal;
}

.ace_italic {
    font-style: italic;
}


.ace_error-marker {
    background-color: rgba(255, 0, 0,0.2);
    position: absolute;
    z-index: 9;
}

.ace_highlight-marker {
    background-color: rgba(255, 255, 0,0.2);
    position: absolute;
    z-index: 8;
}

.ace_mobile-menu {
    position: absolute;
    line-height: 1.5;
    border-radius: 4px;
    -ms-user-select: none;
    -moz-user-select: none;
    -webkit-user-select: none;
    user-select: none;
    background: white;
    box-shadow: 1px 3px 2px grey;
    border: 1px solid #dcdcdc;
    color: black;
}
.ace_dark > .ace_mobile-menu {
    background: #333;
    color: #ccc;
    box-shadow: 1px 3px 2px grey;
    border: 1px solid #444;

}
.ace_mobile-button {
    padding: 2px;
    cursor: pointer;
    overflow: hidden;
}
.ace_mobile-button:hover {
    background-color: #eee;
    opacity:1;
}
.ace_mobile-button:active {
    background-color: #ddd;
}

.ace_placeholder {
    font-family: arial;
    transform: scale(0.9);
    transform-origin: left;
    white-space: pre;
    opacity: 0.7;
    margin: 0 10px;
}

.ace_ghost_text {
    opacity: 0.5;
    font-style: italic;
    white-space: pre;
}

.ace_screenreader-only {
    position:absolute;
    left:-10000px;
    top:auto;
    width:1px;
    height:1px;
    overflow:hidden;
}`}),ace.define("ace/layer/decorators",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter"],function(d,f,R){var y=d("../lib/dom"),C=d("../lib/oop"),d=d("../lib/event_emitter").EventEmitter,h=(l.prototype.$updateDecorators=function(n){var o=this.renderer.theme.isDark===!0?this.colors.dark:this.colors.light,i=(n&&(this.maxHeight=n.maxHeight,this.lineHeight=n.lineHeight,this.canvasHeight=n.height,(n.lastRow+1)*this.lineHeight<this.canvasHeight?this.heightRatio=1:this.heightRatio=this.canvasHeight/this.maxHeight),this.canvas.getContext("2d")),a=this.renderer.session.$annotations;if(i.clearRect(0,0,this.canvas.width,this.canvas.height),a)for(var r={info:1,warning:2,error:3},e=(a.forEach(function(w){w.priority=r[w.type]||null}),a=a.sort(function(w,E){return w.priority<E.priority?-1:w.priority>E.priority?1:0}),this.renderer.session.$foldData),t=0;t<a.length;t++){var s,b=a[t].row,c=this.compensateFoldRows(b,e),p=Math.round((b-c)*this.lineHeight*this.heightRatio),g=Math.round((b-c)*this.lineHeight*this.heightRatio),b=Math.round(((b-c)*this.lineHeight+this.lineHeight)*this.heightRatio);b-g<this.minDecorationHeight&&((s=(g+b)/2|0)<this.halfMinDecorationHeight?s=this.halfMinDecorationHeight:s+this.halfMinDecorationHeight>this.canvasHeight&&(s=this.canvasHeight-this.halfMinDecorationHeight),g=Math.round(s-this.halfMinDecorationHeight),b=Math.round(s+this.halfMinDecorationHeight)),i.fillStyle=o[a[t].type]||null,i.fillRect(0,p,this.canvasWidth,b-g)}n=this.renderer.session.selection.getCursor(),n&&(c=this.compensateFoldRows(n.row,e),p=Math.round((n.row-c)*this.lineHeight*this.heightRatio),i.fillStyle="rgba(0, 0, 0, 0.5)",i.fillRect(0,p,this.canvasWidth,2))},l.prototype.compensateFoldRows=function(n,o){var i=0;if(o&&0<o.length)for(var a=0;a<o.length;a++)n>o[a].start.row&&n<o[a].end.row?i+=n-o[a].start.row:n>=o[a].end.row&&(i+=o[a].end.row-o[a].start.row);return i},l);function l(n,o){this.canvas=y.createElement("canvas"),this.renderer=o,this.pixelRatio=1,this.maxHeight=o.layerConfig.maxHeight,this.lineHeight=o.layerConfig.lineHeight,this.canvasHeight=n.parent.scrollHeight,this.heightRatio=this.canvasHeight/this.maxHeight,this.canvasWidth=n.width,this.minDecorationHeight=2*this.pixelRatio|0,this.halfMinDecorationHeight=this.minDecorationHeight/2|0,this.canvas.width=this.canvasWidth,this.canvas.height=this.canvasHeight,this.canvas.style.top="0px",this.canvas.style.right="0px",this.canvas.style.zIndex="7px",this.canvas.style.position="absolute",this.colors={},this.colors.dark={error:"rgba(255, 18, 18, 1)",warning:"rgba(18, 136, 18, 1)",info:"rgba(18, 18, 136, 1)"},this.colors.light={error:"rgb(255,51,51)",warning:"rgb(32,133,72)",info:"rgb(35,68,138)"},n.element.appendChild(this.canvas)}C.implement(h.prototype,d),f.Decorator=h}),ace.define("ace/virtual_renderer",["require","exports","module","ace/lib/oop","ace/lib/dom","ace/lib/lang","ace/config","ace/layer/gutter","ace/layer/marker","ace/layer/text","ace/layer/cursor","ace/scrollbar","ace/scrollbar","ace/scrollbar_custom","ace/scrollbar_custom","ace/renderloop","ace/layer/font_metrics","ace/lib/event_emitter","ace/css/editor-css","ace/layer/decorators","ace/lib/useragent"],function(E,f,R){var y=E("./lib/oop"),C=E("./lib/dom"),d=E("./lib/lang"),h=E("./config"),l=E("./layer/gutter").Gutter,n=E("./layer/marker").Marker,o=E("./layer/text").Text,i=E("./layer/cursor").Cursor,a=E("./scrollbar").HScrollBar,r=E("./scrollbar").VScrollBar,e=E("./scrollbar_custom").HScrollBar,t=E("./scrollbar_custom").VScrollBar,s=E("./renderloop").RenderLoop,c=E("./layer/font_metrics").FontMetrics,p=E("./lib/event_emitter").EventEmitter,g=E("./css/editor-css"),b=E("./layer/decorators").Decorator,w=E("./lib/useragent"),E=(C.importCssString(g,"ace_editor.css",!1),W.prototype.updateCharacterSize=function(){this.$textLayer.allowBoldFonts!=this.$allowBoldFonts&&(this.$allowBoldFonts=this.$textLayer.allowBoldFonts,this.setStyle("ace_nobold",!this.$allowBoldFonts)),this.layerConfig.characterWidth=this.characterWidth=this.$textLayer.getCharacterWidth(),this.layerConfig.lineHeight=this.lineHeight=this.$textLayer.getLineHeight(),this.$updatePrintMargin(),C.setStyle(this.scroller.style,"line-height",this.lineHeight+"px")},W.prototype.setSession=function(B){this.session&&this.session.doc.off("changeNewLineMode",this.onChangeNewLineMode),(this.session=B)&&this.scrollMargin.top&&B.getScrollTop()<=0&&B.setScrollTop(-this.scrollMargin.top),this.$cursorLayer.setSession(B),this.$markerBack.setSession(B),this.$markerFront.setSession(B),this.$gutterLayer.setSession(B),this.$textLayer.setSession(B),B&&(this.$loop.schedule(this.CHANGE_FULL),this.session.$setFontMetrics(this.$fontMetrics),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.onChangeNewLineMode=this.onChangeNewLineMode.bind(this),this.onChangeNewLineMode(),this.session.doc.on("changeNewLineMode",this.onChangeNewLineMode))},W.prototype.updateLines=function(B,O,x){if(O===void 0&&(O=1/0),this.$changedLines?(this.$changedLines.firstRow>B&&(this.$changedLines.firstRow=B),this.$changedLines.lastRow<O&&(this.$changedLines.lastRow=O)):this.$changedLines={firstRow:B,lastRow:O},this.$changedLines.lastRow<this.layerConfig.firstRow){if(!x)return;this.$changedLines.lastRow=this.layerConfig.lastRow}this.$changedLines.firstRow>this.layerConfig.lastRow||this.$loop.schedule(this.CHANGE_LINES)},W.prototype.onChangeNewLineMode=function(){this.$loop.schedule(this.CHANGE_TEXT),this.$textLayer.$updateEolChar(),this.session.$bidiHandler.setEolChar(this.$textLayer.EOL_CHAR)},W.prototype.onChangeTabSize=function(){this.$loop.schedule(this.CHANGE_TEXT|this.CHANGE_MARKER),this.$textLayer.onChangeTabSize()},W.prototype.updateText=function(){this.$loop.schedule(this.CHANGE_TEXT)},W.prototype.updateFull=function(B){B?this.$renderChanges(this.CHANGE_FULL,!0):this.$loop.schedule(this.CHANGE_FULL)},W.prototype.updateFontSize=function(){this.$textLayer.checkForSizeChanges()},W.prototype.$updateSizeAsync=function(){this.$loop.pending?this.$size.$dirty=!0:this.onResize()},W.prototype.onResize=function(B,O,x,u){if(!(2<this.resizing)){0<this.resizing?this.resizing++:this.resizing=B?1:0;var _=this.container,_=(u=u||_.clientHeight||_.scrollHeight,x=x||_.clientWidth||_.scrollWidth,this.$updateCachedSize(B,O,x,u));if(this.$resizeTimer&&this.$resizeTimer.cancel(),!this.$size.scrollerHeight||!x&&!u)return this.resizing=0;B&&(this.$gutterLayer.$padding=null),B?this.$renderChanges(_|this.$changes,!0):this.$loop.schedule(_|this.$changes),this.resizing&&(this.resizing=0),this.scrollBarH.scrollLeft=this.scrollBarV.scrollTop=null,this.$customScrollbar&&this.$updateCustomScrollbar(!0)}},W.prototype.$updateCachedSize=function(B,O,x,u){u-=this.$extraHeight||0;var _=0,v=this.$size,$={width:v.width,height:v.height,scrollerHeight:v.scrollerHeight,scrollerWidth:v.scrollerWidth};return u&&(B||v.height!=u)&&(v.height=u,_|=this.CHANGE_SIZE,v.scrollerHeight=v.height,this.$horizScroll&&(v.scrollerHeight-=this.scrollBarH.getHeight()),this.scrollBarV.setHeight(v.scrollerHeight),this.scrollBarV.element.style.bottom=this.scrollBarH.getHeight()+"px",_|=this.CHANGE_SCROLL),x&&(B||v.width!=x)&&(_|=this.CHANGE_SIZE,v.width=x,O==null&&(O=this.$showGutter?this.$gutter.offsetWidth:0),this.gutterWidth=O,C.setStyle(this.scrollBarH.element.style,"left",O+"px"),C.setStyle(this.scroller.style,"left",O+this.margin.left+"px"),v.scrollerWidth=Math.max(0,x-O-this.scrollBarV.getWidth()-this.margin.h),C.setStyle(this.$gutter.style,"left",this.margin.left+"px"),O=this.scrollBarV.getWidth()+"px",C.setStyle(this.scrollBarH.element.style,"right",O),C.setStyle(this.scroller.style,"right",O),C.setStyle(this.scroller.style,"bottom",this.scrollBarH.getHeight()),this.scrollBarH.setWidth(v.scrollerWidth),this.session&&this.session.getUseWrapMode()&&this.adjustWrapLimit()||B)&&(_|=this.CHANGE_FULL),v.$dirty=!x||!u,_&&this._signal("resize",$),_},W.prototype.onGutterResize=function(B){B=this.$showGutter?B:0,B!=this.gutterWidth&&(this.$changes|=this.$updateCachedSize(!0,B,this.$size.width,this.$size.height)),this.session.getUseWrapMode()&&this.adjustWrapLimit()||this.$size.$dirty?this.$loop.schedule(this.CHANGE_FULL):this.$computeLayerConfig()},W.prototype.adjustWrapLimit=function(){var B=this.$size.scrollerWidth-2*this.$padding,B=Math.floor(B/this.characterWidth);return this.session.adjustWrapLimit(B,this.$showPrintMargin&&this.$printMarginColumn)},W.prototype.setAnimatedScroll=function(B){this.setOption("animatedScroll",B)},W.prototype.getAnimatedScroll=function(){return this.$animatedScroll},W.prototype.setShowInvisibles=function(B){this.setOption("showInvisibles",B),this.session.$bidiHandler.setShowInvisibles(B)},W.prototype.getShowInvisibles=function(){return this.getOption("showInvisibles")},W.prototype.getDisplayIndentGuides=function(){return this.getOption("displayIndentGuides")},W.prototype.setDisplayIndentGuides=function(B){this.setOption("displayIndentGuides",B)},W.prototype.getHighlightIndentGuides=function(){return this.getOption("highlightIndentGuides")},W.prototype.setHighlightIndentGuides=function(B){this.setOption("highlightIndentGuides",B)},W.prototype.setShowPrintMargin=function(B){this.setOption("showPrintMargin",B)},W.prototype.getShowPrintMargin=function(){return this.getOption("showPrintMargin")},W.prototype.setPrintMarginColumn=function(B){this.setOption("printMarginColumn",B)},W.prototype.getPrintMarginColumn=function(){return this.getOption("printMarginColumn")},W.prototype.getShowGutter=function(){return this.getOption("showGutter")},W.prototype.setShowGutter=function(B){return this.setOption("showGutter",B)},W.prototype.getFadeFoldWidgets=function(){return this.getOption("fadeFoldWidgets")},W.prototype.setFadeFoldWidgets=function(B){this.setOption("fadeFoldWidgets",B)},W.prototype.setHighlightGutterLine=function(B){this.setOption("highlightGutterLine",B)},W.prototype.getHighlightGutterLine=function(){return this.getOption("highlightGutterLine")},W.prototype.$updatePrintMargin=function(){var B;(this.$showPrintMargin||this.$printMarginEl)&&(this.$printMarginEl||((B=C.createElement("div")).className="ace_layer ace_print-margin-layer",this.$printMarginEl=C.createElement("div"),this.$printMarginEl.className="ace_print-margin",B.appendChild(this.$printMarginEl),this.content.insertBefore(B,this.content.firstChild)),(B=this.$printMarginEl.style).left=Math.round(this.characterWidth*this.$printMarginColumn+this.$padding)+"px",B.visibility=this.$showPrintMargin?"visible":"hidden",this.session)&&this.session.$wrap==-1&&this.adjustWrapLimit()},W.prototype.getContainerElement=function(){return this.container},W.prototype.getMouseEventTarget=function(){return this.scroller},W.prototype.getTextAreaContainer=function(){return this.container},W.prototype.$moveTextAreaToCursor=function(){var B,O,x,u,_,v,$;this.$isMousePressed||(B=this.textarea.style,v=this.$composition,this.$keepTextAreaAtCursor||v?(x=this.$cursorLayer.$pixelPos)&&(v&&v.markerRange&&(x=this.$cursorLayer.getPixelPosition(v.markerRange.start,!0)),$=this.layerConfig,O=x.top,x=x.left,O-=$.offset,u=v&&v.useTextareaForIME||w.isMobile?this.lineHeight:1,O<0||O>$.height-u?C.translate(this.textarea,0,0):($=1,_=this.$size.height-u,v?v.useTextareaForIME?(v=this.textarea.value,$=this.characterWidth*this.session.$getStringScreenWidth(v)[0]):O+=this.lineHeight+2:O+=this.lineHeight,(x-=this.scrollLeft)>this.$size.scrollerWidth-$&&(x=this.$size.scrollerWidth-$),x+=this.gutterWidth+this.margin.left,C.setStyle(B,"height",u+"px"),C.setStyle(B,"width",$+"px"),C.translate(this.textarea,Math.min(x,this.$size.scrollerWidth-$),Math.min(O,_)))):C.translate(this.textarea,-100,0))},W.prototype.getFirstVisibleRow=function(){return this.layerConfig.firstRow},W.prototype.getFirstFullyVisibleRow=function(){return this.layerConfig.firstRow+(this.layerConfig.offset===0?0:1)},W.prototype.getLastFullyVisibleRow=function(){var B=this.layerConfig,O=B.lastRow;return this.session.documentToScreenRow(O,0)*B.lineHeight-this.session.getScrollTop()>B.height-B.lineHeight?O-1:O},W.prototype.getLastVisibleRow=function(){return this.layerConfig.lastRow},W.prototype.setPadding=function(B){this.$padding=B,this.$textLayer.setPadding(B),this.$cursorLayer.setPadding(B),this.$markerFront.setPadding(B),this.$markerBack.setPadding(B),this.$loop.schedule(this.CHANGE_FULL),this.$updatePrintMargin()},W.prototype.setScrollMargin=function(B,O,x,u){var _=this.scrollMargin;_.top=0|B,_.bottom=0|O,_.right=0|u,_.left=0|x,_.v=_.top+_.bottom,_.h=_.left+_.right,_.top&&this.scrollTop<=0&&this.session&&this.session.setScrollTop(-_.top),this.updateFull()},W.prototype.setMargin=function(B,O,x,u){var _=this.margin;_.top=0|B,_.bottom=0|O,_.right=0|u,_.left=0|x,_.v=_.top+_.bottom,_.h=_.left+_.right,this.$updateCachedSize(!0,this.gutterWidth,this.$size.width,this.$size.height),this.updateFull()},W.prototype.getHScrollBarAlwaysVisible=function(){return this.$hScrollBarAlwaysVisible},W.prototype.setHScrollBarAlwaysVisible=function(B){this.setOption("hScrollBarAlwaysVisible",B)},W.prototype.getVScrollBarAlwaysVisible=function(){return this.$vScrollBarAlwaysVisible},W.prototype.setVScrollBarAlwaysVisible=function(B){this.setOption("vScrollBarAlwaysVisible",B)},W.prototype.$updateScrollBarV=function(){var B=this.layerConfig.maxHeight,O=this.$size.scrollerHeight;!this.$maxLines&&this.$scrollPastEnd&&(B-=(O-this.lineHeight)*this.$scrollPastEnd,this.scrollTop>B-O)&&(B=this.scrollTop+O,this.scrollBarV.scrollTop=null),this.scrollBarV.setScrollHeight(B+this.scrollMargin.v),this.scrollBarV.setScrollTop(this.scrollTop+this.scrollMargin.top)},W.prototype.$updateScrollBarH=function(){this.scrollBarH.setScrollWidth(this.layerConfig.width+2*this.$padding+this.scrollMargin.h),this.scrollBarH.setScrollLeft(this.scrollLeft+this.scrollMargin.left)},W.prototype.freeze=function(){this.$frozen=!0},W.prototype.unfreeze=function(){this.$frozen=!1},W.prototype.$renderChanges=function(B,O){if(this.$changes&&(B|=this.$changes,this.$changes=0),this.session&&this.container.offsetWidth&&!this.$frozen&&(B||O)){if(this.$size.$dirty)return this.$changes|=B,this.onResize(!0);this.lineHeight||this.$textLayer.checkForSizeChanges(),this._signal("beforeRender",B),this.session&&this.session.$bidiHandler&&this.session.$bidiHandler.updateCharacterWidths(this.$fontMetrics);var x,u,O=this.layerConfig;(B&this.CHANGE_FULL||B&this.CHANGE_SIZE||B&this.CHANGE_TEXT||B&this.CHANGE_LINES||B&this.CHANGE_SCROLL||B&this.CHANGE_H_SCROLL)&&(B|=this.$computeLayerConfig()|this.$loop.clear(),O.firstRow!=this.layerConfig.firstRow&&O.firstRowScreen==this.layerConfig.firstRowScreen&&0<(x=this.scrollTop+(O.firstRow-Math.max(this.layerConfig.firstRow,0))*this.lineHeight)&&(this.scrollTop=x,B=(B|=this.CHANGE_SCROLL)|(this.$computeLayerConfig()|this.$loop.clear())),O=this.layerConfig,this.$updateScrollBarV(),B&this.CHANGE_H_SCROLL&&this.$updateScrollBarH(),C.translate(this.content,-this.scrollLeft,-O.offset),x=O.width+2*this.$padding+"px",u=O.minHeight+"px",C.setStyle(this.content.style,"width",x),C.setStyle(this.content.style,"height",u)),B&this.CHANGE_H_SCROLL&&(C.translate(this.content,-this.scrollLeft,-O.offset),this.scroller.className=this.scrollLeft<=0?"ace_scroller ":"ace_scroller ace_scroll-left ",this.enableKeyboardAccessibility)&&(this.scroller.className+=this.keyboardFocusClassName),B&this.CHANGE_FULL?(this.$changedLines=null,this.$textLayer.update(O),this.$showGutter&&this.$gutterLayer.update(O),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(O),this.$markerBack.update(O),this.$markerFront.update(O),this.$cursorLayer.update(O),this.$moveTextAreaToCursor()):B&this.CHANGE_SCROLL?(this.$changedLines=null,B&this.CHANGE_TEXT||B&this.CHANGE_LINES?this.$textLayer.update(O):this.$textLayer.scrollLines(O),this.$showGutter&&(B&this.CHANGE_GUTTER||B&this.CHANGE_LINES?this.$gutterLayer.update(O):this.$gutterLayer.scrollLines(O)),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(O),this.$markerBack.update(O),this.$markerFront.update(O),this.$cursorLayer.update(O),this.$moveTextAreaToCursor()):(B&this.CHANGE_TEXT?(this.$changedLines=null,this.$textLayer.update(O),this.$showGutter&&this.$gutterLayer.update(O),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(O)):B&this.CHANGE_LINES?((this.$updateLines()||B&this.CHANGE_GUTTER&&this.$showGutter)&&this.$gutterLayer.update(O),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(O)):B&this.CHANGE_TEXT||B&this.CHANGE_GUTTER?(this.$showGutter&&this.$gutterLayer.update(O),this.$customScrollbar&&this.$scrollDecorator.$updateDecorators(O)):B&this.CHANGE_CURSOR&&(this.$highlightGutterLine&&this.$gutterLayer.updateLineHighlight(O),this.$customScrollbar)&&this.$scrollDecorator.$updateDecorators(O),B&this.CHANGE_CURSOR&&(this.$cursorLayer.update(O),this.$moveTextAreaToCursor()),B&(this.CHANGE_MARKER|this.CHANGE_MARKER_FRONT)&&this.$markerFront.update(O),B&(this.CHANGE_MARKER|this.CHANGE_MARKER_BACK)&&this.$markerBack.update(O)),this._signal("afterRender",B)}else this.$changes|=B},W.prototype.$autosize=function(){var B=this.session.getScreenLength()*this.lineHeight,O=this.$maxLines*this.lineHeight,x=Math.min(O,Math.max((this.$minLines||1)*this.lineHeight,B))+this.scrollMargin.v+(this.$extraHeight||0);this.$horizScroll&&(x+=this.scrollBarH.getHeight()),O=!((x=this.$maxPixelHeight&&x>this.$maxPixelHeight?this.$maxPixelHeight:x)<=2*this.lineHeight)&&O<B,x==this.desiredHeight&&this.$size.height==this.desiredHeight&&O==this.$vScroll||(O!=this.$vScroll&&(this.$vScroll=O,this.scrollBarV.setVisible(O)),B=this.container.clientWidth,this.container.style.height=x+"px",this.$updateCachedSize(!0,this.$gutterWidth,B,x),this.desiredHeight=x,this._signal("autosize"))},W.prototype.$computeLayerConfig=function(){var B,ne=this.session,O=this.$size,Q=O.height<=2*this.lineHeight,x=this.session.getScreenLength()*this.lineHeight,u=this.$getLongestLine(),M=!Q&&(this.$hScrollBarAlwaysVisible||O.scrollerWidth-u-2*this.$padding<0),_=this.$horizScroll!==M,M=(_&&(this.$horizScroll=M,this.scrollBarH.setVisible(M)),this.$vScroll),v=(this.$maxLines&&1<this.lineHeight&&this.$autosize(),O.scrollerHeight+this.lineHeight),$=!this.$maxLines&&this.$scrollPastEnd?(O.scrollerHeight-this.lineHeight)*this.$scrollPastEnd:0,P=(x+=$,this.scrollMargin),Q=(this.session.setScrollTop(Math.max(-P.top,Math.min(this.scrollTop,x-O.scrollerHeight+P.bottom))),this.session.setScrollLeft(Math.max(-P.left,Math.min(this.scrollLeft,u+2*this.$padding-O.scrollerWidth+P.right))),!Q&&(this.$vScrollBarAlwaysVisible||O.scrollerHeight-x+$<0||this.scrollTop>P.top)),$=M!==Q,P=($&&(this.$vScroll=Q,this.scrollBarV.setVisible(Q)),this.scrollTop%this.lineHeight),M=Math.ceil(v/this.lineHeight)-1,M=(Q=Math.max(0,Math.round((this.scrollTop-P)/this.lineHeight)))+M,X=this.lineHeight,Q=ne.screenToDocumentRow(Q,0),K=ne.getFoldLine(Q),ne=(K&&(Q=K.start.row),K=ne.documentToScreenRow(Q,0),B=ne.getRowLength(Q)*X,M=Math.min(ne.screenToDocumentRow(M,0),ne.getLength()-1),v=O.scrollerHeight+ne.getRowLength(M)*X+B,P=this.scrollTop-K*X,0);return this.layerConfig.width==u&&!_||(ne=this.CHANGE_H_SCROLL),(_||$)&&(ne|=this.$updateCachedSize(!0,this.gutterWidth,O.width,O.height),this._signal("scrollbarVisibilityChanged"),$)&&(u=this.$getLongestLine()),this.layerConfig={width:u,padding:this.$padding,firstRow:Q,firstRowScreen:K,lastRow:M,lineHeight:X,characterWidth:this.characterWidth,minHeight:v,maxHeight:x,offset:P,gutterOffset:X?Math.max(0,Math.ceil((P+O.height-O.scrollerHeight)/X)):0,height:this.$size.scrollerHeight},this.session.$bidiHandler&&this.session.$bidiHandler.setContentWidth(u-this.$padding),ne},W.prototype.$updateLines=function(){if(this.$changedLines){var B=this.$changedLines.firstRow,O=this.$changedLines.lastRow,x=(this.$changedLines=null,this.layerConfig);if(!(B>x.lastRow+1||O<x.firstRow)){if(O!==1/0)return this.$textLayer.updateLines(x,B,O),!0;this.$showGutter&&this.$gutterLayer.update(x),this.$textLayer.update(x)}}},W.prototype.$getLongestLine=function(){var B=this.session.getScreenWidth();return this.showInvisibles&&!this.session.$useWrapMode&&(B+=1),this.$textLayer&&B>this.$textLayer.MAX_LINE_LENGTH&&(B=this.$textLayer.MAX_LINE_LENGTH+30),Math.max(this.$size.scrollerWidth-2*this.$padding,Math.round(B*this.characterWidth))},W.prototype.updateFrontMarkers=function(){this.$markerFront.setMarkers(this.session.getMarkers(!0)),this.$loop.schedule(this.CHANGE_MARKER_FRONT)},W.prototype.updateBackMarkers=function(){this.$markerBack.setMarkers(this.session.getMarkers()),this.$loop.schedule(this.CHANGE_MARKER_BACK)},W.prototype.addGutterDecoration=function(B,O){this.$gutterLayer.addGutterDecoration(B,O)},W.prototype.removeGutterDecoration=function(B,O){this.$gutterLayer.removeGutterDecoration(B,O)},W.prototype.updateBreakpoints=function(B){this.$loop.schedule(this.CHANGE_GUTTER)},W.prototype.setAnnotations=function(B){this.$gutterLayer.setAnnotations(B),this.$loop.schedule(this.CHANGE_GUTTER)},W.prototype.updateCursor=function(){this.$loop.schedule(this.CHANGE_CURSOR)},W.prototype.hideCursor=function(){this.$cursorLayer.hideCursor()},W.prototype.showCursor=function(){this.$cursorLayer.showCursor()},W.prototype.scrollSelectionIntoView=function(B,O,x){this.scrollCursorIntoView(B,x),this.scrollCursorIntoView(O,x)},W.prototype.scrollCursorIntoView=function(B,O,x){var u,_,v;this.$size.scrollerHeight!==0&&(u=(B=this.$cursorLayer.getPixelPosition(B)).left,B=B.top,_=x&&x.top||0,x=x&&x.bottom||0,this.$scrollAnimation&&(this.$stopAnimation=!0),B<(v=this.$scrollAnimation?this.session.getScrollTop():this.scrollTop)+_?(O&&v+_>B+this.lineHeight&&(B-=O*this.$size.scrollerHeight),B===0&&(B=-this.scrollMargin.top),this.session.setScrollTop(B)):v+this.$size.scrollerHeight-x<B+this.lineHeight&&(O&&v+this.$size.scrollerHeight-x<B-this.lineHeight&&(B+=O*this.$size.scrollerHeight),this.session.setScrollTop(B+this.lineHeight+x-this.$size.scrollerHeight)),_=this.scrollLeft,u-(v=2*this.layerConfig.characterWidth)<_?((u-=v)<this.$padding+v&&(u=-this.scrollMargin.left),this.session.setScrollLeft(u)):_+this.$size.scrollerWidth<(u+=v)+this.characterWidth?this.session.setScrollLeft(Math.round(u+this.characterWidth-this.$size.scrollerWidth)):_<=this.$padding&&u-_<this.characterWidth&&this.session.setScrollLeft(0))},W.prototype.getScrollTop=function(){return this.session.getScrollTop()},W.prototype.getScrollLeft=function(){return this.session.getScrollLeft()},W.prototype.getScrollTopRow=function(){return this.scrollTop/this.lineHeight},W.prototype.getScrollBottomRow=function(){return Math.max(0,Math.floor((this.scrollTop+this.$size.scrollerHeight)/this.lineHeight)-1)},W.prototype.scrollToRow=function(B){this.session.setScrollTop(B*this.lineHeight)},W.prototype.alignCursor=function(u,O){var u=this.$cursorLayer.getPixelPosition(u=typeof u=="number"?{row:u,column:0}:u),x=this.$size.scrollerHeight-this.lineHeight,u=u.top-x*(O||0);return this.session.setScrollTop(u),u},W.prototype.$calcSteps=function(B,O){for(var x,u,$=0,_=this.STEPS,v=[],$=0;$<_;++$)v.push((x=$/this.STEPS,(O-(u=B))*(Math.pow(x-1,3)+1)+u));return v},W.prototype.scrollToLine=function(B,O,x,u){B=this.$cursorLayer.getPixelPosition({row:B,column:0}).top,O&&(B-=this.$size.scrollerHeight/2),O=this.scrollTop,this.session.setScrollTop(B),x!==!1&&this.animateScrolling(O,u)},W.prototype.animateScrolling=function(B,O){var x=this.scrollTop;if(this.$animatedScroll){var u=this;if(B!=x){if(this.$scrollAnimation){var _=this.$scrollAnimation.steps;if(_.length&&(B=_[0])==x)return}var v=u.$calcSteps(B,x);this.$scrollAnimation={from:B,to:x,steps:v},clearInterval(this.$timer),u.session.setScrollTop(v.shift()),u.session.$scrollTop=x,this.$timer=setInterval(function(){if(!u.$stopAnimation)return u.session?void(v.length?(u.session.setScrollTop(v.shift()),u.session.$scrollTop=x):x!=null?(u.session.$scrollTop=-1,u.session.setScrollTop(x),x=null):$()):clearInterval(u.$timer);$()},10)}}function $(){u.$timer=clearInterval(u.$timer),u.$scrollAnimation=null,u.$stopAnimation=!1,O&&O()}},W.prototype.scrollToY=function(B){this.scrollTop!==B&&(this.$loop.schedule(this.CHANGE_SCROLL),this.scrollTop=B)},W.prototype.scrollToX=function(B){this.scrollLeft!==B&&(this.scrollLeft=B),this.$loop.schedule(this.CHANGE_H_SCROLL)},W.prototype.scrollTo=function(B,O){this.session.setScrollTop(O),this.session.setScrollLeft(B)},W.prototype.scrollBy=function(B,O){O&&this.session.setScrollTop(this.session.getScrollTop()+O),B&&this.session.setScrollLeft(this.session.getScrollLeft()+B)},W.prototype.isScrollableBy=function(B,O){return O<0&&this.session.getScrollTop()>=1-this.scrollMargin.top||0<O&&this.session.getScrollTop()+this.$size.scrollerHeight-this.layerConfig.maxHeight<-1+this.scrollMargin.bottom||B<0&&this.session.getScrollLeft()>=1-this.scrollMargin.left||0<B&&this.session.getScrollLeft()+this.$size.scrollerWidth-this.layerConfig.width<-1+this.scrollMargin.right||void 0},W.prototype.pixelToScreenCoordinates=function(u,_){this.$hasCssTransforms?(v={top:0,left:0},u=(x=this.$fontMetrics.transformCoordinates([u,_]))[1]-this.gutterWidth-this.margin.left,_=x[0]):v=this.scroller.getBoundingClientRect();var x=u+this.scrollLeft-v.left-this.$padding,u=x/this.characterWidth,_=Math.floor((_+this.scrollTop-v.top)/this.lineHeight),v=this.$blockCursor?Math.floor(u):Math.round(u);return{row:_,column:v,side:0<u-v?1:-1,offsetX:x}},W.prototype.screenToTextCoordinates=function(_,v){this.$hasCssTransforms?(x={top:0,left:0},_=(u=this.$fontMetrics.transformCoordinates([_,v]))[1]-this.gutterWidth-this.margin.left,v=u[0]):x=this.scroller.getBoundingClientRect();var x,u=_+this.scrollLeft-x.left-this.$padding,_=u/this.characterWidth,_=this.$blockCursor?Math.floor(_):Math.round(_),v=Math.floor((v+this.scrollTop-x.top)/this.lineHeight);return this.session.screenToDocumentPosition(v,Math.max(_,0),u)},W.prototype.textToScreenCoordinates=function(u,_){var x=this.scroller.getBoundingClientRect(),_=this.session.documentToScreenPosition(u,_),u=this.$padding+(this.session.$bidiHandler.isBidiRow(_.row,u)?this.session.$bidiHandler.getPosLeft(_.column):Math.round(_.column*this.characterWidth)),_=_.row*this.lineHeight;return{pageX:x.left+u-this.scrollLeft,pageY:x.top+_-this.scrollTop}},W.prototype.visualizeFocus=function(){C.addCssClass(this.container,"ace_focus")},W.prototype.visualizeBlur=function(){C.removeCssClass(this.container,"ace_focus")},W.prototype.showComposition=function(B){(this.$composition=B).cssText||(B.cssText=this.textarea.style.cssText),B.useTextareaForIME==null&&(B.useTextareaForIME=this.$useTextareaForIME),this.$useTextareaForIME?(C.addCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText="",this.$moveTextAreaToCursor(),this.$cursorLayer.element.style.display="none"):B.markerId=this.session.addMarker(B.markerRange,"ace_composition_marker","text")},W.prototype.setCompositionText=function(B){var O=this.session.selection.cursor;this.addToken(B,"composition_placeholder",O.row,O.column),this.$moveTextAreaToCursor()},W.prototype.hideComposition=function(){var B;this.$composition&&(this.$composition.markerId&&this.session.removeMarker(this.$composition.markerId),C.removeCssClass(this.textarea,"ace_composition"),this.textarea.style.cssText=this.$composition.cssText,B=this.session.selection.cursor,this.removeExtraToken(B.row,B.column),this.$composition=null,this.$cursorLayer.element.style.display="")},W.prototype.setGhostText=function(B,x){var u=this.session.selection.cursor,x=x||{row:u.row,column:u.column},u=(this.removeGhostText(),B.split(`
`));this.addToken(u[0],"ghost_text",x.row,x.column),this.$ghostText={text:B,position:{row:x.row,column:x.column}},1<u.length&&(this.$ghostTextWidget={text:u.slice(1).join(`
`),row:x.row,column:x.column,className:"ace_ghost_text"},this.session.widgetManager.addLineWidget(this.$ghostTextWidget))},W.prototype.removeGhostText=function(){var B;this.$ghostText&&(B=this.$ghostText.position,this.removeExtraToken(B.row,B.column),this.$ghostTextWidget&&(this.session.widgetManager.removeLineWidget(this.$ghostTextWidget),this.$ghostTextWidget=null),this.$ghostText=null)},W.prototype.addToken=function(B,O,x,u){var _=this.session,v=(_.bgTokenizer.lines[x]=null,{type:O,value:B}),$=_.getTokens(x);if(u!=null&&$.length)for(var P=0,M=0;M<$.length;M++){var X=$[M];if(u<=(P+=X.value.length)){var K=X.value.length-(P-u),Q=X.value.slice(0,K),K=X.value.slice(K);$.splice(M,1,{type:X.type,value:Q},v,{type:X.type,value:K});break}}else $.push(v);this.updateLines(x,x)},W.prototype.removeExtraToken=function(B,O){this.session.bgTokenizer.lines[B]=null,this.updateLines(B,B)},W.prototype.setTheme=function(B,O){var x,u=this;function _(v){if(u.$themeId!=B)return O&&O();if(!v||!v.cssClass)throw new Error("couldn't load module "+B+" or it didn't call define");v.$id&&(u.$themeId=v.$id),C.importCssString(v.cssText,v.cssClass,u.container),u.theme&&C.removeCssClass(u.container,u.theme.cssClass);var $="padding"in v?v.padding:"padding"in(u.theme||{})?4:u.$padding;u.$padding&&$!=u.$padding&&u.setPadding($),u.$theme=v.cssClass,u.theme=v,C.addCssClass(u.container,v.cssClass),C.setCssClass(u.container,"ace_dark",v.isDark),u.$size&&(u.$size.width=0,u.$updateSizeAsync()),u._dispatchEvent("themeLoaded",{theme:v}),O&&O()}this.$themeId=B,u._dispatchEvent("themeChange",{theme:B}),B&&typeof B!="string"?_(B):(x=B||this.$options.theme.initialValue,h.loadModule(["theme",x],_))},W.prototype.getTheme=function(){return this.$themeId},W.prototype.setStyle=function(B,O){C.setCssClass(this.container,B,O!==!1)},W.prototype.unsetStyle=function(B){C.removeCssClass(this.container,B)},W.prototype.setCursorStyle=function(B){C.setStyle(this.scroller.style,"cursor",B)},W.prototype.setMouseCursor=function(B){C.setStyle(this.scroller.style,"cursor",B)},W.prototype.attachToShadowRoot=function(){C.importCssString(g,"ace_editor.css",this.container)},W.prototype.destroy=function(){this.freeze(),this.$fontMetrics.destroy(),this.$cursorLayer.destroy(),this.removeAllListeners(),this.container.textContent="",this.setOption("useResizeObserver",!1)},W.prototype.$updateCustomScrollbar=function(B){var O=this;this.$horizScroll=this.$vScroll=null,this.scrollBarV.element.remove(),this.scrollBarH.element.remove(),this.$scrollDecorator&&delete this.$scrollDecorator,B===!0?(this.scrollBarV=new t(this.container,this),this.scrollBarH=new e(this.container,this),this.scrollBarV.setHeight(this.$size.scrollerHeight),this.scrollBarH.setWidth(this.$size.scrollerWidth),this.scrollBarV.addEventListener("scroll",function(x){O.$scrollAnimation||O.session.setScrollTop(x.data-O.scrollMargin.top)}),this.scrollBarH.addEventListener("scroll",function(x){O.$scrollAnimation||O.session.setScrollLeft(x.data-O.scrollMargin.left)}),this.$scrollDecorator=new b(this.scrollBarV,this),this.$scrollDecorator.$updateDecorators()):(this.scrollBarV=new r(this.container,this),this.scrollBarH=new a(this.container,this),this.scrollBarV.addEventListener("scroll",function(x){O.$scrollAnimation||O.session.setScrollTop(x.data-O.scrollMargin.top)}),this.scrollBarH.addEventListener("scroll",function(x){O.$scrollAnimation||O.session.setScrollLeft(x.data-O.scrollMargin.left)}))},W.prototype.$addResizeObserver=function(){var B;window.ResizeObserver&&!this.$resizeObserver&&((B=this).$resizeTimer=d.delayedCall(function(){B.destroyed||B.onResize()},50),this.$resizeObserver=new window.ResizeObserver(function(u){var x=u[0].contentRect.width,u=u[0].contentRect.height;1<Math.abs(B.$size.width-x)||1<Math.abs(B.$size.height-u)?B.$resizeTimer.delay():B.$resizeTimer.cancel()}),this.$resizeObserver.observe(this.container))},W);function W(u,O){var x=this,u=(this.container=u||C.createElement("div"),C.addCssClass(this.container,"ace_editor"),C.HI_DPI&&C.addCssClass(this.container,"ace_hidpi"),this.setTheme(O),h.get("useStrictCSP")==null&&h.set("useStrictCSP",!1),this.$gutter=C.createElement("div"),this.$gutter.className="ace_gutter",this.container.appendChild(this.$gutter),this.$gutter.setAttribute("aria-hidden",!0),this.scroller=C.createElement("div"),this.scroller.className="ace_scroller",this.container.appendChild(this.scroller),this.content=C.createElement("div"),this.content.className="ace_content",this.scroller.appendChild(this.content),this.$gutterLayer=new l(this.$gutter),this.$gutterLayer.on("changeGutterWidth",this.onGutterResize.bind(this)),this.$markerBack=new n(this.content),this.$textLayer=new o(this.content));this.canvas=u.element,this.$markerFront=new n(this.content),this.$cursorLayer=new i(this.content),this.$horizScroll=!1,this.$vScroll=!1,this.scrollBar=this.scrollBarV=new r(this.container,this),this.scrollBarH=new a(this.container,this),this.scrollBarV.on("scroll",function(_){x.$scrollAnimation||x.session.setScrollTop(_.data-x.scrollMargin.top)}),this.scrollBarH.on("scroll",function(_){x.$scrollAnimation||x.session.setScrollLeft(_.data-x.scrollMargin.left)}),this.scrollTop=0,this.scrollLeft=0,this.cursorPos={row:0,column:0},this.$fontMetrics=new c(this.container),this.$textLayer.$setFontMetrics(this.$fontMetrics),this.$textLayer.on("changeCharacterSize",function(_){x.updateCharacterSize(),x.onResize(!0,x.gutterWidth,x.$size.width,x.$size.height),x._signal("changeCharacterSize",_)}),this.$size={width:0,height:0,scrollerHeight:0,scrollerWidth:0,$dirty:!0},this.layerConfig={width:1,padding:0,firstRow:0,firstRowScreen:0,lastRow:0,lineHeight:0,characterWidth:0,minHeight:1,maxHeight:1,offset:0,height:1,gutterOffset:1},this.scrollMargin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.margin={left:0,right:0,top:0,bottom:0,v:0,h:0},this.$keepTextAreaAtCursor=!w.isIOS,this.$loop=new s(this.$renderChanges.bind(this),this.container.ownerDocument.defaultView),this.$loop.schedule(this.CHANGE_FULL),this.updateCharacterSize(),this.setPadding(4),this.$addResizeObserver(),h.resetOptions(this),h._signal("renderer",this)}E.prototype.CHANGE_CURSOR=1,E.prototype.CHANGE_MARKER=2,E.prototype.CHANGE_GUTTER=4,E.prototype.CHANGE_SCROLL=8,E.prototype.CHANGE_LINES=16,E.prototype.CHANGE_TEXT=32,E.prototype.CHANGE_SIZE=64,E.prototype.CHANGE_MARKER_BACK=128,E.prototype.CHANGE_MARKER_FRONT=256,E.prototype.CHANGE_FULL=512,E.prototype.CHANGE_H_SCROLL=1024,E.prototype.$changes=0,E.prototype.$padding=null,E.prototype.$frozen=!1,E.prototype.STEPS=8,y.implement(E.prototype,p),h.defineOptions(E.prototype,"renderer",{useResizeObserver:{set:function(B){!B&&this.$resizeObserver?(this.$resizeObserver.disconnect(),this.$resizeTimer.cancel(),this.$resizeTimer=this.$resizeObserver=null):B&&!this.$resizeObserver&&this.$addResizeObserver()}},animatedScroll:{initialValue:!1},showInvisibles:{set:function(B){this.$textLayer.setShowInvisibles(B)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!1},showPrintMargin:{set:function(){this.$updatePrintMargin()},initialValue:!0},printMarginColumn:{set:function(){this.$updatePrintMargin()},initialValue:80},printMargin:{set:function(B){typeof B=="number"&&(this.$printMarginColumn=B),this.$showPrintMargin=!!B,this.$updatePrintMargin()},get:function(){return this.$showPrintMargin&&this.$printMarginColumn}},showGutter:{set:function(B){this.$gutter.style.display=B?"block":"none",this.$loop.schedule(this.CHANGE_FULL),this.onGutterResize()},initialValue:!0},useSvgGutterIcons:{set:function(B){this.$gutterLayer.$useSvgGutterIcons=B},initialValue:!1},showFoldedAnnotations:{set:function(B){this.$gutterLayer.$showFoldedAnnotations=B},initialValue:!1},fadeFoldWidgets:{set:function(B){C.setCssClass(this.$gutter,"ace_fade-fold-widgets",B)},initialValue:!1},showFoldWidgets:{set:function(B){this.$gutterLayer.setShowFoldWidgets(B),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},displayIndentGuides:{set:function(B){this.$textLayer.setDisplayIndentGuides(B)&&this.$loop.schedule(this.CHANGE_TEXT)},initialValue:!0},highlightIndentGuides:{set:function(B){this.$textLayer.setHighlightIndentGuides(B)==1?this.$textLayer.$highlightIndentGuide():this.$textLayer.$clearActiveIndentGuide(this.$textLayer.$lines.cells)},initialValue:!0},highlightGutterLine:{set:function(B){this.$gutterLayer.setHighlightGutterLine(B),this.$loop.schedule(this.CHANGE_GUTTER)},initialValue:!0},hScrollBarAlwaysVisible:{set:function(B){this.$hScrollBarAlwaysVisible&&this.$horizScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},vScrollBarAlwaysVisible:{set:function(B){this.$vScrollBarAlwaysVisible&&this.$vScroll||this.$loop.schedule(this.CHANGE_SCROLL)},initialValue:!1},fontSize:{set:function(B){typeof B=="number"&&(B+="px"),this.container.style.fontSize=B,this.updateFontSize()},initialValue:12},fontFamily:{set:function(B){this.container.style.fontFamily=B,this.updateFontSize()}},maxLines:{set:function(B){this.updateFull()}},minLines:{set:function(B){this.$minLines<562949953421311||(this.$minLines=0),this.updateFull()}},maxPixelHeight:{set:function(B){this.updateFull()},initialValue:0},scrollPastEnd:{set:function(B){this.$scrollPastEnd!=(B=+B||0)&&(this.$scrollPastEnd=B,this.$loop.schedule(this.CHANGE_SCROLL))},initialValue:0,handlesSet:!0},fixedWidthGutter:{set:function(B){this.$gutterLayer.$fixedWidth=!!B,this.$loop.schedule(this.CHANGE_GUTTER)}},customScrollbar:{set:function(B){this.$updateCustomScrollbar(B)},initialValue:!1},theme:{set:function(B){this.setTheme(B)},get:function(){return this.$themeId||this.theme},initialValue:"./theme/textmate",handlesSet:!0},hasCssTransforms:{},useTextareaForIME:{initialValue:!w.isMobile&&!w.isIE}}),f.VirtualRenderer=E}),ace.define("ace/worker/worker_client",["require","exports","module","ace/lib/oop","ace/lib/net","ace/lib/event_emitter","ace/config"],function(A,f,R){var y=A("../lib/oop"),C=A("../lib/net"),d=A("../lib/event_emitter").EventEmitter,h=A("../config");function l(o){var i;return typeof Worker>"u"?{postMessage:function(){},terminate:function(){}}:h.get("loadWorkerFromBlob")?(i=function(a){a="importScripts('"+C.qualifyURL(a)+"');";try{return new Blob([a],{type:"application/javascript"})}catch{var r=new(window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder);return r.append(a),r.getBlob("application/javascript")}}(o),i=(window.URL||window.webkitURL).createObjectURL(i),new Worker(i)):new Worker(o)}function n(o){o.postMessage||(o=this.$createWorkerFromOldConfig.apply(this,arguments)),this.$worker=o,this.$sendDeltaQueue=this.$sendDeltaQueue.bind(this),this.changeListener=this.changeListener.bind(this),this.onMessage=this.onMessage.bind(this),this.callbackId=1,this.callbacks={},this.$worker.onmessage=this.onMessage}(function(){y.implement(this,d),this.$createWorkerFromOldConfig=function(o,i,a,r,e){var t,s;return A.nameToUrl&&!A.toUrl&&(A.toUrl=A.nameToUrl),h.get("packaged")||!A.toUrl?r=r||h.moduleUrl(i,"worker"):(t=this.$normalizePath,r=r||t(A.toUrl("ace/worker/worker.js",null,"_")),s={},o.forEach(function(c){s[c]=t(A.toUrl(c,null,"_").replace(/(\.js)?(\?.*)?$/,""))})),this.$worker=l(r),e&&this.send("importScripts",e),this.$worker.postMessage({init:!0,tlns:s,module:i,classname:a}),this.$worker},this.onMessage=function(o){var i=o.data;switch(i.type){case"event":this._signal(i.name,{data:i.data});break;case"call":var a=this.callbacks[i.id];a&&(a(i.data),delete this.callbacks[i.id]);break;case"error":this.reportError(i.data);break;case"log":window.console&&console.log&&console.log.apply(console,i.data)}},this.reportError=function(o){window.console&&console.error&&console.error(o)},this.$normalizePath=function(o){return C.qualifyURL(o)},this.terminate=function(){this._signal("terminate",{}),this.deltaQueue=null,this.$worker.terminate(),this.$worker.onerror=function(o){o.preventDefault()},this.$worker=null,this.$doc&&this.$doc.off("change",this.changeListener),this.$doc=null},this.send=function(o,i){this.$worker.postMessage({command:o,args:i})},this.call=function(o,i,a){var r;a&&(r=this.callbackId++,this.callbacks[r]=a,i.push(r)),this.send(o,i)},this.emit=function(o,i){try{i.data&&i.data.err&&(i.data.err={message:i.data.err.message,stack:i.data.err.stack,code:i.data.err.code}),this.$worker&&this.$worker.postMessage({event:o,data:{data:i.data}})}catch(a){console.error(a.stack)}},this.attachToDocument=function(o){this.$doc&&this.terminate(),this.$doc=o,this.call("setValue",[o.getValue()]),o.on("change",this.changeListener,!0)},this.changeListener=function(o){this.deltaQueue||(this.deltaQueue=[],setTimeout(this.$sendDeltaQueue,0)),o.action=="insert"?this.deltaQueue.push(o.start,o.lines):this.deltaQueue.push(o.start,o.end)},this.$sendDeltaQueue=function(){var o=this.deltaQueue;o&&(this.deltaQueue=null,50<o.length&&o.length>this.$doc.getLength()>>1?this.call("setValue",[this.$doc.getValue()]):this.emit("change",{data:o}))}}).call(n.prototype),f.UIWorkerClient=function(o,i,a){var r=null,e=!1,t=Object.create(d),s=[],c=new n({messageBuffer:s,terminate:function(){},postMessage:function(g){s.push(g),r&&(e?setTimeout(p):p())}}),p=(c.setEmitSync=function(g){e=g},function(){var g=s.shift();g.command?r[g.command].apply(r,g.args):g.event&&t._signal(g.event,g.data)});return t.postMessage=function(g){c.onMessage({data:g})},t.callback=function(g,b){this.postMessage({type:"call",id:b,data:g})},t.emit=function(g,b){this.postMessage({type:"event",name:g,data:b})},h.loadModule(["worker",i],function(g){for(r=new g[a](t);s.length;)p()}),c},f.WorkerClient=n,f.createWorker=l}),ace.define("ace/placeholder",["require","exports","module","ace/range","ace/lib/event_emitter","ace/lib/oop"],function(d,f,R){var y=d("./range").Range,C=d("./lib/event_emitter").EventEmitter,d=d("./lib/oop"),h=(l.prototype.setup=function(){var n=this,o=this.doc,i=this.session,a=(this.selectionBefore=i.selection.toJSON(),i.selection.inMultiSelectMode&&i.selection.toSingleRange(),this.pos=o.createAnchor(this.$pos.row,this.$pos.column),this.pos);a.$insertRight=!0,a.detach(),a.markerId=i.addMarker(new y(a.row,a.column,a.row,a.column+this.length),this.mainClass,null,!1),this.others=[],this.$others.forEach(function(r){r=o.createAnchor(r.row,r.column),r.$insertRight=!0,r.detach(),n.others.push(r)}),i.setUndoSelect(!1)},l.prototype.showOtherMarkers=function(){var n,o;this.othersActive||(n=this.session,(o=this).othersActive=!0,this.others.forEach(function(i){i.markerId=n.addMarker(new y(i.row,i.column,i.row,i.column+o.length),o.othersClass,null,!1)}))},l.prototype.hideOtherMarkers=function(){if(this.othersActive){this.othersActive=!1;for(var n=0;n<this.others.length;n++)this.session.removeMarker(this.others[n].markerId)}},l.prototype.onUpdate=function(n){if(this.$updating)return this.updateAnchors(n);var o=n;if(o.start.row===o.end.row&&o.start.row===this.pos.row){this.$updating=!0;var i=n.action==="insert"?o.end.column-o.start.column:o.start.column-o.end.column,a=o.start.column>=this.pos.column&&o.start.column<=this.pos.column+this.length+1,r=o.start.column-this.pos.column;if(this.updateAnchors(n),a&&(this.length+=i),a&&!this.session.$fromUndo){if(n.action==="insert")for(var e=this.others.length-1;0<=e;e--){var t={row:(s=this.others[e]).row,column:s.column+r};this.doc.insertMergedLines(t,n.lines)}else if(n.action==="remove")for(e=this.others.length-1;0<=e;e--){var s,t={row:(s=this.others[e]).row,column:s.column+r};this.doc.remove(new y(t.row,t.column,t.row,t.column-i))}}this.$updating=!1,this.updateMarkers()}},l.prototype.updateAnchors=function(n){this.pos.onChange(n);for(var o=this.others.length;o--;)this.others[o].onChange(n);this.updateMarkers()},l.prototype.updateMarkers=function(){if(!this.$updating){var n=this,o=this.session,i=function(r,e){o.removeMarker(r.markerId),r.markerId=o.addMarker(new y(r.row,r.column,r.row,r.column+n.length),e,null,!1)};i(this.pos,this.mainClass);for(var a=this.others.length;a--;)i(this.others[a],this.othersClass)}},l.prototype.onCursorChange=function(n){var o;!this.$updating&&this.session&&((o=this.session.selection.getCursor()).row===this.pos.row&&o.column>=this.pos.column&&o.column<=this.pos.column+this.length?(this.showOtherMarkers(),this._emit("cursorEnter",n)):(this.hideOtherMarkers(),this._emit("cursorLeave",n)))},l.prototype.detach=function(){this.session.removeMarker(this.pos&&this.pos.markerId),this.hideOtherMarkers(),this.doc.off("change",this.$onUpdate),this.session.selection.off("changeCursor",this.$onCursorChange),this.session.setUndoSelect(!0),this.session=null},l.prototype.cancel=function(){if(this.$undoStackDepth!==-1){for(var n=this.session.getUndoManager(),o=(n.$undoStack||n.$undostack).length-this.$undoStackDepth,i=0;i<o;i++)n.undo(this.session,!0);this.selectionBefore&&this.session.selection.fromJSON(this.selectionBefore)}},l);function l(n,s,i,a,r,e){var t=this,s=(this.length=s,this.session=n,this.doc=n.getDocument(),this.mainClass=r,this.othersClass=e,this.$onUpdate=this.onUpdate.bind(this),this.doc.on("change",this.$onUpdate,!0),this.$others=a,this.$onCursorChange=function(){setTimeout(function(){t.onCursorChange()})},this.$pos=i,n.getUndoManager().$undoStack||n.getUndoManager().$undostack||{length:-1});this.$undoStackDepth=s.length,this.setup(),n.selection.on("changeCursor",this.$onCursorChange)}d.implement(h.prototype,C),f.PlaceHolder=h}),ace.define("ace/mouse/multi_select_handler",["require","exports","module","ace/lib/event","ace/lib/useragent"],function(A,f,R){var y=A("../lib/event"),C=A("../lib/useragent");function d(h,l){return h.row==l.row&&h.column==l.column}f.onMouseDown=function(h){var l=h.domEvent,n=l.altKey,o=l.shiftKey,i=l.ctrlKey,a=h.getAccelKey(),r=h.getButton();if(i&&C.isMac&&(r=l.button),h.editor.inMultiSelectMode&&r==2)h.editor.textInput.onContextMenu(h.domEvent);else if(i||n||a){if(r===0){var e,t,s,c,p,g,b,w,E=h.editor,W=E.selection,B=E.inMultiSelectMode,O=h.getDocumentPosition(),x=W.getCursor(),x=h.inSelection()||W.isEmpty()&&d(O,x),u=h.x,_=h.y,v=E.session,$=E.renderer.pixelToScreenCoordinates(u,_),P=$;if(E.$mouseHandler.$enableJumpToDef)i&&n||a&&n?e=o?"block":"add":n&&E.$blockSelectEnabled&&(e="block");else if(a&&!n){if(e="add",!B&&o)return}else n&&E.$blockSelectEnabled&&(e="block");if(e&&C.isMac&&l.ctrlKey&&E.$mouseHandler.cancelContextMenu(),e=="add")!B&&x||(B||(t=W.toOrientedRange(),E.addSelectionMarker(t)),s=W.rangeList.rangeAtPoint(O),E.inVirtualSelectionMode=!0,o&&(s=null,t=W.ranges[0]||t,E.removeSelectionMarker(t)),E.once("mouseup",function(){var M=W.toOrientedRange();s&&M.isEmpty()&&d(s.cursor,M.cursor)?W.substractPoint(M.cursor):(o?W.substractPoint(t.cursor):t&&(E.removeSelectionMarker(t),W.addRange(t)),W.addRange(M)),E.inVirtualSelectionMode=!1}));else if(e=="block")return h.stop(),E.inVirtualSelectionMode=!0,p=[],g=function(){var M=E.renderer.pixelToScreenCoordinates(u,_),X=v.screenToDocumentPosition(M.row,M.column,M.offsetX);d(P,M)&&d(X,W.lead)||(P=M,E.selection.moveToPosition(X),E.renderer.scrollCursorIntoView(),E.removeSelectionMarkers(p),p=W.rectangularRangeBlock(P,$),E.$mouseHandler.$clickSelection&&p.length==1&&p[0].isEmpty()&&(p[0]=E.$mouseHandler.$clickSelection.clone()),p.forEach(E.addSelectionMarker,E),E.updateSelectionMarkers())},B&&!a?W.toSingleRange():!B&&a&&(c=W.toOrientedRange(),E.addSelectionMarker(c)),o?$=v.documentToScreenPosition(W.lead):W.moveToPosition(O),P={row:-1,column:-1},b=g,y.capture(E.container,function(M){u=M.clientX,_=M.clientY},function(M){g(),clearInterval(w),E.removeSelectionMarkers(p),p.length||(p=[W.toOrientedRange()]),c&&(E.removeSelectionMarker(c),W.toSingleRange(c));for(var X=0;X<p.length;X++)W.addRange(p[X]);E.inVirtualSelectionMode=!1,E.$mouseHandler.$clickSelection=null}),w=setInterval(function(){b()},20),h.preventDefault()}}else r===0&&h.editor.inMultiSelectMode&&h.editor.exitMultiSelectMode()}}),ace.define("ace/commands/multi_select_commands",["require","exports","module","ace/keyboard/hash_handler"],function(A,f,R){f.defaultCommands=[{name:"addCursorAbove",description:"Add cursor above",exec:function(y){y.selectMoreLines(-1)},bindKey:{win:"Ctrl-Alt-Up",mac:"Ctrl-Alt-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelow",description:"Add cursor below",exec:function(y){y.selectMoreLines(1)},bindKey:{win:"Ctrl-Alt-Down",mac:"Ctrl-Alt-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorAboveSkipCurrent",description:"Add cursor above (skip current)",exec:function(y){y.selectMoreLines(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Up",mac:"Ctrl-Alt-Shift-Up"},scrollIntoView:"cursor",readOnly:!0},{name:"addCursorBelowSkipCurrent",description:"Add cursor below (skip current)",exec:function(y){y.selectMoreLines(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Down",mac:"Ctrl-Alt-Shift-Down"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreBefore",description:"Select more before",exec:function(y){y.selectMore(-1)},bindKey:{win:"Ctrl-Alt-Left",mac:"Ctrl-Alt-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectMoreAfter",description:"Select more after",exec:function(y){y.selectMore(1)},bindKey:{win:"Ctrl-Alt-Right",mac:"Ctrl-Alt-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextBefore",description:"Select next before",exec:function(y){y.selectMore(-1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Left",mac:"Ctrl-Alt-Shift-Left"},scrollIntoView:"cursor",readOnly:!0},{name:"selectNextAfter",description:"Select next after",exec:function(y){y.selectMore(1,!0)},bindKey:{win:"Ctrl-Alt-Shift-Right",mac:"Ctrl-Alt-Shift-Right"},scrollIntoView:"cursor",readOnly:!0},{name:"toggleSplitSelectionIntoLines",description:"Split selection into lines",exec:function(y){1<y.multiSelect.rangeCount?y.multiSelect.joinSelections():y.multiSelect.splitIntoLines()},bindKey:{win:"Ctrl-Alt-L",mac:"Ctrl-Alt-L"},readOnly:!0},{name:"splitSelectionIntoLines",description:"Split into lines",exec:function(y){y.multiSelect.splitIntoLines()},readOnly:!0},{name:"alignCursors",description:"Align cursors",exec:function(y){y.alignCursors()},bindKey:{win:"Ctrl-Alt-A",mac:"Ctrl-Alt-A"},scrollIntoView:"cursor"},{name:"findAll",description:"Find all",exec:function(y){y.findAll()},bindKey:{win:"Ctrl-Alt-K",mac:"Ctrl-Alt-G"},scrollIntoView:"cursor",readOnly:!0}],f.multiSelectCommands=[{name:"singleSelection",description:"Single selection",bindKey:"esc",exec:function(y){y.exitMultiSelectMode()},scrollIntoView:"cursor",readOnly:!0,isAvailable:function(y){return y&&y.inMultiSelectMode}}],A=A("../keyboard/hash_handler").HashHandler,f.keyboardHandler=new A(f.multiSelectCommands)}),ace.define("ace/multi_select",["require","exports","module","ace/range_list","ace/range","ace/selection","ace/mouse/multi_select_handler","ace/lib/event","ace/lib/lang","ace/commands/multi_select_commands","ace/search","ace/edit_session","ace/editor","ace/config"],function(A,f,R){var y=A("./range_list").RangeList,C=A("./range").Range,d=A("./selection").Selection,h=A("./mouse/multi_select_handler").onMouseDown,l=A("./lib/event"),n=A("./lib/lang"),o=A("./commands/multi_select_commands");f.commands=o.defaultCommands.concat(o.multiSelectCommands);var i=new(A("./search")).Search,a=A("./edit_session").EditSession,a=((function(){this.getSelectionMarkers=function(){return this.$selectionMarkers}}).call(a.prototype),(function(){this.ranges=null,this.rangeList=null,this.addRange=function(e,t){if(e){if(!this.inMultiSelectMode&&this.rangeCount===0){var s=this.toOrientedRange();if(this.rangeList.add(s),this.rangeList.add(e),this.rangeList.ranges.length!=2)return this.rangeList.removeAll(),t||this.fromOrientedRange(e);this.rangeList.removeAll(),this.rangeList.add(s),this.$onAddRange(s)}return e.cursor||(e.cursor=e.end),s=this.rangeList.add(e),this.$onAddRange(e),s.length&&this.$onRemoveRange(s),1<this.rangeCount&&!this.inMultiSelectMode&&(this._signal("multiSelect"),this.inMultiSelectMode=!0,this.session.$undoSelect=!1,this.rangeList.attach(this.session)),t||this.fromOrientedRange(e)}},this.toSingleRange=function(e){e=e||this.ranges[0];var t=this.rangeList.removeAll();t.length&&this.$onRemoveRange(t),e&&this.fromOrientedRange(e)},this.substractPoint=function(e){if(e=this.rangeList.substractPoint(e),e)return this.$onRemoveRange(e),e[0]},this.mergeOverlappingRanges=function(){var e=this.rangeList.merge();e.length&&this.$onRemoveRange(e)},this.$onAddRange=function(e){this.rangeCount=this.rangeList.ranges.length,this.ranges.unshift(e),this._signal("addRange",{range:e})},this.$onRemoveRange=function(e){var t;this.rangeCount=this.rangeList.ranges.length,this.rangeCount==1&&this.inMultiSelectMode&&(t=this.rangeList.ranges.pop(),e.push(t),this.rangeCount=0);for(var s=e.length;s--;){var c=this.ranges.indexOf(e[s]);this.ranges.splice(c,1)}this._signal("removeRange",{ranges:e}),this.rangeCount===0&&this.inMultiSelectMode&&(this.inMultiSelectMode=!1,this._signal("singleSelect"),this.session.$undoSelect=!0,this.rangeList.detach(this.session)),(t=t||this.ranges[0])&&!t.isEqual(this.getRange())&&this.fromOrientedRange(t)},this.$initRangeList=function(){this.rangeList||(this.rangeList=new y,this.ranges=[],this.rangeCount=0)},this.getAllRanges=function(){return this.rangeCount?this.rangeList.ranges.concat():[this.getRange()]},this.splitIntoLines=function(){for(var e=this.ranges.length?this.ranges:[this.getRange()],t=[],s=0;s<e.length;s++){var c=e[s],p=c.start.row,g=c.end.row;if(p===g)t.push(c.clone());else{for(t.push(new C(p,c.start.column,p,this.session.getLine(p).length));++p<g;)t.push(this.getLineRange(p,!0));t.push(new C(g,0,g,c.end.column))}s!=0||this.isBackwards()||(t=t.reverse())}for(this.toSingleRange(),s=t.length;s--;)this.addRange(t[s])},this.joinSelections=function(){var t=this.rangeList.ranges,e=t[t.length-1],t=C.fromPoints(t[0].start,e.end);this.toSingleRange(),this.setSelectionRange(t,e.cursor==e.start)},this.toggleBlockSelection=function(){var e,t;1<this.rangeCount?(t=(e=this.rangeList.ranges)[e.length-1],e=C.fromPoints(e[0].start,t.end),this.toSingleRange(),this.setSelectionRange(e,t.cursor==t.start)):(e=this.session.documentToScreenPosition(this.cursor),t=this.session.documentToScreenPosition(this.anchor),this.rectangularRangeBlock(e,t).forEach(this.addRange,this))},this.rectangularRangeBlock=function(e,t,s){var c,p,g,b,w,E,W,B=[],O=e.column<t.column,x=(b=(O?(c=e.column,p=t.column,g=e.offsetX,t):(c=t.column,p=e.column,g=t.offsetX,e)).offsetX,e.row<t.row);E=(x?(w=e.row,t):(w=t.row,e)).row,c<0&&(c=0),(w=w<0?0:w)==E&&(s=!0);for(var u,_,v=w;v<=E;v++){var $=C.fromPoints(this.session.screenToDocumentPosition(v,c,g),this.session.screenToDocumentPosition(v,p,b));if($.isEmpty()){if(W&&(u=$.end,_=W,u.row==_.row)&&u.column==_.column)break;W=$.end}$.cursor=O?$.start:$.end,B.push($)}if(x&&B.reverse(),!s){for(var P=B.length-1;B[P].isEmpty()&&0<P;)P--;if(0<P)for(var M=0;B[M].isEmpty();)M++;for(var X=P;M<=X;X--)B[X].isEmpty()&&B.splice(X,1)}return B}}).call(d.prototype),A("./editor").Editor);function r(e){var t,s;function c(p){s&&(t.renderer.setMouseCursor(""),s=!1)}e.$multiselectOnSessionChange||(e.$onAddRange=e.$onAddRange.bind(e),e.$onRemoveRange=e.$onRemoveRange.bind(e),e.$onMultiSelect=e.$onMultiSelect.bind(e),e.$onSingleSelect=e.$onSingleSelect.bind(e),e.$multiselectOnSessionChange=f.onSessionChange.bind(e),e.$checkMultiselectChange=e.$checkMultiselectChange.bind(e),e.$multiselectOnSessionChange(e),e.on("changeSession",e.$multiselectOnSessionChange),e.on("mousedown",h),e.commands.addCommands(o.defaultCommands),(t=e).textInput&&(e=t.textInput.getElement(),s=!1,l.addListener(e,"keydown",function(p){p=p.keyCode==18&&!(p.ctrlKey||p.shiftKey||p.metaKey),t.$blockSelectEnabled&&p?s||(t.renderer.setMouseCursor("crosshair"),s=!0):s&&c()},t),l.addListener(e,"keyup",c,t),l.addListener(e,"blur",c,t)))}(function(){this.updateSelectionMarkers=function(){this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.addSelectionMarker=function(e){e.cursor||(e.cursor=e.end);var t=this.getSelectionStyle();return e.marker=this.session.addMarker(e,"ace_selection",t),this.session.$selectionMarkers.push(e),this.session.selectionMarkerCount=this.session.$selectionMarkers.length,e},this.removeSelectionMarker=function(e){e.marker&&(this.session.removeMarker(e.marker),(e=this.session.$selectionMarkers.indexOf(e))!=-1&&this.session.$selectionMarkers.splice(e,1),this.session.selectionMarkerCount=this.session.$selectionMarkers.length)},this.removeSelectionMarkers=function(e){for(var t=this.session.$selectionMarkers,s=e.length;s--;){var c=e[s];c.marker&&(this.session.removeMarker(c.marker),(c=t.indexOf(c))!=-1)&&t.splice(c,1)}this.session.selectionMarkerCount=t.length},this.$onAddRange=function(e){this.addSelectionMarker(e.range),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onRemoveRange=function(e){this.removeSelectionMarkers(e.ranges),this.renderer.updateCursor(),this.renderer.updateBackMarkers()},this.$onMultiSelect=function(e){this.inMultiSelectMode||(this.inMultiSelectMode=!0,this.setStyle("ace_multiselect"),this.keyBinding.addKeyboardHandler(o.keyboardHandler),this.commands.setDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers())},this.$onSingleSelect=function(e){this.session.multiSelect.inVirtualMode||(this.inMultiSelectMode=!1,this.unsetStyle("ace_multiselect"),this.keyBinding.removeKeyboardHandler(o.keyboardHandler),this.commands.removeDefaultHandler("exec",this.$onMultiSelectExec),this.renderer.updateCursor(),this.renderer.updateBackMarkers(),this._emit("changeSelection"))},this.$onMultiSelectExec=function(e){var t,s=e.command,c=e.editor;if(c.multiSelect)return s.multiSelectAction?t=s.multiSelectAction=="forEach"?c.forEachSelection(s,e.args):s.multiSelectAction=="forEachLine"?c.forEachSelection(s,e.args,!0):s.multiSelectAction=="single"?(c.exitMultiSelectMode(),s.exec(c,e.args||{})):s.multiSelectAction(c,e.args||{}):(t=s.exec(c,e.args||{}),c.multiSelect.addRange(c.multiSelect.toOrientedRange()),c.multiSelect.mergeOverlappingRanges()),t},this.forEachSelection=function(e,t,s){if(!this.inVirtualSelectionMode){var c,E=s&&s.keepOrder,p=s==1||s&&s.$byLines,g=this.session,s=this.selection,b=s.rangeList,w=(E?s:b).ranges;if(!w.length)return e.exec?e.exec(this,t||{}):e(this,t||{});var E=s._eventRegistry,W=(s._eventRegistry={},new d(g));this.inVirtualSelectionMode=!0;for(var B=w.length;B--;){if(p)for(;0<B&&w[B].start.row==w[B-1].end.row;)B--;W.fromOrientedRange(w[B]),W.index=B,this.selection=g.selection=W;var O=e.exec?e.exec(this,t||{}):e(this,t||{});c||O===void 0||(c=O),W.toOrientedRange(w[B])}return W.detach(),this.selection=g.selection=s,this.inVirtualSelectionMode=!1,s._eventRegistry=E,s.mergeOverlappingRanges(),s.ranges[0]&&s.fromOrientedRange(s.ranges[0]),b=this.renderer.$scrollAnimation,this.onCursorChange(),this.onSelectionChange(),b&&b.from==b.to&&this.renderer.animateScrolling(b.from),c}},this.exitMultiSelectMode=function(){this.inMultiSelectMode&&!this.inVirtualSelectionMode&&this.multiSelect.toSingleRange()},this.getSelectedText=function(){var e="";if(this.inMultiSelectMode&&!this.inVirtualSelectionMode){for(var t=this.multiSelect.rangeList.ranges,s=[],c=0;c<t.length;c++)s.push(this.session.getTextRange(t[c]));var p=this.session.getDocument().getNewLineCharacter();(e=s.join(p)).length==(s.length-1)*p.length&&(e="")}else this.selection.isEmpty()||(e=this.session.getTextRange(this.getSelectionRange()));return e},this.$checkMultiselectChange=function(e,t){var s;this.inMultiSelectMode&&!this.inVirtualSelectionMode&&(s=this.multiSelect.ranges[0],this.multiSelect.isEmpty()&&t==this.multiSelect.anchor||((s=t==this.multiSelect.anchor?s.cursor==s.start?s.end:s.start:s.cursor).row!=t.row||this.session.$clipPositionToDocument(s.row,s.column).column!=t.column?this.multiSelect.toSingleRange(this.multiSelect.toOrientedRange()):this.multiSelect.mergeOverlappingRanges()))},this.findAll=function(e,t,s){(t=t||{}).needle=e||t.needle,t.needle==null&&(c=this.selection.isEmpty()?this.selection.getWordRange():this.selection.getRange(),t.needle=this.session.getTextRange(c)),this.$search.set(t);var c,p=this.$search.findAll(this.session);if(!p.length)return 0;var g=this.multiSelect;s||g.toSingleRange(p[0]);for(var b=p.length;b--;)g.addRange(p[b],!0);return c&&g.rangeList.rangeAtPoint(c.start)&&g.addRange(c,!0),p.length},this.selectMoreLines=function(e,t){var s,c,p,g=this.selection.toOrientedRange(),b=g.cursor==g.end,w=this.session.documentToScreenPosition(g.cursor),E=(this.selection.$desiredColumn&&(w.column=this.selection.$desiredColumn),this.session.screenToDocumentPosition(w.row+e,w.column));e=g.isEmpty()?E:(s=this.session.documentToScreenPosition(b?g.end:g.start),this.session.screenToDocumentPosition(s.row+e,s.column)),b?(c=C.fromPoints(E,e)).cursor=c.start:(c=C.fromPoints(e,E)).cursor=c.end,c.desiredColumn=w.column,this.selection.inMultiSelectMode?t&&(p=g.cursor):this.selection.addRange(g),this.selection.addRange(c),p&&this.selection.substractPoint(p)},this.transposeSelections=function(e){for(var t=this.session,s=t.multiSelect,c=s.ranges,p=c.length;p--;)(b=c[p]).isEmpty()&&(w=t.getWordRange(b.start.row,b.start.column),b.start.row=w.start.row,b.start.column=w.start.column,b.end.row=w.end.row,b.end.column=w.end.column);s.mergeOverlappingRanges();for(var g=[],p=c.length;p--;){var b=c[p];g.unshift(t.getTextRange(b))}for(e<0?g.unshift(g.pop()):g.push(g.shift()),p=c.length;p--;){var w=(b=c[p]).clone();t.replace(b,g[p]),b.start.row=w.start.row,b.start.column=w.start.column}s.fromOrientedRange(s.ranges[0])},this.selectMore=function(e,t,s){var c,p=this.session,g=p.multiSelect.toOrientedRange();g.isEmpty()&&((g=p.getWordRange(g.start.row,g.start.column)).cursor=e==-1?g.start:g.end,this.multiSelect.addRange(g),s)||(s=p.getTextRange(g),p=p,s=s,c=e,i.$options.wrap=!0,i.$options.needle=s,i.$options.backwards=c==-1,(s=i.find(p))&&(s.cursor=e==-1?s.start:s.end,this.session.unfold(s),this.multiSelect.addRange(s),this.renderer.scrollCursorIntoView(null,.5)),t&&this.multiSelect.substractPoint(g.cursor))},this.alignCursors=function(){var e=this.session,t=e.multiSelect,s=t.ranges,c=-1,p=s.filter(function(u){if(u.cursor.row==c)return!0;c=u.cursor.row});if(s.length&&p.length!=s.length-1){p.forEach(function(u){t.substractPoint(u.cursor)});var g=0,b=1/0,w=s.map(function(_){var _=_.cursor,v=e.getLine(_.row).substr(_.column).search(/\S/g);return _.column>g&&(g=_.column),(v=v==-1?0:v)<b&&(b=v),v});s.forEach(function(u,P){var v=u.cursor,$=g-v.column,P=w[P]-b;P<$?e.insert(v,n.stringRepeat(" ",$-P)):e.remove(new C(v.row,v.column,v.row,v.column-$+P)),u.start.column=u.end.column=g,u.start.row=u.end.row=v.row,u.cursor=u.end}),t.fromOrientedRange(s[0]),this.renderer.updateCursor(),this.renderer.updateBackMarkers()}else{var p=this.selection.getRange(),E=p.start.row,W=p.end.row,s=E==W;if(s){for(var B,O=this.session.getLength();B=this.session.getLine(W),/[=:]/.test(B)&&++W<O;);for(;B=this.session.getLine(E),/[=:]/.test(B)&&0<--E;);E<0&&(E=0),O<=W&&(W=O-1)}var x=this.session.removeFullLines(E,W),x=this.$reAlignText(x,s);this.session.insert({row:E,column:0},x.join(`
`)+`
`),s||(p.start.column=0,p.end.column=x[x.length-1].length),this.selection.setRange(p)}},this.$reAlignText=function(e,t){var s,c,p,g=!0,b=!0;return e.map(function(W){var B=W.match(/(\s*)(.*?)(\s*)([=:].*)/);return B?(s==null?(s=B[1].length,c=B[2].length,p=B[3].length):(s+c+p!=B[1].length+B[2].length+B[3].length&&(b=!1),s!=B[1].length&&(g=!1),s>B[1].length&&(s=B[1].length),c<B[2].length&&(c=B[2].length),p>B[3].length&&(p=B[3].length)),B):[W]}).map(t?E:g?b?function(W){return W[2]?w(s+c-W[2].length)+W[2]+w(p)+W[4].replace(/^([=:])\s+/,"$1 "):W[0]}:E:function(W){return W[2]?w(s)+W[2]+w(p)+W[4].replace(/^([=:])\s+/,"$1 "):W[0]});function w(W){return n.stringRepeat(" ",W)}function E(W){return W[2]?w(s)+W[2]+w(c-W[2].length+p)+W[4].replace(/^([=:])\s+/,"$1 "):W[0]}}}).call(a.prototype),f.onSessionChange=function(s){var t=s.session,s=(t&&!t.multiSelect&&(t.$selectionMarkers=[],t.selection.$initRangeList(),t.multiSelect=t.selection),this.multiSelect=t&&t.multiSelect,s.oldSession);s&&(s.multiSelect.off("addRange",this.$onAddRange),s.multiSelect.off("removeRange",this.$onRemoveRange),s.multiSelect.off("multiSelect",this.$onMultiSelect),s.multiSelect.off("singleSelect",this.$onSingleSelect),s.multiSelect.lead.off("change",this.$checkMultiselectChange),s.multiSelect.anchor.off("change",this.$checkMultiselectChange)),t&&(t.multiSelect.on("addRange",this.$onAddRange),t.multiSelect.on("removeRange",this.$onRemoveRange),t.multiSelect.on("multiSelect",this.$onMultiSelect),t.multiSelect.on("singleSelect",this.$onSingleSelect),t.multiSelect.lead.on("change",this.$checkMultiselectChange),t.multiSelect.anchor.on("change",this.$checkMultiselectChange)),t&&this.inMultiSelectMode!=t.selection.inMultiSelectMode&&(t.selection.inMultiSelectMode?this.$onMultiSelect():this.$onSingleSelect())},f.MultiSelect=r,A("./config").defineOptions(a.prototype,"editor",{enableMultiselect:{set:function(e){r(this),e?this.on("mousedown",h):this.off("mousedown",h)},value:!0},enableBlockSelect:{set:function(e){this.$blockSelectEnabled=e},value:!0}})}),ace.define("ace/mode/folding/fold_mode",["require","exports","module","ace/range"],function(C,f,R){var y=C("../../range").Range,C=f.FoldMode=function(){};(function(){this.foldingStartMarker=null,this.foldingStopMarker=null,this.getFoldWidget=function(d,h,l){return d=d.getLine(l),this.foldingStartMarker.test(d)?"start":h=="markbeginend"&&this.foldingStopMarker&&this.foldingStopMarker.test(d)?"end":""},this.getFoldWidgetRange=function(d,h,l){return null},this.indentationBlock=function(d,h,l){var n=/\S/,o=d.getLine(h),i=o.search(n);if(i!=-1){for(var a,l=l||o.length,r=d.getLength(),o=h,e=h;++h<r;){var t=d.getLine(h).search(n);if(t!=-1){if(t<=i&&(t=d.getTokenAt(h,0),!t||t.type!=="string"))break;e=h}}return o<e?(a=d.getLine(e).length,new y(o,l,e,a)):void 0}},this.openingBracketBlock=function(d,h,l,n,o){if(l={row:l,column:n+1},n=d.$findClosingBracket(h,l,o),n)return(h=(h=d.foldWidgets[n.row])==null?d.getFoldWidget(n.row):h)=="start"&&n.row>l.row&&(n.row--,n.column=d.getLine(n.row).length),y.fromPoints(l,n)},this.closingBracketBlock=function(d,h,l,n,o){if(l={row:l,column:n},n=d.$findOpeningBracket(h,l),n)return n.column++,l.column--,y.fromPoints(n,l)}}).call(C.prototype)}),ace.define("ace/ext/error_marker",["require","exports","module","ace/line_widgets","ace/lib/dom","ace/range","ace/config"],function(A,f,R){var y=A("../line_widgets").LineWidgets,C=A("../lib/dom"),d=A("../range").Range,h=A("../config").nls;function l(n,o,i){var a=n.getAnnotations().sort(d.comparePoints);if(a.length){var r=function(s,c,p){for(var g=0,b=s.length-1;g<=b;){var w=g+b>>1,E=p(c,s[w]);if(0<E)g=1+w;else{if(!(E<0))return w;b=w-1}}return-(g+1)}(a,{row:o,column:-1},d.comparePoints),e=((r=r<0?-r-1:r)>=a.length?r=0<i?0:a.length-1:r===0&&i<0&&(r=a.length-1),a[r]);if(e&&i){if(e.row===o){for(;(e=a[r+=i])&&e.row===o;);if(!e)return a.slice()}var t=[];for(o=e.row;t[i<0?"unshift":"push"](e),(e=a[r+=i])&&e.row==o;);return t.length&&t}}}f.showErrorMarker=function(n,c){var i,a=n.session,r=(a.widgetManager||(a.widgetManager=new y(a),a.widgetManager.attach(n)),n.getCursorPosition()),s=r.row,p=a.widgetManager.getWidgetsAtRow(s).filter(function(g){return g.type=="errorMarker"})[0],s=(p?p.destroy():s-=c,l(a,s,c));if(s)c=s[0],r.column=(c.pos&&typeof c.column!="number"?c.pos.sc:c.column)||0,r.row=c.row,i=n.renderer.$gutterLayer.$annotations[r.row];else{if(p)return;i={text:[h("Looks good!")],className:"ace_ok"}}n.session.unfold(r.row),n.selection.moveToPosition(r);function e(g,b,w){if(b===0&&(w==="esc"||w==="return"))return t.destroy(),{command:"null"}}var t={row:r.row,fixedWidth:!0,coverGutter:!0,el:C.createElement("div"),type:"errorMarker"},s=t.el.appendChild(C.createElement("div")),c=t.el.appendChild(C.createElement("div")),p=(c.className="error_widget_arrow "+i.className,n.renderer.$cursorLayer.getPixelPosition(r).left);c.style.left=p+n.renderer.gutterWidth-5+"px",t.el.className="error_widget_wrapper",s.className="error_widget "+i.className,s.innerHTML=i.text.join("<br>"),s.appendChild(C.createElement("div")),t.destroy=function(){n.$mouseHandler.isMousePressed||(n.keyBinding.removeKeyboardHandler(e),a.widgetManager.removeLineWidget(t),n.off("changeSelection",t.destroy),n.off("changeSession",t.destroy),n.off("mouseup",t.destroy),n.off("change",t.destroy))},n.keyBinding.addKeyboardHandler(e),n.on("changeSelection",t.destroy),n.on("changeSession",t.destroy),n.on("mouseup",t.destroy),n.on("change",t.destroy),n.session.widgetManager.addLineWidget(t),t.el.onmousedown=n.focus.bind(n),n.renderer.scrollCursorIntoView(null,.5,{bottom:t.el.offsetHeight})},C.importCssString(`
    .error_widget_wrapper {
        background: inherit;
        color: inherit;
        border:none
    }
    .error_widget {
        border-top: solid 2px;
        border-bottom: solid 2px;
        margin: 5px 0;
        padding: 10px 40px;
        white-space: pre-wrap;
    }
    .error_widget.ace_error, .error_widget_arrow.ace_error{
        border-color: #ff5a5a
    }
    .error_widget.ace_warning, .error_widget_arrow.ace_warning{
        border-color: #F1D817
    }
    .error_widget.ace_info, .error_widget_arrow.ace_info{
        border-color: #5a5a5a
    }
    .error_widget.ace_ok, .error_widget_arrow.ace_ok{
        border-color: #5aaa5a
    }
    .error_widget_arrow {
        position: absolute;
        border: solid 5px;
        border-top-color: transparent!important;
        border-right-color: transparent!important;
        border-left-color: transparent!important;
        top: -5px;
    }
`,"error_marker.css",!1)}),ace.define("ace/ace",["require","exports","module","ace/lib/dom","ace/range","ace/editor","ace/edit_session","ace/undomanager","ace/virtual_renderer","ace/worker/worker_client","ace/keyboard/hash_handler","ace/placeholder","ace/multi_select","ace/mode/folding/fold_mode","ace/theme/textmate","ace/ext/error_marker","ace/config","ace/loader_build"],function(A,f,R){A("./loader_build")(f);var y=A("./lib/dom"),C=A("./range").Range,d=A("./editor").Editor,h=A("./edit_session").EditSession,l=A("./undomanager").UndoManager,n=A("./virtual_renderer").VirtualRenderer;A("./worker/worker_client"),A("./keyboard/hash_handler"),A("./placeholder"),A("./multi_select"),A("./mode/folding/fold_mode"),A("./theme/textmate"),A("./ext/error_marker"),f.config=A("./config"),f.edit=function(o,i){if(typeof o=="string"){var a=o;if(!(o=document.getElementById(a)))throw new Error("ace.edit can't find div #"+a)}var r,e;return o&&o.env&&o.env.editor instanceof d?o.env.editor:(a="",o&&/input|textarea/i.test(o.tagName)?(a=(r=o).value,o=y.createElement("pre"),r.parentNode.replaceChild(o,r)):o&&(a=o.textContent,o.innerHTML=""),a=f.createEditSession(a),o=new d(new n(o),a,i),e={document:a,editor:o,onResize:o.resize.bind(o,null)},r&&(e.textarea=r),o.on("destroy",function(){e.editor.container.env=null}),o.container.env=o.env=e,o)},f.createEditSession=function(o,i){return o=new h(o,i),o.setUndoManager(new l),o},f.Range=C,f.Editor=d,f.EditSession=h,f.UndoManager=l,f.VirtualRenderer=n,f.version=f.config.version}),ace.require(["ace/ace"],function(A){A&&(A.config.init(!0),A.define=ace.define);var f,R=function(){return this}();for(f in(R=(R=R||typeof window>"u"?R:window)||typeof self>"u"?R:self).ace||(R.ace=A),A)A.hasOwnProperty(f)&&(R.ace[f]=A[f]);R.ace.default=R.ace,le&&(le.exports=R.ace)})},4317:function(le,m,D){le=D.nmd(le),ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(U,k,H){var j=U("./lib/dom"),r=U("./lib/oop"),z=U("./lib/event_emitter").EventEmitter,Y=U("./lib/lang"),G=U("./range").Range,N=U("./range_list").RangeList,A=U("./keyboard/hash_handler").HashHandler,f=U("./tokenizer").Tokenizer,R=U("./clipboard"),y={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,t,s){return e=e.session.getTextRange(),s?e.replace(/\n\r?([ \t]*\S)/g,`
`+s+"$1"):e},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return R.getText&&R.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){return e=e.session.$mode||{},e.blockComment&&e.blockComment.start||""},BLOCK_COMMENT_END:function(e){return e=e.session.$mode||{},e.blockComment&&e.blockComment.end||""},LINE_COMMENT:function(e){return(e.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:C.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:C.bind(null,{year:"2-digit"}),CURRENT_MONTH:C.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:C.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:C.bind(null,{month:"short"}),CURRENT_DATE:C.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:C.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:C.bind(null,{weekday:"short"}),CURRENT_HOUR:C.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:C.bind(null,{minute:"2-digit"}),CURRENT_SECOND:C.bind(null,{second:"2-digit"})};function C(e){return e=new Date().toLocaleString("en-us",e),e.length==1?"0"+e:e}y.SELECTED_TEXT=y.SELECTION,h.prototype.getTokenizer=function(){return h.$tokenizer||this.createTokenizer()},h.prototype.createTokenizer=function(){function e(c){return c=c.substr(1),/^\d+$/.test(c)?[{tabstopId:parseInt(c,10)}]:[{text:c}]}function t(c){return"(?:[^\\\\"+c+"]|\\\\.)"}var s={regex:"/("+t("/")+"+)/",onMatch:function(c,p,g){return g=g[0],g.fmtString=!0,g.guard=c.slice(1,-1),g.flag=""},next:"formatString"};return h.$tokenizer=new f({start:[{regex:/\\./,onMatch:function(c,p,g){var b=c[1];return[c=b=="}"&&g.length||"`$\\".indexOf(b)!=-1?b:c]}},{regex:/}/,onMatch:function(c,p,g){return[g.length?g.shift():c]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(c,p,g){return c=e(c.substr(1)),g.unshift(c[0]),c},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+t("\\|")+"*\\|",onMatch:function(c,p,g){return c=c.slice(1,-1).replace(/\\[,|\\]|,/g,function(b){return b.length==2?b[1]:"\0"}).split("\0").map(function(b){return{value:b}}),[(g[0].choices=c)[0]]},next:"start"},s,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(c,p,g){return g.length&&g[0].expectElse?(g[0].expectElse=!1,g[0].ifEnd={elseEnd:g[0]},[g[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(c,p,g){var b=c[1];return b=="}"&&g.length||"`$\\".indexOf(b)!=-1?c=b:b=="n"?c=`
`:b=="t"?c="	":"ulULE".indexOf(b)!=-1&&(c={changeCase:b,local:"a"<b}),[c]}},{regex:"/\\w*}",onMatch:function(c,p,g){return g=g.shift(),g&&(g.flag=c.slice(1,-1)),this.next=g&&g.tabstopId?"start":"",[g||c]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(c,p,g){return[{text:c.slice(1)}]}},{regex:/\${\w+/,onMatch:function(c,p,g){return c={text:c.slice(2)},g.unshift(c),[c]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(c,p,g){return g=g.shift(),this.next=g&&g.tabstopId?"start":"",[g||c]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(c,p,g){return g[0].formatFunction=c.slice(2,-1),[g.shift()]},next:"formatString"},s,{regex:/:[\?\-+]?/,onMatch:function(c,p,g){c[1]=="+"&&(g[0].ifEnd=g[0]),c[1]=="?"&&(g[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},h.prototype.tokenizeTmSnippet=function(e,t){return this.getTokenizer().getLineTokens(e,t).tokens.map(function(s){return s.value||s})},h.prototype.getVariableValue=function(e,t,s){var c;return/^\d+$/.test(t)?(this.variables.__||{})[t]||"":/^[A-Z]\d+$/.test(t)?(this.variables[t[0]+"__"]||{})[t.substr(1)]||"":(t=t.replace(/^TM_/,""),!this.variables.hasOwnProperty(t)||(c=typeof(c=this.variables[t])=="function"?this.variables[t](e,t,s):c)==null?"":c)},h.prototype.tmStrFormat=function(e,t,s){var c,p,g,b;return t.fmt?(c=t.flag||"",p=t.guard,p=new RegExp(p,c.replace(/[^gim]/g,"")),g=typeof t.fmt=="string"?this.tokenizeTmSnippet(t.fmt,"formatString"):t.fmt,b=this,e.replace(p,function(){for(var w=b.variables.__,E=(b.variables.__=[].slice.call(arguments),b.resolveVariables(g,s)),W="E",B=0;B<E.length;B++){var O,x=E[B];typeof x=="object"?(E[B]="",x.changeCase&&x.local?(O=E[B+1])&&typeof O=="string"&&(x.changeCase=="u"?E[B]=O[0].toUpperCase():E[B]=O[0].toLowerCase(),E[B+1]=O.substr(1)):x.changeCase&&(W=x.changeCase)):W=="U"?E[B]=x.toUpperCase():W=="L"&&(E[B]=x.toLowerCase())}return b.variables.__=w,E.join("")})):e},h.prototype.tmFormatFunction=function(e,t,s){return t.formatFunction=="upcase"?e.toUpperCase():t.formatFunction=="downcase"?e.toLowerCase():e},h.prototype.resolveVariables=function(e,t){for(var s=[],c="",p=!0,g=0;g<e.length;g++){var b,w=e[g];typeof w=="string"?(s.push(w),w==`
`?(p=!0,c=""):p&&(c=/^\t*/.exec(w)[0],p=/\S/.test(w))):w&&(p=!1,w.fmtString&&((b=e.indexOf(w,g+1))==-1&&(b=e.length),w.fmt=e.slice(g+1,b),g=b),w.text?(b=this.getVariableValue(t,w.text,c)+"",w.fmtString&&(b=this.tmStrFormat(b,w,t)),(b=w.formatFunction?this.tmFormatFunction(b,w,t):b)&&!w.ifEnd?(s.push(b),E(w)):!b&&w.ifEnd&&E(w.ifEnd)):w.elseEnd?E(w.elseEnd):w.tabstopId==null&&w.changeCase==null||s.push(w))}function E(W){W=e.indexOf(W,g+1),W!=-1&&(g=W)}return s},h.prototype.getDisplayTextForSnippet=function(e,t){return l.call(this,e,t).text},h.prototype.insertSnippetForSelection=function(w,c,p){var c=l.call(this,w,c,p=p===void 0?{}:p),p=w.getSelectionRange(),g=w.session.replace(p,c.text),b=new n(w),w=w.inVirtualSelectionMode&&w.selection.index;b.addTabstops(c.tabstops,p.start,g,w)},h.prototype.insertSnippet=function(e,t,s){s===void 0&&(s={});var c=this;if(e.inVirtualSelectionMode)return c.insertSnippetForSelection(e,t,s);e.forEachSelection(function(){c.insertSnippetForSelection(e,t,s)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},h.prototype.$getScope=function(e){var t,s=e.session.$mode.$id||"";return(s=s.split("/").pop())!=="html"&&s!=="php"||(s!=="php"||e.session.$mode.inlinePhp||(s="html"),t=e.getCursorPosition(),(e=typeof(e=e.session.getState(t.row))=="object"?e[0]:e).substring&&(e.substring(0,3)=="js-"?s="javascript":e.substring(0,4)=="css-"?s="css":e.substring(0,4)=="php-"&&(s="php"))),s},h.prototype.getActiveScopes=function(t){var t=this.$getScope(t),s=[t],c=this.snippetMap;return c[t]&&c[t].includeScopes&&s.push.apply(s,c[t].includeScopes),s.push("_"),s},h.prototype.expandWithTab=function(e,t){var s=this,c=e.forEachSelection(function(){return s.expandSnippetForSelection(e,t)},null,{keepOrder:!0});return c&&e.tabstopManager&&e.tabstopManager.tabNext(),c},h.prototype.expandSnippetForSelection=function(e,t){var s,c=e.getCursorPosition(),p=e.session.getLine(c.row),g=p.substring(0,c.column),b=p.substr(c.column),w=this.snippetMap;return this.getActiveScopes(e).some(function(E){return E=w[E],!!(s=E?this.findMatchingSnippet(E,g,b):s)},this),!!s&&(t&&t.dryRun||(e.session.doc.removeInLine(c.row,c.column-s.replaceBefore.length,c.column+s.replaceAfter.length),this.variables.M__=s.matchBefore,this.variables.T__=s.matchAfter,this.insertSnippetForSelection(e,s.content),this.variables.M__=this.variables.T__=null),!0)},h.prototype.findMatchingSnippet=function(e,t,s){for(var c=e.length;c--;){var p=e[c];if((!p.startRe||p.startRe.test(t))&&(!p.endRe||p.endRe.test(s))&&(p.startRe||p.endRe))return p.matchBefore=p.startRe?p.startRe.exec(t):[""],p.matchAfter=p.endRe?p.endRe.exec(s):[""],p.replaceBefore=p.triggerRe?p.triggerRe.exec(t)[0]:"",p.replaceAfter=p.endTriggerRe?p.endTriggerRe.exec(s)[0]:"",p}},h.prototype.register=function(e,t){var s=this.snippetMap,c=this.snippetNameMap,p=this;function g(E){return(E=E&&!/^\^?\(.*\)\$?$|^\\b$/.test(E)?"(?:"+E+")":E)||""}function b(E,W,B){return E=g(E),W=g(W),B?(E=W+E)&&E[E.length-1]!="$"&&(E+="$"):(E+=W)&&E[0]!="^"&&(E="^"+E),new RegExp(E)}function w(E){E.scope||(E.scope=t||"_"),t=E.scope,s[t]||(s[t]=[],c[t]={});var W,B=c[t];E.name&&((W=B[E.name])&&p.unregister(W),B[E.name]=E),s[t].push(E),E.prefix&&(E.tabTrigger=E.prefix),!E.content&&E.body&&(E.content=Array.isArray(E.body)?E.body.join(`
`):E.body),E.tabTrigger&&!E.trigger&&(!E.guard&&/^\w/.test(E.tabTrigger)&&(E.guard="\\b"),E.trigger=Y.escapeRegExp(E.tabTrigger)),(E.trigger||E.guard||E.endTrigger||E.endGuard)&&(E.startRe=b(E.trigger,E.guard,!0),E.triggerRe=new RegExp(E.trigger),E.endRe=b(E.endTrigger,E.endGuard,!0),E.endTriggerRe=new RegExp(E.endTrigger))}e=e||[],Array.isArray(e)?e.forEach(w):Object.keys(e).forEach(function(E){w(e[E])}),this._signal("registerSnippets",{scope:t})},h.prototype.unregister=function(e,t){var s=this.snippetMap,c=this.snippetNameMap;function p(g){var b=c[g.scope||t];b&&b[g.name]&&(delete b[g.name],0<=(g=(b=s[g.scope||t])&&b.indexOf(g)))&&b.splice(g,1)}e.content?p(e):Array.isArray(e)&&e.forEach(p)},h.prototype.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var t,s,c,p=[],g={},b=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;s=b.exec(e);){if(s[1])try{g=JSON.parse(s[1]),p.push(g)}catch{}s[4]?(g.content=s[4].replace(/^\t/gm,""),p.push(g),g={}):(t=s[2],s=s[3],t=="regex"?(g.guard=(c=/\/((?:[^\/\\]|\\.)*)|$/g).exec(s)[1],g.trigger=c.exec(s)[1],g.endTrigger=c.exec(s)[1],g.endGuard=c.exec(s)[1]):t=="snippet"?(g.tabTrigger=s.match(/^\S*/)[0],g.name||(g.name=s)):t&&(g[t]=s))}return p},h.prototype.getSnippetByName=function(e,t){var s,c=this.snippetNameMap;return this.getActiveScopes(t).some(function(p){return p=c[p],!!(s=p?p[e]:s)},this),s};var d=h;function h(){this.snippetMap={},this.snippetNameMap={},this.variables=y}r.implement(d.prototype,z);var l=function(e,t,s){s===void 0&&(s={});for(var c=e.getCursorPosition(),p=e.session.getLine(c.row),g=e.session.getTabString(),b=p.match(/^\s*/)[0],w=(c.column<b.length&&(b=b.slice(0,c.column)),t=t.replace(/\r/g,""),this.tokenizeTmSnippet(t)),E=(w=(w=this.resolveVariables(w,e)).map(function(M){return M!=`
`||s.excludeExtraIndent?typeof M=="string"?M.replace(/\t/g,g):M:M+b}),[]),W=(w.forEach(function(M,X){var Q,K,ne;typeof M=="object"&&(ne=M.tabstopId,(Q=E[ne])||((Q=E[ne]=[]).index=ne,Q.value="",Q.parents={}),Q.indexOf(M)===-1)&&(M.choices&&!Q.choices&&(Q.choices=M.choices),Q.push(M),(K=w.indexOf(M,X+1))!==-1)&&((ne=w.slice(X+1,K)).some(function(T){return typeof T=="object"})&&!Q.value?Q.value=ne:!ne.length||Q.value&&typeof Q.value=="string"||(Q.value=ne.join("")))}),E.forEach(function(M){M.length=0}),{}),B=0;B<w.length;B++){var O,x,u,_=w[B];typeof _=="object"&&(u=_.tabstopId,O=E[u],x=w.indexOf(_,B+1),W[u]?W[u]===_&&(delete W[u],Object.keys(W).forEach(function(M){O.parents[M]=!0})):(W[u]=_,typeof(u=O.value)!="string"?u=function(M){for(var X=[],Q=0;Q<M.length;Q++){if(typeof(K=M[Q])=="object"){if(W[K.tabstopId])continue;var K=X[M.lastIndexOf(K,Q-1)]||{tabstopId:K.tabstopId}}X[Q]=K}return X}(u):_.fmt&&(u=this.tmStrFormat(u,_,e)),w.splice.apply(w,[B+1,Math.max(0,x-B)].concat(u,_)),O.indexOf(_)===-1&&O.push(_)))}var v=0,$=0,P="";return w.forEach(function(M){var X;typeof M=="string"?(1<(X=M.split(`
`)).length?($=X[X.length-1].length,v+=X.length-1):$+=M.length,P+=M):M&&(M.start?M.end={row:v,column:$}:M.start={row:v,column:$})}),{text:P,tabstops:E,tokens:w}},n=(o.prototype.attach=function(e){this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.session=e.session,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},o.prototype.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges.length=0,this.tabstops.length=0,this.selectedTabstop=null,this.editor.off("change",this.$onChange),this.editor.off("changeSelection",this.$onChangeSelection),this.editor.off("changeSession",this.$onChangeSession),this.editor.commands.off("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.session=null,this.editor=null},o.prototype.onChange=function(e){for(var t=e.action[0]=="r",s=this.selectedTabstop||{},c=s.parents||{},p=this.tabstops.slice(),g=0;g<p.length;g++){var b=p[g],w=b==s||c[b.index];if(b.rangeList.$bias=w?0:1,e.action=="remove"&&b!==s)for(var w=b.parents&&b.parents[s.index],E=(E=b.rangeList.pointIndex(e.start,w))<0?-E-1:E+1,w=b.rangeList.pointIndex(e.end,w),W=b.rangeList.ranges.slice(E,w<0?-w-1:w-1),B=0;B<W.length;B++)this.removeRange(W[B]);b.rangeList.$onChange(e)}var O=this.session;this.$inChange||!t||O.getLength()!=1||O.getValue()||this.detach()},o.prototype.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var t=this.session,s=t.getTextRange(e.firstNonLinked),c=0;c<e.length;c++){var p,g=e[c];g.linked&&(p=g.original,p=k.snippetManager.tmStrFormat(s,p,this.editor),t.replace(g,p))}this.$inChange=!1}},o.prototype.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},o.prototype.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,t=this.editor.selection.anchor,s=this.editor.selection.isEmpty(),c=0;c<this.ranges.length;c++)if(!this.ranges[c].linked){var p=this.ranges[c].contains(e.row,e.column),g=s||this.ranges[c].contains(t.row,t.column);if(p&&g)return}this.detach()}},o.prototype.onChangeSession=function(){this.detach()},o.prototype.tabNext=function(s){var t=this.tabstops.length,s=this.index+(s||1),s=Math.min(Math.max(s,1),t);this.selectTabstop(s=s==t?0:s),s===0&&this.detach()},o.prototype.selectTabstop=function(e){this.$openTabstops=null;var t=this.tabstops[this.index];if(t&&this.addTabstopMarkers(t),this.index=e,(t=this.tabstops[this.index])&&t.length){if(e=(this.selectedTabstop=t).firstNonLinked||t,t.choices&&(e.cursor=e.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(e);else{var s=this.editor.multiSelect;s.toSingleRange(e);for(var c=0;c<t.length;c++)t.hasLinkedRanges&&t[c].linked||s.addRange(t[c].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},o.prototype.addTabstops=function(e,t,s){var c=this.useLink||!this.editor.getOption("enableMultiselect");this.$openTabstops||(this.$openTabstops=[]),e[0]||(s=G.fromPoints(s,s),a(s.start,t),a(s.end,t),e[0]=[s],e[0].index=0);var p=[this.index+1,0],g=this.ranges;e.forEach(function(b,w){for(var E=this.$openTabstops[w]||b,W=0;W<b.length;W++){var B=b[W],O=G.fromPoints(B.start,B.end||B.start);i(O.start,t),i(O.end,t),O.original=B,O.tabstop=E,g.push(O),E!=b?E.unshift(O):E[W]=O,B.fmtString||E.firstNonLinked&&c?(O.linked=!0,E.hasLinkedRanges=!0):E.firstNonLinked||(E.firstNonLinked=O)}E.firstNonLinked||(E.hasLinkedRanges=!1),E===b&&(p.push(E),this.$openTabstops[w]=E),this.addTabstopMarkers(E),E.rangeList=E.rangeList||new N,E.rangeList.$bias=0,E.rangeList.addList(E)},this),2<p.length&&(this.tabstops.length&&p.push(p.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,p))},o.prototype.addTabstopMarkers=function(e){var t=this.session;e.forEach(function(s){s.markerId||(s.markerId=t.addMarker(s,"ace_snippet-marker","text"))})},o.prototype.removeTabstopMarkers=function(e){var t=this.session;e.forEach(function(s){t.removeMarker(s.markerId),s.markerId=null})},o.prototype.removeRange=function(e){var t=e.tabstop.indexOf(e);t!=-1&&e.tabstop.splice(t,1),(t=this.ranges.indexOf(e))!=-1&&this.ranges.splice(t,1),(t=e.tabstop.rangeList.ranges.indexOf(e))!=-1&&e.tabstop.splice(t,1),this.session.removeMarker(e.markerId),e.tabstop.length||((t=this.tabstops.indexOf(e.tabstop))!=-1&&this.tabstops.splice(t,1),this.tabstops.length)||this.detach()},o);function o(e){if(this.index=0,this.ranges=[],this.tabstops=[],e.tabstopManager)return e.tabstopManager;(e.tabstopManager=this).$onChange=this.onChange.bind(this),this.$onChangeSelection=Y.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)}n.prototype.keyboardHandler=new A,n.prototype.keyboardHandler.bindKeys({Tab:function(e){k.snippetManager&&k.snippetManager.expandWithTab(e)||(e.tabstopManager.tabNext(1),e.renderer.scrollCursorIntoView())},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1),e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}});var i=function(e,t){e.row==0&&(e.column+=t.column),e.row+=t.row},a=function(e,t){e.row==t.row&&(e.column-=t.column),e.row-=t.row},r=(j.importCssString(`
.ace_snippet-marker {
    -moz-box-sizing: border-box;
    box-sizing: border-box;
    background: rgba(194, 193, 208, 0.09);
    border: 1px dotted rgba(211, 208, 235, 0.62);
    position: absolute;
}`,"snippets.css",!1),k.snippetManager=new d,U("./editor").Editor);(function(){this.insertSnippet=function(e,t){return k.snippetManager.insertSnippet(this,e,t)},this.expandSnippet=function(e){return k.snippetManager.expandWithTab(this,e)}}).call(r.prototype)}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config"],function(U,k,H){function j(d){return"suggest-aria-id:".concat(d)}function z(d){return(d=new G(d)).$maxLines=4,(d=new N(d)).setHighlightActiveLine(!1),d.setShowPrintMargin(!1),d.renderer.setShowGutter(!1),d.renderer.setHighlightGutterLine(!1),d.$mouseHandler.$focusTimeout=0,d.$highlightTagPending=!0,d}function Y(d){function h(){}function l(){e(-1)}var n,o=y.createElement("div"),i=new z(o),a=(d&&d.appendChild(o),o.style.display="none",i.renderer.content.style.cursor="default",i.renderer.setStyle("ace_autocomplete"),i.renderer.$textLayer.element.setAttribute("role","listbox"),i.renderer.$textLayer.element.setAttribute("aria-label",C("Autocomplete suggestions")),i.renderer.textarea.setAttribute("aria-hidden","true"),i.setOption("displayIndentGuides",!1),i.setOption("dragDelay",150),i.focus=h,i.$isFocused=!0,i.renderer.$cursorLayer.restartTimer=h,i.renderer.$cursorLayer.element.style.opacity=0,i.renderer.$maxLines=8,i.renderer.$keepTextAreaAtCursor=!1,i.setHighlightActiveLine(!1),i.session.highlight(""),i.session.$searchHighlight.clazz="ace_highlight-marker",i.on("mousedown",function(t){var s=t.getDocumentPosition();i.selection.moveToPosition(s),r.start.row=r.end.row=s.row,t.stop()}),new A(-1,0,-1,1/0)),r=new A(-1,0,-1,1/0),e=(r.id=i.session.addMarker(r,"ace_active-line","fullLine"),i.setSelectOnHover=function(t){t?a.id&&(i.session.removeMarker(a.id),a.id=null):a.id=i.session.addMarker(a,"ace_line-hover","fullLine")},i.setSelectOnHover(!1),i.on("mousemove",function(t){var s;n?n.x==t.x&&n.y==t.y||((n=t).scrollTop=i.renderer.scrollTop,i.isMouseOver=!0,s=n.getDocumentPosition().row,a.start.row!=s&&(a.id||i.setRow(s),e(s))):n=t}),i.renderer.on("beforeRender",function(){var t;n&&a.start.row!=-1&&(n.$pos=null,t=n.getDocumentPosition().row,a.id||i.setRow(t),e(t,!0))}),i.renderer.on("afterRender",function(){var t,s=i.getRow(),c=i.renderer.$textLayer,p=c.element.childNodes[s-c.config.firstRow],g=document.activeElement;p!==c.selectedNode&&c.selectedNode&&(y.removeCssClass(c.selectedNode,"ace_selected"),g.removeAttribute("aria-activedescendant"),c.selectedNode.removeAttribute("id")),(c.selectedNode=p)&&(y.addCssClass(p,"ace_selected"),t=j(s),p.id=t,c.element.setAttribute("aria-activedescendant",t),g.setAttribute("aria-activedescendant",t),p.setAttribute("role","option"),p.setAttribute("aria-label",i.getData(s).value),p.setAttribute("aria-setsize",i.data.length),p.setAttribute("aria-posinset",s+1),p.setAttribute("aria-describedby","doc-tooltip"))}),function(t,s){t!==a.start.row&&(a.start.row=a.end.row=t,s||i.session._emit("changeBackMarker"),i._emit("changeHoverMarker"))});return i.getHoveredRow=function(){return a.start.row},f.addListener(i.container,"mouseout",function(){i.isMouseOver=!1,l()}),i.on("hide",l),i.on("changeSelection",l),i.session.doc.getLength=function(){return i.data.length},i.session.doc.getLine=function(t){return t=i.data[t],typeof t=="string"?t:t&&t.value||""},(d=i.session.bgTokenizer).$tokenizeRow=function(t){var s=i.data[t],c=[];if(s){for(var p,g,b=(s=typeof s=="string"?{value:s}:s).caption||s.value||s.name,w=b.toLowerCase(),E=(i.filterText||"").toLowerCase(),W=0,B=0,O=0;O<=E.length;O++)O!=B&&(s.matchMask&1<<O||O==E.length)&&(p=E.slice(B,O),B=O,(g=w.indexOf(p,W))!=-1)&&(x(b.slice(W,g),""),W=g+p.length,x(b.slice(g,W),"completion-highlight"));x(b.slice(W,b.length),""),c.push({type:"completion-spacer",value:" "}),s.meta&&c.push({type:"completion-meta",value:s.meta}),s.message&&c.push({type:"completion-message",value:s.message})}return c;function x(u,_){u&&c.push({type:(s.className||"")+(_||""),value:u})}},d.$updateOnChange=h,d.start=h,i.session.$computeWidth=function(){return this.screenWidth=0},i.isOpen=!1,i.isTopdown=!1,i.autoSelect=!0,i.filterText="",i.isMouseOver=!1,i.data=[],i.setData=function(t,s){i.filterText=s||"",i.setValue(R.stringRepeat(`
`,t.length),-1),i.data=t||[],i.setRow(0)},i.getData=function(t){return i.data[t]},i.getRow=function(){return r.start.row},i.setRow=function(t){t=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,t)),r.start.row!=t&&(i.selection.clearSelection(),r.start.row=r.end.row=t||0,i.session._emit("changeBackMarker"),i.moveCursorTo(t||0,0),i.isOpen)&&i._signal("select")},i.on("changeSelection",function(){i.isOpen&&i.setRow(i.selection.lead.row),i.renderer.scrollCursorIntoView()}),i.hide=function(){this.container.style.display="none",i.anchorPos=null,i.anchor=null,i.isOpen&&(i.isOpen=!1,this._signal("hide"))},i.tryShow=function(t,s,c,p){if(p||!i.isOpen||!i.anchorPos||!i.anchor||i.anchorPos.top!==t.top||i.anchorPos.left!==t.left||i.anchor!==c){var g=this.container,b=window.innerHeight,w=window.innerWidth,E=this.renderer,W=E.$maxLines*s*1.4,B={top:0,bottom:0,left:0},O=b-t.top-3*this.$borderSize-s,x=t.top-3*this.$borderSize,s=((c=c||(x<=O||W<=O?"bottom":"top"))==="top"?(B.bottom=t.top-this.$borderSize,B.top=B.bottom-W):c==="bottom"&&(B.top=t.top+s+this.$borderSize,B.bottom=B.top+W),0<=B.top&&B.bottom<=b);if(!p&&!s)return!1;E.$maxPixelHeight=s?null:c==="top"?x:O,c==="top"?(g.style.top="",g.style.bottom=b-B.bottom+"px",i.isTopdown=!1):(g.style.top=B.top+"px",g.style.bottom="",i.isTopdown=!0),g.style.display="",W=t.left,W+g.offsetWidth>w&&(W=w-g.offsetWidth),g.style.left=W+"px",g.style.right="",i.isOpen||(i.isOpen=!0,this._signal("show"),n=null),i.anchorPos=t,i.anchor=c}return!0},i.show=function(t,s,c){this.tryShow(t,s,c?"bottom":void 0,!0)},i.goTo=function(t){var s=this.getRow(),c=this.session.getLength()-1;switch(t){case"up":s=s<=0?c:s-1;break;case"down":s=c<=s?-1:s+1;break;case"start":s=0;break;case"end":s=c}this.setRow(s)},i.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},i.$imageSize=0,i.$borderSize=1,i}var G=U("../virtual_renderer").VirtualRenderer,N=U("../editor").Editor,A=U("../range").Range,f=U("../lib/event"),R=U("../lib/lang"),y=U("../lib/dom"),C=U("../config").nls;y.importCssString(`
.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {
    background-color: #CAD6FA;
    z-index: 1;
}
.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {
    background-color: #3a674e;
}
.ace_editor.ace_autocomplete .ace_line-hover {
    border: 1px solid #abbffe;
    margin-top: -1px;
    background: rgba(233,233,253,0.4);
    position: absolute;
    z-index: 2;
}
.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {
    border: 1px solid rgba(109, 150, 13, 0.8);
    background: rgba(58, 103, 78, 0.62);
}
.ace_completion-meta {
    opacity: 0.5;
    margin-left: 0.9em;
}
.ace_completion-message {
    margin-left: 0.9em;
    color: blue;
}
.ace_editor.ace_autocomplete .ace_completion-highlight{
    color: #2d69c7;
}
.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{
    color: #93ca12;
}
.ace_editor.ace_autocomplete {
    width: 300px;
    z-index: 200000;
    border: 1px lightgray solid;
    position: fixed;
    box-shadow: 2px 3px 5px rgba(0,0,0,.2);
    line-height: 1.4;
    background: #fefefe;
    color: #111;
}
.ace_dark.ace_editor.ace_autocomplete {
    border: 1px #484747 solid;
    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);
    line-height: 1.4;
    background: #25282c;
    color: #c1c1c1;
}
.ace_autocomplete .ace_text-layer  {
    width: calc(100% - 8px);
}
.ace_autocomplete .ace_line {
    display: flex;
    align-items: center;
}
.ace_autocomplete .ace_line > * {
    min-width: 0;
    flex: 0 0 auto;
}
.ace_autocomplete .ace_line .ace_ {
    flex: 0 1 auto;
    overflow: hidden;
    white-space: nowrap;
    text-overflow: ellipsis;
}
.ace_autocomplete .ace_completion-spacer {
    flex: 1;
}
.ace_autocomplete.ace_loading:after  {
    content: "";
    position: absolute;
    top: 0px;
    height: 2px;
    width: 8%;
    background: blue;
    z-index: 100;
    animation: ace_progress 3s infinite linear;
    animation-delay: 300ms;
    transform: translateX(-100%) scaleX(1);
}
@keyframes ace_progress {
    0% { transform: translateX(-100%) scaleX(1) }
    50% { transform: translateX(625%) scaleX(2) } 
    100% { transform: translateX(1500%) scaleX(3) } 
}
@media (prefers-reduced-motion) {
    .ace_autocomplete.ace_loading:after {
        transform: translateX(625%) scaleX(2);
        animation: none;
     }
}
`,"autocompletion.css",!1),k.AcePopup=Y,k.$singleLineEditor=z,k.getAriaId=j}),ace.define("ace/autocomplete/inline_screenreader",["require","exports","module"],function(U,k,H){function j(z){this.editor=z,this.screenReaderDiv=document.createElement("div"),this.screenReaderDiv.classList.add("ace_screenreader-only"),this.editor.container.appendChild(this.screenReaderDiv)}j.prototype.setScreenReaderContent=function(z){for(!this.popup&&this.editor.completer&&this.editor.completer.popup&&(this.popup=this.editor.completer.popup,this.popup.renderer.on("afterRender",(function(){var G=this.popup.getRow(),Y=this.popup.renderer.$textLayer,G=Y.element.childNodes[G-Y.config.firstRow];if(G){for(var N="doc-tooltip ",A=0;A<this._lines.length;A++)N+="ace-inline-screenreader-line-".concat(A," ");G.setAttribute("aria-describedby",N)}}).bind(this)));this.screenReaderDiv.firstChild;)this.screenReaderDiv.removeChild(this.screenReaderDiv.firstChild);this._lines=z.split(/\r\n|\r|\n/),z=this.createCodeBlock(),this.screenReaderDiv.appendChild(z)},j.prototype.destroy=function(){this.screenReaderDiv.remove()},j.prototype.createCodeBlock=function(){var z=document.createElement("pre");z.setAttribute("id","ace-inline-screenreader");for(var Y=0;Y<this._lines.length;Y++){var G=document.createElement("code"),N=(G.setAttribute("id","ace-inline-screenreader-line-".concat(Y)),document.createTextNode(this._lines[Y]));G.appendChild(N),z.appendChild(G)}return z},k.AceInlineScreenReader=j}),ace.define("ace/autocomplete/inline",["require","exports","module","ace/snippets","ace/autocomplete/inline_screenreader"],function(U,k,H){var j=U("../snippets").snippetManager,z=U("./inline_screenreader").AceInlineScreenReader;function Y(){this.editor=null}Y.prototype.show=function(G,N,A){if(A=A||"",G&&this.editor&&this.editor!==G&&(this.hide(),this.editor=null,this.inlineScreenReader=null),!G||!N)return!1;this.inlineScreenReader||(this.inlineScreenReader=new z(G));var f=N.snippet?j.getDisplayTextForSnippet(G,N.snippet):N.value;return!(N.hideInlinePreview||!f||!f.startsWith(A)||(this.editor=G,this.inlineScreenReader.setScreenReaderContent(f),(f=f.slice(A.length))===""?G.removeGhostText():G.setGhostText(f),0))},Y.prototype.isOpen=function(){return!!this.editor&&!!this.editor.renderer.$ghostText},Y.prototype.hide=function(){return!!this.editor&&(this.editor.removeGhostText(),!0)},Y.prototype.destroy=function(){this.hide(),this.editor=null,this.inlineScreenReader&&(this.inlineScreenReader.destroy(),this.inlineScreenReader=null)},k.AceInline=Y}),ace.define("ace/autocomplete/util",["require","exports","module"],function(U,k,H){k.parForEach=function(z,Y,G){var N=0,A=z.length;A===0&&G();for(var f=0;f<A;f++)Y(z[f],function(R,y){++N===A&&G(R,y)})};var j=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;k.retrievePrecedingIdentifier=function(z,Y,G){G=G||j;for(var N=[],A=Y-1;0<=A&&G.test(z[A]);A--)N.push(z[A]);return N.reverse().join("")},k.retrieveFollowingIdentifier=function(z,Y,G){G=G||j;for(var N=[],A=Y;A<z.length&&G.test(z[A]);A++)N.push(z[A]);return N},k.getCompletionPrefix=function(z){var Y,G=z.getCursorPosition(),N=z.session.getLine(G.row);return z.completers.forEach((function(A){A.identifierRegexps&&A.identifierRegexps.forEach((function(f){!Y&&f&&(Y=this.retrievePrecedingIdentifier(N,G.column,f))}).bind(this))}).bind(this)),Y||this.retrievePrecedingIdentifier(N,G.column)},k.triggerAutocomplete=function(z){var Y=z.getCursorPosition(),G=z.session.getLine(Y.row)[Y.column===0?0:Y.column-1];return z.completers.some(function(N){if(N.triggerCharacters&&Array.isArray(N.triggerCharacters))return N.triggerCharacters.includes(G)})}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config","ace/lib/event"],function(U,k,H){function j(r,e){e.completer&&e.completer.destroy()}var z=U("./keyboard/hash_handler").HashHandler,Y=U("./autocomplete/popup").AcePopup,G=U("./autocomplete/inline").AceInline,N=U("./autocomplete/popup").getAriaId,A=U("./autocomplete/util"),f=U("./lib/lang"),R=U("./lib/dom"),y=U("./snippets").snippetManager,C=U("./config"),d=U("./lib/event"),h=(l.prototype.$init=function(){return this.popup=new Y(this.parentNode||document.body||document.documentElement),this.popup.on("click",(function(r){this.insertMatch(),r.stop()}).bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupShow.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),d.addListener(this.popup.container,"mouseout",this.mouseOutListener.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup},l.prototype.$initInline=function(){if(this.inlineEnabled&&!this.inlineRenderer)return this.inlineRenderer=new G,this.inlineRenderer},l.prototype.getPopup=function(){return this.popup||this.$init()},l.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip(),this.stickySelectionTimer.cancel(),this.stickySelection=!1},l.prototype.$onPopupChange=function(r){if(this.inlineRenderer&&this.inlineEnabled){var r=r?null:this.popup.getData(this.popup.getRow()),e=A.getCompletionPrefix(this.editor);if(this.inlineRenderer.show(this.editor,r,e)||this.inlineRenderer.hide(),this.popup.isMouseOver&&this.setSelectOnHover)return void this.tooltipTimer.call(null,null)}this.$updatePopupPosition(),this.tooltipTimer.call(null,null)},l.prototype.$onPopupShow=function(r){this.$onPopupChange(r),this.stickySelection=!1,0<=this.stickySelectionDelay&&this.stickySelectionTimer.schedule(this.stickySelectionDelay)},l.prototype.observeLayoutChanges=function(){if(!this.$elements&&this.editor){window.addEventListener("resize",this.onLayoutChange,{passive:!0}),window.addEventListener("wheel",this.mousewheelListener);for(var r=this.editor.container.parentNode,e=[];r;)e.push(r),r.addEventListener("scroll",this.onLayoutChange,{passive:!0}),r=r.parentNode;this.$elements=e}},l.prototype.unObserveLayoutChanges=function(){var r=this;window.removeEventListener("resize",this.onLayoutChange,{passive:!0}),window.removeEventListener("wheel",this.mousewheelListener),this.$elements&&this.$elements.forEach(function(e){e.removeEventListener("scroll",r.onLayoutChange,{passive:!0})}),this.$elements=null},l.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition(),this.updateDocTooltip()},l.prototype.$updatePopupPosition=function(){var r=this.editor,e=r.renderer,t=e.layerConfig.lineHeight,s=e.$cursorLayer.getPixelPosition(this.base,!0),c=(s.left-=this.popup.getTextLeftOffset(),r.container.getBoundingClientRect()),c=(s.top+=c.top-e.layerConfig.offset,s.left+=c.left-r.renderer.scrollLeft,s.left+=e.gutterWidth,{top:s.top,left:s.left});e.$ghostText&&e.$ghostTextWidget&&this.base.row===e.$ghostText.position.row&&(c.top+=e.$ghostTextWidget.el.offsetHeight),this.popup.tryShow(c,t,"bottom")||this.popup.tryShow(s,t,"top")||this.popup.show(s,t)},l.prototype.openPopup=function(r,e,t){this.$firstOpenTimer.cancel(),this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setSelectOnHover(this.setSelectOnHover);var s=this.popup.data[this.popup.getRow()],s=(this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:N(this.popup.getRow()),inline:this.inlineEnabled}),r.keyBinding.addKeyboardHandler(this.keyboardHandler),this.popup.data.indexOf(s));s&&this.stickySelection?this.popup.setRow(this.autoSelect?s:-1):this.popup.setRow(this.autoSelect?0:-1),t?e||this.detach():(this.popup.setTheme(r.getTheme()),this.popup.setFontSize(r.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel(),this.observeLayoutChanges()},l.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.$firstOpenTimer.cancel(),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null,this.unObserveLayoutChanges()},l.prototype.changeListener=function(r){var e=this.editor.selection.lead;(e.row!=this.base.row||e.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},l.prototype.blurListener=function(r){var e=document.activeElement,t=this.editor.textInput.getElement(),s=r.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(r.relatedTarget),c=this.popup&&this.popup.container;e==t||e.parentNode==c||s||e==this.tooltipNode||r.relatedTarget==t||this.detach()},l.prototype.mousedownListener=function(r){this.detach()},l.prototype.mousewheelListener=function(r){this.popup.isMouseOver||this.detach()},l.prototype.mouseOutListener=function(r){this.popup.isOpen&&this.$updatePopupPosition()},l.prototype.goTo=function(r){this.popup.goTo(r)},l.prototype.insertMatch=function(r,e){var t;return!!(r=r||this.popup.getData(this.popup.getRow()))&&(r.value===""?this.detach():(t=this.completions,r=this.getCompletionProvider().insertMatch(this.editor,r,t.filterText,e),this.completions==t&&this.detach(),r))},l.prototype.showPopup=function(r,e){this.editor&&this.detach(),this.activated=!0,(this.editor=r).completer!=this&&(r.completer&&r.completer.detach(),r.completer=this),r.on("changeSelection",this.changeListener),r.on("blur",this.blurListener),r.on("mousedown",this.mousedownListener),r.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,e)},l.prototype.getCompletionProvider=function(r){return this.completionProvider||(this.completionProvider=new n(r)),this.completionProvider},l.prototype.gatherCompletions=function(r,e){return this.getCompletionProvider().gatherCompletions(r,e)},l.prototype.updateCompletions=function(r,e){var t,s;return r&&this.base&&this.completions?(t=this.editor.getCursorPosition(),(s=this.editor.session.getTextRange({start:this.base,end:t}))==this.completions.filterText?void 0:(this.completions.setFilter(s),this.completions.filtered.length&&(this.completions.filtered.length!=1||this.completions.filtered[0].value!=s||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,s,r):this.detach())):e&&e.matches?(t=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(t.row,t.column),this.base.$insertRight=!0,this.completions=new i(e.matches),this.openPopup(this.editor,"",r)):(e=this.editor.getSession(),t=this.editor.getCursorPosition(),s=A.getCompletionPrefix(this.editor),this.base=e.doc.createAnchor(t.row,t.column-s.length),this.base.$insertRight=!0,e={exactMatch:this.exactMatch,ignoreCaption:this.ignoreCaption},this.getCompletionProvider({prefix:s,pos:t}).provideCompletions(this.editor,e,(function(c,p,g){var b,w=p.filtered,E=A.getCompletionPrefix(this.editor);if(this.$firstOpenTimer.cancel(),g){if(!w.length)return(b=typeof(b=!this.autoShown&&this.emptyMessage)=="function"?this.emptyMessage(E):b)?(this.completions=new i([{caption:b,value:""}]),void this.openPopup(this.editor,E,r)):this.detach();if(w.length==1&&w[0].value==E&&!w[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&w.length==1)return this.insertMatch(w[0])}this.completions=p,this.openPopup(this.editor,E,r),this.popup.renderer.setStyle("ace_loading",!g)}).bind(this)),void(this.autoShown||this.popup&&this.popup.isOpen||this.$firstOpenTimer.delay(this.stickySelectionDelay/2)))},l.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},l.prototype.updateDocTooltip=function(){var r=this.popup,e=this.completions.filtered,t=e&&(e[r.getHoveredRow()]||e[r.getRow()]),s=null;if(!t||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();for(var c=this.editor.completers.length,p=0;p<c;p++){var g=this.editor.completers[p];if(g.getDocTooltip&&t.completerId===g.id){s=g.getDocTooltip(t);break}}if(!(s=typeof(s=s||typeof t=="string"?s:t)=="string"?{docText:s}:s)||!s.docHTML&&!s.docText)return this.hideDocTooltip();this.showDocTooltip(s)},l.prototype.showDocTooltip=function(t){this.tooltipNode||(this.tooltipNode=R.createElement("div"),this.tooltipNode.style.margin=0,this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this),this.tooltipNode.id="doc-tooltip",this.tooltipNode.setAttribute("role","tooltip"));var e=this.editor.renderer.theme,e=(this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(e.isDark?"ace_dark ":"")+(e.cssClass||""),this.tooltipNode),t=(t.docHTML?e.innerHTML=t.docHTML:t.docText&&(e.textContent=t.docText),e.parentNode||this.popup.container.appendChild(this.tooltipNode),this.popup),s=t.container.getBoundingClientRect();e.style.top=t.container.style.top,e.style.bottom=t.container.style.bottom,e.style.display="block",window.innerWidth-s.right<320?s.left<320?(t.isTopdown?e.style.top=s.bottom+"px":e.style.top=t.container.offsetTop-e.offsetHeight+"px",e.style.left=s.left+"px",e.style.right="",e.style.bottom=""):(e.style.right=window.innerWidth-s.left+"px",e.style.left=""):(e.style.left=s.right+1+"px",e.style.right="")},l.prototype.hideDocTooltip=function(){var r;this.tooltipTimer.cancel(),this.tooltipNode&&(r=this.tooltipNode,this.editor.isFocused()||document.activeElement!=r||this.editor.focus(),this.tooltipNode=null,r.parentNode)&&r.parentNode.removeChild(r)},l.prototype.onTooltipClick=function(r){for(var e=r.target;e&&e!=this.tooltipNode;){if(e.nodeName=="A"&&e.href){e.rel="noreferrer",e.target="_blank";break}e=e.parentNode}},l.prototype.destroy=function(){var r;this.detach(),this.popup&&(this.popup.destroy(),r=this.popup.container)&&r.parentNode&&r.parentNode.removeChild(r),this.editor&&this.editor.completer==this&&(this.editor.off("destroy",j),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},l);function l(){this.autoInsert=!1,this.autoSelect=!0,this.autoShown=!1,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new z,this.keyboardHandler.bindKeys(this.commands),this.parentNode=null,this.setSelectOnHover=!1,this.stickySelectionDelay=500,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.onLayoutChange=this.onLayoutChange.bind(this),this.changeTimer=f.delayedCall((function(){this.updateCompletions(!0)}).bind(this)),this.tooltipTimer=f.delayedCall(this.updateDocTooltip.bind(this),50),this.stickySelectionTimer=f.delayedCall((function(){this.stickySelection=!0}).bind(this),this.stickySelectionDelay),this.$firstOpenTimer=f.delayedCall((function(){var r,e=this.completionProvider&&this.completionProvider.initialPosition;this.autoShown||this.popup&&this.popup.isOpen||!e||(r=[{caption:C.nls("Loading..."),value:""}],this.completions=new i(r),this.openPopup(this.editor,e.prefix,!1),this.popup.renderer.setStyle("ace_loading",!0))}).bind(this),this.stickySelectionDelay)}h.prototype.commands={Up:function(r){r.completer.goTo("up")},Down:function(r){r.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(r){r.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(r){r.completer.goTo("end")},Esc:function(r){r.completer.detach()},Return:function(r){return r.completer.insertMatch()},"Shift-Return":function(r){r.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(r){var e=r.completer.insertMatch();if(e||r.tabstopManager)return e;r.completer.goTo("down")},PageUp:function(r){r.completer.popup.gotoPageUp()},PageDown:function(r){r.completer.popup.gotoPageDown()}},h.for=function(r){return r.completer instanceof h||(r.completer&&(r.completer.destroy(),r.completer=null),C.get("sharedPopups")?(h.$sharedInstance||(h.$sharedInstance=new h),r.completer=h.$sharedInstance):(r.completer=new h,r.once("destroy",j))),r.completer},h.startCommand={name:"startAutocomplete",exec:function(r,e){var t=h.for(r);t.autoInsert=!1,t.autoSelect=!0,t.autoShown=!1,t.showPopup(r,e),t.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"},o.prototype.insertByIndex=function(r,e,t){return!(!this.completions||!this.completions.filtered)&&this.insertMatch(r,this.completions.filtered[e],t)},o.prototype.insertMatch=function(r,e,t){if(!e)return!1;if(r.startOperation({command:{name:"insertMatch"}}),e.completer&&e.completer.insertMatch)e.completer.insertMatch(r,e);else{if(!this.completions)return!1;var s=this.completions.filterText.length,c=0;if(e.range&&e.range.start.row===e.range.end.row&&(s=(s-=this.initialPosition.prefix.length)+(this.initialPosition.pos.column-e.range.start.column),c+=e.range.end.column-this.initialPosition.pos.column),s||c)for(var p,g=r.selection.getAllRanges?r.selection.getAllRanges():[r.getSelectionRange()],b=0;p=g[b];b++)p.start.column-=s,p.end.column+=c,r.session.remove(p);e.snippet?y.insertSnippet(r,e.snippet):this.$insertString(r,e),e.command&&e.command==="startAutocomplete"&&r.execCommand(e.command)}return r.endOperation(),!0},o.prototype.$insertString=function(r,e){e=e.value||e,r.execCommand("insertstring",e)},o.prototype.gatherCompletions=function(r,e){var t=r.getSession(),s=r.getCursorPosition(),c=A.getCompletionPrefix(r),p=[],g=(this.completers=r.completers,r.completers.length);return r.completers.forEach(function(b,w){b.getCompletions(r,t,s,c,function(E,W){b.hideInlinePreview&&(W=W.map(function(B){return Object.assign(B,{hideInlinePreview:b.hideInlinePreview})})),!E&&W&&(p=p.concat(W)),e(null,{prefix:A.getCompletionPrefix(r),matches:p,finished:--g==0})})}),!0},o.prototype.provideCompletions=function(r,e,t){var s=(function(g){var b=g.prefix,w=g.matches;this.completions=new i(w),e.exactMatch&&(this.completions.exactMatch=!0),e.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(b),(g.finished||this.completions.filtered.length)&&t(null,this.completions,g.finished)}).bind(this),c=!0,p=null;this.gatherCompletions(r,(function(g,b){this.active&&(g&&(t(g,[],!0),this.detach()),b.prefix.indexOf(b.prefix)===0)&&(c?p=b:s(b))}).bind(this)),c=!1,p&&(r=p,p=null,s(r))},o.prototype.detach=function(){this.active=!1,this.completers&&this.completers.forEach(function(r){typeof r.cancel=="function"&&r.cancel()})};var n=o;function o(r){this.initialPosition=r,this.active=!0}a.prototype.setFilter=function(r){e=r.length>this.filterText&&r.lastIndexOf(this.filterText,0)===0?this.filtered:this.all,this.filterText=r,e=(e=this.filterCompletions(e,this.filterText)).sort(function(s,c){return c.exactMatch-s.exactMatch||c.$score-s.$score||(s.caption||s.value).localeCompare(c.caption||c.value)});var e,t=null;e=e.filter(function(s){return s=s.snippet||s.caption||s.value,s!==t&&(t=s,!0)}),this.filtered=e},a.prototype.filterCompletions=function(r,e){var t=[],s=e.toUpperCase(),c=e.toLowerCase();e:for(var p,g=0;p=r[g];g++){var b=!this.ignoreCaption&&p.caption||p.value||p.snippet;if(b){var w=-1,E=0,W=0;if(this.exactMatch){if(e!==b.substr(0,e.length))continue}else{var B=b.toLowerCase().indexOf(c);if(-1<B)W=B;else for(var O=0;O<e.length;O++){var x=b.indexOf(c[O],w+1),u=b.indexOf(s[O],w+1);if((x=0<=x&&(u<0||x<u)?x:u)<0)continue e;0<(u=x-w-1)&&(w===-1&&(W+=10),W+=u,E|=1<<O),w=x}}p.matchMask=E,p.exactMatch=W?0:1,p.$score=(p.score||0)-W,t.push(p)}}return t};var i=a;function a(r,e){this.all=r,this.filtered=r,this.filterText=e||"",this.exactMatch=!1,this.ignoreCaption=!1}k.Autocomplete=h,k.CompletionProvider=n,k.FilteredList=i}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(U,k,H){var j=U("../range").Range,z=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;function Y(G,N){var A=G.getTextRange(j.fromPoints({row:0,column:0},N)).split(z).length-1,f=G.getValue().split(z),R=Object.create(null),y=f[A];return f.forEach(function(C,d){C&&C!==y&&(d=Math.abs(A-d),d=f.length-d,R[C]?R[C]=Math.max(d,R[C]):R[C]=d)}),R}k.getCompletions=function(G,N,A,f,R){var y=Y(N,A);R(null,Object.keys(y).map(function(C){return{caption:C,value:C,score:y[C],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(U,k,H){function j(r,e){l(e.session.$mode)}function z(r){var e=r.editor,t=e.completer&&e.completer.activated;r.command.name==="backspace"?t&&!R.getCompletionPrefix(e)&&e.completer.detach():r.command.name!=="insertstring"||t||((e=(Y=r).editor.$liveAutocompletionDelay)?o.delay(e):i(r))}var Y,G=U("../snippets").snippetManager,N=U("../autocomplete").Autocomplete,A=U("../config"),f=U("../lib/lang"),R=U("../autocomplete/util"),a=U("../autocomplete/text_completer"),y={getCompletions:function(r,e,t,s,c){if(e.$mode.completer)return e.$mode.completer.getCompletions(r,e,t,s,c);r=r.session.getState(t.row),c(null,e.$mode.getCompletions(r,e,t,s).map(function(p){return p.completerId=y.id,p}))},id:"keywordCompleter"},C={getCompletions:function(r,g,t,s,c){var p=[],g=g.getTokenAt(t.row,t.column),b=(g&&g.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?p.push("html-tag"):p=G.getActiveScopes(r),G.snippetMap),w=[];p.forEach(function(E){for(var W=b[E]||[],B=W.length;B--;){var O=W[B],x=O.name||O.tabTrigger;x&&w.push({caption:x,snippet:O.content,meta:O.tabTrigger&&!O.name?O.tabTrigger+"⇥ ":"snippet",completerId:C.id})}},this),c(null,w)},getDocTooltip:function(r){var e;r.snippet&&!r.docHTML&&(r.docHTML=["<b>",f.escapeHTML(r.caption),"</b>","<hr></hr>",f.escapeHTML((r=r.snippet,e={},r.replace(/\${(\d+)(:(.*?))?}/g,function(t,s,c,p){return e[s]=p||""}).replace(/\$(\d+?)/g,function(t,s){return e[s]})))].join(""))},id:"snippetCompleter"},d=[C,a,y],h=(k.setCompleters=function(r){d.length=0,r&&d.push.apply(d,r)},k.addCompleter=function(r){d.push(r)},k.textCompleter=a,k.keyWordCompleter=y,k.snippetCompleter=C,{name:"expandSnippet",exec:function(r){return G.expandWithTab(r)},bindKey:"Tab"}),l=function(r){(r=typeof r=="string"?A.$modes[r]:r)&&(G.files||(G.files={}),n(r.$id,r.snippetFileId),r.modes)&&r.modes.forEach(l)},n=function(r,e){e&&r&&!G.files[r]&&(G.files[r]={},A.loadModule(e,function(t){t&&(!(G.files[r]=t).snippets&&t.snippetText&&(t.snippets=G.parseSnippetFile(t.snippetText)),G.register(t.snippets||[],t.scope),t.includeScopes)&&(G.snippetMap[t.scope].includeScopes=t.includeScopes,t.includeScopes.forEach(function(s){l("ace/mode/"+s)}))}))},o=f.delayedCall(function(){i(Y)},0),i=function(e){var e=e.editor,t=R.getCompletionPrefix(e),s=R.triggerAutocomplete(e);(t&&t.length>=e.$liveAutocompletionThreshold||s)&&((t=N.for(e)).autoShown=!0,t.showPopup(e))},a=U("../editor").Editor;U("../config").defineOptions(a.prototype,"editor",{enableBasicAutocompletion:{set:function(r){r?(this.completers||(this.completers=Array.isArray(r)?r:d),this.commands.addCommand(N.startCommand)):this.commands.removeCommand(N.startCommand)},value:!1},enableLiveAutocompletion:{set:function(r){r?(this.completers||(this.completers=Array.isArray(r)?r:d),this.commands.on("afterExec",z)):this.commands.off("afterExec",z)},value:!1},liveAutocompletionDelay:{initialValue:0},liveAutocompletionThreshold:{initialValue:0},enableSnippets:{set:function(r){r?(this.commands.addCommand(h),this.on("changeMode",j),j(0,this)):(this.commands.removeCommand(h),this.off("changeMode",j))},value:!1}})}),ace.require(["ace/ext/language_tools"],function(U){le&&(le.exports=U)})},3330:function(le,m,D){le=D.nmd(le),ace.define("ace/ext/searchbox-css",["require","exports","module"],function(U,k,H){H.exports=`

/* ------------------------------------------------------------------------------------------
 * Editor Search Form
 * --------------------------------------------------------------------------------------- */
.ace_search {
    background-color: #ddd;
    color: #666;
    border: 1px solid #cbcbcb;
    border-top: 0 none;
    overflow: hidden;
    margin: 0;
    padding: 4px 6px 0 4px;
    position: absolute;
    top: 0;
    z-index: 99;
    white-space: normal;
}
.ace_search.left {
    border-left: 0 none;
    border-radius: 0px 0px 5px 0px;
    left: 0;
}
.ace_search.right {
    border-radius: 0px 0px 0px 5px;
    border-right: 0 none;
    right: 0;
}

.ace_search_form, .ace_replace_form {
    margin: 0 20px 4px 0;
    overflow: hidden;
    line-height: 1.9;
}
.ace_replace_form {
    margin-right: 0;
}
.ace_search_form.ace_nomatch {
    outline: 1px solid red;
}

.ace_search_field {
    border-radius: 3px 0 0 3px;
    background-color: white;
    color: black;
    border: 1px solid #cbcbcb;
    border-right: 0 none;
    outline: 0;
    padding: 0;
    font-size: inherit;
    margin: 0;
    line-height: inherit;
    padding: 0 6px;
    min-width: 17em;
    vertical-align: top;
    min-height: 1.8em;
    box-sizing: content-box;
}
.ace_searchbtn {
    border: 1px solid #cbcbcb;
    line-height: inherit;
    display: inline-block;
    padding: 0 6px;
    background: #fff;
    border-right: 0 none;
    border-left: 1px solid #dcdcdc;
    cursor: pointer;
    margin: 0;
    position: relative;
    color: #666;
}
.ace_searchbtn:last-child {
    border-radius: 0 3px 3px 0;
    border-right: 1px solid #cbcbcb;
}
.ace_searchbtn:disabled {
    background: none;
    cursor: default;
}
.ace_searchbtn:hover {
    background-color: #eef1f6;
}
.ace_searchbtn.prev, .ace_searchbtn.next {
     padding: 0px 0.7em
}
.ace_searchbtn.prev:after, .ace_searchbtn.next:after {
     content: "";
     border: solid 2px #888;
     width: 0.5em;
     height: 0.5em;
     border-width:  2px 0 0 2px;
     display:inline-block;
     transform: rotate(-45deg);
}
.ace_searchbtn.next:after {
     border-width: 0 2px 2px 0 ;
}
.ace_searchbtn_close {
    background: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA4AAAAcCAYAAABRVo5BAAAAZ0lEQVR42u2SUQrAMAhDvazn8OjZBilCkYVVxiis8H4CT0VrAJb4WHT3C5xU2a2IQZXJjiQIRMdkEoJ5Q2yMqpfDIo+XY4k6h+YXOyKqTIj5REaxloNAd0xiKmAtsTHqW8sR2W5f7gCu5nWFUpVjZwAAAABJRU5ErkJggg==) no-repeat 50% 0;
    border-radius: 50%;
    border: 0 none;
    color: #656565;
    cursor: pointer;
    font: 16px/16px Arial;
    padding: 0;
    height: 14px;
    width: 14px;
    top: 9px;
    right: 7px;
    position: absolute;
}
.ace_searchbtn_close:hover {
    background-color: #656565;
    background-position: 50% 100%;
    color: white;
}

.ace_button {
    margin-left: 2px;
    cursor: pointer;
    -webkit-user-select: none;
    -moz-user-select: none;
    -o-user-select: none;
    -ms-user-select: none;
    user-select: none;
    overflow: hidden;
    opacity: 0.7;
    border: 1px solid rgba(100,100,100,0.23);
    padding: 1px;
    box-sizing:    border-box!important;
    color: black;
}

.ace_button:hover {
    background-color: #eee;
    opacity:1;
}
.ace_button:active {
    background-color: #ddd;
}

.ace_button.checked {
    border-color: #3399ff;
    opacity:1;
}

.ace_search_options{
    margin-bottom: 3px;
    text-align: right;
    -webkit-user-select: none;
    -moz-user-select: none;
    -o-user-select: none;
    -ms-user-select: none;
    user-select: none;
    clear: both;
}

.ace_search_counter {
    float: left;
    font-family: arial;
    padding: 0 8px;
}`}),ace.define("ace/ext/searchbox",["require","exports","module","ace/lib/dom","ace/lib/lang","ace/lib/event","ace/ext/searchbox-css","ace/keyboard/hash_handler","ace/lib/keys","ace/config"],function(U,k,H){var j=U("../lib/dom"),z=U("../lib/lang"),Y=U("../lib/event"),G=U("./searchbox-css"),N=U("../keyboard/hash_handler").HashHandler,A=U("../lib/keys"),f=U("../config").nls,R=(j.importCssString(G,"ace_searchbox",!1),y.prototype.setEditor=function(C){C.searchBox=this,C.renderer.scroller.appendChild(this.element),this.editor=C},y.prototype.setSession=function(C){this.searchRange=null,this.$syncOptions(!0)},y.prototype.$initElements=function(C){this.searchBox=C.querySelector(".ace_search_form"),this.replaceBox=C.querySelector(".ace_replace_form"),this.searchOption=C.querySelector("[action=searchInSelection]"),this.replaceOption=C.querySelector("[action=toggleReplace]"),this.regExpOption=C.querySelector("[action=toggleRegexpMode]"),this.caseSensitiveOption=C.querySelector("[action=toggleCaseSensitive]"),this.wholeWordOption=C.querySelector("[action=toggleWholeWords]"),this.searchInput=this.searchBox.querySelector(".ace_search_field"),this.replaceInput=this.replaceBox.querySelector(".ace_search_field"),this.searchCounter=C.querySelector(".ace_search_counter")},y.prototype.$init=function(){var C=this.element,d=(this.$initElements(C),this);Y.addListener(C,"mousedown",function(h){setTimeout(function(){d.activeInput.focus()},0),Y.stopPropagation(h)}),Y.addListener(C,"click",function(h){var l=(h.target||h.srcElement).getAttribute("action");l&&d[l]?d[l]():d.$searchBarKb.commands[l]&&d.$searchBarKb.commands[l].exec(d),Y.stopPropagation(h)}),Y.addCommandKeyListener(C,function(h,l,n){n=A.keyCodeToString(n),l=d.$searchBarKb.findKeyCommand(l,n),l&&l.exec&&(l.exec(d),Y.stopEvent(h))}),this.$onChange=z.delayedCall(function(){d.find(!1,!1)}),Y.addListener(this.searchInput,"input",function(){d.$onChange.schedule(20)}),Y.addListener(this.searchInput,"focus",function(){d.activeInput=d.searchInput,d.searchInput.value&&d.highlight()}),Y.addListener(this.replaceInput,"focus",function(){d.activeInput=d.replaceInput,d.searchInput.value&&d.highlight()})},y.prototype.setSearchRange=function(C){(this.searchRange=C)?this.searchRangeMarker=this.editor.session.addMarker(C,"ace_active-line"):this.searchRangeMarker&&(this.editor.session.removeMarker(this.searchRangeMarker),this.searchRangeMarker=null)},y.prototype.$syncOptions=function(C){j.setCssClass(this.replaceOption,"checked",this.searchRange),j.setCssClass(this.searchOption,"checked",this.searchOption.checked),this.replaceOption.textContent=this.replaceOption.checked?"-":"+",j.setCssClass(this.regExpOption,"checked",this.regExpOption.checked),j.setCssClass(this.wholeWordOption,"checked",this.wholeWordOption.checked),j.setCssClass(this.caseSensitiveOption,"checked",this.caseSensitiveOption.checked);var d=this.editor.getReadOnly();this.replaceOption.style.display=d?"none":"",this.replaceBox.style.display=this.replaceOption.checked&&!d?"":"none",this.find(!1,!1,C)},y.prototype.highlight=function(C){this.editor.session.highlight(C||this.editor.$search.$options.re),this.editor.renderer.updateBackMarkers()},y.prototype.find=function(C,d,h){C=!this.editor.find(this.searchInput.value,{skipCurrent:C,backwards:d,wrap:!0,regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked,preventScroll:h,range:this.searchRange})&&this.searchInput.value,j.setCssClass(this.searchBox,"ace_nomatch",C),this.editor._emit("findSearchBox",{match:!C}),this.highlight(),this.updateCounter()},y.prototype.updateCounter=function(){var C=this.editor,d=C.$search.$options.re,h=0,l=0;if(d){var n,o,i=this.searchRange?C.session.getTextRange(this.searchRange):C.getValue(),a=C.session.doc.positionToIndex(C.selection.anchor);for(this.searchRange&&(a-=C.session.doc.positionToIndex(this.searchRange.start)),d.lastIndex=0;(o=d.exec(i))&&((n=o.index)<=a&&l++,!(999<++h))&&(o[0]||(d.lastIndex=n+=1,!(n>=i.length))););}this.searchCounter.textContent=f("$0 of $1",[l,999<h?"999+":h])},y.prototype.findNext=function(){this.find(!0,!1)},y.prototype.findPrev=function(){this.find(!0,!0)},y.prototype.findAll=function(){var C=!this.editor.findAll(this.searchInput.value,{regExp:this.regExpOption.checked,caseSensitive:this.caseSensitiveOption.checked,wholeWord:this.wholeWordOption.checked})&&this.searchInput.value;j.setCssClass(this.searchBox,"ace_nomatch",C),this.editor._emit("findSearchBox",{match:!C}),this.highlight(),this.hide()},y.prototype.replace=function(){this.editor.getReadOnly()||this.editor.replace(this.replaceInput.value)},y.prototype.replaceAndFindNext=function(){this.editor.getReadOnly()||(this.editor.replace(this.replaceInput.value),this.findNext())},y.prototype.replaceAll=function(){this.editor.getReadOnly()||this.editor.replaceAll(this.replaceInput.value)},y.prototype.hide=function(){this.active=!1,this.setSearchRange(null),this.editor.off("changeSession",this.setSession),this.element.style.display="none",this.editor.keyBinding.removeKeyboardHandler(this.$closeSearchBarKb),this.editor.focus()},y.prototype.show=function(C,d){this.active=!0,this.editor.on("changeSession",this.setSession),this.element.style.display="",this.replaceOption.checked=d,C&&(this.searchInput.value=C),this.searchInput.focus(),this.searchInput.select(),this.editor.keyBinding.addKeyboardHandler(this.$closeSearchBarKb),this.$syncOptions(!0)},y.prototype.isFocused=function(){var C=document.activeElement;return C==this.searchInput||C==this.replaceInput},y);function y(C,d,h){var l=j.createElement("div");j.buildDom(["div",{class:"ace_search right"},["span",{action:"hide",class:"ace_searchbtn_close"}],["div",{class:"ace_search_form"},["input",{class:"ace_search_field",placeholder:f("Search for"),spellcheck:"false"}],["span",{action:"findPrev",class:"ace_searchbtn prev"},"​"],["span",{action:"findNext",class:"ace_searchbtn next"},"​"],["span",{action:"findAll",class:"ace_searchbtn",title:"Alt-Enter"},f("All")]],["div",{class:"ace_replace_form"},["input",{class:"ace_search_field",placeholder:f("Replace with"),spellcheck:"false"}],["span",{action:"replaceAndFindNext",class:"ace_searchbtn"},f("Replace")],["span",{action:"replaceAll",class:"ace_searchbtn"},f("All")]],["div",{class:"ace_search_options"},["span",{action:"toggleReplace",class:"ace_button",title:f("Toggle Replace mode"),style:"float:left;margin-top:-2px;padding:0 5px;"},"+"],["span",{class:"ace_search_counter"}],["span",{action:"toggleRegexpMode",class:"ace_button",title:f("RegExp Search")},".*"],["span",{action:"toggleCaseSensitive",class:"ace_button",title:f("CaseSensitive Search")},"Aa"],["span",{action:"toggleWholeWords",class:"ace_button",title:f("Whole Word Search")},"\\b"],["span",{action:"searchInSelection",class:"ace_button",title:f("Search In Selection")},"S"]]],l),this.element=l.firstChild,this.setSession=this.setSession.bind(this),this.$init(),this.setEditor(C),j.importCssString(G,"ace_searchbox",C.container)}U=new N,U.bindKeys({"Ctrl-f|Command-f":function(C){var d=C.isReplace=!C.isReplace;C.replaceBox.style.display=d?"":"none",C.replaceOption.checked=!1,C.$syncOptions(),C.searchInput.focus()},"Ctrl-H|Command-Option-F":function(C){C.editor.getReadOnly()||(C.replaceOption.checked=!0,C.$syncOptions(),C.replaceInput.focus())},"Ctrl-G|Command-G":function(C){C.findNext()},"Ctrl-Shift-G|Command-Shift-G":function(C){C.findPrev()},esc:function(C){setTimeout(function(){C.hide()})},Return:function(C){C.activeInput==C.replaceInput&&C.replace(),C.findNext()},"Shift-Return":function(C){C.activeInput==C.replaceInput&&C.replace(),C.findPrev()},"Alt-Return":function(C){C.activeInput==C.replaceInput&&C.replaceAll(),C.findAll()},Tab:function(C){(C.activeInput==C.replaceInput?C.searchInput:C.replaceInput).focus()}}),U.addCommands([{name:"toggleRegexpMode",bindKey:{win:"Alt-R|Alt-/",mac:"Ctrl-Alt-R|Ctrl-Alt-/"},exec:function(C){C.regExpOption.checked=!C.regExpOption.checked,C.$syncOptions()}},{name:"toggleCaseSensitive",bindKey:{win:"Alt-C|Alt-I",mac:"Ctrl-Alt-R|Ctrl-Alt-I"},exec:function(C){C.caseSensitiveOption.checked=!C.caseSensitiveOption.checked,C.$syncOptions()}},{name:"toggleWholeWords",bindKey:{win:"Alt-B|Alt-W",mac:"Ctrl-Alt-B|Ctrl-Alt-W"},exec:function(C){C.wholeWordOption.checked=!C.wholeWordOption.checked,C.$syncOptions()}},{name:"toggleReplace",exec:function(C){C.replaceOption.checked=!C.replaceOption.checked,C.$syncOptions()}},{name:"searchInSelection",exec:function(C){C.searchOption.checked=!C.searchRange,C.setSearchRange(C.searchOption.checked&&C.editor.getSelectionRange()),C.$syncOptions()}}]),N=new N([{bindKey:"Esc",name:"closeSearchBar",exec:function(C){C.searchBox.hide()}}]),R.prototype.$searchBarKb=U,R.prototype.$closeSearchBarKb=N,k.SearchBox=R,k.Search=function(C,d){(C.searchBox||new R(C)).show(C.session.getTextRange(),d)}}),ace.require(["ace/ext/searchbox"],function(U){le&&(le.exports=U)})},4091:function(le,m,D){le=D.nmd(le),ace.define("ace/mode/json_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(Y,k,H){function j(){this.$rules={start:[{token:"variable",regex:'["](?:(?:\\\\.)|(?:[^"\\\\]))*?["]\\s*(?=:)'},{token:"string",regex:'"',next:"string"},{token:"constant.numeric",regex:"0[xX][0-9a-fA-F]+\\b"},{token:"constant.numeric",regex:"[+-]?\\d+(?:(?:\\.\\d*)?(?:[eE][+-]?\\d+)?)?\\b"},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"text",regex:"['](?:(?:\\\\.)|(?:[^'\\\\]))*?[']"},{token:"comment",regex:"\\/\\/.*$"},{token:"comment.start",regex:"\\/\\*",next:"comment"},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"punctuation.operator",regex:/[,]/},{token:"text",regex:"\\s+"}],string:[{token:"constant.language.escape",regex:/\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|["\\\/bfnrt])/},{token:"string",regex:'"|$',next:"start"},{defaultToken:"string"}],comment:[{token:"comment.end",regex:"\\*\\/",next:"start"},{defaultToken:"comment"}]}}var z=Y("../lib/oop"),Y=Y("./text_highlight_rules").TextHighlightRules;z.inherits(j,Y),k.JsonHighlightRules=j}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(U,k,H){function j(){}var z=U("../range").Range;(function(){this.checkOutdent=function(Y,G){return!!/^\s+$/.test(Y)&&/^\s*\}/.test(G)},this.autoOutdent=function(Y,G){var N,A=Y.getLine(G).match(/^(\s*\})/);return A&&(A=A[1].length,N=Y.findMatchingBracket({row:G,column:A}))&&N.row!=G?(N=this.$getIndent(Y.getLine(N.row)),void Y.replace(new z(G,0,G,A-1),N)):0},this.$getIndent=function(Y){return Y.match(/^\s*/)[0]}}).call(j.prototype),k.MatchingBraceOutdent=j}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(Y,G,H){var j=Y("../../lib/oop"),z=Y("../../range").Range,Y=Y("./fold_mode").FoldMode,G=G.FoldMode=function(N){N&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+N.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+N.end)))};j.inherits(G,Y),(function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(N,A,f){var R=N.getLine(f);return!this.singleLineBlockCommentRe.test(R)||this.startRegionRe.test(R)||this.tripleStarBlockCommentRe.test(R)?!(N=this._getFoldWidgetBase(N,A,f))&&this.startRegionRe.test(R)?"start":N:""},this.getFoldWidgetRange=function(N,A,f,R){var y,C,d,h=N.getLine(f);return this.startRegionRe.test(h)?this.getCommentRegionBlock(N,h,f):(C=h.match(this.foldingStartMarker))?(d=C.index,C[1]?this.openingBracketBlock(N,C[1],f,d):((y=N.getCommentFoldRange(f,d+C[0].length,1))&&!y.isMultiLine()&&(R?y=this.getSectionRange(N,f):A!="all"&&(y=null)),y)):A!=="markbegin"&&(C=h.match(this.foldingStopMarker))?(d=C.index+C[0].length,C[1]?this.closingBracketBlock(N,C[1],f,d):N.getCommentFoldRange(f,d,-1)):void 0},this.getSectionRange=function(N,A){for(var f=(h=N.getLine(A)).search(/\S/),R=A,y=h.length,C=A+=1,d=N.getLength();++A<d;){var h,l=(h=N.getLine(A)).search(/\S/);if(l!==-1){if(l<f)break;var n=this.getFoldWidgetRange(N,"all",A);if(n){if(n.start.row<=R)break;if(n.isMultiLine())A=n.end.row;else if(f==l)break}C=A}}return new z(R,y,C,N.getLine(C).length)},this.getCommentRegionBlock=function(N,A,f){for(var R=A.search(/\s*$/),y=N.getLength(),C=f,d=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,h=1;++f<y;){A=N.getLine(f);var l=d.exec(A);if(l&&(l[1]?h--:h++,!h))break}if(C<f)return new z(C,R,f,A.length)}}).call(G.prototype)}),ace.define("ace/mode/json",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/json_highlight_rules","ace/mode/matching_brace_outdent","ace/mode/folding/cstyle","ace/worker/worker_client"],function(U,k,H){function j(){this.HighlightRules=G,this.$outdent=new N,this.$behaviour=this.$defaultBehaviour,this.foldingRules=new A}var z=U("../lib/oop"),Y=U("./text").Mode,G=U("./json_highlight_rules").JsonHighlightRules,N=U("./matching_brace_outdent").MatchingBraceOutdent,A=U("./folding/cstyle").FoldMode,f=U("../worker/worker_client").WorkerClient;z.inherits(j,Y),(function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(R,y,C){var d=this.$getIndent(y);return R=="start"&&y.match(/^.*[\{\(\[]\s*$/)&&(d+=C),d},this.checkOutdent=function(R,y,C){return this.$outdent.checkOutdent(y,C)},this.autoOutdent=function(R,y,C){this.$outdent.autoOutdent(y,C)},this.createWorker=function(R){var y=new f(["ace"],"ace/mode/json_worker","JsonWorker");return y.attachToDocument(R.getDocument()),y.on("annotate",function(C){R.setAnnotations(C.data)}),y.on("terminate",function(){R.clearAnnotations()}),y},this.$id="ace/mode/json"}).call(j.prototype),k.Mode=j}),ace.require(["ace/mode/json"],function(U){le&&(le.exports=U)})},8903:function(f,m,D){var U=D(5689),k=D(3969),H=D(5255),j=D(4293),z=D(3508),Y=D(3368),G=D(742),N=D(9394),A=D(3724),f=((f.exports=d).prototype.validate=function(e,t){var s;if(typeof e=="string"){if(!(s=this.getSchema(e)))throw new Error('no schema with key or ref "'+e+'"')}else e=this._addSchema(e),s=e.validate||this._compile(e);return e=s(t),s.$async!==!0&&(this.errors=s.errors),e},d.prototype.compile=function(e,t){return e=this._addSchema(e,void 0,t),e.validate||this._compile(e)},d.prototype.addSchema=function(e,t,s,c){if(Array.isArray(e))for(var p=0;p<e.length;p++)this.addSchema(e[p],void 0,s,c);else{var g=this._getId(e);if(g!==void 0&&typeof g!="string")throw new Error("schema id must be string");a(this,t=k.normalizeId(t||g)),this._schemas[t]=this._addSchema(e,s,c,!0)}return this},d.prototype.addMetaSchema=function(e,t,s){return this.addSchema(e,t,s,!0),this},d.prototype.validateSchema=function(e,t){var s=e.$schema;if(s!==void 0&&typeof s!="string")throw new Error("$schema must be a string");if(!(s=s||this._opts.defaultMeta||function(c){var p=c._opts.meta;return c._opts.defaultMeta=typeof p=="object"?c._getId(p)||p:c.getSchema(R)?R:void 0,c._opts.defaultMeta}(this)))return this.logger.warn("meta-schema not available"),!(this.errors=null);if(s=this.validate(s,e),!s&&t){if(e="schema is invalid: "+this.errorsText(),this._opts.validateSchema!="log")throw new Error(e);this.logger.error(e)}return s},d.prototype.getSchema=function(e){var t=h(this,e);switch(typeof t){case"object":return t.validate||this._compile(t);case"string":return this.getSchema(t);case"undefined":return function(s,c){var p=k.schema.call(s,{schema:{}},c);{var g,b,w;if(p)return g=p.schema,b=p.root,p=p.baseId,w=U.call(s,g,b,void 0,p),s._fragments[c]=new j({ref:c,fragment:!0,schema:g,root:b,baseId:p,validate:w}),w}}(this,e)}},d.prototype.removeSchema=function(e){if(e instanceof RegExp)l(this,this._schemas,e),l(this,this._refs,e);else switch(typeof e){case"undefined":return l(this,this._schemas),l(this,this._refs),this._cache.clear(),this;case"string":var t=h(this,e);return t&&this._cache.del(t.cacheKey),delete this._schemas[e],delete this._refs[e],this;case"object":t=this._opts.serialize,t=t?t(e):e,t=(this._cache.del(t),this._getId(e)),t&&(t=k.normalizeId(t),delete this._schemas[t],delete this._refs[t])}return this},d.prototype.addFormat=function(e,t){return typeof t=="string"&&(t=new RegExp(t)),this._formats[e]=t,this},d.prototype.errorsText=function(e,t){if(!(e=e||this.errors))return"No errors";for(var s=(t=t||{}).separator===void 0?", ":t.separator,c=t.dataVar===void 0?"data":t.dataVar,p="",g=0;g<e.length;g++){var b=e[g];b&&(p+=c+b.dataPath+" "+b.message+s)}return p.slice(0,-s.length)},d.prototype._addSchema=function(e,w,s,c){if(typeof e!="object"&&typeof e!="boolean")throw new Error("schema should be object or boolean");var p=this._opts.serialize,p=p?p(e):e,g=this._cache.get(p);if(g)return g;c=c||this._opts.addUsedSchema!==!1,g=k.normalizeId(this._getId(e)),g&&c&&a(this,g);var b,w=this._opts.validateSchema!==!1&&!w;w&&!(b=g&&g==k.normalizeId(e.$schema))&&this.validateSchema(e,!0);var E=k.ids.call(this,e),E=new j({id:g,schema:e,localRefs:E,cacheKey:p,meta:s});return g[0]!="#"&&c&&(this._refs[g]=E),this._cache.put(p,E),w&&b&&this.validateSchema(e,!0),E},d.prototype._compile=function(e,t){if(e.compiling)return(e.validate=p).schema=e.schema,p.errors=null,p.root=t||p,e.schema.$async===!0&&(p.$async=!0),p;var s,c;e.compiling=!0,e.meta&&(s=this._opts,this._opts=this._metaOpts);try{c=U.call(this,e.schema,t,e.localRefs)}catch(g){throw delete e.validate,g}finally{e.compiling=!1,e.meta&&(this._opts=s)}return e.validate=c,e.refs=c.refs,e.refVal=c.refVal,e.root=c.root,c;function p(){var g=e.validate,b=g.apply(this,arguments);return p.errors=g.errors,b}},d.prototype.compileAsync=D(9677),D(7931)),f=(d.prototype.addKeyword=f.add,d.prototype.getKeyword=f.get,d.prototype.removeKeyword=f.remove,d.prototype.validateKeyword=f.validate,D(5359)),R=(d.ValidationError=f.Validation,d.MissingRefError=f.MissingRef,d.$dataMetaSchema=N,"http://json-schema.org/draft-07/schema"),y=["removeAdditional","useDefaults","coerceTypes","strictDefaults"],C=["/properties"];function d(e){if(!(this instanceof d))return new d(e);e=this._opts=A.copy(e)||{};var W=this,t=W._opts.logger;if(t===!1)W.logger={log:r,warn:r,error:r};else{if(!(typeof(t=t===void 0?console:t)=="object"&&t.log&&t.warn&&t.error))throw new Error("logger must implement log, warn and error methods");W.logger=t}if(this._schemas={},this._refs={},this._fragments={},this._formats=Y(e.format),this._cache=e.cache||new H,this._loadingSchemas={},this._compilations=[],this.RULES=G(),this._getId=function(u){switch(u.schemaId){case"auto":return i;case"id":return n;default:return o}}(e),e.loopRequired=e.loopRequired||1/0,e.errorDataPath=="property"&&(e._errorDataPathProperty=!0),e.serialize===void 0&&(e.serialize=z),this._metaOpts=function(u){for(var _=A.copy(u._opts),v=0;v<y.length;v++)delete _[y[v]];return _}(this),e.formats){var s,c=this;for(s in c._opts.formats){var p=c._opts.formats[s];c.addFormat(s,p)}}if(e.keywords){var g,b=this;for(g in b._opts.keywords){var w=b._opts.keywords[g];b.addKeyword(g,w)}}var E,W=this,B=(W._opts.$data&&(E=D(894),W.addMetaSchema(E,E.$id,!0)),W._opts.meta!==!1&&(E=D(6680),W._opts.$data&&(E=N(E,C)),W.addMetaSchema(E,R,!0),W._refs["http://json-schema.org/schema"]=R),typeof e.meta=="object"&&this.addMetaSchema(e.meta),e.nullable&&this.addKeyword("nullable",{metaSchema:{type:"boolean"}}),this),O=B._opts.schemas;if(O)if(Array.isArray(O))B.addSchema(O);else for(var x in O)B.addSchema(O[x],x)}function h(e,t){return t=k.normalizeId(t),e._schemas[t]||e._refs[t]||e._fragments[t]}function l(e,t,s){for(var c in t){var p=t[c];p.meta||s&&!s.test(c)||(e._cache.del(p.cacheKey),delete t[c])}}function n(e){return e.$id&&this.logger.warn("schema $id ignored",e.$id),e.id}function o(e){return e.id&&this.logger.warn("schema id ignored",e.id),e.$id}function i(e){if(e.$id&&e.id&&e.$id!=e.id)throw new Error("schema $id is different from id");return e.$id||e.id}function a(e,t){if(e._schemas[t]||e._refs[t])throw new Error('schema with key or id "'+t+'" already exists')}function r(){}},5255:function(le){le=le.exports=function(){this._cache={}},le.prototype.put=function(m,D){this._cache[m]=D},le.prototype.get=function(m){return this._cache[m]},le.prototype.del=function(m){delete this._cache[m]},le.prototype.clear=function(){this._cache={}}},9677:function(le,m,D){var U=D(5359).MissingRef;function k(H,j,z){var Y=this;if(typeof this._opts.loadSchema!="function")throw new Error("options.loadSchema should be a function");typeof j=="function"&&(z=j,j=void 0);var G=N(H).then(function(){var A=Y._addSchema(H,void 0,j);return A.validate||function f(R){try{return Y._compile(R)}catch(C){if(C instanceof U)return y(C);throw C}function y(C){var d=C.missingSchema;if(l(d))throw new Error("Schema "+d+" is loaded but "+C.missingRef+" cannot be resolved");return C=Y._loadingSchemas[d],C||(C=Y._loadingSchemas[d]=Y._opts.loadSchema(d)).then(h,h),C.then(function(n){if(!l(d))return N(n).then(function(){l(d)||Y.addSchema(n,d,void 0,j)})}).then(function(){return f(R)});function h(){delete Y._loadingSchemas[d]}function l(n){return Y._refs[n]||Y._schemas[n]}}}(A)});return z&&G.then(function(A){z(null,A)},z),G;function N(A){return A=A.$schema,A&&!Y.getSchema(A)?k.call(Y,{$ref:A},!0):Promise.resolve()}}le.exports=k},5359:function(le,m,D){var U=D(3969);function k(j,z,Y){this.message=Y||k.message(j,z),this.missingRef=U.url(j,z),this.missingSchema=U.normalizeId(U.fullPath(this.missingRef))}function H(j){return j.prototype=Object.create(Error.prototype),j.prototype.constructor=j}le.exports={Validation:H(function(j){this.message="validation failed",this.errors=j,this.ajv=this.validation=!0}),MissingRef:H(k)},k.message=function(j,z){return"can't resolve reference "+z+" from id "+j}},3368:function(le,m,z){var U=z(3724),k=/^(\d\d\d\d)-(\d\d)-(\d\d)$/,H=[0,31,28,31,30,31,30,31,31,30,31,30,31],j=/^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i,z=/^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i,Y=/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,G=/^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i,N=/^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i,A=/^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i,f=/^(?:\/(?:[^~/]|~0|~1)*)*$/,R=/^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i,y=/^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;function C(a){return U.copy(C[a=a=="full"?"full":"fast"])}function d(t){var r,e,t=t.match(k);return!!t&&(r=+t[1],e=+t[2],t=+t[3],1<=e)&&e<=12&&1<=t&&t<=(e!=2||(t=r)%4!=0||t%100==0&&t%400!=0?H[e]:29)}function h(c,r){var e,t,s,c=c.match(j);return!!c&&(e=c[1],t=c[2],s=c[3],c=c[5],e<=23&&t<=59&&s<=59||e==23&&t==59&&s==60)&&(!r||c)}(le.exports=C).fast={date:/^\d\d\d\d-[0-1]\d-[0-3]\d$/,time:/^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,"date-time":/^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,uri:/^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,"uri-reference":/^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,"uri-template":G,url:N,email:/^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,hostname:z,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:i,uuid:A,"json-pointer":f,"json-pointer-uri-fragment":R,"relative-json-pointer":y},C.full={date:d,time:h,"date-time":function(a){return a=a.split(l),a.length==2&&d(a[0])&&h(a[1],!0)},uri:function(a){return n.test(a)&&Y.test(a)},"uri-reference":/^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i,"uri-template":G,url:N,email:/^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,hostname:z,ipv4:/^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,ipv6:/^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,regex:i,uuid:A,"json-pointer":f,"json-pointer-uri-fragment":R,"relative-json-pointer":y};var l=/t|\s/i,n=/\/|:/,o=/[^\\]\\Z/;function i(a){if(o.test(a))return!1;try{return new RegExp(a),!0}catch{return!1}}},5689:function(le,m,D){var U=D(3969),k=D(3724),H=D(5359),j=D(3508),z=D(1869),Y=k.ucs2length,G=D(2303),N=H.Validation;function A(l,n,o,i){var a=this,r=this._opts,e=[void 0],t={},s=[],c={},p=[],g={},b=[],w=(n=n||{schema:l,refVal:e,refs:t},(function(K,ne,T){var F=f.call(this,K,ne,T);return 0<=F?{index:F,compiling:!0}:(F=this._compilations.length,this._compilations[F]={schema:K,root:ne,baseId:T},{index:F,compiling:!1})}).call(this,l,n,i)),E=this._compilations[w.index];if(w.compiling)return E.callValidate=u;var W=this._formats,B=this.RULES;try{var O=_(l,n,o,i),x=(E.validate=O,E.callValidate);return x&&(x.schema=O.schema,x.errors=null,x.refs=O.refs,x.refVal=O.refVal,x.root=O.root,x.$async=O.$async,r.sourceCode)&&(x.source=O.source),O}finally{(function(K,ne,T){K=f.call(this,K,ne,T),0<=K&&this._compilations.splice(K,1)}).call(this,l,n,i)}function u(){var K=E.validate,ne=K.apply(this,arguments);return u.errors=K.errors,ne}function _(K,ne,T,F){var V=!ne||ne.schema==K;if(ne.schema!=n.schema)return A.call(a,K,ne,T,F);T=K.$async===!0,F=z({isTop:!0,schema:K,isRoot:V,baseId:F,root:ne,schemaPath:"",errSchemaPath:"#",errorPath:'""',MissingRefError:H.MissingRef,RULES:B,validate:z,util:k,resolve:U,resolveRef:v,usePattern:M,useDefault:X,useCustomRule:Q,opts:r,formats:W,logger:a.logger,self:a}),F=h(e,C)+h(s,R)+h(p,y)+h(b,d)+F,r.processCode&&(F=r.processCode(F,K));try{var I=new Function("self","RULES","formats","root","refVal","defaults","customRules","equal","ucs2length","ValidationError",F)(a,B,W,n,e,p,b,G,Y,N);e[0]=I}catch(S){throw a.logger.error("Error compiling schema, function code:",F),S}return I.schema=K,I.errors=null,I.refs=t,I.refVal=e,I.root=V?I:ne,T&&(I.$async=!0),r.sourceCode===!0&&(I.source={code:F,patterns:s,defaults:p}),I}function v(K,ne,S){ne=U.url(K,ne);var F=t[ne];if(F!==void 0)return P(V=e[F],I="refVal["+F+"]");if(!S&&n.refs&&(F=n.refs[ne],F!==void 0))return P(V=n.refVal[F],I=$(ne,V));var V,I=$(ne),S=U.call(a,_,n,ne);if((S=S===void 0&&(F=o&&o[ne])?U.inlineRef(F,r.inlineRefs)?F:A.call(a,F,n,o,K):S)!==void 0)return V=S,F=t[F=ne],e[F]=V,P(S,I);delete t[ne]}function $(K,ne){var T=e.length;return e[T]=ne,"refVal"+(t[K]=T)}function P(K,ne){return typeof K=="object"||typeof K=="boolean"?{code:ne,schema:K,inline:!0}:{code:ne,$async:K&&!!K.$async}}function M(K){var ne=c[K];return ne===void 0&&(ne=c[K]=s.length,s[ne]=K),"pattern"+ne}function X(K){switch(typeof K){case"boolean":case"number":return""+K;case"string":return k.toQuotedString(K);case"object":var ne,T;return K===null?"null":(ne=j(K),(T=g[ne])===void 0&&(T=g[ne]=p.length,p[T]=K),"default"+T)}}function Q(K,ne,T,F){if(a._opts.validateSchema!==!1){var I=K.definition.dependencies;if(I&&!I.every(function(J){return Object.prototype.hasOwnProperty.call(T,J)}))throw new Error("parent schema must have all required keywords: "+I.join(","));if(I=K.definition.validateSchema,I&&!I(ne)){if(I="keyword schema is invalid: "+a.errorsText(I.errors),a._opts.validateSchema!="log")throw new Error(I);a.logger.error(I)}}var V,I=K.definition.compile,S=K.definition.inline,L=K.definition.macro;if(I)V=I.call(a,ne,T,F);else if(L)V=L.call(a,ne,T,F),r.validateSchema!==!1&&a.validateSchema(V,!0);else if(S)V=S.call(a,F,K.keyword,ne,T);else if(!(V=K.definition.validate))return;if(V===void 0)throw new Error('custom keyword "'+K.keyword+'"failed to compile');return I=b.length,{code:"customRule"+I,validate:b[I]=V}}}function f(l,n,o){for(var i=0;i<this._compilations.length;i++){var a=this._compilations[i];if(a.schema==l&&a.root==n&&a.baseId==o)return i}return-1}function R(l,n){return"var pattern"+l+" = new RegExp("+k.toQuotedString(n[l])+");"}function y(l){return"var default"+l+" = defaults["+l+"];"}function C(l,n){return n[l]===void 0?"":"var refVal"+l+" = refVal["+l+"];"}function d(l){return"var customRule"+l+" = customRules["+l+"];"}function h(l,n){if(!l.length)return"";for(var o="",i=0;i<l.length;i++)o+=n(i,l);return o}le.exports=A},3969:function(le,m,D){var U=D(7533),k=D(2303),H=D(3724),j=D(4293),z=D(500);function Y(n,o,i){var a,r,e,t=this._refs[i];if(typeof t=="string"){if(!this._refs[t])return Y.call(this,n,o,t);t=this._refs[t]}return(t=t||this._schemas[i])instanceof j?R(t.schema,this._opts.inlineRefs)?t.schema:t.validate||this._compile(t):((t=G.call(this,o,i))&&(a=t.schema,o=t.root,e=t.baseId),a instanceof j?r=a.validate||n.call(this,a.schema,o,void 0,e):a!==void 0&&(r=R(a,this._opts.inlineRefs)?a:n.call(this,a,o,void 0,e)),r)}function G(n,o){var i=U.parse(o),a=C(i),r=y(this._getId(n.schema));if(Object.keys(n.schema).length===0||a!==r){var a=h(a),e=this._refs[a];if(typeof e=="string")return(function(s,c,p){c=G.call(this,s,c);{var g,b;if(c)return g=c.schema,b=c.baseId,s=c.root,(c=this._getId(g))&&(b=l(b,c)),A.call(this,p,b,g,s)}}).call(this,n,e,i);if(e instanceof j)e.validate||this._compile(e);else{if(!((e=this._schemas[a])instanceof j))return;if(e.validate||this._compile(e),a==h(o))return{schema:e,root:n,baseId:r}}if(!(n=e).schema)return;r=y(this._getId(n.schema))}return A.call(this,i,r,n.schema,n)}(le.exports=Y).normalizeId=h,Y.fullPath=y,Y.url=l,Y.ids=function(n){var o=h(this._getId(n)),i={"":o},a={"":y(o,!1)},r={},e=this;return z(n,{allKeys:!0},function(t,s,c,p,g,b,w){if(s!==""){var E=e._getId(t),W=i[p],p=a[p]+"/"+g;if(w!==void 0&&(p+="/"+(typeof w=="number"?w:H.escapeFragment(w))),typeof E=="string"){if(E=W=h(W?U.resolve(W,E):E),g=e._refs[E],(g=typeof g=="string"?e._refs[g]:g)&&g.schema){if(!k(t,g.schema))throw new Error('id "'+E+'" resolves to more than one schema')}else if(E!=h(p))if(E[0]=="#"){if(r[E]&&!k(t,r[E]))throw new Error('id "'+E+'" resolves to more than one schema');r[E]=t}else e._refs[E]=p}i[s]=W,a[s]=p}}),r},Y.inlineRef=R,Y.schema=G;var N=H.toHash(["properties","patternProperties","enum","dependencies","definitions"]);function A(n,o,i,a){if(n.fragment=n.fragment||"",n.fragment.slice(0,1)=="/"){for(var r=n.fragment.split("/"),e=1;e<r.length;e++){var t=r[e];if(t){if((i=i[t=H.unescapeFragment(t)])===void 0)break;N[t]||((t=this._getId(i))&&(o=l(o,t)),i.$ref&&(t=l(o,i.$ref),t=G.call(this,a,t))&&(i=t.schema,a=t.root,o=t.baseId))}}return i!==void 0&&i!==a.schema?{schema:i,root:a,baseId:o}:void 0}}var f=H.toHash(["type","format","pattern","maxLength","minLength","maxProperties","minProperties","maxItems","minItems","maximum","minimum","uniqueItems","multipleOf","required","enum"]);function R(n,o){return o!==!1&&(o===void 0||o===!0?function i(a){var r;if(Array.isArray(a)){for(var e=0;e<a.length;e++)if(typeof(r=a[e])=="object"&&!i(r))return!1}else for(var t in a)if(t=="$ref"||typeof(r=a[t])=="object"&&!i(r))return!1;return!0}(n):o?function i(a){var r,e=0;if(Array.isArray(a)){for(var t=0;t<a.length;t++)if(typeof(r=a[t])=="object"&&(e+=i(r)),e==1/0)return 1/0}else for(var s in a){if(s=="$ref")return 1/0;if(f[s])e++;else if(typeof(r=a[s])=="object"&&(e+=i(r)+1),e==1/0)return 1/0}return e}(n)<=o:void 0)}function y(n,o){return o!==!1&&(n=h(n)),C(U.parse(n))}function C(n){return U.serialize(n).split("#")[0]+"#"}var d=/#\/?$/;function h(n){return n?n.replace(d,""):""}function l(n,o){return o=h(o),U.resolve(n,o)}},742:function(le,m,D){var U=D(9646),k=D(3724).toHash;le.exports=function(){var H=[{type:"number",rules:[{maximum:["exclusiveMaximum"]},{minimum:["exclusiveMinimum"]},"multipleOf","format"]},{type:"string",rules:["maxLength","minLength","pattern","format"]},{type:"array",rules:["maxItems","minItems","items","contains","uniqueItems"]},{type:"object",rules:["maxProperties","minProperties","required","dependencies","propertyNames",{properties:["additionalProperties","patternProperties"]}]},{rules:["$ref","const","enum","not","anyOf","oneOf","allOf","if"]}],j=["type","$comment"];return H.all=k(j),H.types=k(["number","integer","string","array","object","boolean","null"]),H.forEach(function(z){z.rules=z.rules.map(function(Y){var G,N;return typeof Y=="object"&&(N=Y[G=Object.keys(Y)[0]],Y=G,N.forEach(function(A){j.push(A),H.all[A]=!0})),j.push(Y),H.all[Y]={keyword:Y,code:U[Y],implements:N}}),H.all.$comment={keyword:"$comment",code:U.$comment},z.type&&(H.types[z.type]=z)}),H.keywords=k(j.concat(["$schema","$id","id","$data","$async","title","description","default","definitions","examples","readOnly","writeOnly","contentMediaType","contentEncoding","additionalItems","then","else"])),H.custom={},H}},4293:function(le,m,D){var U=D(3724);le.exports=function(k){U.copy(k,this)}},6887:function(le){le.exports=function(m){for(var D,U=0,k=m.length,H=0;H<k;)U++,55296<=(D=m.charCodeAt(H++))&&D<=56319&&H<k&&(64512&m.charCodeAt(H))==56320&&H++;return U}},3724:function(le,m,D){function U(d,h,l,n){var o=n?" !== ":" === ",i=n?" || ":" && ",a=n?"!":"",r=n?"":"!";switch(d){case"null":return h+o+"null";case"array":return a+"Array.isArray("+h+")";case"object":return"("+a+h+i+"typeof "+h+o+'"object"'+i+r+"Array.isArray("+h+"))";case"integer":return"(typeof "+h+o+'"number"'+i+r+"("+h+" % 1)"+i+h+o+h+(l?i+a+"isFinite("+h+")":"")+")";case"number":return"(typeof "+h+o+'"'+d+'"'+(l?i+a+"isFinite("+h+")":"")+")";default:return"typeof "+h+o+'"'+d+'"'}}le.exports={copy:function(d,h){for(var l in h=h||{},d)h[l]=d[l];return h},checkDataType:U,checkDataTypes:function(d,h,l){{if(d.length===1)return U(d[0],h,l,!0);var n,o="",d=H(d);for(n in d.array&&d.object&&(o=d.null?"(":"(!"+h+" || ",o+="typeof "+h+' !== "object")',delete d.null,delete d.array,delete d.object),d.number&&delete d.integer,d)o+=(o?" && ":"")+U(n,h,l,!0);return o}},coerceToTypes:function(d,h){{if(!Array.isArray(h))return k[h]?[h]:d==="array"&&h==="array"?["array"]:void 0;for(var l=[],n=0;n<h.length;n++){var o=h[n];(k[o]||d==="array"&&o==="array")&&(l[l.length]=o)}return l.length?l:void 0}},toHash:H,getProperty:Y,escapeQuotes:G,equal:D(2303),ucs2length:D(6887),varOccurences:function(d,h){return h+="[^0-9]",d=d.match(new RegExp(h,"g")),d?d.length:0},varReplace:function(d,h,l){return h+="([^0-9])",l=l.replace(/\$/g,"$$$$"),d.replace(new RegExp(h,"g"),l+"$1")},schemaHasRules:function(d,h){if(typeof d=="boolean")return!d;for(var l in d)if(h[l])return!0},schemaHasRulesExcept:function(d,h,l){if(typeof d=="boolean")return!d&&l!="not";for(var n in d)if(n!=l&&h[n])return!0},schemaUnknownRules:function(d,h){if(typeof d!="boolean"){for(var l in d)if(!h[l])return l}},toQuotedString:N,getPathExpr:function(d,h,l,n){return R(d,l?"'/' + "+h+(n?"":".replace(/~/g, '~0').replace(/\\//g, '~1')"):n?"'[' + "+h+" + ']'":"'[\\'' + "+h+" + '\\']'")},getPath:function(d,h,l){return l=N(l?"/"+y(h):Y(h)),R(d,l)},getData:function(d,h,l){var n,o,i;if(d==="")return"rootData";if(d[0]=="/"){if(!A.test(d))throw new Error("Invalid JSON-pointer: "+d);n=d,o="rootData"}else{if(!(i=d.match(f)))throw new Error("Invalid JSON-pointer: "+d);if(d=+i[1],(n=i[2])=="#"){if(h<=d)throw new Error("Cannot access property/index "+d+" levels up, current level is "+h);return l[h-d]}if(h<d)throw new Error("Cannot access data "+d+" levels up, current level is "+h);if(o="data"+(h-d||""),!n)return o}for(var a=o,r=n.split("/"),e=0;e<r.length;e++){var t=r[e];t&&(o+=Y(C(t)),a+=" && "+o)}return a},unescapeFragment:function(d){return C(decodeURIComponent(d))},unescapeJsonPointer:C,escapeFragment:function(d){return encodeURIComponent(y(d))},escapeJsonPointer:y};var k=H(["string","number","integer","boolean","null"]);function H(d){for(var h={},l=0;l<d.length;l++)h[d[l]]=!0;return h}var j=/^[a-z$_][a-z$_0-9]*$/i,z=/'|\\/g;function Y(d){return typeof d=="number"?"["+d+"]":j.test(d)?"."+d:"['"+G(d)+"']"}function G(d){return d.replace(z,"\\$&").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\f/g,"\\f").replace(/\t/g,"\\t")}function N(d){return"'"+G(d)+"'"}var A=/^\/(?:[^~]|~0|~1)*$/,f=/^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;function R(d,h){return d=='""'?h:(d+" + "+h).replace(/([^\\])' \+ '/g,"$1")}function y(d){return d.replace(/~/g,"~0").replace(/\//g,"~1")}function C(d){return d.replace(/~1/g,"/").replace(/~0/g,"~")}},9394:function(le){var m=["multipleOf","maximum","exclusiveMaximum","minimum","exclusiveMinimum","maxLength","minLength","pattern","additionalItems","maxItems","minItems","uniqueItems","maxProperties","minProperties","required","additionalProperties","enum","format","const"];le.exports=function(D,U){for(var k=0;k<U.length;k++){D=JSON.parse(JSON.stringify(D));for(var H=U[k].split("/"),j=D,z=1;z<H.length;z++)j=j[H[z]];for(z=0;z<m.length;z++){var Y=m[z],G=j[Y];G&&(j[Y]={anyOf:[G,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]})}}return D}},5868:function(le,m,D){D=D(6680),le.exports={$id:"https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js",definitions:{simpleTypes:D.definitions.simpleTypes},type:"object",dependencies:{schema:["validate"],$data:["validate"],statements:["inline"],valid:{not:{required:["macro"]}}},properties:{type:D.properties.type,schema:{type:"boolean"},statements:{type:"boolean"},dependencies:{type:"array",items:{type:"string"}},metaSchema:{type:"object"},modifying:{type:"boolean"},valid:{type:"boolean"},$data:{type:"boolean"},async:{type:"boolean"},errors:{anyOf:[{type:"boolean"},{const:"full"}]}}}},1796:function(le){le.exports=function(m,D,U){var k,H,j,z,Y,G=" ",N=m.level,A=m.dataLevel,f=m.schema[D],R=m.schemaPath+m.util.getProperty(D),y=m.errSchemaPath+"/"+D,C=!m.opts.allErrors,d="data"+(A||""),h=m.opts.$data&&f&&f.$data,l=h?(G+=" var schema"+N+" = "+m.util.getData(f.$data,A,m.dataPathArr)+"; ","schema"+N):f,n=D=="maximum",o=n?"exclusiveMaximum":"exclusiveMinimum",i=m.schema[o],a=m.opts.$data&&i&&i.$data,r=n?"<":">",e=n?">":"<",t=void 0;if(!h&&typeof f!="number"&&f!==void 0)throw new Error(D+" must be number");if(!a&&i!==void 0&&typeof i!="number"&&typeof i!="boolean")throw new Error(o+" must be number or boolean");a?(A=m.util.getData(i.$data,A,m.dataPathArr),j="exclIsNumber"+N,z="' + "+(Y="op"+N)+" + '",t=o,(s=s||[]).push(G=G+(" var schemaExcl"+N+" = "+A+"; ")+(" var "+(k="exclusive"+N)+"; var "+(H="exclType"+N)+" = typeof "+(A="schemaExcl"+N)+"; if ("+H+" != 'boolean' && "+H+" != 'undefined' && "+H+" != 'number') { ")),G="",m.createErrors!==!1?(G+=" { keyword: '"+(t||"_exclusiveLimit")+"' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(y)+" , params: {} ",m.opts.messages!==!1&&(G+=" , message: '"+o+" should be boolean' "),m.opts.verbose&&(G+=" , schema: validate.schema"+R+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+d+" "),G+=" } "):G+=" {} ",c=G,G=s.pop(),!m.compositeRule&&C?m.async?G+=" throw new ValidationError(["+c+"]); ":G+=" validate.errors = ["+c+"]; return false; ":G+=" var err = "+c+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G+=" } else if ( ",h&&(G+=" ("+l+" !== undefined && typeof "+l+" != 'number') || "),G+=" "+H+" == 'number' ? ( ("+k+" = "+l+" === undefined || "+A+" "+r+"= "+l+") ? "+d+" "+e+"= "+A+" : "+d+" "+e+" "+l+" ) : ( ("+k+" = "+A+" === true) ? "+d+" "+e+"= "+l+" : "+d+" "+e+" "+l+" ) || "+d+" !== "+d+") { var op"+N+" = "+k+" ? '"+r+"' : '"+r+"='; ",f===void 0&&(y=m.errSchemaPath+"/"+(t=o),l=A,h=a)):(z=r,(j=typeof i=="number")&&h?(Y="'"+z+"'",G+=" if ( ",h&&(G+=" ("+l+" !== undefined && typeof "+l+" != 'number') || "),G+=" ( "+l+" === undefined || "+i+" "+r+"= "+l+" ? "+d+" "+e+"= "+i+" : "+d+" "+e+" "+l+" ) || "+d+" !== "+d+") { "):(j&&f===void 0?(k=!0,y=m.errSchemaPath+"/"+(t=o),l=i,e+="="):(j&&(l=Math[n?"min":"max"](i,f)),i===(!j||l)?(k=!0,y=m.errSchemaPath+"/"+(t=o),e+="="):(k=!1,z+="=")),Y="'"+z+"'",G+=" if ( ",h&&(G+=" ("+l+" !== undefined && typeof "+l+" != 'number') || "),G+=" "+d+" "+e+" "+l+" || "+d+" !== "+d+") { ")),t=t||D,(s=s||[]).push(G),G="",m.createErrors!==!1?(G+=" { keyword: '"+(t||"_limit")+"' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(y)+" , params: { comparison: "+Y+", limit: "+l+", exclusive: "+k+" } ",m.opts.messages!==!1&&(G=G+" , message: 'should be "+z+" "+(h?"' + "+l:l+"'")),m.opts.verbose&&(G=(G+=" , schema:  ")+(h?"validate.schema"+R:""+f)+"         , parentSchema: validate.schema"+m.schemaPath+" , data: "+d+" "),G+=" } "):G+=" {} ";var s,c=G;return G=s.pop(),!m.compositeRule&&C?m.async?G+=" throw new ValidationError(["+c+"]); ":G+=" validate.errors = ["+c+"]; return false; ":G+=" var err = "+c+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G+=" } ",C&&(G+=" else { "),G}},2407:function(le){le.exports=function(m,D,U){var k,H=" ",j=m.level,R=m.dataLevel,z=m.schema[D],Y=m.schemaPath+m.util.getProperty(D),G=m.errSchemaPath+"/"+D,N=!m.opts.allErrors,A="data"+(R||""),f=m.opts.$data&&z&&z.$data,R=f?(H+=" var schema"+j+" = "+m.util.getData(z.$data,R,m.dataPathArr)+"; ","schema"+j):z;if(f||typeof z=="number")return H+="if ( ",f&&(H+=" ("+R+" !== undefined && typeof "+R+" != 'number') || "),(j=[]).push(H+=" "+A+".length "+((k=D)=="maxItems"?">":"<")+" "+R+") { "),H="",m.createErrors!==!1?(H+=" { keyword: '"+(k||"_limitItems")+"' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: { limit: "+R+" } ",m.opts.messages!==!1&&(H=(H=(H+=" , message: 'should NOT have ")+(D=="maxItems"?"more":"fewer")+" than ")+(f?"' + "+R+" + '":""+z)+" items' "),m.opts.verbose&&(H=(H+=" , schema:  ")+(f?"validate.schema"+Y:""+z)+"         , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),H+=" } "):H+=" {} ",k=H,H=j.pop(),!m.compositeRule&&N?m.async?H+=" throw new ValidationError(["+k+"]); ":H+=" validate.errors = ["+k+"]; return false; ":H+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",H+="} ",N&&(H+=" else { "),H;throw new Error(D+" must be number")}},1250:function(le){le.exports=function(m,D,U){var k,H=" ",j=m.level,R=m.dataLevel,z=m.schema[D],Y=m.schemaPath+m.util.getProperty(D),G=m.errSchemaPath+"/"+D,N=!m.opts.allErrors,A="data"+(R||""),f=m.opts.$data&&z&&z.$data,R=f?(H+=" var schema"+j+" = "+m.util.getData(z.$data,R,m.dataPathArr)+"; ","schema"+j):z;if(f||typeof z=="number")return H+="if ( ",f&&(H+=" ("+R+" !== undefined && typeof "+R+" != 'number') || "),m.opts.unicode===!1?H+=" "+A+".length ":H+=" ucs2length("+A+") ",(j=[]).push(H+=" "+((k=D)=="maxLength"?">":"<")+" "+R+") { "),H="",m.createErrors!==!1?(H+=" { keyword: '"+(k||"_limitLength")+"' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: { limit: "+R+" } ",m.opts.messages!==!1&&(H=(H=(H+=" , message: 'should NOT be ")+(D=="maxLength"?"longer":"shorter")+" than ")+(f?"' + "+R+" + '":""+z)+" characters' "),m.opts.verbose&&(H=(H+=" , schema:  ")+(f?"validate.schema"+Y:""+z)+"         , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),H+=" } "):H+=" {} ",k=H,H=j.pop(),!m.compositeRule&&N?m.async?H+=" throw new ValidationError(["+k+"]); ":H+=" validate.errors = ["+k+"]; return false; ":H+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",H+="} ",N&&(H+=" else { "),H;throw new Error(D+" must be number")}},2596:function(le){le.exports=function(m,D,U){var k,H=" ",j=m.level,R=m.dataLevel,z=m.schema[D],Y=m.schemaPath+m.util.getProperty(D),G=m.errSchemaPath+"/"+D,N=!m.opts.allErrors,A="data"+(R||""),f=m.opts.$data&&z&&z.$data,R=f?(H+=" var schema"+j+" = "+m.util.getData(z.$data,R,m.dataPathArr)+"; ","schema"+j):z;if(f||typeof z=="number")return H+="if ( ",f&&(H+=" ("+R+" !== undefined && typeof "+R+" != 'number') || "),(j=[]).push(H+=" Object.keys("+A+").length "+((k=D)=="maxProperties"?">":"<")+" "+R+") { "),H="",m.createErrors!==!1?(H+=" { keyword: '"+(k||"_limitProperties")+"' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: { limit: "+R+" } ",m.opts.messages!==!1&&(H=(H=(H+=" , message: 'should NOT have ")+(D=="maxProperties"?"more":"fewer")+" than ")+(f?"' + "+R+" + '":""+z)+" properties' "),m.opts.verbose&&(H=(H+=" , schema:  ")+(f?"validate.schema"+Y:""+z)+"         , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),H+=" } "):H+=" {} ",k=H,H=j.pop(),!m.compositeRule&&N?m.async?H+=" throw new ValidationError(["+k+"]); ":H+=" validate.errors = ["+k+"]; return false; ":H+=" var err = "+k+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",H+="} ",N&&(H+=" else { "),H;throw new Error(D+" must be number")}},9486:function(le){le.exports=function(m,D,U){var k=" ",H=m.schema[D],j=m.schemaPath+m.util.getProperty(D),z=m.errSchemaPath+"/"+D,Y=!m.opts.allErrors,G=m.util.copy(m),N="",A=(G.level++,"valid"+G.level),f=G.baseId,R=!0,y=H;if(y)for(var C,d=-1,h=y.length-1;d<h;)C=y[d+=1],(m.opts.strictKeywords?typeof C=="object"&&0<Object.keys(C).length||C===!1:m.util.schemaHasRules(C,m.RULES.all))&&(R=!1,G.schema=C,G.schemaPath=j+"["+d+"]",G.errSchemaPath=z+"/"+d,k+="  "+m.validate(G)+" ",G.baseId=f,Y)&&(k+=" if ("+A+") { ",N+="}");return Y&&(k+=R?" if (true) { ":" "+N.slice(0,-1)+" "),k}},5347:function(le){le.exports=function(m,Y,U){var k=" ",A=m.level,G=m.dataLevel,H=m.schema[Y],j=m.schemaPath+m.util.getProperty(Y),z=m.errSchemaPath+"/"+Y,Y=!m.opts.allErrors,G="data"+(G||""),N="valid"+A,A="errs__"+A,f=m.util.copy(m),R="",y=(f.level++,"valid"+f.level);if(H.every(function(i){return m.opts.strictKeywords?typeof i=="object"&&0<Object.keys(i).length||i===!1:m.util.schemaHasRules(i,m.RULES.all)})){var C=f.baseId,d=(k+=" var "+A+" = errors; var "+N+" = false;  ",m.compositeRule),h=(m.compositeRule=f.compositeRule=!0,H);if(h)for(var l,n=-1,o=h.length-1;n<o;)l=h[n+=1],f.schema=l,f.schemaPath=j+"["+n+"]",f.errSchemaPath=z+"/"+n,k+="  "+m.validate(f)+" ",f.baseId=C,k+=" "+N+" = "+N+" || "+y+"; if (!"+N+") { ",R+="}";m.compositeRule=f.compositeRule=d,k+=" "+R+" if (!"+N+") {   var err =   ",m.createErrors!==!1?(k+=" { keyword: 'anyOf' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(z)+" , params: {} ",m.opts.messages!==!1&&(k+=" , message: 'should match some schema in anyOf' "),m.opts.verbose&&(k+=" , schema: validate.schema"+j+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+G+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!m.compositeRule&&Y&&(m.async?k+=" throw new ValidationError(vErrors); ":k+=" validate.errors = vErrors; return false; "),k+=" } else {  errors = "+A+"; if (vErrors !== null) { if ("+A+") vErrors.length = "+A+"; else vErrors = null; } ",m.opts.allErrors&&(k+=" } ")}else Y&&(k+=" if (true) { ");return k}},923:function(le){le.exports=function(m,H,U){var k=" ",j=m.schema[H],H=m.errSchemaPath+"/"+H,j=(m.opts.allErrors,m.util.toQuotedString(j));return m.opts.$comment===!0?k+=" console.log("+j+");":typeof m.opts.$comment=="function"&&(k+=" self._opts.$comment("+j+", "+m.util.toQuotedString(H)+", validate.root.schema);"),k}},2617:function(le){le.exports=function(m,j,U){var R=" ",k=m.level,f=m.dataLevel,A=m.schema[j],H=m.schemaPath+m.util.getProperty(j),j=m.errSchemaPath+"/"+j,z=!m.opts.allErrors,Y="data"+(f||""),G="valid"+k,N=m.opts.$data&&A&&A.$data,A=(N&&(R+=" var schema"+k+" = "+m.util.getData(A.$data,f,m.dataPathArr)+"; "),N||(R+=" var schema"+k+" = validate.schema"+H+";"),[]),f=(A.push(R+="var "+G+" = equal("+Y+", schema"+k+"); if (!"+G+") {   "),R="",m.createErrors!==!1?(R+=" { keyword: 'const' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(j)+" , params: { allowedValue: schema"+k+" } ",m.opts.messages!==!1&&(R+=" , message: 'should be equal to constant' "),m.opts.verbose&&(R+=" , schema: validate.schema"+H+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+Y+" "),R+=" } "):R+=" {} ",R),R=A.pop();return!m.compositeRule&&z?m.async?R+=" throw new ValidationError(["+f+"]); ":R+=" validate.errors = ["+f+"]; return false; ":R+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",R+=" }",z&&(R+=" else { "),R}},2119:function(le){le.exports=function(m,j,U){var l=" ",d=m.level,Y=m.dataLevel,k=m.schema[j],H=m.schemaPath+m.util.getProperty(j),j=m.errSchemaPath+"/"+j,z=!m.opts.allErrors,Y="data"+(Y||""),G="valid"+d,N="errs__"+d,A=m.util.copy(m),f=(A.level++,"valid"+A.level),d="i"+d,R=A.dataLevel=m.dataLevel+1,y="data"+R,h=m.baseId,C=m.opts.strictKeywords?typeof k=="object"&&0<Object.keys(k).length||k===!1:m.util.schemaHasRules(k,m.RULES.all),d=(l+="var "+N+" = errors;var "+G+";",C?(G=m.compositeRule,m.compositeRule=A.compositeRule=!0,A.schema=k,A.schemaPath=H,A.errSchemaPath=j,l+=" var "+f+" = false; for (var "+d+" = 0; "+d+" < "+Y+".length; "+d+"++) { ",A.errorPath=m.util.getPathExpr(m.errorPath,d,m.opts.jsonPointers,!0),k=Y+"["+d+"]",A.dataPathArr[R]=d,R=m.validate(A),A.baseId=h,m.util.varOccurences(R,y)<2?l+=" "+m.util.varReplace(R,y,k)+" ":l+=" var "+y+" = "+k+"; "+R+" ",l+=" if ("+f+") break; }  ",m.compositeRule=A.compositeRule=G,l+="  if (!"+f+") {"):l+=" if ("+Y+".length == 0) {",[]),h=(d.push(l),l="",m.createErrors!==!1?(l+=" { keyword: 'contains' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(j)+" , params: {} ",m.opts.messages!==!1&&(l+=" , message: 'should contain a valid item' "),m.opts.verbose&&(l+=" , schema: validate.schema"+H+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+Y+" "),l+=" } "):l+=" {} ",l),l=d.pop();return!m.compositeRule&&z?m.async?l+=" throw new ValidationError(["+h+"]); ":l+=" validate.errors = ["+h+"]; return false; ":l+=" var err = "+h+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l+=" } else { ",C&&(l+="  errors = "+N+"; if (vErrors !== null) { if ("+N+") vErrors.length = "+N+"; else vErrors = null; } "),m.opts.allErrors&&(l+=" } "),l}},1793:function(le){le.exports=function(m,p,U){var k,H,j,z=" ",Y=m.level,G=m.dataLevel,g=m.schema[p],N=m.schemaPath+m.util.getProperty(p),A=m.errSchemaPath+"/"+p,f=!m.opts.allErrors,R="data"+(G||""),y="valid"+Y,C="errs__"+Y,d=m.opts.$data&&g&&g.$data,h=d?(z+=" var schema"+Y+" = "+m.util.getData(g.$data,G,m.dataPathArr)+"; ","schema"+Y):g,l="definition"+Y,n=this.definition,o="";if(d&&n.$data){var i="keywordValidate"+Y,a=n.validateSchema;z+=" var "+l+" = RULES.custom['"+p+"'].definition; var "+i+" = "+l+".validate;"}else{if(!(s=m.useCustomRule(this,g,m.schema,m)))return;h="validate.schema"+N,i=s.code,k=n.compile,H=n.inline,j=n.macro}var r,e,t,s,c,p=i+".errors",g="i"+Y,b="ruleErr"+Y,w=n.async;if(w&&!m.async)throw new Error("async keyword in sync schema");return H||j||(z+=p+" = null;"),z+="var "+C+" = errors;var "+y+";",d&&n.$data&&(o+="}",z+=" if ("+h+" === undefined) { "+y+" = true; } else { ",a)&&(o+="}",z+=" "+y+" = "+l+".validateSchema("+h+"); if ("+y+") { "),H?n.statements?z+=" "+s.validate+" ":z+=" "+y+" = "+s.validate+"; ":j?(o="",(d=m.util.copy(m)).level++,r="valid"+d.level,d.schema=s.validate,d.schemaPath="",a=m.compositeRule,m.compositeRule=d.compositeRule=!0,l=m.validate(d).replace(/validate\.schema/g,i),m.compositeRule=d.compositeRule=a,z+=" "+l):((c=c||[]).push(z),z="",z+="  "+i+".call( ",m.opts.passContext?z+="this":z+="self",k||n.schema===!1?z+=" , "+R+" ":z+=" , "+h+" , "+R+" , validate.schema"+m.schemaPath+" ",z+=" , (dataPath || '')",m.errorPath!='""'&&(z+=" + "+m.errorPath),s=z+=" , "+(e=G?"data"+(G-1||""):"parentData")+" , "+(t=G?m.dataPathArr[G]:"parentDataProperty")+" , rootData )  ",z=c.pop(),n.errors===!1?(z+=" "+y+" = ",w&&(z+="await "),z+=s+"; "):z+=w?" var "+(p="customErrors"+Y)+" = null; try { "+y+" = await "+s+"; } catch (e) { "+y+" = false; if (e instanceof ValidationError) "+p+" = e.errors; else throw e; } ":" "+p+" = null; "+y+" = "+s+"; "),n.modifying&&(z+=" if ("+e+") "+R+" = "+e+"["+t+"];"),z+=""+o,n.valid?f&&(z+=" if (true) { "):(z+=" if ( ",n.valid===void 0?z=z+" !"+(j?""+r:y):z+=" "+!n.valid+" ",d=this.keyword,(c=c||[]).push(z+=") { "),(c=c||[]).push(z=""),z="",m.createErrors!==!1?(z+=" { keyword: '"+(d||"custom")+"' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(A)+" , params: { keyword: '"+this.keyword+"' } ",m.opts.messages!==!1&&(z+=` , message: 'should pass "`+this.keyword+`" keyword validation' `),m.opts.verbose&&(z+=" , schema: validate.schema"+N+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+R+" "),z+=" } "):z+=" {} ",a=z,z=c.pop(),!m.compositeRule&&f?m.async?z+=" throw new ValidationError(["+a+"]); ":z+=" validate.errors = ["+a+"]; return false; ":z+=" var err = "+a+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",l=z,z=c.pop(),H?n.errors?n.errors!="full"&&(z+="  for (var "+g+"="+C+"; "+g+"<errors; "+g+"++) { var "+b+" = vErrors["+g+"]; if ("+b+".dataPath === undefined) "+b+".dataPath = (dataPath || '') + "+m.errorPath+"; if ("+b+".schemaPath === undefined) { "+b+'.schemaPath = "'+A+'"; } ',m.opts.verbose&&(z+=" "+b+".schema = "+h+"; "+b+".data = "+R+"; "),z+=" } "):n.errors===!1?z+=" "+l+" ":(z+=" if ("+C+" == errors) { "+l+" } else {  for (var "+g+"="+C+"; "+g+"<errors; "+g+"++) { var "+b+" = vErrors["+g+"]; if ("+b+".dataPath === undefined) "+b+".dataPath = (dataPath || '') + "+m.errorPath+"; if ("+b+".schemaPath === undefined) { "+b+'.schemaPath = "'+A+'"; } ',m.opts.verbose&&(z+=" "+b+".schema = "+h+"; "+b+".data = "+R+"; "),z+=" } } "):j?(z+="   var err =   ",m.createErrors!==!1?(z+=" { keyword: '"+(d||"custom")+"' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(A)+" , params: { keyword: '"+this.keyword+"' } ",m.opts.messages!==!1&&(z+=` , message: 'should pass "`+this.keyword+`" keyword validation' `),m.opts.verbose&&(z+=" , schema: validate.schema"+N+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+R+" "),z+=" } "):z+=" {} ",z+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!m.compositeRule&&f&&(m.async?z+=" throw new ValidationError(vErrors); ":z+=" validate.errors = vErrors; return false; ")):n.errors===!1?z+=" "+l+" ":(z+=" if (Array.isArray("+p+")) { if (vErrors === null) vErrors = "+p+"; else vErrors = vErrors.concat("+p+"); errors = vErrors.length;  for (var "+g+"="+C+"; "+g+"<errors; "+g+"++) { var "+b+" = vErrors["+g+"]; if ("+b+".dataPath === undefined) "+b+".dataPath = (dataPath || '') + "+m.errorPath+";  "+b+'.schemaPath = "'+A+'";  ',m.opts.verbose&&(z+=" "+b+".schema = "+h+"; "+b+".data = "+R+"; "),z+=" } } else { "+l+" } "),z+=" } ",f&&(z+=" else { ")),z}},9115:function(le){le.exports=function(m,R,U){var k,H=" ",j=m.level,z=m.dataLevel,Y=m.schema[R],G=m.schemaPath+m.util.getProperty(R),N=m.errSchemaPath+"/"+R,A=!m.opts.allErrors,f="data"+(z||""),R="errs__"+j,y=m.util.copy(m),C="",d=(y.level++,"valid"+y.level),h={},l={},n=m.opts.ownProperties;for(W in Y)W!="__proto__"&&(O=Y[W],(k=Array.isArray(O)?l:h)[W]=O);var o=m.errorPath;for(W in H=H+("var "+R+" = errors;")+("var missing"+j+";"),l)if((k=l[W]).length){if(H+=" if ( "+f+m.util.getProperty(W)+" !== undefined ",n&&(H+=" && Object.prototype.hasOwnProperty.call("+f+", '"+m.util.escapeQuotes(W)+"') "),A){H+=" && ( ";var i=k;if(i)for(var a=-1,r=i.length-1;a<r;)p=i[a+=1],a&&(H+=" || "),H+=" ( ( "+(E=f+(w=m.util.getProperty(p)))+" === undefined ",n&&(H+=" || ! Object.prototype.hasOwnProperty.call("+f+", '"+m.util.escapeQuotes(p)+"') "),H+=") && (missing"+j+" = "+m.util.toQuotedString(m.opts.jsonPointers?p:w)+") ) ";H+=")) {  ";var s="missing"+j,e="' + "+s+" + '",t=(m.opts._errorDataPathProperty&&(m.errorPath=m.opts.jsonPointers?m.util.getPathExpr(o,s,!0):o+" + "+s),t||[]),s=(t.push(H),H="",m.createErrors!==!1?(H+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(N)+" , params: { property: '"+m.util.escapeQuotes(W)+"', missingProperty: '"+e+"', depsCount: "+k.length+", deps: '"+m.util.escapeQuotes(k.length==1?k[0]:k.join(", "))+"' } ",m.opts.messages!==!1&&(H+=" , message: 'should have ",k.length==1?H+="property "+m.util.escapeQuotes(k[0]):H+="properties "+m.util.escapeQuotes(k.join(", ")),H+=" when property "+m.util.escapeQuotes(W)+" is present' "),m.opts.verbose&&(H+=" , schema: validate.schema"+G+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+f+" "),H+=" } "):H+=" {} ",H),H=t.pop();!m.compositeRule&&A?m.async?H+=" throw new ValidationError(["+s+"]); ":H+=" validate.errors = ["+s+"]; return false; ":H+=" var err = "+s+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "}else{H+=" ) { ";var c=k;if(c)for(var p,g=-1,b=c.length-1;g<b;){p=c[g+=1];var w=m.util.getProperty(p),e=m.util.escapeQuotes(p),E=f+w;m.opts._errorDataPathProperty&&(m.errorPath=m.util.getPath(o,p,m.opts.jsonPointers)),H+=" if ( "+E+" === undefined ",n&&(H+=" || ! Object.prototype.hasOwnProperty.call("+f+", '"+m.util.escapeQuotes(p)+"') "),H+=") {  var err =   ",m.createErrors!==!1?(H+=" { keyword: 'dependencies' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(N)+" , params: { property: '"+m.util.escapeQuotes(W)+"', missingProperty: '"+e+"', depsCount: "+k.length+", deps: '"+m.util.escapeQuotes(k.length==1?k[0]:k.join(", "))+"' } ",m.opts.messages!==!1&&(H+=" , message: 'should have ",k.length==1?H+="property "+m.util.escapeQuotes(k[0]):H+="properties "+m.util.escapeQuotes(k.join(", ")),H+=" when property "+m.util.escapeQuotes(W)+" is present' "),m.opts.verbose&&(H+=" , schema: validate.schema"+G+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+f+" "),H+=" } "):H+=" {} ",H+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}H+=" }   ",A&&(C+="}",H+=" else { ")}m.errorPath=o;var W,B=y.baseId;for(W in h){var O=h[W];(m.opts.strictKeywords?typeof O=="object"&&0<Object.keys(O).length||O===!1:m.util.schemaHasRules(O,m.RULES.all))&&(H+=" "+d+" = true; if ( "+f+m.util.getProperty(W)+" !== undefined ",n&&(H+=" && Object.prototype.hasOwnProperty.call("+f+", '"+m.util.escapeQuotes(W)+"') "),H+=") { ",y.schema=O,y.schemaPath=G+m.util.getProperty(W),y.errSchemaPath=N+"/"+m.util.escapeFragment(W),H+="  "+m.validate(y)+" ",y.baseId=B,H+=" }  ",A)&&(H+=" if ("+d+") { ",C+="}")}return A&&(H+="   "+C+" if ("+R+" == errors) {"),H}},9317:function(le){le.exports=function(m,j,U){var R=" ",k=m.level,A=m.dataLevel,f=m.schema[j],H=m.schemaPath+m.util.getProperty(j),j=m.errSchemaPath+"/"+j,z=!m.opts.allErrors,Y="data"+(A||""),G="valid"+k,N=m.opts.$data&&f&&f.$data,f=(N&&(R+=" var schema"+k+" = "+m.util.getData(f.$data,A,m.dataPathArr)+"; "),"i"+k),A="schema"+k,A=(N||(R+=" var "+A+" = validate.schema"+H+";"),R+="var "+G+";",N&&(R+=" if (schema"+k+" === undefined) "+G+" = true; else if (!Array.isArray(schema"+k+")) "+G+" = false; else {"),R+=G+" = false;for (var "+f+"=0; "+f+"<"+A+".length; "+f+"++) if (equal("+Y+", "+A+"["+f+"])) { "+G+" = true; break; }",N&&(R+="  }  "),[]),f=(A.push(R+=" if (!"+G+") {   "),R="",m.createErrors!==!1?(R+=" { keyword: 'enum' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(j)+" , params: { allowedValues: schema"+k+" } ",m.opts.messages!==!1&&(R+=" , message: 'should be equal to one of the allowed values' "),m.opts.verbose&&(R+=" , schema: validate.schema"+H+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+Y+" "),R+=" } "):R+=" {} ",R),R=A.pop();return!m.compositeRule&&z?m.async?R+=" throw new ValidationError(["+f+"]); ":R+=" validate.errors = ["+f+"]; return false; ":R+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",R+=" }",z&&(R+=" else { "),R}},8327:function(le){le.exports=function(m,G,U){var k=" ",H=m.level,j=m.dataLevel,z=m.schema[G],Y=m.schemaPath+m.util.getProperty(G),G=m.errSchemaPath+"/"+G,N=!m.opts.allErrors,A="data"+(j||"");if(m.opts.format===!1)N&&(k+=" if (true) { ");else{var f,R=m.opts.$data&&z&&z.$data,j=R?(k+=" var schema"+H+" = "+m.util.getData(z.$data,j,m.dataPathArr)+"; ","schema"+H):z,y=m.opts.unknownFormats,C=Array.isArray(y);if(R)k+=" var "+(f="format"+H)+" = formats["+j+"]; var "+(d="isObject"+H)+" = typeof "+f+" == 'object' && !("+f+" instanceof RegExp) && "+f+".validate; var "+(l="formatType"+H)+" = "+d+" && "+f+".type || 'string'; if ("+d+") { ",m.async&&(k+=" var async"+H+" = "+f+".async; "),k+=" "+f+" = "+f+".validate; } if (  ",R&&(k+=" ("+j+" !== undefined && typeof "+j+" != 'string') || "),k+=" (",y!="ignore"&&(k+=" ("+j+" && !"+f+" ",C&&(k+=" && self._opts.unknownFormats.indexOf("+j+") == -1 "),k+=") || "),k+=" ("+f+" && "+l+" == '"+U+"' && !(typeof "+f+" == 'function' ? ",m.async?k+=" (async"+H+" ? await "+f+"("+A+") : "+f+"("+A+")) ":k+=" "+f+"("+A+") ",k+=" : "+f+".test("+A+"))))) {";else{if(!(f=m.formats[z])){if(y=="ignore")return m.logger.warn('unknown format "'+z+'" ignored in schema at path "'+m.errSchemaPath+'"'),N&&(k+=" if (true) { "),k;if(C&&0<=y.indexOf(z))return N&&(k+=" if (true) { "),k;throw new Error('unknown format "'+z+'" is used in schema at path "'+m.errSchemaPath+'"')}var d,h,l=(d=typeof f=="object"&&!(f instanceof RegExp)&&f.validate)&&f.type||"string";if(d&&(h=f.async===!0,f=f.validate),l!=U)return N&&(k+=" if (true) { "),k;if(h){if(!m.async)throw new Error("async format in sync schema");k+=" if (!(await "+(n="formats"+m.util.getProperty(z)+".validate")+"("+A+"))) { "}else{k+=" if (! ";var n="formats"+m.util.getProperty(z);d&&(n+=".validate"),k=k+(typeof f=="function"?" "+n+"("+A+") ":" "+n+".test("+A+") ")+") { "}}H=[],C=(H.push(k),k="",m.createErrors!==!1?(k=(k+=" { keyword: 'format' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: { format:  ")+(R?""+j:""+m.util.toQuotedString(z))+"  } ",m.opts.messages!==!1&&(k=(k+=` , message: 'should match format "`)+(R?"' + "+j+" + '":""+m.util.escapeQuotes(z))+`"' `),m.opts.verbose&&(k=(k=(k+=" , schema:  ")+(R?"validate.schema"+Y:""+m.util.toQuotedString(z)))+"         , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),k+=" } "):k+=" {} ",k),k=H.pop(),!m.compositeRule&&N?m.async?k+=" throw new ValidationError(["+C+"]); ":k+=" validate.errors = ["+C+"]; return false; ":k+=" var err = "+C+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } ",N&&(k+=" else { ")}return k}},5926:function(le){le.exports=function(m,G,U){var k,H=" ",j=m.level,A=m.dataLevel,z=m.schema[G],Y=m.schemaPath+m.util.getProperty(G),G=m.errSchemaPath+"/"+G,N=!m.opts.allErrors,A="data"+(A||""),f="valid"+j,R="errs__"+j,y=m.util.copy(m),C=(y.level++,"valid"+y.level),d=m.schema.then,h=m.schema.else,d=d!==void 0&&(m.opts.strictKeywords?typeof d=="object"&&0<Object.keys(d).length||d===!1:m.util.schemaHasRules(d,m.RULES.all)),h=h!==void 0&&(m.opts.strictKeywords?typeof h=="object"&&0<Object.keys(h).length||h===!1:m.util.schemaHasRules(h,m.RULES.all)),l=y.baseId;return d||h?(y.createErrors=!1,y.schema=z,y.schemaPath=Y,y.errSchemaPath=G,H+=" var "+R+" = errors; var "+f+" = true;  ",z=m.compositeRule,m.compositeRule=y.compositeRule=!0,H+="  "+m.validate(y)+" ",y.baseId=l,y.createErrors=!0,H+="  errors = "+R+"; if (vErrors !== null) { if ("+R+") vErrors.length = "+R+"; else vErrors = null; }  ",m.compositeRule=y.compositeRule=z,d?(H+=" if ("+C+") {  ",y.schema=m.schema.then,y.schemaPath=m.schemaPath+".then",y.errSchemaPath=m.errSchemaPath+"/then",H+="  "+m.validate(y)+" ",y.baseId=l,H+=" "+f+" = "+C+"; ",d&&h?H+=" var "+(k="ifClause"+j)+" = 'then'; ":k="'then'",H+=" } ",h&&(H+=" else { ")):H+=" if (!"+C+") { ",h&&(y.schema=m.schema.else,y.schemaPath=m.schemaPath+".else",y.errSchemaPath=m.errSchemaPath+"/else",H+="  "+m.validate(y)+" ",y.baseId=l,H+=" "+f+" = "+C+"; ",d&&h?H+=" var "+(k="ifClause"+j)+" = 'else'; ":k="'else'",H+=" } "),H+=" if (!"+f+") {   var err =   ",m.createErrors!==!1?(H+=" { keyword: 'if' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: { failingKeyword: "+k+" } ",m.opts.messages!==!1&&(H+=` , message: 'should match "' + `+k+` + '" schema' `),m.opts.verbose&&(H+=" , schema: validate.schema"+Y+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),H+=" } "):H+=" {} ",H+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!m.compositeRule&&N&&(m.async?H+=" throw new ValidationError(vErrors); ":H+=" validate.errors = vErrors; return false; "),H+=" }   ",N&&(H+=" else { ")):N&&(H+=" if (true) { "),H}},9646:function(le,m,D){le.exports={$ref:D(2331),allOf:D(9486),anyOf:D(5347),$comment:D(923),const:D(2617),contains:D(2119),dependencies:D(9115),enum:D(9317),format:D(8327),if:D(5926),items:D(392),maximum:D(1796),minimum:D(1796),maxItems:D(2407),minItems:D(2407),maxLength:D(1250),minLength:D(1250),maxProperties:D(2596),minProperties:D(2596),multipleOf:D(6039),not:D(7946),oneOf:D(9344),pattern:D(9737),properties:D(2537),propertyNames:D(2127),required:D(1204),uniqueItems:D(1985),validate:D(1869)}},392:function(le){le.exports=function(m,N,U){var k=" ",C=m.level,A=m.dataLevel,H=m.schema[N],j=m.schemaPath+m.util.getProperty(N),z=m.errSchemaPath+"/"+N,Y=!m.opts.allErrors,G="data"+(A||""),N="valid"+C,A="errs__"+C,f=m.util.copy(m),R="",y=(f.level++,"valid"+f.level),C="i"+C,d=f.dataLevel=m.dataLevel+1,h="data"+d,l=m.baseId;if(k+="var "+A+" = errors;var "+N+";",Array.isArray(H)){var n,o,i=m.schema.additionalItems,a=(i===!1&&(k+=" "+N+" = "+G+".length <= "+H.length+"; ",n=z,z=m.errSchemaPath+"/additionalItems",(o=o||[]).push(k+="  if (!"+N+") {   "),k="",m.createErrors!==!1?(k+=" { keyword: 'additionalItems' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(z)+" , params: { limit: "+H.length+" } ",m.opts.messages!==!1&&(k+=" , message: 'should NOT have more than "+H.length+" items' "),m.opts.verbose&&(k+=" , schema: false , parentSchema: validate.schema"+m.schemaPath+" , data: "+G+" "),k+=" } "):k+=" {} ",N=k,k=o.pop(),!m.compositeRule&&Y?m.async?k+=" throw new ValidationError(["+N+"]); ":k+=" validate.errors = ["+N+"]; return false; ":k+=" var err = "+N+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } ",z=n,Y)&&(R+="}",k+=" else { "),H);if(a)for(var r=-1,e=a.length-1;r<e;){var t,s,c=a[r+=1];(m.opts.strictKeywords?typeof c=="object"&&0<Object.keys(c).length||c===!1:m.util.schemaHasRules(c,m.RULES.all))&&(k+=" "+y+" = true; if ("+G+".length > "+r+") { ",t=G+"["+r+"]",f.schema=c,f.schemaPath=j+"["+r+"]",f.errSchemaPath=z+"/"+r,f.errorPath=m.util.getPathExpr(m.errorPath,r,m.opts.jsonPointers,!0),f.dataPathArr[d]=r,s=m.validate(f),f.baseId=l,m.util.varOccurences(s,h)<2?k+=" "+m.util.varReplace(s,h,t)+" ":k+=" var "+h+" = "+t+"; "+s+" ",k+=" }  ",Y)&&(k+=" if ("+y+") { ",R+="}")}typeof i=="object"&&(m.opts.strictKeywords?typeof i=="object"&&0<Object.keys(i).length||i===!1:m.util.schemaHasRules(i,m.RULES.all))&&(f.schema=i,f.schemaPath=m.schemaPath+".additionalItems",f.errSchemaPath=m.errSchemaPath+"/additionalItems",k+=" "+y+" = true; if ("+G+".length > "+H.length+") {  for (var "+C+" = "+H.length+"; "+C+" < "+G+".length; "+C+"++) { ",f.errorPath=m.util.getPathExpr(m.errorPath,C,m.opts.jsonPointers,!0),t=G+"["+C+"]",f.dataPathArr[d]=C,s=m.validate(f),f.baseId=l,m.util.varOccurences(s,h)<2?k+=" "+m.util.varReplace(s,h,t)+" ":k+=" var "+h+" = "+t+"; "+s+" ",Y&&(k+=" if (!"+y+") break; "),k+=" } }  ",Y)&&(k+=" if ("+y+") { ",R+="}")}else(m.opts.strictKeywords?typeof H=="object"&&0<Object.keys(H).length||H===!1:m.util.schemaHasRules(H,m.RULES.all))&&(f.schema=H,f.schemaPath=j,f.errSchemaPath=z,k+="  for (var "+C+" = 0; "+C+" < "+G+".length; "+C+"++) { ",f.errorPath=m.util.getPathExpr(m.errorPath,C,m.opts.jsonPointers,!0),t=G+"["+C+"]",f.dataPathArr[d]=C,s=m.validate(f),f.baseId=l,m.util.varOccurences(s,h)<2?k+=" "+m.util.varReplace(s,h,t)+" ":k+=" var "+h+" = "+t+"; "+s+" ",Y&&(k+=" if (!"+y+") break; "),k+=" }");return Y&&(k+=" "+R+" if ("+A+" == errors) {"),k}},6039:function(le){le.exports=function(m,D,U){var k=" ",H=m.level,f=m.dataLevel,j=m.schema[D],z=m.schemaPath+m.util.getProperty(D),Y=m.errSchemaPath+"/"+D,G=!m.opts.allErrors,N="data"+(f||""),A=m.opts.$data&&j&&j.$data,f=A?(k+=" var schema"+H+" = "+m.util.getData(j.$data,f,m.dataPathArr)+"; ","schema"+H):j;if(!A&&typeof j!="number")throw new Error(D+" must be number");return k+="var division"+H+";if (",A&&(k+=" "+f+" !== undefined && ( typeof "+f+" != 'number' || "),k+=" (division"+H+" = "+N+" / "+f+", ",m.opts.multipleOfPrecision?k+=" Math.abs(Math.round(division"+H+") - division"+H+") > 1e-"+m.opts.multipleOfPrecision+" ":k+=" division"+H+" !== parseInt(division"+H+") ",k+=" ) ",A&&(k+="  )  "),D=[],D.push(k+=" ) {   "),k="",m.createErrors!==!1?(k+=" { keyword: 'multipleOf' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(Y)+" , params: { multipleOf: "+f+" } ",m.opts.messages!==!1&&(k=k+" , message: 'should be multiple of "+(A?"' + "+f:f+"'")),m.opts.verbose&&(k=(k+=" , schema:  ")+(A?"validate.schema"+z:""+j)+"         , parentSchema: validate.schema"+m.schemaPath+" , data: "+N+" "),k+=" } "):k+=" {} ",H=k,k=D.pop(),!m.compositeRule&&G?m.async?k+=" throw new ValidationError(["+H+"]); ":k+=" validate.errors = ["+H+"]; return false; ":k+=" var err = "+H+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+="} ",G&&(k+=" else { "),k}},7946:function(le){le.exports=function(m,G,U){var k,H,j=" ",f=m.level,A=m.dataLevel,z=m.schema[G],Y=m.schemaPath+m.util.getProperty(G),G=m.errSchemaPath+"/"+G,N=!m.opts.allErrors,A="data"+(A||""),f="errs__"+f,R=m.util.copy(m),y=(R.level++,"valid"+R.level);return(m.opts.strictKeywords?typeof z=="object"&&0<Object.keys(z).length||z===!1:m.util.schemaHasRules(z,m.RULES.all))?(R.schema=z,R.schemaPath=Y,R.errSchemaPath=G,j+=" var "+f+" = errors;  ",z=m.compositeRule,m.compositeRule=R.compositeRule=!0,R.createErrors=!1,R.opts.allErrors&&(H=R.opts.allErrors,R.opts.allErrors=!1),j+=" "+m.validate(R)+" ",R.createErrors=!0,H&&(R.opts.allErrors=H),m.compositeRule=R.compositeRule=z,(k=k||[]).push(j+=" if ("+y+") {   "),j="",m.createErrors!==!1?(j+=" { keyword: 'not' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: {} ",m.opts.messages!==!1&&(j+=" , message: 'should NOT be valid' "),m.opts.verbose&&(j+=" , schema: validate.schema"+Y+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),j+=" } "):j+=" {} ",H=j,j=k.pop(),!m.compositeRule&&N?m.async?j+=" throw new ValidationError(["+H+"]); ":j+=" validate.errors = ["+H+"]; return false; ":j+=" var err = "+H+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",j+=" } else {  errors = "+f+"; if (vErrors !== null) { if ("+f+") vErrors.length = "+f+"; else vErrors = null; } ",m.opts.allErrors&&(j+=" } ")):(j+="  var err =   ",m.createErrors!==!1?(j+=" { keyword: 'not' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: {} ",m.opts.messages!==!1&&(j+=" , message: 'should NOT be valid' "),m.opts.verbose&&(j+=" , schema: validate.schema"+Y+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),j+=" } "):j+=" {} ",j+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",N&&(j+=" if (false) { ")),j}},9344:function(le){le.exports=function(m,Y,U){var k=" ",l=m.level,G=m.dataLevel,H=m.schema[Y],j=m.schemaPath+m.util.getProperty(Y),z=m.errSchemaPath+"/"+Y,Y=!m.opts.allErrors,G="data"+(G||""),N="valid"+l,A="errs__"+l,f=m.util.copy(m),R="",y=(f.level++,"valid"+f.level),C=f.baseId,d="prevValid"+l,h="passingSchemas"+l,l=(k+="var "+A+" = errors , "+d+" = false , "+N+" = false , "+h+" = null; ",m.compositeRule),n=(m.compositeRule=f.compositeRule=!0,H);if(n)for(var o,i=-1,a=n.length-1;i<a;)o=n[i+=1],(m.opts.strictKeywords?typeof o=="object"&&0<Object.keys(o).length||o===!1:m.util.schemaHasRules(o,m.RULES.all))?(f.schema=o,f.schemaPath=j+"["+i+"]",f.errSchemaPath=z+"/"+i,k+="  "+m.validate(f)+" ",f.baseId=C):k+=" var "+y+" = true; ",i&&(k+=" if ("+y+" && "+d+") { "+N+" = false; "+h+" = ["+h+", "+i+"]; } else { ",R+="}"),k+=" if ("+y+") { "+N+" = "+d+" = true; "+h+" = "+i+"; }";return m.compositeRule=f.compositeRule=l,k+=R+"if (!"+N+") {   var err =   ",m.createErrors!==!1?(k+=" { keyword: 'oneOf' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(z)+" , params: { passingSchemas: "+h+" } ",m.opts.messages!==!1&&(k+=" , message: 'should match exactly one schema in oneOf' "),m.opts.verbose&&(k+=" , schema: validate.schema"+j+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+G+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!m.compositeRule&&Y&&(m.async?k+=" throw new ValidationError(vErrors); ":k+=" validate.errors = vErrors; return false; "),k+="} else {  errors = "+A+"; if (vErrors !== null) { if ("+A+") vErrors.length = "+A+"; else vErrors = null; }",m.opts.allErrors&&(k+=" } "),k}},9737:function(le){le.exports=function(m,j,U){var R=" ",f=m.level,N=m.dataLevel,k=m.schema[j],H=m.schemaPath+m.util.getProperty(j),j=m.errSchemaPath+"/"+j,z=!m.opts.allErrors,Y="data"+(N||""),G=m.opts.$data&&k&&k.$data,N=G?(R+=" var schema"+f+" = "+m.util.getData(k.$data,N,m.dataPathArr)+"; ","schema"+f):k,f=G?"(new RegExp("+N+"))":m.usePattern(k),A=(R+="if ( ",G&&(R+=" ("+N+" !== undefined && typeof "+N+" != 'string') || "),[]),f=(A.push(R+=" !"+f+".test("+Y+") ) {   "),R="",m.createErrors!==!1?(R=(R+=" { keyword: 'pattern' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(j)+" , params: { pattern:  ")+(G?""+N:""+m.util.toQuotedString(k))+"  } ",m.opts.messages!==!1&&(R=(R+=` , message: 'should match pattern "`)+(G?"' + "+N+" + '":""+m.util.escapeQuotes(k))+`"' `),m.opts.verbose&&(R=(R=(R+=" , schema:  ")+(G?"validate.schema"+H:""+m.util.toQuotedString(k)))+"         , parentSchema: validate.schema"+m.schemaPath+" , data: "+Y+" "),R+=" } "):R+=" {} ",R),R=A.pop();return!m.compositeRule&&z?m.async?R+=" throw new ValidationError(["+f+"]); ":R+=" validate.errors = ["+f+"]; return false; ":R+=" var err = "+f+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",R+="} ",z&&(R+=" else { "),R}},2537:function(le){le.exports=function(m,f,U){var k,H=" ",j=m.level,i=m.dataLevel,z=m.schema[f],Y=m.schemaPath+m.util.getProperty(f),G=m.errSchemaPath+"/"+f,N=!m.opts.allErrors,A="data"+(i||""),f="errs__"+j,R=m.util.copy(m),y="",C=(R.level++,"valid"+R.level),d="key"+j,h="idx"+j,l=R.dataLevel=m.dataLevel+1,n="data"+l,o="dataProperties"+j,i=Object.keys(z||{}).filter(W),a=m.schema.patternProperties||{},r=Object.keys(a).filter(W),e=m.schema.additionalProperties,t=i.length||r.length,s=e===!1,c=typeof e=="object"&&Object.keys(e).length,p=m.opts.removeAdditional,g=s||c||p,b=m.opts.ownProperties,w=m.baseId,E=m.schema.required;function W(xe){return xe!=="__proto__"}if(E&&(!m.opts.$data||!E.$data)&&E.length<m.opts.loopRequired&&(k=m.util.toHash(E)),H+="var "+f+" = errors;var "+C+" = true;",b&&(H+=" var "+o+" = undefined;"),g){if(H+=b?" "+o+" = "+o+" || Object.keys("+A+"); for (var "+h+"=0; "+h+"<"+o+".length; "+h+"++) { var "+d+" = "+o+"["+h+"]; ":" for (var "+d+" in "+A+") { ",t){if(H+=" var isAdditional"+j+" = !(false ",i.length)if(8<i.length)H+=" || validate.schema"+Y+".hasOwnProperty("+d+") ";else{var B=i;if(B)for(var O=-1,x=B.length-1;O<x;)M=B[O+=1],H+=" || "+d+" == "+m.util.toQuotedString(M)+" "}if(r.length){var u=r;if(u)for(var _=-1,v=u.length-1;_<v;)J=u[_+=1],H+=" || "+m.usePattern(J)+".test("+d+") "}H+=" ); if (isAdditional"+j+") { "}p=="all"?H+=" delete "+A+"["+d+"]; ":(T=m.errorPath,E="' + "+d+" + '",m.opts._errorDataPathProperty&&(m.errorPath=m.util.getPathExpr(m.errorPath,d,m.opts.jsonPointers)),s?p?H+=" delete "+A+"["+d+"]; ":(F=G,G=m.errSchemaPath+"/additionalProperties",(I=I||[]).push(H+=" "+C+" = false; "),H="",m.createErrors!==!1?(H+=" { keyword: 'additionalProperties' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: { additionalProperty: '"+E+"' } ",m.opts.messages!==!1&&(H+=" , message: '",m.opts._errorDataPathProperty?H+="is an invalid additional property":H+="should NOT have additional properties",H+="' "),m.opts.verbose&&(H+=" , schema: false , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),H+=" } "):H+=" {} ",S=H,H=I.pop(),!m.compositeRule&&N?m.async?H+=" throw new ValidationError(["+S+"]); ":H+=" validate.errors = ["+S+"]; return false; ":H+=" var err = "+S+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G=F,N&&(H+=" break; ")):c&&(p=="failing"?(H+=" var "+f+" = errors;  ",g=m.compositeRule,m.compositeRule=R.compositeRule=!0,R.schema=e,R.schemaPath=m.schemaPath+".additionalProperties",R.errSchemaPath=m.errSchemaPath+"/additionalProperties",R.errorPath=m.opts._errorDataPathProperty?m.errorPath:m.util.getPathExpr(m.errorPath,d,m.opts.jsonPointers),me=A+"["+d+"]",R.dataPathArr[l]=d,ye=m.validate(R),R.baseId=w,m.util.varOccurences(ye,n)<2?H+=" "+m.util.varReplace(ye,n,me)+" ":H+=" var "+n+" = "+me+"; "+ye+" ",H+=" if (!"+C+") { errors = "+f+"; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete "+A+"["+d+"]; }  ",m.compositeRule=R.compositeRule=g):(R.schema=e,R.schemaPath=m.schemaPath+".additionalProperties",R.errSchemaPath=m.errSchemaPath+"/additionalProperties",R.errorPath=m.opts._errorDataPathProperty?m.errorPath:m.util.getPathExpr(m.errorPath,d,m.opts.jsonPointers),me=A+"["+d+"]",R.dataPathArr[l]=d,ye=m.validate(R),R.baseId=w,m.util.varOccurences(ye,n)<2?H+=" "+m.util.varReplace(ye,n,me)+" ":H+=" var "+n+" = "+me+"; "+ye+" ",N&&(H+=" if (!"+C+") break; "))),m.errorPath=T),t&&(H+=" } "),H+=" }  ",N&&(H+=" if ("+C+") { ",y+="}")}var $=m.opts.useDefaults&&!m.compositeRule;if(i.length){var P=i;if(P)for(var M,X=-1,Q=P.length-1;X<Q;){var K,ne,T,F,V,I,S,L=z[M=P[X+=1]];(m.opts.strictKeywords?typeof L=="object"&&0<Object.keys(L).length||L===!1:m.util.schemaHasRules(L,m.RULES.all))&&(me=A+(V=m.util.getProperty(M)),K=$&&L.default!==void 0,R.schema=L,R.schemaPath=Y+V,R.errSchemaPath=G+"/"+m.util.escapeFragment(M),R.errorPath=m.util.getPath(m.errorPath,M,m.opts.jsonPointers),R.dataPathArr[l]=m.util.toQuotedString(M),ye=m.validate(R),R.baseId=w,m.util.varOccurences(ye,n)<2?(ye=m.util.varReplace(ye,n,me),ne=me):H+=" var "+(ne=n)+" = "+me+"; ",K?H+=" "+ye+" ":(k&&k[M]?(H+=" if ( "+ne+" === undefined ",b&&(H+=" || ! Object.prototype.hasOwnProperty.call("+A+", '"+m.util.escapeQuotes(M)+"') "),H+=") { "+C+" = false; ",T=m.errorPath,F=G,V=m.util.escapeQuotes(M),m.opts._errorDataPathProperty&&(m.errorPath=m.util.getPath(T,M,m.opts.jsonPointers)),G=m.errSchemaPath+"/required",(I=I||[]).push(H),H="",m.createErrors!==!1?(H+=" { keyword: 'required' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: { missingProperty: '"+V+"' } ",m.opts.messages!==!1&&(H+=" , message: '",m.opts._errorDataPathProperty?H+="is a required property":H+="should have required property \\'"+V+"\\'",H+="' "),m.opts.verbose&&(H+=" , schema: validate.schema"+Y+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),H+=" } "):H+=" {} ",S=H,H=I.pop(),!m.compositeRule&&N?m.async?H+=" throw new ValidationError(["+S+"]); ":H+=" validate.errors = ["+S+"]; return false; ":H+=" var err = "+S+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",G=F,m.errorPath=T,H+=" } else { "):N?(H+=" if ( "+ne+" === undefined ",b&&(H+=" || ! Object.prototype.hasOwnProperty.call("+A+", '"+m.util.escapeQuotes(M)+"') "),H+=") { "+C+" = true; } else { "):(H+=" if ("+ne+" !== undefined ",b&&(H+=" &&   Object.prototype.hasOwnProperty.call("+A+", '"+m.util.escapeQuotes(M)+"') "),H+=" ) { "),H+=" "+ye+" } ")),N&&(H+=" if ("+C+") { ",y+="}")}}if(r.length){var Z=r;if(Z)for(var J,re=-1,pe=Z.length-1;re<pe;){var me,ye,L=a[J=Z[re+=1]];(m.opts.strictKeywords?typeof L=="object"&&0<Object.keys(L).length||L===!1:m.util.schemaHasRules(L,m.RULES.all))&&(R.schema=L,R.schemaPath=m.schemaPath+".patternProperties"+m.util.getProperty(J),R.errSchemaPath=m.errSchemaPath+"/patternProperties/"+m.util.escapeFragment(J),H=(H+=b?" "+o+" = "+o+" || Object.keys("+A+"); for (var "+h+"=0; "+h+"<"+o+".length; "+h+"++) { var "+d+" = "+o+"["+h+"]; ":" for (var "+d+" in "+A+") { ")+" if ("+m.usePattern(J)+".test("+d+")) { ",R.errorPath=m.util.getPathExpr(m.errorPath,d,m.opts.jsonPointers),me=A+"["+d+"]",R.dataPathArr[l]=d,ye=m.validate(R),R.baseId=w,m.util.varOccurences(ye,n)<2?H+=" "+m.util.varReplace(ye,n,me)+" ":H+=" var "+n+" = "+me+"; "+ye+" ",N&&(H+=" if (!"+C+") break; "),H+=" } ",N&&(H+=" else "+C+" = true; "),H+=" }  ",N)&&(H+=" if ("+C+") { ",y+="}")}}return N&&(H+=" "+y+" if ("+f+" == errors) {"),H}},2127:function(le){le.exports=function(m,C,U){var k,H,j,z,Y,G,N,A=" ",f=m.level,h=m.dataLevel,R=m.schema[C],y=m.schemaPath+m.util.getProperty(C),C=m.errSchemaPath+"/"+C,d=!m.opts.allErrors,h="data"+(h||""),l="errs__"+f,n=m.util.copy(m),o=(n.level++,"valid"+n.level);return A+="var "+l+" = errors;",(m.opts.strictKeywords?typeof R=="object"&&0<Object.keys(R).length||R===!1:m.util.schemaHasRules(R,m.RULES.all))&&(n.schema=R,n.schemaPath=y,n.errSchemaPath=C,R="idx"+f,H="i"+f,j="' + "+(k="key"+f)+" + '",z="data"+(n.dataLevel=m.dataLevel+1),N="dataProperties"+f,G=m.opts.ownProperties,Y=m.baseId,G&&(A+=" var "+N+" = undefined; "),A=A+(G?" "+N+" = "+N+" || Object.keys("+h+"); for (var "+R+"=0; "+R+"<"+N+".length; "+R+"++) { var "+k+" = "+N+"["+R+"]; ":" for (var "+k+" in "+h+") { ")+" var startErrs"+f+" = errors; ",G=k,N=m.compositeRule,m.compositeRule=n.compositeRule=!0,R=m.validate(n),n.baseId=Y,m.util.varOccurences(R,z)<2?A+=" "+m.util.varReplace(R,z,G)+" ":A+=" var "+z+" = "+G+"; "+R+" ",m.compositeRule=n.compositeRule=N,A+=" if (!"+o+") { for (var "+H+"=startErrs"+f+"; "+H+"<errors; "+H+"++) { vErrors["+H+"].propertyName = "+k+"; }   var err =   ",m.createErrors!==!1?(A+=" { keyword: 'propertyNames' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(C)+" , params: { propertyName: '"+j+"' } ",m.opts.messages!==!1&&(A+=" , message: 'property name \\'"+j+"\\' is invalid' "),m.opts.verbose&&(A+=" , schema: validate.schema"+y+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+h+" "),A+=" } "):A+=" {} ",A+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",!m.compositeRule&&d&&(m.async?A+=" throw new ValidationError(vErrors); ":A+=" validate.errors = vErrors; return false; "),d&&(A+=" break; "),A+=" } }"),d&&(A+="  if ("+l+" == errors) {"),A}},2331:function(le){le.exports=function(m,G,U){var k,H,j=" ",f=m.level,z=m.dataLevel,Y=m.schema[G],G=m.errSchemaPath+"/"+G,N=!m.opts.allErrors,A="data"+(z||""),f="valid"+f;if(Y=="#"||Y=="#/")H=m.isRoot?(k=m.async,"validate"):(k=m.root.schema.$async===!0,"root.refVal[0]");else{var R=m.resolveRef(m.baseId,Y,m.isRoot);if(R===void 0){var y=m.MissingRefError.message(m.baseId,Y);if(m.opts.missingRefs=="fail")m.logger.error(y),(C=C||[]).push(j),j="",m.createErrors!==!1?(j+=" { keyword: '$ref' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: { ref: '"+m.util.escapeQuotes(Y)+"' } ",m.opts.messages!==!1&&(j+=" , message: 'can\\'t resolve reference "+m.util.escapeQuotes(Y)+"' "),m.opts.verbose&&(j+=" , schema: "+m.util.toQuotedString(Y)+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),j+=" } "):j+=" {} ",G=j,j=C.pop(),!m.compositeRule&&N?m.async?j+=" throw new ValidationError(["+G+"]); ":j+=" validate.errors = ["+G+"]; return false; ":j+=" var err = "+G+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",N&&(j+=" if (false) { ");else{if(m.opts.missingRefs!="ignore")throw new m.MissingRefError(m.baseId,Y,y);m.logger.warn(y),N&&(j+=" if (true) { ")}}else R.inline?((G=m.util.copy(m)).level++,y="valid"+G.level,G.schema=R.schema,G.schemaPath="",G.errSchemaPath=Y,j+=" "+m.validate(G).replace(/validate\.schema/g,R.code)+" ",N&&(j+=" if ("+y+") { ")):(k=R.$async===!0||m.async&&R.$async!==!1,H=R.code)}if(H){(C=C||[]).push(j),j="",m.opts.passContext?j+=" "+H+".call(this, ":j+=" "+H+"( ",j+=" "+A+", (dataPath || '')",m.errorPath!='""'&&(j+=" + "+m.errorPath);var C,Y=z?"data"+(z-1||""):"parentData",G=j+=" , "+Y+" , "+(z?m.dataPathArr[z]:"parentDataProperty")+", rootData)  ";if(j=C.pop(),k){if(!m.async)throw new Error("async schema referenced by sync schema");N&&(j+=" var "+f+"; "),j+=" try { await "+G+"; ",N&&(j+=" "+f+" = true; "),j+=" } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ",N&&(j+=" "+f+" = false; "),j+=" } ",N&&(j+=" if ("+f+") { ")}else j+=" if (!"+G+") { if (vErrors === null) vErrors = "+H+".errors; else vErrors = vErrors.concat("+H+".errors); errors = vErrors.length; } ",N&&(j+=" else { ")}return j}},1204:function(le){le.exports=function(m,G,U){var k=" ",H=m.level,R=m.dataLevel,j=m.schema[G],z=m.schemaPath+m.util.getProperty(G),Y=m.errSchemaPath+"/"+G,G=!m.opts.allErrors,N="data"+(R||""),A="valid"+H,f=m.opts.$data&&j&&j.$data,R=(f&&(k+=" var schema"+H+" = "+m.util.getData(j.$data,R,m.dataPathArr)+"; "),"schema"+H);if(!f)if(j.length<m.opts.loopRequired&&m.schema.properties&&Object.keys(m.schema.properties).length){var y=[],C=j;if(C)for(var d=-1,h=C.length-1;d<h;){var l=C[d+=1],n=m.schema.properties[l];n&&(m.opts.strictKeywords?typeof n=="object"&&0<Object.keys(n).length||n===!1:m.util.schemaHasRules(n,m.RULES.all))||(y[y.length]=l)}}else y=j;if(f||y.length){var o=m.errorPath,j=f||y.length>=m.opts.loopRequired,i=m.opts.ownProperties;if(G){if(k+=" var missing"+H+"; ",j){f||(k+=" var "+R+" = validate.schema"+z+"; ");var a="' + "+(p="schema"+H+"["+(t="i"+H)+"]")+" + '";m.opts._errorDataPathProperty&&(m.errorPath=m.util.getPathExpr(o,p,m.opts.jsonPointers)),k+=" var "+A+" = true; ",f&&(k+=" if (schema"+H+" === undefined) "+A+" = true; else if (!Array.isArray(schema"+H+")) "+A+" = false; else {"),k+=" for (var "+t+" = 0; "+t+" < "+R+".length; "+t+"++) { "+A+" = "+N+"["+R+"["+t+"]] !== undefined ",i&&(k+=" &&   Object.prototype.hasOwnProperty.call("+N+", "+R+"["+t+"]) "),k+="; if (!"+A+") break; } ",f&&(k+="  }  "),(c=c||[]).push(k+="  if (!"+A+") {   "),k="",m.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(Y)+" , params: { missingProperty: '"+a+"' } ",m.opts.messages!==!1&&(k+=" , message: '",m.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+a+"\\'",k+="' "),m.opts.verbose&&(k+=" , schema: validate.schema"+z+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+N+" "),k+=" } "):k+=" {} ";var r=k,k=c.pop()}else{k+=" if ( ";var e=y;if(e)for(var t=-1,s=e.length-1;t<s;)b=e[t+=1],t&&(k+=" || "),k+=" ( ( "+(B=N+(W=m.util.getProperty(b)))+" === undefined ",i&&(k+=" || ! Object.prototype.hasOwnProperty.call("+N+", '"+m.util.escapeQuotes(b)+"') "),k+=") && (missing"+H+" = "+m.util.toQuotedString(m.opts.jsonPointers?b:W)+") ) ";k+=") {  ",a="' + "+(p="missing"+H)+" + '",m.opts._errorDataPathProperty&&(m.errorPath=m.opts.jsonPointers?m.util.getPathExpr(o,p,!0):o+" + "+p),(c=c||[]).push(k),k="",m.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(Y)+" , params: { missingProperty: '"+a+"' } ",m.opts.messages!==!1&&(k+=" , message: '",m.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+a+"\\'",k+="' "),m.opts.verbose&&(k+=" , schema: validate.schema"+z+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+N+" "),k+=" } "):k+=" {} ";var c,r=k;k=c.pop()}!m.compositeRule&&G?m.async?k+=" throw new ValidationError(["+r+"]); ":k+=" validate.errors = ["+r+"]; return false; ":k+=" var err = "+r+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } else { "}else if(j){f||(k+=" var "+R+" = validate.schema"+z+"; ");var p,a="' + "+(p="schema"+H+"["+(t="i"+H)+"]")+" + '";m.opts._errorDataPathProperty&&(m.errorPath=m.util.getPathExpr(o,p,m.opts.jsonPointers)),f&&(k+=" if ("+R+" && !Array.isArray("+R+")) {  var err =   ",m.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(Y)+" , params: { missingProperty: '"+a+"' } ",m.opts.messages!==!1&&(k+=" , message: '",m.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+a+"\\'",k+="' "),m.opts.verbose&&(k+=" , schema: validate.schema"+z+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+N+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if ("+R+" !== undefined) { "),k+=" for (var "+t+" = 0; "+t+" < "+R+".length; "+t+"++) { if ("+N+"["+R+"["+t+"]] === undefined ",i&&(k+=" || ! Object.prototype.hasOwnProperty.call("+N+", "+R+"["+t+"]) "),k+=") {  var err =   ",m.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(Y)+" , params: { missingProperty: '"+a+"' } ",m.opts.messages!==!1&&(k+=" , message: '",m.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+a+"\\'",k+="' "),m.opts.verbose&&(k+=" , schema: validate.schema"+z+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+N+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ",f&&(k+="  }  ")}else{var g=y;if(g)for(var b,w=-1,E=g.length-1;w<E;){b=g[w+=1];var W=m.util.getProperty(b),a=m.util.escapeQuotes(b),B=N+W;m.opts._errorDataPathProperty&&(m.errorPath=m.util.getPath(o,b,m.opts.jsonPointers)),k+=" if ( "+B+" === undefined ",i&&(k+=" || ! Object.prototype.hasOwnProperty.call("+N+", '"+m.util.escapeQuotes(b)+"') "),k+=") {  var err =   ",m.createErrors!==!1?(k+=" { keyword: 'required' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(Y)+" , params: { missingProperty: '"+a+"' } ",m.opts.messages!==!1&&(k+=" , message: '",m.opts._errorDataPathProperty?k+="is a required property":k+="should have required property \\'"+a+"\\'",k+="' "),m.opts.verbose&&(k+=" , schema: validate.schema"+z+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+N+" "),k+=" } "):k+=" {} ",k+=";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } "}}m.errorPath=o}else G&&(k+=" if (true) {");return k}},1985:function(le){le.exports=function(m,G,U){var k,H=" ",j=m.level,y=m.dataLevel,z=m.schema[G],Y=m.schemaPath+m.util.getProperty(G),G=m.errSchemaPath+"/"+G,N=!m.opts.allErrors,A="data"+(y||""),f="valid"+j,R=m.opts.$data&&z&&z.$data,y=R?(H+=" var schema"+j+" = "+m.util.getData(z.$data,y,m.dataPathArr)+"; ","schema"+j):z;return(z||R)&&m.opts.uniqueItems!==!1?(R&&(H+=" var "+f+"; if ("+y+" === false || "+y+" === undefined) "+f+" = true; else if (typeof "+y+" != 'boolean') "+f+" = false; else { "),H+=" var i = "+A+".length , "+f+" = true , j; if (i > 1) { ",j=m.schema.items&&m.schema.items.type,y=Array.isArray(j),!j||j=="object"||j=="array"||y&&(0<=j.indexOf("object")||0<=j.indexOf("array"))?H+=" outer: for (;i--;) { for (j = i; j--;) { if (equal("+A+"[i], "+A+"[j])) { "+f+" = false; break outer; } } } ":(H=(H+=" var itemIndices = {}, item; for (;i--;) { var item = "+A+"[i]; ")+" if ("+m.util["checkDataType"+(y?"s":"")](j,"item",m.opts.strictNumbers,!0)+") continue; ",y&&(H+=` if (typeof item == 'string') item = '"' + item; `),H+=" if (typeof itemIndices[item] == 'number') { "+f+" = false; j = itemIndices[item]; break; } itemIndices[item] = i; } "),H+=" } ",R&&(H+="  }  "),(k=k||[]).push(H+=" if (!"+f+") {   "),H="",m.createErrors!==!1?(H+=" { keyword: 'uniqueItems' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(G)+" , params: { i: i, j: j } ",m.opts.messages!==!1&&(H+=" , message: 'should NOT have duplicate items (items ## ' + j + ' and ' + i + ' are identical)' "),m.opts.verbose&&(H=(H+=" , schema:  ")+(R?"validate.schema"+Y:""+z)+"         , parentSchema: validate.schema"+m.schemaPath+" , data: "+A+" "),H+=" } "):H+=" {} ",j=H,H=k.pop(),!m.compositeRule&&N?m.async?H+=" throw new ValidationError(["+j+"]); ":H+=" validate.errors = ["+j+"]; return false; ":H+=" var err = "+j+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",H+=" } ",N&&(H+=" else { ")):N&&(H+=" if (true) { "),H}},1869:function(le){le.exports=function(m,D,U){var k="",H=m.schema.$async===!0,j=m.util.schemaHasRulesExcept(m.schema,m.RULES.all,"$ref"),z=m.self._getId(m.schema);if(m.opts.strictKeywords){var Y=m.util.schemaUnknownRules(m.schema,m.RULES.keywords);if(Y){if(Y="unknown keyword: "+Y,m.opts.strictKeywords!=="log")throw new Error(Y);m.logger.warn(Y)}}if(m.isTop&&(k+=" var validate = ",H&&(m.async=!0,k+="async "),k+="function(data, dataPath, parentData, parentDataProperty, rootData) { 'use strict'; ",z)&&(m.opts.sourceCode||m.opts.processCode)&&(k+=" /*# sourceURL="+z+" */ "),typeof m.schema=="boolean"||!j&&!m.schema.$ref)N=m.level,A=m.dataLevel,B=m.schema[D="false schema"],a=m.schemaPath+m.util.getProperty(D),r=m.errSchemaPath+"/"+D,C=!m.opts.allErrors,f="data"+(A||""),y="valid"+N,m.schema===!1?(m.isTop?C=!0:k+=" var "+y+" = false; ",(X=X||[]).push(k),k="",m.createErrors!==!1?(k+=" { keyword: 'false schema' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(r)+" , params: {} ",m.opts.messages!==!1&&(k+=" , message: 'boolean schema is false' "),m.opts.verbose&&(k+=" , schema: false , parentSchema: validate.schema"+m.schemaPath+" , data: "+f+" "),k+=" } "):k+=" {} ",b=k,k=X.pop(),!m.compositeRule&&C?m.async?k+=" throw new ValidationError(["+b+"]); ":k+=" validate.errors = ["+b+"]; return false; ":k+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; "):m.isTop?k+=H?" return data; ":" validate.errors = null; return true; ":k+=" var "+y+" = true; ",m.isTop&&(k+=" }; return validate; ");else{if(m.isTop){var G=m.isTop,N=m.level=0,A=m.dataLevel=0,f="data";if(m.rootId=m.resolve.fullPath(m.self._getId(m.root.schema)),m.baseId=m.baseId||m.rootId,delete m.isTop,m.dataPathArr=[""],m.schema.default!==void 0&&m.opts.useDefaults&&m.opts.strictDefaults){var R="default is ignored in the schema root";if(m.opts.strictDefaults!=="log")throw new Error(R);m.logger.warn(R)}k=(k+=" var vErrors = null; ")+" var errors = 0;      if (rootData === undefined) rootData = data; "}else{if(N=m.level,f="data"+((A=m.dataLevel)||""),z&&(m.baseId=m.resolve.url(m.baseId,z)),H&&!m.async)throw new Error("async schema in sync schema");k+=" var errs_"+N+" = errors;"}var y="valid"+N,C=!m.opts.allErrors,d="",h="",l=m.schema.type,n=Array.isArray(l);if(l&&m.opts.nullable&&m.schema.nullable===!0&&(n?l.indexOf("null")==-1&&(l=l.concat("null")):l!="null"&&(l=[l,"null"],n=!0)),n&&l.length==1&&(l=l[0],n=!1),m.schema.$ref&&j){if(m.opts.extendRefs=="fail")throw new Error('$ref: validation keywords used in schema at path "'+m.errSchemaPath+'" (see option extendRefs)');m.opts.extendRefs!==!0&&(j=!1,m.logger.warn('$ref: keywords ignored in schema at path "'+m.errSchemaPath+'"'))}if(m.schema.$comment&&m.opts.$comment&&(k+=" "+m.RULES.all.$comment.code(m,"$comment")),l){m.opts.coerceTypes&&(o=m.util.coerceToTypes(m.opts.coerceTypes,l));var o,i=m.RULES.types[l];if(o||n||i===!0||i&&!F(i)){var a=m.schemaPath+".type",r=m.errSchemaPath+"/type",a=m.schemaPath+".type",r=m.errSchemaPath+"/type";if(k+=" if ("+m.util[n?"checkDataTypes":"checkDataType"](l,f,m.opts.strictNumbers,!0)+") { ",o){var e="dataType"+N,t="coerced"+N,s=(k+=" var "+e+" = typeof "+f+"; var "+t+" = undefined; ",m.opts.coerceTypes=="array"&&(k+=" if ("+e+" == 'object' && Array.isArray("+f+") && "+f+".length == 1) { "+f+" = "+f+"[0]; "+e+" = typeof "+f+"; if ("+m.util.checkDataType(m.schema.type,f,m.opts.strictNumbers)+") "+t+" = "+f+"; } "),k+=" if ("+t+" !== undefined) ; ",o);if(s)for(var c,p=-1,g=s.length-1;p<g;)(c=s[p+=1])=="string"?k+=" else if ("+e+" == 'number' || "+e+" == 'boolean') "+t+" = '' + "+f+"; else if ("+f+" === null) "+t+" = ''; ":c=="number"||c=="integer"?(k+=" else if ("+e+" == 'boolean' || "+f+" === null || ("+e+" == 'string' && "+f+" && "+f+" == +"+f+" ",c=="integer"&&(k+=" && !("+f+" % 1)"),k+=")) "+t+" = +"+f+"; "):c=="boolean"?k+=" else if ("+f+" === 'false' || "+f+" === 0 || "+f+" === null) "+t+" = false; else if ("+f+" === 'true' || "+f+" === 1) "+t+" = true; ":c=="null"?k+=" else if ("+f+" === '' || "+f+" === 0 || "+f+" === false) "+t+" = null; ":m.opts.coerceTypes=="array"&&c=="array"&&(k+=" else if ("+e+" == 'string' || "+e+" == 'number' || "+e+" == 'boolean' || "+f+" == null) "+t+" = ["+f+"]; ");(X=X||[]).push(k+=" else {   "),k="",m.createErrors!==!1?(k=(k+=" { keyword: 'type' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(r)+" , params: { type: '")+(n?""+l.join(","):""+l)+"' } ",m.opts.messages!==!1&&(k=(k+=" , message: 'should be ")+(n?""+l.join(","):""+l)+"' "),m.opts.verbose&&(k+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+f+" "),k+=" } "):k+=" {} ";var b=k,Y=(k=X.pop(),!m.compositeRule&&C?m.async?k+=" throw new ValidationError(["+b+"]); ":k+=" validate.errors = ["+b+"]; return false; ":k+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",A?"data"+(A-1||""):"parentData");k=k+(" } if ("+t+" !== undefined) {  ")+(" "+f+" = "+t+"; "),A||(k+="if ("+Y+" !== undefined)"),k+=" "+Y+"["+(A?m.dataPathArr[A]:"parentDataProperty")+"] = "+t+"; } "}else b=((X=X||[]).push(k),k="",m.createErrors!==!1?(k=(k+=" { keyword: 'type' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(r)+" , params: { type: '")+(n?""+l.join(","):""+l)+"' } ",m.opts.messages!==!1&&(k=(k+=" , message: 'should be ")+(n?""+l.join(","):""+l)+"' "),m.opts.verbose&&(k+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+f+" "),k+=" } "):k+=" {} ",k),k=X.pop(),!m.compositeRule&&C?m.async?k+=" throw new ValidationError(["+b+"]); ":k+=" validate.errors = ["+b+"]; return false; ":k+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ";k+=" } "}}if(m.schema.$ref&&!j)k+=" "+m.RULES.all.$ref.code(m,"$ref")+" ",C&&(k=(k+=" } if (errors === ")+(G?"0":"errs_"+N)+") { ",h+="}");else{var w=m.RULES;if(w){for(var E=-1,W=w.length-1;E<W;)if(F(i=w[E+=1])){if(i.type&&(k+=" if ("+m.util.checkDataType(i.type,f,m.opts.strictNumbers)+") { "),m.opts.useDefaults){if(i.type=="object"&&m.schema.properties){var B=m.schema.properties,O=Object.keys(B);if(O){for(var x,u=-1,_=O.length-1;u<_;)if((P=B[x=O[u+=1]]).default!==void 0){var v=f+m.util.getProperty(x);if(m.compositeRule){if(m.opts.strictDefaults){if(R="default is ignored for: "+v,m.opts.strictDefaults!=="log")throw new Error(R);m.logger.warn(R)}}else k+=" if ("+v+" === undefined ",m.opts.useDefaults=="empty"&&(k+=" || "+v+" === null || "+v+" === '' "),k+=" ) "+v+" = ",m.opts.useDefaults=="shared"?k+=" "+m.useDefault(P.default)+" ":k+=" "+JSON.stringify(P.default)+" ",k+="; "}}}else if(i.type=="array"&&Array.isArray(m.schema.items)){var $=m.schema.items;if($){for(var P,p=-1,M=$.length-1;p<M;)if((P=$[p+=1]).default!==void 0)if(v=f+"["+p+"]",m.compositeRule){if(m.opts.strictDefaults){if(R="default is ignored for: "+v,m.opts.strictDefaults!=="log")throw new Error(R);m.logger.warn(R)}}else k+=" if ("+v+" === undefined ",m.opts.useDefaults=="empty"&&(k+=" || "+v+" === null || "+v+" === '' "),k+=" ) "+v+" = ",m.opts.useDefaults=="shared"?k+=" "+m.useDefault(P.default)+" ":k+=" "+JSON.stringify(P.default)+" ",k+="; "}}}var X,Q=i.rules;if(Q)for(var K,ne=-1,T=Q.length-1;ne<T;)V(K=Q[ne+=1])&&(K=K.code(m,K.keyword,i.type))&&(k+=" "+K+" ",C)&&(d+="}");C&&(k+=" "+d+" ",d=""),i.type&&(k+=" } ",l)&&l===i.type&&!o&&(k+=" else { ",a=m.schemaPath+".type",r=m.errSchemaPath+"/type",(X=X||[]).push(k),k="",m.createErrors!==!1?(k=(k+=" { keyword: 'type' , dataPath: (dataPath || '') + "+m.errorPath+" , schemaPath: "+m.util.toQuotedString(r)+" , params: { type: '")+(n?""+l.join(","):""+l)+"' } ",m.opts.messages!==!1&&(k=(k+=" , message: 'should be ")+(n?""+l.join(","):""+l)+"' "),m.opts.verbose&&(k+=" , schema: validate.schema"+a+" , parentSchema: validate.schema"+m.schemaPath+" , data: "+f+" "),k+=" } "):k+=" {} ",b=k,k=X.pop(),!m.compositeRule&&C?m.async?k+=" throw new ValidationError(["+b+"]); ":k+=" validate.errors = ["+b+"]; return false; ":k+=" var err = "+b+";  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ",k+=" } "),C&&(k=(k+=" if (errors === ")+(G?"0":"errs_"+N)+") { ",h+="}")}}}C&&(k+=" "+h+" "),G?k=k+(H?" if (errors === 0) return data;            else throw new ValidationError(vErrors); ":" validate.errors = vErrors;  return errors === 0;       ")+" }; return validate;":k+=" var "+y+" = errors === errs_"+N+";"}return k;function F(I){for(var S=I.rules,L=0;L<S.length;L++)if(V(S[L]))return 1}function V(I){return m.schema[I.keyword]!==void 0||I.implements&&function(S){for(var L=S.implements,Z=0;Z<L.length;Z++)if(m.schema[L[Z]]!==void 0)return 1}(I)}}},7931:function(le,m,D){var U=/^[a-z_$][a-z0-9_$-]*$/i,k=D(1793),H=D(5868);function j(z,Y){j.errors=null;var G=this._validateKeyword=this._validateKeyword||this.compile(H,!0);if(G(z))return!0;if(j.errors=G.errors,Y)throw new Error("custom keyword definition is invalid: "+this.errorsText(G.errors));return!1}le.exports={add:function(z,Y){var G=this.RULES;if(G.keywords[z])throw new Error("Keyword "+z+" is already defined");if(!U.test(z))throw new Error("Keyword "+z+" is not a valid identifier");if(Y){this.validateKeyword(Y,!0);var N=Y.type;if(Array.isArray(N))for(var A=0;A<N.length;A++)R(z,N[A],Y);else R(z,N,Y);var f=Y.metaSchema;f&&(Y.$data&&this._opts.$data&&(f={anyOf:[f,{$ref:"https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"}]}),Y.validateSchema=this.compile(f,!0))}function R(y,C,d){for(var h,l=0;l<G.length;l++){var n=G[l];if(n.type==C){h=n;break}}h||G.push(h={type:C,rules:[]}),d={keyword:y,definition:d,custom:!0,code:k,implements:d.implements},h.rules.push(d),G.custom[y]=d}return G.keywords[z]=G.all[z]=!0,this},get:function(z){var Y=this.RULES.custom[z];return Y?Y.definition:this.RULES.keywords[z]||!1},remove:function(z){var Y=this.RULES;delete Y.keywords[z],delete Y.all[z],delete Y.custom[z];for(var G=0;G<Y.length;G++)for(var N=Y[G].rules,A=0;A<N.length;A++)if(N[A].keyword==z){N.splice(A,1);break}return this},validate:j}},2303:function(le){le.exports=function m(D,U){if(D===U)return!0;if(D&&U&&typeof D=="object"&&typeof U=="object"){if(D.constructor!==U.constructor)return!1;var k,H,j;if(Array.isArray(D)){if((k=D.length)!=U.length)return!1;for(H=k;H--!=0;)if(!m(D[H],U[H]))return!1}else{if(D.constructor===RegExp)return D.source===U.source&&D.flags===U.flags;if(D.valueOf!==Object.prototype.valueOf)return D.valueOf()===U.valueOf();if(D.toString!==Object.prototype.toString)return D.toString()===U.toString();if((k=(j=Object.keys(D)).length)!==Object.keys(U).length)return!1;for(H=k;H--!=0;)if(!Object.prototype.hasOwnProperty.call(U,j[H]))return!1;for(H=k;H--!=0;){var z=j[H];if(!m(D[z],U[z]))return!1}}return!0}return D!=D&&U!=U}},3508:function(le){le.exports=function(m,D){var U,k=typeof(D=typeof(D=D||{})=="function"?{cmp:D}:D).cycles=="boolean"&&D.cycles,H=D.cmp&&(U=D.cmp,function(z){return function(Y,G){return Y={key:Y,value:z[Y]},G={key:G,value:z[G]},U(Y,G)}}),j=[];return function z(Y){if((Y=Y&&Y.toJSON&&typeof Y.toJSON=="function"?Y.toJSON():Y)!==void 0){if(typeof Y=="number")return isFinite(Y)?""+Y:"null";if(typeof Y!="object")return JSON.stringify(Y);if(Array.isArray(Y)){for(A="[",f=0;f<Y.length;f++)f&&(A+=","),A+=z(Y[f])||"null";return A+"]"}if(Y===null)return"null";if(j.indexOf(Y)!==-1){if(k)return JSON.stringify("__cycle__");throw new TypeError("Converting circular structure to JSON")}for(var G=j.push(Y)-1,N=Object.keys(Y).sort(H&&H(Y)),A="",f=0;f<N.length;f++){var R=N[f],y=z(Y[R]);y&&(A&&(A+=","),A+=JSON.stringify(R)+":"+y)}return j.splice(G,1),"{"+A+"}"}}(m)}},233:function(le){le.exports=function m(N,A){function k(l){return m.insensitive&&(""+l).toLowerCase()||""+l}var H,j,C=/(^([+\-]?(?:0|[1-9]\d*)(?:\.\d*)?(?:[eE][+\-]?\d+)?)?$|^0x[0-9a-f]+$|\d+)/gi,y=/(^[ ]*|[ ]*$)/g,z=/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,Y=/^0x[0-9a-f]+$/i,G=/^0/,N=k(N).replace(y,"")||"",A=k(A).replace(y,"")||"",f=N.replace(C,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),R=A.replace(C,"\0$1\0").replace(/\0$/,"").replace(/^\0/,"").split("\0"),y=parseInt(N.match(Y),16)||f.length!==1&&N.match(z)&&Date.parse(N),C=parseInt(A.match(Y),16)||y&&A.match(z)&&Date.parse(A)||null;if(C){if(y<C)return-1;if(C<y)return 1}for(var d=0,h=Math.max(f.length,R.length);d<h;d++){if(H=!(f[d]||"").match(G)&&parseFloat(f[d])||f[d]||0,j=!(R[d]||"").match(G)&&parseFloat(R[d])||R[d]||0,isNaN(H)!==isNaN(j))return isNaN(H)?1:-1;if(typeof H!=typeof j&&(H+="",j+=""),H<j)return-1;if(j<H)return 1}return 0}},5156:function(le,m){(function(D){function U(x){return x!==null&&Object.prototype.toString.call(x)==="[object Array]"}function k(x){return x!==null&&Object.prototype.toString.call(x)==="[object Object]"}function H(x,u){if(x!==u){if(Object.prototype.toString.call(x)!==Object.prototype.toString.call(u))return!1;if(U(x)===!0){if(x.length!==u.length)return!1;for(var _=0;_<x.length;_++)if(H(x[_],u[_])===!1)return!1}else{if(k(x)!==!0)return!1;var v,$,P={};for(v in x)if(hasOwnProperty.call(x,v)){if(H(x[v],u[v])===!1)return!1;P[v]=!0}for($ in u)if(hasOwnProperty.call(u,$)&&P[$]!==!0)return!1}}return!0}function j(x){if(x===""||x===!1||x===null||U(x)&&x.length===0)return!0;if(k(x)){for(var u in x)if(x.hasOwnProperty(u))return!1;return!0}return!1}var z=typeof String.prototype.trimLeft=="function"?function(x){return x.trimLeft()}:function(x){return x.match(/^\s*(.*)/)[1]},Y={0:"number",1:"any",2:"string",3:"array",4:"object",5:"boolean",6:"expression",7:"null",8:"Array<number>",9:"Array<string>"},G="UnquotedIdentifier",N="QuotedIdentifier",A="Rbracket",f="Rparen",R="Comma",y="Colon",C="Rbrace",d="Number",h="Current",l="Expref",n="Pipe",o="Flatten",i="Star",a="Filter",r="Lbrace",e="Lbracket",t="Lparen",s="Literal",c={".":"Dot","*":i,",":R,":":y,"{":r,"}":C,"]":A,"(":t,")":f,"@":h},p={"<":!0,">":!0,"=":!0,"!":!0},g={" ":!0,"	":!0,"\n":!0};function b(x){return"0"<=x&&x<="9"||x==="-"}function w(){}w.prototype={tokenize:function(x){var u,_,v=[];for(this._current=0;this._current<x.length;)if("a"<=(P=x[this._current])&&P<="z"||"A"<=P&&P<="Z"||P==="_")$=this._current,u=this._consumeUnquotedIdentifier(x),v.push({type:G,value:u,start:$});else if(c[x[this._current]]!==void 0)v.push({type:c[x[this._current]],value:x[this._current],start:this._current}),this._current++;else if(b(x[this._current]))_=this._consumeNumber(x),v.push(_);else if(x[this._current]==="[")_=this._consumeLBracket(x),v.push(_);else if(x[this._current]==='"')$=this._current,u=this._consumeQuotedIdentifier(x),v.push({type:N,value:u,start:$});else if(x[this._current]==="'")$=this._current,u=this._consumeRawStringLiteral(x),v.push({type:s,value:u,start:$});else if(x[this._current]==="`"){var $=this._current,P=this._consumeLiteral(x);v.push({type:s,value:P,start:$})}else if(p[x[this._current]]!==void 0)v.push(this._consumeOperator(x));else if(g[x[this._current]]!==void 0)this._current++;else if(x[this._current]==="&")$=this._current,this._current++,x[this._current]==="&"?(this._current++,v.push({type:"And",value:"&&",start:$})):v.push({type:l,value:"&",start:$});else{if(x[this._current]!=="|")throw(P=new Error("Unknown character:"+x[this._current])).name="LexerError",P;$=this._current,this._current++,x[this._current]==="|"?(this._current++,v.push({type:"Or",value:"||",start:$})):v.push({type:n,value:"|",start:$})}return v},_consumeUnquotedIdentifier:function(x){var u,_=this._current;for(this._current++;this._current<x.length&&("a"<=(u=x[this._current])&&u<="z"||"A"<=u&&u<="Z"||"0"<=u&&u<="9"||u==="_");)this._current++;return x.slice(_,this._current)},_consumeQuotedIdentifier:function(x){for(var u=this._current,_=(this._current++,x.length);x[this._current]!=='"'&&this._current<_;){var v=this._current;x[v]!=="\\"||x[v+1]!=="\\"&&x[v+1]!=='"'?v++:v+=2,this._current=v}return this._current++,JSON.parse(x.slice(u,this._current))},_consumeRawStringLiteral:function(x){for(var u=this._current,_=(this._current++,x.length);x[this._current]!=="'"&&this._current<_;){var v=this._current;x[v]!=="\\"||x[v+1]!=="\\"&&x[v+1]!=="'"?v++:v+=2,this._current=v}return this._current++,x.slice(u+1,this._current-1).replace("\\'","'")},_consumeNumber:function(x){for(var u=this._current,_=(this._current++,x.length);b(x[this._current])&&this._current<_;)this._current++;var v=parseInt(x.slice(u,this._current));return{type:d,value:v,start:u}},_consumeLBracket:function(x){var u=this._current;return this._current++,x[this._current]==="?"?(this._current++,{type:a,value:"[?",start:u}):x[this._current]==="]"?(this._current++,{type:o,value:"[]",start:u}):{type:e,value:"[",start:u}},_consumeOperator:function(x){var u=this._current,_=x[u];return this._current++,_==="!"?x[this._current]==="="?(this._current++,{type:"NE",value:"!=",start:u}):{type:"Not",value:"!",start:u}:_==="<"?x[this._current]==="="?(this._current++,{type:"LTE",value:"<=",start:u}):{type:"LT",value:"<",start:u}:_===">"?x[this._current]==="="?(this._current++,{type:"GTE",value:">=",start:u}):{type:"GT",value:">",start:u}:_==="="&&x[this._current]==="="?(this._current++,{type:"EQ",value:"==",start:u}):void 0},_consumeLiteral:function(x){this._current++;for(var u=this._current,_=x.length;x[this._current]!=="`"&&this._current<_;){var v=this._current;x[v]!=="\\"||x[v+1]!=="\\"&&x[v+1]!=="`"?v++:v+=2,this._current=v}return u=(u=z(x.slice(u,this._current))).replace("\\`","`"),u=this._looksLikeJSON(u)?JSON.parse(u):JSON.parse('"'+u+'"'),this._current++,u},_looksLikeJSON:function(x){if(x==="")return!1;if(0<='[{"'.indexOf(x[0])||0<=["true","false","null"].indexOf(x))return!0;if(!(0<="-0123456789".indexOf(x[0])))return!1;try{return JSON.parse(x),!0}catch{return!1}}};var E={};function W(){}function B(x){this.runtime=x}function O(x){this._interpreter=x,this.functionTable={abs:{_func:this._functionAbs,_signature:[{types:[0]}]},avg:{_func:this._functionAvg,_signature:[{types:[8]}]},ceil:{_func:this._functionCeil,_signature:[{types:[0]}]},contains:{_func:this._functionContains,_signature:[{types:[2,3]},{types:[1]}]},ends_with:{_func:this._functionEndsWith,_signature:[{types:[2]},{types:[2]}]},floor:{_func:this._functionFloor,_signature:[{types:[0]}]},length:{_func:this._functionLength,_signature:[{types:[2,3,4]}]},map:{_func:this._functionMap,_signature:[{types:[6]},{types:[3]}]},max:{_func:this._functionMax,_signature:[{types:[8,9]}]},merge:{_func:this._functionMerge,_signature:[{types:[4],variadic:!0}]},max_by:{_func:this._functionMaxBy,_signature:[{types:[3]},{types:[6]}]},sum:{_func:this._functionSum,_signature:[{types:[8]}]},starts_with:{_func:this._functionStartsWith,_signature:[{types:[2]},{types:[2]}]},min:{_func:this._functionMin,_signature:[{types:[8,9]}]},min_by:{_func:this._functionMinBy,_signature:[{types:[3]},{types:[6]}]},type:{_func:this._functionType,_signature:[{types:[1]}]},keys:{_func:this._functionKeys,_signature:[{types:[4]}]},values:{_func:this._functionValues,_signature:[{types:[4]}]},sort:{_func:this._functionSort,_signature:[{types:[9,8]}]},sort_by:{_func:this._functionSortBy,_signature:[{types:[3]},{types:[6]}]},join:{_func:this._functionJoin,_signature:[{types:[2]},{types:[9]}]},reverse:{_func:this._functionReverse,_signature:[{types:[2,3]}]},to_array:{_func:this._functionToArray,_signature:[{types:[1]}]},to_string:{_func:this._functionToString,_signature:[{types:[1]}]},to_number:{_func:this._functionToNumber,_signature:[{types:[1]}]},not_null:{_func:this._functionNotNull,_signature:[{types:[1],variadic:!0}]}}}E.EOF=0,E[G]=0,E[N]=0,E[A]=0,E[f]=0,E[R]=0,E[C]=0,E[d]=0,E[h]=0,E[l]=0,E.Pipe=1,E.Or=2,E.And=3,E.EQ=5,E.GT=5,E.LT=5,E.GTE=5,E.LTE=5,E.NE=5,E[o]=9,E.Star=20,E[a]=21,E.Dot=40,E.Not=45,E[r]=50,E[e]=55,E[t]=60,W.prototype={parse:function(_){this._loadTokens(_),this.index=0;var u,_=this.expression(0);if(this._lookahead(0)!=="EOF")throw u=this._lookaheadToken(0),(u=new Error("Unexpected token type: "+u.type+", value: "+u.value)).name="ParserError",u;return _},_loadTokens:function(x){var u=new w().tokenize(x);u.push({type:"EOF",value:"",start:x.length}),this.tokens=u},expression:function(x){for(var u=this._lookaheadToken(0),_=(this._advance(),this.nud(u)),v=this._lookahead(0);x<E[v];)this._advance(),_=this.led(v,_),v=this._lookahead(0);return _},_lookahead:function(x){return this.tokens[this.index+x].type},_lookaheadToken:function(x){return this.tokens[this.index+x]},_advance:function(){this.index++},nud:function(x){var u,_;switch(x.type){case s:return{type:"Literal",value:x.value};case G:return{type:"Field",name:x.value};case N:var v={type:"Field",name:x.value};if(this._lookahead(0)===t)throw new Error("Quoted identifier not allowed for function names.");return v;case"Not":return{type:"NotExpression",children:[u=this.expression(E.Not)]};case i:return u=null,{type:"ValueProjection",children:[{type:"Identity"},u=this._lookahead(0)===A?{type:"Identity"}:this._parseProjectionRHS(E.Star)]};case a:return this.led(x.type,{type:"Identity"});case r:return this._parseMultiselectHash();case o:return{type:"Projection",children:[{type:o,children:[{type:"Identity"}]},u=this._parseProjectionRHS(E.Flatten)]};case e:return this._lookahead(0)===d||this._lookahead(0)===y?(u=this._parseIndexExpression(),this._projectIfSlice({type:"Identity"},u)):this._lookahead(0)===i&&this._lookahead(1)===A?(this._advance(),this._advance(),{type:"Projection",children:[{type:"Identity"},u=this._parseProjectionRHS(E.Star)]}):this._parseMultiselectList();case h:return{type:h};case l:return{type:"ExpressionReference",children:[_=this.expression(E.Expref)]};case t:for(var $=[];this._lookahead(0)!==f;)this._lookahead(0)===h?(_={type:h},this._advance()):_=this.expression(0),$.push(_);return this._match(f),$[0];default:this._errorToken(x)}},led:function(x,u){var _;switch(x){case"Dot":var v=E.Dot;return this._lookahead(0)!==i?{type:"Subexpression",children:[u,_=this._parseDotRHS(v)]}:(this._advance(),{type:"ValueProjection",children:[u,_=this._parseProjectionRHS(v)]});case n:return _=this.expression(E.Pipe),{type:n,children:[u,_]};case"Or":return{type:"OrExpression",children:[u,_=this.expression(E.Or)]};case"And":return{type:"AndExpression",children:[u,_=this.expression(E.And)]};case t:for(var $,v=u.name,P=[];this._lookahead(0)!==f;)this._lookahead(0)===h?($={type:h},this._advance()):$=this.expression(0),this._lookahead(0)===R&&this._match(R),P.push($);return this._match(f),{type:"Function",name:v,children:P};case a:return v=this.expression(0),this._match(A),{type:"FilterProjection",children:[u,_=this._lookahead(0)===o?{type:"Identity"}:this._parseProjectionRHS(E.Filter),v]};case o:return{type:"Projection",children:[{type:o,children:[u]},this._parseProjectionRHS(E.Flatten)]};case"EQ":case"NE":case"GT":case"GTE":case"LT":case"LTE":return this._parseComparator(u,x);case e:return v=this._lookaheadToken(0),v.type===d||v.type===y?(_=this._parseIndexExpression(),this._projectIfSlice(u,_)):(this._match(i),this._match(A),{type:"Projection",children:[u,_=this._parseProjectionRHS(E.Star)]});default:this._errorToken(this._lookaheadToken(0))}},_match:function(x){var u;if(this._lookahead(0)!==x)throw u=this._lookaheadToken(0),(x=new Error("Expected "+x+", got: "+u.type)).name="ParserError",x;this._advance()},_errorToken:function(x){throw x=new Error("Invalid token ("+x.type+'): "'+x.value+'"'),x.name="ParserError",x},_parseIndexExpression:function(){var x;return this._lookahead(0)===y||this._lookahead(1)===y?this._parseSliceExpression():(x={type:"Index",value:this._lookaheadToken(0).value},this._advance(),this._match(A),x)},_projectIfSlice:function(x,u){return x={type:"IndexExpression",children:[x,u]},u.type==="Slice"?{type:"Projection",children:[x,this._parseProjectionRHS(E.Star)]}:x},_parseSliceExpression:function(){for(var x,u=[null,null,null],_=0,v=this._lookahead(0);v!==A&&_<3;){if(v===y)_++;else{if(v!==d)throw x=this._lookahead(0),(x=new Error("Syntax error, unexpected token: "+x.value+"("+x.type+")")).name="Parsererror",x;u[_]=this._lookaheadToken(0).value}this._advance(),v=this._lookahead(0)}return this._match(A),{type:"Slice",children:u}},_parseComparator:function(x,u){return{type:"Comparator",name:u,children:[x,this.expression(E[u])]}},_parseDotRHS:function(x){var u=this._lookahead(0);return 0<=[G,N,i].indexOf(u)?this.expression(x):u===e?(this._match(e),this._parseMultiselectList()):u===r?(this._match(r),this._parseMultiselectHash()):void 0},_parseProjectionRHS:function(x){var u,_;if(E[this._lookahead(0)]<10)u={type:"Identity"};else if(this._lookahead(0)===e)u=this.expression(x);else if(this._lookahead(0)===a)u=this.expression(x);else{if(this._lookahead(0)!=="Dot")throw _=this._lookaheadToken(0),(_=new Error("Sytanx error, unexpected token: "+_.value+"("+_.type+")")).name="ParserError",_;this._match("Dot"),u=this._parseDotRHS(x)}return u},_parseMultiselectList:function(){for(var x=[];this._lookahead(0)!==A;){var u=this.expression(0);if(x.push(u),this._lookahead(0)===R&&(this._match(R),this._lookahead(0)===A))throw new Error("Unexpected token Rbracket")}return this._match(A),{type:"MultiSelectList",children:x}},_parseMultiselectHash:function(){for(var x,u,_=[],v=[G,N];;){if(x=this._lookaheadToken(0),v.indexOf(x.type)<0)throw new Error("Expecting an identifier token, got: "+x.type);if(x=x.value,this._advance(),this._match(y),u=this.expression(0),_.push({type:"KeyValuePair",name:x,value:u}),this._lookahead(0)===R)this._match(R);else if(this._lookahead(0)===C){this._match(C);break}}return{type:"MultiSelectHash",children:_}}},B.prototype={search:function(x,u){return this.visit(x,u)},visit:function(x,u){var _,v,$,P,M,X;switch(x.type){case"Field":return u!==null&&k(u)?(Q=u[x.name])===void 0?null:Q:null;case"Subexpression":for(F=this.visit(x.children[0],u),L=1;L<x.children.length;L++)if((F=this.visit(x.children[1],F))===null)return null;return F;case"IndexExpression":return M=this.visit(x.children[0],u),this.visit(x.children[1],M);case"Index":return U(u)?(F=u[Q=(Q=x.value)<0?u.length+Q:Q])===void 0?null:F:null;case"Slice":if(!U(u))return null;var Q=x.children.slice(0),Q=this.computeSliceParams(u.length,Q),K=Q[0],ne=Q[1],T=Q[2],F=[];if(0<T)for(L=K;L<ne;L+=T)F.push(u[L]);else for(L=K;ne<L;L+=T)F.push(u[L]);return F;case"Projection":var V=this.visit(x.children[0],u);if(!U(V))return null;for(I=[],L=0;L<V.length;L++)(v=this.visit(x.children[1],V[L]))!==null&&I.push(v);return I;case"ValueProjection":if(!k(V=this.visit(x.children[0],u)))return null;for(var I=[],S=function(xe){for(var be=Object.keys(xe),Ae=[],we=0;we<be.length;we++)Ae.push(xe[be[we]]);return Ae}(V),L=0;L<S.length;L++)(v=this.visit(x.children[1],S[L]))!==null&&I.push(v);return I;case"FilterProjection":if(!U(V=this.visit(x.children[0],u)))return null;var Z=[],J=[];for(L=0;L<V.length;L++)j(_=this.visit(x.children[2],V[L]))||Z.push(V[L]);for(var re=0;re<Z.length;re++)(v=this.visit(x.children[1],Z[re]))!==null&&J.push(v);return J;case"Comparator":switch($=this.visit(x.children[0],u),P=this.visit(x.children[1],u),x.name){case"EQ":F=H($,P);break;case"NE":F=!H($,P);break;case"GT":F=P<$;break;case"GTE":F=P<=$;break;case"LT":F=$<P;break;case"LTE":F=$<=P;break;default:throw new Error("Unknown comparator: "+x.name)}return F;case o:var pe=this.visit(x.children[0],u);if(!U(pe))return null;var me=[];for(L=0;L<pe.length;L++)U(v=pe[L])?me.push.apply(me,v):me.push(v);return me;case"Identity":return u;case"MultiSelectList":if(u===null)return null;for(I=[],L=0;L<x.children.length;L++)I.push(this.visit(x.children[L],u));return I;case"MultiSelectHash":if(u===null)return null;for(I={},L=0;L<x.children.length;L++)I[(X=x.children[L]).name]=this.visit(X.value,u);return I;case"OrExpression":return _=j(_=this.visit(x.children[0],u))?this.visit(x.children[1],u):_;case"AndExpression":return j($=this.visit(x.children[0],u))===!0?$:this.visit(x.children[1],u);case"NotExpression":return j($=this.visit(x.children[0],u));case"Literal":return x.value;case n:return M=this.visit(x.children[0],u),this.visit(x.children[1],M);case h:return u;case"Function":var ye=[];for(L=0;L<x.children.length;L++)ye.push(this.visit(x.children[L],u));return this.runtime.callFunction(x.name,ye);case"ExpressionReference":return Q=x.children[0],Q.jmespathType=l,Q;default:throw new Error("Unknown node type: "+x.type)}},computeSliceParams:function(x,_){var P=_[0],M=_[1],_=_[2],v=[null,null,null];if(_===null)_=1;else if(_===0)throw($=new Error("Invalid slice, step cannot be 0")).name="RuntimeError",$;var $=_<0,P=P===null?$?x-1:0:this.capSliceRange(x,P,_),M=M===null?$?-1:x:this.capSliceRange(x,M,_);return v[0]=P,v[1]=M,v[2]=_,v},capSliceRange:function(x,u,_){return u<0?(u+=x)<0&&(u=_<0?-1:0):x<=u&&(u=_<0?x-1:x),u}},O.prototype={callFunction:function(x,u){var _=this.functionTable[x];if(_===void 0)throw new Error("Unknown function: "+x+"()");return this._validateArgs(x,u,_._signature),_._func.call(this,u)},_validateArgs:function(x,u,_){var v;if(_[_.length-1].variadic){if(u.length<_.length)throw v=_.length===1?" argument":" arguments",new Error("ArgumentError: "+x+"() takes at least"+_.length+v+" but received "+u.length)}else if(u.length!==_.length)throw v=_.length===1?" argument":" arguments",new Error("ArgumentError: "+x+"() takes "+_.length+v+" but received "+u.length);for(var $=0;$<_.length;$++){for(var P,M=!1,X=_[$].types,Q=this._getTypeName(u[$]),K=0;K<X.length;K++)if(this._typeMatches(Q,X[K],u[$])){M=!0;break}if(!M)throw P=X.map(function(ne){return Y[ne]}).join(","),new Error("TypeError: "+x+"() expected argument "+($+1)+" to be type "+P+" but received type "+Y[Q]+" instead.")}},_typeMatches:function(x,u,_){if(u===1)return!0;if(u!==9&&u!==8&&u!==3)return x===u;if(u===3)return x===3;if(x===3){var v;u===8?v=0:u===9&&(v=2);for(var $=0;$<_.length;$++)if(!this._typeMatches(this._getTypeName(_[$]),v,_[$]))return!1;return!0}},_getTypeName:function(x){switch(Object.prototype.toString.call(x)){case"[object String]":return 2;case"[object Number]":return 0;case"[object Array]":return 3;case"[object Boolean]":return 5;case"[object Null]":return 7;case"[object Object]":return x.jmespathType===l?6:4}},_functionStartsWith:function(x){return x[0].lastIndexOf(x[1])===0},_functionEndsWith:function(_){var u=_[0],_=_[1];return u.indexOf(_,u.length-_.length)!==-1},_functionReverse:function(x){var u;if(this._getTypeName(x[0])!==2)return(u=x[0].slice(0)).reverse(),u;for(var _=x[0],v="",$=_.length-1;0<=$;$--)v+=_[$];return v},_functionAbs:function(x){return Math.abs(x[0])},_functionCeil:function(x){return Math.ceil(x[0])},_functionAvg:function(x){for(var u=0,_=x[0],v=0;v<_.length;v++)u+=_[v];return u/_.length},_functionContains:function(x){return 0<=x[0].indexOf(x[1])},_functionFloor:function(x){return Math.floor(x[0])},_functionLength:function(x){return(k(x[0])?Object.keys(x[0]):x[0]).length},_functionMap:function(x){for(var u=[],_=this._interpreter,v=x[0],$=x[1],P=0;P<$.length;P++)u.push(_.visit(v,$[P]));return u},_functionMerge:function(x){for(var u={},_=0;_<x.length;_++){var v,$=x[_];for(v in $)u[v]=$[v]}return u},_functionMax:function(x){if(0<x[0].length){if(this._getTypeName(x[0][0])===0)return Math.max.apply(Math,x[0]);for(var u=x[0],_=u[0],v=1;v<u.length;v++)_.localeCompare(u[v])<0&&(_=u[v]);return _}return null},_functionMin:function(x){if(0<x[0].length){if(this._getTypeName(x[0][0])===0)return Math.min.apply(Math,x[0]);for(var u=x[0],_=u[0],v=1;v<u.length;v++)u[v].localeCompare(_)<0&&(_=u[v]);return _}return null},_functionSum:function(x){for(var u=0,_=x[0],v=0;v<_.length;v++)u+=_[v];return u},_functionType:function(x){switch(this._getTypeName(x[0])){case 0:return"number";case 2:return"string";case 3:return"array";case 4:return"object";case 5:return"boolean";case 6:return"expref";case 7:return"null"}},_functionKeys:function(x){return Object.keys(x[0])},_functionValues:function(x){for(var u=x[0],_=Object.keys(u),v=[],$=0;$<_.length;$++)v.push(u[_[$]]);return v},_functionJoin:function(x){var u=x[0];return x[1].join(u)},_functionToArray:function(x){return this._getTypeName(x[0])===3?x[0]:[x[0]]},_functionToString:function(x){return this._getTypeName(x[0])===2?x[0]:JSON.stringify(x[0])},_functionToNumber:function(x){var u=this._getTypeName(x[0]);return u===0?x[0]:u!==2||(u=+x[0],isNaN(u))?null:u},_functionNotNull:function(x){for(var u=0;u<x.length;u++)if(this._getTypeName(x[u])!==7)return x[u];return null},_functionSort:function(x){return x=x[0].slice(0),x.sort(),x},_functionSortBy:function(x){var u=x[0].slice(0);if(u.length!==0){var _=this._interpreter,v=x[1],$=this._getTypeName(_.visit(v,u[0]));if([0,2].indexOf($)<0)throw new Error("TypeError");for(var P=this,M=[],X=0;X<u.length;X++)M.push([X,u[X]]);M.sort(function(K,ne){var T=_.visit(v,K[1]),F=_.visit(v,ne[1]);if(P._getTypeName(T)!==$)throw new Error("TypeError: expected "+$+", received "+P._getTypeName(T));if(P._getTypeName(F)!==$)throw new Error("TypeError: expected "+$+", received "+P._getTypeName(F));return F<T?1:T<F?-1:K[0]-ne[0]});for(var Q=0;Q<M.length;Q++)u[Q]=M[Q][1]}return u},_functionMaxBy:function(x){for(var u,_,v=x[1],$=x[0],P=this.createKeyFunction(v,[0,2]),M=-1/0,X=0;X<$.length;X++)M<(_=P($[X]))&&(M=_,u=$[X]);return u},_functionMinBy:function(x){for(var u,_,v=x[1],$=x[0],P=this.createKeyFunction(v,[0,2]),M=1/0,X=0;X<$.length;X++)(_=P($[X]))<M&&(M=_,u=$[X]);return u},createKeyFunction:function(x,u){var _=this,v=this._interpreter;return function(M){var P,M=v.visit(x,M);if(u.indexOf(_._getTypeName(M))<0)throw P="TypeError: expected one of "+u+", received "+_._getTypeName(M),new Error(P);return M}}},D.tokenize=function(x){return new w().tokenize(x)},D.compile=function(x){return new W().parse(x)},D.search=function(x,u){var _=new W,v=new B($=new O),$=($._interpreter=v,_.parse(u));return v.search($,x)},D.strictDeepEqual=H})(m)},500:function(le){var m=le.exports=function(U,k,H){typeof k=="function"&&(H=k,k={}),function j(z,Y,G,N,A,f,R,y,C,d){if(N&&typeof N=="object"&&!Array.isArray(N)){for(var h in Y(N,A,f,R,y,C,d),N){var l=N[h];if(Array.isArray(l)){if(h in m.arrayKeywords)for(var n=0;n<l.length;n++)j(z,Y,G,l[n],A+"/"+h+"/"+n,f,A,h,N,n)}else if(h in m.propsKeywords){if(l&&typeof l=="object")for(var o in l)j(z,Y,G,l[o],A+"/"+h+"/"+D(o),f,A,h,N,o)}else(h in m.keywords||z.allKeys&&!(h in m.skipKeywords))&&j(z,Y,G,l,A+"/"+h,f,A,h,N)}G(N,A,f,R,y,C,d)}}(k,typeof(H=k.cb||H)=="function"?H:H.pre||function(){},H.post||function(){},U,"",U)};function D(U){return U.replace(/~/g,"~0").replace(/\//g,"~1")}m.keywords={additionalItems:!0,items:!0,contains:!0,additionalProperties:!0,propertyNames:!0,not:!0},m.arrayKeywords={items:!0,allOf:!0,anyOf:!0,oneOf:!0},m.propsKeywords={definitions:!0,properties:!0,patternProperties:!0,dependencies:!0},m.skipKeywords={default:!0,enum:!0,const:!0,required:!0,maximum:!0,minimum:!0,exclusiveMaximum:!0,exclusiveMinimum:!0,multipleOf:!0,maxLength:!0,minLength:!0,pattern:!0,format:!0,maxItems:!0,minItems:!0,uniqueItems:!0,maxProperties:!0,minProperties:!0}},7026:function(le,m){var D={b:"\b",f:"\f",n:`
`,r:"\r",t:"	",'"':'"',"/":"/","\\":"\\"},U="a".charCodeAt(),k=(m.parse=function(d,h,l){var n={},o=0,i=0,a=0,r=l&&l.bigint&&typeof BigInt<"u";return{data:e("",!0),pointers:n};function e(u,_){t(),w(u,"value");var v,$=p();switch($){case"t":c("rue"),v=!0;break;case"f":c("alse"),v=!1;break;case"n":c("ull"),v=null;break;case'"':v=s();break;case"[":v=function(P){t();var M=[],X=0;if(p()!="]")for(g();;){M.push(e(P+"/"+X)),t();var Q=p();if(Q=="]")break;Q!=","&&O(),t(),X++}return M}(u);break;case"{":v=function(P){t();var M={};if(p()!="}")for(g();;){var K=W(),X=(p()!='"'&&O(),s()),Q=P+"/"+C(X),K=(E(Q,"key",K),w(Q,"keyEnd"),t(),p()!=":"&&O(),t(),M[X]=e(Q),t(),p());if(K=="}")break;K!=","&&O(),t()}return M}(u);break;default:g(),0<="-0123456789".indexOf($)?v=function(){var P="",M=!0;d[a]=="-"&&(P+=p()),P+=(d[a]=="0"?p:b)(),d[a]=="."&&(P+=p()+b(),M=!1),d[a]!="e"&&d[a]!="E"||(P+=p(),d[a]!="+"&&d[a]!="-"||(P+=p()),P+=b(),M=!1);var X=+P;return r&&M&&(X>Number.MAX_SAFE_INTEGER||X<Number.MIN_SAFE_INTEGER)?BigInt(P):X}():B()}return w(u,"valueEnd"),t(),_&&a<d.length&&B(),v}function t(){e:for(;a<d.length;){switch(d[a]){case" ":i++;break;case"	":i+=4;break;case"\r":i=0;break;case`
`:i=0,o++;break;default:break e}a++}}function s(){for(var u,_="";(u=p())!='"';)u=="\\"?(u=p())in D?_+=D[u]:u=="u"?_+=function(){for(var v=4,$=0;v--;){$<<=4;var P=p().toLowerCase();"a"<=P&&P<="f"?$+=P.charCodeAt()-U+10:"0"<=P&&P<="9"?$+=+P:O()}return String.fromCharCode($)}():O():_+=u;return _}function c(u){for(var _=0;_<u.length;_++)p()!==u[_]&&O()}function p(){x();var u=d[a];return a++,i++,u}function g(){a--,i--}function b(){for(var u="";"0"<=d[a]&&d[a]<="9";)u+=p();if(u.length)return u;x(),B()}function w(u,_){E(u,_,W())}function E(u,_,v){n[u]=n[u]||{},n[u][_]=v}function W(){return{line:o,column:i,pos:a}}function B(){throw new SyntaxError("Unexpected token "+d[a]+" in JSON at position "+a)}function O(){g(),B()}function x(){if(a>=d.length)throw new SyntaxError("Unexpected end of JSON input")}},m.stringify=function(d,h,l){if(H(d)){var n=0;switch(typeof(i=typeof l=="object"?l.space:l)){case"number":var o=10<i?10:i<0?0:Math.floor(i),i=o&&B(o," "),a=o,r=o;break;case"string":i=i.slice(0,10);for(var e=r=a=0;e<i.length;e++){switch(i[e]){case" ":r++;break;case"	":r+=4;break;case"\r":r=0;break;case`
`:r=0,n++;break;default:throw new Error("whitespace characters not allowed in JSON")}a++}break;default:i=void 0}var t="",s={},c=0,p=0,g=0,b=l&&l.es6&&typeof Map=="function";return function O(x,u,_){switch(W(_,"value"),typeof x){case"number":case"bigint":case"boolean":w(""+x);break;case"string":w(f(x));break;case"object":x===null?w("null"):typeof x.toJSON=="function"?w(f(x.toJSON())):Array.isArray(x)?v():b?x.constructor.BYTES_PER_ELEMENT?v():x instanceof Map?P():x instanceof Set?P(!0):$():$()}W(_,"valueEnd");function v(){if(x.length){w("[");for(var M=u+1,X=0;X<x.length;X++){X&&w(","),E(M);var Q=H(x[X])?x[X]:null,K=_+"/"+X;O(Q,M,K)}E(u),w("]")}else w("[]")}function $(){var M=Object.keys(x);if(M.length){w("{");for(var X=u+1,Q=0;Q<M.length;Q++){var K,ne=M[Q],T=x[ne];H(T)&&(Q&&w(","),K=_+"/"+C(ne),E(X),W(K,"key"),w(f(ne)),W(K,"keyEnd"),w(":"),i&&w(" "),O(T,X,K))}E(u),w("}")}else w("{}")}function P(M){if(x.size){w("{");for(var X=u+1,Q=!0,K=x.entries(),ne=K.next();!ne.done;){var T,V=ne.value,F=V[0],V=!!M||V[1];H(V)&&(Q||w(","),Q=!1,T=_+"/"+C(F),E(X),W(T,"key"),w(f(F)),W(T,"keyEnd"),w(":"),i&&w(" "),O(V,X,T)),ne=K.next()}E(u),w("}")}else w("{}")}}(d,0,""),{json:t,pointers:s}}function w(O){p+=O.length,g+=O.length,t+=O}function E(O){if(i){for(t+=`
`+B(O,i),c++,p=0;O--;)n?(c+=n,p=r):p+=r,g+=a;g+=1}}function W(O,x){s[O]=s[O]||{},s[O][x]={line:c,column:p,pos:g}}function B(O,x){return Array(O+1).join(x)}},["number","bigint","boolean","string","object"]);function H(d){return 0<=k.indexOf(typeof d)}var j=/"|\\/g,z=/[\b]/g,Y=/\f/g,G=/\n/g,N=/\r/g,A=/\t/g;function f(d){return'"'+(d=d.replace(j,"\\$&").replace(Y,"\\f").replace(z,"\\b").replace(G,"\\n").replace(N,"\\r").replace(A,"\\t"))+'"'}var R=/~/g,y=/\//g;function C(d){return d.replace(R,"~0").replace(y,"~1")}},483:function(le,m){var D,U;(function(){U=[],(U=typeof(D=function(){function k(l){return typeof Node=="object"?l instanceof Node:l&&typeof l=="object"&&typeof l.nodeType=="number"}function H(l){return typeof l=="string"}function j(){var l=[];return{watch:l.push.bind(l),trigger:function(n,o){for(var i=!0,a={detail:o,preventDefault:function(){i=!1}},r=0;r<l.length;r++)l[r](n,a);return i}}}function z(l){return window.getComputedStyle(l).display==="none"}function Y(l){this.elem=l}function G(l,n){return Y.make(l("parent")).clazz("pico-overlay").clazz(l("overlayClass","")).stylize({display:"none",position:"fixed",top:"0px",left:"0px",height:"100%",width:"100%",zIndex:1e4}).stylize(l("overlayStyles",{opacity:.5,background:"#000"})).onClick(function(){l("overlayClose",!0)&&n()})}Y.make=function(l,n){typeof l=="string"&&(l=document.querySelector(l));var o=document.createElement(n||"div");return(l||document.body).appendChild(o),new Y(o)},Y.prototype={child:function(l){return Y.make(this.elem,l)},stylize:function(l){l=l||{},typeof l.opacity<"u"&&(l.filter="alpha(opacity="+l.opacity*100+")");for(var n in l)l.hasOwnProperty(n)&&(this.elem.style[n]=l[n]);return this},clazz:function(l){return this.elem.className+=" "+l,this},html:function(l){return k(l)?this.elem.appendChild(l):this.elem.innerHTML=l,this},onClick:function(l){return this.elem.addEventListener("click",l),this},destroy:function(){this.elem.parentNode.removeChild(this.elem)},hide:function(){this.elem.style.display="none"},show:function(){this.elem.style.display="block"},attr:function(l,n){return n!==void 0&&this.elem.setAttribute(l,n),this},anyAncestor:function(l){for(var n=this.elem;n;){if(l(new Y(n)))return!0;n=n.parentNode}return!1},isVisible:function(){return!z(this.elem)}};var N=1;function A(l,n){var o=l("width","auto");typeof o=="number"&&(o=""+o+"px");var i=l("modalId","pico-"+N++),a=Y.make(l("parent")).clazz("pico-content").clazz(l("modalClass","")).stylize({display:"none",position:"fixed",zIndex:10001,left:"50%",top:"38.1966%",maxHeight:"90%",boxSizing:"border-box",width:o,"-ms-transform":"translate(-50%,-38.1966%)","-moz-transform":"translate(-50%,-38.1966%)","-webkit-transform":"translate(-50%,-38.1966%)","-o-transform":"translate(-50%,-38.1966%)",transform:"translate(-50%,-38.1966%)"}).stylize(l("modalStyles",{overflow:"auto",backgroundColor:"white",padding:"20px",borderRadius:"5px"})).html(l("content")).attr("id",i).attr("role","dialog").attr("aria-labelledby",l("ariaLabelledBy")).attr("aria-describedby",l("ariaDescribedBy",i)).onClick(function(r){var e=new Y(r.target).anyAncestor(function(t){return/\bpico-close\b/.test(t.elem.className)});e&&n()});return a}function f(l,n){if(n("closeButton",!0))return l.child("button").html(n("closeHtml","&#xD7;")).clazz("pico-close").clazz(n("closeClass","")).stylize(n("closeStyles",{borderRadius:"2px",border:0,padding:0,cursor:"pointer",height:"15px",width:"15px",position:"absolute",top:"5px",right:"5px",fontSize:"16px",textAlign:"center",lineHeight:"15px",background:"#CCC"})).attr("aria-label",n("close-label","Close"))}function R(l){return function(){return l().elem}}var y=j(),C=j();function d(l,n){function o(t,s){var c=t.msMatchesSelector||t.webkitMatchesSelector||t.matches;return c.call(t,s)}function i(t){return z(t)||o(t,":disabled")||t.hasAttribute("contenteditable")?!1:t.hasAttribute("tabindex")||o(t,"input,select,textarea,button,a[href],area[href],iframe")}function a(t){for(var s=t.getElementsByTagName("*"),c=0;c<s.length;c++)if(i(s[c]))return s[c]}function r(t){for(var s=t.getElementsByTagName("*"),c=s.length;c--;)if(i(s[c]))return s[c]}var e;l.beforeShow(function(){e=document.activeElement}),l.afterShow(function(){if(n()){var s=a(l.modalElem());s&&s.focus()}}),l.afterClose(function(){n()&&e&&e.focus(),e=null}),C.watch(function(s){if(n()&&l.isVisible()){var c=a(l.modalElem()),p=r(l.modalElem()),g=s.shiftKey?c:p;g===document.activeElement&&((s.shiftKey?p:c).focus(),s.preventDefault())}})}function h(l,n){var o,i=new Y(document.body);l.beforeShow(function(){o=i.elem.style.overflow,n()&&i.stylize({overflow:"hidden"})}),l.afterClose(function(){i.stylize({overflow:o})})}return document.documentElement.addEventListener("keydown",function(n){var o=n.which||n.keyCode;o===27?y.trigger():o===9&&C.trigger(n)}),function(n){(H(n)||k(n))&&(n={content:n});var o=j(),i=j(),a=j(),r=j(),e=j();function t(O,x){var u=n[O];return typeof u=="function"&&(u=u(x)),u===void 0?x:u}var s=B.bind(window,"modal"),c=B.bind(window,"overlay"),p=B.bind(window,"close"),g;function b(O){c().hide(),s().hide(),e.trigger(g,O)}function w(O){r.trigger(g,O)&&b(O)}function E(O){return function(){return O.apply(this,arguments),g}}var W;function B(O,x){if(!W){var u=A(t,w);W={modal:u,overlay:G(t,w),close:f(u,t)},o.trigger(g,x)}return W[O]}return g={modalElem:R(s),closeElem:R(p),overlayElem:R(c),buildDom:E(B.bind(null,null)),isVisible:function(){return!!(W&&s&&s().isVisible())},show:function(O){return i.trigger(g,O)&&(c().show(),p(),s().show(),a.trigger(g,O)),this},close:E(w),forceClose:E(b),destroy:function(){s().destroy(),c().destroy(),c=s=p=void 0},options:function(O){Object.keys(O).map(function(x){n[x]=O[x]})},afterCreate:E(o.watch),beforeShow:E(i.watch),afterShow:E(a.watch),beforeClose:E(r.watch),afterClose:E(e.watch)},d(g,t.bind(null,"focus",!0)),h(g,t.bind(null,"bodyOverflow",!0)),y.watch(function(){t("escCloses",!0)&&g.isVisible()&&g.close()}),g}})=="function"?D.apply(m,U):D)!==void 0&&(le.exports=U)})()},7533:function(le,m){/** @license URI.js v4.4.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js */(function(D){function U(){for(var se=arguments.length,q=Array(se),oe=0;oe<se;oe++)q[oe]=arguments[oe];if(q.length>1){q[0]=q[0].slice(0,-1);for(var de=q.length-1,ue=1;ue<de;++ue)q[ue]=q[ue].slice(1,-1);return q[de]=q[de].slice(1),q.join("")}else return q[0]}function k(se){return"(?:"+se+")"}function H(se){return se===void 0?"undefined":se===null?"null":Object.prototype.toString.call(se).split(" ").pop().split("]").shift().toLowerCase()}function j(se){return se.toUpperCase()}function z(se){return se!=null?se instanceof Array?se:typeof se.length!="number"||se.split||se.setInterval||se.call?[se]:Array.prototype.slice.call(se):[]}function Y(se,q){var oe=se;if(q)for(var de in q)oe[de]=q[de];return oe}function G(se){var q="[A-Za-z]",oe="[0-9]",de=U(oe,"[A-Fa-f]"),ue=k(k("%[EFef]"+de+"%"+de+de+"%"+de+de)+"|"+k("%[89A-Fa-f]"+de+"%"+de+de)+"|"+k("%"+de+de)),Ee="[\\:\\/\\?\\#\\[\\]\\@]",_e="[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",He=U(Ee,_e),Ge=se?"[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]":"[]",Oe=se?"[\\uE000-\\uF8FF]":"[]",Me=U(q,oe,"[\\-\\.\\_\\~]",Ge);k(q+U(q,oe,"[\\+\\-\\.]")+"*"),k(k(ue+"|"+U(Me,_e,"[\\:]"))+"*");var Ve=k(k("25[0-5]")+"|"+k("2[0-4]"+oe)+"|"+k("1"+oe+oe)+"|"+k("0?[1-9]"+oe)+"|0?0?"+oe),Ke=k(Ve+"\\."+Ve+"\\."+Ve+"\\."+Ve),Be=k(de+"{1,4}"),Ze=k(k(Be+"\\:"+Be)+"|"+Ke),je=k(k(Be+"\\:")+"{6}"+Ze),De=k("\\:\\:"+k(Be+"\\:")+"{5}"+Ze),tt=k(k(Be)+"?\\:\\:"+k(Be+"\\:")+"{4}"+Ze),Ue=k(k(k(Be+"\\:")+"{0,1}"+Be)+"?\\:\\:"+k(Be+"\\:")+"{3}"+Ze),Qe=k(k(k(Be+"\\:")+"{0,2}"+Be)+"?\\:\\:"+k(Be+"\\:")+"{2}"+Ze),ot=k(k(k(Be+"\\:")+"{0,3}"+Be)+"?\\:\\:"+Be+"\\:"+Ze),nt=k(k(k(Be+"\\:")+"{0,4}"+Be)+"?\\:\\:"+Ze),Je=k(k(k(Be+"\\:")+"{0,5}"+Be)+"?\\:\\:"+Be),qe=k(k(k(Be+"\\:")+"{0,6}"+Be)+"?\\:\\:"),it=k([je,De,tt,Ue,Qe,ot,nt,Je,qe].join("|")),et=k(k(Me+"|"+ue)+"+");k("[vV]"+de+"+\\."+U(Me,_e,"[\\:]")+"+"),k(k(ue+"|"+U(Me,_e))+"*");var rt=k(ue+"|"+U(Me,_e,"[\\:\\@]"));return k(k(ue+"|"+U(Me,_e,"[\\@]"))+"+"),k(k(rt+"|"+U("[\\/\\?]",Oe))+"*"),{NOT_SCHEME:new RegExp(U("[^]",q,oe,"[\\+\\-\\.]"),"g"),NOT_USERINFO:new RegExp(U("[^\\%\\:]",Me,_e),"g"),NOT_HOST:new RegExp(U("[^\\%\\[\\]\\:]",Me,_e),"g"),NOT_PATH:new RegExp(U("[^\\%\\/\\:\\@]",Me,_e),"g"),NOT_PATH_NOSCHEME:new RegExp(U("[^\\%\\/\\@]",Me,_e),"g"),NOT_QUERY:new RegExp(U("[^\\%]",Me,_e,"[\\:\\@\\/\\?]",Oe),"g"),NOT_FRAGMENT:new RegExp(U("[^\\%]",Me,_e,"[\\:\\@\\/\\?]"),"g"),ESCAPE:new RegExp(U("[^]",Me,_e),"g"),UNRESERVED:new RegExp(Me,"g"),OTHER_CHARS:new RegExp(U("[^\\%]",Me,He),"g"),PCT_ENCODED:new RegExp(ue,"g"),IPV4ADDRESS:new RegExp("^("+Ke+")$"),IPV6ADDRESS:new RegExp("^\\[?("+it+")"+k(k("\\%25|\\%(?!"+de+"{2})")+"("+et+")")+"?\\]?$")}}var N=G(!1),A=G(!0),f=function(){function se(q,oe){var de=[],ue=!0,Ee=!1,_e=void 0;try{for(var He=q[Symbol.iterator](),Ge;!(ue=(Ge=He.next()).done)&&(de.push(Ge.value),!(oe&&de.length===oe));ue=!0);}catch(Oe){Ee=!0,_e=Oe}finally{try{!ue&&He.return&&He.return()}finally{if(Ee)throw _e}}return de}return function(q,oe){if(Array.isArray(q))return q;if(Symbol.iterator in Object(q))return se(q,oe);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),R=function(se){if(Array.isArray(se)){for(var q=0,oe=Array(se.length);q<se.length;q++)oe[q]=se[q];return oe}else return Array.from(se)},y=2147483647,C=36,d=1,h=26,l=38,n=700,o=72,i=128,a="-",r=/^xn--/,e=/[^\0-\x7E]/,t=/[\x2E\u3002\uFF0E\uFF61]/g,s={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},c=C-d,p=Math.floor,g=String.fromCharCode;function b(se){throw new RangeError(s[se])}function w(se,q){for(var oe=[],de=se.length;de--;)oe[de]=q(se[de]);return oe}function E(se,q){var oe=se.split("@"),de="";oe.length>1&&(de=oe[0]+"@",se=oe[1]),se=se.replace(t,".");var ue=se.split("."),Ee=w(ue,q).join(".");return de+Ee}function W(se){for(var q=[],oe=0,de=se.length;oe<de;){var ue=se.charCodeAt(oe++);if(ue>=55296&&ue<=56319&&oe<de){var Ee=se.charCodeAt(oe++);(Ee&64512)==56320?q.push(((ue&1023)<<10)+(Ee&1023)+65536):(q.push(ue),oe--)}else q.push(ue)}return q}var B=function(q){return q-48<10?q-22:q-65<26?q-65:q-97<26?q-97:C},O=function(q,oe){return q+22+75*(q<26)-((oe!=0)<<5)},x=function(q,oe,de){var ue=0;for(q=de?p(q/n):q>>1,q+=p(q/oe);q>c*h>>1;ue+=C)q=p(q/c);return p(ue+(c+1)*q/(q+l))},u=function(q){var oe=[],de=q.length,ue=0,Ee=i,_e=o,He=q.lastIndexOf(a);He<0&&(He=0);for(var Ge=0;Ge<He;++Ge)q.charCodeAt(Ge)>=128&&b("not-basic"),oe.push(q.charCodeAt(Ge));for(var Oe=He>0?He+1:0;Oe<de;){for(var Me=ue,Ve=1,Ke=C;;Ke+=C){Oe>=de&&b("invalid-input");var Be=B(q.charCodeAt(Oe++));(Be>=C||Be>p((y-ue)/Ve))&&b("overflow"),ue+=Be*Ve;var Ze=Ke<=_e?d:Ke>=_e+h?h:Ke-_e;if(Be<Ze)break;var je=C-Ze;Ve>p(y/je)&&b("overflow"),Ve*=je}var De=oe.length+1;_e=x(ue-Me,De,Me==0),p(ue/De)>y-Ee&&b("overflow"),Ee+=p(ue/De),ue%=De,oe.splice(ue++,0,Ee)}return String.fromCodePoint.apply(String,oe)},_=function(q){var oe=[];q=W(q);var de=q.length,ue=i,Ee=0,_e=o,He=!0,Ge=!1,Oe=void 0;try{for(var Me=q[Symbol.iterator](),Ve;!(He=(Ve=Me.next()).done);He=!0){var Ke=Ve.value;Ke<128&&oe.push(g(Ke))}}catch(st){Ge=!0,Oe=st}finally{try{!He&&Me.return&&Me.return()}finally{if(Ge)throw Oe}}var Be=oe.length,Ze=Be;for(Be&&oe.push(a);Ze<de;){var je=y,De=!0,tt=!1,Ue=void 0;try{for(var Qe=q[Symbol.iterator](),ot;!(De=(ot=Qe.next()).done);De=!0){var nt=ot.value;nt>=ue&&nt<je&&(je=nt)}}catch(st){tt=!0,Ue=st}finally{try{!De&&Qe.return&&Qe.return()}finally{if(tt)throw Ue}}var Je=Ze+1;je-ue>p((y-Ee)/Je)&&b("overflow"),Ee+=(je-ue)*Je,ue=je;var qe=!0,it=!1,et=void 0;try{for(var rt=q[Symbol.iterator](),ut;!(qe=(ut=rt.next()).done);qe=!0){var gt=ut.value;if(gt<ue&&++Ee>y&&b("overflow"),gt==ue){for(var lt=Ee,ct=C;;ct+=C){var ht=ct<=_e?d:ct>=_e+h?h:ct-_e;if(lt<ht)break;var pt=lt-ht,mt=C-ht;oe.push(g(O(ht+pt%mt,0))),lt=p(pt/mt)}oe.push(g(O(lt,0))),_e=x(Ee,Je,Ze==Be),Ee=0,++Ze}}}catch(st){it=!0,et=st}finally{try{!qe&&rt.return&&rt.return()}finally{if(it)throw et}}++Ee,++ue}return oe.join("")},v={version:"2.1.0",ucs2:{decode:W,encode:function(q){return String.fromCodePoint.apply(String,R(q))}},decode:u,encode:_,toASCII:function(q){return E(q,function(oe){return e.test(oe)?"xn--"+_(oe):oe})},toUnicode:function(q){return E(q,function(oe){return r.test(oe)?u(oe.slice(4).toLowerCase()):oe})}},$={};function P(se){var q=se.charCodeAt(0),oe=void 0;return q<16?oe="%0"+q.toString(16).toUpperCase():q<128?oe="%"+q.toString(16).toUpperCase():q<2048?oe="%"+(q>>6|192).toString(16).toUpperCase()+"%"+(q&63|128).toString(16).toUpperCase():oe="%"+(q>>12|224).toString(16).toUpperCase()+"%"+(q>>6&63|128).toString(16).toUpperCase()+"%"+(q&63|128).toString(16).toUpperCase(),oe}function M(se){for(var q="",oe=0,de=se.length;oe<de;){var ue=parseInt(se.substr(oe+1,2),16);if(ue<128)q+=String.fromCharCode(ue),oe+=3;else if(ue>=194&&ue<224){if(de-oe>=6){var Ee=parseInt(se.substr(oe+4,2),16);q+=String.fromCharCode((ue&31)<<6|Ee&63)}else q+=se.substr(oe,6);oe+=6}else if(ue>=224){if(de-oe>=9){var _e=parseInt(se.substr(oe+4,2),16),He=parseInt(se.substr(oe+7,2),16);q+=String.fromCharCode((ue&15)<<12|(_e&63)<<6|He&63)}else q+=se.substr(oe,9);oe+=9}else q+=se.substr(oe,3),oe+=3}return q}function X(se,q){function oe(de){var ue=M(de);return ue.match(q.UNRESERVED)?ue:de}return se.scheme&&(se.scheme=String(se.scheme).replace(q.PCT_ENCODED,oe).toLowerCase().replace(q.NOT_SCHEME,"")),se.userinfo!==void 0&&(se.userinfo=String(se.userinfo).replace(q.PCT_ENCODED,oe).replace(q.NOT_USERINFO,P).replace(q.PCT_ENCODED,j)),se.host!==void 0&&(se.host=String(se.host).replace(q.PCT_ENCODED,oe).toLowerCase().replace(q.NOT_HOST,P).replace(q.PCT_ENCODED,j)),se.path!==void 0&&(se.path=String(se.path).replace(q.PCT_ENCODED,oe).replace(se.scheme?q.NOT_PATH:q.NOT_PATH_NOSCHEME,P).replace(q.PCT_ENCODED,j)),se.query!==void 0&&(se.query=String(se.query).replace(q.PCT_ENCODED,oe).replace(q.NOT_QUERY,P).replace(q.PCT_ENCODED,j)),se.fragment!==void 0&&(se.fragment=String(se.fragment).replace(q.PCT_ENCODED,oe).replace(q.NOT_FRAGMENT,P).replace(q.PCT_ENCODED,j)),se}function Q(se){return se.replace(/^0*(.*)/,"$1")||"0"}function K(se,q){var oe=se.match(q.IPV4ADDRESS)||[],de=f(oe,2),ue=de[1];return ue?ue.split(".").map(Q).join("."):se}function ne(se,q){var oe=se.match(q.IPV6ADDRESS)||[],de=f(oe,3),ue=de[1],Ee=de[2];if(ue){for(var _e=ue.toLowerCase().split("::").reverse(),He=f(_e,2),Ge=He[0],Oe=He[1],Me=Oe?Oe.split(":").map(Q):[],Ve=Ge.split(":").map(Q),Ke=q.IPV4ADDRESS.test(Ve[Ve.length-1]),Be=Ke?7:8,Ze=Ve.length-Be,je=Array(Be),De=0;De<Be;++De)je[De]=Me[De]||Ve[Ze+De]||"";Ke&&(je[Be-1]=K(je[Be-1],q));var tt=je.reduce(function(Je,qe,it){if(!qe||qe==="0"){var et=Je[Je.length-1];et&&et.index+et.length===it?et.length++:Je.push({index:it,length:1})}return Je},[]),Ue=tt.sort(function(Je,qe){return qe.length-Je.length})[0],Qe=void 0;if(Ue&&Ue.length>1){var ot=je.slice(0,Ue.index),nt=je.slice(Ue.index+Ue.length);Qe=ot.join(":")+"::"+nt.join(":")}else Qe=je.join(":");return Ee&&(Qe+="%"+Ee),Qe}else return se}var T=/^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i,F="".match(/(){0}/)[1]===void 0;function V(se){var q=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},oe={},de=q.iri!==!1?A:N;q.reference==="suffix"&&(se=(q.scheme?q.scheme+":":"")+"//"+se);var ue=se.match(T);if(ue){F?(oe.scheme=ue[1],oe.userinfo=ue[3],oe.host=ue[4],oe.port=parseInt(ue[5],10),oe.path=ue[6]||"",oe.query=ue[7],oe.fragment=ue[8],isNaN(oe.port)&&(oe.port=ue[5])):(oe.scheme=ue[1]||void 0,oe.userinfo=se.indexOf("@")!==-1?ue[3]:void 0,oe.host=se.indexOf("//")!==-1?ue[4]:void 0,oe.port=parseInt(ue[5],10),oe.path=ue[6]||"",oe.query=se.indexOf("?")!==-1?ue[7]:void 0,oe.fragment=se.indexOf("#")!==-1?ue[8]:void 0,isNaN(oe.port)&&(oe.port=se.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/)?ue[4]:void 0)),oe.host&&(oe.host=ne(K(oe.host,de),de)),oe.scheme===void 0&&oe.userinfo===void 0&&oe.host===void 0&&oe.port===void 0&&!oe.path&&oe.query===void 0?oe.reference="same-document":oe.scheme===void 0?oe.reference="relative":oe.fragment===void 0?oe.reference="absolute":oe.reference="uri",q.reference&&q.reference!=="suffix"&&q.reference!==oe.reference&&(oe.error=oe.error||"URI is not a "+q.reference+" reference.");var Ee=$[(q.scheme||oe.scheme||"").toLowerCase()];if(!q.unicodeSupport&&(!Ee||!Ee.unicodeSupport)){if(oe.host&&(q.domainHost||Ee&&Ee.domainHost))try{oe.host=v.toASCII(oe.host.replace(de.PCT_ENCODED,M).toLowerCase())}catch(_e){oe.error=oe.error||"Host's domain name can not be converted to ASCII via punycode: "+_e}X(oe,N)}else X(oe,de);Ee&&Ee.parse&&Ee.parse(oe,q)}else oe.error=oe.error||"URI can not be parsed.";return oe}function I(se,q){var oe=q.iri!==!1?A:N,de=[];return se.userinfo!==void 0&&(de.push(se.userinfo),de.push("@")),se.host!==void 0&&de.push(ne(K(String(se.host),oe),oe).replace(oe.IPV6ADDRESS,function(ue,Ee,_e){return"["+Ee+(_e?"%25"+_e:"")+"]"})),(typeof se.port=="number"||typeof se.port=="string")&&(de.push(":"),de.push(String(se.port))),de.length?de.join(""):void 0}var S=/^\.\.?\//,L=/^\/\.(\/|$)/,Z=/^\/\.\.(\/|$)/,J=/^\/?(?:.|\n)*?(?=\/|$)/;function re(se){for(var q=[];se.length;)if(se.match(S))se=se.replace(S,"");else if(se.match(L))se=se.replace(L,"/");else if(se.match(Z))se=se.replace(Z,"/"),q.pop();else if(se==="."||se==="..")se="";else{var oe=se.match(J);if(oe){var de=oe[0];se=se.slice(de.length),q.push(de)}else throw new Error("Unexpected dot segment condition")}return q.join("")}function pe(se){var q=arguments.length>1&&arguments[1]!==void 0?arguments[1]:{},oe=q.iri?A:N,de=[],ue=$[(q.scheme||se.scheme||"").toLowerCase()];if(ue&&ue.serialize&&ue.serialize(se,q),se.host&&!oe.IPV6ADDRESS.test(se.host)){if(q.domainHost||ue&&ue.domainHost)try{se.host=q.iri?v.toUnicode(se.host):v.toASCII(se.host.replace(oe.PCT_ENCODED,M).toLowerCase())}catch(He){se.error=se.error||"Host's domain name can not be converted to "+(q.iri?"Unicode":"ASCII")+" via punycode: "+He}}X(se,oe),q.reference!=="suffix"&&se.scheme&&(de.push(se.scheme),de.push(":"));var Ee=I(se,q);if(Ee!==void 0&&(q.reference!=="suffix"&&de.push("//"),de.push(Ee),se.path&&se.path.charAt(0)!=="/"&&de.push("/")),se.path!==void 0){var _e=se.path;!q.absolutePath&&(!ue||!ue.absolutePath)&&(_e=re(_e)),Ee===void 0&&(_e=_e.replace(/^\/\//,"/%2F")),de.push(_e)}return se.query!==void 0&&(de.push("?"),de.push(se.query)),se.fragment!==void 0&&(de.push("#"),de.push(se.fragment)),de.join("")}function me(se,q){var oe=arguments.length>2&&arguments[2]!==void 0?arguments[2]:{},de=arguments[3],ue={};return de||(se=V(pe(se,oe),oe),q=V(pe(q,oe),oe)),oe=oe||{},!oe.tolerant&&q.scheme?(ue.scheme=q.scheme,ue.userinfo=q.userinfo,ue.host=q.host,ue.port=q.port,ue.path=re(q.path||""),ue.query=q.query):(q.userinfo!==void 0||q.host!==void 0||q.port!==void 0?(ue.userinfo=q.userinfo,ue.host=q.host,ue.port=q.port,ue.path=re(q.path||""),ue.query=q.query):(q.path?(q.path.charAt(0)==="/"?ue.path=re(q.path):((se.userinfo!==void 0||se.host!==void 0||se.port!==void 0)&&!se.path?ue.path="/"+q.path:se.path?ue.path=se.path.slice(0,se.path.lastIndexOf("/")+1)+q.path:ue.path=q.path,ue.path=re(ue.path)),ue.query=q.query):(ue.path=se.path,q.query!==void 0?ue.query=q.query:ue.query=se.query),ue.userinfo=se.userinfo,ue.host=se.host,ue.port=se.port),ue.scheme=se.scheme),ue.fragment=q.fragment,ue}function ye(se,q,oe){var de=Y({scheme:"null"},oe);return pe(me(V(se,de),V(q,de),de,!0),de)}function xe(se,q){return typeof se=="string"?se=pe(V(se,q),q):H(se)==="object"&&(se=V(pe(se,q),q)),se}function be(se,q,oe){return typeof se=="string"?se=pe(V(se,oe),oe):H(se)==="object"&&(se=pe(se,oe)),typeof q=="string"?q=pe(V(q,oe),oe):H(q)==="object"&&(q=pe(q,oe)),se===q}function Ae(se,q){return se&&se.toString().replace(!q||!q.iri?N.ESCAPE:A.ESCAPE,P)}function we(se,q){return se&&se.toString().replace(!q||!q.iri?N.PCT_ENCODED:A.PCT_ENCODED,M)}var Re={scheme:"http",domainHost:!0,parse:function(q,oe){return q.host||(q.error=q.error||"HTTP URIs must have a host."),q},serialize:function(q,oe){var de=String(q.scheme).toLowerCase()==="https";return(q.port===(de?443:80)||q.port==="")&&(q.port=void 0),q.path||(q.path="/"),q}},We={scheme:"https",domainHost:Re.domainHost,parse:Re.parse,serialize:Re.serialize};function Se(se){return typeof se.secure=="boolean"?se.secure:String(se.scheme).toLowerCase()==="wss"}var ve={scheme:"ws",domainHost:!0,parse:function(q,oe){var de=q;return de.secure=Se(de),de.resourceName=(de.path||"/")+(de.query?"?"+de.query:""),de.path=void 0,de.query=void 0,de},serialize:function(q,oe){if((q.port===(Se(q)?443:80)||q.port==="")&&(q.port=void 0),typeof q.secure=="boolean"&&(q.scheme=q.secure?"wss":"ws",q.secure=void 0),q.resourceName){var de=q.resourceName.split("?"),ue=f(de,2),Ee=ue[0],_e=ue[1];q.path=Ee&&Ee!=="/"?Ee:void 0,q.query=_e,q.resourceName=void 0}return q.fragment=void 0,q}},Le={scheme:"wss",domainHost:ve.domainHost,parse:ve.parse,serialize:ve.serialize},Pe={},ge="[A-Za-z0-9\\-\\.\\_\\~\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]",te="[0-9A-Fa-f]",ie=k(k("%[EFef]"+te+"%"+te+te+"%"+te+te)+"|"+k("%[89A-Fa-f]"+te+"%"+te+te)+"|"+k("%"+te+te)),ce="[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]",fe=U("[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]",'[\\"\\\\]'),Ie="[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]",$e=new RegExp(ge,"g"),ee=new RegExp(ie,"g"),ae=new RegExp(U("[^]",ce,"[\\.]",'[\\"]',fe),"g"),he=new RegExp(U("[^]",ge,Ie),"g"),Ce=he;function Te(se){var q=M(se);return q.match($e)?q:se}var ke={scheme:"mailto",parse:function(q,oe){var de=q,ue=de.to=de.path?de.path.split(","):[];if(de.path=void 0,de.query){for(var Ee=!1,_e={},He=de.query.split("&"),Ge=0,Oe=He.length;Ge<Oe;++Ge){var Me=He[Ge].split("=");switch(Me[0]){case"to":for(var Ve=Me[1].split(","),Ke=0,Be=Ve.length;Ke<Be;++Ke)ue.push(Ve[Ke]);break;case"subject":de.subject=we(Me[1],oe);break;case"body":de.body=we(Me[1],oe);break;default:Ee=!0,_e[we(Me[0],oe)]=we(Me[1],oe);break}}Ee&&(de.headers=_e)}de.query=void 0;for(var Ze=0,je=ue.length;Ze<je;++Ze){var De=ue[Ze].split("@");if(De[0]=we(De[0]),oe.unicodeSupport)De[1]=we(De[1],oe).toLowerCase();else try{De[1]=v.toASCII(we(De[1],oe).toLowerCase())}catch(tt){de.error=de.error||"Email address's domain name can not be converted to ASCII via punycode: "+tt}ue[Ze]=De.join("@")}return de},serialize:function(q,oe){var de=q,ue=z(q.to);if(ue){for(var Ee=0,_e=ue.length;Ee<_e;++Ee){var He=String(ue[Ee]),Ge=He.lastIndexOf("@"),Oe=He.slice(0,Ge).replace(ee,Te).replace(ee,j).replace(ae,P),Me=He.slice(Ge+1);try{Me=oe.iri?v.toUnicode(Me):v.toASCII(we(Me,oe).toLowerCase())}catch(Ze){de.error=de.error||"Email address's domain name can not be converted to "+(oe.iri?"Unicode":"ASCII")+" via punycode: "+Ze}ue[Ee]=Oe+"@"+Me}de.path=ue.join(",")}var Ve=q.headers=q.headers||{};q.subject&&(Ve.subject=q.subject),q.body&&(Ve.body=q.body);var Ke=[];for(var Be in Ve)Ve[Be]!==Pe[Be]&&Ke.push(Be.replace(ee,Te).replace(ee,j).replace(he,P)+"="+Ve[Be].replace(ee,Te).replace(ee,j).replace(Ce,P));return Ke.length&&(de.query=Ke.join("&")),de}},Ne=/^([^\:]+)\:(.*)/,Fe={scheme:"urn",parse:function(q,oe){var de=q.path&&q.path.match(Ne),ue=q;if(de){var Ee=oe.scheme||ue.scheme||"urn",_e=de[1].toLowerCase(),He=de[2],Ge=Ee+":"+(oe.nid||_e),Oe=$[Ge];ue.nid=_e,ue.nss=He,ue.path=void 0,Oe&&(ue=Oe.parse(ue,oe))}else ue.error=ue.error||"URN can not be parsed.";return ue},serialize:function(q,oe){var de=oe.scheme||q.scheme||"urn",ue=q.nid,Ee=de+":"+(oe.nid||ue),_e=$[Ee];_e&&(q=_e.serialize(q,oe));var He=q,Ge=q.nss;return He.path=(ue||oe.nid)+":"+Ge,He}},ze=/^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/,Xe={scheme:"urn:uuid",parse:function(q,oe){var de=q;return de.uuid=de.nss,de.nss=void 0,!oe.tolerant&&(!de.uuid||!de.uuid.match(ze))&&(de.error=de.error||"UUID is not valid."),de},serialize:function(q,oe){var de=q;return de.nss=(q.uuid||"").toLowerCase(),de}};$[Re.scheme]=Re,$[We.scheme]=We,$[ve.scheme]=ve,$[Le.scheme]=Le,$[ke.scheme]=ke,$[Fe.scheme]=Fe,$[Xe.scheme]=Xe,D.SCHEMES=$,D.pctEncChar=P,D.pctDecChars=M,D.parse=V,D.removeDotSegments=re,D.serialize=pe,D.resolveComponents=me,D.resolve=ye,D.normalize=xe,D.equal=be,D.escapeComponent=Ae,D.unescapeComponent=we,Object.defineProperty(D,"__esModule",{value:!0})})(m)},4049:function(le){le.exports=function(){var m=function(o,i){if(!(o instanceof i))throw new TypeError("Cannot call a class as a function")},D=function(){function o(i,a){for(var r=0;r<a.length;r++){var e=a[r];e.enumerable=e.enumerable||!1,e.configurable=!0,"value"in e&&(e.writable=!0),Object.defineProperty(i,e.key,e)}}return function(i,a,r){return a&&o(i.prototype,a),r&&o(i,r),i}}(),U=function(){function o(i,a){var r=[],e=!0,t=!1,s=void 0;try{for(var c=i[Symbol.iterator](),p;!(e=(p=c.next()).done)&&(r.push(p.value),!(a&&r.length===a));e=!0);}catch(g){t=!0,s=g}finally{try{!e&&c.return&&c.return()}finally{if(t)throw s}}return r}return function(i,a){if(Array.isArray(i))return i;if(Symbol.iterator in Object(i))return o(i,a);throw new TypeError("Invalid attempt to destructure non-iterable instance")}}(),k=(String.prototype.startsWith=String.prototype.startsWith||function(o){return this.indexOf(o)===0},String.prototype.padStart=String.prototype.padStart||function(o,i){for(var a=this;a.length<o;)a=i+a;return a},{cb:"0f8ff",tqw:"aebd7",q:"-ffff",qmrn:"7fffd4",zr:"0ffff",bg:"5f5dc",bsq:"e4c4",bck:"---",nch:"ebcd",b:"--ff",bvt:"8a2be2",brwn:"a52a2a",brw:"deb887",ctb:"5f9ea0",hrt:"7fff-",chcT:"d2691e",cr:"7f50",rnw:"6495ed",crns:"8dc",crms:"dc143c",cn:"-ffff",Db:"--8b",Dcn:"-8b8b",Dgnr:"b8860b",Dgr:"a9a9a9",Dgrn:"-64-",Dkhk:"bdb76b",Dmgn:"8b-8b",Dvgr:"556b2f",Drng:"8c-",Drch:"9932cc",Dr:"8b--",Dsmn:"e9967a",Dsgr:"8fbc8f",DsTb:"483d8b",DsTg:"2f4f4f",Dtrq:"-ced1",Dvt:"94-d3",ppnk:"1493",pskb:"-bfff",mgr:"696969",grb:"1e90ff",rbrc:"b22222",rwht:"af0",stg:"228b22",chs:"-ff",gnsb:"dcdcdc",st:"8f8ff",g:"d7-",gnr:"daa520",gr:"808080",grn:"-8-0",grnw:"adff2f",hnw:"0fff0",htpn:"69b4",nnr:"cd5c5c",ng:"4b-82",vr:"0",khk:"0e68c",vnr:"e6e6fa",nrb:"0f5",wngr:"7cfc-",mnch:"acd",Lb:"add8e6",Lcr:"08080",Lcn:"e0ffff",Lgnr:"afad2",Lgr:"d3d3d3",Lgrn:"90ee90",Lpnk:"b6c1",Lsmn:"a07a",Lsgr:"20b2aa",Lskb:"87cefa",LsTg:"778899",Lstb:"b0c4de",Lw:"e0",m:"-ff-",mgrn:"32cd32",nn:"af0e6",mgnt:"-ff",mrn:"8--0",mqm:"66cdaa",mmb:"--cd",mmrc:"ba55d3",mmpr:"9370db",msg:"3cb371",mmsT:"7b68ee","":"-fa9a",mtr:"48d1cc",mmvt:"c71585",mnLb:"191970",ntc:"5fffa",mstr:"e4e1",mccs:"e4b5",vjw:"dead",nv:"--80",c:"df5e6",v:"808-0",vrb:"6b8e23",rng:"a5-",rngr:"45-",rch:"da70d6",pgnr:"eee8aa",pgrn:"98fb98",ptrq:"afeeee",pvtr:"db7093",ppwh:"efd5",pchp:"dab9",pr:"cd853f",pnk:"c0cb",pm:"dda0dd",pwrb:"b0e0e6",prp:"8-080",cc:"663399",r:"--",sbr:"bc8f8f",rb:"4169e1",sbrw:"8b4513",smn:"a8072",nbr:"4a460",sgrn:"2e8b57",ssh:"5ee",snn:"a0522d",svr:"c0c0c0",skb:"87ceeb",sTb:"6a5acd",sTgr:"708090",snw:"afa",n:"-ff7f",stb:"4682b4",tn:"d2b48c",t:"-8080",thst:"d8bfd8",tmT:"6347",trqs:"40e0d0",vt:"ee82ee",whT:"5deb3",wht:"",hts:"5f5f5",w:"-",wgrn:"9acd32"});function H(o){var i=arguments.length>1&&arguments[1]!==void 0?arguments[1]:1,a=i>0?o.toFixed(i).replace(/0+$/,"").replace(/\.$/,""):o.toString();return a||"0"}var j=function(){function o(i,a,r,e){m(this,o);var t=this;function s(p){if(p.startsWith("hsl")){var g=p.match(/([\-\d\.e]+)/g).map(Number),b=U(g,4),w=b[0],E=b[1],W=b[2],B=b[3];B===void 0&&(B=1),w/=360,E/=100,W/=100,t.hsla=[w,E,W,B]}else if(p.startsWith("rgb")){var O=p.match(/([\-\d\.e]+)/g).map(Number),x=U(O,4),u=x[0],_=x[1],v=x[2],$=x[3];$===void 0&&($=1),t.rgba=[u,_,v,$]}else p.startsWith("#")?t.rgba=o.hexToRgb(p):t.rgba=o.nameToRgb(p)||o.hexToRgb(p)}if(i!==void 0)if(Array.isArray(i))this.rgba=i;else if(r===void 0){var c=i&&""+i;c&&s(c.toLowerCase())}else this.rgba=[i,a,r,e===void 0?1:e]}return D(o,[{key:"printRGB",value:function(a){var r=a?this.rgba:this.rgba.slice(0,3),e=r.map(function(t,s){return H(t,s===3?3:0)});return a?"rgba("+e+")":"rgb("+e+")"}},{key:"printHSL",value:function(a){var r=[360,100,100,1],e=["","%","%",""],t=a?this.hsla:this.hsla.slice(0,3),s=t.map(function(c,p){return H(c*r[p],p===3?3:1)+e[p]});return a?"hsla("+s+")":"hsl("+s+")"}},{key:"printHex",value:function(a){var r=this.hex;return a?r:r.substring(0,7)}},{key:"rgba",get:function(){if(this._rgba)return this._rgba;if(!this._hsla)throw new Error("No color is set");return this._rgba=o.hslToRgb(this._hsla)},set:function(a){a.length===3&&(a[3]=1),this._rgba=a,this._hsla=null}},{key:"rgbString",get:function(){return this.printRGB()}},{key:"rgbaString",get:function(){return this.printRGB(!0)}},{key:"hsla",get:function(){if(this._hsla)return this._hsla;if(!this._rgba)throw new Error("No color is set");return this._hsla=o.rgbToHsl(this._rgba)},set:function(a){a.length===3&&(a[3]=1),this._hsla=a,this._rgba=null}},{key:"hslString",get:function(){return this.printHSL()}},{key:"hslaString",get:function(){return this.printHSL(!0)}},{key:"hex",get:function(){var a=this.rgba,r=a.map(function(e,t){return t<3?e.toString(16):Math.round(e*255).toString(16)});return"#"+r.map(function(e){return e.padStart(2,"0")}).join("")},set:function(a){this.rgba=o.hexToRgb(a)}}],[{key:"hexToRgb",value:function(a){var r=(a.startsWith("#")?a.slice(1):a).replace(/^(\w{3})$/,"$1F").replace(/^(\w)(\w)(\w)(\w)$/,"$1$1$2$2$3$3$4$4").replace(/^(\w{6})$/,"$1FF");if(!r.match(/^([0-9a-fA-F]{8})$/))throw new Error("Unknown hex color; "+a);var e=r.match(/^(\w\w)(\w\w)(\w\w)(\w\w)$/).slice(1).map(function(t){return parseInt(t,16)});return e[3]=e[3]/255,e}},{key:"nameToRgb",value:function(a){var r=a.toLowerCase().replace("at","T").replace(/[aeiouyldf]/g,"").replace("ght","L").replace("rk","D").slice(-5,4),e=k[r];return e===void 0?e:o.hexToRgb(e.replace(/\-/g,"00").padStart(6,"f"))}},{key:"rgbToHsl",value:function(a){var r=U(a,4),e=r[0],t=r[1],s=r[2],c=r[3];e/=255,t/=255,s/=255;var p=Math.max(e,t,s),g=Math.min(e,t,s),b=void 0,w=void 0,E=(p+g)/2;if(p===g)b=w=0;else{var W=p-g;switch(w=E>.5?W/(2-p-g):W/(p+g),p){case e:b=(t-s)/W+(t<s?6:0);break;case t:b=(s-e)/W+2;break;case s:b=(e-t)/W+4;break}b/=6}return[b,w,E,c]}},{key:"hslToRgb",value:function(a){var r=U(a,4),e=r[0],t=r[1],s=r[2],c=r[3],p=void 0,g=void 0,b=void 0;if(t===0)p=g=b=s;else{var w=function(x,u,_){return _<0&&(_+=1),_>1&&(_-=1),_<.16666666666666666?x+(u-x)*6*_:_<.5?u:_<.6666666666666666?x+(u-x)*(.6666666666666666-_)*6:x},E=s<.5?s*(1+t):s+t-s*t,W=2*s-E;p=w(W,E,e+1/3),g=w(W,E,e),b=w(W,E,e-1/3)}var B=[p*255,g*255,b*255].map(Math.round);return B[3]=c,B}}]),o}(),z=function(){function o(){m(this,o),this._events=[]}return D(o,[{key:"add",value:function(a,r,e){a.addEventListener(r,e,!1),this._events.push({target:a,type:r,handler:e})}},{key:"remove",value:function(a,r,e){this._events=this._events.filter(function(t){var s=!0;return a&&a!==t.target&&(s=!1),r&&r!==t.type&&(s=!1),e&&e!==t.handler&&(s=!1),s&&o._doRemove(t.target,t.type,t.handler),!s})}},{key:"destroy",value:function(){this._events.forEach(function(a){return o._doRemove(a.target,a.type,a.handler)}),this._events=[]}}],[{key:"_doRemove",value:function(a,r,e){a.removeEventListener(r,e,!1)}}]),o}();function Y(o){var i=document.createElement("div");return i.innerHTML=o,i.firstElementChild}function G(o,i,a){var r=!1;function e(p,g,b){return Math.max(g,Math.min(p,b))}function t(p,g,b){if(b&&(r=!0),!!r){p.preventDefault();var w=i.getBoundingClientRect(),E=w.width,W=w.height,B=g.clientX,O=g.clientY,x=e(B-w.left,0,E),u=e(O-w.top,0,W);a(x/E,u/W)}}function s(p,g){var b=p.buttons===void 0?p.which:p.buttons;b===1?t(p,p,g):r=!1}function c(p,g){p.touches.length===1?t(p,p.touches[0],g):r=!1}o.add(i,"mousedown",function(p){s(p,!0)}),o.add(i,"touchstart",function(p){c(p,!0)}),o.add(window,"mousemove",s),o.add(i,"touchmove",c),o.add(window,"mouseup",function(p){r=!1}),o.add(i,"touchend",function(p){r=!1}),o.add(i,"touchcancel",function(p){r=!1})}var N=`linear-gradient(45deg, lightgrey 25%, transparent 25%, transparent 75%, lightgrey 75%) 0 0 / 2em 2em,
                   linear-gradient(45deg, lightgrey 25%,       white 25%,       white 75%, lightgrey 75%) 1em 1em / 2em 2em`,A=360,f="keydown",R="mousedown",y="focusin";function C(o,i){return(i||document).querySelector(o)}function d(o){o.preventDefault(),o.stopPropagation()}function h(o,i,a,r,e){o.add(i,f,function(t){a.indexOf(t.key)>=0&&(e&&d(t),r(t))})}var l=function(){function o(i){m(this,o),this.settings={popup:"right",layout:"default",alpha:!0,editor:!0,editorFormat:"hex",cancelButton:!1,defaultColor:"#0cf"},this._events=new z,this.onChange=null,this.onDone=null,this.onOpen=null,this.onClose=null,this.setOptions(i)}return D(o,[{key:"setOptions",value:function(a){var r=this;if(!a)return;var e=this.settings;function t(g,b,w){for(var E in g)w&&w.indexOf(E)>=0||(b[E]=g[E])}if(a instanceof HTMLElement)e.parent=a;else{e.parent&&a.parent&&e.parent!==a.parent&&(this._events.remove(e.parent),this._popupInited=!1),t(a,e),a.onChange&&(this.onChange=a.onChange),a.onDone&&(this.onDone=a.onDone),a.onOpen&&(this.onOpen=a.onOpen),a.onClose&&(this.onClose=a.onClose);var s=a.color||a.colour;s&&this._setColor(s)}var c=e.parent;if(c&&e.popup&&!this._popupInited){var p=function(b){return r.openHandler(b)};this._events.add(c,"click",p),h(this._events,c,[" ","Spacebar","Enter"],p),this._popupInited=!0}else a.parent&&!e.popup&&this.show()}},{key:"openHandler",value:function(a){if(this.show()){a&&a.preventDefault(),this.settings.parent.style.pointerEvents="none";var r=a&&a.type===f?this._domEdit:this.domElement;setTimeout(function(){return r.focus()},100),this.onOpen&&this.onOpen(this.colour)}}},{key:"closeHandler",value:function(a){var r=a&&a.type,e=!1;if(!a)e=!0;else if(r===R||r===y){var t=(this.__containedEvent||0)+100;a.timeStamp>t&&(e=!0)}else d(a),e=!0;e&&this.hide()&&(this.settings.parent.style.pointerEvents="",r!==R&&this.settings.parent.focus(),this.onClose&&this.onClose(this.colour))}},{key:"movePopup",value:function(a,r){this.closeHandler(),this.setOptions(a),r&&this.openHandler()}},{key:"setColor",value:function(a,r){this._setColor(a,{silent:r})}},{key:"_setColor",value:function(a,r){if(typeof a=="string"&&(a=a.trim()),!!a){r=r||{};var e=void 0;try{e=new j(a)}catch(s){if(r.failSilently)return;throw s}if(!this.settings.alpha){var t=e.hsla;t[3]=1,e.hsla=t}this.colour=this.color=e,this._setHSLA(null,null,null,null,r)}}},{key:"setColour",value:function(a,r){this.setColor(a,r)}},{key:"show",value:function(){var a=this.settings.parent;if(!a)return!1;if(this.domElement){var r=this._toggleDOM(!0);return this._setPosition(),r}var e=this.settings.template||'<div class="picker_wrapper" tabindex="-1"><div class="picker_arrow"></div><div class="picker_hue picker_slider"><div class="picker_selector"></div></div><div class="picker_sl"><div class="picker_selector"></div></div><div class="picker_alpha picker_slider"><div class="picker_selector"></div></div><div class="picker_editor"><input aria-label="Type a color name or hex value"/></div><div class="picker_sample"></div><div class="picker_done"><button>Ok</button></div><div class="picker_cancel"><button>Cancel</button></div></div>',t=Y(e);return this.domElement=t,this._domH=C(".picker_hue",t),this._domSL=C(".picker_sl",t),this._domA=C(".picker_alpha",t),this._domEdit=C(".picker_editor input",t),this._domSample=C(".picker_sample",t),this._domOkay=C(".picker_done button",t),this._domCancel=C(".picker_cancel button",t),t.classList.add("layout_"+this.settings.layout),this.settings.alpha||t.classList.add("no_alpha"),this.settings.editor||t.classList.add("no_editor"),this.settings.cancelButton||t.classList.add("no_cancel"),this._ifPopup(function(){return t.classList.add("popup")}),this._setPosition(),this.colour?this._updateUI():this._setColor(this.settings.defaultColor),this._bindEvents(),!0}},{key:"hide",value:function(){return this._toggleDOM(!1)}},{key:"destroy",value:function(){this._events.destroy(),this.domElement&&this.settings.parent.removeChild(this.domElement)}},{key:"_bindEvents",value:function(){var a=this,r=this,e=this.domElement,t=this._events;function s(g,b,w){t.add(g,b,w)}s(e,"click",function(g){return g.preventDefault()}),G(t,this._domH,function(g,b){return r._setHSLA(g)}),G(t,this._domSL,function(g,b){return r._setHSLA(null,g,1-b)}),this.settings.alpha&&G(t,this._domA,function(g,b){return r._setHSLA(null,null,null,1-b)});var c=this._domEdit;s(c,"input",function(g){r._setColor(this.value,{fromEditor:!0,failSilently:!0})}),s(c,"focus",function(g){var b=this;b.selectionStart===b.selectionEnd&&b.select()}),this._ifPopup(function(){var g=function(E){return a.closeHandler(E)};s(window,R,g),s(window,y,g),h(t,e,["Esc","Escape"],g);var b=function(E){a.__containedEvent=E.timeStamp};s(e,R,b),s(e,y,b),s(a._domCancel,"click",g)});var p=function(b){a._ifPopup(function(){return a.closeHandler(b)}),a.onDone&&a.onDone(a.colour)};s(this._domOkay,"click",p),h(t,e,["Enter"],p)}},{key:"_setPosition",value:function(){var a=this.settings.parent,r=this.domElement;a!==r.parentNode&&a.appendChild(r),this._ifPopup(function(e){getComputedStyle(a).position==="static"&&(a.style.position="relative");var t=e===!0?"popup_right":"popup_"+e;["popup_top","popup_bottom","popup_left","popup_right"].forEach(function(s){s===t?r.classList.add(s):r.classList.remove(s)}),r.classList.add(t)})}},{key:"_setHSLA",value:function(a,r,e,t,s){s=s||{};var c=this.colour,p=c.hsla;[a,r,e,t].forEach(function(g,b){(g||g===0)&&(p[b]=g)}),c.hsla=p,this._updateUI(s),this.onChange&&!s.silent&&this.onChange(c)}},{key:"_updateUI",value:function(a){if(!this.domElement)return;a=a||{};var r=this.colour,e=r.hsla,t="hsl("+e[0]*A+", 100%, 50%)",s=r.hslString,c=r.hslaString,p=this._domH,g=this._domSL,b=this._domA,w=C(".picker_selector",p),E=C(".picker_selector",g),W=C(".picker_selector",b);function B(M,X,Q){X.style.left=Q*100+"%"}function O(M,X,Q){X.style.top=Q*100+"%"}B(p,w,e[0]),this._domSL.style.backgroundColor=this._domH.style.color=t,B(g,E,e[1]),O(g,E,1-e[2]),g.style.color=s,O(b,W,1-e[3]);var x=s,u=x.replace("hsl","hsla").replace(")",", 0)"),_="linear-gradient("+[x,u]+")";if(this._domA.style.background=_+", "+N,!a.fromEditor){var v=this.settings.editorFormat,$=this.settings.alpha,P=void 0;switch(v){case"rgb":P=r.printRGB($);break;case"hsl":P=r.printHSL($);break;default:P=r.printHex($)}this._domEdit.value=P}this._domSample.style.color=c}},{key:"_ifPopup",value:function(a,r){this.settings.parent&&this.settings.popup?a&&a(this.settings.popup):r&&r()}},{key:"_toggleDOM",value:function(a){var r=this.domElement;if(!r)return!1;var e=a?"":"none",t=r.style.display!==e;return t&&(r.style.display=e),t}}]),o}(),n=document.createElement("style");return n.textContent='.picker_wrapper.no_alpha .picker_alpha{display:none}.picker_wrapper.no_editor .picker_editor{position:absolute;z-index:-1;opacity:0}.picker_wrapper.no_cancel .picker_cancel{display:none}.layout_default.picker_wrapper{display:flex;flex-flow:row wrap;justify-content:space-between;align-items:stretch;font-size:10px;width:25em;padding:.5em}.layout_default.picker_wrapper input,.layout_default.picker_wrapper button{font-size:1rem}.layout_default.picker_wrapper>*{margin:.5em}.layout_default.picker_wrapper::before{content:"";display:block;width:100%;height:0;order:1}.layout_default .picker_slider,.layout_default .picker_selector{padding:1em}.layout_default .picker_hue{width:100%}.layout_default .picker_sl{flex:1 1 auto}.layout_default .picker_sl::before{content:"";display:block;padding-bottom:100%}.layout_default .picker_editor{order:1;width:6.5rem}.layout_default .picker_editor input{width:100%;height:100%}.layout_default .picker_sample{order:1;flex:1 1 auto}.layout_default .picker_done,.layout_default .picker_cancel{order:1}.picker_wrapper{box-sizing:border-box;background:#f2f2f2;box-shadow:0 0 0 1px silver;cursor:default;font-family:sans-serif;color:#444;pointer-events:auto}.picker_wrapper:focus{outline:none}.picker_wrapper button,.picker_wrapper input{box-sizing:border-box;border:none;box-shadow:0 0 0 1px silver;outline:none}.picker_wrapper button:focus,.picker_wrapper button:active,.picker_wrapper input:focus,.picker_wrapper input:active{box-shadow:0 0 2px 1px #1e90ff}.picker_wrapper button{padding:.4em .6em;cursor:pointer;background-color:#f5f5f5;background-image:linear-gradient(0deg, gainsboro, transparent)}.picker_wrapper button:active{background-image:linear-gradient(0deg, transparent, gainsboro)}.picker_wrapper button:hover{background-color:#fff}.picker_selector{position:absolute;z-index:1;display:block;-webkit-transform:translate(-50%, -50%);transform:translate(-50%, -50%);border:2px solid #fff;border-radius:100%;box-shadow:0 0 3px 1px #67b9ff;background:currentColor;cursor:pointer}.picker_slider .picker_selector{border-radius:2px}.picker_hue{position:relative;background-image:linear-gradient(90deg, red, yellow, lime, cyan, blue, magenta, red);box-shadow:0 0 0 1px silver}.picker_sl{position:relative;box-shadow:0 0 0 1px silver;background-image:linear-gradient(180deg, white, rgba(255, 255, 255, 0) 50%),linear-gradient(0deg, black, rgba(0, 0, 0, 0) 50%),linear-gradient(90deg, #808080, rgba(128, 128, 128, 0))}.picker_alpha,.picker_sample{position:relative;background:linear-gradient(45deg, lightgrey 25%, transparent 25%, transparent 75%, lightgrey 75%) 0 0/2em 2em,linear-gradient(45deg, lightgrey 25%, white 25%, white 75%, lightgrey 75%) 1em 1em/2em 2em;box-shadow:0 0 0 1px silver}.picker_alpha .picker_selector,.picker_sample .picker_selector{background:none}.picker_editor input{font-family:monospace;padding:.2em .4em}.picker_sample::before{content:"";position:absolute;display:block;width:100%;height:100%;background:currentColor}.picker_arrow{position:absolute;z-index:-1}.picker_wrapper.popup{position:absolute;z-index:2;margin:1.5em}.picker_wrapper.popup,.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{background:#f2f2f2;box-shadow:0 0 10px 1px rgba(0,0,0,.4)}.picker_wrapper.popup .picker_arrow{width:3em;height:3em;margin:0}.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{content:"";display:block;position:absolute;top:0;left:0;z-index:-99}.picker_wrapper.popup .picker_arrow::before{width:100%;height:100%;-webkit-transform:skew(45deg);transform:skew(45deg);-webkit-transform-origin:0 100%;transform-origin:0 100%}.picker_wrapper.popup .picker_arrow::after{width:150%;height:150%;box-shadow:none}.popup.popup_top{bottom:100%;left:0}.popup.popup_top .picker_arrow{bottom:0;left:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.popup.popup_bottom{top:100%;left:0}.popup.popup_bottom .picker_arrow{top:0;left:0;-webkit-transform:rotate(90deg) scale(1, -1);transform:rotate(90deg) scale(1, -1)}.popup.popup_left{top:0;right:100%}.popup.popup_left .picker_arrow{top:0;right:0;-webkit-transform:scale(-1, 1);transform:scale(-1, 1)}.popup.popup_right{top:0;left:100%}.popup.popup_right .picker_arrow{top:0;left:0}',document.documentElement.firstElementChild.appe